/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor.normalization.bounds;

import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.opensearch.neuralsearch.processor.normalization.bounds.BoundMode;

public abstract class ScoreBound {
    public static final float MIN_BOUND_SCORE = -10000.0f;
    public static final float MAX_BOUND_SCORE = 10000.0f;
    protected static final String PARAM_NAME_BOUND_MODE = "mode";
    protected final boolean enabled;
    protected final BoundMode mode;
    protected final float boundScore;

    protected ScoreBound(boolean enabled, BoundMode mode, float boundScore) {
        this.enabled = enabled;
        this.mode = mode;
        this.boundScore = boundScore;
    }

    public abstract float determineEffectiveScore(float var1, float var2, float var3);

    public abstract boolean shouldClipToBound(float var1, float var2);

    protected static BoundMode parseBoundMode(Map<String, Object> bound) {
        return BoundMode.fromString(Objects.toString(bound.get(PARAM_NAME_BOUND_MODE), ""));
    }

    protected static float parseBoundScore(Map<String, Object> bound, String scoreParamName, float defaultScore) {
        String scoreStr = Objects.toString(bound.get(scoreParamName), "");
        return scoreStr.isEmpty() ? defaultScore : Float.parseFloat(scoreStr);
    }

    @Generated
    public BoundMode getMode() {
        return this.mode;
    }

    @Generated
    public float getBoundScore() {
        return this.boundScore;
    }
}

