---
stage: Developer Experience
group: API
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: GraphQL APIのリソース
---

<!--
  This documentation is auto generated by a script.
  Please do not edit this file directly.

  To edit the introductory text, modify `tooling/graphql/docs/templates/default.md.haml`.

  Run `bundle exec rake gitlab:graphql:compile_docs`
  or check the `compile_docs` task in `lib/tasks/gitlab/graphql.rake`.
-->

このドキュメントは、GitLabの現在のGraphQLスキーマに基づいて自動生成されたものです。

APIについて調べるには、[インタラクティブGraphQLエクスプローラー](../_index.md#interactive-graphql-explorer)を使用することができます。デベロッパーは、マシン読み取り可能GraphQLスキーマをIDL形式とJSON形式で生成することもできます。

以下の各表は、それぞれ1つのGraphQL型について記述しています。型は大まかに言ってモデルに対応していますが、モデルのすべてのフィールドとメソッドがGraphQL経由で利用できるわけではありません。

{{< alert type="warning" >}}

非推奨のフィールドには、{{< icon name="warning-solid" >}}が付いています。当社の[廃止プロセス](../_index.md#deprecation-and-removal-process)に従って削除された項目は、[削除された項目](../removed_items.md)に記載されています。

{{< /alert >}}

<!-- vale off -->
<!-- Vale linting disabled after this line. -->
<!-- See https://docs.gitlab.com/ee/development/documentation/testing/vale.html#disable-vale-tests -->

<!-- markdownlint-disable MD044 -->
<!-- MD044/proper-names test disabled after this line to make page compatible with markdownlint-cli 0.29.0. -->
<!-- See https://docs.gitlab.com/ee/development/documentation/testing/markdownlint.html#disable-markdownlint-tests -->

## `Query`type {#query-type}

`Query`型には、すべての実行可能クエリに対するAPIのトップレベルのエントリポイントが含まれています。

### `Query.abuseReport` {#queryabusereport}

{{< details >}}GitLab 16.3で**導入**されました。**状態**: 実験的機能。{{< /details >}}

不正行為レポートを検索します。

[`AbuseReport`](#abusereport)を返します。

#### 引数 {#arguments}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryabusereportid"></a>`id` | [`AbuseReportID!`](#abusereportid) | 不正行為レポートのID。 |

### `Query.abuseReportLabels` {#queryabusereportlabels}

{{< details >}}GitLab 16.3で**導入**されました。**状態**: 実験的機能。{{< /details >}}

不正行為レポートのラベル。

[`AbuseReportLabelConnection`](#abusereportlabelconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

#### 引数 {#arguments-1}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryabusereportlabelssearchterm"></a>`searchTerm` | [`String`](#string) | ラベルを検索するための検索語句。 |

### `Query.addOnPurchases` {#queryaddonpurchases}

アクティブなアドオン購入をすべて取得します。このクエリは、GitLab.com環境およびSelf-Managed環境で使用できます。

[`[AddOnPurchase!]`](#addonpurchase)を返します。

#### 引数 {#arguments-2}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryaddonpurchasesnamespaceid"></a>`namespaceId` | [`NamespaceID`](#namespaceid) | アドオン購入の対象となるネームスペースのID。 |

### `Query.adminGroups` {#queryadmingroups}

{{< details >}}GitLab 18.4で**導入**されました。**状態**: 実験的機能。{{< /details >}}

現在の管理者に表示されるグループを検索します。

[`GroupInterfaceConnection`](#groupinterfaceconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

#### 引数 {#arguments-3}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryadmingroupsactive"></a>`active` | [`Boolean`](#boolean) | `nil`（デフォルト値）の場合、すべてのグループを返します。`true`の場合、削除保留中でないグループのみを返します。`false`の場合、削除保留中のグループのみを返します。 |
| <a id="queryadmingroupsallavailable"></a>`allAvailable` | [`Boolean`](#boolean) | `true`の場合、アクセス可能なすべてのグループを返します。`false`の場合、ユーザーがメンバーであるグループのみを返します。非認証のリクエストでは、常にすべての公開グループが返されます。`owned_only`引数が優先されます。 |
| <a id="queryadmingroupsids"></a>`ids` | [`[ID!]`](#id) | グループをIDでフィルタリングします。 |
| <a id="queryadmingroupsmarkedfordeletionon"></a>`markedForDeletionOn` | [`Date`](#date) | グループが削除対象としてマークされた日付。 |
| <a id="queryadmingroupsownedonly"></a>`ownedOnly` | [`Boolean`](#boolean) | 現在のユーザーがオーナーロールを付与されているグループのみを含めます。 |
| <a id="queryadmingroupsparentpath"></a>`parentPath` | [`ID`](#id) | 親グループのフルパス。 |
| <a id="queryadmingroupssearch"></a>`search` | [`String`](#string) | グループ名またはグループのフルパスの検索クエリ。 |
| <a id="queryadmingroupssort"></a>`sort` | [`String`](#string) | 結果のソート順。形式: `<field_name>_<sort_direction>`（`id_desc`や`name_asc`など）。 |
| <a id="queryadmingroupstoplevelonly"></a>`topLevelOnly` | [`Boolean`](#boolean) | トップレベルグループのみを含めます。 |

### `Query.adminMemberRole` {#queryadminmemberrole}

{{< details >}}GitLab 17.10で**導入**されました。**状態**: 実験的機能。{{< /details >}}

インスタンスの単一の管理者カスタムロールを検索します。GitLab Self-Managedでのみ利用可能。

[`AdminMemberRole`](#adminmemberrole)を返します。

#### 引数 {#arguments-4}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryadminmemberroleid"></a>`id` | [`MemberRoleID`](#memberroleid) | 検索するメンバーロールのグローバルID。 |
| <a id="queryadminmemberroleids"></a>`ids` | [`[MemberRoleID!]`](#memberroleid) | 検索する複数個のメンバーロールのグローバルID。 |
| <a id="queryadminmemberroleorderby"></a>`orderBy` | [`MemberRolesOrderBy`](#memberrolesorderby) | 列の並べ替え。デフォルトはNAMEです。 |
| <a id="queryadminmemberrolesort"></a>`sort` | [`SortDirectionEnum`](#sortdirectionenum) | 列の並べ替え。デフォルトはASCです。 |

### `Query.adminMemberRolePermissions` {#queryadminmemberrolepermissions}

{{< details >}}GitLab 17.9で**導入**されました。**状態**: 実験的機能。{{< /details >}}

カスタマイズ可能な管理者権限すべてのリスト。

[`CustomizableAdminPermissionConnection`](#customizableadminpermissionconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

### `Query.adminMemberRoles` {#queryadminmemberroles}

{{< details >}}GitLab 17.10で**導入**されました。**状態**: 実験的機能。{{< /details >}}

インスタンスで使用可能な管理者カスタムロール。GitLab Self-Managedでのみ利用可能。

[`AdminMemberRoleConnection`](#adminmemberroleconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

#### 引数 {#arguments-5}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryadminmemberrolesid"></a>`id` | [`MemberRoleID`](#memberroleid) | 検索するメンバーロールのグローバルID。 |
| <a id="queryadminmemberrolesids"></a>`ids` | [`[MemberRoleID!]`](#memberroleid) | 検索する複数個のメンバーロールのグローバルID。 |
| <a id="queryadminmemberrolesorderby"></a>`orderBy` | [`MemberRolesOrderBy`](#memberrolesorderby) | 列の並べ替え。デフォルトはNAMEです。 |
| <a id="queryadminmemberrolessort"></a>`sort` | [`SortDirectionEnum`](#sortdirectionenum) | 列の並べ替え。デフォルトはASCです。 |

### `Query.adminProjects` {#queryadminprojects}

{{< details >}}GitLab 18.4で**導入**されました。**状態**: 実験的機能。{{< /details >}}

現在の管理者に表示可能なプロジェクトを検索します。

[`ProjectInterfaceConnection`](#projectinterfaceconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

#### 引数 {#arguments-6}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryadminprojectsactive"></a>`active` | [`Boolean`](#boolean) | アーカイブされておらず、削除対象としてマークされていないプロジェクトでフィルタリングします。 |
| <a id="queryadminprojectsaimedfordeletion"></a>`aimedForDeletion` | [`Boolean`](#boolean) | 削除対象としてマークされているプロジェクトのみを返します。 |
| <a id="queryadminprojectsarchived"></a>`archived` | [`ProjectArchived`](#projectarchived) | アーカイブされたステータスによりプロジェクトをフィルタリングします。 |
| <a id="queryadminprojectsfullpaths"></a>`fullPaths` | [`[String!]`](#string) | プロジェクトをフルパスでフィルタリングします。50を超えるフルパスを指定することはできません。 |
| <a id="queryadminprojectsids"></a>`ids` | [`[ID!]`](#id) | プロジェクトをIDでフィルタリングします。 |
| <a id="queryadminprojectsincludehidden"></a>`includeHidden` | [`Boolean`](#boolean) | 非表示のプロジェクトを含めます。 |
| <a id="queryadminprojectslastrepositorycheckfailed"></a>`lastRepositoryCheckFailed` | [`Boolean`](#boolean) | 最後のリポジトリチェックに失敗したプロジェクトのみを返します。管理者のみが利用できます。 |
| <a id="queryadminprojectsmarkedfordeletionon"></a>`markedForDeletionOn` | [`Date`](#date) | プロジェクトが削除対象としてマークされた日付。 |
| <a id="queryadminprojectsmembership"></a>`membership` | [`Boolean`](#boolean) | 現在のユーザーがメンバーであるプロジェクトのみを返します。 |
| <a id="queryadminprojectsminaccesslevel"></a>`minAccessLevel` | [`AccessLevelEnum`](#accesslevelenum) | 現在のユーザーに付与されているアクセスレベルが指定されたアクセスレベル以上であるプロジェクトのみを返します。 |
| <a id="queryadminprojectsnamespacepath"></a>`namespacePath` | [`ID`](#id) | プロジェクトをネームスペースのフルパス（グループまたはユーザー）でフィルタリングします。 |
| <a id="queryadminprojectsnotaimedfordeletion"></a>`notAimedForDeletion` | [`Boolean`](#boolean) | 削除対象としてマークされているプロジェクトを除外します。 |
| <a id="queryadminprojectspersonal"></a>`personal` | [`Boolean`](#boolean) | 個人用プロジェクトのみを返します。 |
| <a id="queryadminprojectsprogramminglanguagename"></a>`programmingLanguageName` | [`String`](#string) | プロジェクトをプログラミング言語名でフィルタリングします（大文字と小文字は区別されません）。「css」や「ruby」など。 |
| <a id="queryadminprojectssearch"></a>`search` | [`String`](#string) | プロジェクト名、パス、または説明の検索クエリ。 |
| <a id="queryadminprojectssearchnamespaces"></a>`searchNamespaces` | [`Boolean`](#boolean) | プロジェクト検索にネームスペースを含めます。 |
| <a id="queryadminprojectssort"></a>`sort` | [`String`](#string) | 結果のソート順。形式: `<field_name>_<sort_direction>`（`id_desc`や`name_asc`など）。デフォルトでは`id_desc`、検索を使用する場合は`similarity`になります。 |
| <a id="queryadminprojectstopics"></a>`topics` | [`[String!]`](#string) | プロジェクトをトピックでフィルタリングします。 |
| <a id="queryadminprojectstrending"></a>`trending` | [`Boolean`](#boolean) | トレンド中のプロジェクトのみを返します。 |
| <a id="queryadminprojectsvisibilitylevel"></a>`visibilityLevel` | [`VisibilityLevelsEnum`](#visibilitylevelsenum) | 表示レベルでプロジェクトをフィルタリングします。 |
| <a id="queryadminprojectswithcodeembeddingsindexed"></a>`withCodeEmbeddingsIndexed` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | GitLab 18.2で**導入**されました。**状態**: 実験的機能。インデックス付きコード埋め込みを含むプロジェクトを含めます。`ids`を送信する必要があります。機能フラグ`allow_with_code_embeddings_indexed_projects_filter`が有効になっている場合にのみ適用されます。 |
| <a id="queryadminprojectswithissuesenabled"></a>`withIssuesEnabled` | [`Boolean`](#boolean) | イシューが有効になっているプロジェクトのみを返します。 |
| <a id="queryadminprojectswithmergerequestsenabled"></a>`withMergeRequestsEnabled` | [`Boolean`](#boolean) | マージリクエストが有効になっているプロジェクトのみを返します。 |

### `Query.aiCatalogAgentFlowConfig` {#queryaicatalogagentflowconfig}

{{< details >}}GitLab 18.4で**導入**されました。**状態**: 実験的機能。{{< /details >}}

AIカタログエージェントのフロー設定を取得します。

[`String`](#string)を返します。

#### 引数 {#arguments-7}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryaicatalogagentflowconfigagentversionid"></a>`agentVersionId` | [`AiCatalogItemVersionID!`](#aicatalogitemversionid) | 使用するエージェントバージョンのグローバルID。 |
| <a id="queryaicatalogagentflowconfigflowconfigtype"></a>`flowConfigType` | [`AiCatalogFlowConfigType!`](#aicatalogflowconfigtype) | 生成するフロー設定の型。 |

### `Query.aiCatalogBuiltInTools` {#queryaicatalogbuiltintools}

{{< details >}}GitLab 18.3で**導入**されました。**状態**: 実験的機能。{{< /details >}}

AIカタログの組み込みツールのリスト。

[`AiCatalogBuiltInToolConnection!`](#aicatalogbuiltintoolconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

### `Query.aiCatalogConfiguredItems` {#queryaicatalogconfigureditems}

{{< details >}}GitLab 18.2で**導入**されました。**状態**: 実験的機能。{{< /details >}}

使用できるよう設定されたAIカタログ項目。

[`AiCatalogItemConsumerConnection!`](#aicatalogitemconsumerconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

#### 引数 {#arguments-8}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryaicatalogconfigureditemsgroupid"></a>`groupId` | [`GroupID`](#groupid) | 設定されたAIカタログ項目を取得するためのグループID。 |
| <a id="queryaicatalogconfigureditemsincludeinherited"></a>`includeInherited` | [`Boolean`](#boolean) | 親グループから継承された、設定済みのAIカタログ項目を含めます。 |
| <a id="queryaicatalogconfigureditemsitemid"></a>`itemId` | [`AiCatalogItemID`](#aicatalogitemid) | 設定されたAIカタログ項目を取得するための項目ID。 |
| <a id="queryaicatalogconfigureditemsitemtype"></a>`itemType` | [`AiCatalogItemType`](#aicatalogitemtype) | 取得する項目の型。 |
| <a id="queryaicatalogconfigureditemsprojectid"></a>`projectId` | [`ProjectID`](#projectid) | 設定されたAIカタログ項目を取得するプロジェクトID。 |

### `Query.aiCatalogItem` {#queryaicatalogitem}

{{< details >}}GitLab 18.2で**導入**されました。**状態**: 実験的機能。{{< /details >}}

AIカタログ項目を検索します。

[`AiCatalogItem`](#aicatalogitem)を返します。

#### 引数 {#arguments-9}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryaicatalogitemid"></a>`id` | [`AiCatalogItemID!`](#aicatalogitemid) | 検索するカタログ項目のグローバルID。 |

### `Query.aiCatalogItemConsumer` {#queryaicatalogitemconsumer}

{{< details >}}GitLab 18.5で**導入**されました。**状態**: 実験的機能。{{< /details >}}

IDで単一のAIカタログ項目コンシューマーを検索します。

[`AiCatalogItemConsumer`](#aicatalogitemconsumer)を返します。

#### 引数 {#arguments-10}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryaicatalogitemconsumerid"></a>`id` | [`AiCatalogItemConsumerID!`](#aicatalogitemconsumerid) | AIカタログ項目コンシューマーのグローバルID。 |

### `Query.aiCatalogItems` {#queryaicatalogitems}

{{< details >}}GitLab 18.2で**導入**されました。**状態**: 実験的機能。{{< /details >}}

AIカタログ項目のリスト。

[`AiCatalogItemConnection!`](#aicatalogitemconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

#### 引数 {#arguments-11}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryaicatalogitemsitemtype"></a>`itemType` | [`AiCatalogItemType`](#aicatalogitemtype) | 取得する項目の型。 |
| <a id="queryaicatalogitemssearch"></a>`search` | [`String`](#string) | 名前と説明で項目を検索します。 |

### `Query.aiChatAvailableModels` {#queryaichatavailablemodels}

{{< details >}}GitLab 18.4で**導入**されました。**状態**: 実験的機能。{{< /details >}}

Duo Agentic Chatで利用可能なモデルを取得します。

[`AvailableModels`](#availablemodels)を返します。

#### 引数 {#arguments-12}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryaichatavailablemodelsrootnamespaceid"></a>`rootNamespaceId` | [`GroupID!`](#groupid) | ユーザー操作の対象となるネームスペースのグローバルID。 |

### `Query.aiChatContextPresets` {#queryaichatcontextpresets}

特定のURLに対する現在のユーザーが利用できるGitLab Duo Chatコンテキストのプリセットを取得します。

[`ContextPreset`](#contextpreset)を返します。

#### 引数 {#arguments-13}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryaichatcontextpresetsprojectid"></a>`projectId` | [`ProjectID`](#projectid) | ユーザー操作の対象となるプロジェクトのグローバルID。 |
| <a id="queryaichatcontextpresetsquestioncount"></a>`questionCount` | [`Int`](#int) | デフォルト画面の質問数。 |
| <a id="queryaichatcontextpresetsresourceid"></a>`resourceId` | [`AiModelID`](#aimodelid) | 現在のページのリソースのグローバルID。 |
| <a id="queryaichatcontextpresetsurl"></a>`url` | [`String`](#string) | ユーザーが現在アクセスしているページのURL。 |

### `Query.aiConversationThreads` {#queryaiconversationthreads}

{{< details >}}GitLab 17.9で**導入**されました。**状態**: 実験的機能。{{< /details >}}

AI機能の会話スレッドのリスト。

[`AiConversationsThreadConnection!`](#aiconversationsthreadconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

#### 引数 {#arguments-14}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryaiconversationthreadsconversationtype"></a>`conversationType` | [`AiConversationsThreadsConversationType`](#aiconversationsthreadsconversationtype) | スレッドの会話タイプ。 |
| <a id="queryaiconversationthreadsid"></a>`id` | [`AiConversationThreadID`](#aiconversationthreadid) | スレッドのID。 |

### `Query.aiFeatureSettings` {#queryaifeaturesettings}

{{< details >}}GitLab 17.4で**導入**されました。**状態**: 実験的機能。{{< /details >}}

設定可能なAI機能のリスト。

[`AiFeatureSettingConnection`](#aifeaturesettingconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

#### 引数 {#arguments-15}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryaifeaturesettingsselfhostedmodelid"></a>`selfHostedModelId` | [`AiSelfHostedModelID`](#aiselfhostedmodelid) | セルフホストモデルのグローバルID。 |

### `Query.aiMessages` {#queryaimessages}

{{< details >}}GitLab 16.1で**導入**されました。**状態**: 実験的機能。{{< /details >}}

GitLab Duo Chatのメッセージを検索します。

[`AiMessageConnection!`](#aimessageconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

#### 引数 {#arguments-16}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryaimessagesagentversionid"></a>`agentVersionId` | [`AiAgentVersionID`](#aiagentversionid) | チャットに応答するエージェントのグローバルID。 |
| <a id="queryaimessagesconversationtype"></a>`conversationType` | [`AiConversationsThreadsConversationType`](#aiconversationsthreadsconversationtype) | スレッドの会話タイプ。 |
| <a id="queryaimessagesrequestids"></a>`requestIds` | [`[ID!]`](#id) | フェッチするリクエストIDの配列。 |
| <a id="queryaimessagesroles"></a>`roles` | [`[AiMessageRole!]`](#aimessagerole) | フェッチするロールの配列。 |
| <a id="queryaimessagesthreadid"></a>`threadId` | [`AiConversationThreadID`](#aiconversationthreadid) | 既存スレッドのグローバルID。指定されていない場合、指定されたconversation_typeの最後のスレッドを取得します。 |

### `Query.aiModelSelectionNamespaceSettings` {#queryaimodelselectionnamespacesettings}

{{< details >}}GitLab 18.1で**導入**されました。**状態**: 実験的機能。{{< /details >}}

ネームスペースモデル選択の設定可能なAI機能のリスト。

[`AiModelSelectionNamespaceFeatureSettingConnection`](#aimodelselectionnamespacefeaturesettingconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

#### 引数 {#arguments-17}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryaimodelselectionnamespacesettingsgroupid"></a>`groupId` | [`GroupID!`](#groupid) | モデル選択のグループ。 |

### `Query.aiSelfHostedModels` {#queryaiselfhostedmodels}

{{< details >}}GitLab 17.1で**導入**されました。**状態**: 実験的機能。{{< /details >}}

IDが指定されている場合はセルフホストモデルを返し、それ以外の場合はすべてのモデルを返します。

[`AiSelfHostedModelConnection`](#aiselfhostedmodelconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

#### 引数 {#arguments-18}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryaiselfhostedmodelsid"></a>`id` | [`AiSelfHostedModelID`](#aiselfhostedmodelid) | セルフホストモデルのグローバルID。 |

### `Query.aiSlashCommands` {#queryaislashcommands}

特定のURLについて現在のユーザーが使用できるGitLab Duo Chatスラッシュコマンドを取得します。

[`[SlashCommand!]`](#slashcommand)を返します。

#### 引数 {#arguments-19}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryaislashcommandsurl"></a>`url` | [`String!`](#string) | ユーザーが現在アクセスしているページのURL。 |

### `Query.auditEventDefinitions` {#queryauditeventdefinitions}

インスタンスで使用可能なすべての監査イベントの定義。

[`AuditEventDefinitionConnection!`](#auditeventdefinitionconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

### `Query.auditEventsInstanceAmazonS3Configurations` {#queryauditeventsinstanceamazons3configurations}

監査イベントのインスタンスレベルのAmazon S3設定。

[`InstanceAmazonS3ConfigurationTypeConnection`](#instanceamazons3configurationtypeconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

### `Query.auditEventsInstanceStreamingDestinations` {#queryauditeventsinstancestreamingdestinations}

{{< details >}}GitLab 16.11で**導入**されました。**状態**: 実験的機能。{{< /details >}}

インスタンスレベルの外部監査イベントストリーミング先。

[`InstanceAuditEventStreamingDestinationConnection`](#instanceauditeventstreamingdestinationconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

### `Query.blobSearch` {#queryblobsearch}

{{< details >}}GitLab 17.2で**導入**されました。**状態**: 実験的機能。{{< /details >}}

現在のユーザーに表示可能なコードを検索します。

[`BlobSearch`](#blobsearch)を返します。

#### 引数 {#arguments-20}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryblobsearchchunkcount"></a>`chunkCount` {{< icon name="warning-solid" >}} | [`Int`](#int) | GitLab 17.2で**導入**されました。**状態**: 実験的機能。ファイルごとの最大チャンク数。 |
| <a id="queryblobsearchexcludeforks"></a>`excludeForks` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | GitLab 17.11で**導入**されました。**状態**: 実験的機能。フォークしたプロジェクトを検索から除外します。プロジェクト検索の場合は常にfalseになります。デフォルトはtrueです。 |
| <a id="queryblobsearchgroupid"></a>`groupId` {{< icon name="warning-solid" >}} | [`GroupID`](#groupid) | GitLab 17.2で**導入**されました。**状態**: 実験的機能。検索するグループ。 |
| <a id="queryblobsearchincludearchived"></a>`includeArchived` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | GitLab 17.7で**導入**されました。**状態**: 実験的機能。アーカイブされたプロジェクトを検索に含めます。プロジェクト検索では常にtrueになります。デフォルトはfalseです。 |
| <a id="queryblobsearchpage"></a>`page` {{< icon name="warning-solid" >}} | [`Int`](#int) | GitLab 17.2で**導入**されました。**状態**: 実験的機能。結果をフェッチするページ番号。 |
| <a id="queryblobsearchperpage"></a>`perPage` {{< icon name="warning-solid" >}} | [`Int`](#int) | GitLab 17.2で**導入**されました。**状態**: 実験的機能。ページあたりの結果数。 |
| <a id="queryblobsearchprojectid"></a>`projectId` {{< icon name="warning-solid" >}} | [`ProjectID`](#projectid) | GitLab 17.2で**導入**されました。**状態**: 実験的機能。検索するプロジェクト。 |
| <a id="queryblobsearchregex"></a>`regex` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | GitLab 17.3で**導入**されました。**状態**: 実験的機能。正規表現検索モードを使用します。デフォルトはfalseです。 |
| <a id="queryblobsearchrepositoryref"></a>`repositoryRef` {{< icon name="warning-solid" >}} | [`String`](#string) | GitLab 17.2で**導入**されました。**状態**: 実験的機能。検索するリポジトリ参照。 |
| <a id="queryblobsearchsearch"></a>`search` | [`String!`](#string) | 検索語句。 |

### `Query.boardList` {#queryboardlist}

イシューボードリストを検索します。

[`BoardList`](#boardlist)を返します。

#### 引数 {#arguments-21}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryboardlistid"></a>`id` | [`ListID!`](#listid) | リストのグローバルID。 |
| <a id="queryboardlistissuefilters"></a>`issueFilters` | [`BoardIssueInput`](#boardissueinput) | ボードリストでイシューメタデータを取得する際に適用されるフィルター。 |

### `Query.ciApplicationSettings` {#queryciapplicationsettings}

インスタンス全体に適用されるCI関連の設定。

[`CiApplicationSettings`](#ciapplicationsettings)を返します。

### `Query.ciCatalogResource` {#querycicatalogresource}

{{< details >}}GitLab 16.1で**導入**されました。**状態**: 実験的機能。{{< /details >}}

認証済みユーザーに表示可能な単一のCI/CDカタログリソース。

[`CiCatalogResource`](#cicatalogresource)を返します。

#### 引数 {#arguments-22}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querycicatalogresourcefullpath"></a>`fullPath` | [`ID`](#id) | CI/CDカタログリソースのフルパス。 |
| <a id="querycicatalogresourceid"></a>`id` | [`CiCatalogResourceID`](#cicatalogresourceid) | CI/CDカタログリソースのグローバルID。 |

### `Query.ciCatalogResources` {#querycicatalogresources}

{{< details >}}GitLab 15.11で**導入**されました。**状態**: 実験的機能。{{< /details >}}

認証済みユーザーに表示可能な、共通のネームスペース下のすべてのCI/CDカタログリソース。

[`CiCatalogResourceConnection`](#cicatalogresourceconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

#### 引数 {#arguments-23}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querycicatalogresourcesscope"></a>`scope` | [`CiCatalogResourceScope`](#cicatalogresourcescope) | 返されるカタログリソースのスコープ。 |
| <a id="querycicatalogresourcessearch"></a>`search` | [`String`](#string) | カタログリソースを名前または説明でフィルタリングするための検索語句。 |
| <a id="querycicatalogresourcessort"></a>`sort` | [`CiCatalogResourceSort`](#cicatalogresourcesort) | 指定された基準でカタログリソースをソートします。 |
| <a id="querycicatalogresourcestopics"></a>`topics` | [`[String!]`](#string) | プロジェクトトピック名でカタログリソースをフィルタリングします。 |
| <a id="querycicatalogresourcesverificationlevel"></a>`verificationLevel` | [`CiCatalogResourceVerificationLevel`](#cicatalogresourceverificationlevel) | 検証レベルでカタログリソースをフィルタリングします。 |

### `Query.ciConfig` {#queryciconfig}

{{< details >}}GitLab 18.1で**非推奨**になりました。CiLint mutation: <https://docs.gitlab.com/api/graphql/reference/#mutationcilint>を使用します。{{< /details >}}

lintおよび処理されたCI設定内容。1回のリクエストで複数のリクエストはしないでください。

[`CiConfig`](#ciconfig)を返します。

#### 引数 {#arguments-24}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryciconfigcontent"></a>`content` | [`String!`](#string) | `.gitlab-ci.yml`の内容。 |
| <a id="queryciconfigdryrun"></a>`dryRun` | [`Boolean`](#boolean) | パイプライン作成シミュレーションを実行するか、または静的チェックのみ実行します。 |
| <a id="queryciconfigprojectpath"></a>`projectPath` | [`ID!`](#id) | CI設定のプロジェクト。 |
| <a id="queryciconfigsha"></a>`sha` | [`String`](#string) | パイプラインのSHA。 |
| <a id="queryciconfigskipverifyprojectsha"></a>`skipVerifyProjectSha` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | GitLab 16.5で**導入**されました。**状態**: 実験的機能。指定された`sha`はプロジェクトのリポジトリに見つかったが、それがGit参照（デタッチされたコミット）に関連付けられていない場合、検証は失敗し、検証エラーが返されます。それ以外の場合、`sha`が無効であっても検証は成功します。`true`に設定すると、この検証処理をスキップします。 |

### `Query.ciDedicatedHostedRunnerFilters` {#querycidedicatedhostedrunnerfilters}

GitLab Dedicated Runnerの使用状況データに使用可能なフィルターを返します。

[`CiDedicatedHostedRunnerFilters`](#cidedicatedhostedrunnerfilters)を返します。

### `Query.ciDedicatedHostedRunnerUsage` {#querycidedicatedhostedrunnerusage}

GitLab Dedicatedにおいてさまざまなネームスペースに関するRunnerのコンピューティング使用状況データ。年または請求月が指定されていない場合のデフォルトは、現在の年になります。Ultimateでのみご利用いただけます。

[`CiDedicatedHostedRunnerUsageConnection`](#cidedicatedhostedrunnerusageconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

#### 引数 {#arguments-25}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querycidedicatedhostedrunnerusagebillingmonth"></a>`billingMonth` | [`Date`](#date) | データを取得する対象月の最初の日。 |
| <a id="querycidedicatedhostedrunnerusagegrouping"></a>`grouping` | [`GroupingEnum`](#groupingenum) | インスタンスの集計またはルートネームスペースによって使用状況データをグループ化します。 |
| <a id="querycidedicatedhostedrunnerusagerunnerid"></a>`runnerId` | [`CiRunnerID`](#cirunnerid) | データ取得対象のRunner ID。 |
| <a id="querycidedicatedhostedrunnerusageyear"></a>`year` | [`Int`](#int) | データ取得対象の年。 |

### `Query.ciMinutesUsage` {#queryciminutesusage}

ネームスペースのコンピューティング使用状況データ。

[`CiMinutesNamespaceMonthlyUsageConnection`](#ciminutesnamespacemonthlyusageconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

#### 引数 {#arguments-26}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryciminutesusagedate"></a>`date` | [`Date`](#date) | 使用状況データを取得する対象の日付。月の最初の日でなければなりません。 |
| <a id="queryciminutesusagenamespaceid"></a>`namespaceId` | [`NamespaceID`](#namespaceid) | 月間コンピューティング使用状況のネームスペースのグローバルID。 |

### `Query.ciPipelineStage` {#querycipipelinestage}

CIパイプラインに属するステージ。

[`CiStage`](#cistage)を返します。

#### 引数 {#arguments-27}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querycipipelinestageid"></a>`id` | [`CiStageID!`](#cistageid) | CIステージのグローバルID。 |

### `Query.ciQueueingHistory` {#queryciqueueinghistory}

RunnerがCIジョブを百分位で選択するのにかかる時間。このクエリを使用するには、ClickHouse DBバックエンドを有効にします。

[`QueueingDelayHistory`](#queueingdelayhistory)を返します。

#### 引数 {#arguments-28}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryciqueueinghistoryfromtime"></a>`fromTime` | [`Time`](#time) | リクエストされた時間の開始時刻。デフォルトは3時間前です。 |
| <a id="queryciqueueinghistoryrunnertype"></a>`runnerType` | [`CiRunnerType`](#cirunnertype) | ジョブを実行したRunnerのタイプでジョブをフィルタリングします。 |
| <a id="queryciqueueinghistorytotime"></a>`toTime` | [`Time`](#time) | リクエストされた時間の終了時刻。デフォルトは現在の時刻です。 |

### `Query.ciVariables` {#querycivariables}

インスタンスのCI/CD変数のリスト。

[`CiInstanceVariableConnection`](#ciinstancevariableconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

#### 引数 {#arguments-29}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querycivariablessort"></a>`sort` | [`CiVariableSort`](#civariablesort) | 結果のソート順。 |

### `Query.cloudConnectorStatus` {#querycloudconnectorstatus}

{{< details >}}GitLab 17.3で**導入**されました。**状態**: 実験的機能。{{< /details >}}

Cloud Connector機能についての一連のステータスチェックを実行します。

[`CloudConnectorStatus`](#cloudconnectorstatus)を返します。

### `Query.complianceRequirementControls` {#querycompliancerequirementcontrols}

コンプライアンス要件コントロールすべてのリストを取得します。

[`ComplianceRequirementControl`](#compliancerequirementcontrol)を返します。

### `Query.containerRepository` {#querycontainerrepository}

コンテナリポジトリを検索します。

[`ContainerRepositoryDetails`](#containerrepositorydetails)を返します。

#### 引数 {#arguments-30}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querycontainerrepositoryid"></a>`id` | [`ContainerRepositoryID!`](#containerrepositoryid) | コンテナリポジトリのグローバルID。 |

### `Query.currentLicense` {#querycurrentlicense}

現在のライセンスに関連するフィールド。

[`CurrentLicense`](#currentlicense)を返します。

### `Query.currentUser` {#querycurrentuser}

現在のユーザーに関する情報を取得します。

[`CurrentUser`](#currentuser)を返します。

### `Query.customField` {#querycustomfield}

{{< details >}}GitLab 17.10で**導入**されました。**状態**: 実験的機能。{{< /details >}}

カスタムフィールドをIDで検索します。

[`CustomField`](#customfield)を返します。

#### 引数 {#arguments-31}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querycustomfieldid"></a>`id` | [`IssuablesCustomFieldID!`](#issuablescustomfieldid) | カスタムフィールドのグローバルID。 |

### `Query.dependency` {#querydependency}

依存関係を検索します。

[`Dependency`](#dependency)を返します。

#### 引数 {#arguments-32}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querydependencyid"></a>`id` | [`SbomOccurrenceID!`](#sbomoccurrenceid) | 依存関係のグローバルID。 |

### `Query.designManagement` {#querydesignmanagement}

設計管理に関連するフィールド。

[`DesignManagement!`](#designmanagement)を返します。

### `Query.devopsAdoptionEnabledNamespaces` {#querydevopsadoptionenablednamespaces}

設定されているDevOpsアドプションネームスペースを取得します。**状態**: ベータ版。このエンドポイントは、予告なしに変更される場合があります。

[`DevopsAdoptionEnabledNamespaceConnection`](#devopsadoptionenablednamespaceconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

#### 引数 {#arguments-33}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querydevopsadoptionenablednamespacesdisplaynamespaceid"></a>`displayNamespaceId` | [`NamespaceID`](#namespaceid) | 表示ネームスペースでフィルタリングします。 |

### `Query.duoSettings` {#queryduosettings}

{{< details >}}GitLab 17.9で**導入**されました。**状態**: 実験的機能。{{< /details >}}

GitLab Duoの設定を取得します。

[`DuoSettings`](#duosettings)を返します。

### `Query.duoWorkflowEvents` {#queryduoworkflowevents}

{{< details >}}GitLab 17.2で**導入**されました。**状態**: 実験的機能。{{< /details >}}

GitLab Duo Agent Platformのイベントをリスト表示します。

[`DuoWorkflowEventConnection!`](#duoworkfloweventconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

#### 引数 {#arguments-34}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryduoworkfloweventsworkflowid"></a>`workflowId` | [`AiDuoWorkflowsWorkflowID!`](#aiduoworkflowsworkflowid) | フェッチするリクエストIDの配列。 |

### `Query.duoWorkflowWorkflows` {#queryduoworkflowworkflows}

{{< details >}}GitLab 17.2で**導入**されました。**状態**: 実験的機能。{{< /details >}}

現在のユーザーがオーナーであるワークフローを一覧表示します。

[`DuoWorkflowConnection!`](#duoworkflowconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

#### 引数 {#arguments-35}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryduoworkflowworkflowsenvironment"></a>`environment` | [`WorkflowEnvironment`](#workflowenvironment) | 環境（IDE、Webなど）。 |
| <a id="queryduoworkflowworkflowsprojectpath"></a>`projectPath` | [`ID`](#id) | フローを含むプロジェクトのフルパス。 |
| <a id="queryduoworkflowworkflowssort"></a>`sort` | [`Sort`](#sort) | 条件でフローをソートします。 |
| <a id="queryduoworkflowworkflowstype"></a>`type` | [`String`](#string) | フィルタリングするフローのタイプ（software_developmentなど）。 |
| <a id="queryduoworkflowworkflowsworkflowid"></a>`workflowId` | [`AiDuoWorkflowsWorkflowID`](#aiduoworkflowsworkflowid) | フィルタリングするフローID。 |

### `Query.echo` {#queryecho}

APIの検証に使用するテストエンドポイント。

[`String!`](#string)を返します。

#### 引数 {#arguments-36}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryechotext"></a>`text` | [`String!`](#string) | エコーバックするテキスト。 |

### `Query.epicBoardList` {#queryepicboardlist}

[`EpicList`](#epiclist)を返します。

#### 引数 {#arguments-37}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryepicboardlistepicfilters"></a>`epicFilters` | [`EpicFilters`](#epicfilters) | エピックボードリストでエピックメタデータを取得する際に適用されるフィルター。 |
| <a id="queryepicboardlistid"></a>`id` | [`BoardsEpicListID!`](#boardsepiclistid) | リストのグローバルID。 |

### `Query.featureFlagEnabled` {#queryfeatureflagenabled}

{{< details >}}GitLab 17.4で**非推奨**になりました。metadata.featureFlagsに置き換えられました。{{< /details >}}

機能フラグが有効になっているかどうかを確認します。

[`Boolean!`](#boolean)を返します。

#### 引数 {#arguments-38}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryfeatureflagenabledname"></a>`name` | [`String!`](#string) | 機能フラグの名前。 |

### `Query.frecentGroups` {#queryfrecentgroups}

ユーザーが最近アクセスしたグループ。

[`[Group!]`](#group)を返します。

### `Query.frecentProjects` {#queryfrecentprojects}

ユーザーが最近アクセスしたプロジェクト。

[`[Project!]`](#project)を返します。

### `Query.geoNode` {#querygeonode}

Geoノードを検索します。

[`GeoNode`](#geonode)を返します。

#### 引数 {#arguments-39}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querygeonodename"></a>`name` | [`String`](#string) | Geoノードの名前。デフォルトは現在のGeoノードの名前です。 |

### `Query.gitpodEnabled` {#querygitpodenabled}

アプリケーション設定でGitpodが有効になっているかどうか。

[`Boolean`](#boolean)を返します。

### `Query.googleCloudArtifactRegistryRepositoryArtifact` {#querygooglecloudartifactregistryrepositoryartifact}

{{< details >}}GitLab 16.10で**導入**されました。**状態**: 実験的機能。{{< /details >}}

Google Artifact Registryに含まれるアーティファクトに関する詳細。

[`GoogleCloudArtifactRegistryArtifactDetails`](#googlecloudartifactregistryartifactdetails)を返します。

#### 引数 {#arguments-40}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querygooglecloudartifactregistryrepositoryartifactgooglecloudprojectid"></a>`googleCloudProjectId` | [`String!`](#string) | Google CloudプロジェクトのID。 |
| <a id="querygooglecloudartifactregistryrepositoryartifactimage"></a>`image` | [`String!`](#string) | Google Artifact Registryのイメージの名前。 |
| <a id="querygooglecloudartifactregistryrepositoryartifactlocation"></a>`location` | [`String!`](#string) | Artifact Registryリポジトリの場所。 |
| <a id="querygooglecloudartifactregistryrepositoryartifactprojectpath"></a>`projectPath` | [`ID!`](#id) | プロジェクトのフルパス。 |
| <a id="querygooglecloudartifactregistryrepositoryartifactrepository"></a>`repository` | [`String!`](#string) | Google Artifact Registryのリポジトリ。 |

### `Query.group` {#querygroup}

グループを検索します。

[`Group`](#group)を返します。

#### 引数 {#arguments-41}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querygroupfullpath"></a>`fullPath` | [`ID!`](#id) | グループのフルパス。例: `gitlab-org/gitlab-foss`。 |

### `Query.groups` {#querygroups}

グループを検索します。

[`GroupConnection`](#groupconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

#### 引数 {#arguments-42}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querygroupsactive"></a>`active` | [`Boolean`](#boolean) | `nil`（デフォルト値）の場合、すべてのグループを返します。`true`の場合、削除保留中でないグループのみを返します。`false`の場合、削除保留中のグループのみを返します。 |
| <a id="querygroupsallavailable"></a>`allAvailable` | [`Boolean`](#boolean) | `true`の場合、アクセス可能なすべてのグループを返します。`false`の場合、ユーザーがメンバーであるグループのみを返します。非認証のリクエストでは、常にすべての公開グループが返されます。`owned_only`引数が優先されます。 |
| <a id="querygroupsids"></a>`ids` | [`[ID!]`](#id) | グループをIDでフィルタリングします。 |
| <a id="querygroupsmarkedfordeletionon"></a>`markedForDeletionOn` | [`Date`](#date) | グループが削除対象としてマークされた日付。 |
| <a id="querygroupsownedonly"></a>`ownedOnly` | [`Boolean`](#boolean) | 現在のユーザーがオーナーロールを付与されているグループのみを含めます。 |
| <a id="querygroupsparentpath"></a>`parentPath` | [`ID`](#id) | 親グループのフルパス。 |
| <a id="querygroupssearch"></a>`search` | [`String`](#string) | グループ名またはグループのフルパスの検索クエリ。 |
| <a id="querygroupssort"></a>`sort` | [`String`](#string) | 結果のソート順。形式: `<field_name>_<sort_direction>`（`id_desc`や`name_asc`など）。 |
| <a id="querygroupstoplevelonly"></a>`topLevelOnly` | [`Boolean`](#boolean) | トップレベルグループのみを含めます。 |

### `Query.instanceExternalAuditEventDestinations` {#queryinstanceexternalauditeventdestinations}

インスタンスレベルの外部監査イベントの宛先。

[`InstanceExternalAuditEventDestinationConnection`](#instanceexternalauditeventdestinationconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

### `Query.instanceGoogleCloudLoggingConfigurations` {#queryinstancegooglecloudloggingconfigurations}

インスタンスレベルでのGoogle Cloudのログ生成の設定。

[`InstanceGoogleCloudLoggingConfigurationTypeConnection`](#instancegooglecloudloggingconfigurationtypeconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

### `Query.instanceSecurityDashboard` {#queryinstancesecuritydashboard}

インスタンスセキュリティダッシュボードに関連するフィールド。

[`InstanceSecurityDashboard`](#instancesecuritydashboard)を返します。

### `Query.integrationExclusions` {#queryintegrationexclusions}

{{< details >}} GitLab 17.0で**導入**されました。**状態**: 実験的機能。{{< /details >}}

[`IntegrationExclusionConnection`](#integrationexclusionconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

#### 引数 {#arguments-43}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryintegrationexclusionsintegrationname"></a>`integrationName` | [`IntegrationType!`](#integrationtype) | インテグレーションのタイプ。 |

### `Query.issue` {#queryissue}

イシューを検索します。

[`Issue`](#issue)を返します。

#### 引数 {#arguments-44}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryissueid"></a>`id` | [`IssueID!`](#issueid) | イシューのグローバルID。 |

### `Query.issues` {#queryissues}

{{< details >}} GitLab 15.6で**導入**されました。**状態**: 実験的機能。{{< /details >}}

現在のユーザーに表示可能なイシューを検索します。少なくとも1つのフィルターを指定する必要があります。

[`IssueConnection`](#issueconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

#### 引数 {#arguments-45}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryissuesassigneeid"></a>`assigneeId` | [`String`](#string) | イシューに割り当てられているユーザーのID。ワイルドカード値「NONE」と「ANY」がサポートされています。 |
| <a id="queryissuesassigneeusername"></a>`assigneeUsername` {{< icon name="warning-solid" >}} | [`String`](#string) | GitLab 13.11で**非推奨**になりました。`assigneeUsernames`を使用してください。 |
| <a id="queryissuesassigneeusernames"></a>`assigneeUsernames` | [`[String!]`](#string) | イシューに割り当てられているユーザーのユーザー名。 |
| <a id="queryissuesassigneewildcardid"></a>`assigneeWildcardId` | [`AssigneeWildcardId`](#assigneewildcardid) | 担当者のワイルドカードでフィルタリングします。assigneeUsernameともassigneeUsernamesとも互換性がありません。 |
| <a id="queryissuesauthorusername"></a>`authorUsername` | [`String`](#string) | イシューの作成者のユーザー名。 |
| <a id="queryissuesclosedafter"></a>`closedAfter` | [`Time`](#time) | 指定日付より後に完了したイシュー。 |
| <a id="queryissuesclosedbefore"></a>`closedBefore` | [`Time`](#time) | 指定日付より前に完了したイシュー。 |
| <a id="queryissuesconfidential"></a>`confidential` | [`Boolean`](#boolean) | 機密情報イシューについてフィルタリングします。「false」の場合、機密情報イシューを除外します。「true」の場合、機密情報イシューのみを返します。 |
| <a id="queryissuescreatedafter"></a>`createdAfter` | [`Time`](#time) | 指定日付より後に作成されたイシュー。 |
| <a id="queryissuescreatedbefore"></a>`createdBefore` | [`Time`](#time) | 指定日付より前に作成されたイシュー。 |
| <a id="queryissuescrmcontactid"></a>`crmContactId` | [`String`](#string) | イシューに割り当てられている連絡先のID。 |
| <a id="queryissuescrmorganizationid"></a>`crmOrganizationId` | [`String`](#string) | イシューに割り当てられている組織のID。 |
| <a id="queryissuescustomfield"></a>`customField` {{< icon name="warning-solid" >}} | [`[WorkItemWidgetCustomFieldFilterInputType!]`](#workitemwidgetcustomfieldfilterinputtype) | GitLab 17.10で**導入**されました。**状態**: 実験的機能。カスタムフィールドでフィルタリングします。 |
| <a id="queryissuesdueafter"></a>`dueAfter` | [`Time`](#time) | 指定時刻以降に期限が切れるイシューを返します。 |
| <a id="queryissuesduebefore"></a>`dueBefore` | [`Time`](#time) | 指定時刻以前に期限が切れるイシューを返します。 |
| <a id="queryissuesepicid"></a>`epicId` | [`String`](#string) | イシューに関連付けられているエピックのID。「none」と「any」の値がサポートされています。 |
| <a id="queryissuesepicwildcardid"></a>`epicWildcardId` | [`EpicWildcardId`](#epicwildcardid) | エピックIDのワイルドカードでフィルタリングします。epicIdと互換性がありません。 |
| <a id="queryissueshealthstatusfilter"></a>`healthStatusFilter` | [`HealthStatusFilter`](#healthstatusfilter) | イシューのヘルスステータス。「none」と「any」の値がサポートされています。 |
| <a id="queryissuesiid"></a>`iid` | [`String`](#string) | イシューのIID。例: 「1」。 |
| <a id="queryissuesiids"></a>`iids` | [`[String!]`](#string) | イシューのIIDのリスト。例: `["1", "2"]`。 |
| <a id="queryissuesin"></a>`in` | [`[IssuableSearchableField!]`](#issuablesearchablefield) | 検索を実行するフィールドを指定します。デフォルトは`[TITLE, DESCRIPTION]`です。`search`引数が必要です。 |
| <a id="queryissuesincludearchived"></a>`includeArchived` | [`Boolean`](#boolean) | アーカイブされたプロジェクトからのイシューを含めるかどうか。デフォルトは`false`です。 |
| <a id="queryissuesincludesubepics"></a>`includeSubepics` | [`Boolean`](#boolean) | epicIdでイシューをフィルタリングする際にサブエピックを含めるかどうか。 |
| <a id="queryissuesiterationcadenceid"></a>`iterationCadenceId` | [`[IterationsCadenceID!]`](#iterationscadenceid) | イテレーションの反復IDのリストでフィルタリングします。 |
| <a id="queryissuesiterationid"></a>`iterationId` | [`[ID]`](#id) | イシューに適用されるイテレーショングローバルIDのリスト。 |
| <a id="queryissuesiterationtitle"></a>`iterationTitle` | [`String`](#string) | イテレーションのタイトルでフィルタリングします。 |
| <a id="queryissuesiterationwildcardid"></a>`iterationWildcardId` | [`IterationWildcardId`](#iterationwildcardid) | イテレーションIDのワイルドカードでフィルタリングします。 |
| <a id="queryissueslabelname"></a>`labelName` | [`[String]`](#string) | イシューに適用されるラベル。 |
| <a id="queryissuesmilestonetitle"></a>`milestoneTitle` | [`[String]`](#string) | イシューに適用されるマイルストーン。 |
| <a id="queryissuesmilestonewildcardid"></a>`milestoneWildcardId` | [`MilestoneWildcardId`](#milestonewildcardid) | マイルストーンIDのワイルドカードでイシューをフィルタリングします。 |
| <a id="queryissuesmyreactionemoji"></a>`myReactionEmoji` | [`String`](#string) | 現在のユーザーが適用したリアクション絵文字でフィルタリングします。ワイルドカード値「NONE」と「ANY」がサポートされています。 |
| <a id="queryissuesnot"></a>`not` | [`NegatedIssueFilterInput`](#negatedissuefilterinput) | 否定条件となる引数。 |
| <a id="queryissuesor"></a>`or` | [`UnionedIssueFilterInput`](#unionedissuefilterinput) | 引数のリストのインクルーシブOR結合。 |
| <a id="queryissuessearch"></a>`search` | [`String`](#string) | タイトルまたは説明の検索クエリ。 |
| <a id="queryissuessort"></a>`sort` | [`IssueSort`](#issuesort) | 基準でイシューをソートします。 |
| <a id="queryissuesstate"></a>`state` | [`IssuableState`](#issuablestate) | イシューの現在の状態。 |
| <a id="queryissuesstatus"></a>`status` {{< icon name="warning-solid" >}} | [`WorkItemWidgetStatusFilterInput`](#workitemwidgetstatusfilterinput) | GitLab 18.0で**導入**されました。**状態**: 実験的機能。ステータスでフィルタリングします。 |
| <a id="queryissuessubscribed"></a>`subscribed` | [`SubscriptionStatus`](#subscriptionstatus) | 現在のユーザーがサブスクライブしているイシュー。 |
| <a id="queryissuestypes"></a>`types` | [`[IssueType!]`](#issuetype) | 指定されたイシュータイプでイシューをフィルタリングします。 |
| <a id="queryissuesupdatedafter"></a>`updatedAfter` | [`Time`](#time) | 指定日付より後に更新されたイシュー。 |
| <a id="queryissuesupdatedbefore"></a>`updatedBefore` | [`Time`](#time) | 指定日付より前に更新されたイシュー。 |
| <a id="queryissuesweight"></a>`weight` | [`String`](#string) | イシューに適用されるウェイト。「none」と「any」の値がサポートされています。 |
| <a id="queryissuesweightwildcardid"></a>`weightWildcardId` | [`WeightWildcardId`](#weightwildcardid) | ウェイトIDのワイルドカードでフィルタリングします。weightと互換性がありません。 |

### `Query.iteration` {#queryiteration}

イテレーションを検索します。

[`Iteration`](#iteration)を返します。

#### 引数 {#arguments-46}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryiterationid"></a>`id` | [`IterationID!`](#iterationid) | イテレーションをIDで検索します。 |

### `Query.jobs` {#queryjobs}

このGitLabインスタンス上のすべてのジョブ。管理者アクセス権のないユーザーには空の結果が返されます。

[`CiJobInterfaceConnection`](#cijobinterfaceconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

#### 引数 {#arguments-47}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryjobscompatiblerunnerid"></a>`compatibleRunnerId` {{< icon name="warning-solid" >}} | [`CiRunnerID`](#cirunnerid) | GitLab 18.1で**導入**されました。**状態**: 実験的機能。返されたジョブの要件に一致するRunnerのID（通常、保留中のジョブをフィルタリングする際に使用します）。 |
| <a id="queryjobsfailurereason"></a>`failureReason` {{< icon name="warning-solid" >}} | [`CiJobFailureReason`](#cijobfailurereason) | GitLab 16.4で**導入**されました。**状態**: 実験的機能。失敗理由でジョブをフィルタリングします。現在、`RUNNER_SYSTEM_FAILURE`と`runnerTypes: INSTANCE_TYPE`の組み合わせのみサポートされています。 |
| <a id="queryjobsrunnertypes"></a>`runnerTypes` {{< icon name="warning-solid" >}} | [`[CiRunnerType!]`](#cirunnertype) | GitLab 16.4で**導入**されました。**状態**: 実験的機能。機能フラグ`:admin_jobs_filter_runner_type`が有効になっている場合に、Runnerのタイプでジョブをフィルタリングします。 |
| <a id="queryjobsstatuses"></a>`statuses` | [`[CiJobStatus!]`](#cijobstatus) | ジョブをステータスでフィルタリングします。 |

### `Query.ldapAdminRoleLinks` {#queryldapadminrolelinks}

{{< details >}} GitLab 17.11で**導入**されました。**状態**: 実験的機能。{{< /details >}}

LDAP管理者リンク。GitLab Self-Managedでのみ利用可能。

[`LdapAdminRoleLinkConnection`](#ldapadminrolelinkconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

### `Query.licenseHistoryEntries` {#querylicensehistoryentries}

ライセンス履歴のエントリに関連するフィールド。

[`LicenseHistoryEntryConnection`](#licensehistoryentryconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

### `Query.mavenUpstreamRegistry` {#querymavenupstreamregistry}

{{< details >}}GitLab 18.4で**導入**されました。**状態**: 実験的機能。{{< /details >}}

Mavenアップストリームレジストリを検索します。`maven_virtual_registry`機能フラグが無効になっている場合は、nullが返されます。

[`MavenUpstream`](#mavenupstream)を返します。

#### 引数 {#arguments-48}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querymavenupstreamregistryid"></a>`id` | [`VirtualRegistriesPackagesMavenUpstreamID!`](#virtualregistriespackagesmavenupstreamid) | MavenアップストリームレジストリのグローバルID。 |

### `Query.mavenVirtualRegistry` {#querymavenvirtualregistry}

{{< details >}}GitLab 18.3で**導入**されました。**状態**: 実験的機能。{{< /details >}}

Maven仮想レジストリを検索します。`maven_virtual_registry`機能フラグが無効になっている場合は、nullが返されます。

[`MavenVirtualRegistry`](#mavenvirtualregistry)を返します。

#### 引数 {#arguments-49}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querymavenvirtualregistryid"></a>`id` | [`VirtualRegistriesPackagesMavenRegistryID!`](#virtualregistriespackagesmavenregistryid) | Maven仮想レジストリのグローバルID。 |

### `Query.memberRole` {#querymemberrole}

{{< details >}} GitLab 16.6で**導入**されました。**状態**: 実験的機能。{{< /details >}}

インスタンスの単一のカスタムロールを検索します。GitLab Self-Managedでのみ利用可能。

[`MemberRole`](#memberrole)を返します。

#### 引数 {#arguments-50}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querymemberroleid"></a>`id` | [`MemberRoleID`](#memberroleid) | 検索するメンバーロールのグローバルID。 |
| <a id="querymemberroleids"></a>`ids` | [`[MemberRoleID!]`](#memberroleid) | 検索する複数個のメンバーロールのグローバルID。 |
| <a id="querymemberroleorderby"></a>`orderBy` | [`MemberRolesOrderBy`](#memberrolesorderby) | 列の並べ替え。デフォルトはNAMEです。 |
| <a id="querymemberrolesort"></a>`sort` | [`SortDirectionEnum`](#sortdirectionenum) | 列の並べ替え。デフォルトはASCです。 |

### `Query.memberRolePermissions` {#querymemberrolepermissions}

{{< details >}}GitLab 16.4で**導入**されました。**状態**: 実験的機能。{{< /details >}}

標準のカスタマイズ可能権限すべてのリスト。

[`CustomizableStandardPermissionConnection`](#customizablestandardpermissionconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

### `Query.memberRoles` {#querymemberroles}

{{< details >}} GitLab 16.7で**導入**されました。**状態**: 実験的機能。{{< /details >}}

インスタンスで使用可能なカスタムロール。GitLab Self-Managedでのみ利用可能。

[`MemberRoleConnection`](#memberroleconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

#### 引数 {#arguments-51}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querymemberrolesid"></a>`id` | [`MemberRoleID`](#memberroleid) | 検索するメンバーロールのグローバルID。 |
| <a id="querymemberrolesids"></a>`ids` | [`[MemberRoleID!]`](#memberroleid) | 検索する複数個のメンバーロールのグローバルID。 |
| <a id="querymemberrolesorderby"></a>`orderBy` | [`MemberRolesOrderBy`](#memberrolesorderby) | 列の並べ替え。デフォルトはNAMEです。 |
| <a id="querymemberrolessort"></a>`sort` | [`SortDirectionEnum`](#sortdirectionenum) | 列の並べ替え。デフォルトはASCです。 |

### `Query.mergeRequest` {#querymergerequest}

マージリクエストを検索します。

[`MergeRequest`](#mergerequest)を返します。

#### 引数 {#arguments-52}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querymergerequestid"></a>`id` | [`MergeRequestID!`](#mergerequestid) | マージリクエストのグローバルID。 |

### `Query.metadata` {#querymetadata}

GitLabに関するメタデータ。

[`Metadata`](#metadata)を返します。

### `Query.milestone` {#querymilestone}

マイルストーンを検索します。

[`Milestone`](#milestone)を返します。

#### 引数 {#arguments-53}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querymilestoneid"></a>`id` | [`MilestoneID!`](#milestoneid) | マイルストーンをIDで検索します。 |

### `Query.mlExperiment` {#querymlexperiment}

機械学習の実験を検索します。

[`MlExperiment`](#mlexperiment)を返します。

#### 引数 {#arguments-54}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querymlexperimentid"></a>`id` | [`MlExperimentID!`](#mlexperimentid) | 実験のID。 |

### `Query.mlModel` {#querymlmodel}

{{< details >}} GitLab 16.7で**導入**されました。**状態**: 実験的機能。{{< /details >}}

機械学習モデルを検索します。

[`MlModel`](#mlmodel)を返します。

#### 引数 {#arguments-55}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querymlmodelid"></a>`id` | [`MlModelID!`](#mlmodelid) | モデルのID。 |

### `Query.namespace` {#querynamespace}

ネームスペースを検索します。

[`Namespace`](#namespace)を返します。

#### 引数 {#arguments-56}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querynamespacefullpath"></a>`fullPath` | [`ID!`](#id) | ネームスペースのフルパス。例: `gitlab-org/gitlab-foss`。 |

### `Query.namespaceSecurityProjects` {#querynamespacesecurityprojects}

ネームスペースのセキュリティでフィルタリングされたプロジェクト。

[`ProjectConnection`](#projectconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

#### 引数 {#arguments-57}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querynamespacesecurityprojectsnamespaceid"></a>`namespaceId` | [`NamespaceID!`](#namespaceid) | ネームスペースのグローバルID。 |
| <a id="querynamespacesecurityprojectssearch"></a>`search` | [`String`](#string) | 名前でプロジェクトを検索します。 |
| <a id="querynamespacesecurityprojectssecurityanalyzerfilters"></a>`securityAnalyzerFilters` | [`[AnalyzerFilterInput!]`](#analyzerfilterinput) | アナライザーの型と状態で、プロジェクトをフィルタリングします。 |
| <a id="querynamespacesecurityprojectsvulnerabilitycountfilters"></a>`vulnerabilityCountFilters` | [`[VulnerabilityCountFilterInput!]`](#vulnerabilitycountfilterinput) | 比較演算子を使用して、脆弱性の数でプロジェクトをフィルタリングします。 |

### `Query.note` {#querynote}

{{< details >}} GitLab 15.9で**導入**されました。**状態**: 実験的機能。{{< /details >}}

ノートを検索します。

[`Note`](#note)を返します。

#### 引数 {#arguments-58}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querynoteid"></a>`id` | [`NoteID!`](#noteid) | ノートのグローバルID。 |

### `Query.organization` {#queryorganization}

{{< details >}}GitLab 16.4で**導入**されました。**状態**: 実験的機能。{{< /details >}}

組織を検索します。

[`Organization`](#organization)を返します。

#### 引数 {#arguments-59}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryorganizationid"></a>`id` | [`OrganizationsOrganizationID!`](#organizationsorganizationid) | 組織のID。 |

### `Query.organizations` {#queryorganizations}

{{< details >}}GitLab 16.8で**導入**されました。**状態**: 実験的機能。{{< /details >}}

組織を一覧表示します。

[`OrganizationConnection`](#organizationconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

### `Query.package` {#querypackage}

パッケージを検索します。このフィールドは、1回のリクエストにつき1つのクエリに対してのみ解決できます。パッケージに`default`のステータスがない場合、`null`を返します。

[`PackageDetailsType`](#packagedetailstype)を返します。

#### 引数 {#arguments-60}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querypackageid"></a>`id` | [`PackagesPackageID!`](#packagespackageid) | パッケージのグローバルID。 |

### `Query.project` {#queryproject}

プロジェクトを検索します。

[`Project`](#project)を返します。

#### 引数 {#arguments-61}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryprojectfullpath"></a>`fullPath` | [`ID!`](#id) | プロジェクトのフルパス。例: `gitlab-org/gitlab-foss`。 |

### `Query.projectComplianceViolation` {#queryprojectcomplianceviolation}

プロジェクトのコンプライアンス違反を検索します。

[`ProjectComplianceViolation`](#projectcomplianceviolation)を返します。

#### 引数 {#arguments-62}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryprojectcomplianceviolationid"></a>`id` | [`ComplianceManagementProjectsComplianceViolationID!`](#compliancemanagementprojectscomplianceviolationid) | プロジェクトコンプライアンス違反のグローバルID。 |

### `Query.projectSecret` {#queryprojectsecret}

{{< details >}}GitLab 17.9で**導入**されました。**状態**: 実験的機能。{{< /details >}}

特定のプロジェクトシークレットを表示します。

[`ProjectSecret`](#projectsecret)を返します。

#### 引数 {#arguments-63}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryprojectsecretname"></a>`name` | [`String!`](#string) | 表示するプロジェクトシークレットの名前。 |
| <a id="queryprojectsecretprojectpath"></a>`projectPath` | [`ID!`](#id) | シークレットが属するプロジェクト。 |

### `Query.projectSecrets` {#queryprojectsecrets}

{{< details >}}GitLab 17.8で**導入**されました。**状態**: 実験的機能。{{< /details >}}

プロジェクトシークレットを一覧表示します。

[`ProjectSecretConnection`](#projectsecretconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

#### 引数 {#arguments-64}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryprojectsecretsprojectpath"></a>`projectPath` | [`ID!`](#id) | シークレットが属するプロジェクト。 |

### `Query.projectSecretsManager` {#queryprojectsecretsmanager}

{{< details >}}GitLab 17.4で**導入**されました。**状態**: 実験的機能。{{< /details >}}

プロジェクトシークレットマネージャーを検索します。

[`ProjectSecretsManager`](#projectsecretsmanager)を返します。

#### 引数 {#arguments-65}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryprojectsecretsmanagerprojectpath"></a>`projectPath` | [`ID!`](#id) | シークレットマネージャーのプロジェクト。 |

### `Query.projects` {#queryprojects}

現在のユーザーに表示可能なプロジェクトを検索します。

[`ProjectConnection`](#projectconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

#### 引数 {#arguments-66}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryprojectsactive"></a>`active` | [`Boolean`](#boolean) | アーカイブされておらず、削除対象としてマークされていないプロジェクトでフィルタリングします。 |
| <a id="queryprojectsaimedfordeletion"></a>`aimedForDeletion` | [`Boolean`](#boolean) | 削除対象としてマークされているプロジェクトのみを返します。 |
| <a id="queryprojectsarchived"></a>`archived` | [`ProjectArchived`](#projectarchived) | アーカイブされたステータスによりプロジェクトをフィルタリングします。 |
| <a id="queryprojectsfullpaths"></a>`fullPaths` | [`[String!]`](#string) | プロジェクトをフルパスでフィルタリングします。50を超えるフルパスを指定することはできません。 |
| <a id="queryprojectsids"></a>`ids` | [`[ID!]`](#id) | プロジェクトをIDでフィルタリングします。 |
| <a id="queryprojectsincludehidden"></a>`includeHidden` | [`Boolean`](#boolean) | 非表示のプロジェクトを含めます。 |
| <a id="queryprojectslastrepositorycheckfailed"></a>`lastRepositoryCheckFailed` | [`Boolean`](#boolean) | 最後のリポジトリチェックに失敗したプロジェクトのみを返します。管理者のみが利用できます。 |
| <a id="queryprojectsmarkedfordeletionon"></a>`markedForDeletionOn` | [`Date`](#date) | プロジェクトが削除対象としてマークされた日付。 |
| <a id="queryprojectsmembership"></a>`membership` | [`Boolean`](#boolean) | 現在のユーザーがメンバーであるプロジェクトのみを返します。 |
| <a id="queryprojectsminaccesslevel"></a>`minAccessLevel` | [`AccessLevelEnum`](#accesslevelenum) | 現在のユーザーに付与されているアクセスレベルが指定されたアクセスレベル以上であるプロジェクトのみを返します。 |
| <a id="queryprojectsnamespacepath"></a>`namespacePath` | [`ID`](#id) | プロジェクトをネームスペースのフルパス（グループまたはユーザー）でフィルタリングします。 |
| <a id="queryprojectsnotaimedfordeletion"></a>`notAimedForDeletion` | [`Boolean`](#boolean) | 削除対象としてマークされているプロジェクトを除外します。 |
| <a id="queryprojectspersonal"></a>`personal` | [`Boolean`](#boolean) | 個人用プロジェクトのみを返します。 |
| <a id="queryprojectsprogramminglanguagename"></a>`programmingLanguageName` | [`String`](#string) | プロジェクトをプログラミング言語名でフィルタリングします（大文字と小文字は区別されません）。「css」や「ruby」など。 |
| <a id="queryprojectssearch"></a>`search` | [`String`](#string) | プロジェクト名、パス、または説明の検索クエリ。 |
| <a id="queryprojectssearchnamespaces"></a>`searchNamespaces` | [`Boolean`](#boolean) | プロジェクト検索にネームスペースを含めます。 |
| <a id="queryprojectssort"></a>`sort` | [`String`](#string) | 結果のソート順。形式: `<field_name>_<sort_direction>`（`id_desc`や`name_asc`など）。デフォルトでは`id_desc`、検索を使用する場合は`similarity`になります。 |
| <a id="queryprojectstopics"></a>`topics` | [`[String!]`](#string) | プロジェクトをトピックでフィルタリングします。 |
| <a id="queryprojectstrending"></a>`trending` | [`Boolean`](#boolean) | トレンド中のプロジェクトのみを返します。 |
| <a id="queryprojectsvisibilitylevel"></a>`visibilityLevel` | [`VisibilityLevelsEnum`](#visibilitylevelsenum) | 表示レベルでプロジェクトをフィルタリングします。 |
| <a id="queryprojectswithcodeembeddingsindexed"></a>`withCodeEmbeddingsIndexed` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | GitLab 18.2で**導入**されました。**状態**: 実験的機能。インデックス付きコード埋め込みを含むプロジェクトを含めます。`ids`を送信する必要があります。機能フラグ`allow_with_code_embeddings_indexed_projects_filter`が有効になっている場合にのみ適用されます。 |
| <a id="queryprojectswithissuesenabled"></a>`withIssuesEnabled` | [`Boolean`](#boolean) | イシューが有効になっているプロジェクトのみを返します。 |
| <a id="queryprojectswithmergerequestsenabled"></a>`withMergeRequestsEnabled` | [`Boolean`](#boolean) | マージリクエストが有効になっているプロジェクトのみを返します。 |

### `Query.queryComplexity` {#queryquerycomplexity}

GraphQLクエリの複雑さに関する情報。

[`QueryComplexity`](#querycomplexity)を返します。

### `Query.runner` {#queryrunner}

Runnerを検索します。

[`CiRunner`](#cirunner)を返します。

#### 引数 {#arguments-67}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryrunnerid"></a>`id` | [`CiRunnerID!`](#cirunnerid) | RunnerのID。 |

### `Query.runnerPlatforms` {#queryrunnerplatforms}

{{< details >}}GitLab 15.9で**非推奨**になりました。使用されなくなりました。サポートされているプラットフォームについては、gitlab-Runnerのドキュメントを参照してください。{{< /details >}}

サポートされているRunnerプラットフォーム。

[`RunnerPlatformConnection`](#runnerplatformconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

### `Query.runnerSetup` {#queryrunnersetup}

{{< details >}}GitLab 15.9で**非推奨**になりました。使用されなくなりました。Runnerの登録コマンドについては、gitlab-runnerのドキュメントを参照してください。{{< /details >}}

Runnerの設定手順。

[`RunnerSetup`](#runnersetup)を返します。

#### 引数 {#arguments-68}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryrunnersetuparchitecture"></a>`architecture` | [`String!`](#string) | 手順を生成する対象のアーキテクチャ。 |
| <a id="queryrunnersetupgroupid"></a>`groupId` {{< icon name="warning-solid" >}} | [`GroupID`](#groupid) | GitLab 13.11で**非推奨**になりました。使用されなくなりました。 |
| <a id="queryrunnersetupplatform"></a>`platform` | [`String!`](#string) | 手順を生成する対象のプラットフォーム。 |
| <a id="queryrunnersetupprojectid"></a>`projectId` {{< icon name="warning-solid" >}} | [`ProjectID`](#projectid) | GitLab 13.11で**非推奨**になりました。使用されなくなりました。 |

### `Query.runnerUsage` {#queryrunnerusage}

RunnerごとのRunner使用状況。このクエリを使用するには、ClickHouse DBバックエンドを有効にします。

[`[CiRunnerUsage!]`](#cirunnerusage)を返します。

#### 引数 {#arguments-69}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryrunnerusagefromdate"></a>`fromDate` | [`Date`](#date) | リクエストされた日付フレームの開始日。デフォルトは、カレンダー前月の開始日です。 |
| <a id="queryrunnerusagefullpath"></a>`fullPath` | [`ID`](#id) | ジョブを、その属するグループまたはプロジェクトのフルパスでフィルタリングします。例: `gitlab-org`や`gitlab-org/gitlab`など。これを使用できるのは、管理者と、グループ（グループが指定されている場合）またはプロジェクト（プロジェクトが指定されている場合）のメンテナーロールを付与されているユーザーだけです。最大5,000個の子プロジェクトからのRunnerに制限されています。 |
| <a id="queryrunnerusagerunnertype"></a>`runnerType` | [`CiRunnerType`](#cirunnertype) | Runnerをタイプでフィルタリングします。 |
| <a id="queryrunnerusagerunnerslimit"></a>`runnersLimit` | [`Int`](#int) | 返すRunnerの最大数。その他のRunnerは`runner: null`エントリに集約されます。指定されていない場合のデフォルトは5です。最大500。 |
| <a id="queryrunnerusagetodate"></a>`toDate` | [`Date`](#date) | リクエストされた日付フレームの終了日。デフォルトは、カレンダー前月の終了日です。 |

### `Query.runnerUsageByProject` {#queryrunnerusagebyproject}

プロジェクトごとのRunnerの使用状況。このクエリを使用するには、ClickHouse DBバックエンドを有効にします。

[`[CiRunnerUsageByProject!]`](#cirunnerusagebyproject)を返します。

#### 引数 {#arguments-70}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryrunnerusagebyprojectfromdate"></a>`fromDate` | [`Date`](#date) | リクエストされた日付フレームの開始日。デフォルトは、カレンダー前月の開始日です。 |
| <a id="queryrunnerusagebyprojectfullpath"></a>`fullPath` | [`ID`](#id) | ジョブを、その属するグループまたはプロジェクトのフルパスに基づいてフィルタリングします。例: `gitlab-org`や`gitlab-org/gitlab`など。これを使用できるのは、管理者と、グループ（グループが指定されている場合）またはプロジェクト（プロジェクトが指定されている場合）のメンテナーロールを付与されているユーザーだけです。最大5,000個の子プロジェクトからのRunnerに制限されています。 |
| <a id="queryrunnerusagebyprojectprojectslimit"></a>`projectsLimit` | [`Int`](#int) | 返すプロジェクトの最大数。その他のプロジェクトは`project: null`エントリに集約されます。指定されていない場合のデフォルトは5です。最大500。 |
| <a id="queryrunnerusagebyprojectrunnertype"></a>`runnerType` | [`CiRunnerType`](#cirunnertype) | ジョブを実行したRunnerのタイプでジョブをフィルタリングします。 |
| <a id="queryrunnerusagebyprojecttodate"></a>`toDate` | [`Date`](#date) | リクエストされた日付フレームの終了日。デフォルトは、カレンダー前月の終了日です。 |

### `Query.runners` {#queryrunners}

GitLabインスタンス（プロジェクトおよび共有）内のすべてのRunnerを取得します。アクセスは、管理者アクセス権を持つユーザーに制限されています。

[`CiRunnerConnection`](#cirunnerconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

#### 引数 {#arguments-71}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryrunnersactive"></a>`active` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | GitLab 14.8で**非推奨**になりました。名前が変更されました。`paused`を使用してください。 |
| <a id="queryrunnerscreatorid"></a>`creatorId` | [`UserID`](#userid) | Runnerを作成者IDでフィルタリングします。 |
| <a id="queryrunnerscreatorusername"></a>`creatorUsername` | [`String`](#string) | Runnerを作成者のユーザー名でフィルタリングします。 |
| <a id="queryrunnersownerfullpath"></a>`ownerFullPath` {{< icon name="warning-solid" >}} | [`String`](#string) | GitLab 17.8で**導入**されました。**状態**: 実験的機能。Runnerを、それを所有するプロジェクトまたはグループでフィルタリングします。 |
| <a id="queryrunnerspaused"></a>`paused` | [`Boolean`](#boolean) | Runnerを`paused`（true）または`active`（false）のステータスによりフィルタリングします。 |
| <a id="queryrunnerssearch"></a>`search` | [`String`](#string) | description（説明）フィールドのフルトークンまたは部分テキストでフィルタリングします。 |
| <a id="queryrunnerssort"></a>`sort` | [`CiRunnerSort`](#cirunnersort) | 結果のソート順。 |
| <a id="queryrunnersstatus"></a>`status` | [`CiRunnerStatus`](#cirunnerstatus) | Runnerをステータスでフィルタリングします。 |
| <a id="queryrunnerstaglist"></a>`tagList` | [`[String!]`](#string) | Runnerに関連するタグでフィルタリングします（カンマ区切りまたは配列）。 |
| <a id="queryrunnerstype"></a>`type` | [`CiRunnerType`](#cirunnertype) | Runnerをタイプでフィルタリングします。 |
| <a id="queryrunnersupgradestatus"></a>`upgradeStatus` | [`CiRunnerUpgradeStatus`](#cirunnerupgradestatus) | アップグレードステータスでフィルタリングします。 |
| <a id="queryrunnersversionprefix"></a>`versionPrefix` | [`String`](#string) | Runnerをバージョンでフィルタリングします。検索語の先頭がバージョンであるRunnerマネージャーを含むRunnerが返されます。たとえば、検索語「14.」は、バージョン「14.11.1」と「14.2.3」のRunnerマネージャーを返します。 |

### `Query.secretPermissions` {#querysecretpermissions}

{{< details >}}GitLab 17.10で**導入**されました。**状態**: 実験的機能。{{< /details >}}

シークレット権限を一覧表示します。

[`SecretPermissionConnection`](#secretpermissionconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

#### 引数 {#arguments-72}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querysecretpermissionsprojectpath"></a>`projectPath` | [`ID!`](#id) | シークレット権限が属するプロジェクト。 |

### `Query.selfManagedAddOnEligibleUsers` {#queryselfmanagedaddoneligibleusers}

{{< details >}} GitLab 16.7で**導入**されました。**状態**: 実験的機能。{{< /details >}}

アドオンの対象となるSelf-Managedインスタンス内のユーザー。

[`AddOnUserConnection`](#addonuserconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

#### 引数 {#arguments-73}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryselfmanagedaddoneligibleusersaddonpurchaseids"></a>`addOnPurchaseIds` | [`[GitlabSubscriptionsAddOnPurchaseID!]!`](#gitlabsubscriptionsaddonpurchaseid) | 割り当てを検索する対象のアドオン購入のグローバルID。 |
| <a id="queryselfmanagedaddoneligibleusersaddontype"></a>`addOnType` | [`GitlabSubscriptionsAddOnType!`](#gitlabsubscriptionsaddontype) | 対象ユーザーのフィルタリングの基準となるアドオンのタイプ。 |
| <a id="queryselfmanagedaddoneligibleusersfilterbyassignedseat"></a>`filterByAssignedSeat` | [`String`](#string) | ユーザーリストを、割り当てられたシートでフィルタリングします。 |
| <a id="queryselfmanagedaddoneligibleuserssearch"></a>`search` | [`String`](#string) | ユーザーリストを検索します。 |
| <a id="queryselfmanagedaddoneligibleuserssort"></a>`sort` | [`GitlabSubscriptionsUserSort`](#gitlabsubscriptionsusersort) | ユーザーリストをソートします。 |

### `Query.selfManagedUsersQueuedForRolePromotion` {#queryselfmanagedusersqueuedforrolepromotion}

Self-Managedインスタンス内でロールプロモーションの承認を保留しているユーザーに関連するフィールド。

[`UsersQueuedForRolePromotionConnection`](#usersqueuedforrolepromotionconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

### `Query.semanticCodeSearch` {#querysemanticcodesearch}

{{< details >}}GitLab 18.4で**導入**されました。**状態**: 実験的機能。{{< /details >}}

指定されたリポジトリ内のコードをセマンティック検索します。

[`[SemanticSearchCode!]`](#semanticsearchcode)を返します。

#### 引数 {#arguments-74}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querysemanticcodesearchknn"></a>`knn` | [`Int`](#int) | KNNカウント。 |
| <a id="querysemanticcodesearchlimit"></a>`limit` | [`Int`](#int) | 返される検索結果の最大数。 |
| <a id="querysemanticcodesearchproject"></a>`project` | [`ProjectInfoInput!`](#projectinfoinput) | オプションのパスプレフィックスを使用して検索するプロジェクト。 |
| <a id="querysemanticcodesearchsearchterm"></a>`searchTerm` | [`String!`](#string) | 検索する検索語。 |

### `Query.snippets` {#querysnippets}

現在のユーザーに表示可能なスニペットを検索します。

[`SnippetConnection`](#snippetconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

#### 引数 {#arguments-75}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querysnippetsauthorid"></a>`authorId` | [`UserID`](#userid) | 作成者のID。 |
| <a id="querysnippetsexplore"></a>`explore` | [`Boolean`](#boolean) | 個人用スニペットを調べます。 |
| <a id="querysnippetsids"></a>`ids` | [`[SnippetID!]`](#snippetid) | グローバルスニペットIDの配列。例: `gid://gitlab/ProjectSnippet/1`。 |
| <a id="querysnippetsprojectid"></a>`projectId` | [`ProjectID`](#projectid) | プロジェクトのID。 |
| <a id="querysnippetstype"></a>`type` | [`TypeEnum`](#typeenum) | スニペットのタイプ。 |
| <a id="querysnippetsvisibility"></a>`visibility` | [`VisibilityScopesEnum`](#visibilityscopesenum) | スニペットの表示レベル。 |

### `Query.standardRole` {#querystandardrole}

{{< details >}}GitLab 17.6で**導入**されました。**状態**: 実験的機能。{{< /details >}}

インスタンスの単一のデフォルトロールを検索します。GitLab Self-Managedでのみ利用可能。

[`StandardRole`](#standardrole)を返します。

#### 引数 {#arguments-76}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querystandardroleaccesslevel"></a>`accessLevel` | [`[MemberAccessLevel!]`](#memberaccesslevel) | フィルタリングの基準となるアクセスレベル。 |

### `Query.standardRoles` {#querystandardroles}

{{< details >}}GitLab 17.3で**導入**されました。**状態**: 実験的機能。{{< /details >}}

インスタンスで利用可能なデフォルトロール。GitLab Self-Managedでのみ利用可能。

[`StandardRoleConnection`](#standardroleconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

#### 引数 {#arguments-77}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querystandardrolesaccesslevel"></a>`accessLevel` | [`[MemberAccessLevel!]`](#memberaccesslevel) | フィルタリングの基準となるアクセスレベル。 |

### `Query.subscriptionFutureEntries` {#querysubscriptionfutureentries}

将来のサブスクリプションのエントリに関連するフィールド。

[`SubscriptionFutureEntryConnection`](#subscriptionfutureentryconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

### `Query.syntheticNote` {#querysyntheticnote}

{{< details >}} GitLab 15.9で**導入**されました。**状態**: 実験的機能。{{< /details >}}

合成ノートを検索します。

[`Note`](#note)を返します。

#### 引数 {#arguments-78}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querysyntheticnotenoteableid"></a>`noteableId` | [`NoteableID!`](#noteableid) | 合成ノートを検索するリソースのグローバルID。 |
| <a id="querysyntheticnotesha"></a>`sha` | [`String!`](#string) | ノートのグローバルID。 |

### `Query.timelogs` {#querytimelogs}

現在のユーザーに表示可能なタイムログを検索します。

[`TimelogConnection`](#timelogconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

#### 引数 {#arguments-79}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querytimelogsenddate"></a>`endDate` | [`Time`](#time) | 日付範囲内のタイムログのうち、記録された日付がendDate以前であるものを一覧表示します。 |
| <a id="querytimelogsendtime"></a>`endTime` | [`Time`](#time) | 時刻範囲内のタイムログのうち、記録された時刻がendTime以前であるものを一覧表示します。 |
| <a id="querytimelogsgroupid"></a>`groupId` | [`GroupID`](#groupid) | グループのタイムログを一覧表示します。 |
| <a id="querytimelogsprojectid"></a>`projectId` | [`ProjectID`](#projectid) | プロジェクトのタイムログを一覧表示します。 |
| <a id="querytimelogssort"></a>`sort` | [`TimelogSort`](#timelogsort) | タイムログを特定の順序で一覧表示します。 |
| <a id="querytimelogsstartdate"></a>`startDate` | [`Time`](#time) | 日付範囲内のタイムログのうち、ログに記録された日付がstartDate以後であるものを一覧表示します。 |
| <a id="querytimelogsstarttime"></a>`startTime` | [`Time`](#time) | 時刻範囲内のタイムログのうち、ログに記録された時刻がstartTime以後であるものを一覧表示します。 |
| <a id="querytimelogsusername"></a>`username` | [`String`](#string) | ユーザーのタイムログを一覧表示します。 |

### `Query.todo` {#querytodo}

単一のTo Doアイテムを取得します。

[`Todo`](#todo)を返します。

#### 引数 {#arguments-80}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querytodoid"></a>`id` | [`TodoID!`](#todoid) | To DoアイテムのID。 |

### `Query.topics` {#querytopics}

プロジェクトのトピックを検索します。

[`TopicConnection`](#topicconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

#### 引数 {#arguments-81}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querytopicsorganizationid"></a>`organizationId` {{< icon name="warning-solid" >}} | [`OrganizationsOrganizationID`](#organizationsorganizationid) | GitLab 17.7で**導入**されました。**状態**: 実験的機能。組織のグローバルID。 |
| <a id="querytopicssearch"></a>`search` | [`String`](#string) | トピック名を検索するクエリ。 |

### `Query.usageTrendsMeasurements` {#queryusagetrendsmeasurements}

インスタンスの統計を取得します。

[`UsageTrendsMeasurementConnection`](#usagetrendsmeasurementconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

#### 引数 {#arguments-82}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryusagetrendsmeasurementsidentifier"></a>`identifier` | [`MeasurementIdentifier!`](#measurementidentifier) | 取得する測定または統計のタイプ。 |
| <a id="queryusagetrendsmeasurementsrecordedafter"></a>`recordedAfter` | [`Time`](#time) | この日付より後に記録された測定。 |
| <a id="queryusagetrendsmeasurementsrecordedbefore"></a>`recordedBefore` | [`Time`](#time) | この日付より前に記録された測定。 |

### `Query.user` {#queryuser}

ユーザーを検索します。

[`UserCore`](#usercore)を返します。

#### 引数 {#arguments-83}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryuserid"></a>`id` | [`UserID`](#userid) | ユーザーのID。 |
| <a id="queryuserusername"></a>`username` | [`String`](#string) | ユーザーのユーザー名。 |

### `Query.users` {#queryusers}

ユーザーを検索します。

[`UserCoreConnection`](#usercoreconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

#### 引数 {#arguments-84}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryusersactive"></a>`active` | [`Boolean`](#boolean) | アクティブユーザーでフィルタリングします。trueの場合、アクティブユーザーを返します。falseの場合、非アクティブユーザーを返します。 |
| <a id="queryusersadmins"></a>`admins` | [`Boolean`](#boolean) | 管理者ユーザーのみを返します。 |
| <a id="queryusersgroupid"></a>`groupId` | [`GroupID`](#groupid) | 特定のグループのメンバーであるユーザーを返します。 |
| <a id="queryusershumans"></a>`humans` | [`Boolean`](#boolean) | 標準ユーザーでフィルタリングします。trueの場合、ボットでも内部ユーザーでもないユーザーのみを返します。falseの場合、ボットまたは内部ユーザーであるユーザーのみを返します。 |
| <a id="queryusersids"></a>`ids` | [`[ID!]`](#id) | ユーザーのグローバルIDのリスト。 |
| <a id="queryuserssearch"></a>`search` | [`String`](#string) | 名前、ユーザー名、またはプライマリメールでユーザーを検索するクエリ。 |
| <a id="queryuserssort"></a>`sort` | [`Sort`](#sort) | 条件でユーザーをソートします。 |
| <a id="queryusersusertypes"></a>`userTypes` {{< icon name="warning-solid" >}} | [`[UserType!]`](#usertype) | GitLab 18.3で**導入**されました。**状態**: 実験的機能。ユーザータイプでフィルタリングします。 |
| <a id="queryusersusernames"></a>`usernames` | [`[String!]`](#string) | ユーザー名のリスト。 |

### `Query.vulnerabilities` {#queryvulnerabilities}

現在のユーザーのインスタンスセキュリティダッシュボードのプロジェクトで報告された脆弱性。

[`VulnerabilityConnection`](#vulnerabilityconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

#### 引数 {#arguments-85}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryvulnerabilitiesclusteragentid"></a>`clusterAgentId` | [`[ClustersAgentID!]`](#clustersagentid) | 脆弱性を`cluster_agent_id`でフィルタリングします。このフィルターで含められるのは、`reportType`が`cluster_image_scanning`の脆弱性だけです。 |
| <a id="queryvulnerabilitiesclusterid"></a>`clusterId` | [`[ClustersClusterID!]`](#clustersclusterid) | 脆弱性を`cluster_id`でフィルタリングします。このフィルターで含められるのは、`reportType`が`cluster_image_scanning`の脆弱性だけです。 |
| <a id="queryvulnerabilitiesdismissalreason"></a>`dismissalReason` | [`[VulnerabilityDismissalReason!]`](#vulnerabilitydismissalreason) | 却下理由でフィルタリングします。このフィルターで含められるのは、却下された脆弱性だけです。 |
| <a id="queryvulnerabilitieshasairesolution"></a>`hasAiResolution` | [`Boolean`](#boolean) | GitLab Duo脆弱性の修正で解決できる可能性が高い脆弱性のみを返します。 |
| <a id="queryvulnerabilitieshasissues"></a>`hasIssues` | [`Boolean`](#boolean) | リンクされたイシューがある脆弱性のみを返します。 |
| <a id="queryvulnerabilitieshasmergerequest"></a>`hasMergeRequest` | [`Boolean`](#boolean) | リンクされているマージリクエストがある脆弱性のみを返します。 |
| <a id="queryvulnerabilitieshasremediations"></a>`hasRemediations` | [`Boolean`](#boolean) | 修正がある脆弱性のみを返します。 |
| <a id="queryvulnerabilitieshasresolution"></a>`hasResolution` | [`Boolean`](#boolean) | デフォルトブランチで解決された脆弱性のみを返します。 |
| <a id="queryvulnerabilitiesidentifiername"></a>`identifierName` | [`String`](#string) | 脆弱性を識別子の名前でフィルタリングします。インスタンスセキュリティダッシュボードのクエリに適用した場合、無視されます。 |
| <a id="queryvulnerabilitiesimage"></a>`image` | [`[String!]`](#string) | 脆弱性をロケーションイメージでフィルタリングします。このフィルターが存在する場合、レスポンスは`container_scanning`、`cluster_image_scanning`を含む`reportType`のエントリのみと一致します。 |
| <a id="queryvulnerabilitiesowasptopten"></a>`owaspTopTen` | [`[VulnerabilityOwaspTop10!]`](#vulnerabilityowasptop10) | 脆弱性をOWASP Top 10 2017カテゴリでフィルタリングします。ワイルドカード値`NONE`もサポートされていますが、他のOWASP Top 10値と組み合わせることはできません。 |
| <a id="queryvulnerabilitiesowasptopten2021"></a>`owaspTopTen2021` {{< icon name="warning-solid" >}} | [`[VulnerabilityOwasp2021Top10!]`](#vulnerabilityowasp2021top10) | GitLab 18.1で**導入**されました。**状態**: 実験的機能。脆弱性をOWASP Top 10 2021カテゴリでフィルタリングします。ワイルドカード値`NONE`もサポートされていますが、他のOWASP Top 10 2021値と組み合わせることはできません。この引数を使用するには、Elasticsearchが設定され、`advanced_vulnerability_management`機能フラグが有効になっている必要があります。インスタンスセキュリティダッシュボードクエリではサポートされていません。 |
| <a id="queryvulnerabilitiesprojectid"></a>`projectId` | [`[ID!]`](#id) | 脆弱性をプロジェクトでフィルタリングします。 |
| <a id="queryvulnerabilitiesreachability"></a>`reachability` {{< icon name="warning-solid" >}} | [`ReachabilityType`](#reachabilitytype) | GitLab 18.2で**導入**されました。**状態**: 実験的機能。到達可能性で脆弱性をフィルタリングします。 |
| <a id="queryvulnerabilitiesreporttype"></a>`reportType` | [`[VulnerabilityReportType!]`](#vulnerabilityreporttype) | 脆弱性をレポートタイプでフィルタリングします。 |
| <a id="queryvulnerabilitiesscanner"></a>`scanner` | [`[String!]`](#string) | 脆弱性をVulnerabilityScanner.externalIdでフィルタリングします。 |
| <a id="queryvulnerabilitiesscannerid"></a>`scannerId` | [`[VulnerabilitiesScannerID!]`](#vulnerabilitiesscannerid) | 脆弱性をスキャナーIDでフィルタリングします。 |
| <a id="queryvulnerabilitiesseverity"></a>`severity` | [`[VulnerabilitySeverity!]`](#vulnerabilityseverity) | 脆弱性を重大度でフィルタリングします。 |
| <a id="queryvulnerabilitiessort"></a>`sort` | [`VulnerabilitySort`](#vulnerabilitysort) | 脆弱性をソート順で一覧表示します。 |
| <a id="queryvulnerabilitiesstate"></a>`state` | [`[VulnerabilityState!]`](#vulnerabilitystate) | 脆弱性を状態でフィルタリングします。 |

### `Query.vulnerabilitiesCountByDay` {#queryvulnerabilitiescountbyday}

現在のユーザーのインスタンスセキュリティダッシュボードのプロジェクトに対する1日あたりの脆弱性履歴数。

[`VulnerabilitiesCountByDayConnection`](#vulnerabilitiescountbydayconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

#### 引数 {#arguments-86}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryvulnerabilitiescountbydayenddate"></a>`endDate` | [`ISO8601Date!`](#iso8601date) | 脆弱性の履歴をフェッチする対象となる最後の日付。 |
| <a id="queryvulnerabilitiescountbydaystartdate"></a>`startDate` | [`ISO8601Date!`](#iso8601date) | 脆弱性の履歴をフェッチする対象となる最初の日付。 |

### `Query.vulnerability` {#queryvulnerability}

脆弱性を検索します。

[`Vulnerability`](#vulnerability)を返します。

#### 引数 {#arguments-87}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryvulnerabilityid"></a>`id` | [`VulnerabilityID!`](#vulnerabilityid) | 脆弱性のグローバルID。 |

### `Query.wikiPage` {#querywikipage}

{{< details >}}GitLab 17.6で**導入**されました。**状態**: 実験的機能。{{< /details >}}

Wikiページを検索します。

[`WikiPage`](#wikipage)を返します。

#### 引数 {#arguments-88}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="querywikipagenamespaceid"></a>`namespaceId` | [`NamespaceID`](#namespaceid) | WikiページのネームスペースID。 |
| <a id="querywikipageprojectid"></a>`projectId` | [`ProjectID`](#projectid) | WikiページのプロジェクトID。 |
| <a id="querywikipageslug"></a>`slug` | [`String`](#string) | Wikiページのslug。 |

### `Query.workItem` {#queryworkitem}

{{< details >}}GitLab 15.1で**導入**されました。**状態**: 実験的機能。{{< /details >}}

作業アイテムを検索します。

[`WorkItem`](#workitem)を返します。

#### 引数 {#arguments-89}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryworkitemid"></a>`id` | [`WorkItemID!`](#workitemid) | 作業アイテムのグローバルID。 |

### `Query.workItemAllowedStatuses` {#queryworkitemallowedstatuses}

{{< details >}}GitLab 18.4で**導入**されました。**状態**: 実験的機能。{{< /details >}}

現在のユーザーが所属するルートグループで許可されている作業項目の状態。

[`WorkItemStatusConnection`](#workitemstatusconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

#### 引数 {#arguments-90}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryworkitemallowedstatusesname"></a>`name` | [`String`](#string) | 名前で状態をフィルタリングします。 |

### `Query.workItemDescriptionTemplateContent` {#queryworkitemdescriptiontemplatecontent}

{{< details >}}GitLab 17.9で**導入**されました。**状態**: 実験的機能。{{< /details >}}

作業アイテムの説明テンプレートを検索します。

[`WorkItemDescriptionTemplate`](#workitemdescriptiontemplate)を返します。

#### 引数 {#arguments-91}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryworkitemdescriptiontemplatecontenttemplatecontentinput"></a>`templateContentInput` | [`WorkItemDescriptionTemplateContentInput!`](#workitemdescriptiontemplatecontentinput) | 特定の説明テンプレートをフェッチするためのインプット。 |

### `Query.workItemsByReference` {#queryworkitemsbyreference}

{{< details >}} GitLab 16.7で**導入**されました。**状態**: 実験的機能。{{< /details >}}

作業アイテムを参照によって検索します。

[`WorkItemConnection`](#workitemconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

#### 引数 {#arguments-92}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryworkitemsbyreferencecontextnamespacepath"></a>`contextNamespacePath` | [`ID`](#id) | コンテキストネームスペース（プロジェクトまたはグループ）のフルパス。 |
| <a id="queryworkitemsbyreferencerefs"></a>`refs` | [`[String!]!`](#string) | 作業アイテムの参照。短い参照またはURLのいずれかを指定できます。 |

### `Query.workspace` {#queryworkspace}

ワークスペースを検索します。

[`Workspace`](#workspace)を返します。

#### 引数 {#arguments-93}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryworkspaceid"></a>`id` | [`RemoteDevelopmentWorkspaceID!`](#remotedevelopmentworkspaceid) | ワークスペースをIDで検索します。 |

### `Query.workspaces` {#queryworkspaces}

インスタンス全体でワークスペースを検索します。このフィールドはインスタンス管理者のみが使用できます。管理者以外のすべてのユーザーには空の結果が返されます。

[`WorkspaceConnection`](#workspaceconnection)を返します。

このフィールドは[接続](#connections)を返します。`before: String`、`after: String`、`first: Int`、`last: Int`の4つを、標準[ページネーション](#pagination-arguments)引数として受け入れます。

#### 引数 {#arguments-94}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="queryworkspacesactualstates"></a>`actualStates` | [`[String!]`](#string) | ワークスペースを実際の状態でフィルタリングします。 |
| <a id="queryworkspacesagentids"></a>`agentIds` | [`[ClustersAgentID!]`](#clustersagentid) | ワークスペースをエージェントのグローバルIDでフィルタリングします。 |
| <a id="queryworkspacesids"></a>`ids` | [`[RemoteDevelopmentWorkspaceID!]`](#remotedevelopmentworkspaceid) | ワークスペースをワークスペースのグローバルIDでフィルタリングします。例: `["gid://gitlab/RemoteDevelopment::Workspace/1"]`。 |
| <a id="queryworkspacesincludeactualstates"></a>`includeActualStates` {{< icon name="warning-solid" >}} | [`[String!]`](#string) | GitLab 16.7で**非推奨**になりました。代わりにactual_statesを使用してください。 |
| <a id="queryworkspacesprojectids"></a>`projectIds` | [`[ProjectID!]`](#projectid) | ワークスペースをプロジェクトのグローバルIDでフィルタリングします。 |
| <a id="queryworkspacesuserids"></a>`userIds` | [`[ProjectID!]`](#projectid) | ワークスペースをユーザーのグローバルIDでフィルタリングします。 |

## `Mutation`type {#mutation-type}

`Mutation`型には、実行できるすべてのミューテーションが含まれています。

どのミューテーションも、`input`という名前の単一のインプットオブジェクトで引数を受け取ります。どのミューテーションでも、少なくとも、エラーメッセージのリストを含む戻りフィールド`errors`をサポートしています。

どのインプットオブジェクトについても、ミューテーションを識別する`clientMutationId: String`フィールドが含まれる可能性があります。

次に例を示します。

```graphql
mutation($id: NoteableID!, $body: String!) {
  createNote(input: { noteableId: $id, body: $body }) {
    errors
  }
}
```

### `Mutation.abuseReportLabelCreate` {#mutationabusereportlabelcreate}

{{< details >}}GitLab 16.4で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `AbuseReportLabelCreateInput`

#### 引数 {#arguments-95}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationabusereportlabelcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationabusereportlabelcreatecolor"></a>`color` | [`String`](#string) | ラベルの色。先頭が「#」記号の6桁の16進数表記（`#FFAABB`など）か、またはCSSカラー名のいずれかで指定。 |
| <a id="mutationabusereportlabelcreatetitle"></a>`title` | [`String!`](#string) | ラベルのタイトル。 |

#### フィールド {#fields}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationabusereportlabelcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationabusereportlabelcreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationabusereportlabelcreatelabel"></a>`label` | [`AbuseReportLabel`](#abusereportlabel) | ミューテーション後のラベル。 |

### `Mutation.achievementsAward` {#mutationachievementsaward}

{{< details >}}GitLab 15.10で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `AchievementsAwardInput`

#### 引数 {#arguments-96}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationachievementsawardachievementid"></a>`achievementId` | [`AchievementsAchievementID!`](#achievementsachievementid) | 授与されるアチーブメントのグローバルID。 |
| <a id="mutationachievementsawardclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationachievementsawarduserid"></a>`userId` | [`UserID!`](#userid) | アチーブメントを授与されるユーザーのグローバルID。 |

#### フィールド {#fields-1}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationachievementsawardclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationachievementsawarderrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationachievementsawarduserachievement"></a>`userAchievement` | [`UserAchievement`](#userachievement) | アチーブメントの授与。 |

### `Mutation.achievementsCreate` {#mutationachievementscreate}

{{< details >}}GitLab 15.8で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `AchievementsCreateInput`

#### 引数 {#arguments-97}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationachievementscreateavatar"></a>`avatar` | [`Upload`](#upload) | アチーブメントのアバター。 |
| <a id="mutationachievementscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationachievementscreatedescription"></a>`description` | [`String`](#string) | アチーブメントの説明またはノート。 |
| <a id="mutationachievementscreatename"></a>`name` | [`String!`](#string) | アチーブメントの名前。 |
| <a id="mutationachievementscreatenamespaceid"></a>`namespaceId` | [`NamespaceID!`](#namespaceid) | アチーブメントのネームスペース。 |

#### フィールド {#fields-2}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationachievementscreateachievement"></a>`achievement` | [`Achievement`](#achievement) | 作成されたアチーブメント。 |
| <a id="mutationachievementscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationachievementscreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.achievementsDelete` {#mutationachievementsdelete}

{{< details >}}GitLab 15.11で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `AchievementsDeleteInput`

#### 引数 {#arguments-98}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationachievementsdeleteachievementid"></a>`achievementId` | [`AchievementsAchievementID!`](#achievementsachievementid) | 削除するアチーブメントのグローバルID。 |
| <a id="mutationachievementsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |

#### フィールド {#fields-3}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationachievementsdeleteachievement"></a>`achievement` | [`Achievement`](#achievement) | アチーブメント。 |
| <a id="mutationachievementsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationachievementsdeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.achievementsRevoke` {#mutationachievementsrevoke}

{{< details >}}GitLab 15.10で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `AchievementsRevokeInput`

#### 引数 {#arguments-99}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationachievementsrevokeclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationachievementsrevokeuserachievementid"></a>`userAchievementId` | [`AchievementsUserAchievementID!`](#achievementsuserachievementid) | 取り消すユーザーアチーブメントのグローバルID。 |

#### フィールド {#fields-4}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationachievementsrevokeclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationachievementsrevokeerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationachievementsrevokeuserachievement"></a>`userAchievement` | [`UserAchievement`](#userachievement) | アチーブメントの授与。 |

### `Mutation.achievementsUpdate` {#mutationachievementsupdate}

{{< details >}}GitLab 15.11で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `AchievementsUpdateInput`

#### 引数 {#arguments-100}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationachievementsupdateachievementid"></a>`achievementId` | [`AchievementsAchievementID!`](#achievementsachievementid) | 更新対象のアチーブメントのグローバルID。 |
| <a id="mutationachievementsupdateavatar"></a>`avatar` | [`Upload`](#upload) | アチーブメントのアバター。 |
| <a id="mutationachievementsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationachievementsupdatedescription"></a>`description` | [`String`](#string) | アチーブメントの説明またはノート。 |
| <a id="mutationachievementsupdatename"></a>`name` | [`String`](#string) | アチーブメントの名前。 |

#### フィールド {#fields-5}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationachievementsupdateachievement"></a>`achievement` | [`Achievement`](#achievement) | アチーブメント。 |
| <a id="mutationachievementsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationachievementsupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.addProjectToSecurityDashboard` {#mutationaddprojecttosecuritydashboard}

入力型: `AddProjectToSecurityDashboardInput`

#### 引数 {#arguments-101}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaddprojecttosecuritydashboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaddprojecttosecuritydashboardid"></a>`id` | [`ProjectID!`](#projectid) | インスタンスセキュリティダッシュボードに追加するプロジェクトのID。 |

#### フィールド {#fields-6}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaddprojecttosecuritydashboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaddprojecttosecuritydashboarderrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationaddprojecttosecuritydashboardproject"></a>`project` | [`Project`](#project) | インスタンスセキュリティダッシュボードに追加されたプロジェクト。 |

### `Mutation.adminRolesLdapSync` {#mutationadminrolesldapsync}

{{< details >}}GitLab 18.0で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `AdminRolesLdapSyncInput`

#### 引数 {#arguments-102}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationadminrolesldapsyncclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |

#### フィールド {#fields-7}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationadminrolesldapsyncclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationadminrolesldapsyncerrors"></a>`errors` | [`[String!]`](#string) | オペレーション中に発生したエラー。 |
| <a id="mutationadminrolesldapsyncsuccess"></a>`success` | [`Boolean`](#boolean) | 同期が正常にエンキューされたかどうか。 |

### `Mutation.adminSidekiqQueuesDeleteJobs` {#mutationadminsidekiqqueuesdeletejobs}

入力型: `AdminSidekiqQueuesDeleteJobsInput`

#### 引数 {#arguments-103}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationadminsidekiqqueuesdeletejobsairesource"></a>`aiResource` | [`String`](#string) | コンテキストメタデータ内のai_resourceに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobsartifactsize"></a>`artifactSize` | [`String`](#string) | コンテキストメタデータ内のartifact_sizeに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobsartifactusedcdn"></a>`artifactUsedCdn` | [`String`](#string) | コンテキストメタデータ内のartifact_used_cdnに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobsartifactsdependenciescount"></a>`artifactsDependenciesCount` | [`String`](#string) | コンテキストメタデータ内のartifacts_dependencies_countに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobsartifactsdependenciessize"></a>`artifactsDependenciesSize` | [`String`](#string) | コンテキストメタデータ内のartifacts_dependencies_sizeに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobsbulkimportentityid"></a>`bulkImportEntityId` | [`String`](#string) | コンテキストメタデータ内のbulk_import_entity_idに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobscallerid"></a>`callerId` | [`String`](#string) | コンテキストメタデータ内のcaller_idに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobsclientid"></a>`clientId` | [`String`](#string) | コンテキストメタデータ内のclient_idに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobsclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationadminsidekiqqueuesdeletejobsfeaturecategory"></a>`featureCategory` | [`String`](#string) | コンテキストメタデータ内のfeature_categoryに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobsjobid"></a>`jobId` | [`String`](#string) | コンテキストメタデータ内のjob_idに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobskubernetesagentid"></a>`kubernetesAgentId` | [`String`](#string) | コンテキストメタデータ内のkubernetes_agent_idに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobsmergeactionstatus"></a>`mergeActionStatus` | [`String`](#string) | コンテキストメタデータ内のmerge_action_statusに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobsorganizationid"></a>`organizationId` | [`String`](#string) | コンテキストメタデータ内のorganization_idに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobspipelineid"></a>`pipelineId` | [`String`](#string) | コンテキストメタデータ内のpipeline_idに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobspolicysyncconfigid"></a>`policySyncConfigId` | [`String`](#string) | コンテキストメタデータ内のpolicy_sync_config_idに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobsproject"></a>`project` | [`String`](#string) | コンテキストメタデータ内のprojectに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobsqueuename"></a>`queueName` | [`String!`](#string) | ジョブを削除する元のキューの名前。 |
| <a id="mutationadminsidekiqqueuesdeletejobsrelatedclass"></a>`relatedClass` | [`String`](#string) | コンテキストメタデータ内のrelated_classに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobsremoteip"></a>`remoteIp` | [`String`](#string) | コンテキストメタデータ内のremote_ipに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobsrootcallerid"></a>`rootCallerId` | [`String`](#string) | コンテキストメタデータ内のroot_caller_idに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobsrootnamespace"></a>`rootNamespace` | [`String`](#string) | コンテキストメタデータ内のroot_namespaceに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobsscopeduser"></a>`scopedUser` | [`String`](#string) | コンテキストメタデータ内のscoped_userに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobsscopeduserid"></a>`scopedUserId` | [`String`](#string) | コンテキストメタデータ内のscoped_user_idに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobssidekiqdestinationshardredis"></a>`sidekiqDestinationShardRedis` | [`String`](#string) | コンテキストメタデータ内のsidekiq_destination_shard_redisに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobssubscriptionplan"></a>`subscriptionPlan` | [`String`](#string) | コンテキストメタデータ内のsubscription_planに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobsuser"></a>`user` | [`String`](#string) | コンテキストメタデータ内のuserに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobsuserid"></a>`userId` | [`String`](#string) | コンテキストメタデータ内のuser_idに一致するジョブを削除します。 |
| <a id="mutationadminsidekiqqueuesdeletejobsworkerclass"></a>`workerClass` | [`String`](#string) | 指定されたワーカークラスのジョブを削除します。 |

#### フィールド {#fields-8}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationadminsidekiqqueuesdeletejobsclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationadminsidekiqqueuesdeletejobserrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationadminsidekiqqueuesdeletejobsresult"></a>`result` | [`DeleteJobsResponse`](#deletejobsresponse) | 削除リクエストのステータスに関する情報。 |

### `Mutation.aiAction` {#mutationaiaction}

{{< details >}}GitLab 15.11で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `AiActionInput`

#### 引数 {#arguments-104}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaiactionagenticchat"></a>`agenticChat` | [`AiAgenticChatInput`](#aiagenticchatinput) | agentic_chat AIアクションのインプット。 |
| <a id="mutationaiactionchat"></a>`chat` | [`AiChatInput`](#aichatinput) | チャットAIアクションのインプット。 |
| <a id="mutationaiactionclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaiactionclientsubscriptionid"></a>`clientSubscriptionId` | [`String`](#string) | ミューテーションのレスポンスを受信するためにサブスクライブできる、クライアントによって生成されたID。 |
| <a id="mutationaiactionconversationtype"></a>`conversationType` | [`AiConversationsThreadsConversationType`](#aiconversationsthreadsconversationtype) | スレッドの会話タイプ。 |
| <a id="mutationaiactiondescriptioncomposer"></a>`descriptionComposer` | [`AiDescriptionComposerInput`](#aidescriptioncomposerinput) | description_composer AIアクションのインプット。 |
| <a id="mutationaiactionexplainvulnerability"></a>`explainVulnerability` | [`AiExplainVulnerabilityInput`](#aiexplainvulnerabilityinput) | explain_vulnerability AIアクションのインプット。 |
| <a id="mutationaiactiongeneratecommitmessage"></a>`generateCommitMessage` | [`AiGenerateCommitMessageInput`](#aigeneratecommitmessageinput) | generate_commit_message AIアクションのインプット。 |
| <a id="mutationaiactiongeneratedescription"></a>`generateDescription` | [`AiGenerateDescriptionInput`](#aigeneratedescriptioninput) | generate_description AIアクションのインプット。 |
| <a id="mutationaiactionmeasurecommenttemperature"></a>`measureCommentTemperature` | [`AiMeasureCommentTemperatureInput`](#aimeasurecommenttemperatureinput) | measure_comment_temperature AIアクションのインプット。 |
| <a id="mutationaiactionplatformorigin"></a>`platformOrigin` | [`String`](#string) | リクエストのoriginプラットフォームを指定します。 |
| <a id="mutationaiactionprojectid"></a>`projectId` | [`ProjectID`](#projectid) | ユーザー操作の対象となるプロジェクトのグローバルID。 |
| <a id="mutationaiactionresolvevulnerability"></a>`resolveVulnerability` | [`AiResolveVulnerabilityInput`](#airesolvevulnerabilityinput) | resolve_vulnerability AIアクションのインプット。 |
| <a id="mutationaiactionrootnamespaceid"></a>`rootNamespaceId` | [`NamespaceID`](#namespaceid) | ユーザー操作の対象となるトップレベルのネームスペースのグローバルID。 |
| <a id="mutationaiactionsummarizenewmergerequest"></a>`summarizeNewMergeRequest` | [`AiSummarizeNewMergeRequestInput`](#aisummarizenewmergerequestinput) | summarize_new_merge_request AIアクションのインプット。 |
| <a id="mutationaiactionsummarizereview"></a>`summarizeReview` | [`AiSummarizeReviewInput`](#aisummarizereviewinput) | summarize_review AIアクションのインプット。 |
| <a id="mutationaiactionthreadid"></a>`threadId` | [`AiConversationThreadID`](#aiconversationthreadid) | 会話を継続する既存スレッドのグローバルID。指定されていない場合、指定されたconversation_typeのための新しいスレッドが作成されます。 |

#### フィールド {#fields-9}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaiactionclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaiactionerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationaiactionrequestid"></a>`requestId` | [`String`](#string) | リクエストのID。 |
| <a id="mutationaiactionthreadid"></a>`threadId` | [`AiConversationThreadID`](#aiconversationthreadid) | スレッドのグローバルID。 |

### `Mutation.aiAgentCreate` {#mutationaiagentcreate}

{{< details >}}GitLab 16.8で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `AiAgentCreateInput`

#### 引数 {#arguments-105}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaiagentcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaiagentcreatename"></a>`name` | [`String!`](#string) | エージェントの名前。 |
| <a id="mutationaiagentcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | エージェントが属するプロジェクト。 |
| <a id="mutationaiagentcreateprompt"></a>`prompt` | [`String!`](#string) | エージェントのプロンプト。 |

#### フィールド {#fields-10}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaiagentcreateagent"></a>`agent` | [`AiAgent`](#aiagent) | ミューテーション後のエージェント。 |
| <a id="mutationaiagentcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaiagentcreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.aiAgentDestroy` {#mutationaiagentdestroy}

{{< details >}}GitLab 16.11で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `AiAgentDestroyInput`

#### 引数 {#arguments-106}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaiagentdestroyagentid"></a>`agentId` | [`AiAgentID!`](#aiagentid) | 削除するAIエージェントのグローバルID。 |
| <a id="mutationaiagentdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaiagentdestroyprojectpath"></a>`projectPath` | [`ID!`](#id) | エージェントが属するプロジェクト。 |

#### フィールド {#fields-11}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaiagentdestroyagent"></a>`agent` | [`AiAgent`](#aiagent) | ミューテーション後のエージェント。 |
| <a id="mutationaiagentdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaiagentdestroyerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationaiagentdestroymessage"></a>`message` | [`String`](#string) | AIエージェント削除の結果メッセージ。 |

### `Mutation.aiAgentUpdate` {#mutationaiagentupdate}

{{< details >}}GitLab 16.10で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `AiAgentUpdateInput`

#### 引数 {#arguments-107}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaiagentupdateagentid"></a>`agentId` | [`AiAgentID!`](#aiagentid) | エージェントのID。 |
| <a id="mutationaiagentupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaiagentupdatename"></a>`name` | [`String`](#string) | エージェントの名前。 |
| <a id="mutationaiagentupdateprojectpath"></a>`projectPath` | [`ID!`](#id) | エージェントが属するプロジェクト。 |
| <a id="mutationaiagentupdateprompt"></a>`prompt` | [`String`](#string) | エージェントのプロンプト。 |

#### フィールド {#fields-12}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaiagentupdateagent"></a>`agent` | [`AiAgent`](#aiagent) | ミューテーション後のエージェント。 |
| <a id="mutationaiagentupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaiagentupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.aiCatalogAgentCreate` {#mutationaicatalogagentcreate}

{{< details >}}GitLab 18.2で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `AiCatalogAgentCreateInput`

#### 引数 {#arguments-108}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogagentcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaicatalogagentcreatedescription"></a>`description` | [`String!`](#string) | エージェントの説明。 |
| <a id="mutationaicatalogagentcreatename"></a>`name` | [`String!`](#string) | エージェントの名前。 |
| <a id="mutationaicatalogagentcreateprojectid"></a>`projectId` | [`ProjectID!`](#projectid) | エージェントのプロジェクト。 |
| <a id="mutationaicatalogagentcreatepublic"></a>`public` | [`Boolean!`](#boolean) | エージェントがカタログで公開されているかどうか。 |
| <a id="mutationaicatalogagentcreaterelease"></a>`release` | [`Boolean`](#boolean) | エージェントの最新バージョンをリリースするかどうか。 |
| <a id="mutationaicatalogagentcreatesystemprompt"></a>`systemPrompt` | [`String!`](#string) | エージェントのシステムプロンプト。 |
| <a id="mutationaicatalogagentcreatetools"></a>`tools` | [`[AiCatalogBuiltInToolID!]`](#aicatalogbuiltintoolid) | エージェントに対して有効になっているGitLabツールのリスト。 |
| <a id="mutationaicatalogagentcreateuserprompt"></a>`userPrompt` | [`String!`](#string) | エージェントのユーザープロンプト。 |

#### フィールド {#fields-13}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogagentcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaicatalogagentcreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationaicatalogagentcreateitem"></a>`item` | [`AiCatalogAgent`](#aicatalogagent) | 項目が作成されました。 |

### `Mutation.aiCatalogAgentDelete` {#mutationaicatalogagentdelete}

{{< details >}}GitLab 18.2で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `AiCatalogAgentDeleteInput`

#### 引数 {#arguments-109}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogagentdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaicatalogagentdeleteid"></a>`id` | [`AiCatalogItemID!`](#aicatalogitemid) | 削除するカタログエージェントのグローバルID。 |

#### フィールド {#fields-14}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogagentdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaicatalogagentdeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationaicatalogagentdeletesuccess"></a>`success` | [`Boolean!`](#boolean) | カタログエージェントが正常に削除された場合はtrueを返します。 |

### `Mutation.aiCatalogAgentExecute` {#mutationaicatalogagentexecute}

{{< details >}}GitLab 18.3で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `AiCatalogAgentExecuteInput`

#### 引数 {#arguments-110}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogagentexecuteagentid"></a>`agentId` | [`AiCatalogItemID!`](#aicatalogitemid) | 実行するAIカタログエージェントのグローバルID。 |
| <a id="mutationaicatalogagentexecuteagentversionid"></a>`agentVersionId` | [`AiCatalogItemVersionID`](#aicatalogitemversionid) | 使用する特定のエージェントバージョンのグローバルID。指定されていない場合は、最新バージョンが使用されます。 |
| <a id="mutationaicatalogagentexecuteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaicatalogagentexecuteuserprompt"></a>`userPrompt` | [`String`](#string) | オプションのユーザープロンプト。指定されている場合は、エージェントの実行に使用されます。それ以外の場合は、データベースに保存されているuser_promptが使用されます。 |

#### フィールド {#fields-15}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogagentexecuteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaicatalogagentexecuteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationaicatalogagentexecuteflowconfig"></a>`flowConfig` | [`String`](#string) | フロー実行のためにGitLab Duo Workflowサービスで使用できるYAML設定。 |
| <a id="mutationaicatalogagentexecuteworkflow"></a>`workflow` | [`DuoWorkflow`](#duoworkflow) | 作成されたワークフロー。 |

### `Mutation.aiCatalogAgentUpdate` {#mutationaicatalogagentupdate}

{{< details >}}GitLab 18.3で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `AiCatalogAgentUpdateInput`

#### 引数 {#arguments-111}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogagentupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaicatalogagentupdatedescription"></a>`description` | [`String`](#string) | エージェントの説明。 |
| <a id="mutationaicatalogagentupdateid"></a>`id` | [`AiCatalogItemID!`](#aicatalogitemid) | 更新するカタログエージェントのグローバルID。 |
| <a id="mutationaicatalogagentupdatename"></a>`name` | [`String`](#string) | エージェントの名前。 |
| <a id="mutationaicatalogagentupdatepublic"></a>`public` | [`Boolean`](#boolean) | エージェントがカタログで公開されているかどうか。 |
| <a id="mutationaicatalogagentupdaterelease"></a>`release` | [`Boolean`](#boolean) | エージェントの最新バージョンをリリースするかどうか。 |
| <a id="mutationaicatalogagentupdatesystemprompt"></a>`systemPrompt` | [`String`](#string) | エージェントのシステムプロンプト。 |
| <a id="mutationaicatalogagentupdatetools"></a>`tools` | [`[AiCatalogBuiltInToolID!]`](#aicatalogbuiltintoolid) | エージェントに対して有効になっているGitLabツールのリスト。 |
| <a id="mutationaicatalogagentupdateuserprompt"></a>`userPrompt` | [`String`](#string) | エージェントのユーザープロンプト。 |
| <a id="mutationaicatalogagentupdateversionbump"></a>`versionBump` | [`AiCatalogVersionBump`](#aicatalogversionbump) | 最後にリリースされたバージョン名から算出されたバージョンを更新する。 |

#### フィールド {#fields-16}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogagentupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaicatalogagentupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationaicatalogagentupdateitem"></a>`item` | [`AiCatalogAgent`](#aicatalogagent) | 更新されたエージェント。 |

### `Mutation.aiCatalogFlowCreate` {#mutationaicatalogflowcreate}

{{< details >}}GitLab 18.3で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `AiCatalogFlowCreateInput`

#### 引数 {#arguments-112}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogflowcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaicatalogflowcreatedescription"></a>`description` | [`String!`](#string) | フローの説明。 |
| <a id="mutationaicatalogflowcreatename"></a>`name` | [`String!`](#string) | フローの名前。 |
| <a id="mutationaicatalogflowcreateprojectid"></a>`projectId` | [`ProjectID!`](#projectid) | フローのプロジェクト。 |
| <a id="mutationaicatalogflowcreatepublic"></a>`public` | [`Boolean!`](#boolean) | フローがカタログで公開されているかどうか。 |
| <a id="mutationaicatalogflowcreaterelease"></a>`release` | [`Boolean`](#boolean) | フローの最新バージョンをリリースするかどうか。 |
| <a id="mutationaicatalogflowcreatesteps"></a>`steps` | [`[AiCatalogFlowStepsInput!]!`](#aicatalogflowstepsinput) | フローのステップ。 |

#### フィールド {#fields-17}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogflowcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaicatalogflowcreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationaicatalogflowcreateitem"></a>`item` | [`AiCatalogFlow`](#aicatalogflow) | 項目が作成されました。 |

### `Mutation.aiCatalogFlowDelete` {#mutationaicatalogflowdelete}

{{< details >}}GitLab 18.3で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `AiCatalogFlowDeleteInput`

#### 引数 {#arguments-113}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogflowdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaicatalogflowdeleteid"></a>`id` | [`AiCatalogItemID!`](#aicatalogitemid) | 削除するカタログフローのグローバルID。 |

#### フィールド {#fields-18}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogflowdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaicatalogflowdeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationaicatalogflowdeletesuccess"></a>`success` | [`Boolean!`](#boolean) | カタログフローが正常に削除された場合はtrueを返します。 |

### `Mutation.aiCatalogFlowExecute` {#mutationaicatalogflowexecute}

{{< details >}}GitLab 18.5で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `AiCatalogFlowExecuteInput`

#### 引数 {#arguments-114}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogflowexecuteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaicatalogflowexecuteflowid"></a>`flowId` | [`AiCatalogItemID!`](#aicatalogitemid) | 実行するAIカタログフローのグローバルID。 |
| <a id="mutationaicatalogflowexecuteflowversionid"></a>`flowVersionId` | [`AiCatalogItemVersionID`](#aicatalogitemversionid) | 使用する特定のフローバージョンのグローバルID。指定されていない場合は、最新バージョンが使用されます。 |

#### フィールド {#fields-19}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogflowexecuteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaicatalogflowexecuteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationaicatalogflowexecuteflowconfig"></a>`flowConfig` | [`String`](#string) | フロー実行のためにGitLab Duo Workflowサービスで使用できるYAML設定。 |
| <a id="mutationaicatalogflowexecuteworkflow"></a>`workflow` | [`DuoWorkflow`](#duoworkflow) | 作成されたワークフロー。 |

### `Mutation.aiCatalogFlowUpdate` {#mutationaicatalogflowupdate}

{{< details >}}GitLab 18.3で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `AiCatalogFlowUpdateInput`

#### 引数 {#arguments-115}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogflowupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaicatalogflowupdatedescription"></a>`description` | [`String`](#string) | フローの説明。 |
| <a id="mutationaicatalogflowupdateid"></a>`id` | [`AiCatalogItemID!`](#aicatalogitemid) | 更新するカタログフローのグローバルID。 |
| <a id="mutationaicatalogflowupdatename"></a>`name` | [`String`](#string) | フローの名前。 |
| <a id="mutationaicatalogflowupdatepublic"></a>`public` | [`Boolean`](#boolean) | フローがカタログで公開されているかどうか。 |
| <a id="mutationaicatalogflowupdaterelease"></a>`release` | [`Boolean`](#boolean) | フローの最新バージョンをリリースするかどうか。 |
| <a id="mutationaicatalogflowupdatesteps"></a>`steps` | [`[AiCatalogFlowStepsInput!]`](#aicatalogflowstepsinput) | フローのステップ。 |

#### フィールド {#fields-20}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogflowupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaicatalogflowupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationaicatalogflowupdateitem"></a>`item` | [`AiCatalogFlow`](#aicatalogflow) | 更新されたフロー。 |

### `Mutation.aiCatalogItemConsumerCreate` {#mutationaicatalogitemconsumercreate}

{{< details >}}GitLab 18.3で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `AiCatalogItemConsumerCreateInput`

#### 引数 {#arguments-116}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogitemconsumercreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaicatalogitemconsumercreateitemid"></a>`itemId` | [`AiCatalogItemID!`](#aicatalogitemid) | 設定する項目。 |
| <a id="mutationaicatalogitemconsumercreatepinnedversionprefix"></a>`pinnedVersionPrefix` | [`String`](#string) | 項目をピン留めするメジャーバージョン、マイナーバージョン、またはパッチ。 |
| <a id="mutationaicatalogitemconsumercreatetarget"></a>`target` | [`ItemConsumerTargetInput!`](#itemconsumertargetinput) | カタログ項目が設定されているターゲット。 |

#### フィールド {#fields-21}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogitemconsumercreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaicatalogitemconsumercreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationaicatalogitemconsumercreateitemconsumer"></a>`itemConsumer` | [`AiCatalogItemConsumer`](#aicatalogitemconsumer) | 設定が作成されました。 |

### `Mutation.aiCatalogItemConsumerDelete` {#mutationaicatalogitemconsumerdelete}

{{< details >}}GitLab 18.3で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `AiCatalogItemConsumerDeleteInput`

#### 引数 {#arguments-117}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogitemconsumerdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaicatalogitemconsumerdeleteid"></a>`id` | [`AiCatalogItemConsumerID!`](#aicatalogitemconsumerid) | 削除するカタログ項目コンシューマーのグローバルID。 |

#### フィールド {#fields-22}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogitemconsumerdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaicatalogitemconsumerdeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationaicatalogitemconsumerdeletesuccess"></a>`success` | [`Boolean!`](#boolean) | カタログ項目コンシューマーが正常に削除された場合はtrueを返します。 |

### `Mutation.aiCatalogItemConsumerUpdate` {#mutationaicatalogitemconsumerupdate}

{{< details >}}GitLab 18.3で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `AiCatalogItemConsumerUpdateInput`

#### 引数 {#arguments-118}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogitemconsumerupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaicatalogitemconsumerupdateid"></a>`id` | [`AiCatalogItemConsumerID!`](#aicatalogitemconsumerid) | 更新するカタログ項目コンシューマーのグローバルID。 |
| <a id="mutationaicatalogitemconsumerupdatepinnedversionprefix"></a>`pinnedVersionPrefix` | [`String`](#string) | 項目をピン留めするメジャーバージョン、マイナーバージョン、またはパッチ。 |

#### フィールド {#fields-23}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaicatalogitemconsumerupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaicatalogitemconsumerupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationaicatalogitemconsumerupdateitemconsumer"></a>`itemConsumer` | [`AiCatalogItemConsumer`](#aicatalogitemconsumer) | 更新された項目コンシューマー。 |

### `Mutation.aiDuoWorkflowCreate` {#mutationaiduoworkflowcreate}

{{< details >}}GitLab 18.1で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `AiDuoWorkflowCreateInput`

#### 引数 {#arguments-119}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaiduoworkflowcreateagentprivileges"></a>`agentPrivileges` | [`[Int!]`](#int) | エージェントが実行できるアクション。 |
| <a id="mutationaiduoworkflowcreateaicatalogitemversionid"></a>`aiCatalogItemVersionId` | [`AiCatalogItemVersionID`](#aicatalogitemversionid) | ワークフローがトリガーされたカタログ項目のID。 |
| <a id="mutationaiduoworkflowcreateallowagenttorequestuser"></a>`allowAgentToRequestUser` | [`Boolean`](#boolean) | これを有効にすると、GitLab Duo Agent Platformは続行する前にユーザーに質問する場合があります。 |
| <a id="mutationaiduoworkflowcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaiduoworkflowcreateenvironment"></a>`environment` | [`WorkflowEnvironment`](#workflowenvironment) | ワークフローの環境。 |
| <a id="mutationaiduoworkflowcreategoal"></a>`goal` | [`String`](#string) | ワークフローの目標。 |
| <a id="mutationaiduoworkflowcreatenamespaceid"></a>`namespaceId` | [`NamespaceID`](#namespaceid) | ユーザー操作の対象となるネームスペースのグローバルID。 |
| <a id="mutationaiduoworkflowcreatepreapprovedagentprivileges"></a>`preApprovedAgentPrivileges` | [`[Int!]`](#int) | 承認を求めることなく、エージェントが実行できるアクション。 |
| <a id="mutationaiduoworkflowcreateprojectid"></a>`projectId` | [`ProjectID`](#projectid) | ユーザー操作の対象となるプロジェクトのグローバルID。 |
| <a id="mutationaiduoworkflowcreateworkflowdefinition"></a>`workflowDefinition` | [`String`](#string) | 機能に基づくワークフローの型。 |

#### フィールド {#fields-24}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaiduoworkflowcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaiduoworkflowcreateerrors"></a>`errors` | [`[String!]!`](#string) | 作成プロセス中に発生したエラー。 |
| <a id="mutationaiduoworkflowcreateworkflow"></a>`workflow` | [`DuoWorkflow`](#duoworkflow) | 作成されたワークフロー。 |

### `Mutation.aiFeatureSettingUpdate` {#mutationaifeaturesettingupdate}

{{< details >}}GitLab 17.4で**導入**されました。**状態**: 実験的機能。{{< /details >}}

AI機能の設定を更新または作成します。

入力型: `AiFeatureSettingUpdateInput`

#### 引数 {#arguments-120}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaifeaturesettingupdateaiselfhostedmodelid"></a>`aiSelfHostedModelId` | [`AiSelfHostedModelID`](#aiselfhostedmodelid) | AI設定を提供するセルフホストモデルのグローバルID。 |
| <a id="mutationaifeaturesettingupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaifeaturesettingupdatefeatures"></a>`features` | [`[AiFeatures!]!`](#aifeatures) | 設定するAI機能の配列（単一の更新またはバッチ更新）。 |
| <a id="mutationaifeaturesettingupdateofferedmodelref"></a>`offeredModelRef` | [`String`](#string) | 機能に選択されたモデルの識別子。 |
| <a id="mutationaifeaturesettingupdateprovider"></a>`provider` | [`AiFeatureProviders!`](#aifeatureproviders) | AI設定のプロバイダー。 |

#### フィールド {#fields-25}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaifeaturesettingupdateaifeaturesettings"></a>`aiFeatureSettings` | [`[AiFeatureSetting!]!`](#aifeaturesetting) | ミューテーション後のAI機能設定のリスト。 |
| <a id="mutationaifeaturesettingupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaifeaturesettingupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.aiFlowTriggerCreate` {#mutationaiflowtriggercreate}

{{< details >}}GitLab 18.3で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `AiFlowTriggerCreateInput`

#### 引数 {#arguments-121}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaiflowtriggercreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaiflowtriggercreateconfigpath"></a>`configPath` | [`String`](#string) | AIフロートリガーの設定ファイルへのパス。 |
| <a id="mutationaiflowtriggercreatedescription"></a>`description` | [`String!`](#string) | AIフロートリガーの説明。 |
| <a id="mutationaiflowtriggercreateeventtypes"></a>`eventTypes` | [`[Int!]`](#int) | AIフローをトリガーするイベントタイプ。 |
| <a id="mutationaiflowtriggercreateprojectpath"></a>`projectPath` | [`ID!`](#id) | AIフロートリガーが関連付けられているプロジェのフルパス。 |
| <a id="mutationaiflowtriggercreateuserid"></a>`userId` | [`UserID!`](#userid) | AIフロートリガーのオーナー。 |

#### フィールド {#fields-26}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaiflowtriggercreateaiflowtrigger"></a>`aiFlowTrigger` | [`AiFlowTriggerType`](#aiflowtriggertype) | 作成されたAIフロートリガー。 |
| <a id="mutationaiflowtriggercreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaiflowtriggercreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.aiFlowTriggerDelete` {#mutationaiflowtriggerdelete}

{{< details >}}GitLab 18.3で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `AiFlowTriggerDeleteInput`

#### 引数 {#arguments-122}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaiflowtriggerdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaiflowtriggerdeleteid"></a>`id` | [`AiFlowTriggerID!`](#aiflowtriggerid) | 削除するフロートリガーのID。 |

#### フィールド {#fields-27}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaiflowtriggerdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaiflowtriggerdeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.aiFlowTriggerUpdate` {#mutationaiflowtriggerupdate}

{{< details >}}GitLab 18.3で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `AiFlowTriggerUpdateInput`

#### 引数 {#arguments-123}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaiflowtriggerupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaiflowtriggerupdateconfigpath"></a>`configPath` | [`String`](#string) | AIフロートリガーの設定ファイルへのパス。 |
| <a id="mutationaiflowtriggerupdatedescription"></a>`description` | [`String`](#string) | AIフロートリガーの説明。 |
| <a id="mutationaiflowtriggerupdateeventtypes"></a>`eventTypes` | [`[Int!]`](#int) | AIフローをトリガーするイベントタイプ。 |
| <a id="mutationaiflowtriggerupdateid"></a>`id` | [`AiFlowTriggerID!`](#aiflowtriggerid) | 更新するフロートリガーのID。 |
| <a id="mutationaiflowtriggerupdateuserid"></a>`userId` | [`UserID`](#userid) | AIフロートリガーのオーナー。 |

#### フィールド {#fields-28}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaiflowtriggerupdateaiflowtrigger"></a>`aiFlowTrigger` | [`AiFlowTriggerType`](#aiflowtriggertype) | 更新されたAIフロートリガー。 |
| <a id="mutationaiflowtriggerupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaiflowtriggerupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.aiModelSelectionNamespaceUpdate` {#mutationaimodelselectionnamespaceupdate}

{{< details >}}GitLab 18.1で**導入**されました。**状態**: 実験的機能。{{< /details >}}

ネームスペースのAI機能の設定を更新または作成します。

入力型: `AiModelSelectionNamespaceUpdateInput`

#### 引数 {#arguments-124}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaimodelselectionnamespaceupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaimodelselectionnamespaceupdatefeatures"></a>`features` | [`[AiModelSelectionFeatures!]!`](#aimodelselectionfeatures) | 設定するAI機能の配列（単一の更新またはバッチ更新）。 |
| <a id="mutationaimodelselectionnamespaceupdategroupid"></a>`groupId` | [`GroupID!`](#groupid) | モデル選択のグループ。 |
| <a id="mutationaimodelselectionnamespaceupdateofferedmodelref"></a>`offeredModelRef` | [`String!`](#string) | 機能に選択されたモデルの識別子。 |

#### フィールド {#fields-29}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaimodelselectionnamespaceupdateaifeaturesettings"></a>`aiFeatureSettings` {{< icon name="warning-solid" >}} | [`[AiModelSelectionNamespaceFeatureSetting!]!`](#aimodelselectionnamespacefeaturesetting) | **非推奨**: **状態**: 実験的機能。GitLab 18.1で導入されました。 |
| <a id="mutationaimodelselectionnamespaceupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaimodelselectionnamespaceupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.aiSelfHostedModelConnectionCheck` {#mutationaiselfhostedmodelconnectioncheck}

{{< details >}}GitLab 17.7で**導入**されました。**状態**: 実験的機能。{{< /details >}}

指定されたモデル設定による接続をAIゲートウェイが確立できるかどうかをチェックします。

入力型: `AiSelfHostedModelConnectionCheckInput`

#### 引数 {#arguments-125}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaiselfhostedmodelconnectioncheckapitoken"></a>`apiToken` | [`String`](#string) | セルフホストモデルへのアクセスに使用するAPIトークン（存在する場合）。 |
| <a id="mutationaiselfhostedmodelconnectioncheckclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaiselfhostedmodelconnectioncheckendpoint"></a>`endpoint` | [`String!`](#string) | セルフホストモデルのエンドポイント。 |
| <a id="mutationaiselfhostedmodelconnectioncheckidentifier"></a>`identifier` | [`String`](#string) | サードパーティモデルプロバイダーの識別子。 |
| <a id="mutationaiselfhostedmodelconnectioncheckmodel"></a>`model` | [`AiAcceptedSelfHostedModels!`](#aiacceptedselfhostedmodels) | デプロイされたAIモデル。 |
| <a id="mutationaiselfhostedmodelconnectioncheckname"></a>`name` | [`String!`](#string) | セルフホストモデルのデプロイ名。 |

#### フィールド {#fields-30}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaiselfhostedmodelconnectioncheckclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaiselfhostedmodelconnectioncheckerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationaiselfhostedmodelconnectioncheckresult"></a>`result` | [`CloudConnectorProbeResult`](#cloudconnectorproberesult) | セルフホストのホスティング接続チェックの結果。 |

### `Mutation.aiSelfHostedModelCreate` {#mutationaiselfhostedmodelcreate}

{{< details >}}GitLab 17.1で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `AiSelfHostedModelCreateInput`

#### 引数 {#arguments-126}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaiselfhostedmodelcreateapitoken"></a>`apiToken` | [`String`](#string) | セルフホストモデルへのアクセスに使用するAPIトークン（存在する場合）。 |
| <a id="mutationaiselfhostedmodelcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaiselfhostedmodelcreateendpoint"></a>`endpoint` | [`String!`](#string) | セルフホストモデルのエンドポイント。 |
| <a id="mutationaiselfhostedmodelcreateidentifier"></a>`identifier` | [`String`](#string) | サードパーティモデルプロバイダーの識別子。 |
| <a id="mutationaiselfhostedmodelcreatemodel"></a>`model` | [`AiAcceptedSelfHostedModels!`](#aiacceptedselfhostedmodels) | デプロイされたAIモデル。 |
| <a id="mutationaiselfhostedmodelcreatename"></a>`name` | [`String!`](#string) | セルフホストモデルのデプロイ名。 |

#### フィールド {#fields-31}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaiselfhostedmodelcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaiselfhostedmodelcreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationaiselfhostedmodelcreateselfhostedmodel"></a>`selfHostedModel` | [`AiSelfHostedModel`](#aiselfhostedmodel) | ミューテーション後のセルフホストモデル。 |

### `Mutation.aiSelfHostedModelDelete` {#mutationaiselfhostedmodeldelete}

{{< details >}}GitLab 17.2で**導入**されました。**状態**: 実験的機能。{{< /details >}}

セルフホストモデルを削除します。

入力型: `AiSelfHostedModelDeleteInput`

#### 引数 {#arguments-127}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaiselfhostedmodeldeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaiselfhostedmodeldeleteid"></a>`id` | [`AiSelfHostedModelID!`](#aiselfhostedmodelid) | 削除するセルフホストモデルのグローバルID。 |

#### フィールド {#fields-32}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaiselfhostedmodeldeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaiselfhostedmodeldeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.aiSelfHostedModelUpdate` {#mutationaiselfhostedmodelupdate}

{{< details >}}GitLab 17.2で**導入**されました。**状態**: 実験的機能。{{< /details >}}

セルフホストモデルを更新します。

入力型: `AiSelfHostedModelUpdateInput`

#### 引数 {#arguments-128}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaiselfhostedmodelupdateapitoken"></a>`apiToken` | [`String`](#string) | セルフホストモデルへのアクセスに使用するAPIトークン（存在する場合）。 |
| <a id="mutationaiselfhostedmodelupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaiselfhostedmodelupdateendpoint"></a>`endpoint` | [`String!`](#string) | セルフホストモデルのエンドポイント。 |
| <a id="mutationaiselfhostedmodelupdateid"></a>`id` | [`AiSelfHostedModelID!`](#aiselfhostedmodelid) | 更新するセルフホストモデルのグローバルID。 |
| <a id="mutationaiselfhostedmodelupdateidentifier"></a>`identifier` | [`String`](#string) | サードパーティモデルプロバイダーの識別子。 |
| <a id="mutationaiselfhostedmodelupdatemodel"></a>`model` | [`AiAcceptedSelfHostedModels!`](#aiacceptedselfhostedmodels) | デプロイされたAIモデル。 |
| <a id="mutationaiselfhostedmodelupdatename"></a>`name` | [`String!`](#string) | セルフホストモデルのデプロイ名。 |

#### フィールド {#fields-33}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationaiselfhostedmodelupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationaiselfhostedmodelupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationaiselfhostedmodelupdateselfhostedmodel"></a>`selfHostedModel` | [`AiSelfHostedModel`](#aiselfhostedmodel) | ミューテーション後のセルフホストモデル。 |

### `Mutation.alertSetAssignees` {#mutationalertsetassignees}

入力型: `AlertSetAssigneesInput`

#### 引数 {#arguments-129}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationalertsetassigneesassigneeusernames"></a>`assigneeUsernames` | [`[String!]!`](#string) | アラートに割り当てるユーザー名。デフォルトでは、既存の担当者を置き換えます。 |
| <a id="mutationalertsetassigneesclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationalertsetassigneesiid"></a>`iid` | [`String!`](#string) | ミューテーション対象のアラートのIID。 |
| <a id="mutationalertsetassigneesoperationmode"></a>`operationMode` | [`MutationOperationMode`](#mutationoperationmode) | 実行する操作。デフォルトはREPLACEです。 |
| <a id="mutationalertsetassigneesprojectpath"></a>`projectPath` | [`ID!`](#id) | ミューテーション対象のアラートの属するプロジェクト。 |

#### フィールド {#fields-34}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationalertsetassigneesalert"></a>`alert` | [`AlertManagementAlert`](#alertmanagementalert) | ミューテーション後のアラート。 |
| <a id="mutationalertsetassigneesclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationalertsetassigneeserrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationalertsetassigneesissue"></a>`issue` | [`Issue`](#issue) | ミューテーション後に作成されたイシュー。 |
| <a id="mutationalertsetassigneestodo"></a>`todo` | [`Todo`](#todo) | ミューテーション後のTo Doアイテム。 |

### `Mutation.alertTodoCreate` {#mutationalerttodocreate}

入力型: `AlertTodoCreateInput`

#### 引数 {#arguments-130}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationalerttodocreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationalerttodocreateiid"></a>`iid` | [`String!`](#string) | ミューテーション対象のアラートのIID。 |
| <a id="mutationalerttodocreateprojectpath"></a>`projectPath` | [`ID!`](#id) | ミューテーション対象のアラートの属するプロジェクト。 |

#### フィールド {#fields-35}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationalerttodocreatealert"></a>`alert` | [`AlertManagementAlert`](#alertmanagementalert) | ミューテーション後のアラート。 |
| <a id="mutationalerttodocreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationalerttodocreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationalerttodocreateissue"></a>`issue` | [`Issue`](#issue) | ミューテーション後に作成されたイシュー。 |
| <a id="mutationalerttodocreatetodo"></a>`todo` | [`Todo`](#todo) | ミューテーション後のTo Doアイテム。 |

### `Mutation.approvalProjectRuleDelete` {#mutationapprovalprojectruledelete}

{{< details >}}GitLab 16.10で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `approvalProjectRuleDeleteInput`

#### 引数 {#arguments-131}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationapprovalprojectruledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationapprovalprojectruledeleteid"></a>`id` | [`ApprovalProjectRuleID!`](#approvalprojectruleid) | 削除する承認ルールのグローバルID。 |

#### フィールド {#fields-36}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationapprovalprojectruledeleteapprovalrule"></a>`approvalRule` | [`ApprovalProjectRule`](#approvalprojectrule) | 削除された承認ルール。 |
| <a id="mutationapprovalprojectruledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationapprovalprojectruledeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.approvalProjectRuleUpdate` {#mutationapprovalprojectruleupdate}

{{< details >}}GitLab 16.10で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `approvalProjectRuleUpdateInput`

#### 引数 {#arguments-132}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationapprovalprojectruleupdateapprovalsrequired"></a>`approvalsRequired` | [`Int!`](#int) | ルールを満たすために必要な承認の数。 |
| <a id="mutationapprovalprojectruleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationapprovalprojectruleupdategroupids"></a>`groupIds` | [`[ID!]`](#id) | 承認ルールを実行できるグループのIDのリスト。 |
| <a id="mutationapprovalprojectruleupdateid"></a>`id` | [`ApprovalProjectRuleID!`](#approvalprojectruleid) | 削除する承認ルールのグローバルID。 |
| <a id="mutationapprovalprojectruleupdatename"></a>`name` | [`String!`](#string) | 承認ルールの名前。 |
| <a id="mutationapprovalprojectruleupdateuserids"></a>`userIds` | [`[ID!]`](#id) | 承認ルールを実行できるユーザーのIDのリスト。 |

#### フィールド {#fields-37}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationapprovalprojectruleupdateapprovalrule"></a>`approvalRule` | [`ApprovalProjectRule`](#approvalprojectrule) | ミューテーション後の承認ルール。 |
| <a id="mutationapprovalprojectruleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationapprovalprojectruleupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.approveDeployment` {#mutationapprovedeployment}

入力型: `ApproveDeploymentInput`

#### 引数 {#arguments-133}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationapprovedeploymentclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationapprovedeploymentcomment"></a>`comment` | [`String`](#string) | 承認に伴うコメント。 |
| <a id="mutationapprovedeploymentid"></a>`id` | [`DeploymentID!`](#deploymentid) | デプロイのID。 |
| <a id="mutationapprovedeploymentrepresentedas"></a>`representedAs` | [`String`](#string) | ユーザーが複数の承認ルールに属している場合に、承認に使用するユーザー/グループ/ロールの名前。 |
| <a id="mutationapprovedeploymentstatus"></a>`status` | [`DeploymentsApprovalStatus!`](#deploymentsapprovalstatus) | 承認のステータス（`APPROVED`または`REJECTED`のいずれか）。 |

#### フィールド {#fields-38}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationapprovedeploymentclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationapprovedeploymentdeploymentapproval"></a>`deploymentApproval` | [`DeploymentApproval`](#deploymentapproval) | ミューテーション後のデプロイ承認。 |
| <a id="mutationapprovedeploymenterrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.artifactDestroy` {#mutationartifactdestroy}

入力型: `ArtifactDestroyInput`

#### 引数 {#arguments-134}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationartifactdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationartifactdestroyid"></a>`id` | [`CiJobArtifactID!`](#cijobartifactid) | 削除するアーティファクトのID。 |

#### フィールド {#fields-39}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationartifactdestroyartifact"></a>`artifact` | [`CiJobArtifact`](#cijobartifact) | 削除されたアーティファクト。 |
| <a id="mutationartifactdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationartifactdestroyerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.auditEventsAmazonS3ConfigurationCreate` {#mutationauditeventsamazons3configurationcreate}

入力型: `AuditEventsAmazonS3ConfigurationCreateInput`

#### 引数 {#arguments-135}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsamazons3configurationcreateaccesskeyxid"></a>`accessKeyXid` | [`String!`](#string) | Amazon S3アカウントのアクセスキーID。 |
| <a id="mutationauditeventsamazons3configurationcreateawsregion"></a>`awsRegion` | [`String!`](#string) | バケットを作成するAWSリージョン。 |
| <a id="mutationauditeventsamazons3configurationcreatebucketname"></a>`bucketName` | [`String!`](#string) | 監査イベントが記録されるバケットの名前。 |
| <a id="mutationauditeventsamazons3configurationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsamazons3configurationcreategrouppath"></a>`groupPath` | [`ID!`](#id) | グループパス。 |
| <a id="mutationauditeventsamazons3configurationcreatename"></a>`name` | [`String`](#string) | 宛先名。 |
| <a id="mutationauditeventsamazons3configurationcreatesecretaccesskey"></a>`secretAccessKey` | [`String!`](#string) | Amazon S3アカウントのシークレットアクセスキー。 |

#### フィールド {#fields-40}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsamazons3configurationcreateamazons3configuration"></a>`amazonS3Configuration` | [`AmazonS3ConfigurationType`](#amazons3configurationtype) | 作成された設定。 |
| <a id="mutationauditeventsamazons3configurationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsamazons3configurationcreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.auditEventsAmazonS3ConfigurationDelete` {#mutationauditeventsamazons3configurationdelete}

入力型: `AuditEventsAmazonS3ConfigurationDeleteInput`

#### 引数 {#arguments-136}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsamazons3configurationdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsamazons3configurationdeleteid"></a>`id` | [`AuditEventsAmazonS3ConfigurationID!`](#auditeventsamazons3configurationid) | 削除するAmazon S3設定のID。 |

#### フィールド {#fields-41}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsamazons3configurationdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsamazons3configurationdeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.auditEventsAmazonS3ConfigurationUpdate` {#mutationauditeventsamazons3configurationupdate}

入力型: `AuditEventsAmazonS3ConfigurationUpdateInput`

#### 引数 {#arguments-137}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsamazons3configurationupdateaccesskeyxid"></a>`accessKeyXid` | [`String`](#string) | Amazon S3アカウントのアクセスキーID。 |
| <a id="mutationauditeventsamazons3configurationupdateactive"></a>`active` | [`Boolean`](#boolean) | 送信先の有効ステータス。 |
| <a id="mutationauditeventsamazons3configurationupdateawsregion"></a>`awsRegion` | [`String`](#string) | バケットを作成するAWSリージョン。 |
| <a id="mutationauditeventsamazons3configurationupdatebucketname"></a>`bucketName` | [`String`](#string) | 監査イベントが記録されるバケットの名前。 |
| <a id="mutationauditeventsamazons3configurationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsamazons3configurationupdateid"></a>`id` | [`AuditEventsAmazonS3ConfigurationID!`](#auditeventsamazons3configurationid) | 更新するAmazon S3設定のID。 |
| <a id="mutationauditeventsamazons3configurationupdatename"></a>`name` | [`String`](#string) | 宛先名。 |
| <a id="mutationauditeventsamazons3configurationupdatesecretaccesskey"></a>`secretAccessKey` | [`String`](#string) | Amazon S3アカウントのシークレットアクセスキー。 |

#### フィールド {#fields-42}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsamazons3configurationupdateamazons3configuration"></a>`amazonS3Configuration` | [`AmazonS3ConfigurationType`](#amazons3configurationtype) | 更新されたAmazon S3設定。 |
| <a id="mutationauditeventsamazons3configurationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsamazons3configurationupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.auditEventsGroupDestinationEventsAdd` {#mutationauditeventsgroupdestinationeventsadd}

{{< details >}} GitLab 17.0で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `AuditEventsGroupDestinationEventsAddInput`

#### 引数 {#arguments-138}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsgroupdestinationeventsaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsgroupdestinationeventsadddestinationid"></a>`destinationId` | [`AuditEventsGroupExternalStreamingDestinationID!`](#auditeventsgroupexternalstreamingdestinationid) | 宛先ID。 |
| <a id="mutationauditeventsgroupdestinationeventsaddeventtypefilters"></a>`eventTypeFilters` | [`[String!]!`](#string) | ストリーミング用に追加するイベントタイプフィルターのリスト。 |

#### フィールド {#fields-43}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsgroupdestinationeventsaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsgroupdestinationeventsadderrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationauditeventsgroupdestinationeventsaddeventtypefilters"></a>`eventTypeFilters` | [`[String!]`](#string) | 監査イベントの外部宛先のためのイベントタイプフィルターのリスト。 |

### `Mutation.auditEventsGroupDestinationEventsDelete` {#mutationauditeventsgroupdestinationeventsdelete}

{{< details >}} GitLab 17.0で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `AuditEventsGroupDestinationEventsDeleteInput`

#### 引数 {#arguments-139}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsgroupdestinationeventsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsgroupdestinationeventsdeletedestinationid"></a>`destinationId` | [`AuditEventsGroupExternalStreamingDestinationID!`](#auditeventsgroupexternalstreamingdestinationid) | 宛先ID。 |
| <a id="mutationauditeventsgroupdestinationeventsdeleteeventtypefilters"></a>`eventTypeFilters` | [`[String!]!`](#string) | ストリーミングから削除するイベントタイプフィルターのリスト。 |

#### フィールド {#fields-44}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsgroupdestinationeventsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsgroupdestinationeventsdeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.auditEventsGroupDestinationNamespaceFilterCreate` {#mutationauditeventsgroupdestinationnamespacefiltercreate}

{{< details >}} GitLab 17.0で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `AuditEventsGroupDestinationNamespaceFilterCreateInput`

#### 引数 {#arguments-140}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsgroupdestinationnamespacefiltercreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsgroupdestinationnamespacefiltercreatedestinationid"></a>`destinationId` | [`AuditEventsGroupExternalStreamingDestinationID!`](#auditeventsgroupexternalstreamingdestinationid) | 宛先ID。 |
| <a id="mutationauditeventsgroupdestinationnamespacefiltercreatenamespacepath"></a>`namespacePath` | [`String`](#string) | ネームスペースのフルパス（プロジェクトまたはグループのみ）。 |

#### フィールド {#fields-45}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsgroupdestinationnamespacefiltercreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsgroupdestinationnamespacefiltercreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationauditeventsgroupdestinationnamespacefiltercreatenamespacefilter"></a>`namespaceFilter` | [`GroupAuditEventNamespaceFilter`](#groupauditeventnamespacefilter) | 作成されたネームスペースフィルター。 |

### `Mutation.auditEventsGroupDestinationNamespaceFilterDelete` {#mutationauditeventsgroupdestinationnamespacefilterdelete}

{{< details >}} GitLab 17.0で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `AuditEventsGroupDestinationNamespaceFilterDeleteInput`

#### 引数 {#arguments-141}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsgroupdestinationnamespacefilterdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsgroupdestinationnamespacefilterdeletenamespacefilterid"></a>`namespaceFilterId` | [`AuditEventsGroupNamespaceFilterID!`](#auditeventsgroupnamespacefilterid) | ネームスペースフィルターID。 |

#### フィールド {#fields-46}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsgroupdestinationnamespacefilterdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsgroupdestinationnamespacefilterdeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.auditEventsInstanceAmazonS3ConfigurationCreate` {#mutationauditeventsinstanceamazons3configurationcreate}

入力型: `AuditEventsInstanceAmazonS3ConfigurationCreateInput`

#### 引数 {#arguments-142}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstanceamazons3configurationcreateaccesskeyxid"></a>`accessKeyXid` | [`String!`](#string) | Amazon S3アカウントのアクセスキーID。 |
| <a id="mutationauditeventsinstanceamazons3configurationcreateawsregion"></a>`awsRegion` | [`String!`](#string) | バケットを作成するAWSリージョン。 |
| <a id="mutationauditeventsinstanceamazons3configurationcreatebucketname"></a>`bucketName` | [`String!`](#string) | 監査イベントが記録されるバケットの名前。 |
| <a id="mutationauditeventsinstanceamazons3configurationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsinstanceamazons3configurationcreatename"></a>`name` | [`String`](#string) | 宛先名。 |
| <a id="mutationauditeventsinstanceamazons3configurationcreatesecretaccesskey"></a>`secretAccessKey` | [`String!`](#string) | Amazon S3アカウントのシークレットアクセスキー。 |

#### フィールド {#fields-47}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstanceamazons3configurationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsinstanceamazons3configurationcreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationauditeventsinstanceamazons3configurationcreateinstanceamazons3configuration"></a>`instanceAmazonS3Configuration` | [`InstanceAmazonS3ConfigurationType`](#instanceamazons3configurationtype) | 作成されたインスタンスAmazon S3設定。 |

### `Mutation.auditEventsInstanceAmazonS3ConfigurationDelete` {#mutationauditeventsinstanceamazons3configurationdelete}

入力型: `AuditEventsInstanceAmazonS3ConfigurationDeleteInput`

#### 引数 {#arguments-143}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstanceamazons3configurationdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsinstanceamazons3configurationdeleteid"></a>`id` | [`AuditEventsInstanceAmazonS3ConfigurationID!`](#auditeventsinstanceamazons3configurationid) | 削除するインスタンスレベルのAmazon S3設定のID。 |

#### フィールド {#fields-48}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstanceamazons3configurationdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsinstanceamazons3configurationdeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.auditEventsInstanceAmazonS3ConfigurationUpdate` {#mutationauditeventsinstanceamazons3configurationupdate}

入力型: `AuditEventsInstanceAmazonS3ConfigurationUpdateInput`

#### 引数 {#arguments-144}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstanceamazons3configurationupdateaccesskeyxid"></a>`accessKeyXid` | [`String`](#string) | Amazon S3アカウントのアクセスキーID。 |
| <a id="mutationauditeventsinstanceamazons3configurationupdateactive"></a>`active` | [`Boolean`](#boolean) | 送信先の有効ステータス。 |
| <a id="mutationauditeventsinstanceamazons3configurationupdateawsregion"></a>`awsRegion` | [`String`](#string) | バケットを作成するAWSリージョン。 |
| <a id="mutationauditeventsinstanceamazons3configurationupdatebucketname"></a>`bucketName` | [`String`](#string) | 監査イベントが記録されるバケットの名前。 |
| <a id="mutationauditeventsinstanceamazons3configurationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsinstanceamazons3configurationupdateid"></a>`id` | [`AuditEventsInstanceAmazonS3ConfigurationID!`](#auditeventsinstanceamazons3configurationid) | 更新するインスタンスレベルのAmazon S3設定のID。 |
| <a id="mutationauditeventsinstanceamazons3configurationupdatename"></a>`name` | [`String`](#string) | 宛先名。 |
| <a id="mutationauditeventsinstanceamazons3configurationupdatesecretaccesskey"></a>`secretAccessKey` | [`String`](#string) | Amazon S3アカウントのシークレットアクセスキー。 |

#### フィールド {#fields-49}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstanceamazons3configurationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsinstanceamazons3configurationupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationauditeventsinstanceamazons3configurationupdateinstanceamazons3configuration"></a>`instanceAmazonS3Configuration` | [`InstanceAmazonS3ConfigurationType`](#instanceamazons3configurationtype) | 更新されたインスタンスレベルのAmazon S3設定。 |

### `Mutation.auditEventsInstanceDestinationEventsAdd` {#mutationauditeventsinstancedestinationeventsadd}

{{< details >}} GitLab 17.0で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `AuditEventsInstanceDestinationEventsAddInput`

#### 引数 {#arguments-145}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstancedestinationeventsaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsinstancedestinationeventsadddestinationid"></a>`destinationId` | [`AuditEventsInstanceExternalStreamingDestinationID!`](#auditeventsinstanceexternalstreamingdestinationid) | 宛先ID。 |
| <a id="mutationauditeventsinstancedestinationeventsaddeventtypefilters"></a>`eventTypeFilters` | [`[String!]!`](#string) | ストリーミング用に追加するイベントタイプフィルターのリスト。 |

#### フィールド {#fields-50}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstancedestinationeventsaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsinstancedestinationeventsadderrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationauditeventsinstancedestinationeventsaddeventtypefilters"></a>`eventTypeFilters` | [`[String!]`](#string) | 監査イベントの外部宛先のためのイベントタイプフィルターのリスト。 |

### `Mutation.auditEventsInstanceDestinationEventsDelete` {#mutationauditeventsinstancedestinationeventsdelete}

{{< details >}} GitLab 17.0で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `AuditEventsInstanceDestinationEventsDeleteInput`

#### 引数 {#arguments-146}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstancedestinationeventsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsinstancedestinationeventsdeletedestinationid"></a>`destinationId` | [`AuditEventsInstanceExternalStreamingDestinationID!`](#auditeventsinstanceexternalstreamingdestinationid) | 宛先ID。 |
| <a id="mutationauditeventsinstancedestinationeventsdeleteeventtypefilters"></a>`eventTypeFilters` | [`[String!]!`](#string) | ストリーミングから削除するイベントタイプフィルターのリスト。 |

#### フィールド {#fields-51}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstancedestinationeventsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsinstancedestinationeventsdeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.auditEventsInstanceDestinationNamespaceFilterCreate` {#mutationauditeventsinstancedestinationnamespacefiltercreate}

{{< details >}}GitLab 17.2で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `AuditEventsInstanceDestinationNamespaceFilterCreateInput`

#### 引数 {#arguments-147}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstancedestinationnamespacefiltercreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsinstancedestinationnamespacefiltercreatedestinationid"></a>`destinationId` | [`AuditEventsInstanceExternalStreamingDestinationID!`](#auditeventsinstanceexternalstreamingdestinationid) | 宛先ID。 |
| <a id="mutationauditeventsinstancedestinationnamespacefiltercreatenamespacepath"></a>`namespacePath` | [`String`](#string) | ネームスペースのフルパス。プロジェクトまたはグループのネームスペースのみ。 |

#### フィールド {#fields-52}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstancedestinationnamespacefiltercreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsinstancedestinationnamespacefiltercreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationauditeventsinstancedestinationnamespacefiltercreatenamespacefilter"></a>`namespaceFilter` | [`InstanceAuditEventNamespaceFilter`](#instanceauditeventnamespacefilter) | 作成するネームスペースフィルター。 |

### `Mutation.auditEventsInstanceDestinationNamespaceFilterDelete` {#mutationauditeventsinstancedestinationnamespacefilterdelete}

{{< details >}}GitLab 17.2で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `AuditEventsInstanceDestinationNamespaceFilterDeleteInput`

#### 引数 {#arguments-148}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstancedestinationnamespacefilterdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsinstancedestinationnamespacefilterdeletenamespacefilterid"></a>`namespaceFilterId` | [`AuditEventsInstanceNamespaceFilterID!`](#auditeventsinstancenamespacefilterid) | ネームスペースフィルターID。 |

#### フィールド {#fields-53}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstancedestinationnamespacefilterdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsinstancedestinationnamespacefilterdeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.auditEventsStreamingDestinationEventsAdd` {#mutationauditeventsstreamingdestinationeventsadd}

入力型: `AuditEventsStreamingDestinationEventsAddInput`

#### 引数 {#arguments-149}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingdestinationeventsaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreamingdestinationeventsadddestinationid"></a>`destinationId` | [`AuditEventsExternalAuditEventDestinationID!`](#auditeventsexternalauditeventdestinationid) | 宛先ID。 |
| <a id="mutationauditeventsstreamingdestinationeventsaddeventtypefilters"></a>`eventTypeFilters` | [`[String!]!`](#string) | ストリーミング用に追加するイベントタイプフィルターのリスト。 |

#### フィールド {#fields-54}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingdestinationeventsaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreamingdestinationeventsadderrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationauditeventsstreamingdestinationeventsaddeventtypefilters"></a>`eventTypeFilters` | [`[String!]`](#string) | 監査イベントの外部宛先のためのイベントタイプフィルターのリスト。 |

### `Mutation.auditEventsStreamingDestinationEventsRemove` {#mutationauditeventsstreamingdestinationeventsremove}

入力型: `AuditEventsStreamingDestinationEventsRemoveInput`

#### 引数 {#arguments-150}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingdestinationeventsremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreamingdestinationeventsremovedestinationid"></a>`destinationId` | [`AuditEventsExternalAuditEventDestinationID!`](#auditeventsexternalauditeventdestinationid) | 宛先ID。 |
| <a id="mutationauditeventsstreamingdestinationeventsremoveeventtypefilters"></a>`eventTypeFilters` | [`[String!]!`](#string) | ストリーミングから削除するイベントタイプフィルターのリスト。 |

#### フィールド {#fields-55}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingdestinationeventsremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreamingdestinationeventsremoveerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.auditEventsStreamingDestinationInstanceEventsAdd` {#mutationauditeventsstreamingdestinationinstanceeventsadd}

入力型: `AuditEventsStreamingDestinationInstanceEventsAddInput`

#### 引数 {#arguments-151}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingdestinationinstanceeventsaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreamingdestinationinstanceeventsadddestinationid"></a>`destinationId` | [`AuditEventsInstanceExternalAuditEventDestinationID!`](#auditeventsinstanceexternalauditeventdestinationid) | 宛先ID。 |
| <a id="mutationauditeventsstreamingdestinationinstanceeventsaddeventtypefilters"></a>`eventTypeFilters` | [`[String!]!`](#string) | ストリーミング用に追加するイベントタイプフィルターのリスト。 |

#### フィールド {#fields-56}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingdestinationinstanceeventsaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreamingdestinationinstanceeventsadderrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationauditeventsstreamingdestinationinstanceeventsaddeventtypefilters"></a>`eventTypeFilters` | [`[String!]`](#string) | 監査イベントの外部宛先のためのイベントタイプフィルターのリスト。 |

### `Mutation.auditEventsStreamingDestinationInstanceEventsRemove` {#mutationauditeventsstreamingdestinationinstanceeventsremove}

入力型: `AuditEventsStreamingDestinationInstanceEventsRemoveInput`

#### 引数 {#arguments-152}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingdestinationinstanceeventsremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreamingdestinationinstanceeventsremovedestinationid"></a>`destinationId` | [`AuditEventsInstanceExternalAuditEventDestinationID!`](#auditeventsinstanceexternalauditeventdestinationid) | 宛先ID。 |
| <a id="mutationauditeventsstreamingdestinationinstanceeventsremoveeventtypefilters"></a>`eventTypeFilters` | [`[String!]!`](#string) | ストリーミングから削除するイベントタイプフィルターのリスト。 |

#### フィールド {#fields-57}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingdestinationinstanceeventsremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreamingdestinationinstanceeventsremoveerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.auditEventsStreamingHeadersCreate` {#mutationauditeventsstreamingheaderscreate}

入力型: `AuditEventsStreamingHeadersCreateInput`

#### 引数 {#arguments-153}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingheaderscreateactive"></a>`active` | [`Boolean`](#boolean) | ヘッダーがアクティブかどうかを判断するブール値オプション。 |
| <a id="mutationauditeventsstreamingheaderscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreamingheaderscreatedestinationid"></a>`destinationId` | [`AuditEventsExternalAuditEventDestinationID!`](#auditeventsexternalauditeventdestinationid) | ヘッダーを関連付ける宛先です。 |
| <a id="mutationauditeventsstreamingheaderscreatekey"></a>`key` | [`String!`](#string) | ヘッダーキーです。 |
| <a id="mutationauditeventsstreamingheaderscreatevalue"></a>`value` | [`String!`](#string) | ヘッダーの値です。 |

#### フィールド {#fields-58}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingheaderscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreamingheaderscreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationauditeventsstreamingheaderscreateheader"></a>`header` | [`AuditEventStreamingHeader`](#auditeventstreamingheader) | 作成されたヘッダー。 |

### `Mutation.auditEventsStreamingHeadersDestroy` {#mutationauditeventsstreamingheadersdestroy}

入力型: `AuditEventsStreamingHeadersDestroyInput`

#### 引数 {#arguments-154}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingheadersdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreamingheadersdestroyheaderid"></a>`headerId` | [`AuditEventsStreamingHeaderID!`](#auditeventsstreamingheaderid) | 削除するヘッダー。 |

#### フィールド {#fields-59}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingheadersdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreamingheadersdestroyerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.auditEventsStreamingHeadersUpdate` {#mutationauditeventsstreamingheadersupdate}

入力型: `AuditEventsStreamingHeadersUpdateInput`

#### 引数 {#arguments-155}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingheadersupdateactive"></a>`active` | [`Boolean`](#boolean) | ヘッダーがアクティブかどうかを判断するブール値オプション。 |
| <a id="mutationauditeventsstreamingheadersupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreamingheadersupdateheaderid"></a>`headerId` | [`AuditEventsStreamingHeaderID!`](#auditeventsstreamingheaderid) | 更新するヘッダー。 |
| <a id="mutationauditeventsstreamingheadersupdatekey"></a>`key` | [`String`](#string) | ヘッダーキーです。 |
| <a id="mutationauditeventsstreamingheadersupdatevalue"></a>`value` | [`String`](#string) | ヘッダーの値です。 |

#### フィールド {#fields-60}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingheadersupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreamingheadersupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationauditeventsstreamingheadersupdateheader"></a>`header` | [`AuditEventStreamingHeader`](#auditeventstreamingheader) | ヘッダーを更新します。 |

### `Mutation.auditEventsStreamingHttpNamespaceFiltersAdd` {#mutationauditeventsstreaminghttpnamespacefiltersadd}

入力型: `AuditEventsStreamingHTTPNamespaceFiltersAddInput`

#### 引数 {#arguments-156}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreaminghttpnamespacefiltersaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreaminghttpnamespacefiltersadddestinationid"></a>`destinationId` | [`AuditEventsExternalAuditEventDestinationID!`](#auditeventsexternalauditeventdestinationid) | 宛先ID。 |
| <a id="mutationauditeventsstreaminghttpnamespacefiltersaddgrouppath"></a>`groupPath` | [`ID`](#id) | グループのフルパス。 |
| <a id="mutationauditeventsstreaminghttpnamespacefiltersaddprojectpath"></a>`projectPath` | [`ID`](#id) | プロジェクトのフルパス。 |

#### フィールド {#fields-61}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreaminghttpnamespacefiltersaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreaminghttpnamespacefiltersadderrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationauditeventsstreaminghttpnamespacefiltersaddnamespacefilter"></a>`namespaceFilter` | [`AuditEventStreamingHTTPNamespaceFilter`](#auditeventstreaminghttpnamespacefilter) | 作成されたネームスペースフィルター。 |

### `Mutation.auditEventsStreamingHttpNamespaceFiltersDelete` {#mutationauditeventsstreaminghttpnamespacefiltersdelete}

入力型: `AuditEventsStreamingHTTPNamespaceFiltersDeleteInput`

#### 引数 {#arguments-157}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreaminghttpnamespacefiltersdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreaminghttpnamespacefiltersdeletenamespacefilterid"></a>`namespaceFilterId` | [`AuditEventsStreamingHTTPNamespaceFilterID!`](#auditeventsstreaminghttpnamespacefilterid) | ネームスペースフィルターID。 |

#### フィールド {#fields-62}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreaminghttpnamespacefiltersdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreaminghttpnamespacefiltersdeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.auditEventsStreamingInstanceHeadersCreate` {#mutationauditeventsstreaminginstanceheaderscreate}

入力型: `AuditEventsStreamingInstanceHeadersCreateInput`

#### 引数 {#arguments-158}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreaminginstanceheaderscreateactive"></a>`active` | [`Boolean`](#boolean) | ヘッダーがアクティブかどうかを判断するブール値オプション。 |
| <a id="mutationauditeventsstreaminginstanceheaderscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreaminginstanceheaderscreatedestinationid"></a>`destinationId` | [`AuditEventsInstanceExternalAuditEventDestinationID!`](#auditeventsinstanceexternalauditeventdestinationid) | ヘッダーを関連付けるインスタンスレベルの外部宛先です。 |
| <a id="mutationauditeventsstreaminginstanceheaderscreatekey"></a>`key` | [`String!`](#string) | ヘッダーキーです。 |
| <a id="mutationauditeventsstreaminginstanceheaderscreatevalue"></a>`value` | [`String!`](#string) | ヘッダーの値です。 |

#### フィールド {#fields-63}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreaminginstanceheaderscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreaminginstanceheaderscreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationauditeventsstreaminginstanceheaderscreateheader"></a>`header` | [`AuditEventsStreamingInstanceHeader`](#auditeventsstreaminginstanceheader) | 作成されたヘッダー。 |

### `Mutation.auditEventsStreamingInstanceHeadersDestroy` {#mutationauditeventsstreaminginstanceheadersdestroy}

入力型: `AuditEventsStreamingInstanceHeadersDestroyInput`

#### 引数 {#arguments-159}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreaminginstanceheadersdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreaminginstanceheadersdestroyheaderid"></a>`headerId` | [`AuditEventsStreamingInstanceHeaderID!`](#auditeventsstreaminginstanceheaderid) | 削除するヘッダー。 |

#### フィールド {#fields-64}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreaminginstanceheadersdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreaminginstanceheadersdestroyerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.auditEventsStreamingInstanceHeadersUpdate` {#mutationauditeventsstreaminginstanceheadersupdate}

入力型: `AuditEventsStreamingInstanceHeadersUpdateInput`

#### 引数 {#arguments-160}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreaminginstanceheadersupdateactive"></a>`active` | [`Boolean`](#boolean) | ヘッダーがアクティブかどうかを判断するブール値オプション。 |
| <a id="mutationauditeventsstreaminginstanceheadersupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreaminginstanceheadersupdateheaderid"></a>`headerId` | [`AuditEventsStreamingInstanceHeaderID!`](#auditeventsstreaminginstanceheaderid) | 更新するヘッダー。 |
| <a id="mutationauditeventsstreaminginstanceheadersupdatekey"></a>`key` | [`String`](#string) | ヘッダーキーです。 |
| <a id="mutationauditeventsstreaminginstanceheadersupdatevalue"></a>`value` | [`String`](#string) | ヘッダーの値です。 |

#### フィールド {#fields-65}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreaminginstanceheadersupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationauditeventsstreaminginstanceheadersupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationauditeventsstreaminginstanceheadersupdateheader"></a>`header` | [`AuditEventsStreamingInstanceHeader`](#auditeventsstreaminginstanceheader) | ヘッダーを更新します。 |

### `Mutation.awardEmojiAdd` {#mutationawardemojiadd}

入力型: `AwardEmojiAddInput`

#### 引数 {#arguments-161}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationawardemojiaddawardableid"></a>`awardableId` | [`AwardableID!`](#awardableid) | 授与可能リソースのグローバルIDです。 |
| <a id="mutationawardemojiaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationawardemojiaddname"></a>`name` | [`String!`](#string) | 絵文字の名前。 |

#### フィールド {#fields-66}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationawardemojiaddawardemoji"></a>`awardEmoji` | [`AwardEmoji`](#awardemoji) | ミューテーション後の絵文字リアクション。 |
| <a id="mutationawardemojiaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationawardemojiadderrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.awardEmojiRemove` {#mutationawardemojiremove}

入力型: `AwardEmojiRemoveInput`

#### 引数 {#arguments-162}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationawardemojiremoveawardableid"></a>`awardableId` | [`AwardableID!`](#awardableid) | 授与可能リソースのグローバルIDです。 |
| <a id="mutationawardemojiremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationawardemojiremovename"></a>`name` | [`String!`](#string) | 絵文字の名前。 |

#### フィールド {#fields-67}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationawardemojiremoveawardemoji"></a>`awardEmoji` | [`AwardEmoji`](#awardemoji) | ミューテーション後の絵文字リアクション。 |
| <a id="mutationawardemojiremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationawardemojiremoveerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.awardEmojiToggle` {#mutationawardemojitoggle}

入力型: `AwardEmojiToggleInput`

#### 引数 {#arguments-163}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationawardemojitoggleawardableid"></a>`awardableId` | [`AwardableID!`](#awardableid) | 授与可能リソースのグローバルIDです。 |
| <a id="mutationawardemojitoggleclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationawardemojitogglename"></a>`name` | [`String!`](#string) | 絵文字の名前。 |

#### フィールド {#fields-68}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationawardemojitoggleawardemoji"></a>`awardEmoji` | [`AwardEmoji`](#awardemoji) | ミューテーション後の絵文字リアクション。 |
| <a id="mutationawardemojitoggleclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationawardemojitoggleerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationawardemojitoggletoggledon"></a>`toggledOn` | [`Boolean!`](#boolean) | 絵文字のステータスを示します。トグルが絵文字を付与した場合はtrue、トグルが絵文字を削除した場合はfalseになります。 |

### `Mutation.boardEpicCreate` {#mutationboardepiccreate}

{{< details >}}GitLab 17.5で**非推奨**になりました。WorkItem型に置き換えられました。{{< /details >}}

入力型: `BoardEpicCreateInput`

#### 引数 {#arguments-164}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationboardepiccreateboardid"></a>`boardId` | [`BoardsEpicBoardID!`](#boardsepicboardid) | エピックの属するボードのグローバルIDです。 |
| <a id="mutationboardepiccreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationboardepiccreategrouppath"></a>`groupPath` | [`ID!`](#id) | 作成するエピックが属するグループ。 |
| <a id="mutationboardepiccreatelistid"></a>`listId` | [`BoardsEpicListID!`](#boardsepiclistid) | エピックを作成するエピックボードリストのグローバルID。 |
| <a id="mutationboardepiccreatetitle"></a>`title` | [`String!`](#string) | エピックのタイトル。 |

#### フィールド {#fields-69}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationboardepiccreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationboardepiccreateepic"></a>`epic` | [`Epic`](#epic) | 作成後のエピック。 |
| <a id="mutationboardepiccreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.boardListCreate` {#mutationboardlistcreate}

入力型: `BoardListCreateInput`

#### 引数 {#arguments-165}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationboardlistcreateassigneeid"></a>`assigneeId` | [`UserID`](#userid) | 既存ユーザーのグローバルID。 |
| <a id="mutationboardlistcreatebacklog"></a>`backlog` | [`Boolean`](#boolean) | バックログリストを作成します。 |
| <a id="mutationboardlistcreateboardid"></a>`boardId` | [`BoardID!`](#boardid) | ミューテーション対象のイシューボードのグローバルID。 |
| <a id="mutationboardlistcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationboardlistcreateiterationid"></a>`iterationId` | [`IterationID`](#iterationid) | 既存イテレーションのグローバルID。 |
| <a id="mutationboardlistcreatelabelid"></a>`labelId` | [`LabelID`](#labelid) | 既存ラベルのグローバルID。 |
| <a id="mutationboardlistcreatemilestoneid"></a>`milestoneId` | [`MilestoneID`](#milestoneid) | 既存マイルストーンのグローバルID。 |
| <a id="mutationboardlistcreateposition"></a>`position` | [`Int`](#int) | リストの位置。 |
| <a id="mutationboardlistcreatestatusid"></a>`statusId` {{< icon name="warning-solid" >}} | [`WorkItemsStatusesStatusID`](#workitemsstatusesstatusid) | **非推奨**: **状態**: 実験的機能。GitLab 18.0で導入されました。 |

#### フィールド {#fields-70}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationboardlistcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationboardlistcreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationboardlistcreatelist"></a>`list` | [`BoardList`](#boardlist) | イシューボードのイシューリスト。 |

### `Mutation.boardListUpdateLimitMetrics` {#mutationboardlistupdatelimitmetrics}

入力型: `BoardListUpdateLimitMetricsInput`

#### 引数 {#arguments-166}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationboardlistupdatelimitmetricsclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationboardlistupdatelimitmetricslimitmetric"></a>`limitMetric` | [`ListLimitMetric`](#listlimitmetric) | リスト用の新しい制限メトリクス型。 |
| <a id="mutationboardlistupdatelimitmetricslistid"></a>`listId` | [`ListID!`](#listid) | リストのグローバルID。 |
| <a id="mutationboardlistupdatelimitmetricsmaxissuecount"></a>`maxIssueCount` | [`Int`](#int) | 新しい最大イシュー数制限。 |
| <a id="mutationboardlistupdatelimitmetricsmaxissueweight"></a>`maxIssueWeight` | [`Int`](#int) | 新しい最大イシューウェイト制限。 |

#### フィールド {#fields-71}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationboardlistupdatelimitmetricsclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationboardlistupdatelimitmetricserrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationboardlistupdatelimitmetricslist"></a>`list` | [`BoardList`](#boardlist) | 更新されたリスト。 |

### `Mutation.branchDelete` {#mutationbranchdelete}

入力型: `BranchDeleteInput`

#### 引数 {#arguments-167}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbranchdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationbranchdeletename"></a>`name` | [`String!`](#string) | ブランチの名前。 |
| <a id="mutationbranchdeleteprojectpath"></a>`projectPath` | [`ID!`](#id) | ブランチが関連付けられているプロジェクトのフルパス。 |

#### フィールド {#fields-72}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbranchdeletebranch"></a>`branch` | [`Branch`](#branch) | ミューテーション後のブランチ。 |
| <a id="mutationbranchdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationbranchdeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.branchRuleApprovalProjectRuleCreate` {#mutationbranchruleapprovalprojectrulecreate}

{{< details >}}GitLab 16.10で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `branchRuleApprovalProjectRuleCreateInput`

#### 引数 {#arguments-168}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbranchruleapprovalprojectrulecreateapprovalsrequired"></a>`approvalsRequired` | [`Int!`](#int) | ルールを満たすために必要な承認の数。 |
| <a id="mutationbranchruleapprovalprojectrulecreatebranchruleid"></a>`branchRuleId` | [`ProjectsBranchRuleID!`](#projectsbranchruleid) | 削除するブランチルールのグローバルID。 |
| <a id="mutationbranchruleapprovalprojectrulecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationbranchruleapprovalprojectrulecreategroupids"></a>`groupIds` | [`[ID!]`](#id) | 承認ルールを実行できるグループのIDのリスト。 |
| <a id="mutationbranchruleapprovalprojectrulecreatename"></a>`name` | [`String!`](#string) | 承認ルールの名前。 |
| <a id="mutationbranchruleapprovalprojectrulecreateuserids"></a>`userIds` | [`[ID!]`](#id) | 承認ルールを実行できるユーザーのIDのリスト。 |

#### フィールド {#fields-73}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbranchruleapprovalprojectrulecreateapprovalrule"></a>`approvalRule` | [`ApprovalProjectRule`](#approvalprojectrule) | ミューテーション後の承認ルール。 |
| <a id="mutationbranchruleapprovalprojectrulecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationbranchruleapprovalprojectrulecreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.branchRuleCreate` {#mutationbranchrulecreate}

{{< details >}} GitLab 16.7で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `BranchRuleCreateInput`

#### 引数 {#arguments-169}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbranchrulecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationbranchrulecreatename"></a>`name` | [`String!`](#string) | ブランチルールのブランチ名（ワイルドカードを含む）。 |
| <a id="mutationbranchrulecreateprojectpath"></a>`projectPath` | [`ID!`](#id) | ブランチが関連付けられているプロジェクトへのフルパス。 |

#### フィールド {#fields-74}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbranchrulecreatebranchrule"></a>`branchRule` | [`BranchRule`](#branchrule) | ミューテーション後のブランチルール。 |
| <a id="mutationbranchrulecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationbranchrulecreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.branchRuleDelete` {#mutationbranchruledelete}

{{< details >}}GitLab 16.9で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `BranchRuleDeleteInput`

#### 引数 {#arguments-170}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbranchruledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationbranchruledeleteid"></a>`id` | [`ProjectsBranchRuleID!`](#projectsbranchruleid) | 削除するブランチルールのグローバルID。 |

#### フィールド {#fields-75}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbranchruledeletebranchrule"></a>`branchRule` | [`BranchRule`](#branchrule) | ミューテーション後のブランチルール。 |
| <a id="mutationbranchruledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationbranchruledeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.branchRuleExternalStatusCheckCreate` {#mutationbranchruleexternalstatuscheckcreate}

{{< details >}}GitLab 16.11で**導入**されました。**状態**: 実験的機能。{{< /details >}}

ブランチルールから新しい外部ステータスチェックを作成します。

入力型: `BranchRuleExternalStatusCheckCreateInput`

#### 引数 {#arguments-171}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbranchruleexternalstatuscheckcreatebranchruleid"></a>`branchRuleId` | [`ProjectsBranchRuleID!`](#projectsbranchruleid) | 更新するブランチルールのグローバルID。 |
| <a id="mutationbranchruleexternalstatuscheckcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationbranchruleexternalstatuscheckcreateexternalurl"></a>`externalUrl` | [`String!`](#string) | 外部ステータスチェックリソースのURL。 |
| <a id="mutationbranchruleexternalstatuscheckcreatename"></a>`name` | [`String!`](#string) | 外部ステータスチェックの名前。 |

#### フィールド {#fields-76}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbranchruleexternalstatuscheckcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationbranchruleexternalstatuscheckcreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationbranchruleexternalstatuscheckcreateexternalstatuscheck"></a>`externalStatusCheck` | [`ExternalStatusCheck`](#externalstatuscheck) | ミューテーション後の新しいステータスチェック。 |

### `Mutation.branchRuleExternalStatusCheckDestroy` {#mutationbranchruleexternalstatuscheckdestroy}

{{< details >}} GitLab 17.0で**導入**されました。**状態**: 実験的機能。{{< /details >}}

ブランチルールから外部ステータスチェックを破棄します。

入力型: `BranchRuleExternalStatusCheckDestroyInput`

#### 引数 {#arguments-172}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbranchruleexternalstatuscheckdestroybranchruleid"></a>`branchRuleId` | [`ProjectsBranchRuleID!`](#projectsbranchruleid) | ブランチルールのグローバルID。 |
| <a id="mutationbranchruleexternalstatuscheckdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationbranchruleexternalstatuscheckdestroyid"></a>`id` | [`MergeRequestsExternalStatusCheckID!`](#mergerequestsexternalstatuscheckid) | 削除する外部ステータスチェックのグローバルID。 |

#### フィールド {#fields-77}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbranchruleexternalstatuscheckdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationbranchruleexternalstatuscheckdestroyerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.branchRuleExternalStatusCheckUpdate` {#mutationbranchruleexternalstatuscheckupdate}

{{< details >}} GitLab 17.0で**導入**されました。**状態**: 実験的機能。{{< /details >}}

ブランチルールから外部ステータスチェックを更新します。

入力型: `BranchRuleExternalStatusCheckUpdateInput`

#### 引数 {#arguments-173}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbranchruleexternalstatuscheckupdatebranchruleid"></a>`branchRuleId` | [`ProjectsBranchRuleID!`](#projectsbranchruleid) | ブランチルールのグローバルID。 |
| <a id="mutationbranchruleexternalstatuscheckupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationbranchruleexternalstatuscheckupdateexternalurl"></a>`externalUrl` | [`String!`](#string) | 外部ステータスチェックの外部URL。 |
| <a id="mutationbranchruleexternalstatuscheckupdateid"></a>`id` | [`MergeRequestsExternalStatusCheckID!`](#mergerequestsexternalstatuscheckid) | 更新する外部ステータスチェックのグローバルID。 |
| <a id="mutationbranchruleexternalstatuscheckupdatename"></a>`name` | [`String!`](#string) | 外部ステータスチェックの名前。 |

#### フィールド {#fields-78}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbranchruleexternalstatuscheckupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationbranchruleexternalstatuscheckupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationbranchruleexternalstatuscheckupdateexternalstatuscheck"></a>`externalStatusCheck` | [`ExternalStatusCheck`](#externalstatuscheck) | ミューテーション後に更新された外部ステータスチェック。 |

### `Mutation.branchRuleSquashOptionDelete` {#mutationbranchrulesquashoptiondelete}

{{< details >}}GitLab 17.9で**導入**されました。**状態**: 実験的機能。{{< /details >}}

ブランチルールのスカッシュオプションを削除します。

入力型: `BranchRuleSquashOptionDeleteInput`

#### 引数 {#arguments-174}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbranchrulesquashoptiondeletebranchruleid"></a>`branchRuleId` | [`ProjectsBranchRuleID!`](#projectsbranchruleid) | ブランチルールのグローバルID。 |
| <a id="mutationbranchrulesquashoptiondeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |

#### フィールド {#fields-79}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbranchrulesquashoptiondeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationbranchrulesquashoptiondeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.branchRuleSquashOptionUpdate` {#mutationbranchrulesquashoptionupdate}

{{< details >}}GitLab 17.9で**導入**されました。**状態**: 実験的機能。{{< /details >}}

ブランチルールのスカッシュオプションを更新します。

入力型: `BranchRuleSquashOptionUpdateInput`

#### 引数 {#arguments-175}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbranchrulesquashoptionupdatebranchruleid"></a>`branchRuleId` | [`ProjectsBranchRuleID!`](#projectsbranchruleid) | ブランチルールのグローバルID。 |
| <a id="mutationbranchrulesquashoptionupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationbranchrulesquashoptionupdatesquashoption"></a>`squashOption` | [`SquashOptionSetting!`](#squashoptionsetting) | ミューテーション後のスカッシュオプション。 |

#### フィールド {#fields-80}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbranchrulesquashoptionupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationbranchrulesquashoptionupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationbranchrulesquashoptionupdatesquashoption"></a>`squashOption` | [`SquashOption`](#squashoption) | ミューテーション後に更新されたスカッシュオプション。 |

### `Mutation.branchRuleUpdate` {#mutationbranchruleupdate}

{{< details >}} GitLab 16.7で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `BranchRuleUpdateInput`

#### 引数 {#arguments-176}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbranchruleupdatebranchprotection"></a>`branchProtection` | [`BranchProtectionInput`](#branchprotectioninput) | ブランチルール用に設定されているブランチ保護。 |
| <a id="mutationbranchruleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationbranchruleupdateid"></a>`id` | [`ProjectsBranchRuleID!`](#projectsbranchruleid) | 更新するブランチルールのグローバルID。 |
| <a id="mutationbranchruleupdatename"></a>`name` | [`String!`](#string) | ブランチルールのブランチ名（ワイルドカードを含む）。 |

#### フィールド {#fields-81}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbranchruleupdatebranchrule"></a>`branchRule` | [`BranchRule`](#branchrule) | ミューテーション後のブランチルール。 |
| <a id="mutationbranchruleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationbranchruleupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.bulkDestroyJobArtifacts` {#mutationbulkdestroyjobartifacts}

{{< details >}}GitLab 15.10で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `BulkDestroyJobArtifactsInput`

#### 引数 {#arguments-177}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbulkdestroyjobartifactsclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationbulkdestroyjobartifactsids"></a>`ids` | [`[CiJobArtifactID!]!`](#cijobartifactid) | 削除するジョブアーティファクトのグローバルID。 |
| <a id="mutationbulkdestroyjobartifactsprojectid"></a>`projectId` | [`ProjectID!`](#projectid) | 削除するジョブアーティファクトのグローバルプロジェクトID。projectPathと互換性がありません。 |

#### フィールド {#fields-82}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbulkdestroyjobartifactsclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationbulkdestroyjobartifactsdestroyedcount"></a>`destroyedCount` | [`Int`](#int) | 削除されたジョブアーティファクトの数。 |
| <a id="mutationbulkdestroyjobartifactsdestroyedids"></a>`destroyedIds` | [`[CiJobArtifactID!]`](#cijobartifactid) | 削除されたジョブアーティファクトのID。 |
| <a id="mutationbulkdestroyjobartifactserrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.bulkEnableDevopsAdoptionNamespaces` {#mutationbulkenabledevopsadoptionnamespaces}

**状態**: ベータ版。

入力型: `BulkEnableDevopsAdoptionNamespacesInput`

#### 引数 {#arguments-178}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbulkenabledevopsadoptionnamespacesclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationbulkenabledevopsadoptionnamespacesdisplaynamespaceid"></a>`displayNamespaceId` | [`NamespaceID`](#namespaceid) | 表示ネームスペースID。 |
| <a id="mutationbulkenabledevopsadoptionnamespacesnamespaceids"></a>`namespaceIds` | [`[NamespaceID!]!`](#namespaceid) | ネームスペースIDのリスト。 |

#### フィールド {#fields-83}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbulkenabledevopsadoptionnamespacesclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationbulkenabledevopsadoptionnamespacesenablednamespaces"></a>`enabledNamespaces` | [`[DevopsAdoptionEnabledNamespace!]`](#devopsadoptionenablednamespace) | ミューテーション後に有効になったネームスペース。 |
| <a id="mutationbulkenabledevopsadoptionnamespaceserrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.bulkRunnerDelete` {#mutationbulkrunnerdelete}

{{< details >}}GitLab 15.3で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `BulkRunnerDeleteInput`

#### 引数 {#arguments-179}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbulkrunnerdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationbulkrunnerdeleteids"></a>`ids` | [`[CiRunnerID!]`](#cirunnerid) | 削除するRunnerのID。 |

#### フィールド {#fields-84}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationbulkrunnerdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationbulkrunnerdeletedeletedcount"></a>`deletedCount` | [`Int`](#int) | 有効削除されたレコードの数。同期操作が実行された場合にのみ存在します。 |
| <a id="mutationbulkrunnerdeletedeletedids"></a>`deletedIds` | [`[CiRunnerID!]`](#cirunnerid) | 有効削除されたレコードのID。同期操作が実行された場合にのみ存在します。 |
| <a id="mutationbulkrunnerdeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.catalogResourcesCreate` {#mutationcatalogresourcescreate}

{{< details >}}GitLab 15.11で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `CatalogResourcesCreateInput`

#### 引数 {#arguments-180}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcatalogresourcescreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcatalogresourcescreateprojectpath"></a>`projectPath` | [`ID!`](#id) | カタログリソースに属するプロジェクトパス。 |

#### フィールド {#fields-85}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcatalogresourcescreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcatalogresourcescreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.catalogResourcesDestroy` {#mutationcatalogresourcesdestroy}

{{< details >}} GitLab 16.6で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `CatalogResourcesDestroyInput`

#### 引数 {#arguments-181}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcatalogresourcesdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcatalogresourcesdestroyprojectpath"></a>`projectPath` | [`ID!`](#id) | カタログリソースに属するプロジェクトパス。 |

#### フィールド {#fields-86}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcatalogresourcesdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcatalogresourcesdestroyerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.ciJobTokenScopeAddGroupOrProject` {#mutationcijobtokenscopeaddgrouporproject}

入力型: `CiJobTokenScopeAddGroupOrProjectInput`

#### 引数 {#arguments-182}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscopeaddgrouporprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcijobtokenscopeaddgrouporprojectdefaultpermissions"></a>`defaultPermissions` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | **非推奨**: **状態**: 実験的機能。GitLab 17.8で導入されました。 |
| <a id="mutationcijobtokenscopeaddgrouporprojectjobtokenpolicies"></a>`jobTokenPolicies` {{< icon name="warning-solid" >}} | [`[CiJobTokenScopePolicies!]`](#cijobtokenscopepolicies) | **非推奨**: **状態**: 実験的機能。GitLab 17.5で導入されました。 |
| <a id="mutationcijobtokenscopeaddgrouporprojectprojectpath"></a>`projectPath` | [`ID!`](#id) | CIジョブトークンスコープが属するプロジェクト。 |
| <a id="mutationcijobtokenscopeaddgrouporprojecttargetpath"></a>`targetPath` | [`ID!`](#id) | CIジョブトークンスコープに追加するグループまたはプロジェクト。 |

#### フィールド {#fields-87}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscopeaddgrouporprojectcijobtokenscope"></a>`ciJobTokenScope` | [`CiJobTokenScopeType`](#cijobtokenscopetype) | CIジョブトークンのアクセススコープ。 |
| <a id="mutationcijobtokenscopeaddgrouporprojectcijobtokenscopeallowlistentry"></a>`ciJobTokenScopeAllowlistEntry` {{< icon name="warning-solid" >}} | [`CiJobTokenScopeAllowlistEntry`](#cijobtokenscopeallowlistentry) | **非推奨**: **状態**: 実験的機能。GitLab 17.6で導入されました。 |
| <a id="mutationcijobtokenscopeaddgrouporprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcijobtokenscopeaddgrouporprojecterrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.ciJobTokenScopeAddProject` {#mutationcijobtokenscopeaddproject}

入力型: `CiJobTokenScopeAddProjectInput`

#### 引数 {#arguments-183}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscopeaddprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcijobtokenscopeaddprojectdirection"></a>`direction` {{< icon name="warning-solid" >}} | [`CiJobTokenScopeDirection`](#cijobtokenscopedirection) | **非推奨**: 送信ジョブトークンスコープは削除されます。現在のところ、このフィールドで可能な設定値はINBOUNDだけです。GitLab 16.0で非推奨になりました。 |
| <a id="mutationcijobtokenscopeaddprojectprojectpath"></a>`projectPath` | [`ID!`](#id) | CIジョブトークンスコープが属するプロジェクト。 |
| <a id="mutationcijobtokenscopeaddprojecttargetprojectpath"></a>`targetProjectPath` | [`ID!`](#id) | CIジョブトークンスコープに追加するプロジェクト。 |

#### フィールド {#fields-88}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscopeaddprojectcijobtokenscope"></a>`ciJobTokenScope` | [`CiJobTokenScopeType`](#cijobtokenscopetype) | CIジョブトークンのアクセススコープ。 |
| <a id="mutationcijobtokenscopeaddprojectcijobtokenscopeallowlistentry"></a>`ciJobTokenScopeAllowlistEntry` {{< icon name="warning-solid" >}} | [`CiJobTokenScopeAllowlistEntry`](#cijobtokenscopeallowlistentry) | **非推奨**: **状態**: 実験的機能。GitLab 17.6で導入されました。 |
| <a id="mutationcijobtokenscopeaddprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcijobtokenscopeaddprojecterrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.ciJobTokenScopeAutopopulateAllowlist` {#mutationcijobtokenscopeautopopulateallowlist}

{{< details >}}GitLab 17.9で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `CiJobTokenScopeAutopopulateAllowlistInput`

#### 引数 {#arguments-184}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscopeautopopulateallowlistclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcijobtokenscopeautopopulateallowlistprojectpath"></a>`projectPath` | [`ID!`](#id) | 許可リストを自動設定するプロジェクト。 |

#### フィールド {#fields-89}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscopeautopopulateallowlistclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcijobtokenscopeautopopulateallowlisterrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationcijobtokenscopeautopopulateallowliststatus"></a>`status` | [`String!`](#string) | 自動設定プロセスのステータス。 |

### `Mutation.ciJobTokenScopeClearAllowlistAutopopulations` {#mutationcijobtokenscopeclearallowlistautopopulations}

{{< details >}}GitLab 17.9で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `CiJobTokenScopeClearAllowlistAutopopulationsInput`

#### 引数 {#arguments-185}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscopeclearallowlistautopopulationsclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcijobtokenscopeclearallowlistautopopulationsprojectpath"></a>`projectPath` | [`ID!`](#id) | 許可リストを自動設定するプロジェクト。 |

#### フィールド {#fields-90}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscopeclearallowlistautopopulationsclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcijobtokenscopeclearallowlistautopopulationserrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationcijobtokenscopeclearallowlistautopopulationsstatus"></a>`status` | [`String!`](#string) | 自動設定プロセスのステータス。 |

### `Mutation.ciJobTokenScopeRemoveGroup` {#mutationcijobtokenscoperemovegroup}

入力型: `CiJobTokenScopeRemoveGroupInput`

#### 引数 {#arguments-186}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscoperemovegroupclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcijobtokenscoperemovegroupprojectpath"></a>`projectPath` | [`ID!`](#id) | CIジョブトークンスコープが属するプロジェクト。 |
| <a id="mutationcijobtokenscoperemovegrouptargetgrouppath"></a>`targetGroupPath` | [`ID!`](#id) | CIジョブトークンスコープから削除するグループ。 |

#### フィールド {#fields-91}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscoperemovegroupcijobtokenscope"></a>`ciJobTokenScope` | [`CiJobTokenScopeType`](#cijobtokenscopetype) | CIジョブトークンのアクセススコープ。 |
| <a id="mutationcijobtokenscoperemovegroupcijobtokenscopeallowlistentry"></a>`ciJobTokenScopeAllowlistEntry` {{< icon name="warning-solid" >}} | [`CiJobTokenScopeAllowlistEntry`](#cijobtokenscopeallowlistentry) | **非推奨**: **状態**: 実験的機能。GitLab 17.6で導入されました。 |
| <a id="mutationcijobtokenscoperemovegroupclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcijobtokenscoperemovegrouperrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.ciJobTokenScopeRemoveProject` {#mutationcijobtokenscoperemoveproject}

入力型: `CiJobTokenScopeRemoveProjectInput`

#### 引数 {#arguments-187}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscoperemoveprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcijobtokenscoperemoveprojectdirection"></a>`direction` {{< icon name="warning-solid" >}} | [`CiJobTokenScopeDirection`](#cijobtokenscopedirection) | **非推奨**: 送信ジョブトークンスコープは削除されます。現在のところ、このフィールドで可能な設定値はINBOUNDだけです。GitLab 16.9で非推奨になりました。 |
| <a id="mutationcijobtokenscoperemoveprojectprojectpath"></a>`projectPath` | [`ID!`](#id) | CIジョブトークンスコープが属するプロジェクト。 |
| <a id="mutationcijobtokenscoperemoveprojecttargetprojectpath"></a>`targetProjectPath` | [`ID!`](#id) | CIジョブトークンスコープから削除するプロジェクト。 |

#### フィールド {#fields-92}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscoperemoveprojectcijobtokenscope"></a>`ciJobTokenScope` | [`CiJobTokenScopeType`](#cijobtokenscopetype) | CIジョブトークンのアクセススコープ。 |
| <a id="mutationcijobtokenscoperemoveprojectcijobtokenscopeallowlistentry"></a>`ciJobTokenScopeAllowlistEntry` {{< icon name="warning-solid" >}} | [`CiJobTokenScopeAllowlistEntry`](#cijobtokenscopeallowlistentry) | **非推奨**: **状態**: 実験的機能。GitLab 17.6で導入されました。 |
| <a id="mutationcijobtokenscoperemoveprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcijobtokenscoperemoveprojecterrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.ciJobTokenScopeUpdatePolicies` {#mutationcijobtokenscopeupdatepolicies}

{{< details >}}GitLab 17.6で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `CiJobTokenScopeUpdatePoliciesInput`

#### 引数 {#arguments-188}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscopeupdatepoliciesclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcijobtokenscopeupdatepoliciesdefaultpermissions"></a>`defaultPermissions` | [`Boolean!`](#boolean) | デフォルトの権限が有効か（true）、きめ細かいアクセス権限が有効か（false）を示します。 |
| <a id="mutationcijobtokenscopeupdatepoliciesjobtokenpolicies"></a>`jobTokenPolicies` | [`[CiJobTokenScopePolicies!]!`](#cijobtokenscopepolicies) | CIジョブトークンスコープに追加されたポリシーのリスト。 |
| <a id="mutationcijobtokenscopeupdatepoliciesprojectpath"></a>`projectPath` | [`ID!`](#id) | CIジョブトークンスコープが属するプロジェクト。 |
| <a id="mutationcijobtokenscopeupdatepoliciestargetpath"></a>`targetPath` | [`ID!`](#id) | CIジョブトークンのターゲットとなるグループまたはプロジェクト。 |

#### フィールド {#fields-93}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscopeupdatepoliciescijobtokenscopeallowlistentry"></a>`ciJobTokenScopeAllowlistEntry` {{< icon name="warning-solid" >}} | [`CiJobTokenScopeAllowlistEntry`](#cijobtokenscopeallowlistentry) | **非推奨**: **状態**: 実験的機能。GitLab 17.6で導入されました。 |
| <a id="mutationcijobtokenscopeupdatepoliciesclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcijobtokenscopeupdatepolicieserrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.ciLint` {#mutationcilint}

lintおよび処理されたCI設定内容。1回のリクエストで複数のリクエストはしないでください。

入力型: `CiLintInput`

#### 引数 {#arguments-189}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcilintclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcilintcontent"></a>`content` | [`String!`](#string) | `.gitlab-ci.yml`の内容。 |
| <a id="mutationcilintdryrun"></a>`dryRun` | [`Boolean`](#boolean) | パイプライン作成シミュレーションを実行するか、または静的チェックのみ実行します。 |
| <a id="mutationcilintprojectpath"></a>`projectPath` | [`ID!`](#id) | CI設定のプロジェクト。 |
| <a id="mutationcilintref"></a>`ref` | [`String`](#string) | Lint時に使用するRef。デフォルトは、プロジェクトのデフォルトブランチです。 |

#### フィールド {#fields-94}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcilintclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcilintconfig"></a>`config` | [`CiConfigV2`](#ciconfigv2) | LintされたCI設定とメタデータ。 |
| <a id="mutationcilinterrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.clusterAgentDelete` {#mutationclusteragentdelete}

入力型: `ClusterAgentDeleteInput`

#### 引数 {#arguments-190}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationclusteragentdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationclusteragentdeleteid"></a>`id` | [`ClustersAgentID!`](#clustersagentid) | 削除するクラスターエージェントのグローバルID。 |

#### フィールド {#fields-95}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationclusteragentdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationclusteragentdeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.clusterAgentTokenCreate` {#mutationclusteragenttokencreate}

入力型: `ClusterAgentTokenCreateInput`

#### 引数 {#arguments-191}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationclusteragenttokencreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationclusteragenttokencreateclusteragentid"></a>`clusterAgentId` | [`ClustersAgentID!`](#clustersagentid) | 新しいトークンに関連付けられるクラスターエージェントのグローバルID。 |
| <a id="mutationclusteragenttokencreatedescription"></a>`description` | [`String`](#string) | トークンの説明。 |
| <a id="mutationclusteragenttokencreatename"></a>`name` | [`String!`](#string) | トークンの名前。 |

#### フィールド {#fields-96}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationclusteragenttokencreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationclusteragenttokencreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationclusteragenttokencreatesecret"></a>`secret` | [`String`](#string) | トークンのシークレット値。必ず保存してください。そうしないと、再度アクセスできなくなります。 |
| <a id="mutationclusteragenttokencreatetoken"></a>`token` | [`ClusterAgentToken`](#clusteragenttoken) | ミューテーション後に作成されたトークン。 |

### `Mutation.clusterAgentTokenRevoke` {#mutationclusteragenttokenrevoke}

入力型: `ClusterAgentTokenRevokeInput`

#### 引数 {#arguments-192}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationclusteragenttokenrevokeclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationclusteragenttokenrevokeid"></a>`id` | [`ClustersAgentTokenID!`](#clustersagenttokenid) | 失効するエージェントトークンのグローバルID。 |

#### フィールド {#fields-97}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationclusteragenttokenrevokeclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationclusteragenttokenrevokeerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.clusterAgentUrlConfigurationCreate` {#mutationclusteragenturlconfigurationcreate}

入力型: `ClusterAgentUrlConfigurationCreateInput`

#### 引数 {#arguments-193}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationclusteragenturlconfigurationcreatecacert"></a>`caCert` | [`String`](#string) | エージェントエンドポイントを検証するための、PEM形式Base64エンコードのCA証明書。 |
| <a id="mutationclusteragenturlconfigurationcreateclientcert"></a>`clientCert` | [`String`](#string) | mTLS認証を使用する場合、PEM形式Base64エンコードのクライアント証明書。`client_key`と共に指定する必要があります。 |
| <a id="mutationclusteragenturlconfigurationcreateclientkey"></a>`clientKey` | [`String`](#string) | mTLS認証を使用する場合、PEM形式Base64エンコードのクライアントキー。`client_cert`と共に指定する必要があります。 |
| <a id="mutationclusteragenturlconfigurationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationclusteragenturlconfigurationcreateclusteragentid"></a>`clusterAgentId` | [`ClustersAgentID!`](#clustersagentid) | 新しいURL設定に関連付けられるクラスターエージェントのグローバルID。 |
| <a id="mutationclusteragenturlconfigurationcreatetlshost"></a>`tlsHost` | [`String`](#string) | エージェントエンドポイント証明書のサーバー名を検証するためのTLSホスト名。 |
| <a id="mutationclusteragenturlconfigurationcreateurl"></a>`url` | [`String!`](#string) | 新しいURL設定のURL。 |

#### フィールド {#fields-98}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationclusteragenturlconfigurationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationclusteragenturlconfigurationcreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationclusteragenturlconfigurationcreateurlconfiguration"></a>`urlConfiguration` | [`ClusterAgentUrlConfiguration`](#clusteragenturlconfiguration) | ミューテーション後に作成されたURL設定。 |

### `Mutation.clusterAgentUrlConfigurationDelete` {#mutationclusteragenturlconfigurationdelete}

入力型: `ClusterAgentUrlConfigurationDeleteInput`

#### 引数 {#arguments-194}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationclusteragenturlconfigurationdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationclusteragenturlconfigurationdeleteid"></a>`id` | [`ClustersAgentsUrlConfigurationID!`](#clustersagentsurlconfigurationid) | 削除するエージェントURL設定のグローバルID。 |

#### フィールド {#fields-99}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationclusteragenturlconfigurationdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationclusteragenturlconfigurationdeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.commitCreate` {#mutationcommitcreate}

入力型: `CommitCreateInput`

#### 引数 {#arguments-195}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcommitcreateactions"></a>`actions` | [`[CommitAction!]!`](#commitaction) | バッチとしてコミットするアクションハッシュの配列。 |
| <a id="mutationcommitcreatebranch"></a>`branch` | [`String!`](#string) | コミットするブランチの名前。新しいブランチも可能。 |
| <a id="mutationcommitcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcommitcreatemessage"></a>`message` | [`String!`](#string) | Rawのコミットメッセージ。 |
| <a id="mutationcommitcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | ブランチが関連付けられているプロジェクトのフルパス。 |
| <a id="mutationcommitcreatestartbranch"></a>`startBranch` | [`String`](#string) | 新しいブランチの場合、元のブランチの名前。 |

#### フィールド {#fields-100}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcommitcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcommitcreatecommit"></a>`commit` | [`Commit`](#commit) | ミューテーション後のコミット。 |
| <a id="mutationcommitcreatecommitpipelinepath"></a>`commitPipelinePath` | [`String`](#string) | コミットのパイプラインのETagパス。 |
| <a id="mutationcommitcreatecontent"></a>`content` | [`[String!]`](#string) | コミットの内容。 |
| <a id="mutationcommitcreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.configureContainerScanning` {#mutationconfigurecontainerscanning}

新しいブランチの新規または変更後`.gitlab-ci.yml`ファイルでコンテナスキャンを有効にすることにより、プロジェクトのコンテナスキャンを設定します。新しいブランチとマージリクエストを作成するためのURLが、レスポンスの一部として含まれます。

入力型: `ConfigureContainerScanningInput`

#### 引数 {#arguments-196}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationconfigurecontainerscanningclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationconfigurecontainerscanningprojectpath"></a>`projectPath` | [`ID!`](#id) | プロジェクトのフルパス。 |

#### フィールド {#fields-101}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationconfigurecontainerscanningbranch"></a>`branch` | [`String`](#string) | 新規/変更後`.gitlab-ci.yml`ファイルのあるブランチ。 |
| <a id="mutationconfigurecontainerscanningclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationconfigurecontainerscanningerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationconfigurecontainerscanningsuccesspath"></a>`successPath` | [`String`](#string) | レスポンス成功の場合に使用するリダイレクトパス。 |

### `Mutation.configureDependencyScanning` {#mutationconfiguredependencyscanning}

新しいブランチの新規または変更後`.gitlab-ci.yml`ファイルで依存関係スキャンを有効にすることにより、プロジェクトの依存関係スキャンを設定します。新しいブランチとマージリクエストを作成するためのURLが、レスポンスの一部として含まれます。

入力型: `ConfigureDependencyScanningInput`

#### 引数 {#arguments-197}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationconfiguredependencyscanningclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationconfiguredependencyscanningprojectpath"></a>`projectPath` | [`ID!`](#id) | プロジェクトのフルパス。 |

#### フィールド {#fields-102}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationconfiguredependencyscanningbranch"></a>`branch` | [`String`](#string) | 新規/変更後`.gitlab-ci.yml`ファイルのあるブランチ。 |
| <a id="mutationconfiguredependencyscanningclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationconfiguredependencyscanningerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationconfiguredependencyscanningsuccesspath"></a>`successPath` | [`String`](#string) | レスポンス成功の場合に使用するリダイレクトパス。 |

### `Mutation.configureSast` {#mutationconfiguresast}

新しいブランチの新規または変更後の`.gitlab-ci.yml`ファイルでSASTを有効にすることにより、プロジェクトのSASTを設定します。新しいブランチとマージリクエストを作成するためのURLが、レスポンスの一部として含まれます。

入力型: `ConfigureSastInput`

#### 引数 {#arguments-198}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationconfiguresastclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationconfiguresastconfiguration"></a>`configuration` | [`SastCiConfigurationInput!`](#sastciconfigurationinput) | プロジェクトのSAST CI設定。 |
| <a id="mutationconfiguresastprojectpath"></a>`projectPath` | [`ID!`](#id) | プロジェクトのフルパス。 |

#### フィールド {#fields-103}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationconfiguresastbranch"></a>`branch` | [`String`](#string) | 新規/変更後`.gitlab-ci.yml`ファイルのあるブランチ。 |
| <a id="mutationconfiguresastclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationconfiguresasterrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationconfiguresastsuccesspath"></a>`successPath` | [`String`](#string) | レスポンス成功の場合に使用するリダイレクトパス。 |

### `Mutation.configureSastIac` {#mutationconfiguresastiac}

新しいブランチの新規または変更後`.gitlab-ci.yml`ファイルで、プロジェクトに対しSAST IaCを有効にします。新しいブランチとマージリクエストを作成するためのURLが、レスポンスの一部として含まれます。

入力型: `ConfigureSastIacInput`

#### 引数 {#arguments-199}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationconfiguresastiacclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationconfiguresastiacprojectpath"></a>`projectPath` | [`ID!`](#id) | プロジェクトのフルパス。 |

#### フィールド {#fields-104}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationconfiguresastiacbranch"></a>`branch` | [`String`](#string) | 新規/変更後`.gitlab-ci.yml`ファイルのあるブランチ。 |
| <a id="mutationconfiguresastiacclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationconfiguresastiacerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationconfiguresastiacsuccesspath"></a>`successPath` | [`String`](#string) | レスポンス成功の場合に使用するリダイレクトパス。 |

### `Mutation.configureSecretDetection` {#mutationconfiguresecretdetection}

新しいブランチの新規または変更後`.gitlab-ci.yml`ファイルでシークレット検出を有効にすることにより、プロジェクトのシークレット検出を設定します。新しいブランチとマージリクエストを作成するためのURLが、レスポンスの一部として含まれます。

入力型: `ConfigureSecretDetectionInput`

#### 引数 {#arguments-200}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationconfiguresecretdetectionclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationconfiguresecretdetectionprojectpath"></a>`projectPath` | [`ID!`](#id) | プロジェクトのフルパス。 |

#### フィールド {#fields-105}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationconfiguresecretdetectionbranch"></a>`branch` | [`String`](#string) | 新規/変更後`.gitlab-ci.yml`ファイルのあるブランチ。 |
| <a id="mutationconfiguresecretdetectionclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationconfiguresecretdetectionerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationconfiguresecretdetectionsuccesspath"></a>`successPath` | [`String`](#string) | レスポンス成功の場合に使用するリダイレクトパス。 |

### `Mutation.corpusCreate` {#mutationcorpuscreate}

入力型: `CorpusCreateInput`

#### 引数 {#arguments-201}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcorpuscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcorpuscreatefullpath"></a>`fullPath` | [`ID!`](#id) | コーパスが属するプロジェクト。 |
| <a id="mutationcorpuscreatepackageid"></a>`packageId` | [`PackagesPackageID!`](#packagespackageid) | コーパスパッケージのID。 |

#### フィールド {#fields-106}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcorpuscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcorpuscreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.createAbuseReportNote` {#mutationcreateabusereportnote}

不正行為レポートのノートを作成します。

入力型: `CreateAbuseReportNoteInput`

#### 引数 {#arguments-202}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreateabusereportnoteabusereportid"></a>`abuseReportId` | [`AbuseReportID!`](#abusereportid) | 不正行為レポートのID。 |
| <a id="mutationcreateabusereportnotebody"></a>`body` | [`String!`](#string) | ノートの内容。 |
| <a id="mutationcreateabusereportnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcreateabusereportnotediscussionid"></a>`discussionId` | [`DiscussionID`](#discussionid) | ノートを含める返信の対象となる不正行為レポートディスカッションのグローバルID。 |

#### フィールド {#fields-107}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreateabusereportnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcreateabusereportnoteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationcreateabusereportnotenote"></a>`note` | [`AbuseReportNote`](#abusereportnote) | ミューテーション後の不正行為レポートノート。 |

### `Mutation.createAlertIssue` {#mutationcreatealertissue}

入力型: `CreateAlertIssueInput`

#### 引数 {#arguments-203}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatealertissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcreatealertissueiid"></a>`iid` | [`String!`](#string) | ミューテーション対象のアラートのIID。 |
| <a id="mutationcreatealertissueprojectpath"></a>`projectPath` | [`ID!`](#id) | ミューテーション対象のアラートの属するプロジェクト。 |

#### フィールド {#fields-108}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatealertissuealert"></a>`alert` | [`AlertManagementAlert`](#alertmanagementalert) | ミューテーション後のアラート。 |
| <a id="mutationcreatealertissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcreatealertissueerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationcreatealertissueissue"></a>`issue` | [`Issue`](#issue) | ミューテーション後に作成されたイシュー。 |
| <a id="mutationcreatealertissuetodo"></a>`todo` | [`Todo`](#todo) | ミューテーション後のTo Doアイテム。 |

### `Mutation.createAnnotation` {#mutationcreateannotation}

{{< details >}} GitLab 16.0で**非推奨**になりました。基盤となる機能は16.0で削除されました。{{< /details >}}

入力型: `CreateAnnotationInput`

#### 引数 {#arguments-204}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreateannotationclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcreateannotationclusterid"></a>`clusterId` | [`ClustersClusterID`](#clustersclusterid) | アノテーション追加先のクラスターのグローバルID。 |
| <a id="mutationcreateannotationdashboardpath"></a>`dashboardPath` | [`String!`](#string) | アノテーションを追加するダッシュボードを定義するファイルへのパス。 |
| <a id="mutationcreateannotationdescription"></a>`description` | [`String!`](#string) | アノテーションの説明。 |
| <a id="mutationcreateannotationendingat"></a>`endingAt` | [`Time`](#time) | アノテーションが関係する終了時点を示すタイムスタンプ。 |
| <a id="mutationcreateannotationenvironmentid"></a>`environmentId` | [`EnvironmentID`](#environmentid) | アノテーション追加先の環境のグローバルID。 |
| <a id="mutationcreateannotationstartingat"></a>`startingAt` | [`Time!`](#time) | アノテーションが関係する開始時点を示すタイムスタンプ。 |

#### フィールド {#fields-109}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreateannotationannotation"></a>`annotation` | [`MetricsDashboardAnnotation`](#metricsdashboardannotation) | 作成されたアノテーション。 |
| <a id="mutationcreateannotationclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcreateannotationerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.createBoard` {#mutationcreateboard}

入力型: `CreateBoardInput`

#### 引数 {#arguments-205}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreateboardassigneeid"></a>`assigneeId` | [`UserID`](#userid) | ボードに割り当てるユーザーのID。 |
| <a id="mutationcreateboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcreateboardgrouppath"></a>`groupPath` | [`ID`](#id) | リソースが関連付けられているグループのフルパス。 |
| <a id="mutationcreateboardhidebackloglist"></a>`hideBacklogList` | [`Boolean`](#boolean) | バックログリストを非表示にするかどうか。 |
| <a id="mutationcreateboardhideclosedlist"></a>`hideClosedList` | [`Boolean`](#boolean) | 完了リストを非表示にするかどうか。 |
| <a id="mutationcreateboarditerationcadenceid"></a>`iterationCadenceId` | [`IterationsCadenceID`](#iterationscadenceid) | ボードに割り当てるイテレーションの反復ID。 |
| <a id="mutationcreateboarditerationid"></a>`iterationId` | [`IterationID`](#iterationid) | ボードに割り当てるイテレーションのID。 |
| <a id="mutationcreateboardlabelids"></a>`labelIds` | [`[LabelID!]`](#labelid) | ボードに追加するラベルのID。 |
| <a id="mutationcreateboardlabels"></a>`labels` | [`[String!]`](#string) | イシューのラベル。 |
| <a id="mutationcreateboardmilestoneid"></a>`milestoneId` | [`MilestoneID`](#milestoneid) | ボードに割り当てるマイルストーンのID。 |
| <a id="mutationcreateboardname"></a>`name` | [`String`](#string) | ボード名。 |
| <a id="mutationcreateboardprojectpath"></a>`projectPath` | [`ID`](#id) | リソースが関連付けられているプロジェクトのフルパス。 |
| <a id="mutationcreateboardweight"></a>`weight` | [`Int`](#int) | ボードに割り当てるウェイト値。 |

#### フィールド {#fields-110}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreateboardboard"></a>`board` | [`Board`](#board) | ミューテーション後のボード。 |
| <a id="mutationcreateboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcreateboarderrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.createBranch` {#mutationcreatebranch}

入力型: `CreateBranchInput`

#### 引数 {#arguments-206}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatebranchclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcreatebranchname"></a>`name` | [`String!`](#string) | ブランチの名前。 |
| <a id="mutationcreatebranchprojectpath"></a>`projectPath` | [`ID!`](#id) | ブランチが関連付けられているプロジェクトのフルパス。 |
| <a id="mutationcreatebranchref"></a>`ref` | [`String!`](#string) | ブランチの作成元となるブランチ名またはコミットSHA。 |

#### フィールド {#fields-111}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatebranchbranch"></a>`branch` | [`Branch`](#branch) | ミューテーション後のブランチ。 |
| <a id="mutationcreatebranchclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcreatebrancherrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.createClusterAgent` {#mutationcreateclusteragent}

入力型: `CreateClusterAgentInput`

#### 引数 {#arguments-207}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreateclusteragentclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcreateclusteragentname"></a>`name` | [`String!`](#string) | クラスターエージェントの名前。 |
| <a id="mutationcreateclusteragentprojectpath"></a>`projectPath` | [`ID!`](#id) | クラスターエージェントの関連プロジェクトのフルパス。 |

#### フィールド {#fields-112}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreateclusteragentclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcreateclusteragentclusteragent"></a>`clusterAgent` | [`ClusterAgent`](#clusteragent) | ミューテーション後に作成されたクラスターエージェント。 |
| <a id="mutationcreateclusteragenterrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.createComplianceFramework` {#mutationcreatecomplianceframework}

入力型: `CreateComplianceFrameworkInput`

#### 引数 {#arguments-208}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatecomplianceframeworkclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcreatecomplianceframeworknamespacepath"></a>`namespacePath` | [`ID!`](#id) | コンプライアンスフレームワークの追加先ネームスペースのフルパス。 |
| <a id="mutationcreatecomplianceframeworkparams"></a>`params` | [`ComplianceFrameworkInput!`](#complianceframeworkinput) | コンプライアンスフレームワークを更新するためのパラメータ。 |

#### フィールド {#fields-113}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatecomplianceframeworkclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcreatecomplianceframeworkerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationcreatecomplianceframeworkframework"></a>`framework` | [`ComplianceFramework`](#complianceframework) | 作成されたコンプライアンスフレームワーク。 |

### `Mutation.createComplianceRequirement` {#mutationcreatecompliancerequirement}

{{< details >}}GitLab 17.6で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `CreateComplianceRequirementInput`

#### 引数 {#arguments-209}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatecompliancerequirementclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcreatecompliancerequirementcomplianceframeworkid"></a>`complianceFrameworkId` | [`ComplianceManagementFrameworkID!`](#compliancemanagementframeworkid) | 新しい要件のコンプライアンスフレームワークのグローバルID。 |
| <a id="mutationcreatecompliancerequirementcontrols"></a>`controls` | [`[ComplianceRequirementsControlInput!]`](#compliancerequirementscontrolinput) | コンプライアンス要件に追加するコントロール。 |
| <a id="mutationcreatecompliancerequirementparams"></a>`params` | [`ComplianceRequirementInput!`](#compliancerequirementinput) | コンプライアンス要件を更新するためのパラメータ。 |

#### フィールド {#fields-114}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatecompliancerequirementclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcreatecompliancerequirementerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationcreatecompliancerequirementrequirement"></a>`requirement` | [`ComplianceRequirement`](#compliancerequirement) | 作成されたコンプライアンス要件。 |

### `Mutation.createComplianceRequirementsControl` {#mutationcreatecompliancerequirementscontrol}

{{< details >}}GitLab 17.9で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `CreateComplianceRequirementsControlInput`

#### 引数 {#arguments-210}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatecompliancerequirementscontrolclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcreatecompliancerequirementscontrolcompliancerequirementid"></a>`complianceRequirementId` | [`ComplianceManagementComplianceFrameworkComplianceRequirementID!`](#compliancemanagementcomplianceframeworkcompliancerequirementid) | 新しいコントロールのコンプライアンス要件のグローバルID。 |
| <a id="mutationcreatecompliancerequirementscontrolparams"></a>`params` | [`ComplianceRequirementsControlInput!`](#compliancerequirementscontrolinput) | コンプライアンス要件コントロールを作成するためのパラメータ。 |

#### フィールド {#fields-115}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatecompliancerequirementscontrolclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcreatecompliancerequirementscontrolerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationcreatecompliancerequirementscontrolrequirementscontrol"></a>`requirementsControl` | [`ComplianceRequirementsControl`](#compliancerequirementscontrol) | 作成されたコンプライアンス要件コントロール。 |

### `Mutation.createContainerProtectionRepositoryRule` {#mutationcreatecontainerprotectionrepositoryrule}

プロジェクトのコンテナレジストリへのアクセスを制限するためのリポジトリ保護ルールを作成します。

入力型: `CreateContainerProtectionRepositoryRuleInput`

#### 引数 {#arguments-211}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatecontainerprotectionrepositoryruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcreatecontainerprotectionrepositoryruleminimumaccesslevelfordelete"></a>`minimumAccessLevelForDelete` | [`ContainerProtectionRepositoryRuleAccessLevel`](#containerprotectionrepositoryruleaccesslevel) | コンテナリポジトリからコンテナイメージを削除するために必要な最小GitLabアクセスレベル。有効な値には`MAINTAINER`、`OWNER`、または`ADMIN`が含まれます。値が`nil`の場合のデフォルトの最小アクセスレベルは`DEVELOPER`です。 |
| <a id="mutationcreatecontainerprotectionrepositoryruleminimumaccesslevelforpush"></a>`minimumAccessLevelForPush` | [`ContainerProtectionRepositoryRuleAccessLevel`](#containerprotectionrepositoryruleaccesslevel) | コンテナイメージをコンテナリポジトリにプッシュするために必要な最小GitLabアクセスレベル。有効な値には`MAINTAINER`、`OWNER`、または`ADMIN`が含まれます。値が`nil`の場合のデフォルトの最小アクセスレベルは`DEVELOPER`です。 |
| <a id="mutationcreatecontainerprotectionrepositoryruleprojectpath"></a>`projectPath` | [`ID!`](#id) | 保護ルールの属するプロジェクトのフルパス。 |
| <a id="mutationcreatecontainerprotectionrepositoryrulerepositorypathpattern"></a>`repositoryPathPattern` | [`String!`](#string) | 保護ルールによって保護されるコンテナリポジトリパスパターン。先頭がプロジェクトのフルパスでなければなりません。例: `my-project/*-prod-*`。ワイルドカード文字`*`は、プロジェクトのフルパスの後なら、どこにでも使用できます。 |

#### フィールド {#fields-116}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatecontainerprotectionrepositoryruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcreatecontainerprotectionrepositoryrulecontainerprotectionrepositoryrule"></a>`containerProtectionRepositoryRule` | [`ContainerProtectionRepositoryRule`](#containerprotectionrepositoryrule) | ミューテーション後のコンテナリポジトリ保護ルール。 |
| <a id="mutationcreatecontainerprotectionrepositoryruleerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.createContainerProtectionTagRule` {#mutationcreatecontainerprotectiontagrule}

{{< details >}}GitLab 17.8で**導入**されました。**状態**: 実験的機能。{{< /details >}}

指定されたパターンに一致するコンテナイメージタグを変更できるユーザーロールを制御する保護ルールを作成します。

入力型: `createContainerProtectionTagRuleInput`

#### 引数 {#arguments-212}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatecontainerprotectiontagruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcreatecontainerprotectiontagruleminimumaccesslevelfordelete"></a>`minimumAccessLevelForDelete` | [`ContainerProtectionTagRuleAccessLevel`](#containerprotectiontagruleaccesslevel) | コンテナリポジトリからコンテナイメージタグを削除するために必要な最小GitLabアクセスレベル。有効な値には`MAINTAINER`、`OWNER`、または`ADMIN`が含まれます。GitLab 17.8で導入されました。**状態**: 実験的機能。値が`nil`の場合、どのアクセスレベルでもタグを削除できません。 |
| <a id="mutationcreatecontainerprotectiontagruleminimumaccesslevelforpush"></a>`minimumAccessLevelForPush` | [`ContainerProtectionTagRuleAccessLevel`](#containerprotectiontagruleaccesslevel) | コンテナイメージタグをコンテナリポジトリにプッシュするために必要な最小GitLabアクセスレベル。有効な値には`MAINTAINER`、`OWNER`、または`ADMIN`が含まれます。GitLab 17.8で導入されました。**状態**: 実験的機能。値が`nil`の場合、どのアクセスレベルもタグをプッシュできません。 |
| <a id="mutationcreatecontainerprotectiontagruleprojectpath"></a>`projectPath` | [`ID!`](#id) | コンテナイメージタグを含むプロジェクトのフルパス。 |
| <a id="mutationcreatecontainerprotectiontagruletagnamepattern"></a>`tagNamePattern` | [`String!`](#string) | 保護するコンテナイメージタグに一致するパターン。例: `v1.*`。ワイルドカード文字`*`を使用できます。GitLab 17.8で導入されました。**状態**: 実験的機能。 |

#### フィールド {#fields-117}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatecontainerprotectiontagruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcreatecontainerprotectiontagrulecontainerprotectiontagrule"></a>`containerProtectionTagRule` {{< icon name="warning-solid" >}} | [`ContainerProtectionTagRule`](#containerprotectiontagrule) | **非推奨**: **状態**: 実験的機能。GitLab 17.8で導入されました。 |
| <a id="mutationcreatecontainerprotectiontagruleerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.createCustomEmoji` {#mutationcreatecustomemoji}

入力型: `CreateCustomEmojiInput`

#### 引数 {#arguments-213}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatecustomemojiclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcreatecustomemojigrouppath"></a>`groupPath` | [`ID!`](#id) | 絵文字が関連付けられているネームスペースのフルパス。 |
| <a id="mutationcreatecustomemojiname"></a>`name` | [`String!`](#string) | 絵文字の名前。 |
| <a id="mutationcreatecustomemojiurl"></a>`url` | [`String!`](#string) | 絵文字ファイルの場所。 |

#### フィールド {#fields-118}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatecustomemojiclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcreatecustomemojicustomemoji"></a>`customEmoji` | [`CustomEmoji`](#customemoji) | 新しいカスタム絵文字。 |
| <a id="mutationcreatecustomemojierrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.createDiffNote` {#mutationcreatediffnote}

入力型: `CreateDiffNoteInput`

#### 引数 {#arguments-214}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatediffnotebody"></a>`body` | [`String!`](#string) | ノートの内容。 |
| <a id="mutationcreatediffnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcreatediffnoteinternal"></a>`internal` | [`Boolean`](#boolean) | ノートの内部フラグ。デフォルトはfalseです。 |
| <a id="mutationcreatediffnotenoteableid"></a>`noteableId` | [`NoteableID!`](#noteableid) | ノート追加先のリソースのグローバルID。 |
| <a id="mutationcreatediffnoteposition"></a>`position` | [`DiffPositionInput!`](#diffpositioninput) | 差分に関するノートの位置。 |

#### フィールド {#fields-119}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatediffnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcreatediffnoteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationcreatediffnotenote"></a>`note` | [`Note`](#note) | ミューテーション後のノート。 |
| <a id="mutationcreatediffnotequickactionsstatus"></a>`quickActionsStatus` | [`QuickActionsStatus`](#quickactionsstatus) | ミューテーション後のクイックアクションのステータス。 |

### `Mutation.createDiscussion` {#mutationcreatediscussion}

入力型: `CreateDiscussionInput`

#### 引数 {#arguments-215}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatediscussionbody"></a>`body` | [`String!`](#string) | ノートの内容。 |
| <a id="mutationcreatediscussionclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcreatediscussioninternal"></a>`internal` | [`Boolean`](#boolean) | ノートの内部フラグ。デフォルトはfalseです。 |
| <a id="mutationcreatediscussionnoteableid"></a>`noteableId` | [`NoteableID!`](#noteableid) | ノート追加先のリソースのグローバルID。 |

#### フィールド {#fields-120}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatediscussionclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcreatediscussionerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationcreatediscussionnote"></a>`note` | [`Note`](#note) | ミューテーション後のノート。 |
| <a id="mutationcreatediscussionquickactionsstatus"></a>`quickActionsStatus` | [`QuickActionsStatus`](#quickactionsstatus) | ミューテーション後のクイックアクションのステータス。 |

### `Mutation.createEpic` {#mutationcreateepic}

{{< details >}}GitLab 17.5で**非推奨**になりました。`WorkItem`型に置き換えられました。詳細については、[移行ガイド](https://docs.gitlab.com/api/graphql/epic_work_items_api_migration_guide/)を参照してください。{{< /details >}}

入力型: `CreateEpicInput`

#### 引数 {#arguments-216}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreateepicaddlabelids"></a>`addLabelIds` | [`[ID!]`](#id) | エピックに追加するラベルのID。 |
| <a id="mutationcreateepicaddlabels"></a>`addLabels` | [`[String!]`](#string) | エピックに追加するラベルの配列。 |
| <a id="mutationcreateepicclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcreateepiccolor"></a>`color` | [`Color`](#color) | エピックの色。 |
| <a id="mutationcreateepicconfidential"></a>`confidential` | [`Boolean`](#boolean) | エピックが機密かどうかを示します。 |
| <a id="mutationcreateepicdescription"></a>`description` | [`String`](#string) | エピックの説明。 |
| <a id="mutationcreateepicduedatefixed"></a>`dueDateFixed` | [`String`](#string) | エピックの終了日。 |
| <a id="mutationcreateepicduedateisfixed"></a>`dueDateIsFixed` | [`Boolean`](#boolean) | 終了日をイシューのマイルストーンではなく、due_date_fixedフィールドから取得することを示します。 |
| <a id="mutationcreateepicgrouppath"></a>`groupPath` | [`ID!`](#id) | ミューテーション対象のエピックの属するグループ。 |
| <a id="mutationcreateepicremovelabelids"></a>`removeLabelIds` | [`[ID!]`](#id) | エピックから削除するラベルのID。 |
| <a id="mutationcreateepicstartdatefixed"></a>`startDateFixed` | [`String`](#string) | エピックの開始日。 |
| <a id="mutationcreateepicstartdateisfixed"></a>`startDateIsFixed` | [`Boolean`](#boolean) | 開始日をイシューのマイルストーンではなく、start_date_fixedフィールドから取得することを示します。 |
| <a id="mutationcreateepictitle"></a>`title` | [`String`](#string) | エピックのタイトル。 |

#### フィールド {#fields-121}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreateepicclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcreateepicepic"></a>`epic` | [`Epic`](#epic) | 作成されたエピック。 |
| <a id="mutationcreateepicerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.createImageDiffNote` {#mutationcreateimagediffnote}

入力型: `CreateImageDiffNoteInput`

#### 引数 {#arguments-217}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreateimagediffnotebody"></a>`body` | [`String!`](#string) | ノートの内容。 |
| <a id="mutationcreateimagediffnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcreateimagediffnoteinternal"></a>`internal` | [`Boolean`](#boolean) | ノートの内部フラグ。デフォルトはfalseです。 |
| <a id="mutationcreateimagediffnotenoteableid"></a>`noteableId` | [`NoteableID!`](#noteableid) | ノート追加先のリソースのグローバルID。 |
| <a id="mutationcreateimagediffnoteposition"></a>`position` | [`DiffImagePositionInput!`](#diffimagepositioninput) | 差分に関するノートの位置。 |

#### フィールド {#fields-122}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreateimagediffnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcreateimagediffnoteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationcreateimagediffnotenote"></a>`note` | [`Note`](#note) | ミューテーション後のノート。 |
| <a id="mutationcreateimagediffnotequickactionsstatus"></a>`quickActionsStatus` | [`QuickActionsStatus`](#quickactionsstatus) | ミューテーション後のクイックアクションのステータス。 |

### `Mutation.createIssue` {#mutationcreateissue}

入力型: `CreateIssueInput`

#### 引数 {#arguments-218}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreateissueassigneeids"></a>`assigneeIds` | [`[UserID!]`](#userid) | イシューに割り当てるユーザーIDの配列。 |
| <a id="mutationcreateissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcreateissueconfidential"></a>`confidential` | [`Boolean`](#boolean) | イシューが機密であることを示します。 |
| <a id="mutationcreateissuecreatedat"></a>`createdAt` | [`Time`](#time) | イシュー作成時のタイムスタンプ。管理者とプロジェクトオーナーのみが使用できます。 |
| <a id="mutationcreateissuedescription"></a>`description` | [`String`](#string) | イシューの説明。 |
| <a id="mutationcreateissuediscussiontoresolve"></a>`discussionToResolve` | [`String`](#string) | 解決するディスカッションのID。`merge_request_to_resolve_discussions_of`も渡してください。 |
| <a id="mutationcreateissueduedate"></a>`dueDate` | [`ISO8601Date`](#iso8601date) | イシューの期限。 |
| <a id="mutationcreateissueepicid"></a>`epicId` {{< icon name="warning-solid" >}} | [`EpicID`](#epicid) | **非推奨**: これはWorkItem hierarchyWidgetに置き換えられる予定です。GitLab 17.5で非推奨になりました。 |
| <a id="mutationcreateissuehealthstatus"></a>`healthStatus` | [`HealthStatus`](#healthstatus) | 目的のヘルスステータス。 |
| <a id="mutationcreateissueiid"></a>`iid` | [`Int`](#int) | プロジェクトイシューのIID（内部ID）。これを変更できるのは管理者とプロジェクトオーナーだけです。 |
| <a id="mutationcreateissueiterationcadenceid"></a>`iterationCadenceId` | [`IterationsCadenceID`](#iterationscadenceid) | グローバルイテレーションの反復ID。`iterationWildcardId`が指定されている場合は必須。 |
| <a id="mutationcreateissueiterationid"></a>`iterationId` | [`IterationID`](#iterationid) | グローバルイテレーションID。`iterationWildcardId`と相互排他的な引数。 |
| <a id="mutationcreateissueiterationwildcardid"></a>`iterationWildcardId` | [`IssueCreationIterationWildcardId`](#issuecreationiterationwildcardid) | イテレーションワイルドカードID。サポートされている値は`CURRENT`です。`iterationId`と相互排他的な引数。この引数を指定する場合はiterationCadenceIdも必須です。 |
| <a id="mutationcreateissuelabelids"></a>`labelIds` | [`[LabelID!]`](#labelid) | イシューに追加するラベルのID。 |
| <a id="mutationcreateissuelabels"></a>`labels` | [`[String!]`](#string) | イシューのラベル。 |
| <a id="mutationcreateissuelocked"></a>`locked` | [`Boolean`](#boolean) | イシューでディスカッションがロックされていることを示します。 |
| <a id="mutationcreateissuemergerequesttoresolvediscussionsof"></a>`mergeRequestToResolveDiscussionsOf` | [`MergeRequestID`](#mergerequestid) | ディスカッションを解決する対象となるマージリクエストのIID。 |
| <a id="mutationcreateissuemilestoneid"></a>`milestoneId` | [`MilestoneID`](#milestoneid) | イシューに割り当てるマイルストーンのID。nullに設定すると、更新時にマイルストーンが削除されます。 |
| <a id="mutationcreateissuemoveafterid"></a>`moveAfterId` | [`IssueID`](#issueid) | 現在のイシューの後に配置するイシューのグローバルID。 |
| <a id="mutationcreateissuemovebeforeid"></a>`moveBeforeId` | [`IssueID`](#issueid) | 現在のイシューの前に配置するイシューのグローバルID。 |
| <a id="mutationcreateissueprojectpath"></a>`projectPath` | [`ID!`](#id) | イシューが関連付けられているプロジェクトのフルパス。 |
| <a id="mutationcreateissuestatusid"></a>`statusId` | [`WorkItemsStatusesStatusID`](#workitemsstatusesstatusid) | ステータスのグローバルID。 |
| <a id="mutationcreateissuetitle"></a>`title` | [`String!`](#string) | イシューのタイトル。 |
| <a id="mutationcreateissuetype"></a>`type` | [`IssueType`](#issuetype) | イシューのタイプ。 |
| <a id="mutationcreateissueweight"></a>`weight` | [`Int`](#int) | イシューのウェイト。 |

#### フィールド {#fields-123}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreateissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcreateissueerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationcreateissueissue"></a>`issue` | [`Issue`](#issue) | ミューテーション後のイシュー。 |

### `Mutation.createIteration` {#mutationcreateiteration}

{{< details >}}GitLab 14.0で**非推奨**になりました。iterationCreateを使用してください。{{< /details >}}

入力型: `CreateIterationInput`

#### 引数 {#arguments-219}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreateiterationclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcreateiterationdescription"></a>`description` | [`String`](#string) | イテレーションの説明。 |
| <a id="mutationcreateiterationduedate"></a>`dueDate` | [`String`](#string) | イテレーションの終了日。 |
| <a id="mutationcreateiterationgrouppath"></a>`groupPath` | [`ID`](#id) | リソースが関連付けられているグループのフルパス。 |
| <a id="mutationcreateiterationiterationscadenceid"></a>`iterationsCadenceId` | [`IterationsCadenceID`](#iterationscadenceid) | 新しいイテレーションに割り当てるイテレーションの反復のグローバルID。 |
| <a id="mutationcreateiterationprojectpath"></a>`projectPath` | [`ID`](#id) | リソースが関連付けられているプロジェクトのフルパス。 |
| <a id="mutationcreateiterationstartdate"></a>`startDate` | [`String`](#string) | イテレーションの開始日。 |
| <a id="mutationcreateiterationtitle"></a>`title` | [`String`](#string) | イテレーションのタイトル。 |

#### フィールド {#fields-124}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreateiterationclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcreateiterationerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationcreateiterationiteration"></a>`iteration` | [`Iteration`](#iteration) | 作成されたイテレーション。 |

### `Mutation.createNote` {#mutationcreatenote}

ノートを作成します。ノートの本文に含まれるのがクイックアクションだけの場合、更新時にノートが削除され、ノートは返されません。

入力型: `CreateNoteInput`

#### 引数 {#arguments-220}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatenotebody"></a>`body` | [`String!`](#string) | ノートの内容。 |
| <a id="mutationcreatenoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcreatenotediscussionid"></a>`discussionId` | [`DiscussionID`](#discussionid) | ノートを含める返信の対象となるディスカッションのグローバルID。 |
| <a id="mutationcreatenoteinternal"></a>`internal` | [`Boolean`](#boolean) | ノートの内部フラグ。デフォルトはfalseです。 |
| <a id="mutationcreatenotemergerequestdiffheadsha"></a>`mergeRequestDiffHeadSha` | [`String`](#string) | リクエスト送信以降にマージリクエストが更新されていないことを確認するために使用されるヘッドコミットのSHA。 |
| <a id="mutationcreatenotenoteableid"></a>`noteableId` | [`NoteableID!`](#noteableid) | ノート追加先のリソースのグローバルID。 |

#### フィールド {#fields-125}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatenoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcreatenoteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationcreatenotenote"></a>`note` | [`Note`](#note) | ミューテーション後のノート。 |
| <a id="mutationcreatenotequickactionsstatus"></a>`quickActionsStatus` | [`QuickActionsStatus`](#quickactionsstatus) | ミューテーション後のクイックアクションのステータス。 |

### `Mutation.createPackagesProtectionRule` {#mutationcreatepackagesprotectionrule}

プロジェクトパッケージへのアクセスを制限する保護ルールを作成します。

入力型: `CreatePackagesProtectionRuleInput`

#### 引数 {#arguments-221}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatepackagesprotectionruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcreatepackagesprotectionruleminimumaccesslevelfordelete"></a>`minimumAccessLevelForDelete` {{< icon name="warning-solid" >}} | [`PackagesProtectionRuleAccessLevelForDelete`](#packagesprotectionruleaccesslevelfordelete) | **非推奨**: **状態**: 実験的機能。GitLab 17.10で導入されました。 |
| <a id="mutationcreatepackagesprotectionruleminimumaccesslevelforpush"></a>`minimumAccessLevelForPush` | [`PackagesProtectionRuleAccessLevel`](#packagesprotectionruleaccesslevel) | パッケージをパッケージレジストリにプッシュするために必要な最小GitLabアクセスレベル。有効な値には`MAINTAINER`、`OWNER`、または`ADMIN`が含まれます。値が`nil`の場合のデフォルトの最小アクセスレベルは`DEVELOPER`です。 |
| <a id="mutationcreatepackagesprotectionrulepackagenamepattern"></a>`packageNamePattern` | [`String!`](#string) | 保護ルールによって保護されるパッケージ名。例: `@my-scope/my-package-*`。ワイルドカード文字`*`を使用できます。 |
| <a id="mutationcreatepackagesprotectionrulepackagetype"></a>`packageType` | [`PackagesProtectionRulePackageType!`](#packagesprotectionrulepackagetype) | 保護ルールによって保護されるパッケージのタイプ。例: `NPM`、`PYPI`。 |
| <a id="mutationcreatepackagesprotectionruleprojectpath"></a>`projectPath` | [`ID!`](#id) | 保護ルールの属するプロジェクトのフルパス。 |

#### フィールド {#fields-126}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatepackagesprotectionruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcreatepackagesprotectionruleerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationcreatepackagesprotectionrulepackageprotectionrule"></a>`packageProtectionRule` | [`PackagesProtectionRule`](#packagesprotectionrule) | ミューテーション後のパッケージ保護ルール。 |

### `Mutation.createRequirement` {#mutationcreaterequirement}

入力型: `CreateRequirementInput`

#### 引数 {#arguments-222}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreaterequirementclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcreaterequirementdescription"></a>`description` | [`String`](#string) | 要件の説明。 |
| <a id="mutationcreaterequirementprojectpath"></a>`projectPath` | [`ID!`](#id) | 要件が関連付けられているプロジェクトのフルパス。 |
| <a id="mutationcreaterequirementtitle"></a>`title` | [`String`](#string) | 要件のタイトル。 |

#### フィールド {#fields-127}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreaterequirementclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcreaterequirementerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationcreaterequirementrequirement"></a>`requirement` | [`Requirement`](#requirement) | ミューテーション後の要求事項。 |

### `Mutation.createSnippet` {#mutationcreatesnippet}

入力型: `CreateSnippetInput`

#### 引数 {#arguments-223}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatesnippetblobactions"></a>`blobActions` | [`[SnippetBlobActionInputType!]`](#snippetblobactioninputtype) | スニペットリポジトリとblobに対して実行するアクション。 |
| <a id="mutationcreatesnippetclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcreatesnippetdescription"></a>`description` | [`String`](#string) | スニペットの説明。 |
| <a id="mutationcreatesnippetprojectpath"></a>`projectPath` | [`ID`](#id) | スニペットが関連付けられているプロジェクトのフルパス。 |
| <a id="mutationcreatesnippettitle"></a>`title` | [`String!`](#string) | スニペットのタイトル。 |
| <a id="mutationcreatesnippetuploadedfiles"></a>`uploadedFiles` | [`[String!]`](#string) | スニペットの説明でアップロードされるファイルのパス。 |
| <a id="mutationcreatesnippetvisibilitylevel"></a>`visibilityLevel` | [`VisibilityLevelsEnum!`](#visibilitylevelsenum) | スニペットの表示レベル。 |

#### フィールド {#fields-128}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatesnippetclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcreatesnippeterrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationcreatesnippetsnippet"></a>`snippet` | [`Snippet`](#snippet) | ミューテーション後のスニペット。 |

### `Mutation.createTestCase` {#mutationcreatetestcase}

入力型: `CreateTestCaseInput`

#### 引数 {#arguments-224}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatetestcaseclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcreatetestcaseconfidential"></a>`confidential` | [`Boolean`](#boolean) | テストケースの機密性を設定します。 |
| <a id="mutationcreatetestcasedescription"></a>`description` | [`String`](#string) | テストケースの説明。 |
| <a id="mutationcreatetestcaselabelids"></a>`labelIds` | [`[ID!]`](#id) | テストケースに追加するラベルのID。 |
| <a id="mutationcreatetestcaseprojectpath"></a>`projectPath` | [`ID!`](#id) | テストケースを作成するプロジェクトへのフルパス。 |
| <a id="mutationcreatetestcasetitle"></a>`title` | [`String!`](#string) | テストケースのタイトル。 |

#### フィールド {#fields-129}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcreatetestcaseclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcreatetestcaseerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationcreatetestcasetestcase"></a>`testCase` | [`Issue`](#issue) | 作成されたテストケース。 |

### `Mutation.customFieldArchive` {#mutationcustomfieldarchive}

{{< details >}}GitLab 17.9で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `CustomFieldArchiveInput`

#### 引数 {#arguments-225}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcustomfieldarchiveclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcustomfieldarchiveid"></a>`id` | [`IssuablesCustomFieldID!`](#issuablescustomfieldid) | カスタムフィールドのグローバルID。 |

#### フィールド {#fields-130}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcustomfieldarchiveclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcustomfieldarchivecustomfield"></a>`customField` | [`CustomField`](#customfield) | アーカイブされたカスタムフィールド。 |
| <a id="mutationcustomfieldarchiveerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.customFieldCreate` {#mutationcustomfieldcreate}

{{< details >}}GitLab 17.6で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `CustomFieldCreateInput`

#### 引数 {#arguments-226}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcustomfieldcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcustomfieldcreatefieldtype"></a>`fieldType` | [`CustomFieldType!`](#customfieldtype) | カスタムフィールドの型。 |
| <a id="mutationcustomfieldcreategrouppath"></a>`groupPath` | [`ID!`](#id) | カスタムフィールドを作成するグループパス。 |
| <a id="mutationcustomfieldcreatename"></a>`name` | [`String!`](#string) | カスタムフィールドの名前。 |
| <a id="mutationcustomfieldcreateselectoptions"></a>`selectOptions` | [`[CustomFieldSelectOptionInput!]`](#customfieldselectoptioninput) | 選択フィールドで使用可能なオプション。 |
| <a id="mutationcustomfieldcreateworkitemtypeids"></a>`workItemTypeIds` | [`[WorkItemsTypeID!]`](#workitemstypeid) | カスタムフィールドに関連付けられている作業アイテムの型のグローバルID。 |

#### フィールド {#fields-131}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcustomfieldcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcustomfieldcreatecustomfield"></a>`customField` | [`CustomField`](#customfield) | 作成されたカスタムフィールド。 |
| <a id="mutationcustomfieldcreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.customFieldUnarchive` {#mutationcustomfieldunarchive}

{{< details >}}GitLab 17.9で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `CustomFieldUnarchiveInput`

#### 引数 {#arguments-227}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcustomfieldunarchiveclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcustomfieldunarchiveid"></a>`id` | [`IssuablesCustomFieldID!`](#issuablescustomfieldid) | カスタムフィールドのグローバルID。 |

#### フィールド {#fields-132}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcustomfieldunarchiveclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcustomfieldunarchivecustomfield"></a>`customField` | [`CustomField`](#customfield) | アーカイブ解除されたカスタムフィールド。 |
| <a id="mutationcustomfieldunarchiveerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.customFieldUpdate` {#mutationcustomfieldupdate}

{{< details >}}GitLab 17.6で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `CustomFieldUpdateInput`

#### 引数 {#arguments-228}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcustomfieldupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcustomfieldupdateid"></a>`id` | [`IssuablesCustomFieldID!`](#issuablescustomfieldid) | カスタムフィールドのグローバルID。 |
| <a id="mutationcustomfieldupdatename"></a>`name` | [`String`](#string) | カスタムフィールドの名前。 |
| <a id="mutationcustomfieldupdateselectoptions"></a>`selectOptions` | [`[CustomFieldSelectOptionInput!]`](#customfieldselectoptioninput) | 選択フィールドで使用可能なオプション。 |
| <a id="mutationcustomfieldupdateworkitemtypeids"></a>`workItemTypeIds` | [`[WorkItemsTypeID!]`](#workitemstypeid) | カスタムフィールドに関連付けられている作業アイテムの型のグローバルID。 |

#### フィールド {#fields-133}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcustomfieldupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcustomfieldupdatecustomfield"></a>`customField` | [`CustomField`](#customfield) | 更新されたカスタムフィールド。 |
| <a id="mutationcustomfieldupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.customerRelationsContactCreate` {#mutationcustomerrelationscontactcreate}

入力型: `CustomerRelationsContactCreateInput`

#### 引数 {#arguments-229}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcustomerrelationscontactcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcustomerrelationscontactcreatedescription"></a>`description` | [`String`](#string) | 連絡先の説明またはノート。 |
| <a id="mutationcustomerrelationscontactcreateemail"></a>`email` | [`String`](#string) | 連絡先のメールアドレス。 |
| <a id="mutationcustomerrelationscontactcreatefirstname"></a>`firstName` | [`String!`](#string) | 連絡先の名前。 |
| <a id="mutationcustomerrelationscontactcreategroupid"></a>`groupId` | [`GroupID!`](#groupid) | 連絡先のグループ。 |
| <a id="mutationcustomerrelationscontactcreatelastname"></a>`lastName` | [`String!`](#string) | 連絡先の苗字。 |
| <a id="mutationcustomerrelationscontactcreateorganizationid"></a>`organizationId` | [`CustomerRelationsOrganizationID`](#customerrelationsorganizationid) | 連絡先の組織。 |
| <a id="mutationcustomerrelationscontactcreatephone"></a>`phone` | [`String`](#string) | 連絡先の電話番号。 |

#### フィールド {#fields-134}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcustomerrelationscontactcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcustomerrelationscontactcreatecontact"></a>`contact` | [`CustomerRelationsContact`](#customerrelationscontact) | ミューテーション後の連絡先。 |
| <a id="mutationcustomerrelationscontactcreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.customerRelationsContactUpdate` {#mutationcustomerrelationscontactupdate}

入力型: `CustomerRelationsContactUpdateInput`

#### 引数 {#arguments-230}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcustomerrelationscontactupdateactive"></a>`active` | [`Boolean`](#boolean) | 連絡先の状態。 |
| <a id="mutationcustomerrelationscontactupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcustomerrelationscontactupdatedescription"></a>`description` | [`String`](#string) | 連絡先の説明またはノート。 |
| <a id="mutationcustomerrelationscontactupdateemail"></a>`email` | [`String`](#string) | 連絡先のメールアドレス。 |
| <a id="mutationcustomerrelationscontactupdatefirstname"></a>`firstName` | [`String`](#string) | 連絡先の名前。 |
| <a id="mutationcustomerrelationscontactupdateid"></a>`id` | [`CustomerRelationsContactID!`](#customerrelationscontactid) | 連絡先のグローバルID。 |
| <a id="mutationcustomerrelationscontactupdatelastname"></a>`lastName` | [`String`](#string) | 連絡先の苗字。 |
| <a id="mutationcustomerrelationscontactupdateorganizationid"></a>`organizationId` | [`CustomerRelationsOrganizationID`](#customerrelationsorganizationid) | 連絡先の組織。 |
| <a id="mutationcustomerrelationscontactupdatephone"></a>`phone` | [`String`](#string) | 連絡先の電話番号。 |

#### フィールド {#fields-135}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcustomerrelationscontactupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcustomerrelationscontactupdatecontact"></a>`contact` | [`CustomerRelationsContact`](#customerrelationscontact) | ミューテーション後の連絡先。 |
| <a id="mutationcustomerrelationscontactupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.customerRelationsOrganizationCreate` {#mutationcustomerrelationsorganizationcreate}

入力型: `CustomerRelationsOrganizationCreateInput`

#### 引数 {#arguments-231}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcustomerrelationsorganizationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcustomerrelationsorganizationcreatedefaultrate"></a>`defaultRate` | [`Float`](#float) | 組織の標準請求レート。 |
| <a id="mutationcustomerrelationsorganizationcreatedescription"></a>`description` | [`String`](#string) | 組織の説明またはノート。 |
| <a id="mutationcustomerrelationsorganizationcreategroupid"></a>`groupId` | [`GroupID!`](#groupid) | 組織のグループ。 |
| <a id="mutationcustomerrelationsorganizationcreatename"></a>`name` | [`String!`](#string) | 組織の名前。 |

#### フィールド {#fields-136}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcustomerrelationsorganizationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcustomerrelationsorganizationcreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationcustomerrelationsorganizationcreateorganization"></a>`organization` | [`CustomerRelationsOrganization`](#customerrelationsorganization) | ミューテーション後の組織。 |

### `Mutation.customerRelationsOrganizationUpdate` {#mutationcustomerrelationsorganizationupdate}

入力型: `CustomerRelationsOrganizationUpdateInput`

#### 引数 {#arguments-232}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcustomerrelationsorganizationupdateactive"></a>`active` | [`Boolean`](#boolean) | 組織の状態。 |
| <a id="mutationcustomerrelationsorganizationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcustomerrelationsorganizationupdatedefaultrate"></a>`defaultRate` | [`Float`](#float) | 組織の標準請求レート。 |
| <a id="mutationcustomerrelationsorganizationupdatedescription"></a>`description` | [`String`](#string) | 組織の説明またはノート。 |
| <a id="mutationcustomerrelationsorganizationupdateid"></a>`id` | [`CustomerRelationsOrganizationID!`](#customerrelationsorganizationid) | 組織のグローバルID。 |
| <a id="mutationcustomerrelationsorganizationupdatename"></a>`name` | [`String`](#string) | 組織の名前。 |

#### フィールド {#fields-137}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationcustomerrelationsorganizationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationcustomerrelationsorganizationupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationcustomerrelationsorganizationupdateorganization"></a>`organization` | [`CustomerRelationsOrganization!`](#customerrelationsorganization) | ミューテーション後の組織。 |

### `Mutation.dastOnDemandScanCreate` {#mutationdastondemandscancreate}

入力型: `DastOnDemandScanCreateInput`

#### 引数 {#arguments-233}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastondemandscancreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdastondemandscancreatedastscannerprofileid"></a>`dastScannerProfileId` | [`DastScannerProfileID`](#dastscannerprofileid) | スキャンに使用するスキャナープロファイルのID。 |
| <a id="mutationdastondemandscancreatedastsiteprofileid"></a>`dastSiteProfileId` | [`DastSiteProfileID!`](#dastsiteprofileid) | スキャンに使用するサイトプロファイルのID。 |
| <a id="mutationdastondemandscancreatefullpath"></a>`fullPath` | [`ID!`](#id) | サイトプロファイルが属するプロジェクト。 |

#### フィールド {#fields-138}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastondemandscancreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdastondemandscancreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationdastondemandscancreatepipelineurl"></a>`pipelineUrl` | [`String`](#string) | 作成されたパイプラインのURL。 |

### `Mutation.dastProfileCreate` {#mutationdastprofilecreate}

入力型: `DastProfileCreateInput`

#### 引数 {#arguments-234}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastprofilecreatebranchname"></a>`branchName` | [`String`](#string) | 関連するブランチ。 |
| <a id="mutationdastprofilecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdastprofilecreatedastprofileschedule"></a>`dastProfileSchedule` | [`DastProfileScheduleInput`](#dastprofilescheduleinput) | DASTプロファイルスケジュールを表します。 |
| <a id="mutationdastprofilecreatedastscannerprofileid"></a>`dastScannerProfileId` | [`DastScannerProfileID!`](#dastscannerprofileid) | 関連付けるスキャナープロファイルのID。 |
| <a id="mutationdastprofilecreatedastsiteprofileid"></a>`dastSiteProfileId` | [`DastSiteProfileID!`](#dastsiteprofileid) | 関連付けるサイトプロファイルのID。 |
| <a id="mutationdastprofilecreatedescription"></a>`description` | [`String`](#string) | プロファイルの説明。デフォルトは空の文字列です。 |
| <a id="mutationdastprofilecreatefullpath"></a>`fullPath` | [`ID!`](#id) | プロファイルが属するプロジェクト。 |
| <a id="mutationdastprofilecreatename"></a>`name` | [`String!`](#string) | プロファイルの名前。 |
| <a id="mutationdastprofilecreaterunaftercreate"></a>`runAfterCreate` | [`Boolean`](#boolean) | 作成後にプロファイルを使用してスキャンを実行します。デフォルトはfalseです。 |
| <a id="mutationdastprofilecreatetaglist"></a>`tagList` | [`[String!]`](#string) | プロファイルに関連付けられているRunnerタグを示します。 |

#### フィールド {#fields-139}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastprofilecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdastprofilecreatedastprofile"></a>`dastProfile` | [`DastProfile`](#dastprofile) | 作成されたプロファイル。 |
| <a id="mutationdastprofilecreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationdastprofilecreatepipelineurl"></a>`pipelineUrl` | [`String`](#string) | 作成されたパイプラインのURL。`runAfterCreate`が`true`に設定されている必要があります。 |

### `Mutation.dastProfileDelete` {#mutationdastprofiledelete}

入力型: `DastProfileDeleteInput`

#### 引数 {#arguments-235}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastprofiledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdastprofiledeleteid"></a>`id` | [`DastProfileID!`](#dastprofileid) | 削除するプロファイルのID。 |

#### フィールド {#fields-140}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastprofiledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdastprofiledeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.dastProfileRun` {#mutationdastprofilerun}

入力型: `DastProfileRunInput`

#### 引数 {#arguments-236}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastprofilerunclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdastprofilerunfullpath"></a>`fullPath` {{< icon name="warning-solid" >}} | [`ID`](#id) | **非推奨**: グローバルIDを修飾するために完全パスは必要ありません。GitLab 14.5で非推奨になりました。 |
| <a id="mutationdastprofilerunid"></a>`id` | [`DastProfileID!`](#dastprofileid) | スキャンに使用するプロファイルのID |

#### フィールド {#fields-141}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastprofilerunclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdastprofilerunerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationdastprofilerunpipelineurl"></a>`pipelineUrl` | [`String`](#string) | 作成されたパイプラインのURL。 |

### `Mutation.dastProfileUpdate` {#mutationdastprofileupdate}

入力型: `DastProfileUpdateInput`

#### 引数 {#arguments-237}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastprofileupdatebranchname"></a>`branchName` | [`String`](#string) | 関連するブランチ。 |
| <a id="mutationdastprofileupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdastprofileupdatedastprofileschedule"></a>`dastProfileSchedule` | [`DastProfileScheduleInput`](#dastprofilescheduleinput) | DASTプロファイルスケジュールを表します。 |
| <a id="mutationdastprofileupdatedastscannerprofileid"></a>`dastScannerProfileId` | [`DastScannerProfileID`](#dastscannerprofileid) | 関連付けるスキャナープロファイルのID。 |
| <a id="mutationdastprofileupdatedastsiteprofileid"></a>`dastSiteProfileId` | [`DastSiteProfileID`](#dastsiteprofileid) | 関連付けるサイトプロファイルのID。 |
| <a id="mutationdastprofileupdatedescription"></a>`description` | [`String`](#string) | プロファイルの説明。デフォルトは空の文字列です。 |
| <a id="mutationdastprofileupdatefullpath"></a>`fullPath` {{< icon name="warning-solid" >}} | [`ID`](#id) | **非推奨**: グローバルIDを修飾するために完全パスは必要ありません。GitLab 14.5で非推奨になりました。 |
| <a id="mutationdastprofileupdateid"></a>`id` | [`DastProfileID!`](#dastprofileid) | 削除するプロファイルのID。 |
| <a id="mutationdastprofileupdatename"></a>`name` | [`String`](#string) | プロファイルの名前。 |
| <a id="mutationdastprofileupdaterunafterupdate"></a>`runAfterUpdate` | [`Boolean`](#boolean) | 更新後にプロファイルを使用してスキャンを実行します。デフォルトはfalseです。 |
| <a id="mutationdastprofileupdatetaglist"></a>`tagList` | [`[String!]`](#string) | プロファイルに関連付けられているRunnerタグを示します。 |

#### フィールド {#fields-142}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastprofileupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdastprofileupdatedastprofile"></a>`dastProfile` | [`DastProfile`](#dastprofile) | 更新されたプロファイル。 |
| <a id="mutationdastprofileupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationdastprofileupdatepipelineurl"></a>`pipelineUrl` | [`String`](#string) | 作成されたパイプラインのURL。ミューテーション呼び出し時に入力引数`runAfterUpdate`を`true`に設定する必要があります。そうしないと、パイプラインは作成されません。 |

### `Mutation.dastScannerProfileCreate` {#mutationdastscannerprofilecreate}

入力型: `DastScannerProfileCreateInput`

#### 引数 {#arguments-238}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastscannerprofilecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdastscannerprofilecreatefullpath"></a>`fullPath` | [`ID!`](#id) | スキャナープロファイルが属するプロジェクト。 |
| <a id="mutationdastscannerprofilecreateprofilename"></a>`profileName` | [`String!`](#string) | スキャナープロファイルの名前。 |
| <a id="mutationdastscannerprofilecreatescantype"></a>`scanType` | [`DastScanTypeEnum`](#dastscantypeenum) | 実行するDASTスキャンのタイプを示します。パッシブスキャンかアクティブスキャンのどちらかになります。 |
| <a id="mutationdastscannerprofilecreateshowdebugmessages"></a>`showDebugMessages` | [`Boolean`](#boolean) | デバッグメッセージをDASTコンソール出力に含めるかどうかを示します。デバッグメッセージを含める場合はtrueになります。 |
| <a id="mutationdastscannerprofilecreatespidertimeout"></a>`spiderTimeout` | [`Int`](#int) | スパイダーがサイトを走査する時間として許可される最大時間（分）。 |
| <a id="mutationdastscannerprofilecreatetaglist"></a>`tagList` {{< icon name="warning-solid" >}} | [`[String!]`](#string) | **非推奨**: DastProfileに移動しました。GitLab 15.8で非推奨になりました。 |
| <a id="mutationdastscannerprofilecreatetargettimeout"></a>`targetTimeout` | [`Int`](#int) | テスト対象のサイトがリクエストに応答するための時間として許可される最大秒数。 |
| <a id="mutationdastscannerprofilecreateuseajaxspider"></a>`useAjaxSpider` | [`Boolean`](#boolean) | ターゲットサイトのクロールにAJAX Spiderを使用するかどうかを示します。従来のスパイダーに加えてAJAX Spiderを実行する場合はtrue、従来のスパイダーだけを実行する場合はfalseになります。 |

#### フィールド {#fields-143}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastscannerprofilecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdastscannerprofilecreatedastscannerprofile"></a>`dastScannerProfile` | [`DastScannerProfile`](#dastscannerprofile) | 作成されたスキャナープロファイル。 |
| <a id="mutationdastscannerprofilecreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationdastscannerprofilecreateid"></a>`id` {{< icon name="warning-solid" >}} | [`DastScannerProfileID`](#dastscannerprofileid) | **非推奨**: `dastScannerProfile`フィールドを使用してください。GitLab 14.10で非推奨になりました。 |

### `Mutation.dastScannerProfileDelete` {#mutationdastscannerprofiledelete}

入力型: `DastScannerProfileDeleteInput`

#### 引数 {#arguments-239}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastscannerprofiledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdastscannerprofiledeletefullpath"></a>`fullPath` {{< icon name="warning-solid" >}} | [`ID`](#id) | **非推奨**: グローバルIDを修飾するために完全パスは必要ありません。GitLab 14.5で非推奨になりました。 |
| <a id="mutationdastscannerprofiledeleteid"></a>`id` | [`DastScannerProfileID!`](#dastscannerprofileid) | 削除するスキャナープロファイルのID。 |

#### フィールド {#fields-144}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastscannerprofiledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdastscannerprofiledeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.dastScannerProfileUpdate` {#mutationdastscannerprofileupdate}

入力型: `DastScannerProfileUpdateInput`

#### 引数 {#arguments-240}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastscannerprofileupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdastscannerprofileupdatefullpath"></a>`fullPath` {{< icon name="warning-solid" >}} | [`ID`](#id) | **非推奨**: グローバルIDを修飾するために完全パスは必要ありません。GitLab 14.5で非推奨になりました。 |
| <a id="mutationdastscannerprofileupdateid"></a>`id` | [`DastScannerProfileID!`](#dastscannerprofileid) | 更新するスキャナープロファイルのID。 |
| <a id="mutationdastscannerprofileupdateprofilename"></a>`profileName` | [`String!`](#string) | スキャナープロファイルの名前。 |
| <a id="mutationdastscannerprofileupdatescantype"></a>`scanType` | [`DastScanTypeEnum`](#dastscantypeenum) | 実行するDASTスキャンのタイプを示します。パッシブスキャンかアクティブスキャンのどちらかになります。 |
| <a id="mutationdastscannerprofileupdateshowdebugmessages"></a>`showDebugMessages` | [`Boolean`](#boolean) | デバッグメッセージをDASTコンソール出力に含めるかどうかを示します。デバッグメッセージを含める場合はtrueになります。 |
| <a id="mutationdastscannerprofileupdatespidertimeout"></a>`spiderTimeout` | [`Int!`](#int) | スパイダーがサイトを走査する時間として許可される最大時間（分）。 |
| <a id="mutationdastscannerprofileupdatetaglist"></a>`tagList` {{< icon name="warning-solid" >}} | [`[String!]`](#string) | **非推奨**: DastProfileに移動しました。GitLab 15.8で非推奨になりました。 |
| <a id="mutationdastscannerprofileupdatetargettimeout"></a>`targetTimeout` | [`Int!`](#int) | テスト対象のサイトがリクエストに応答するための時間として許可される最大秒数。 |
| <a id="mutationdastscannerprofileupdateuseajaxspider"></a>`useAjaxSpider` | [`Boolean`](#boolean) | ターゲットサイトのクロールにAJAX Spiderを使用するかどうかを示します。従来のスパイダーに加えてAJAX Spiderを実行する場合はtrue、従来のスパイダーだけを実行する場合はfalseになります。 |

#### フィールド {#fields-145}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastscannerprofileupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdastscannerprofileupdatedastscannerprofile"></a>`dastScannerProfile` | [`DastScannerProfile`](#dastscannerprofile) | 更新されたスキャナープロファイル。 |
| <a id="mutationdastscannerprofileupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationdastscannerprofileupdateid"></a>`id` {{< icon name="warning-solid" >}} | [`DastScannerProfileID`](#dastscannerprofileid) | **非推奨**: `dastScannerProfile`フィールドを使用してください。GitLab 14.10で非推奨になりました。 |

### `Mutation.dastSiteProfileCreate` {#mutationdastsiteprofilecreate}

入力型: `DastSiteProfileCreateInput`

#### 引数 {#arguments-241}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastsiteprofilecreateauth"></a>`auth` | [`DastSiteProfileAuthInput`](#dastsiteprofileauthinput) | 認証のパラメータ。 |
| <a id="mutationdastsiteprofilecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdastsiteprofilecreateexcludedurls"></a>`excludedUrls` | [`[String!]`](#string) | 認証スキャン中にスキップするURL。デフォルトは`[]`です。 |
| <a id="mutationdastsiteprofilecreatefullpath"></a>`fullPath` | [`ID!`](#id) | サイトプロファイルが属するプロジェクト。 |
| <a id="mutationdastsiteprofilecreateoptionalvariables"></a>`optionalVariables` | [`[JSON!]`](#json) | DASTスキャン用に設定できるオプション変数。 |
| <a id="mutationdastsiteprofilecreateprofilename"></a>`profileName` | [`String!`](#string) | サイトプロファイルの名前。 |
| <a id="mutationdastsiteprofilecreaterequestheaders"></a>`requestHeaders` | [`String`](#string) | DASTによるあらゆるリクエストに追加する、リクエストヘッダーの名前と値のカンマ区切りリスト。 |
| <a id="mutationdastsiteprofilecreatescanfilepath"></a>`scanFilePath` | [`String`](#string) | スキャン方式のインプットとして使用されるファイルパスまたはURL。 |
| <a id="mutationdastsiteprofilecreatescanmethod"></a>`scanMethod` | [`DastScanMethodType`](#dastscanmethodtype) | スキャナーによるスキャン方式。 |
| <a id="mutationdastsiteprofilecreatetargettype"></a>`targetType` | [`DastTargetTypeEnum`](#dasttargettypeenum) | スキャンするターゲットのタイプ。 |
| <a id="mutationdastsiteprofilecreatetargeturl"></a>`targetUrl` | [`String`](#string) | スキャンするターゲットのURL。 |

#### フィールド {#fields-146}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastsiteprofilecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdastsiteprofilecreatedastsiteprofile"></a>`dastSiteProfile` | [`DastSiteProfile`](#dastsiteprofile) | サイトプロファイルオブジェクト。 |
| <a id="mutationdastsiteprofilecreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationdastsiteprofilecreateid"></a>`id` {{< icon name="warning-solid" >}} | [`DastSiteProfileID`](#dastsiteprofileid) | **非推奨**: `dastSiteProfile.id`フィールドを使用してください。GitLab 14.10で非推奨になりました。 |

### `Mutation.dastSiteProfileDelete` {#mutationdastsiteprofiledelete}

入力型: `DastSiteProfileDeleteInput`

#### 引数 {#arguments-242}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastsiteprofiledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdastsiteprofiledeletefullpath"></a>`fullPath` {{< icon name="warning-solid" >}} | [`ID`](#id) | **非推奨**: グローバルIDを修飾するために完全パスは必要ありません。GitLab 14.5で非推奨になりました。 |
| <a id="mutationdastsiteprofiledeleteid"></a>`id` | [`DastSiteProfileID!`](#dastsiteprofileid) | 削除するサイトプロファイルのID。 |

#### フィールド {#fields-147}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastsiteprofiledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdastsiteprofiledeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.dastSiteProfileUpdate` {#mutationdastsiteprofileupdate}

入力型: `DastSiteProfileUpdateInput`

#### 引数 {#arguments-243}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastsiteprofileupdateauth"></a>`auth` | [`DastSiteProfileAuthInput`](#dastsiteprofileauthinput) | 認証のパラメータ。 |
| <a id="mutationdastsiteprofileupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdastsiteprofileupdateexcludedurls"></a>`excludedUrls` | [`[String!]`](#string) | 認証スキャン中にスキップするURL。 |
| <a id="mutationdastsiteprofileupdatefullpath"></a>`fullPath` {{< icon name="warning-solid" >}} | [`ID`](#id) | **非推奨**: グローバルIDを修飾するために完全パスは必要ありません。GitLab 14.5で非推奨になりました。 |
| <a id="mutationdastsiteprofileupdateid"></a>`id` | [`DastSiteProfileID!`](#dastsiteprofileid) | 更新するサイトプロファイルのID。 |
| <a id="mutationdastsiteprofileupdateoptionalvariables"></a>`optionalVariables` | [`[JSON!]`](#json) | DASTスキャン用に設定できるオプション変数。 |
| <a id="mutationdastsiteprofileupdateprofilename"></a>`profileName` | [`String!`](#string) | サイトプロファイルの名前。 |
| <a id="mutationdastsiteprofileupdaterequestheaders"></a>`requestHeaders` | [`String`](#string) | DASTによるあらゆるリクエストに追加する、リクエストヘッダーの名前と値のカンマ区切りリスト。 |
| <a id="mutationdastsiteprofileupdatescanfilepath"></a>`scanFilePath` | [`String`](#string) | スキャン方式のインプットとして使用されるファイルパスまたはURL。 |
| <a id="mutationdastsiteprofileupdatescanmethod"></a>`scanMethod` | [`DastScanMethodType`](#dastscanmethodtype) | スキャナーによるスキャン方式。 |
| <a id="mutationdastsiteprofileupdatetargettype"></a>`targetType` | [`DastTargetTypeEnum`](#dasttargettypeenum) | スキャンするターゲットのタイプ。 |
| <a id="mutationdastsiteprofileupdatetargeturl"></a>`targetUrl` | [`String`](#string) | スキャンするターゲットのURL。 |

#### フィールド {#fields-148}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastsiteprofileupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdastsiteprofileupdatedastsiteprofile"></a>`dastSiteProfile` | [`DastSiteProfile`](#dastsiteprofile) | サイトプロファイルオブジェクト。 |
| <a id="mutationdastsiteprofileupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationdastsiteprofileupdateid"></a>`id` {{< icon name="warning-solid" >}} | [`DastSiteProfileID`](#dastsiteprofileid) | **非推奨**: `dastSiteProfile.id`フィールドを使用してください。GitLab 14.10で非推奨になりました。 |

### `Mutation.dastSiteTokenCreate` {#mutationdastsitetokencreate}

入力型: `DastSiteTokenCreateInput`

#### 引数 {#arguments-244}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastsitetokencreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdastsitetokencreatefullpath"></a>`fullPath` | [`ID!`](#id) | サイトトークンが属するプロジェクト。 |
| <a id="mutationdastsitetokencreatetargeturl"></a>`targetUrl` | [`String`](#string) | 検証するターゲットのURL。 |

#### フィールド {#fields-149}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastsitetokencreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdastsitetokencreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationdastsitetokencreateid"></a>`id` | [`DastSiteTokenID`](#dastsitetokenid) | サイトトークンのID。 |
| <a id="mutationdastsitetokencreatestatus"></a>`status` | [`DastSiteProfileValidationStatusEnum`](#dastsiteprofilevalidationstatusenum) | ターゲットの現在の検証ステータス。 |
| <a id="mutationdastsitetokencreatetoken"></a>`token` | [`String`](#string) | トークン文字列。 |

### `Mutation.dastSiteValidationCreate` {#mutationdastsitevalidationcreate}

入力型: `DastSiteValidationCreateInput`

#### 引数 {#arguments-245}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastsitevalidationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdastsitevalidationcreatedastsitetokenid"></a>`dastSiteTokenId` | [`DastSiteTokenID!`](#dastsitetokenid) | サイトトークンのID。 |
| <a id="mutationdastsitevalidationcreatefullpath"></a>`fullPath` | [`ID!`](#id) | サイトプロファイルが属するプロジェクト。 |
| <a id="mutationdastsitevalidationcreatestrategy"></a>`strategy` | [`DastSiteValidationStrategyEnum`](#dastsitevalidationstrategyenum) | 使用する検証戦略。 |
| <a id="mutationdastsitevalidationcreatevalidationpath"></a>`validationPath` | [`String!`](#string) | 検証中にリクエストするパス。 |

#### フィールド {#fields-150}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastsitevalidationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdastsitevalidationcreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationdastsitevalidationcreateid"></a>`id` | [`DastSiteValidationID`](#dastsitevalidationid) | サイト検証のID。 |
| <a id="mutationdastsitevalidationcreatestatus"></a>`status` | [`DastSiteProfileValidationStatusEnum`](#dastsiteprofilevalidationstatusenum) | 現在の検証ステータス。 |

### `Mutation.dastSiteValidationRevoke` {#mutationdastsitevalidationrevoke}

入力型: `DastSiteValidationRevokeInput`

#### 引数 {#arguments-246}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastsitevalidationrevokeclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdastsitevalidationrevokefullpath"></a>`fullPath` | [`ID!`](#id) | サイト検証が属するプロジェクト。 |
| <a id="mutationdastsitevalidationrevokenormalizedtargeturl"></a>`normalizedTargetUrl` | [`String!`](#string) | 失効するターゲットの正規化URL。 |

#### フィールド {#fields-151}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdastsitevalidationrevokeclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdastsitevalidationrevokeerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.deleteAnnotation` {#mutationdeleteannotation}

{{< details >}} GitLab 16.0で**非推奨**になりました。基盤となる機能は16.0で削除されました。{{< /details >}}

入力型: `DeleteAnnotationInput`

#### 引数 {#arguments-247}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdeleteannotationclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdeleteannotationid"></a>`id` | [`String!`](#string) | 削除するアノーテーションのグローバルID。 |

#### フィールド {#fields-152}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdeleteannotationclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdeleteannotationerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.deleteContainerProtectionRepositoryRule` {#mutationdeletecontainerprotectionrepositoryrule}

コンテナリポジトリ保護ルールを削除します。

入力型: `DeleteContainerProtectionRepositoryRuleInput`

#### 引数 {#arguments-248}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdeletecontainerprotectionrepositoryruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdeletecontainerprotectionrepositoryruleid"></a>`id` | [`ContainerRegistryProtectionRuleID!`](#containerregistryprotectionruleid) | 削除するコンテナリポジトリ保護ルールのグローバルID。 |

#### フィールド {#fields-153}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdeletecontainerprotectionrepositoryruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdeletecontainerprotectionrepositoryrulecontainerprotectionrepositoryrule"></a>`containerProtectionRepositoryRule` | [`ContainerProtectionRepositoryRule`](#containerprotectionrepositoryrule) | 正常に削除されたコンテナリポジトリ保護ルール。 |
| <a id="mutationdeletecontainerprotectionrepositoryruleerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.deleteContainerProtectionTagRule` {#mutationdeletecontainerprotectiontagrule}

{{< details >}}GitLab 17.8で**導入**されました。**状態**: 実験的機能。{{< /details >}}

指定されたパターンに一致するコンテナイメージタグに変更を加えることのできるユーザーロールを制御する保護ルールを削除します。

入力型: `DeleteContainerProtectionTagRuleInput`

#### 引数 {#arguments-249}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdeletecontainerprotectiontagruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdeletecontainerprotectiontagruleid"></a>`id` | [`ContainerRegistryProtectionTagRuleID!`](#containerregistryprotectiontagruleid) | 削除するタグ保護ルールのグローバルID。 |

#### フィールド {#fields-154}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdeletecontainerprotectiontagruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdeletecontainerprotectiontagrulecontainerprotectiontagrule"></a>`containerProtectionTagRule` {{< icon name="warning-solid" >}} | [`ContainerProtectionTagRule`](#containerprotectiontagrule) | **非推奨**: **状態**: 実験的機能。GitLab 17.8で導入されました。 |
| <a id="mutationdeletecontainerprotectiontagruleerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.deleteConversationThread` {#mutationdeleteconversationthread}

{{< details >}}GitLab 17.9で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `DeleteConversationThreadInput`

#### 引数 {#arguments-250}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdeleteconversationthreadclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdeleteconversationthreadthreadid"></a>`threadId` | [`AiConversationThreadID!`](#aiconversationthreadid) | 削除するスレッドのグローバルID。 |

#### フィールド {#fields-155}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdeleteconversationthreadclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdeleteconversationthreaderrors"></a>`errors` | [`[String!]!`](#string) | スレッドの削除試行中に発生したエラーの一覧。 |
| <a id="mutationdeleteconversationthreadsuccess"></a>`success` | [`Boolean!`](#boolean) | スレッドが正常に削除された場合はtrueを返します。 |

### `Mutation.deleteDuoWorkflowsWorkflow` {#mutationdeleteduoworkflowsworkflow}

{{< details >}}GitLab 18.1で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `DeleteDuoWorkflowsWorkflowInput`

#### 引数 {#arguments-251}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdeleteduoworkflowsworkflowclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdeleteduoworkflowsworkflowworkflowid"></a>`workflowId` | [`AiDuoWorkflowsWorkflowID!`](#aiduoworkflowsworkflowid) | 削除するGitLabワークフローのグローバルID。 |

#### フィールド {#fields-156}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdeleteduoworkflowsworkflowclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdeleteduoworkflowsworkflowerrors"></a>`errors` | [`[String!]!`](#string) | ワークフローの削除試行中に発生したエラーの一覧。 |
| <a id="mutationdeleteduoworkflowsworkflowsuccess"></a>`success` | [`Boolean!`](#boolean) | ワークフローが正常に削除された場合はtrueを返します。 |

### `Mutation.deletePackagesProtectionRule` {#mutationdeletepackagesprotectionrule}

パッケージの保護ルールを削除します。

入力型: `DeletePackagesProtectionRuleInput`

#### 引数 {#arguments-252}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdeletepackagesprotectionruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdeletepackagesprotectionruleid"></a>`id` | [`PackagesProtectionRuleID!`](#packagesprotectionruleid) | 削除するパッケージ保護ルールのグローバルID。 |

#### フィールド {#fields-157}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdeletepackagesprotectionruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdeletepackagesprotectionruleerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationdeletepackagesprotectionrulepackageprotectionrule"></a>`packageProtectionRule` | [`PackagesProtectionRule`](#packagesprotectionrule) | 正常に削除されたパッケージ保護ルール。 |

### `Mutation.deletePagesDeployment` {#mutationdeletepagesdeployment}

{{< details >}}GitLab 17.1で**導入**されました。**状態**: 実験的機能。{{< /details >}}

Pagesデプロイを削除します。

入力型: `DeletePagesDeploymentInput`

#### 引数 {#arguments-253}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdeletepagesdeploymentclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdeletepagesdeploymentid"></a>`id` | [`PagesDeploymentID!`](#pagesdeploymentid) | PagesデプロイのID。 |

#### フィールド {#fields-158}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdeletepagesdeploymentclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdeletepagesdeploymenterrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationdeletepagesdeploymentpagesdeployment"></a>`pagesDeployment` | [`PagesDeployment!`](#pagesdeployment) | 削除されたPagesデプロイ。 |

### `Mutation.designManagementDelete` {#mutationdesignmanagementdelete}

入力型: `DesignManagementDeleteInput`

#### 引数 {#arguments-254}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdesignmanagementdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdesignmanagementdeletefilenames"></a>`filenames` | [`[String!]!`](#string) | 削除するデザインのファイル名。 |
| <a id="mutationdesignmanagementdeleteiid"></a>`iid` | [`ID!`](#id) | デザインを変更する対象となるイシューのIID。 |
| <a id="mutationdesignmanagementdeleteprojectpath"></a>`projectPath` | [`ID!`](#id) | イシューのデザインをアップロードするプロジェクト。 |

#### フィールド {#fields-159}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdesignmanagementdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdesignmanagementdeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationdesignmanagementdeleteversion"></a>`version` | [`DesignVersion`](#designversion) | デザインが削除された新しいバージョン。 |

### `Mutation.designManagementMove` {#mutationdesignmanagementmove}

入力型: `DesignManagementMoveInput`

#### 引数 {#arguments-255}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdesignmanagementmoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdesignmanagementmoveid"></a>`id` | [`DesignManagementDesignID!`](#designmanagementdesignid) | 移動するデザインのID。 |
| <a id="mutationdesignmanagementmovenext"></a>`next` | [`DesignManagementDesignID`](#designmanagementdesignid) | 直後にあるデザインのID。 |
| <a id="mutationdesignmanagementmoveprevious"></a>`previous` | [`DesignManagementDesignID`](#designmanagementdesignid) | 直前にあるデザインのID。 |

#### フィールド {#fields-160}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdesignmanagementmoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdesignmanagementmovedesigncollection"></a>`designCollection` | [`DesignCollection`](#designcollection) | コレクションの現在の状態。 |
| <a id="mutationdesignmanagementmoveerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.designManagementUpdate` {#mutationdesignmanagementupdate}

入力型: `DesignManagementUpdateInput`

#### 引数 {#arguments-256}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdesignmanagementupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdesignmanagementupdatedescription"></a>`description` | [`String`](#string) | デザインの説明。 |
| <a id="mutationdesignmanagementupdateid"></a>`id` | [`DesignManagementDesignID!`](#designmanagementdesignid) | 更新するデザインのID。 |

#### フィールド {#fields-161}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdesignmanagementupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdesignmanagementupdatedesign"></a>`design` | [`Design!`](#design) | 更新されたデザイン。 |
| <a id="mutationdesignmanagementupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.designManagementUpload` {#mutationdesignmanagementupload}

入力型: `DesignManagementUploadInput`

#### 引数 {#arguments-257}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdesignmanagementuploadclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdesignmanagementuploadfiles"></a>`files` | [`[Upload!]!`](#upload) | アップロードするファイル。 |
| <a id="mutationdesignmanagementuploadiid"></a>`iid` | [`ID!`](#id) | デザインを変更する対象となるイシューのIID。 |
| <a id="mutationdesignmanagementuploadprojectpath"></a>`projectPath` | [`ID!`](#id) | イシューのデザインをアップロードするプロジェクト。 |

#### フィールド {#fields-162}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdesignmanagementuploadclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdesignmanagementuploaddesigns"></a>`designs` | [`[Design!]!`](#design) | ミューテーションによってアップロードされたデザイン。 |
| <a id="mutationdesignmanagementuploaderrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationdesignmanagementuploadskippeddesigns"></a>`skippedDesigns` | [`[Design!]!`](#design) | 最新バージョン以降にコンテンツへの変更がないため、アップロードでスキップされたデザイン。 |

### `Mutation.destroyBoard` {#mutationdestroyboard}

入力型: `DestroyBoardInput`

#### 引数 {#arguments-258}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroyboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdestroyboardid"></a>`id` | [`BoardID!`](#boardid) | 削除するボードのグローバルID。 |

#### フィールド {#fields-163}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroyboardboard"></a>`board` | [`Board`](#board) | ミューテーション後のボード。 |
| <a id="mutationdestroyboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdestroyboarderrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.destroyBoardList` {#mutationdestroyboardlist}

入力型: `DestroyBoardListInput`

#### 引数 {#arguments-259}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroyboardlistclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdestroyboardlistlistid"></a>`listId` | [`ListID!`](#listid) | 削除するリストのグローバルID。指定できるのはラベルリストのみです。 |

#### フィールド {#fields-164}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroyboardlistclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdestroyboardlisterrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationdestroyboardlistlist"></a>`list` | [`BoardList`](#boardlist) | ミューテーション後のリスト。 |

### `Mutation.destroyComplianceFramework` {#mutationdestroycomplianceframework}

入力型: `DestroyComplianceFrameworkInput`

#### 引数 {#arguments-260}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroycomplianceframeworkclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdestroycomplianceframeworkid"></a>`id` | [`ComplianceManagementFrameworkID!`](#compliancemanagementframeworkid) | 削除するコンプライアンスフレームワークのグローバルID。 |

#### フィールド {#fields-165}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroycomplianceframeworkclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdestroycomplianceframeworkerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.destroyComplianceRequirement` {#mutationdestroycompliancerequirement}

{{< details >}}GitLab 17.7で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `DestroyComplianceRequirementInput`

#### 引数 {#arguments-261}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroycompliancerequirementclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdestroycompliancerequirementid"></a>`id` | [`ComplianceManagementComplianceFrameworkComplianceRequirementID!`](#compliancemanagementcomplianceframeworkcompliancerequirementid) | 削除するコンプライアンス要件のグローバルID。 |

#### フィールド {#fields-166}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroycompliancerequirementclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdestroycompliancerequirementerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.destroyComplianceRequirementsControl` {#mutationdestroycompliancerequirementscontrol}

{{< details >}}GitLab 17.9で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `DestroyComplianceRequirementsControlInput`

#### 引数 {#arguments-262}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroycompliancerequirementscontrolclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdestroycompliancerequirementscontrolid"></a>`id` | [`ComplianceManagementComplianceFrameworkComplianceRequirementsControlID!`](#compliancemanagementcomplianceframeworkcompliancerequirementscontrolid) | 削除するコンプライアンス要件コントロールのグローバルID。 |

#### フィールド {#fields-167}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroycompliancerequirementscontrolclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdestroycompliancerequirementscontrolerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.destroyContainerRepository` {#mutationdestroycontainerrepository}

入力型: `DestroyContainerRepositoryInput`

#### 引数 {#arguments-263}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroycontainerrepositoryclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdestroycontainerrepositoryid"></a>`id` | [`ContainerRepositoryID!`](#containerrepositoryid) | コンテナリポジトリのID。 |

#### フィールド {#fields-168}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroycontainerrepositoryclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdestroycontainerrepositorycontainerrepository"></a>`containerRepository` | [`ContainerRepository!`](#containerrepository) | 削除スケジュール後のコンテナリポジトリポリシー。 |
| <a id="mutationdestroycontainerrepositoryerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.destroyContainerRepositoryTags` {#mutationdestroycontainerrepositorytags}

入力型: `DestroyContainerRepositoryTagsInput`

#### 引数 {#arguments-264}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroycontainerrepositorytagsclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdestroycontainerrepositorytagsid"></a>`id` | [`ContainerRepositoryID!`](#containerrepositoryid) | コンテナリポジトリのID。 |
| <a id="mutationdestroycontainerrepositorytagstagnames"></a>`tagNames` | [`[String!]!`](#string) | 削除するコンテナリポジトリタグ。合計20個以下でなければなりません。 |

#### フィールド {#fields-169}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroycontainerrepositorytagsclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdestroycontainerrepositorytagsdeletedtagnames"></a>`deletedTagNames` | [`[String!]!`](#string) | 削除されたコンテナリポジトリタグ。 |
| <a id="mutationdestroycontainerrepositorytagserrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.destroyCustomEmoji` {#mutationdestroycustomemoji}

入力型: `DestroyCustomEmojiInput`

#### 引数 {#arguments-265}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroycustomemojiclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdestroycustomemojiid"></a>`id` | [`CustomEmojiID!`](#customemojiid) | 削除するカスタム絵文字のグローバルID。 |

#### フィールド {#fields-170}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroycustomemojiclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdestroycustomemojicustomemoji"></a>`customEmoji` | [`CustomEmoji`](#customemoji) | 削除されたカスタム絵文字。 |
| <a id="mutationdestroycustomemojierrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.destroyEpicBoard` {#mutationdestroyepicboard}

{{< details >}}GitLab 17.5で**非推奨**になりました。WorkItem型に置き換えられました。{{< /details >}}

入力型: `DestroyEpicBoardInput`

#### 引数 {#arguments-266}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroyepicboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdestroyepicboardid"></a>`id` | [`BoardsEpicBoardID!`](#boardsepicboardid) | 削除するボードのグローバルID。 |

#### フィールド {#fields-171}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroyepicboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdestroyepicboardepicboard"></a>`epicBoard` | [`EpicBoard`](#epicboard) | ミューテーション後のエピックボード。 |
| <a id="mutationdestroyepicboarderrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.destroyNote` {#mutationdestroynote}

入力型: `DestroyNoteInput`

#### 引数 {#arguments-267}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroynoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdestroynoteid"></a>`id` | [`NoteID!`](#noteid) | 削除するノートのグローバルID。 |

#### フィールド {#fields-172}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroynoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdestroynoteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationdestroynotenote"></a>`note` | [`Note`](#note) | ミューテーション後のノート。 |
| <a id="mutationdestroynotequickactionsstatus"></a>`quickActionsStatus` | [`QuickActionsStatus`](#quickactionsstatus) | ミューテーション後のクイックアクションのステータス。 |

### `Mutation.destroyPackage` {#mutationdestroypackage}

入力型: `DestroyPackageInput`

#### 引数 {#arguments-268}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroypackageclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdestroypackageid"></a>`id` | [`PackagesPackageID!`](#packagespackageid) | パッケージのID。 |

#### フィールド {#fields-173}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroypackageclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdestroypackageerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.destroyPackageFile` {#mutationdestroypackagefile}

入力型: `DestroyPackageFileInput`

#### 引数 {#arguments-269}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroypackagefileclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdestroypackagefileid"></a>`id` | [`PackagesPackageFileID!`](#packagespackagefileid) | パッケージファイルのID。 |

#### フィールド {#fields-174}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroypackagefileclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdestroypackagefileerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.destroyPackageFiles` {#mutationdestroypackagefiles}

入力型: `DestroyPackageFilesInput`

#### 引数 {#arguments-270}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroypackagefilesclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdestroypackagefilesids"></a>`ids` | [`[PackagesPackageFileID!]!`](#packagespackagefileid) | パッケージファイルのID。 |
| <a id="mutationdestroypackagefilesprojectpath"></a>`projectPath` | [`ID!`](#id) | パッケージクリーンアップポリシーの属するプロジェクトパス。 |

#### フィールド {#fields-175}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroypackagefilesclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdestroypackagefileserrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.destroyPackages` {#mutationdestroypackages}

入力型: `DestroyPackagesInput`

#### 引数 {#arguments-271}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroypackagesclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdestroypackagesids"></a>`ids` | [`[PackagesPackageID!]!`](#packagespackageid) | パッケージのグローバルID。最大100。 |

#### フィールド {#fields-176}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroypackagesclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdestroypackageserrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.destroySnippet` {#mutationdestroysnippet}

入力型: `DestroySnippetInput`

#### 引数 {#arguments-272}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroysnippetclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdestroysnippetid"></a>`id` | [`SnippetID!`](#snippetid) | 削除するスニペットのグローバルID。 |

#### フィールド {#fields-177}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdestroysnippetclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdestroysnippeterrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationdestroysnippetsnippet"></a>`snippet` | [`Snippet`](#snippet) | ミューテーション後のスニペット。 |

### `Mutation.devfileValidate` {#mutationdevfilevalidate}

{{< details >}}GitLab 18.4で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `DevfileValidateInput`

#### 引数 {#arguments-273}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdevfilevalidateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdevfilevalidatedevfileyaml"></a>`devfileYaml` | [`String!`](#string) | インプットdevfile。 |

#### フィールド {#fields-178}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdevfilevalidateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdevfilevalidateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationdevfilevalidatevalid"></a>`valid` | [`Boolean`](#boolean) | devfileが有効かどうかを示す状態。 |

### `Mutation.disableDevopsAdoptionNamespace` {#mutationdisabledevopsadoptionnamespace}

**状態**: ベータ版。

入力型: `DisableDevopsAdoptionNamespaceInput`

#### 引数 {#arguments-274}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdisabledevopsadoptionnamespaceclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdisabledevopsadoptionnamespaceid"></a>`id` | [`[AnalyticsDevopsAdoptionEnabledNamespaceID!]!`](#analyticsdevopsadoptionenablednamespaceid) | 無効にする有効なネームスペースのID（1つまたは複数）。 |

#### フィールド {#fields-179}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdisabledevopsadoptionnamespaceclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdisabledevopsadoptionnamespaceerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.discussionToggleResolve` {#mutationdiscussiontoggleresolve}

ディスカッションの解決済み状態を切り替えます。

入力型: `DiscussionToggleResolveInput`

#### 引数 {#arguments-275}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdiscussiontoggleresolveclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdiscussiontoggleresolveid"></a>`id` | [`DiscussionID!`](#discussionid) | ディスカッションのグローバルID。 |
| <a id="mutationdiscussiontoggleresolveresolve"></a>`resolve` | [`Boolean!`](#boolean) | trueの場合、ディスカッションを解決します。falseの場合、ディスカッションを未解決にします。 |

#### フィールド {#fields-180}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdiscussiontoggleresolveclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdiscussiontoggleresolvediscussion"></a>`discussion` | [`Discussion`](#discussion) | ミューテーション後のディスカッション。 |
| <a id="mutationdiscussiontoggleresolveerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.dismissPolicyViolations` {#mutationdismisspolicyviolations}

{{< details >}}GitLab 18.4で**導入**されました。**状態**: 実験的機能。{{< /details >}}

マージリクエストにリンクされているポリシー違反を無視します。

入力型: `DismissPolicyViolationsInput`

#### 引数 {#arguments-276}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdismisspolicyviolationsclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdismisspolicyviolationscomment"></a>`comment` | [`String!`](#string) | ポリシー違反の無視を説明するコメント。 |
| <a id="mutationdismisspolicyviolationsdismissaltypes"></a>`dismissalTypes` | [`[DismissalType!]!`](#dismissaltype) | ポリシー違反を無視する型。 |
| <a id="mutationdismisspolicyviolationsiid"></a>`iid` | [`String!`](#string) | ミューテーション対象のマージリクエストのIID。 |
| <a id="mutationdismisspolicyviolationsprojectpath"></a>`projectPath` | [`ID!`](#id) | ミューテーション対象のマージリクエストが属するプロジェクト。 |
| <a id="mutationdismisspolicyviolationssecuritypolicyids"></a>`securityPolicyIds` | [`[ID!]!`](#id) | 違反を無視する警告モードポリシーのID。 |

#### フィールド {#fields-181}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationdismisspolicyviolationsclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationdismisspolicyviolationserrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationdismisspolicyviolationsmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | ミューテーション後のマージリクエスト。 |

### `Mutation.duoSettingsUpdate` {#mutationduosettingsupdate}

{{< details >}}GitLab 17.9で**導入**されました。**状態**: 実験的機能。{{< /details >}}

GitLab Duoの設定を更新します。

入力型: `DuoSettingsUpdateInput`

#### 引数 {#arguments-277}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationduosettingsupdateaigatewayurl"></a>`aiGatewayUrl` | [`String`](#string) | ローカルAIゲートウェイサーバーのURL。 |
| <a id="mutationduosettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationduosettingsupdateduoagentplatformserviceurl"></a>`duoAgentPlatformServiceUrl` | [`String`](#string) | ローカルのGitLab Duo Agent PlatformサービスのURL。 |
| <a id="mutationduosettingsupdateduocorefeaturesenabled"></a>`duoCoreFeaturesEnabled` | [`Boolean`](#boolean) | GitLab Duo Core機能が有効になっているかどうかを示します。 |

#### フィールド {#fields-182}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationduosettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationduosettingsupdateduosettings"></a>`duoSettings` | [`DuoSettings!`](#duosettings) | ミューテーションDuoの設定。 |
| <a id="mutationduosettingsupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.duoUserFeedback` {#mutationduouserfeedback}

{{< details >}}GitLab 16.10で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `DuoUserFeedbackInput`

#### 引数 {#arguments-278}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationduouserfeedbackagentversionid"></a>`agentVersionId` | [`AiAgentVersionID`](#aiagentversionid) | チャットに応答するエージェントのグローバルID。 |
| <a id="mutationduouserfeedbackaimessageid"></a>`aiMessageId` | [`String!`](#string) | AIメッセージのID。 |
| <a id="mutationduouserfeedbackclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationduouserfeedbacktrackingevent"></a>`trackingEvent` | [`TrackingEventInput`](#trackingeventinput) | 追跡イベントデータ。 |

#### フィールド {#fields-183}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationduouserfeedbackclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationduouserfeedbackerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.echoCreate` {#mutationechocreate}

変更を実行しないミューテーション。

これは、ユーザーにミューテーションアクセス権があることを確認するための、エンドポイントのテスト用途が想定されています。

入力型: `EchoCreateInput`

#### 引数 {#arguments-279}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationechocreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationechocreateerrors"></a>`errors` | [`[String!]`](#string) | ユーザーに返すエラー。 |
| <a id="mutationechocreatemessages"></a>`messages` | [`[String!]`](#string) | ユーザーに返すメッセージ。 |

#### フィールド {#fields-184}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationechocreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationechocreateechoes"></a>`echoes` | [`[String!]`](#string) | ユーザーに返されたメッセージ。 |
| <a id="mutationechocreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.enableDevopsAdoptionNamespace` {#mutationenabledevopsadoptionnamespace}

**状態**: ベータ版。

入力型: `EnableDevopsAdoptionNamespaceInput`

#### 引数 {#arguments-280}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationenabledevopsadoptionnamespaceclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationenabledevopsadoptionnamespacedisplaynamespaceid"></a>`displayNamespaceId` | [`NamespaceID`](#namespaceid) | 表示ネームスペースID。 |
| <a id="mutationenabledevopsadoptionnamespacenamespaceid"></a>`namespaceId` | [`NamespaceID!`](#namespaceid) | ネームスペースID。 |

#### フィールド {#fields-185}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationenabledevopsadoptionnamespaceclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationenabledevopsadoptionnamespaceenablednamespace"></a>`enabledNamespace` | [`DevopsAdoptionEnabledNamespace`](#devopsadoptionenablednamespace) | ミューテーション後に有効になったネームスペース。 |
| <a id="mutationenabledevopsadoptionnamespaceerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.environmentCreate` {#mutationenvironmentcreate}

環境を作成します。

入力型: `EnvironmentCreateInput`

#### 引数 {#arguments-281}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentcreateautostopsetting"></a>`autoStopSetting` | [`AutoStopSetting`](#autostopsetting) | 環境の自動停止設定。 |
| <a id="mutationenvironmentcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationenvironmentcreateclusteragentid"></a>`clusterAgentId` | [`ClustersAgentID`](#clustersagentid) | 環境のクラスターエージェント。 |
| <a id="mutationenvironmentcreatedescription"></a>`description` | [`String`](#string) | 環境の説明。 |
| <a id="mutationenvironmentcreateexternalurl"></a>`externalUrl` | [`String`](#string) | 環境の外部URL。 |
| <a id="mutationenvironmentcreatefluxresourcepath"></a>`fluxResourcePath` | [`String`](#string) | 環境のFluxリソースパス。 |
| <a id="mutationenvironmentcreatekubernetesnamespace"></a>`kubernetesNamespace` | [`String`](#string) | 環境のKubernetesネームスペース。 |
| <a id="mutationenvironmentcreatename"></a>`name` | [`String!`](#string) | 環境の名前。 |
| <a id="mutationenvironmentcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | プロジェクトのフルパス。 |
| <a id="mutationenvironmentcreatetier"></a>`tier` | [`DeploymentTier`](#deploymenttier) | 環境のプラン。 |

#### フィールド {#fields-186}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationenvironmentcreateenvironment"></a>`environment` | [`Environment`](#environment) | 作成された環境。 |
| <a id="mutationenvironmentcreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.environmentDelete` {#mutationenvironmentdelete}

環境を削除します。

入力型: `EnvironmentDeleteInput`

#### 引数 {#arguments-282}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationenvironmentdeleteid"></a>`id` | [`EnvironmentID!`](#environmentid) | 削除する環境のグローバルID。 |

#### フィールド {#fields-187}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationenvironmentdeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.environmentStop` {#mutationenvironmentstop}

環境を停止します。

入力型: `EnvironmentStopInput`

#### 引数 {#arguments-283}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentstopclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationenvironmentstopforce"></a>`force` | [`Boolean`](#boolean) | on_stopアクションを実行せずに環境を強制停止します。 |
| <a id="mutationenvironmentstopid"></a>`id` | [`EnvironmentID!`](#environmentid) | 停止する環境のグローバルID。 |

#### フィールド {#fields-188}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentstopclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationenvironmentstopenvironment"></a>`environment` | [`Environment`](#environment) | 停止試行後の環境。 |
| <a id="mutationenvironmentstoperrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.environmentUpdate` {#mutationenvironmentupdate}

環境を更新します。

入力型: `EnvironmentUpdateInput`

#### 引数 {#arguments-284}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentupdateautostopsetting"></a>`autoStopSetting` | [`AutoStopSetting`](#autostopsetting) | 環境の自動停止設定。 |
| <a id="mutationenvironmentupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationenvironmentupdateclusteragentid"></a>`clusterAgentId` | [`ClustersAgentID`](#clustersagentid) | 環境のクラスターエージェント。 |
| <a id="mutationenvironmentupdatedescription"></a>`description` | [`String`](#string) | 環境の説明。 |
| <a id="mutationenvironmentupdateexternalurl"></a>`externalUrl` | [`String`](#string) | 環境の外部URL。 |
| <a id="mutationenvironmentupdatefluxresourcepath"></a>`fluxResourcePath` | [`String`](#string) | 環境のFluxリソースパス。 |
| <a id="mutationenvironmentupdateid"></a>`id` | [`EnvironmentID!`](#environmentid) | 更新する環境のグローバルID。 |
| <a id="mutationenvironmentupdatekubernetesnamespace"></a>`kubernetesNamespace` | [`String`](#string) | 環境のKubernetesネームスペース。 |
| <a id="mutationenvironmentupdatetier"></a>`tier` | [`DeploymentTier`](#deploymenttier) | 環境のプラン。 |

#### フィールド {#fields-189}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationenvironmentupdateenvironment"></a>`environment` | [`Environment`](#environment) | 更新試行後の環境。 |
| <a id="mutationenvironmentupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.environmentsCanaryIngressUpdate` {#mutationenvironmentscanaryingressupdate}

**非推奨**このエンドポイントは、証明書ベースのクラスターとともに削除される予定です。詳細については、[このエピックを参照してください](https://gitlab.com/groups/gitlab-org/configure/-/epics/8)。

入力型: `EnvironmentsCanaryIngressUpdateInput`

#### 引数 {#arguments-285}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentscanaryingressupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationenvironmentscanaryingressupdateid"></a>`id` | [`EnvironmentID!`](#environmentid) | 更新する環境のグローバルID。 |
| <a id="mutationenvironmentscanaryingressupdateweight"></a>`weight` | [`Int!`](#int) | カナリアIngressのウェイト。 |

#### フィールド {#fields-190}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentscanaryingressupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationenvironmentscanaryingressupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.epicAddIssue` {#mutationepicaddissue}

{{< details >}}GitLab 17.5で**非推奨**になりました。`WorkItem`型に置き換えられました。詳細については、[移行ガイド](https://docs.gitlab.com/api/graphql/epic_work_items_api_migration_guide/)を参照してください。{{< /details >}}

入力型: `EpicAddIssueInput`

#### 引数 {#arguments-286}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationepicaddissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationepicaddissuegrouppath"></a>`groupPath` | [`ID!`](#id) | ミューテーション対象のエピックが属するグループ。 |
| <a id="mutationepicaddissueiid"></a>`iid` | [`ID!`](#id) | ミューテーション対象のエピックのIID。 |
| <a id="mutationepicaddissueissueiid"></a>`issueIid` | [`String!`](#string) | 追加するイシューのIID。 |
| <a id="mutationepicaddissueprojectpath"></a>`projectPath` | [`ID!`](#id) | イシューが属するプロジェクトのフルパス。 |

#### フィールド {#fields-191}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationepicaddissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationepicaddissueepic"></a>`epic` | [`Epic`](#epic) | ミューテーション後のエピック。 |
| <a id="mutationepicaddissueepicissue"></a>`epicIssue` | [`EpicIssue`](#epicissue) | エピックとイシューの関係。 |
| <a id="mutationepicaddissueerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.epicBoardCreate` {#mutationepicboardcreate}

{{< details >}}GitLab 17.5で**非推奨**になりました。WorkItem型に置き換えられました。{{< /details >}}

入力型: `EpicBoardCreateInput`

#### 引数 {#arguments-287}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationepicboardcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationepicboardcreatedisplaycolors"></a>`displayColors` | [`Boolean`](#boolean) | エピックの色を表示するかどうか。 |
| <a id="mutationepicboardcreategrouppath"></a>`groupPath` | [`ID`](#id) | リソースが関連付けられているグループのフルパス。 |
| <a id="mutationepicboardcreatehidebackloglist"></a>`hideBacklogList` | [`Boolean`](#boolean) | バックログリストを非表示にするかどうか。 |
| <a id="mutationepicboardcreatehideclosedlist"></a>`hideClosedList` | [`Boolean`](#boolean) | 完了リストを非表示にするかどうか。 |
| <a id="mutationepicboardcreatelabelids"></a>`labelIds` | [`[LabelID!]`](#labelid) | ボードに追加するラベルのID。 |
| <a id="mutationepicboardcreatelabels"></a>`labels` | [`[String!]`](#string) | イシューのラベル。 |
| <a id="mutationepicboardcreatename"></a>`name` | [`String`](#string) | ボード名。 |

#### フィールド {#fields-192}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationepicboardcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationepicboardcreateepicboard"></a>`epicBoard` | [`EpicBoard`](#epicboard) | 作成されたエピックボード。 |
| <a id="mutationepicboardcreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.epicBoardListCreate` {#mutationepicboardlistcreate}

{{< details >}}GitLab 17.5で**非推奨**になりました。WorkItem型に置き換えられました。{{< /details >}}

入力型: `EpicBoardListCreateInput`

#### 引数 {#arguments-288}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationepicboardlistcreatebacklog"></a>`backlog` | [`Boolean`](#boolean) | バックログリストを作成します。 |
| <a id="mutationepicboardlistcreateboardid"></a>`boardId` | [`BoardsEpicBoardID!`](#boardsepicboardid) | ミューテーション対象のイシューボードのグローバルID。 |
| <a id="mutationepicboardlistcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationepicboardlistcreatelabelid"></a>`labelId` | [`LabelID`](#labelid) | 既存ラベルのグローバルID。 |

#### フィールド {#fields-193}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationepicboardlistcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationepicboardlistcreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationepicboardlistcreatelist"></a>`list` | [`EpicList`](#epiclist) | エピックボード中のエピックリスト。 |

### `Mutation.epicBoardListDestroy` {#mutationepicboardlistdestroy}

{{< details >}}GitLab 17.5で**非推奨**になりました。WorkItem型に置き換えられました。{{< /details >}}

エピックボードリストを削除します。

入力型: `EpicBoardListDestroyInput`

#### 引数 {#arguments-289}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationepicboardlistdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationepicboardlistdestroylistid"></a>`listId` | [`BoardsEpicListID!`](#boardsepiclistid) | 削除するエピックボードリストのグローバルID。 |

#### フィールド {#fields-194}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationepicboardlistdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationepicboardlistdestroyerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationepicboardlistdestroylist"></a>`list` | [`EpicList`](#epiclist) | エピックボードリスト。ボードが正常に削除された場合は`null`。 |

### `Mutation.epicBoardUpdate` {#mutationepicboardupdate}

{{< details >}}GitLab 17.5で**非推奨**になりました。WorkItem型に置き換えられました。{{< /details >}}

入力型: `EpicBoardUpdateInput`

#### 引数 {#arguments-290}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationepicboardupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationepicboardupdatedisplaycolors"></a>`displayColors` | [`Boolean`](#boolean) | エピックの色を表示するかどうか。 |
| <a id="mutationepicboardupdatehidebackloglist"></a>`hideBacklogList` | [`Boolean`](#boolean) | バックログリストを非表示にするかどうか。 |
| <a id="mutationepicboardupdatehideclosedlist"></a>`hideClosedList` | [`Boolean`](#boolean) | 完了リストを非表示にするかどうか。 |
| <a id="mutationepicboardupdateid"></a>`id` | [`BoardsEpicBoardID!`](#boardsepicboardid) | エピックボードのグローバルID。 |
| <a id="mutationepicboardupdatelabelids"></a>`labelIds` | [`[LabelID!]`](#labelid) | ボードに追加するラベルのID。 |
| <a id="mutationepicboardupdatelabels"></a>`labels` | [`[String!]`](#string) | イシューのラベル。 |
| <a id="mutationepicboardupdatename"></a>`name` | [`String`](#string) | ボード名。 |

#### フィールド {#fields-195}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationepicboardupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationepicboardupdateepicboard"></a>`epicBoard` | [`EpicBoard`](#epicboard) | 更新されたエピックボード。 |
| <a id="mutationepicboardupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.epicMoveList` {#mutationepicmovelist}

{{< details >}}GitLab 17.5で**非推奨**になりました。WorkItem型に置き換えられました。{{< /details >}}

入力型: `EpicMoveListInput`

#### 引数 {#arguments-291}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationepicmovelistboardid"></a>`boardId` | [`BoardsEpicBoardID!`](#boardsepicboardid) | エピックの属するボードのグローバルIDです。 |
| <a id="mutationepicmovelistclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationepicmovelistepicid"></a>`epicId` | [`EpicID!`](#epicid) | ミューテーション対象のエピックのID。 |
| <a id="mutationepicmovelistfromlistid"></a>`fromListId` | [`BoardsEpicListID`](#boardsepiclistid) | エピックの移動元のボードリストのID。リスト間を移動する場合は必須。 |
| <a id="mutationepicmovelistmoveafterid"></a>`moveAfterId` | [`EpicID`](#epicid) | 現在のエピックの後に配置するエピックのID。 |
| <a id="mutationepicmovelistmovebeforeid"></a>`moveBeforeId` | [`EpicID`](#epicid) | 現在のエピックの前に配置するエピックのID。 |
| <a id="mutationepicmovelistpositioninlist"></a>`positionInList` | [`Int`](#int) | ボードリスト内のエピックの位置。位置は0から始まります。リストの末尾に移動するには-1を使用します。 |
| <a id="mutationepicmovelisttolistid"></a>`toListId` | [`BoardsEpicListID!`](#boardsepiclistid) | ミューテーション後にエピックが属するリストのID。 |

#### フィールド {#fields-196}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationepicmovelistclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationepicmovelistepic"></a>`epic` | [`Epic`](#epic) | ミューテーション後のエピック。 |
| <a id="mutationepicmovelisterrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.epicSetSubscription` {#mutationepicsetsubscription}

{{< details >}}GitLab 17.5で**非推奨**になりました。`WorkItem`型に置き換えられました。詳細については、[移行ガイド](https://docs.gitlab.com/api/graphql/epic_work_items_api_migration_guide/)を参照してください。{{< /details >}}

入力型: `EpicSetSubscriptionInput`

#### 引数 {#arguments-292}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationepicsetsubscriptionclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationepicsetsubscriptiongrouppath"></a>`groupPath` | [`ID!`](#id) | ミューテーション対象のエピックが属するグループ。 |
| <a id="mutationepicsetsubscriptioniid"></a>`iid` | [`ID!`](#id) | ミューテーション対象のエピックのIID。 |
| <a id="mutationepicsetsubscriptionsubscribedstate"></a>`subscribedState` | [`Boolean!`](#boolean) | サブスクリプションの望ましい状態。 |

#### フィールド {#fields-197}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationepicsetsubscriptionclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationepicsetsubscriptionepic"></a>`epic` | [`Epic`](#epic) | ミューテーション後のエピック。 |
| <a id="mutationepicsetsubscriptionerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.epicTreeReorder` {#mutationepictreereorder}

{{< details >}}GitLab 17.5で**非推奨**になりました。WorkItem型に置き換えられました。{{< /details >}}

入力型: `EpicTreeReorderInput`

#### 引数 {#arguments-293}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationepictreereorderbaseepicid"></a>`baseEpicId` | [`EpicID!`](#epicid) | ツリーのベースエピックのID。 |
| <a id="mutationepictreereorderclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationepictreereordermoved"></a>`moved` | [`EpicTreeNodeFieldsInputType!`](#epictreenodefieldsinputtype) | ツリーの位置を更新するためのパラメータ。 |

#### フィールド {#fields-198}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationepictreereorderclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationepictreereordererrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.escalationPolicyCreate` {#mutationescalationpolicycreate}

入力型: `EscalationPolicyCreateInput`

#### 引数 {#arguments-294}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationescalationpolicycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationescalationpolicycreatedescription"></a>`description` | [`String`](#string) | エスカレーションポリシーの説明。 |
| <a id="mutationescalationpolicycreatename"></a>`name` | [`String!`](#string) | エスカレーションポリシーの名前。 |
| <a id="mutationescalationpolicycreateprojectpath"></a>`projectPath` | [`ID!`](#id) | エスカレーションポリシー作成の対象となるプロジェクト。 |
| <a id="mutationescalationpolicycreaterules"></a>`rules` | [`[EscalationRuleInput!]!`](#escalationruleinput) | エスカレーションポリシーのステップ。 |

#### フィールド {#fields-199}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationescalationpolicycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationescalationpolicycreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationescalationpolicycreateescalationpolicy"></a>`escalationPolicy` | [`EscalationPolicyType`](#escalationpolicytype) | エスカレーションポリシー。 |

### `Mutation.escalationPolicyDestroy` {#mutationescalationpolicydestroy}

入力型: `EscalationPolicyDestroyInput`

#### 引数 {#arguments-295}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationescalationpolicydestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationescalationpolicydestroyid"></a>`id` | [`IncidentManagementEscalationPolicyID!`](#incidentmanagementescalationpolicyid) | 削除するエスカレーションポリシーの内部ID。 |

#### フィールド {#fields-200}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationescalationpolicydestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationescalationpolicydestroyerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationescalationpolicydestroyescalationpolicy"></a>`escalationPolicy` | [`EscalationPolicyType`](#escalationpolicytype) | エスカレーションポリシー。 |

### `Mutation.escalationPolicyUpdate` {#mutationescalationpolicyupdate}

入力型: `EscalationPolicyUpdateInput`

#### 引数 {#arguments-296}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationescalationpolicyupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationescalationpolicyupdatedescription"></a>`description` | [`String`](#string) | エスカレーションポリシーの説明。 |
| <a id="mutationescalationpolicyupdateid"></a>`id` | [`IncidentManagementEscalationPolicyID!`](#incidentmanagementescalationpolicyid) | オンコールローテーションを作成するオンコールスケジュールのID。 |
| <a id="mutationescalationpolicyupdatename"></a>`name` | [`String`](#string) | エスカレーションポリシーの名前。 |
| <a id="mutationescalationpolicyupdaterules"></a>`rules` | [`[EscalationRuleInput!]`](#escalationruleinput) | エスカレーションポリシーのステップ。 |

#### フィールド {#fields-201}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationescalationpolicyupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationescalationpolicyupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationescalationpolicyupdateescalationpolicy"></a>`escalationPolicy` | [`EscalationPolicyType`](#escalationpolicytype) | エスカレーションポリシー。 |

### `Mutation.exportRequirements` {#mutationexportrequirements}

入力型: `ExportRequirementsInput`

#### 引数 {#arguments-297}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationexportrequirementsauthorusername"></a>`authorUsername` | [`[String!]`](#string) | 要件を作成者のユーザー名でフィルタリングします。 |
| <a id="mutationexportrequirementsclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationexportrequirementsprojectpath"></a>`projectPath` | [`ID!`](#id) | 要件が関連付けられているプロジェクトのフルパス。 |
| <a id="mutationexportrequirementssearch"></a>`search` | [`String`](#string) | 要件タイトルの検索クエリ。 |
| <a id="mutationexportrequirementsselectedfields"></a>`selectedFields` | [`[String!]`](#string) | エクスポート対象として選択された要件フィールドのリスト。 |
| <a id="mutationexportrequirementssort"></a>`sort` | [`Sort`](#sort) | 要件をソート順に一覧表示します。 |
| <a id="mutationexportrequirementsstate"></a>`state` | [`RequirementState`](#requirementstate) | 要件を状態でフィルタリングします。 |

#### フィールド {#fields-202}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationexportrequirementsclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationexportrequirementserrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.externalAuditEventDestinationCreate` {#mutationexternalauditeventdestinationcreate}

入力型: `ExternalAuditEventDestinationCreateInput`

#### 引数 {#arguments-298}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationexternalauditeventdestinationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationexternalauditeventdestinationcreatedestinationurl"></a>`destinationUrl` | [`String!`](#string) | 宛先URL。 |
| <a id="mutationexternalauditeventdestinationcreategrouppath"></a>`groupPath` | [`ID!`](#id) | グループパス。 |
| <a id="mutationexternalauditeventdestinationcreatename"></a>`name` | [`String`](#string) | 宛先名。 |
| <a id="mutationexternalauditeventdestinationcreateverificationtoken"></a>`verificationToken` | [`String`](#string) | 検証トークン。 |

#### フィールド {#fields-203}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationexternalauditeventdestinationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationexternalauditeventdestinationcreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationexternalauditeventdestinationcreateexternalauditeventdestination"></a>`externalAuditEventDestination` | [`ExternalAuditEventDestination`](#externalauditeventdestination) | 作成された宛先。 |

### `Mutation.externalAuditEventDestinationDestroy` {#mutationexternalauditeventdestinationdestroy}

入力型: `ExternalAuditEventDestinationDestroyInput`

#### 引数 {#arguments-299}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationexternalauditeventdestinationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationexternalauditeventdestinationdestroyid"></a>`id` | [`AuditEventsExternalAuditEventDestinationID!`](#auditeventsexternalauditeventdestinationid) | 削除する外部監査イベント宛先のID。 |

#### フィールド {#fields-204}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationexternalauditeventdestinationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationexternalauditeventdestinationdestroyerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.externalAuditEventDestinationUpdate` {#mutationexternalauditeventdestinationupdate}

入力型: `ExternalAuditEventDestinationUpdateInput`

#### 引数 {#arguments-300}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationexternalauditeventdestinationupdateactive"></a>`active` | [`Boolean`](#boolean) | 送信先の有効ステータス。 |
| <a id="mutationexternalauditeventdestinationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationexternalauditeventdestinationupdatedestinationurl"></a>`destinationUrl` | [`String`](#string) | 変更する宛先URL。 |
| <a id="mutationexternalauditeventdestinationupdateid"></a>`id` | [`AuditEventsExternalAuditEventDestinationID!`](#auditeventsexternalauditeventdestinationid) | 更新する外部監査イベント宛先のID。 |
| <a id="mutationexternalauditeventdestinationupdatename"></a>`name` | [`String`](#string) | 宛先名。 |

#### フィールド {#fields-205}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationexternalauditeventdestinationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationexternalauditeventdestinationupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationexternalauditeventdestinationupdateexternalauditeventdestination"></a>`externalAuditEventDestination` | [`ExternalAuditEventDestination`](#externalauditeventdestination) | 更新された宛先。 |

### `Mutation.geoRegistriesBulkUpdate` {#mutationgeoregistriesbulkupdate}

{{< details >}}GitLab 16.4で**導入**されました。**状態**: 実験的機能。{{< /details >}}

指定されたレジストリクラスに対して複数のGeoレジストリのミューテーションを行います。

入力型: `GeoRegistriesBulkUpdateInput`

#### 引数 {#arguments-301}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgeoregistriesbulkupdateaction"></a>`action` | [`GeoRegistriesBulkAction!`](#georegistriesbulkaction) | Geoレジストリに対して実行するアクション。 |
| <a id="mutationgeoregistriesbulkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationgeoregistriesbulkupdateids"></a>`ids` | [`[GeoBaseRegistryID!]`](#geobaseregistryid) | IDで選択されたレジストリに対してアクションを実行します。 |
| <a id="mutationgeoregistriesbulkupdateregistryclass"></a>`registryClass` | [`GeoRegistryClass!`](#georegistryclass) | 更新するGeoレジストリのクラス。 |
| <a id="mutationgeoregistriesbulkupdatereplicationstate"></a>`replicationState` | [`ReplicationStateEnum`](#replicationstateenum) | レプリケーション状態によって選択されたレジストリに対してアクションを実行します。 |
| <a id="mutationgeoregistriesbulkupdateverificationstate"></a>`verificationState` | [`VerificationStateEnum`](#verificationstateenum) | 検証状態によって選択されたレジストリに対してアクションを実行します。 |

#### フィールド {#fields-206}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgeoregistriesbulkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationgeoregistriesbulkupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationgeoregistriesbulkupdateregistryclass"></a>`registryClass` | [`GeoRegistryClass`](#georegistryclass) | 更新されたGeoレジストリクラス。 |

### `Mutation.geoRegistriesUpdate` {#mutationgeoregistriesupdate}

{{< details >}}GitLab 16.1で**導入**されました。**状態**: 実験的機能。{{< /details >}}

Geoレジストリのミューテーションを行う。

入力型: `GeoRegistriesUpdateInput`

#### 引数 {#arguments-302}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgeoregistriesupdateaction"></a>`action` | [`GeoRegistryAction!`](#georegistryaction) | Geoレジストリに対して実行するアクション。 |
| <a id="mutationgeoregistriesupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationgeoregistriesupdateregistryid"></a>`registryId` | [`GeoBaseRegistryID!`](#geobaseregistryid) | 更新するGeoレジストリエントリのID。 |

#### フィールド {#fields-207}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgeoregistriesupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationgeoregistriesupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationgeoregistriesupdateregistry"></a>`registry` | [`Registrable`](#registrable) | 更新されたGeoレジストリエントリ。 |

### `Mutation.gitlabSubscriptionActivate` {#mutationgitlabsubscriptionactivate}

入力型: `GitlabSubscriptionActivateInput`

#### 引数 {#arguments-303}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgitlabsubscriptionactivateactivationcode"></a>`activationCode` | [`String!`](#string) | GitLabサブスクリプションの購入後に受信したアクティベーションコード。 |
| <a id="mutationgitlabsubscriptionactivateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |

#### フィールド {#fields-208}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgitlabsubscriptionactivateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationgitlabsubscriptionactivateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationgitlabsubscriptionactivatefuturesubscriptions"></a>`futureSubscriptions` | [`[SubscriptionFutureEntry!]`](#subscriptionfutureentry) | 将来のサブスクリプションの配列。 |
| <a id="mutationgitlabsubscriptionactivatelicense"></a>`license` | [`CurrentLicense`](#currentlicense) | 現在のライセンス。 |

### `Mutation.googleCloudLoggingConfigurationCreate` {#mutationgooglecloudloggingconfigurationcreate}

入力型: `GoogleCloudLoggingConfigurationCreateInput`

#### 引数 {#arguments-304}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgooglecloudloggingconfigurationcreateclientemail"></a>`clientEmail` | [`String!`](#string) | Google Cloud Loggingサービスの認証ややり取りに使用されるサービスアカウントに関連付けられているメールアドレス。これは、IAM認証情報の一部です。 |
| <a id="mutationgooglecloudloggingconfigurationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationgooglecloudloggingconfigurationcreategoogleprojectidname"></a>`googleProjectIdName` | [`String!`](#string) | ログ設定が属するGoogle Cloudプロジェクトの固有識別子。 |
| <a id="mutationgooglecloudloggingconfigurationcreategrouppath"></a>`groupPath` | [`ID!`](#id) | グループパス。 |
| <a id="mutationgooglecloudloggingconfigurationcreatelogidname"></a>`logIdName` | [`String`](#string) | 同じGoogle Cloudプロジェクト内で異なるログを区別および管理するために使用する固有識別子（デフォルトは`audit_events`）。 |
| <a id="mutationgooglecloudloggingconfigurationcreatename"></a>`name` | [`String`](#string) | 宛先名。 |
| <a id="mutationgooglecloudloggingconfigurationcreateprivatekey"></a>`privateKey` | [`String!`](#string) | サービスアカウントに関連付けられているプライベートキー。このキーは、サービスアカウントの認証や、Google Cloud Loggingサービスとのやり取りの承認に使用されます。 |

#### フィールド {#fields-209}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgooglecloudloggingconfigurationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationgooglecloudloggingconfigurationcreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationgooglecloudloggingconfigurationcreategooglecloudloggingconfiguration"></a>`googleCloudLoggingConfiguration` | [`GoogleCloudLoggingConfigurationType`](#googlecloudloggingconfigurationtype) | 作成された設定。 |

### `Mutation.googleCloudLoggingConfigurationDestroy` {#mutationgooglecloudloggingconfigurationdestroy}

入力型: `GoogleCloudLoggingConfigurationDestroyInput`

#### 引数 {#arguments-305}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgooglecloudloggingconfigurationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationgooglecloudloggingconfigurationdestroyid"></a>`id` | [`AuditEventsGoogleCloudLoggingConfigurationID!`](#auditeventsgooglecloudloggingconfigurationid) | 削除するGoogle Cloudログ設定のID。 |

#### フィールド {#fields-210}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgooglecloudloggingconfigurationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationgooglecloudloggingconfigurationdestroyerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.googleCloudLoggingConfigurationUpdate` {#mutationgooglecloudloggingconfigurationupdate}

入力型: `GoogleCloudLoggingConfigurationUpdateInput`

#### 引数 {#arguments-306}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgooglecloudloggingconfigurationupdateactive"></a>`active` | [`Boolean`](#boolean) | 送信先の有効ステータス。 |
| <a id="mutationgooglecloudloggingconfigurationupdateclientemail"></a>`clientEmail` | [`String`](#string) | Google Cloud Loggingサービスの認証ややり取りに使用されるサービスアカウントに関連付けられているメールアドレス。これは、IAM認証情報の一部です。 |
| <a id="mutationgooglecloudloggingconfigurationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationgooglecloudloggingconfigurationupdategoogleprojectidname"></a>`googleProjectIdName` | [`String`](#string) | ログ設定が属するGoogle Cloudプロジェクトの固有識別子。 |
| <a id="mutationgooglecloudloggingconfigurationupdateid"></a>`id` | [`AuditEventsGoogleCloudLoggingConfigurationID!`](#auditeventsgooglecloudloggingconfigurationid) | 更新するGoogle Cloud設定のID。 |
| <a id="mutationgooglecloudloggingconfigurationupdatelogidname"></a>`logIdName` | [`String`](#string) | 同じGoogle Cloudプロジェクト内で異なるログを区別および管理するために使用する固有識別子。 |
| <a id="mutationgooglecloudloggingconfigurationupdatename"></a>`name` | [`String`](#string) | 宛先名。 |
| <a id="mutationgooglecloudloggingconfigurationupdateprivatekey"></a>`privateKey` | [`String`](#string) | サービスアカウントに関連付けられているプライベートキー。このキーは、サービスアカウントの認証や、Google Cloud Loggingサービスとのやり取りの承認に使用されます。 |

#### フィールド {#fields-211}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgooglecloudloggingconfigurationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationgooglecloudloggingconfigurationupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationgooglecloudloggingconfigurationupdategooglecloudloggingconfiguration"></a>`googleCloudLoggingConfiguration` | [`GoogleCloudLoggingConfigurationType`](#googlecloudloggingconfigurationtype) | 更新対象の設定。 |

### `Mutation.groupAuditEventStreamingDestinationsCreate` {#mutationgroupauditeventstreamingdestinationscreate}

{{< details >}}GitLab 16.11で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `GroupAuditEventStreamingDestinationsCreateInput`

#### 引数 {#arguments-307}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgroupauditeventstreamingdestinationscreatecategory"></a>`category` | [`String!`](#string) | 宛先カテゴリ。 |
| <a id="mutationgroupauditeventstreamingdestinationscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationgroupauditeventstreamingdestinationscreateconfig"></a>`config` | [`JSON!`](#json) | 宛先設定。 |
| <a id="mutationgroupauditeventstreamingdestinationscreategrouppath"></a>`groupPath` | [`ID!`](#id) | グループパス。 |
| <a id="mutationgroupauditeventstreamingdestinationscreatename"></a>`name` | [`String`](#string) | 宛先名。 |
| <a id="mutationgroupauditeventstreamingdestinationscreatesecrettoken"></a>`secretToken` | [`String`](#string) | シークレットトークン。 |

#### フィールド {#fields-212}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgroupauditeventstreamingdestinationscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationgroupauditeventstreamingdestinationscreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationgroupauditeventstreamingdestinationscreateexternalauditeventdestination"></a>`externalAuditEventDestination` | [`GroupAuditEventStreamingDestination`](#groupauditeventstreamingdestination) | 作成された宛先。 |

### `Mutation.groupAuditEventStreamingDestinationsDelete` {#mutationgroupauditeventstreamingdestinationsdelete}

{{< details >}}GitLab 16.11で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `GroupAuditEventStreamingDestinationsDeleteInput`

#### 引数 {#arguments-308}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgroupauditeventstreamingdestinationsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationgroupauditeventstreamingdestinationsdeleteid"></a>`id` | [`AuditEventsGroupExternalStreamingDestinationID!`](#auditeventsgroupexternalstreamingdestinationid) | 削除する監査イベント外部ストリーミング先のID。 |

#### フィールド {#fields-213}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgroupauditeventstreamingdestinationsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationgroupauditeventstreamingdestinationsdeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.groupAuditEventStreamingDestinationsUpdate` {#mutationgroupauditeventstreamingdestinationsupdate}

{{< details >}}GitLab 16.11で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `GroupAuditEventStreamingDestinationsUpdateInput`

#### 引数 {#arguments-309}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgroupauditeventstreamingdestinationsupdateactive"></a>`active` | [`Boolean`](#boolean) | 送信先の有効ステータス。 |
| <a id="mutationgroupauditeventstreamingdestinationsupdatecategory"></a>`category` | [`String`](#string) | 宛先カテゴリ。 |
| <a id="mutationgroupauditeventstreamingdestinationsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationgroupauditeventstreamingdestinationsupdateconfig"></a>`config` | [`JSON`](#json) | 宛先設定。 |
| <a id="mutationgroupauditeventstreamingdestinationsupdateid"></a>`id` | [`AuditEventsGroupExternalStreamingDestinationID!`](#auditeventsgroupexternalstreamingdestinationid) | 更新する外部監査イベント宛先のID。 |
| <a id="mutationgroupauditeventstreamingdestinationsupdatename"></a>`name` | [`String`](#string) | 宛先名。 |
| <a id="mutationgroupauditeventstreamingdestinationsupdatesecrettoken"></a>`secretToken` | [`String`](#string) | シークレットトークン。 |

#### フィールド {#fields-214}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgroupauditeventstreamingdestinationsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationgroupauditeventstreamingdestinationsupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationgroupauditeventstreamingdestinationsupdateexternalauditeventdestination"></a>`externalAuditEventDestination` | [`GroupAuditEventStreamingDestination`](#groupauditeventstreamingdestination) | 更新された宛先。 |

### `Mutation.groupMemberBulkUpdate` {#mutationgroupmemberbulkupdate}

入力型: `GroupMemberBulkUpdateInput`

#### 引数 {#arguments-310}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgroupmemberbulkupdateaccesslevel"></a>`accessLevel` | [`MemberAccessLevel!`](#memberaccesslevel) | メンバーの更新後アクセスレベル。 |
| <a id="mutationgroupmemberbulkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationgroupmemberbulkupdateexpiresat"></a>`expiresAt` | [`Time`](#time) | メンバーシップの有効期限が切れる日時。 |
| <a id="mutationgroupmemberbulkupdategroupid"></a>`groupId` | [`GroupID!`](#groupid) | グループのグローバルID。 |
| <a id="mutationgroupmemberbulkupdateuserids"></a>`userIds` | [`[UserID!]!`](#userid) | メンバーのグローバルID。 |

#### フィールド {#fields-215}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgroupmemberbulkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationgroupmemberbulkupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationgroupmemberbulkupdategroupmembers"></a>`groupMembers` | [`[GroupMember!]`](#groupmember) | ミューテーション後のグループメンバー。 |

### `Mutation.groupMembersExport` {#mutationgroupmembersexport}

{{< details >}}GitLab 17.4で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `GroupMembersExportInput`

#### 引数 {#arguments-311}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgroupmembersexportclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationgroupmembersexportgroupid"></a>`groupId` | [`GroupID!`](#groupid) | グループのグローバルID。 |

#### フィールド {#fields-216}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgroupmembersexportclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationgroupmembersexporterrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationgroupmembersexportmessage"></a>`message` | [`String`](#string) | エクスポートリクエストの結果メッセージ。 |

### `Mutation.groupSavedReplyCreate` {#mutationgroupsavedreplycreate}

{{< details >}}GitLab 16.10で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `GroupSavedReplyCreateInput`

#### 引数 {#arguments-312}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgroupsavedreplycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationgroupsavedreplycreatecontent"></a>`content` | [`String!`](#string) | 保存済み返信の内容。 |
| <a id="mutationgroupsavedreplycreategroupid"></a>`groupId` | [`GroupID!`](#groupid) | 保存済み返信のグループ。 |
| <a id="mutationgroupsavedreplycreatename"></a>`name` | [`String!`](#string) | 保存済み返信の名前。 |

#### フィールド {#fields-217}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgroupsavedreplycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationgroupsavedreplycreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationgroupsavedreplycreatesavedreply"></a>`savedReply` | [`GroupSavedReply`](#groupsavedreply) | ミューテーション後の保存済み返信。 |

### `Mutation.groupSavedReplyDestroy` {#mutationgroupsavedreplydestroy}

{{< details >}}GitLab 16.10で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `GroupSavedReplyDestroyInput`

#### 引数 {#arguments-313}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgroupsavedreplydestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationgroupsavedreplydestroyid"></a>`id` | [`GroupsSavedReplyID!`](#groupssavedreplyid) | グループレベル保存済み返信のグローバルID。 |

#### フィールド {#fields-218}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgroupsavedreplydestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationgroupsavedreplydestroyerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationgroupsavedreplydestroysavedreply"></a>`savedReply` | [`GroupSavedReply`](#groupsavedreply) | ミューテーション後の保存済み返信。 |

### `Mutation.groupSavedReplyUpdate` {#mutationgroupsavedreplyupdate}

{{< details >}}GitLab 16.10で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `GroupSavedReplyUpdateInput`

#### 引数 {#arguments-314}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgroupsavedreplyupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationgroupsavedreplyupdatecontent"></a>`content` | [`String!`](#string) | 保存済み返信の内容。 |
| <a id="mutationgroupsavedreplyupdateid"></a>`id` | [`GroupsSavedReplyID!`](#groupssavedreplyid) | グループレベル保存済み返信のグローバルID。 |
| <a id="mutationgroupsavedreplyupdatename"></a>`name` | [`String!`](#string) | 保存済み返信の名前。 |

#### フィールド {#fields-219}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgroupsavedreplyupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationgroupsavedreplyupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationgroupsavedreplyupdatesavedreply"></a>`savedReply` | [`GroupSavedReply`](#groupsavedreply) | ミューテーション後の保存済み返信。 |

### `Mutation.groupUpdate` {#mutationgroupupdate}

入力型: `GroupUpdateInput`

#### 引数 {#arguments-315}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgroupupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationgroupupdateduofeaturesenabled"></a>`duoFeaturesEnabled` | [`Boolean`](#boolean) | グループでGitLab Duo機能が有効になっているかどうかを示します。GitLab 16.10で導入されました。**状態**: 実験的機能。 |
| <a id="mutationgroupupdatefullpath"></a>`fullPath` | [`ID!`](#id) | 更新するグループのフルパス。 |
| <a id="mutationgroupupdatelockduofeaturesenabled"></a>`lockDuoFeaturesEnabled` | [`Boolean`](#boolean) | GitLab Duo機能で有効になっている設定が、すべてのサブグループに適用されるかどうかを示します。GitLab 16.10で導入されました。**状態**: 実験的機能。 |
| <a id="mutationgroupupdatelockmathrenderinglimitsenabled"></a>`lockMathRenderingLimitsEnabled` | [`Boolean`](#boolean) | 数式レンダリングの制限が、すべての子孫グループに対してロックされているかどうかを示します。 |
| <a id="mutationgroupupdatemathrenderinglimitsenabled"></a>`mathRenderingLimitsEnabled` | [`Boolean`](#boolean) | 数式レンダリングの制限が、グループに使用されるかどうかを示します。 |
| <a id="mutationgroupupdatename"></a>`name` | [`String`](#string) | グループの名前。 |
| <a id="mutationgroupupdatepath"></a>`path` | [`String`](#string) | ネームスペースのパス。 |
| <a id="mutationgroupupdatesharedrunnerssetting"></a>`sharedRunnersSetting` | [`SharedRunnersSetting`](#sharedrunnerssetting) | ネームスペースとその子孫が共有Runnerを利用できるかどうか。 |
| <a id="mutationgroupupdatevisibility"></a>`visibility` | [`VisibilityLevelsEnum`](#visibilitylevelsenum) | ネームスペースの表示レベル。 |
| <a id="mutationgroupupdatewebbasedcommitsigningenabled"></a>`webBasedCommitSigningEnabled` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | **非推奨**: **状態**: 実験的機能。GitLab 18.2で導入されました。 |

#### フィールド {#fields-220}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationgroupupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationgroupupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationgroupupdategroup"></a>`group` | [`Group`](#group) | 更新後のグループ。 |

### `Mutation.httpIntegrationCreate` {#mutationhttpintegrationcreate}

入力型: `HttpIntegrationCreateInput`

#### 引数 {#arguments-316}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationhttpintegrationcreateactive"></a>`active` | [`Boolean!`](#boolean) | インテグレーションがアラートを受信しているかどうか。 |
| <a id="mutationhttpintegrationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationhttpintegrationcreatename"></a>`name` | [`String!`](#string) | インテグレーションの名前。 |
| <a id="mutationhttpintegrationcreatepayloadattributemappings"></a>`payloadAttributeMappings` | [`[AlertManagementPayloadAlertFieldInput!]`](#alertmanagementpayloadalertfieldinput) | GitLabアラート属性からペイロードの例に基づくフィールドへのカスタムマッピング。 |
| <a id="mutationhttpintegrationcreatepayloadexample"></a>`payloadExample` | [`JsonString`](#jsonstring) | アラートペイロードの例。 |
| <a id="mutationhttpintegrationcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | インテグレーションを作成するプロジェクト。 |
| <a id="mutationhttpintegrationcreatetype"></a>`type` | [`AlertManagementIntegrationType`](#alertmanagementintegrationtype) | 作成するインテグレーションのタイプ。作成後は変更できません。 |

#### フィールド {#fields-221}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationhttpintegrationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationhttpintegrationcreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationhttpintegrationcreateintegration"></a>`integration` | [`AlertManagementHttpIntegration`](#alertmanagementhttpintegration) | アラートインテグレーション。 |

### `Mutation.httpIntegrationDestroy` {#mutationhttpintegrationdestroy}

入力型: `HttpIntegrationDestroyInput`

#### 引数 {#arguments-317}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationhttpintegrationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationhttpintegrationdestroyid"></a>`id` | [`AlertManagementHttpIntegrationID!`](#alertmanagementhttpintegrationid) | 削除するインテグレーションのID。 |

#### フィールド {#fields-222}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationhttpintegrationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationhttpintegrationdestroyerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationhttpintegrationdestroyintegration"></a>`integration` | [`AlertManagementHttpIntegration`](#alertmanagementhttpintegration) | アラートインテグレーション。 |

### `Mutation.httpIntegrationResetToken` {#mutationhttpintegrationresettoken}

入力型: `HttpIntegrationResetTokenInput`

#### 引数 {#arguments-318}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationhttpintegrationresettokenclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationhttpintegrationresettokenid"></a>`id` | [`AlertManagementHttpIntegrationID!`](#alertmanagementhttpintegrationid) | ミューテーション対象のインテグレーションのID。 |

#### フィールド {#fields-223}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationhttpintegrationresettokenclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationhttpintegrationresettokenerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationhttpintegrationresettokenintegration"></a>`integration` | [`AlertManagementHttpIntegration`](#alertmanagementhttpintegration) | アラートインテグレーション。 |

### `Mutation.httpIntegrationUpdate` {#mutationhttpintegrationupdate}

入力型: `HttpIntegrationUpdateInput`

#### 引数 {#arguments-319}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationhttpintegrationupdateactive"></a>`active` | [`Boolean`](#boolean) | インテグレーションがアラートを受信しているかどうか。 |
| <a id="mutationhttpintegrationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationhttpintegrationupdateid"></a>`id` | [`AlertManagementHttpIntegrationID!`](#alertmanagementhttpintegrationid) | ミューテーション対象のインテグレーションのID。 |
| <a id="mutationhttpintegrationupdatename"></a>`name` | [`String`](#string) | インテグレーションの名前。 |
| <a id="mutationhttpintegrationupdatepayloadattributemappings"></a>`payloadAttributeMappings` | [`[AlertManagementPayloadAlertFieldInput!]`](#alertmanagementpayloadalertfieldinput) | GitLabアラート属性からペイロードの例に基づくフィールドへのカスタムマッピング。 |
| <a id="mutationhttpintegrationupdatepayloadexample"></a>`payloadExample` | [`JsonString`](#jsonstring) | アラートペイロードの例。 |

#### フィールド {#fields-224}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationhttpintegrationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationhttpintegrationupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationhttpintegrationupdateintegration"></a>`integration` | [`AlertManagementHttpIntegration`](#alertmanagementhttpintegration) | アラートインテグレーション。 |

### `Mutation.importSourceUserCancelReassignment` {#mutationimportsourceusercancelreassignment}

{{< details >}}GitLab 17.2で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `ImportSourceUserCancelReassignmentInput`

#### 引数 {#arguments-320}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationimportsourceusercancelreassignmentclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationimportsourceusercancelreassignmentid"></a>`id` | [`ImportSourceUserID!`](#importsourceuserid) | ソースインスタンス上のユーザーから宛先インスタンス上のユーザーへのマッピングのグローバルID。 |

#### フィールド {#fields-225}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationimportsourceusercancelreassignmentclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationimportsourceusercancelreassignmenterrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationimportsourceusercancelreassignmentimportsourceuser"></a>`importSourceUser` | [`ImportSourceUser`](#importsourceuser) | ミューテーション後のソースインスタンスのユーザーから宛先インスタンスのユーザーへのマッピング。 |

### `Mutation.importSourceUserKeepAllAsPlaceholder` {#mutationimportsourceuserkeepallasplaceholder}

{{< details >}}GitLab 17.6で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `ImportSourceUserKeepAllAsPlaceholderInput`

#### 引数 {#arguments-321}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationimportsourceuserkeepallasplaceholderclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationimportsourceuserkeepallasplaceholdernamespaceid"></a>`namespaceId` | [`NamespaceID!`](#namespaceid) | ネームスペースのグローバルID。 |

#### フィールド {#fields-226}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationimportsourceuserkeepallasplaceholderclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationimportsourceuserkeepallasplaceholdererrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationimportsourceuserkeepallasplaceholderupdatedimportsourceusercount"></a>`updatedImportSourceUserCount` | [`Int`](#int) | ソースインスタンスのユーザーからその宛先ユーザーへのマッピングのうち正常に更新されたものの数。 |

### `Mutation.importSourceUserKeepAsPlaceholder` {#mutationimportsourceuserkeepasplaceholder}

{{< details >}}GitLab 17.2で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `ImportSourceUserKeepAsPlaceholderInput`

#### 引数 {#arguments-322}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationimportsourceuserkeepasplaceholderclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationimportsourceuserkeepasplaceholderid"></a>`id` | [`ImportSourceUserID!`](#importsourceuserid) | ソースインスタンス上のユーザーから宛先インスタンス上のユーザーへのマッピングのグローバルID。 |

#### フィールド {#fields-227}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationimportsourceuserkeepasplaceholderclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationimportsourceuserkeepasplaceholdererrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationimportsourceuserkeepasplaceholderimportsourceuser"></a>`importSourceUser` | [`ImportSourceUser`](#importsourceuser) | ミューテーション後のソースインスタンスのユーザーから宛先インスタンスのユーザーへのマッピング。 |

### `Mutation.importSourceUserReassign` {#mutationimportsourceuserreassign}

{{< details >}}GitLab 17.2で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `ImportSourceUserReassignInput`

#### 引数 {#arguments-323}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationimportsourceuserreassignassigneeuserid"></a>`assigneeUserId` | [`UserID!`](#userid) | 担当者ユーザーのグローバルID。 |
| <a id="mutationimportsourceuserreassignclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationimportsourceuserreassignid"></a>`id` | [`ImportSourceUserID!`](#importsourceuserid) | ソースインスタンス上のユーザーから宛先インスタンス上のユーザーへのマッピングのグローバルID。 |

#### フィールド {#fields-228}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationimportsourceuserreassignclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationimportsourceuserreassignerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationimportsourceuserreassignimportsourceuser"></a>`importSourceUser` | [`ImportSourceUser`](#importsourceuser) | ミューテーション後のソースインスタンスのユーザーから宛先インスタンスのユーザーへのマッピング。 |

### `Mutation.importSourceUserResendNotification` {#mutationimportsourceuserresendnotification}

{{< details >}}GitLab 17.2で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `ImportSourceUserResendNotificationInput`

#### 引数 {#arguments-324}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationimportsourceuserresendnotificationclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationimportsourceuserresendnotificationid"></a>`id` | [`ImportSourceUserID!`](#importsourceuserid) | ソースインスタンス上のユーザーから宛先インスタンス上のユーザーへのマッピングのグローバルID。 |

#### フィールド {#fields-229}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationimportsourceuserresendnotificationclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationimportsourceuserresendnotificationerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationimportsourceuserresendnotificationimportsourceuser"></a>`importSourceUser` | [`ImportSourceUser`](#importsourceuser) | ミューテーション後のソースインスタンスのユーザーから宛先インスタンスのユーザーへのマッピング。 |

### `Mutation.importSourceUserUndoKeepAsPlaceholder` {#mutationimportsourceuserundokeepasplaceholder}

{{< details >}}GitLab 18.4で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `ImportSourceUserUndoKeepAsPlaceholderInput`

#### 引数 {#arguments-325}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationimportsourceuserundokeepasplaceholderclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationimportsourceuserundokeepasplaceholderid"></a>`id` | [`ImportSourceUserID!`](#importsourceuserid) | ソースインスタンス上のユーザーから宛先インスタンス上のユーザーへのマッピングのグローバルID。 |

#### フィールド {#fields-230}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationimportsourceuserundokeepasplaceholderclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationimportsourceuserundokeepasplaceholdererrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationimportsourceuserundokeepasplaceholderimportsourceuser"></a>`importSourceUser` | [`ImportSourceUser`](#importsourceuser) | ミューテーション後のソースインスタンスのユーザーから宛先インスタンスのユーザーへのマッピング。 |

### `Mutation.instanceAuditEventStreamingDestinationsCreate` {#mutationinstanceauditeventstreamingdestinationscreate}

{{< details >}}GitLab 16.11で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `InstanceAuditEventStreamingDestinationsCreateInput`

#### 引数 {#arguments-326}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationinstanceauditeventstreamingdestinationscreatecategory"></a>`category` | [`String!`](#string) | 宛先カテゴリ。 |
| <a id="mutationinstanceauditeventstreamingdestinationscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationinstanceauditeventstreamingdestinationscreateconfig"></a>`config` | [`JSON!`](#json) | 宛先設定。 |
| <a id="mutationinstanceauditeventstreamingdestinationscreatename"></a>`name` | [`String`](#string) | 宛先名。 |
| <a id="mutationinstanceauditeventstreamingdestinationscreatesecrettoken"></a>`secretToken` | [`String`](#string) | シークレットトークン。 |

#### フィールド {#fields-231}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationinstanceauditeventstreamingdestinationscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationinstanceauditeventstreamingdestinationscreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationinstanceauditeventstreamingdestinationscreateexternalauditeventdestination"></a>`externalAuditEventDestination` | [`InstanceAuditEventStreamingDestination`](#instanceauditeventstreamingdestination) | 作成された宛先。 |

### `Mutation.instanceAuditEventStreamingDestinationsDelete` {#mutationinstanceauditeventstreamingdestinationsdelete}

{{< details >}}GitLab 16.11で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `InstanceAuditEventStreamingDestinationsDeleteInput`

#### 引数 {#arguments-327}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationinstanceauditeventstreamingdestinationsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationinstanceauditeventstreamingdestinationsdeleteid"></a>`id` | [`AuditEventsInstanceExternalStreamingDestinationID!`](#auditeventsinstanceexternalstreamingdestinationid) | 削除する監査イベント外部ストリーミング先のID。 |

#### フィールド {#fields-232}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationinstanceauditeventstreamingdestinationsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationinstanceauditeventstreamingdestinationsdeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.instanceAuditEventStreamingDestinationsUpdate` {#mutationinstanceauditeventstreamingdestinationsupdate}

{{< details >}}GitLab 16.11で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `InstanceAuditEventStreamingDestinationsUpdateInput`

#### 引数 {#arguments-328}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationinstanceauditeventstreamingdestinationsupdateactive"></a>`active` | [`Boolean`](#boolean) | 送信先の有効ステータス。 |
| <a id="mutationinstanceauditeventstreamingdestinationsupdatecategory"></a>`category` | [`String`](#string) | 宛先カテゴリ。 |
| <a id="mutationinstanceauditeventstreamingdestinationsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationinstanceauditeventstreamingdestinationsupdateconfig"></a>`config` | [`JSON`](#json) | 宛先設定。 |
| <a id="mutationinstanceauditeventstreamingdestinationsupdateid"></a>`id` | [`AuditEventsInstanceExternalStreamingDestinationID!`](#auditeventsinstanceexternalstreamingdestinationid) | 更新する外部監査イベント宛先のID。 |
| <a id="mutationinstanceauditeventstreamingdestinationsupdatename"></a>`name` | [`String`](#string) | 宛先名。 |
| <a id="mutationinstanceauditeventstreamingdestinationsupdatesecrettoken"></a>`secretToken` | [`String`](#string) | シークレットトークン。 |

#### フィールド {#fields-233}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationinstanceauditeventstreamingdestinationsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationinstanceauditeventstreamingdestinationsupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationinstanceauditeventstreamingdestinationsupdateexternalauditeventdestination"></a>`externalAuditEventDestination` | [`InstanceAuditEventStreamingDestination`](#instanceauditeventstreamingdestination) | 更新された宛先。 |

### `Mutation.instanceExternalAuditEventDestinationCreate` {#mutationinstanceexternalauditeventdestinationcreate}

入力型: `InstanceExternalAuditEventDestinationCreateInput`

#### 引数 {#arguments-329}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationinstanceexternalauditeventdestinationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationinstanceexternalauditeventdestinationcreatedestinationurl"></a>`destinationUrl` | [`String!`](#string) | 宛先URL。 |
| <a id="mutationinstanceexternalauditeventdestinationcreatename"></a>`name` | [`String`](#string) | 宛先名。 |

#### フィールド {#fields-234}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationinstanceexternalauditeventdestinationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationinstanceexternalauditeventdestinationcreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationinstanceexternalauditeventdestinationcreateinstanceexternalauditeventdestination"></a>`instanceExternalAuditEventDestination` | [`InstanceExternalAuditEventDestination`](#instanceexternalauditeventdestination) | 作成された宛先。 |

### `Mutation.instanceExternalAuditEventDestinationDestroy` {#mutationinstanceexternalauditeventdestinationdestroy}

入力型: `InstanceExternalAuditEventDestinationDestroyInput`

#### 引数 {#arguments-330}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationinstanceexternalauditeventdestinationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationinstanceexternalauditeventdestinationdestroyid"></a>`id` | [`AuditEventsInstanceExternalAuditEventDestinationID!`](#auditeventsinstanceexternalauditeventdestinationid) | 削除する外部インスタンス監査イベント宛先のID。 |

#### フィールド {#fields-235}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationinstanceexternalauditeventdestinationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationinstanceexternalauditeventdestinationdestroyerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.instanceExternalAuditEventDestinationUpdate` {#mutationinstanceexternalauditeventdestinationupdate}

入力型: `InstanceExternalAuditEventDestinationUpdateInput`

#### 引数 {#arguments-331}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationinstanceexternalauditeventdestinationupdateactive"></a>`active` | [`Boolean`](#boolean) | 送信先の有効ステータス。 |
| <a id="mutationinstanceexternalauditeventdestinationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationinstanceexternalauditeventdestinationupdatedestinationurl"></a>`destinationUrl` | [`String`](#string) | 変更する宛先URL。 |
| <a id="mutationinstanceexternalauditeventdestinationupdateid"></a>`id` | [`AuditEventsInstanceExternalAuditEventDestinationID!`](#auditeventsinstanceexternalauditeventdestinationid) | 更新する外部インスタンス監査イベント宛先のID。 |
| <a id="mutationinstanceexternalauditeventdestinationupdatename"></a>`name` | [`String`](#string) | 宛先名。 |

#### フィールド {#fields-236}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationinstanceexternalauditeventdestinationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationinstanceexternalauditeventdestinationupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationinstanceexternalauditeventdestinationupdateinstanceexternalauditeventdestination"></a>`instanceExternalAuditEventDestination` | [`InstanceExternalAuditEventDestination`](#instanceexternalauditeventdestination) | 更新された宛先。 |

### `Mutation.instanceGoogleCloudLoggingConfigurationCreate` {#mutationinstancegooglecloudloggingconfigurationcreate}

入力型: `InstanceGoogleCloudLoggingConfigurationCreateInput`

#### 引数 {#arguments-332}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationinstancegooglecloudloggingconfigurationcreateclientemail"></a>`clientEmail` | [`String!`](#string) | Google Cloud Loggingサービスの認証ややり取りに使用されるサービスアカウントに関連付けられているメールアドレス。これは、IAM認証情報の一部です。 |
| <a id="mutationinstancegooglecloudloggingconfigurationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationinstancegooglecloudloggingconfigurationcreategoogleprojectidname"></a>`googleProjectIdName` | [`String!`](#string) | ログ設定が属するGoogle Cloudプロジェクトの固有識別子。 |
| <a id="mutationinstancegooglecloudloggingconfigurationcreatelogidname"></a>`logIdName` | [`String`](#string) | 同じGoogle Cloudプロジェクト内で異なるログを区別および管理するために使用する固有識別子（デフォルトは`audit_events`）。 |
| <a id="mutationinstancegooglecloudloggingconfigurationcreatename"></a>`name` | [`String`](#string) | 宛先名。 |
| <a id="mutationinstancegooglecloudloggingconfigurationcreateprivatekey"></a>`privateKey` | [`String!`](#string) | サービスアカウントに関連付けられているプライベートキー。このキーは、サービスアカウントの認証や、Google Cloud Loggingサービスとのやり取りの承認に使用されます。 |

#### フィールド {#fields-237}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationinstancegooglecloudloggingconfigurationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationinstancegooglecloudloggingconfigurationcreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationinstancegooglecloudloggingconfigurationcreateinstancegooglecloudloggingconfiguration"></a>`instanceGoogleCloudLoggingConfiguration` | [`InstanceGoogleCloudLoggingConfigurationType`](#instancegooglecloudloggingconfigurationtype) | 作成された設定。 |

### `Mutation.instanceGoogleCloudLoggingConfigurationDestroy` {#mutationinstancegooglecloudloggingconfigurationdestroy}

入力型: `InstanceGoogleCloudLoggingConfigurationDestroyInput`

#### 引数 {#arguments-333}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationinstancegooglecloudloggingconfigurationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationinstancegooglecloudloggingconfigurationdestroyid"></a>`id` | [`AuditEventsInstanceGoogleCloudLoggingConfigurationID!`](#auditeventsinstancegooglecloudloggingconfigurationid) | 削除するGoogle Cloudログ設定のID。 |

#### フィールド {#fields-238}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationinstancegooglecloudloggingconfigurationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationinstancegooglecloudloggingconfigurationdestroyerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.instanceGoogleCloudLoggingConfigurationUpdate` {#mutationinstancegooglecloudloggingconfigurationupdate}

入力型: `InstanceGoogleCloudLoggingConfigurationUpdateInput`

#### 引数 {#arguments-334}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationinstancegooglecloudloggingconfigurationupdateactive"></a>`active` | [`Boolean`](#boolean) | 送信先の有効ステータス。 |
| <a id="mutationinstancegooglecloudloggingconfigurationupdateclientemail"></a>`clientEmail` | [`String`](#string) | Google Cloud Loggingサービスの認証ややり取りに使用されるサービスアカウントに関連付けられているメールアドレス。これは、IAM認証情報の一部です。 |
| <a id="mutationinstancegooglecloudloggingconfigurationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationinstancegooglecloudloggingconfigurationupdategoogleprojectidname"></a>`googleProjectIdName` | [`String`](#string) | ログ設定が属するGoogle Cloudプロジェクトの固有識別子。 |
| <a id="mutationinstancegooglecloudloggingconfigurationupdateid"></a>`id` | [`AuditEventsInstanceGoogleCloudLoggingConfigurationID!`](#auditeventsinstancegooglecloudloggingconfigurationid) | 更新するインスタンスGoogle Cloud設定のID。 |
| <a id="mutationinstancegooglecloudloggingconfigurationupdatelogidname"></a>`logIdName` | [`String`](#string) | 同じGoogle Cloudプロジェクト内で異なるログを区別および管理するために使用する固有識別子。 |
| <a id="mutationinstancegooglecloudloggingconfigurationupdatename"></a>`name` | [`String`](#string) | 宛先名。 |
| <a id="mutationinstancegooglecloudloggingconfigurationupdateprivatekey"></a>`privateKey` | [`String`](#string) | サービスアカウントに関連付けられているプライベートキー。このキーは、サービスアカウントの認証や、Google Cloud Loggingサービスとのやり取りの承認に使用されます。 |

#### フィールド {#fields-239}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationinstancegooglecloudloggingconfigurationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationinstancegooglecloudloggingconfigurationupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationinstancegooglecloudloggingconfigurationupdateinstancegooglecloudloggingconfiguration"></a>`instanceGoogleCloudLoggingConfiguration` | [`InstanceGoogleCloudLoggingConfigurationType`](#instancegooglecloudloggingconfigurationtype) | 更新対象の設定。 |

### `Mutation.integrationExclusionCreate` {#mutationintegrationexclusioncreate}

{{< details >}} GitLab 17.0で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `IntegrationExclusionCreateInput`

#### 引数 {#arguments-335}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationintegrationexclusioncreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationintegrationexclusioncreategroupids"></a>`groupIds` | [`[GroupID!]`](#groupid) | 除外するグループのID（最大100個）。 |
| <a id="mutationintegrationexclusioncreateintegrationname"></a>`integrationName` | [`IntegrationType!`](#integrationtype) | 除外するインテグレーションのタイプ。 |
| <a id="mutationintegrationexclusioncreateprojectids"></a>`projectIds` | [`[ProjectID!]`](#projectid) | 除外するプロジェクトのID（最大100個）。 |

#### フィールド {#fields-240}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationintegrationexclusioncreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationintegrationexclusioncreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationintegrationexclusioncreateexclusions"></a>`exclusions` | [`[IntegrationExclusion!]`](#integrationexclusion) | ミューテーションによって作成されたインテグレーション除外。 |

### `Mutation.integrationExclusionDelete` {#mutationintegrationexclusiondelete}

{{< details >}} GitLab 17.0で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `IntegrationExclusionDeleteInput`

#### 引数 {#arguments-336}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationintegrationexclusiondeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationintegrationexclusiondeletegroupids"></a>`groupIds` | [`[GroupID!]`](#groupid) | 除外されたグループのID。 |
| <a id="mutationintegrationexclusiondeleteintegrationname"></a>`integrationName` | [`IntegrationType!`](#integrationtype) | インテグレーションのタイプ。 |
| <a id="mutationintegrationexclusiondeleteprojectids"></a>`projectIds` | [`[ProjectID!]`](#projectid) | 除外されたプロジェクトのID。 |

#### フィールド {#fields-241}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationintegrationexclusiondeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationintegrationexclusiondeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationintegrationexclusiondeleteexclusions"></a>`exclusions` | [`[IntegrationExclusion!]`](#integrationexclusion) | ミューテーションのため除外されなくなったプロジェクト。 |

### `Mutation.issuableResourceLinkCreate` {#mutationissuableresourcelinkcreate}

入力型: `IssuableResourceLinkCreateInput`

#### 引数 {#arguments-337}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuableresourcelinkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationissuableresourcelinkcreateid"></a>`id` | [`IssueID!`](#issueid) | リソースリンクの関連先インシデントID。 |
| <a id="mutationissuableresourcelinkcreatelink"></a>`link` | [`String!`](#string) | リソースのリンク。 |
| <a id="mutationissuableresourcelinkcreatelinktext"></a>`linkText` | [`String`](#string) | リソースのリンクテキスト。 |
| <a id="mutationissuableresourcelinkcreatelinktype"></a>`linkType` | [`IssuableResourceLinkType`](#issuableresourcelinktype) | リソースのリンクタイプ。 |

#### フィールド {#fields-242}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuableresourcelinkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationissuableresourcelinkcreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationissuableresourcelinkcreateissuableresourcelink"></a>`issuableResourceLink` | [`IssuableResourceLink`](#issuableresourcelink) | issuableリソースリンク。 |

### `Mutation.issuableResourceLinkDestroy` {#mutationissuableresourcelinkdestroy}

入力型: `IssuableResourceLinkDestroyInput`

#### 引数 {#arguments-338}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuableresourcelinkdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationissuableresourcelinkdestroyid"></a>`id` | [`IncidentManagementIssuableResourceLinkID!`](#incidentmanagementissuableresourcelinkid) | 削除するissuableリソースリンクID。 |

#### フィールド {#fields-243}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuableresourcelinkdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationissuableresourcelinkdestroyerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationissuableresourcelinkdestroyissuableresourcelink"></a>`issuableResourceLink` | [`IssuableResourceLink`](#issuableresourcelink) | issuableリソースリンク。 |

### `Mutation.issueLinkAlerts` {#mutationissuelinkalerts}

入力型: `IssueLinkAlertsInput`

#### 引数 {#arguments-339}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuelinkalertsalertreferences"></a>`alertReferences` | [`[String!]!`](#string) | インシデントにリンクするアラート参照。 |
| <a id="mutationissuelinkalertsclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationissuelinkalertsiid"></a>`iid` | [`String!`](#string) | ミューテーション対象のイシューのIID。 |
| <a id="mutationissuelinkalertsprojectpath"></a>`projectPath` | [`ID!`](#id) | ミューテーション対象のイシューの属するプロジェクト。 |

#### フィールド {#fields-244}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuelinkalertsclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationissuelinkalertserrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationissuelinkalertsissue"></a>`issue` | [`Issue`](#issue) | ミューテーション後のイシュー。 |

### `Mutation.issueMove` {#mutationissuemove}

入力型: `IssueMoveInput`

#### 引数 {#arguments-340}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuemoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationissuemoveiid"></a>`iid` | [`String!`](#string) | ミューテーション対象のイシューのIID。 |
| <a id="mutationissuemoveprojectpath"></a>`projectPath` | [`ID!`](#id) | ミューテーション対象のイシューの属するプロジェクト。 |
| <a id="mutationissuemovetargetprojectpath"></a>`targetProjectPath` | [`ID!`](#id) | イシューの移動先プロジェクト。 |

#### フィールド {#fields-245}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuemoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationissuemoveerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationissuemoveissue"></a>`issue` | [`Issue`](#issue) | ミューテーション後のイシュー。 |

### `Mutation.issueMoveList` {#mutationissuemovelist}

入力型: `IssueMoveListInput`

#### 引数 {#arguments-341}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuemovelistboardid"></a>`boardId` | [`BoardID!`](#boardid) | イシューの属するボードのグローバルID。 |
| <a id="mutationissuemovelistclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationissuemovelistepicid"></a>`epicId` {{< icon name="warning-solid" >}} | [`EpicID`](#epicid) | **非推奨**: これはWorkItem hierarchyWidgetに置き換えられる予定です。GitLab 17.5で非推奨になりました。 |
| <a id="mutationissuemovelistfromlistid"></a>`fromListId` | [`ID`](#id) | イシューの移動元ボードリストのID。 |
| <a id="mutationissuemovelistiid"></a>`iid` | [`String!`](#string) | ミューテーション対象のイシューのIID。 |
| <a id="mutationissuemovelistmoveafterid"></a>`moveAfterId` | [`ID`](#id) | 現在のイシューの後に配置するイシューのID。 |
| <a id="mutationissuemovelistmovebeforeid"></a>`moveBeforeId` | [`ID`](#id) | 現在のイシューの前に配置するイシューのID。 |
| <a id="mutationissuemovelistpositioninlist"></a>`positionInList` | [`Int`](#int) | ボードリスト内のイシューの位置。位置は0から始まります。リストの末尾に移動するには-1を使用します。 |
| <a id="mutationissuemovelistprojectpath"></a>`projectPath` | [`ID!`](#id) | ミューテーション対象のイシューの属するプロジェクト。 |
| <a id="mutationissuemovelisttolistid"></a>`toListId` | [`ID`](#id) | イシューの移動先ボードリストのID。 |

#### フィールド {#fields-246}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuemovelistclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationissuemovelisterrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationissuemovelistissue"></a>`issue` | [`Issue`](#issue) | ミューテーション後のイシュー。 |

### `Mutation.issueSetAssignees` {#mutationissuesetassignees}

入力型: `IssueSetAssigneesInput`

#### 引数 {#arguments-342}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetassigneesassigneeusernames"></a>`assigneeUsernames` | [`[String!]!`](#string) | リソースに割り当てるユーザー名。デフォルトでは、既存の担当者を置き換えます。 |
| <a id="mutationissuesetassigneesclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetassigneesiid"></a>`iid` | [`String!`](#string) | ミューテーション対象のイシューのIID。 |
| <a id="mutationissuesetassigneesoperationmode"></a>`operationMode` | [`MutationOperationMode`](#mutationoperationmode) | 実行する操作。デフォルトはREPLACEです。 |
| <a id="mutationissuesetassigneesprojectpath"></a>`projectPath` | [`ID!`](#id) | ミューテーション対象のイシューの属するプロジェクト。 |

#### フィールド {#fields-247}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetassigneesclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetassigneeserrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationissuesetassigneesissue"></a>`issue` | [`Issue`](#issue) | ミューテーション後のイシュー。 |

### `Mutation.issueSetConfidential` {#mutationissuesetconfidential}

入力型: `IssueSetConfidentialInput`

#### 引数 {#arguments-343}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetconfidentialclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetconfidentialconfidential"></a>`confidential` | [`Boolean!`](#boolean) | イシューを機密として設定するかどうか。 |
| <a id="mutationissuesetconfidentialiid"></a>`iid` | [`String!`](#string) | ミューテーション対象のイシューのIID。 |
| <a id="mutationissuesetconfidentialprojectpath"></a>`projectPath` | [`ID!`](#id) | ミューテーション対象のイシューの属するプロジェクト。 |

#### フィールド {#fields-248}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetconfidentialclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetconfidentialerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationissuesetconfidentialissue"></a>`issue` | [`Issue`](#issue) | ミューテーション後のイシュー。 |

### `Mutation.issueSetCrmContacts` {#mutationissuesetcrmcontacts}

入力型: `IssueSetCrmContactsInput`

#### 引数 {#arguments-344}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetcrmcontactsclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetcrmcontactscontactids"></a>`contactIds` | [`[CustomerRelationsContactID!]!`](#customerrelationscontactid) | 設定する顧客関連連絡先ID。デフォルトでは、既存の連絡先を置き換えます。 |
| <a id="mutationissuesetcrmcontactsiid"></a>`iid` | [`String!`](#string) | ミューテーション対象のイシューのIID。 |
| <a id="mutationissuesetcrmcontactsoperationmode"></a>`operationMode` | [`MutationOperationMode`](#mutationoperationmode) | 操作モードを変更します。デフォルトはREPLACEです。 |
| <a id="mutationissuesetcrmcontactsprojectpath"></a>`projectPath` | [`ID!`](#id) | ミューテーション対象のイシューの属するプロジェクト。 |

#### フィールド {#fields-249}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetcrmcontactsclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetcrmcontactserrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationissuesetcrmcontactsissue"></a>`issue` | [`Issue`](#issue) | ミューテーション後のイシュー。 |

### `Mutation.issueSetDueDate` {#mutationissuesetduedate}

入力型: `IssueSetDueDateInput`

#### 引数 {#arguments-345}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetduedateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetduedateduedate"></a>`dueDate` | [`Time`](#time) | イシューの目標期限。期限がnullの場合、削除されます。 |
| <a id="mutationissuesetduedateiid"></a>`iid` | [`String!`](#string) | ミューテーション対象のイシューのIID。 |
| <a id="mutationissuesetduedateprojectpath"></a>`projectPath` | [`ID!`](#id) | ミューテーション対象のイシューの属するプロジェクト。 |

#### フィールド {#fields-250}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetduedateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetduedateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationissuesetduedateissue"></a>`issue` | [`Issue`](#issue) | ミューテーション後のイシュー。 |

### `Mutation.issueSetEpic` {#mutationissuesetepic}

{{< details >}}GitLab 17.5で**非推奨**になりました。WorkItem型に置き換えられました。{{< /details >}}

入力型: `IssueSetEpicInput`

#### 引数 {#arguments-346}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetepicclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetepicepicid"></a>`epicId` {{< icon name="warning-solid" >}} | [`EpicID`](#epicid) | **非推奨**: これはWorkItem hierarchyWidgetに置き換えられる予定です。GitLab 17.5で非推奨になりました。 |
| <a id="mutationissuesetepiciid"></a>`iid` | [`String!`](#string) | ミューテーション対象のイシューのIID。 |
| <a id="mutationissuesetepicprojectpath"></a>`projectPath` | [`ID!`](#id) | ミューテーション対象のイシューの属するプロジェクト。 |

#### フィールド {#fields-251}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetepicclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetepicerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationissuesetepicissue"></a>`issue` | [`Issue`](#issue) | ミューテーション後のイシュー。 |

### `Mutation.issueSetEscalationPolicy` {#mutationissuesetescalationpolicy}

入力型: `IssueSetEscalationPolicyInput`

#### 引数 {#arguments-347}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetescalationpolicyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetescalationpolicyescalationpolicyid"></a>`escalationPolicyId` | [`IncidentManagementEscalationPolicyID`](#incidentmanagementescalationpolicyid) | イシューに割り当てるエスカレーションポリシーのグローバルID。ポリシーが存在しない場合、またはnullに設定されている場合は削除されます。 |
| <a id="mutationissuesetescalationpolicyiid"></a>`iid` | [`String!`](#string) | ミューテーション対象のイシューのIID。 |
| <a id="mutationissuesetescalationpolicyprojectpath"></a>`projectPath` | [`ID!`](#id) | ミューテーション対象のイシューの属するプロジェクト。 |

#### フィールド {#fields-252}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetescalationpolicyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetescalationpolicyerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationissuesetescalationpolicyissue"></a>`issue` | [`Issue`](#issue) | ミューテーション後のイシュー。 |

### `Mutation.issueSetEscalationStatus` {#mutationissuesetescalationstatus}

入力型: `IssueSetEscalationStatusInput`

#### 引数 {#arguments-348}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetescalationstatusclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetescalationstatusiid"></a>`iid` | [`String!`](#string) | ミューテーション対象のイシューのIID。 |
| <a id="mutationissuesetescalationstatusprojectpath"></a>`projectPath` | [`ID!`](#id) | ミューテーション対象のイシューの属するプロジェクト。 |
| <a id="mutationissuesetescalationstatusstatus"></a>`status` | [`IssueEscalationStatus!`](#issueescalationstatus) | エスカレーションステータスを設定します。 |

#### フィールド {#fields-253}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetescalationstatusclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetescalationstatuserrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationissuesetescalationstatusissue"></a>`issue` | [`Issue`](#issue) | ミューテーション後のイシュー。 |

### `Mutation.issueSetIteration` {#mutationissuesetiteration}

入力型: `IssueSetIterationInput`

#### 引数 {#arguments-349}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetiterationclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetiterationiid"></a>`iid` | [`String!`](#string) | ミューテーション対象のイシューのIID。 |
| <a id="mutationissuesetiterationiterationid"></a>`iterationId` | [`IterationID`](#iterationid) | イシューに割り当てるイテレーション。 |
| <a id="mutationissuesetiterationprojectpath"></a>`projectPath` | [`ID!`](#id) | ミューテーション対象のイシューの属するプロジェクト。 |

#### フィールド {#fields-254}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetiterationclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetiterationerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationissuesetiterationissue"></a>`issue` | [`Issue`](#issue) | ミューテーション後のイシュー。 |

### `Mutation.issueSetLocked` {#mutationissuesetlocked}

入力型: `IssueSetLockedInput`

#### 引数 {#arguments-350}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetlockedclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetlockediid"></a>`iid` | [`String!`](#string) | ミューテーション対象のイシューのIID。 |
| <a id="mutationissuesetlockedlocked"></a>`locked` | [`Boolean!`](#boolean) | イシューに関するディスカッションをロックするかどうか。 |
| <a id="mutationissuesetlockedprojectpath"></a>`projectPath` | [`ID!`](#id) | ミューテーション対象のイシューの属するプロジェクト。 |

#### フィールド {#fields-255}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetlockedclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetlockederrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationissuesetlockedissue"></a>`issue` | [`Issue`](#issue) | ミューテーション後のイシュー。 |

### `Mutation.issueSetSeverity` {#mutationissuesetseverity}

入力型: `IssueSetSeverityInput`

#### 引数 {#arguments-351}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetseverityclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetseverityiid"></a>`iid` | [`String!`](#string) | ミューテーション対象のイシューのIID。 |
| <a id="mutationissuesetseverityprojectpath"></a>`projectPath` | [`ID!`](#id) | ミューテーション対象のイシューの属するプロジェクト。 |
| <a id="mutationissuesetseverityseverity"></a>`severity` | [`IssuableSeverity!`](#issuableseverity) | インシデントの重大度レベルを設定します。 |

#### フィールド {#fields-256}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetseverityclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetseverityerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationissuesetseverityissue"></a>`issue` | [`Issue`](#issue) | ミューテーション後のイシュー。 |

### `Mutation.issueSetSubscription` {#mutationissuesetsubscription}

入力型: `IssueSetSubscriptionInput`

#### 引数 {#arguments-352}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetsubscriptionclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetsubscriptioniid"></a>`iid` | [`String!`](#string) | ミューテーション対象のイシューのIID。 |
| <a id="mutationissuesetsubscriptionprojectpath"></a>`projectPath` | [`ID!`](#id) | ミューテーション対象のイシューの属するプロジェクト。 |
| <a id="mutationissuesetsubscriptionsubscribedstate"></a>`subscribedState` | [`Boolean!`](#boolean) | サブスクリプションの望ましい状態。 |

#### フィールド {#fields-257}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetsubscriptionclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetsubscriptionerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationissuesetsubscriptionissue"></a>`issue` | [`Issue`](#issue) | ミューテーション後のイシュー。 |

### `Mutation.issueSetWeight` {#mutationissuesetweight}

入力型: `IssueSetWeightInput`

#### 引数 {#arguments-353}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetweightclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetweightiid"></a>`iid` | [`String!`](#string) | ミューテーション対象のイシューのIID。 |
| <a id="mutationissuesetweightprojectpath"></a>`projectPath` | [`ID!`](#id) | ミューテーション対象のイシューの属するプロジェクト。 |
| <a id="mutationissuesetweightweight"></a>`weight` | [`Int`](#int) | 目標とするイシューのウェイト。nullに設定すると、ウェイトは削除されます。 |

#### フィールド {#fields-258}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissuesetweightclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationissuesetweighterrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationissuesetweightissue"></a>`issue` | [`Issue`](#issue) | ミューテーション後のイシュー。 |

### `Mutation.issueUnlinkAlert` {#mutationissueunlinkalert}

入力型: `IssueUnlinkAlertInput`

#### 引数 {#arguments-354}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissueunlinkalertalertid"></a>`alertId` | [`AlertManagementAlertID!`](#alertmanagementalertid) | インシデントからリンク解除するアラートのグローバルID。 |
| <a id="mutationissueunlinkalertclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationissueunlinkalertiid"></a>`iid` | [`String!`](#string) | ミューテーション対象のイシューのIID。 |
| <a id="mutationissueunlinkalertprojectpath"></a>`projectPath` | [`ID!`](#id) | ミューテーション対象のイシューの属するプロジェクト。 |

#### フィールド {#fields-259}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationissueunlinkalertclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationissueunlinkalerterrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationissueunlinkalertissue"></a>`issue` | [`Issue`](#issue) | ミューテーション後のイシュー。 |

### `Mutation.iterationCadenceCreate` {#mutationiterationcadencecreate}

入力型: `IterationCadenceCreateInput`

#### 引数 {#arguments-355}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationiterationcadencecreateactive"></a>`active` | [`Boolean!`](#boolean) | イテレーションの反復が有効かどうか。 |
| <a id="mutationiterationcadencecreateautomatic"></a>`automatic` | [`Boolean!`](#boolean) | イテレーションの反復で今後のイテレーションを自動生成するかどうか。 |
| <a id="mutationiterationcadencecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationiterationcadencecreatedescription"></a>`description` | [`String`](#string) | イテレーションの反復の説明。最大長は5000文字です。 |
| <a id="mutationiterationcadencecreatedurationinweeks"></a>`durationInWeeks` | [`Int`](#int) | ケイデンス内でのイテレーションの期間（週単位）。 |
| <a id="mutationiterationcadencecreategrouppath"></a>`groupPath` | [`ID!`](#id) | イテレーションの反復が作成されるグループ。 |
| <a id="mutationiterationcadencecreateiterationsinadvance"></a>`iterationsInAdvance` | [`Int`](#int) | イテレーションの反復が自動に設定されている場合に作成される今後のイテレーション。 |
| <a id="mutationiterationcadencecreaterollover"></a>`rollOver` | [`Boolean`](#boolean) | イテレーションの反復でイシューを次のイテレーションにロールオーバーするかどうか。 |
| <a id="mutationiterationcadencecreatestartdate"></a>`startDate` | [`Time`](#time) | 自動化開始日時のタイムスタンプ。 |
| <a id="mutationiterationcadencecreatetitle"></a>`title` | [`String`](#string) | イテレーションの反復のタイトル。 |

#### フィールド {#fields-260}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationiterationcadencecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationiterationcadencecreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationiterationcadencecreateiterationcadence"></a>`iterationCadence` | [`IterationCadence`](#iterationcadence) | 作成されたイテレーションの反復。 |

### `Mutation.iterationCadenceDestroy` {#mutationiterationcadencedestroy}

入力型: `IterationCadenceDestroyInput`

#### 引数 {#arguments-356}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationiterationcadencedestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationiterationcadencedestroyid"></a>`id` | [`IterationsCadenceID!`](#iterationscadenceid) | イテレーションの反復のグローバルID。 |

#### フィールド {#fields-261}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationiterationcadencedestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationiterationcadencedestroyerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationiterationcadencedestroygroup"></a>`group` | [`Group!`](#group) | イテレーションの反復が属するグループ。 |

### `Mutation.iterationCadenceUpdate` {#mutationiterationcadenceupdate}

入力型: `IterationCadenceUpdateInput`

#### 引数 {#arguments-357}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationiterationcadenceupdateactive"></a>`active` | [`Boolean`](#boolean) | イテレーションの反復が有効かどうか。 |
| <a id="mutationiterationcadenceupdateautomatic"></a>`automatic` | [`Boolean`](#boolean) | イテレーションの反復で今後のイテレーションを自動生成するかどうか。 |
| <a id="mutationiterationcadenceupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationiterationcadenceupdatedescription"></a>`description` | [`String`](#string) | イテレーションの反復の説明。最大長は5000文字です。 |
| <a id="mutationiterationcadenceupdatedurationinweeks"></a>`durationInWeeks` | [`Int`](#int) | ケイデンス内でのイテレーションの期間（週単位）。 |
| <a id="mutationiterationcadenceupdateid"></a>`id` | [`IterationsCadenceID!`](#iterationscadenceid) | イテレーションの反復のグローバルID。 |
| <a id="mutationiterationcadenceupdateiterationsinadvance"></a>`iterationsInAdvance` | [`Int`](#int) | イテレーションの反復が自動に設定されている場合に作成される今後のイテレーション。 |
| <a id="mutationiterationcadenceupdaterollover"></a>`rollOver` | [`Boolean`](#boolean) | イテレーションの反復でイシューを次のイテレーションにロールオーバーするかどうか。 |
| <a id="mutationiterationcadenceupdatestartdate"></a>`startDate` | [`Time`](#time) | 自動化開始日時のタイムスタンプ。 |
| <a id="mutationiterationcadenceupdatetitle"></a>`title` | [`String`](#string) | イテレーションの反復のタイトル。 |

#### フィールド {#fields-262}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationiterationcadenceupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationiterationcadenceupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationiterationcadenceupdateiterationcadence"></a>`iterationCadence` | [`IterationCadence`](#iterationcadence) | 更新されたイテレーションの反復。 |

### `Mutation.iterationCreate` {#mutationiterationcreate}

入力型: `iterationCreateInput`

#### 引数 {#arguments-358}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationiterationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationiterationcreatedescription"></a>`description` | [`String`](#string) | イテレーションの説明。 |
| <a id="mutationiterationcreateduedate"></a>`dueDate` | [`String`](#string) | イテレーションの終了日。 |
| <a id="mutationiterationcreategrouppath"></a>`groupPath` | [`ID`](#id) | リソースが関連付けられているグループのフルパス。 |
| <a id="mutationiterationcreateiterationscadenceid"></a>`iterationsCadenceId` | [`IterationsCadenceID`](#iterationscadenceid) | 新しいイテレーションに割り当てるイテレーションの反復のグローバルID。 |
| <a id="mutationiterationcreateprojectpath"></a>`projectPath` | [`ID`](#id) | リソースが関連付けられているプロジェクトのフルパス。 |
| <a id="mutationiterationcreatestartdate"></a>`startDate` | [`String`](#string) | イテレーションの開始日。 |
| <a id="mutationiterationcreatetitle"></a>`title` | [`String`](#string) | イテレーションのタイトル。 |

#### フィールド {#fields-263}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationiterationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationiterationcreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationiterationcreateiteration"></a>`iteration` | [`Iteration`](#iteration) | 作成されたイテレーション。 |

### `Mutation.iterationDelete` {#mutationiterationdelete}

入力型: `IterationDeleteInput`

#### 引数 {#arguments-359}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationiterationdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationiterationdeleteid"></a>`id` | [`IterationID!`](#iterationid) | イテレーションのID。 |

#### フィールド {#fields-264}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationiterationdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationiterationdeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationiterationdeletegroup"></a>`group` | [`Group!`](#group) | イテレーションが属するグループ。 |

### `Mutation.jiraImportStart` {#mutationjiraimportstart}

入力型: `JiraImportStartInput`

#### 引数 {#arguments-360}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationjiraimportstartclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationjiraimportstartjiraprojectkey"></a>`jiraProjectKey` | [`String!`](#string) | インポーターのJiraプロジェクトのプロジェクトキー。 |
| <a id="mutationjiraimportstartjiraprojectname"></a>`jiraProjectName` {{< icon name="warning-solid" >}} | [`String`](#string) | **非推奨**: 引数は使用されません。GitLab 17.4で非推奨になりました。 |
| <a id="mutationjiraimportstartprojectpath"></a>`projectPath` | [`ID!`](#id) | Jiraプロジェクトのインポート先プロジェクト。 |
| <a id="mutationjiraimportstartusersmapping"></a>`usersMapping` | [`[JiraUsersMappingInputType!]`](#jirausersmappinginputtype) | JiraからGitLabユーザーへのマッピング。 |

#### フィールド {#fields-265}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationjiraimportstartclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationjiraimportstarterrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationjiraimportstartjiraimport"></a>`jiraImport` | [`JiraImport`](#jiraimport) | ミューテーション後のJiraインポートデータ。 |

### `Mutation.jiraImportUsers` {#mutationjiraimportusers}

入力型: `JiraImportUsersInput`

#### 引数 {#arguments-361}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationjiraimportusersclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationjiraimportusersprojectpath"></a>`projectPath` | [`ID!`](#id) | Jiraユーザーのインポート先プロジェクト。 |
| <a id="mutationjiraimportusersstartat"></a>`startAt` | [`Int`](#int) | インポートを開始するレコードのインデックス（デフォルトは0）（返されるレコードは50個）。 |

#### フィールド {#fields-266}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationjiraimportusersclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationjiraimportuserserrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationjiraimportusersjirausers"></a>`jiraUsers` | [`[JiraUser!]`](#jirauser) | Jiraから返されるユーザー。可能ならメールと名前が一致します。 |

### `Mutation.jobArtifactsDestroy` {#mutationjobartifactsdestroy}

入力型: `JobArtifactsDestroyInput`

#### 引数 {#arguments-362}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationjobartifactsdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationjobartifactsdestroyid"></a>`id` | [`CiBuildID!`](#cibuildid) | ミューテーション対象のジョブのID。 |

#### フィールド {#fields-267}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationjobartifactsdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationjobartifactsdestroydestroyedartifactscount"></a>`destroyedArtifactsCount` | [`Int!`](#int) | 削除されたアーティファクトの数。 |
| <a id="mutationjobartifactsdestroyerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationjobartifactsdestroyjob"></a>`job` | [`CiJob`](#cijob) | 削除するアーティファクトを含むジョブ。 |

### `Mutation.jobCancel` {#mutationjobcancel}

入力型: `JobCancelInput`

#### 引数 {#arguments-363}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationjobcancelclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationjobcancelid"></a>`id` | [`CiBuildID!`](#cibuildid) | ミューテーション対象のジョブのID。 |

#### フィールド {#fields-268}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationjobcancelclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationjobcancelerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationjobcanceljob"></a>`job` | [`CiJob`](#cijob) | ミューテーション後のジョブ。 |

### `Mutation.jobPlay` {#mutationjobplay}

入力型: `JobPlayInput`

#### 引数 {#arguments-364}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationjobplayclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationjobplayid"></a>`id` | [`CiProcessableID!`](#ciprocessableid) | ミューテーション対象のジョブのID。 |
| <a id="mutationjobplayvariables"></a>`variables` | [`[CiVariableInput!]`](#civariableinput) | 手動ジョブ再生時に使用する変数。 |

#### フィールド {#fields-269}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationjobplayclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationjobplayerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationjobplayjob"></a>`job` | [`CiJob`](#cijob) | ミューテーション後のジョブ。 |

### `Mutation.jobRetry` {#mutationjobretry}

入力型: `JobRetryInput`

#### 引数 {#arguments-365}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationjobretryclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationjobretryid"></a>`id` | [`CiProcessableID!`](#ciprocessableid) | ミューテーション対象のジョブのID。 |
| <a id="mutationjobretryvariables"></a>`variables` | [`[CiVariableInput!]`](#civariableinput) | 手動ジョブの再試行時に使用する変数。 |

#### フィールド {#fields-270}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationjobretryclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationjobretryerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationjobretryjob"></a>`job` | [`CiJob`](#cijob) | ミューテーション後のジョブ。 |

### `Mutation.jobUnschedule` {#mutationjobunschedule}

入力型: `JobUnscheduleInput`

#### 引数 {#arguments-366}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationjobunscheduleclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationjobunscheduleid"></a>`id` | [`CiBuildID!`](#cibuildid) | ミューテーション対象のジョブのID。 |

#### フィールド {#fields-271}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationjobunscheduleclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationjobunscheduleerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationjobunschedulejob"></a>`job` | [`CiJob`](#cijob) | ミューテーション後のジョブ。 |

### `Mutation.labelCreate` {#mutationlabelcreate}

入力型: `LabelCreateInput`

#### 引数 {#arguments-367}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationlabelcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationlabelcreatecolor"></a>`color` | [`String`](#string) | ラベルの色。先頭が「#」記号の6桁の16進数表記（`#FFAABB`など）か、またはCSSカラー名のいずれかで指定。 |
| <a id="mutationlabelcreatedescription"></a>`description` | [`String`](#string) | ラベルの説明。 |
| <a id="mutationlabelcreategrouppath"></a>`groupPath` | [`ID`](#id) | リソースが関連付けられているグループのフルパス。 |
| <a id="mutationlabelcreateprojectpath"></a>`projectPath` | [`ID`](#id) | リソースが関連付けられているプロジェクトのフルパス。 |
| <a id="mutationlabelcreatetitle"></a>`title` | [`String!`](#string) | ラベルのタイトル。 |

#### フィールド {#fields-272}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationlabelcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationlabelcreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationlabelcreatelabel"></a>`label` | [`Label`](#label) | ミューテーション後のラベル。 |

### `Mutation.labelUpdate` {#mutationlabelupdate}

入力型: `LabelUpdateInput`

#### 引数 {#arguments-368}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationlabelupdatearchived"></a>`archived` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | **非推奨**: **状態**: 実験的機能。GitLab 18.4で導入されました。 |
| <a id="mutationlabelupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationlabelupdateid"></a>`id` | [`LabelID!`](#labelid) | 更新するラベルのグローバルID。 |

#### フィールド {#fields-273}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationlabelupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationlabelupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationlabelupdatelabel"></a>`label` | [`Label`](#label) | ミューテーション後のラベル。 |

### `Mutation.ldapAdminRoleLinkCreate` {#mutationldapadminrolelinkcreate}

{{< details >}} GitLab 17.11で**導入**されました。**状態**: 実験的機能。{{< /details >}}

インスタンスレベルのカスタム管理者ロールのLDAPリンクを作成します。

入力型: `LdapAdminRoleLinkCreateInput`

#### 引数 {#arguments-369}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationldapadminrolelinkcreateadminmemberroleid"></a>`adminMemberRoleId` | [`MemberRoleID!`](#memberroleid) | ユーザーに割り当てるカスタムロールのグローバルID。 |
| <a id="mutationldapadminrolelinkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationldapadminrolelinkcreatecn"></a>`cn` | [`String`](#string) | LDAPグループの共通名（CN）。 |
| <a id="mutationldapadminrolelinkcreatefilter"></a>`filter` | [`String`](#string) | LDAPグループの検索フィルター。 |
| <a id="mutationldapadminrolelinkcreateprovider"></a>`provider` | [`String!`](#string) | LDAPリンクのLDAPプロバイダー。 |

#### フィールド {#fields-274}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationldapadminrolelinkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationldapadminrolelinkcreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationldapadminrolelinkcreateldapadminrolelink"></a>`ldapAdminRoleLink` | [`LdapAdminRoleLink`](#ldapadminrolelink) | インスタンスレベルのLDAPリンクを作成しました。 |

### `Mutation.ldapAdminRoleLinkDestroy` {#mutationldapadminrolelinkdestroy}

{{< details >}}GitLab 18.0で**導入**されました。**状態**: 実験的機能。{{< /details >}}

インスタンスレベルのカスタム管理者ロールのLDAPリンクを削除します。

入力型: `LdapAdminRoleLinkDestroyInput`

#### 引数 {#arguments-370}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationldapadminrolelinkdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationldapadminrolelinkdestroyid"></a>`id` | [`AuthzLdapAdminRoleLinkID!`](#authzldapadminrolelinkid) | 削除するインスタンスレベルのLDAPリンクのグローバルID。 |

#### フィールド {#fields-275}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationldapadminrolelinkdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationldapadminrolelinkdestroyerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationldapadminrolelinkdestroyldapadminrolelink"></a>`ldapAdminRoleLink` | [`LdapAdminRoleLink`](#ldapadminrolelink) | インスタンスレベルのLDAPリンクを削除しました。 |

### `Mutation.lifecycleAttachWorkItemType` {#mutationlifecycleattachworkitemtype}

{{< details >}}GitLab 18.4で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `LifecycleAttachWorkItemTypeInput`

#### 引数 {#arguments-371}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationlifecycleattachworkitemtypeclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationlifecycleattachworkitemtypelifecycleid"></a>`lifecycleId` | [`WorkItemsStatusesLifecycleID!`](#workitemsstatuseslifecycleid) | 作業項目タイプをアタッチするライフサイクルのグローバルID。 |
| <a id="mutationlifecycleattachworkitemtypenamespacepath"></a>`namespacePath` | [`ID!`](#id) | ライフサイクルが存在するネームスペースパス。 |
| <a id="mutationlifecycleattachworkitemtypestatusmappings"></a>`statusMappings` | [`[StatusMappingInput!]`](#statusmappinginput) | 古いライフサイクルから新しいライフサイクルへの状態マッピング。 |
| <a id="mutationlifecycleattachworkitemtypeworkitemtypeid"></a>`workItemTypeId` | [`WorkItemsTypeID!`](#workitemstypeid) | ライフサイクルにアタッチする作業項目タイプのグローバルID。 |

#### フィールド {#fields-276}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationlifecycleattachworkitemtypeclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationlifecycleattachworkitemtypeerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationlifecycleattachworkitemtypelifecycle"></a>`lifecycle` | [`WorkItemLifecycle`](#workitemlifecycle) | 作業項目タイプをアタッチした後のライフサイクル。 |

### `Mutation.lifecycleCreate` {#mutationlifecyclecreate}

{{< details >}}GitLab 18.4で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `LifecycleCreateInput`

#### 引数 {#arguments-372}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationlifecyclecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationlifecyclecreatedefaultclosedstatusindex"></a>`defaultClosedStatusIndex` | [`Int!`](#int) | 状態配列内のデフォルトの完了状態のインデックス。 |
| <a id="mutationlifecyclecreatedefaultduplicatestatusindex"></a>`defaultDuplicateStatusIndex` | [`Int!`](#int) | 状態配列内のデフォルトの重複状態のインデックス。 |
| <a id="mutationlifecyclecreatedefaultopenstatusindex"></a>`defaultOpenStatusIndex` | [`Int!`](#int) | 状態配列内のデフォルトのオープン状態のインデックス。 |
| <a id="mutationlifecyclecreatename"></a>`name` | [`String!`](#string) | ライフサイクルの名前。 |
| <a id="mutationlifecyclecreatenamespacepath"></a>`namespacePath` | [`ID!`](#id) | ライフサイクルが作成されるネームスペースパス。 |
| <a id="mutationlifecyclecreatestatuses"></a>`statuses` | [`[WorkItemStatusInput!]!`](#workitemstatusinput) | ライフサイクルの状態。既存のもの（ID付き）または新規（IDなし）を使用できます。 |

#### フィールド {#fields-277}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationlifecyclecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationlifecyclecreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationlifecyclecreatelifecycle"></a>`lifecycle` | [`WorkItemLifecycle`](#workitemlifecycle) | ライフサイクルが作成されました。 |

### `Mutation.lifecycleDelete` {#mutationlifecycledelete}

{{< details >}}GitLab 18.4で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `LifecycleDeleteInput`

#### 引数 {#arguments-373}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationlifecycledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationlifecycledeleteid"></a>`id` | [`WorkItemsStatusesLifecycleID!`](#workitemsstatuseslifecycleid) | 削除するライフサイクルのグローバルID。 |
| <a id="mutationlifecycledeletenamespacepath"></a>`namespacePath` | [`ID!`](#id) | ライフサイクルが存在するネームスペースパス。 |

#### フィールド {#fields-278}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationlifecycledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationlifecycledeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationlifecycledeletelifecycle"></a>`lifecycle` | [`WorkItemLifecycle`](#workitemlifecycle) | 削除されたライフサイクル。 |

### `Mutation.lifecycleUpdate` {#mutationlifecycleupdate}

{{< details >}}GitLab 18.1で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `LifecycleUpdateInput`

#### 引数 {#arguments-374}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationlifecycleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationlifecycleupdatedefaultclosedstatusindex"></a>`defaultClosedStatusIndex` | [`Int`](#int) | 状態配列内のデフォルトの完了状態のインデックス。 |
| <a id="mutationlifecycleupdatedefaultduplicatestatusindex"></a>`defaultDuplicateStatusIndex` | [`Int`](#int) | 状態配列内のデフォルトの重複状態のインデックス。 |
| <a id="mutationlifecycleupdatedefaultopenstatusindex"></a>`defaultOpenStatusIndex` | [`Int`](#int) | 状態配列内のデフォルトのオープン状態のインデックス。 |
| <a id="mutationlifecycleupdateid"></a>`id` | [`WorkItemsStatusesLifecycleID!`](#workitemsstatuseslifecycleid) | 更新するライフサイクルのグローバルID。 |
| <a id="mutationlifecycleupdatename"></a>`name` | [`String`](#string) | ライフサイクルの名前。 |
| <a id="mutationlifecycleupdatenamespacepath"></a>`namespacePath` | [`ID!`](#id) | ライフサイクルが存在するネームスペースパス。 |
| <a id="mutationlifecycleupdatestatusmappings"></a>`statusMappings` | [`[StatusMappingInput!]`](#statusmappinginput) | ライフサイクルから削除される状態のマッピング。古い状態を代替ステータスにマップします。 |
| <a id="mutationlifecycleupdatestatuses"></a>`statuses` | [`[WorkItemStatusInput!]`](#workitemstatusinput) | ライフサイクルの状態。既存のもの（ID付き）または新規（IDなし）を使用できます。 |

#### フィールド {#fields-279}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationlifecycleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationlifecycleupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationlifecycleupdatelifecycle"></a>`lifecycle` | [`WorkItemLifecycle`](#workitemlifecycle) | 更新されたライフサイクル。 |

### `Mutation.linkProjectComplianceViolationIssue` {#mutationlinkprojectcomplianceviolationissue}

{{< details >}}GitLab 18.3で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `LinkProjectComplianceViolationIssueInput`

#### 引数 {#arguments-375}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationlinkprojectcomplianceviolationissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationlinkprojectcomplianceviolationissueissueiid"></a>`issueIid` | [`String!`](#string) | リンクするイシューのIID。 |
| <a id="mutationlinkprojectcomplianceviolationissueprojectpath"></a>`projectPath` | [`ID!`](#id) | イシューが属するプロジェクトのフルパス。 |
| <a id="mutationlinkprojectcomplianceviolationissueviolationid"></a>`violationId` | [`ComplianceManagementProjectsComplianceViolationID!`](#compliancemanagementprojectscomplianceviolationid) | プロジェクトコンプライアンス違反のグローバルID。 |

#### フィールド {#fields-280}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationlinkprojectcomplianceviolationissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationlinkprojectcomplianceviolationissueerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationlinkprojectcomplianceviolationissueviolation"></a>`violation` | [`ProjectComplianceViolation`](#projectcomplianceviolation) | 更新されたプロジェクトのコンプライアンス違反。 |

### `Mutation.markAsSpamSnippet` {#mutationmarkasspamsnippet}

入力型: `MarkAsSpamSnippetInput`

#### 引数 {#arguments-376}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmarkasspamsnippetclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmarkasspamsnippetid"></a>`id` | [`SnippetID!`](#snippetid) | 更新するスニペットのグローバルID。 |

#### フィールド {#fields-281}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmarkasspamsnippetclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmarkasspamsnippeterrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationmarkasspamsnippetsnippet"></a>`snippet` | [`Snippet`](#snippet) | ミューテーション後のスニペット。 |

### `Mutation.mavenUpstreamCreate` {#mutationmavenupstreamcreate}

{{< details >}}GitLab 18.2で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `MavenUpstreamCreateInput`

#### 引数 {#arguments-377}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmavenupstreamcreatecachevalidityhours"></a>`cacheValidityHours` | [`Int`](#int) | キャッシュの有効期間。デフォルトは24時間です。 |
| <a id="mutationmavenupstreamcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmavenupstreamcreatedescription"></a>`description` | [`String`](#string) | アップストリームレジストリの説明。 |
| <a id="mutationmavenupstreamcreateid"></a>`id` | [`VirtualRegistriesPackagesMavenRegistryID!`](#virtualregistriespackagesmavenregistryid) | アップストリームレジストリのID。 |
| <a id="mutationmavenupstreamcreatemetadatacachevalidityhours"></a>`metadataCacheValidityHours` {{< icon name="warning-solid" >}} | [`Int`](#int) | **非推奨**: **状態**: 実験的機能。GitLab 18.4で導入されました。 |
| <a id="mutationmavenupstreamcreatename"></a>`name` | [`String!`](#string) | アップストリームレジストリの名前。 |
| <a id="mutationmavenupstreamcreatepassword"></a>`password` | [`String`](#string) | アップストリームレジストリのパスワード。 |
| <a id="mutationmavenupstreamcreateurl"></a>`url` | [`String!`](#string) | アップストリームレジストリのURL。 |
| <a id="mutationmavenupstreamcreateusername"></a>`username` | [`String`](#string) | アップストリームレジストリのユーザー名。 |

#### フィールド {#fields-282}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmavenupstreamcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmavenupstreamcreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationmavenupstreamcreateupstream"></a>`upstream` | [`MavenUpstream`](#mavenupstream) | ミューテーション後のMavenアップストリーム。 |

### `Mutation.memberRoleAdminCreate` {#mutationmemberroleadmincreate}

{{< details >}}GitLab 17.7で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `MemberRoleAdminCreateInput`

#### 引数 {#arguments-378}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmemberroleadmincreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmemberroleadmincreatedescription"></a>`description` | [`String`](#string) | メンバーロールの説明。 |
| <a id="mutationmemberroleadmincreatename"></a>`name` | [`String`](#string) | メンバーロールの名前。 |
| <a id="mutationmemberroleadmincreatepermissions"></a>`permissions` | [`[MemberRoleAdminPermission!]`](#memberroleadminpermission) | カスタマイズ可能な管理者権限すべてのリスト。 |

#### フィールド {#fields-283}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmemberroleadmincreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmemberroleadmincreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationmemberroleadmincreatememberrole"></a>`memberRole` | [`AdminMemberRole`](#adminmemberrole) | メンバーロール。 |

### `Mutation.memberRoleAdminDelete` {#mutationmemberroleadmindelete}

{{< details >}}GitLab 17.10で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `MemberRoleAdminDeleteInput`

#### 引数 {#arguments-379}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmemberroleadmindeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmemberroleadmindeleteid"></a>`id` | [`MemberRoleID!`](#memberroleid) | 削除する管理者メンバーロールのID。 |

#### フィールド {#fields-284}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmemberroleadmindeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmemberroleadmindeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationmemberroleadmindeletememberrole"></a>`memberRole` | [`MemberRole`](#memberrole) | 削除された管理者メンバーロール。 |

### `Mutation.memberRoleAdminUpdate` {#mutationmemberroleadminupdate}

{{< details >}}GitLab 17.10で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `MemberRoleAdminUpdateInput`

#### 引数 {#arguments-380}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmemberroleadminupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmemberroleadminupdatedescription"></a>`description` | [`String`](#string) | メンバーロールの説明。 |
| <a id="mutationmemberroleadminupdateid"></a>`id` | [`MemberRoleID!`](#memberroleid) | ミューテーション対象のメンバーロールのID。 |
| <a id="mutationmemberroleadminupdatename"></a>`name` | [`String`](#string) | メンバーロールの名前。 |
| <a id="mutationmemberroleadminupdatepermissions"></a>`permissions` | [`[MemberRoleAdminPermission!]`](#memberroleadminpermission) | カスタマイズ可能な管理者権限すべてのリスト。 |

#### フィールド {#fields-285}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmemberroleadminupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmemberroleadminupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationmemberroleadminupdatememberrole"></a>`memberRole` | [`AdminMemberRole`](#adminmemberrole) | メンバーロール。 |

### `Mutation.memberRoleCreate` {#mutationmemberrolecreate}

{{< details >}}GitLab 16.5で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `MemberRoleCreateInput`

#### 引数 {#arguments-381}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmemberrolecreatebaseaccesslevel"></a>`baseAccessLevel` | [`MemberRolesAccessLevel!`](#memberrolesaccesslevel) | カスタムロールの基本アクセスレベル。 |
| <a id="mutationmemberrolecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmemberrolecreatedescription"></a>`description` | [`String`](#string) | メンバーロールの説明。 |
| <a id="mutationmemberrolecreategrouppath"></a>`groupPath` | [`ID`](#id) | ミューテーション対象のメンバーロールが属するグループ。SaaSでは必須。 |
| <a id="mutationmemberrolecreatename"></a>`name` | [`String`](#string) | メンバーロールの名前。 |
| <a id="mutationmemberrolecreatepermissions"></a>`permissions` | [`[MemberRolePermission!]`](#memberrolepermission) | カスタマイズ可能な権限すべてのリスト。 |

#### フィールド {#fields-286}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmemberrolecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmemberrolecreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationmemberrolecreatememberrole"></a>`memberRole` | [`MemberRole`](#memberrole) | メンバーロール。 |

### `Mutation.memberRoleDelete` {#mutationmemberroledelete}

{{< details >}} GitLab 16.7で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `MemberRoleDeleteInput`

#### 引数 {#arguments-382}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmemberroledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmemberroledeleteid"></a>`id` | [`MemberRoleID!`](#memberroleid) | 削除するメンバーロールのID。 |

#### フィールド {#fields-287}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmemberroledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmemberroledeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationmemberroledeletememberrole"></a>`memberRole` | [`MemberRole`](#memberrole) | 削除されたメンバーロール。 |

### `Mutation.memberRoleToUserAssign` {#mutationmemberroletouserassign}

{{< details >}}GitLab 17.7で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `MemberRoleToUserAssignInput`

#### 引数 {#arguments-383}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmemberroletouserassignclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmemberroletouserassignmemberroleid"></a>`memberRoleId` | [`MemberRoleID`](#memberroleid) | ユーザーに割り当てるカスタムロールのグローバルID。省略した場合、またはNULLに設定した場合、ユーザーの管理者ロール割り当てが解除されます。 |
| <a id="mutationmemberroletouserassignuserid"></a>`userId` | [`UserID!`](#userid) | カスタムロールに割り当てるユーザーのグローバルID。 |

#### フィールド {#fields-288}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmemberroletouserassignclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmemberroletouserassignerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationmemberroletouserassignusermemberrole"></a>`userMemberRole` | [`UserMemberRole`](#usermemberrole) | 作成されたユーザーメンバーロール。関係が削除された場合はnil。 |

### `Mutation.memberRoleUpdate` {#mutationmemberroleupdate}

入力型: `MemberRoleUpdateInput`

#### 引数 {#arguments-384}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmemberroleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmemberroleupdatedescription"></a>`description` | [`String`](#string) | メンバーロールの説明。 |
| <a id="mutationmemberroleupdateid"></a>`id` | [`MemberRoleID!`](#memberroleid) | ミューテーション対象のメンバーロールのID。 |
| <a id="mutationmemberroleupdatename"></a>`name` | [`String`](#string) | メンバーロールの名前。 |
| <a id="mutationmemberroleupdatepermissions"></a>`permissions` | [`[MemberRolePermission!]`](#memberrolepermission) | カスタマイズ可能な権限すべてのリスト。 |

#### フィールド {#fields-289}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmemberroleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmemberroleupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationmemberroleupdatememberrole"></a>`memberRole` | [`MemberRole`](#memberrole) | メンバーロール。 |

### `Mutation.mergeRequestAccept` {#mutationmergerequestaccept}

マージリクエストを受け入れます。受け入れた場合と、可能ならすぐに、または自動マージ戦略のいずれかを使用して、ソースブランチがターゲットブランチにマージされるようにスケジュールされます。

[GitLab 16.5において](https://gitlab.com/gitlab-org/gitlab/-/issues/421510)、マージ操作は非同期です。そのため、ミューテーションリクエスト後も、マージが未完の可能性があり、その場合、`mergeRequest`と`state`は更新されません。

入力型: `MergeRequestAcceptInput`

#### 引数 {#arguments-385}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestacceptclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestacceptcommitmessage"></a>`commitMessage` | [`String`](#string) | カスタムGitLab Duoマージコミットメッセージ。 |
| <a id="mutationmergerequestacceptiid"></a>`iid` | [`String!`](#string) | ミューテーション対象のマージリクエストのIID。 |
| <a id="mutationmergerequestacceptprojectpath"></a>`projectPath` | [`ID!`](#id) | ミューテーション対象のマージリクエストが属するプロジェクト。 |
| <a id="mutationmergerequestacceptsha"></a>`sha` | [`String!`](#string) | マージリクエスト時点のHEAD SHA。 |
| <a id="mutationmergerequestacceptshouldremovesourcebranch"></a>`shouldRemoveSourceBranch` | [`Boolean`](#boolean) | ソースブランチを削除する必要があるかどうか。 |
| <a id="mutationmergerequestacceptsquash"></a>`squash` | [`Boolean`](#boolean) | マージする前にソースブランチのコミットをスカッシュします。 |
| <a id="mutationmergerequestacceptsquashcommitmessage"></a>`squashCommitMessage` | [`String`](#string) | カスタムスカッシュコミットメッセージ（squashがtrueの場合）。 |
| <a id="mutationmergerequestacceptstrategy"></a>`strategy` | [`MergeStrategyEnum`](#mergestrategyenum) | マージリクエストをマージする方法。 |

#### フィールド {#fields-290}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestacceptclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestaccepterrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationmergerequestacceptmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | ミューテーション後のマージリクエスト。 |

### `Mutation.mergeRequestCreate` {#mutationmergerequestcreate}

入力型: `MergeRequestCreateInput`

#### 引数 {#arguments-386}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestcreatedescription"></a>`description` | [`String`](#string) | マージリクエストの説明（Markdownをキャッシュ用にHTMLとしてレンダリング）。 |
| <a id="mutationmergerequestcreatelabels"></a>`labels` | [`[String!]`](#string) | マージリクエストのラベル。 |
| <a id="mutationmergerequestcreatemergeafter"></a>`mergeAfter` | [`Time`](#time) | マージリクエストをマージできようになる日付。 |
| <a id="mutationmergerequestcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | マージリクエストが関連付けられているプロジェクトのフルパス。 |
| <a id="mutationmergerequestcreateremovesourcebranch"></a>`removeSourceBranch` | [`Boolean`](#boolean) | マージ後にマージリクエストのソースブランチを削除するかどうかを示します。 |
| <a id="mutationmergerequestcreatesourcebranch"></a>`sourceBranch` | [`String!`](#string) | マージリクエストのソースブランチ。 |
| <a id="mutationmergerequestcreatetargetbranch"></a>`targetBranch` | [`String!`](#string) | マージリクエストのターゲットブランチ。 |
| <a id="mutationmergerequestcreatetitle"></a>`title` | [`String!`](#string) | マージリクエストのタイトル。 |

#### フィールド {#fields-291}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestcreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationmergerequestcreatemergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | ミューテーション後のマージリクエスト。 |

### `Mutation.mergeRequestDestroyRequestedChanges` {#mutationmergerequestdestroyrequestedchanges}

入力型: `MergeRequestDestroyRequestedChangesInput`

#### 引数 {#arguments-387}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestdestroyrequestedchangesclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestdestroyrequestedchangesiid"></a>`iid` | [`String!`](#string) | ミューテーション対象のマージリクエストのIID。 |
| <a id="mutationmergerequestdestroyrequestedchangesprojectpath"></a>`projectPath` | [`ID!`](#id) | ミューテーション対象のマージリクエストが属するプロジェクト。 |

#### フィールド {#fields-292}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestdestroyrequestedchangesclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestdestroyrequestedchangeserrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationmergerequestdestroyrequestedchangesmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | ミューテーション後のマージリクエスト。 |

### `Mutation.mergeRequestReviewerRereview` {#mutationmergerequestreviewerrereview}

入力型: `MergeRequestReviewerRereviewInput`

#### 引数 {#arguments-388}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestreviewerrereviewclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestreviewerrereviewiid"></a>`iid` | [`String!`](#string) | ミューテーション対象のマージリクエストのIID。 |
| <a id="mutationmergerequestreviewerrereviewprojectpath"></a>`projectPath` | [`ID!`](#id) | ミューテーション対象のマージリクエストが属するプロジェクト。 |
| <a id="mutationmergerequestreviewerrereviewuserid"></a>`userId` | [`UserID!`](#userid) | 新規レビュー用にリクエストされたユーザーのユーザーID。 |

#### フィールド {#fields-293}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestreviewerrereviewclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestreviewerrereviewerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationmergerequestreviewerrereviewmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | ミューテーション後のマージリクエスト。 |

### `Mutation.mergeRequestSetAssignees` {#mutationmergerequestsetassignees}

入力型: `MergeRequestSetAssigneesInput`

#### 引数 {#arguments-389}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetassigneesassigneeusernames"></a>`assigneeUsernames` | [`[String!]!`](#string) | リソースに割り当てるユーザー名。デフォルトでは、既存の担当者を置き換えます。 |
| <a id="mutationmergerequestsetassigneesclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestsetassigneesiid"></a>`iid` | [`String!`](#string) | ミューテーション対象のマージリクエストのIID。 |
| <a id="mutationmergerequestsetassigneesoperationmode"></a>`operationMode` | [`MutationOperationMode`](#mutationoperationmode) | 実行する操作。デフォルトはREPLACEです。 |
| <a id="mutationmergerequestsetassigneesprojectpath"></a>`projectPath` | [`ID!`](#id) | ミューテーション対象のマージリクエストが属するプロジェクト。 |

#### フィールド {#fields-294}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetassigneesclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestsetassigneeserrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationmergerequestsetassigneesmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | ミューテーション後のマージリクエスト。 |

### `Mutation.mergeRequestSetDraft` {#mutationmergerequestsetdraft}

入力型: `MergeRequestSetDraftInput`

#### 引数 {#arguments-390}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetdraftclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestsetdraftdraft"></a>`draft` | [`Boolean!`](#boolean) | マージリクエストを下書きとして設定するかどうか。 |
| <a id="mutationmergerequestsetdraftiid"></a>`iid` | [`String!`](#string) | ミューテーション対象のマージリクエストのIID。 |
| <a id="mutationmergerequestsetdraftprojectpath"></a>`projectPath` | [`ID!`](#id) | ミューテーション対象のマージリクエストが属するプロジェクト。 |

#### フィールド {#fields-295}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetdraftclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestsetdrafterrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationmergerequestsetdraftmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | ミューテーション後のマージリクエスト。 |

### `Mutation.mergeRequestSetLabels` {#mutationmergerequestsetlabels}

入力型: `MergeRequestSetLabelsInput`

#### 引数 {#arguments-391}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetlabelsclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestsetlabelsiid"></a>`iid` | [`String!`](#string) | ミューテーション対象のマージリクエストのIID。 |
| <a id="mutationmergerequestsetlabelslabelids"></a>`labelIds` | [`[LabelID!]!`](#labelid) | 設定するラベルID。デフォルトでは既存のラベルを置き換えます。 |
| <a id="mutationmergerequestsetlabelsoperationmode"></a>`operationMode` | [`MutationOperationMode`](#mutationoperationmode) | 操作モードを変更します。デフォルトはREPLACEです。 |
| <a id="mutationmergerequestsetlabelsprojectpath"></a>`projectPath` | [`ID!`](#id) | ミューテーション対象のマージリクエストが属するプロジェクト。 |

#### フィールド {#fields-296}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetlabelsclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestsetlabelserrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationmergerequestsetlabelsmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | ミューテーション後のマージリクエスト。 |

### `Mutation.mergeRequestSetLocked` {#mutationmergerequestsetlocked}

入力型: `MergeRequestSetLockedInput`

#### 引数 {#arguments-392}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetlockedclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestsetlockediid"></a>`iid` | [`String!`](#string) | ミューテーション対象のマージリクエストのIID。 |
| <a id="mutationmergerequestsetlockedlocked"></a>`locked` | [`Boolean!`](#boolean) | マージリクエストをロックするかどうか。 |
| <a id="mutationmergerequestsetlockedprojectpath"></a>`projectPath` | [`ID!`](#id) | ミューテーション対象のマージリクエストが属するプロジェクト。 |

#### フィールド {#fields-297}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetlockedclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestsetlockederrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationmergerequestsetlockedmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | ミューテーション後のマージリクエスト。 |

### `Mutation.mergeRequestSetMilestone` {#mutationmergerequestsetmilestone}

入力型: `MergeRequestSetMilestoneInput`

#### 引数 {#arguments-393}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetmilestoneclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestsetmilestoneiid"></a>`iid` | [`String!`](#string) | ミューテーション対象のマージリクエストのIID。 |
| <a id="mutationmergerequestsetmilestonemilestoneid"></a>`milestoneId` | [`MilestoneID`](#milestoneid) | マージリクエストに割り当てるマイルストーン。 |
| <a id="mutationmergerequestsetmilestoneprojectpath"></a>`projectPath` | [`ID!`](#id) | ミューテーション対象のマージリクエストが属するプロジェクト。 |

#### フィールド {#fields-298}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetmilestoneclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestsetmilestoneerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationmergerequestsetmilestonemergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | ミューテーション後のマージリクエスト。 |

### `Mutation.mergeRequestSetReviewers` {#mutationmergerequestsetreviewers}

入力型: `MergeRequestSetReviewersInput`

#### 引数 {#arguments-394}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetreviewersclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestsetreviewersiid"></a>`iid` | [`String!`](#string) | ミューテーション対象のマージリクエストのIID。 |
| <a id="mutationmergerequestsetreviewersoperationmode"></a>`operationMode` | [`MutationOperationMode`](#mutationoperationmode) | 実行する操作。デフォルトはREPLACEです。 |
| <a id="mutationmergerequestsetreviewersprojectpath"></a>`projectPath` | [`ID!`](#id) | ミューテーション対象のマージリクエストが属するプロジェクト。 |
| <a id="mutationmergerequestsetreviewersreviewerusernames"></a>`reviewerUsernames` | [`[String!]!`](#string) | 割り当てるレビュアーのユーザー名。デフォルトでは、既存のレビュー担当者を置き換えます。 |

#### フィールド {#fields-299}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetreviewersclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestsetreviewerserrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationmergerequestsetreviewersmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | ミューテーション後のマージリクエスト。 |

### `Mutation.mergeRequestSetSubscription` {#mutationmergerequestsetsubscription}

入力型: `MergeRequestSetSubscriptionInput`

#### 引数 {#arguments-395}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetsubscriptionclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestsetsubscriptioniid"></a>`iid` | [`String!`](#string) | ミューテーション対象のマージリクエストのIID。 |
| <a id="mutationmergerequestsetsubscriptionprojectpath"></a>`projectPath` | [`ID!`](#id) | ミューテーション対象のマージリクエストが属するプロジェクト。 |
| <a id="mutationmergerequestsetsubscriptionsubscribedstate"></a>`subscribedState` | [`Boolean!`](#boolean) | サブスクリプションの望ましい状態。 |

#### フィールド {#fields-300}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetsubscriptionclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestsetsubscriptionerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationmergerequestsetsubscriptionmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | ミューテーション後のマージリクエスト。 |

### `Mutation.mergeRequestUpdate` {#mutationmergerequestupdate}

マージリクエストの属性を更新します。

入力型: `MergeRequestUpdateInput`

#### 引数 {#arguments-396}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestupdatedescription"></a>`description` | [`String`](#string) | マージリクエストの説明（Markdownをキャッシュ用にHTMLとしてレンダリング）。 |
| <a id="mutationmergerequestupdateiid"></a>`iid` | [`String!`](#string) | ミューテーション対象のマージリクエストのIID。 |
| <a id="mutationmergerequestupdatemergeafter"></a>`mergeAfter` | [`Time`](#time) | マージリクエストをマージできようになる日付。 |
| <a id="mutationmergerequestupdateoverriderequestedchanges"></a>`overrideRequestedChanges` | [`Boolean`](#boolean) | リクエストされた変更をすべてオーバーライドします。このマージリクエストをマージする権限を付与されたユーザーのみが設定できます。 |
| <a id="mutationmergerequestupdateprojectpath"></a>`projectPath` | [`ID!`](#id) | ミューテーション対象のマージリクエストが属するプロジェクト。 |
| <a id="mutationmergerequestupdateremovesourcebranch"></a>`removeSourceBranch` | [`Boolean`](#boolean) | マージ後にマージリクエストのソースブランチを削除するかどうかを示します。 |
| <a id="mutationmergerequestupdatestate"></a>`state` | [`MergeRequestNewState`](#mergerequestnewstate) | 状態を変更するために実行するアクション。 |
| <a id="mutationmergerequestupdatetargetbranch"></a>`targetBranch` | [`String`](#string) | マージリクエストのターゲットブランチ。 |
| <a id="mutationmergerequestupdatetimeestimate"></a>`timeEstimate` | [`String`](#string) | マージリクエストを完了するまでの推定時間。`null`または`0`を使用すると、現在の推定値が削除されます。 |
| <a id="mutationmergerequestupdatetitle"></a>`title` | [`String`](#string) | マージリクエストのタイトル。 |

#### フィールド {#fields-301}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationmergerequestupdatemergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | ミューテーション後のマージリクエスト。 |

### `Mutation.mergeRequestUpdateApprovalRule` {#mutationmergerequestupdateapprovalrule}

入力型: `MergeRequestUpdateApprovalRuleInput`

#### 引数 {#arguments-397}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestupdateapprovalruleapprovalruleid"></a>`approvalRuleId` | [`Int!`](#int) | 承認ルールのID。 |
| <a id="mutationmergerequestupdateapprovalruleapprovalsrequired"></a>`approvalsRequired` | [`Int!`](#int) | 特定のルールに必要な承認数。 |
| <a id="mutationmergerequestupdateapprovalruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestupdateapprovalrulegroupids"></a>`groupIds` | [`[String!]`](#string) | 承認者としてのグループのID。 |
| <a id="mutationmergerequestupdateapprovalruleiid"></a>`iid` | [`String!`](#string) | ミューテーション対象のマージリクエストのIID。 |
| <a id="mutationmergerequestupdateapprovalrulename"></a>`name` | [`String!`](#string) | 承認ルールの名前。 |
| <a id="mutationmergerequestupdateapprovalruleprojectpath"></a>`projectPath` | [`ID!`](#id) | ミューテーション対象のマージリクエストが属するプロジェクト。 |
| <a id="mutationmergerequestupdateapprovalruleremovehiddengroups"></a>`removeHiddenGroups` | [`Boolean`](#boolean) | 非表示のグループを削除するかどうか。 |
| <a id="mutationmergerequestupdateapprovalruleuserids"></a>`userIds` | [`[String!]`](#string) | 承認者としてのユーザーのID。 |

#### フィールド {#fields-302}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestupdateapprovalruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmergerequestupdateapprovalruleerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationmergerequestupdateapprovalrulemergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | ミューテーション後のマージリクエスト。 |

### `Mutation.mergeTrainsDeleteCar` {#mutationmergetrainsdeletecar}

{{< details >}}GitLab 17.2で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `MergeTrainsDeleteCarInput`

#### 引数 {#arguments-398}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergetrainsdeletecarcarid"></a>`carId` | [`MergeTrainsCarID!`](#mergetrainscarid) | 車両のグローバルID。 |
| <a id="mutationmergetrainsdeletecarclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |

#### フィールド {#fields-303}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmergetrainsdeletecarclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmergetrainsdeletecarerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.mlModelCreate` {#mutationmlmodelcreate}

{{< details >}}GitLab 16.8で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `MlModelCreateInput`

#### 引数 {#arguments-399}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmlmodelcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmlmodelcreatedescription"></a>`description` | [`String`](#string) | モデルの説明。 |
| <a id="mutationmlmodelcreatename"></a>`name` | [`String!`](#string) | モデルの名前。 |
| <a id="mutationmlmodelcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | ミューテーション対象のモデルが属するプロジェクト。 |

#### フィールド {#fields-304}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmlmodelcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmlmodelcreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationmlmodelcreatemodel"></a>`model` | [`MlModel`](#mlmodel) | ミューテーション後のモデル。 |

### `Mutation.mlModelDelete` {#mutationmlmodeldelete}

{{< details >}} GitLab 17.0で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `MlModelDeleteInput`

#### 引数 {#arguments-400}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmlmodeldeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmlmodeldeleteid"></a>`id` | [`MlModelID!`](#mlmodelid) | 削除するモデルのグローバルID。 |
| <a id="mutationmlmodeldeleteprojectpath"></a>`projectPath` | [`ID!`](#id) | ミューテーション対象のモデルが属するプロジェクト。 |

#### フィールド {#fields-305}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmlmodeldeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmlmodeldeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationmlmodeldeletemodel"></a>`model` | [`MlModel`](#mlmodel) | ミューテーション後のモデル。 |

### `Mutation.mlModelDestroy` {#mutationmlmodeldestroy}

{{< details >}}GitLab 16.10で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `MlModelDestroyInput`

#### 引数 {#arguments-401}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmlmodeldestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmlmodeldestroyid"></a>`id` | [`MlModelID!`](#mlmodelid) | 削除するモデルのグローバルID。 |
| <a id="mutationmlmodeldestroyprojectpath"></a>`projectPath` | [`ID!`](#id) | ミューテーション対象のモデルが属するプロジェクト。 |

#### フィールド {#fields-306}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmlmodeldestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmlmodeldestroyerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationmlmodeldestroymessage"></a>`message` | [`String`](#string) | モデル削除の結果メッセージ。 |
| <a id="mutationmlmodeldestroymodel"></a>`model` | [`MlModel`](#mlmodel) | ミューテーション後のモデル。 |

### `Mutation.mlModelEdit` {#mutationmlmodeledit}

{{< details >}}GitLab 17.3で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `MlModelEditInput`

#### 引数 {#arguments-402}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmlmodeleditclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmlmodeleditdescription"></a>`description` | [`String`](#string) | モデルの説明。 |
| <a id="mutationmlmodeleditmodelid"></a>`modelId` | [`Int`](#int) | モデルのID。 |
| <a id="mutationmlmodeleditname"></a>`name` | [`String!`](#string) | モデルの名前。 |
| <a id="mutationmlmodeleditprojectpath"></a>`projectPath` | [`ID!`](#id) | ミューテーション対象のモデルが属するプロジェクト。 |

#### フィールド {#fields-307}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmlmodeleditclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmlmodelediterrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationmlmodeleditmodel"></a>`model` | [`MlModel`](#mlmodel) | ミューテーション後のモデル。 |

### `Mutation.mlModelVersionCreate` {#mutationmlmodelversioncreate}

{{< details >}}GitLab 17.1で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `MlModelVersionCreateInput`

#### 引数 {#arguments-403}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmlmodelversioncreatecandidateid"></a>`candidateId` | [`MlCandidateID`](#mlcandidateid) | 必要に応じてプロモートする候補のグローバルID。 |
| <a id="mutationmlmodelversioncreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmlmodelversioncreatedescription"></a>`description` | [`String`](#string) | モデルバージョンの説明。 |
| <a id="mutationmlmodelversioncreatemodelid"></a>`modelId` | [`MlModelID!`](#mlmodelid) | バージョンが属するモデルのグローバルID。 |
| <a id="mutationmlmodelversioncreateprojectpath"></a>`projectPath` | [`ID!`](#id) | ミューテーション対象のモデルが属するプロジェクト。 |
| <a id="mutationmlmodelversioncreateversion"></a>`version` | [`String`](#string) | モデルバージョン。 |

#### フィールド {#fields-308}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmlmodelversioncreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmlmodelversioncreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationmlmodelversioncreatemodelversion"></a>`modelVersion` | [`MlModelVersion`](#mlmodelversion) | ミューテーション後のモデル。 |

### `Mutation.mlModelVersionDelete` {#mutationmlmodelversiondelete}

{{< details >}} GitLab 17.0で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `MlModelVersionDeleteInput`

#### 引数 {#arguments-404}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmlmodelversiondeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmlmodelversiondeleteid"></a>`id` | [`MlModelVersionID!`](#mlmodelversionid) | 削除するモデルバージョンのグローバルID。 |

#### フィールド {#fields-309}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmlmodelversiondeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmlmodelversiondeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationmlmodelversiondeletemodelversion"></a>`modelVersion` | [`MlModelVersion`](#mlmodelversion) | 削除されたモデルバージョン。 |

### `Mutation.mlModelVersionEdit` {#mutationmlmodelversionedit}

{{< details >}}GitLab 17.4で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `MlModelVersionEditInput`

#### 引数 {#arguments-405}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmlmodelversioneditclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmlmodelversioneditdescription"></a>`description` | [`String!`](#string) | モデルバージョンの説明。 |
| <a id="mutationmlmodelversioneditmodelid"></a>`modelId` | [`MlModelID!`](#mlmodelid) | バージョンが属するモデルのグローバルID。 |
| <a id="mutationmlmodelversioneditprojectpath"></a>`projectPath` | [`ID!`](#id) | ミューテーション対象のモデルが属するプロジェクト。 |
| <a id="mutationmlmodelversioneditversion"></a>`version` | [`String!`](#string) | モデルバージョン。 |

#### フィールド {#fields-310}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationmlmodelversioneditclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationmlmodelversionediterrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationmlmodelversioneditmodelversion"></a>`modelVersion` | [`MlModelVersion`](#mlmodelversion) | ミューテーション後のモデル。 |

### `Mutation.namespaceBanDestroy` {#mutationnamespacebandestroy}

入力型: `NamespaceBanDestroyInput`

#### 引数 {#arguments-406}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationnamespacebandestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationnamespacebandestroyid"></a>`id` | [`NamespacesNamespaceBanID!`](#namespacesnamespacebanid) | 削除するネームスペースBANのグローバルID。 |

#### フィールド {#fields-311}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationnamespacebandestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationnamespacebandestroyerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationnamespacebandestroynamespaceban"></a>`namespaceBan` | [`NamespaceBan`](#namespaceban) | ネームスペースBAN。 |

### `Mutation.namespaceCiCdSettingsUpdate` {#mutationnamespacecicdsettingsupdate}

入力型: `NamespaceCiCdSettingsUpdateInput`

#### 引数 {#arguments-407}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationnamespacecicdsettingsupdateallowstalerunnerpruning"></a>`allowStaleRunnerPruning` | [`Boolean`](#boolean) | ネームスペースに直接属する、ステータスが停滞状態のRunnerを定期的にプルーニングするかどうかを示します。 |
| <a id="mutationnamespacecicdsettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationnamespacecicdsettingsupdatefullpath"></a>`fullPath` | [`ID!`](#id) | 設定が属するネームスペースのフルパス。 |

#### フィールド {#fields-312}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationnamespacecicdsettingsupdatecicdsettings"></a>`ciCdSettings` | [`NamespaceCiCdSetting!`](#namespacecicdsetting) | ミューテーション後のCI/CD設定。 |
| <a id="mutationnamespacecicdsettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationnamespacecicdsettingsupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.namespaceCreateRemoteDevelopmentClusterAgentMapping` {#mutationnamespacecreateremotedevelopmentclusteragentmapping}

入力型: `NamespaceCreateRemoteDevelopmentClusterAgentMappingInput`

#### 引数 {#arguments-408}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationnamespacecreateremotedevelopmentclusteragentmappingclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationnamespacecreateremotedevelopmentclusteragentmappingclusteragentid"></a>`clusterAgentId` | [`ClustersAgentID!`](#clustersagentid) | ネームスペースに関連付けるクラスターエージェントのGlobalID。 |
| <a id="mutationnamespacecreateremotedevelopmentclusteragentmappingnamespaceid"></a>`namespaceId` | [`NamespaceID!`](#namespaceid) | クラスターエージェントに関連付けるネームスペースのGlobalID。 |

#### フィールド {#fields-313}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationnamespacecreateremotedevelopmentclusteragentmappingclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationnamespacecreateremotedevelopmentclusteragentmappingerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationnamespacecreateremotedevelopmentclusteragentmappingnamespaceclusteragentmapping"></a>`namespaceClusterAgentMapping` {{< icon name="warning-solid" >}} | [`NamespaceClusterAgentMapping`](#namespaceclusteragentmapping) | **非推奨**: **状態**: 実験的機能。GitLab 17.10で導入されました。 |

### `Mutation.namespaceDeleteRemoteDevelopmentClusterAgentMapping` {#mutationnamespacedeleteremotedevelopmentclusteragentmapping}

入力型: `NamespaceDeleteRemoteDevelopmentClusterAgentMappingInput`

#### 引数 {#arguments-409}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationnamespacedeleteremotedevelopmentclusteragentmappingclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationnamespacedeleteremotedevelopmentclusteragentmappingclusteragentid"></a>`clusterAgentId` | [`ClustersAgentID!`](#clustersagentid) | ネームスペースからの関連付けを解除するクラスターエージェントのGlobalID。 |
| <a id="mutationnamespacedeleteremotedevelopmentclusteragentmappingnamespaceid"></a>`namespaceId` | [`NamespaceID!`](#namespaceid) | クラスターエージェントからの関連付けを解除するネームスペースのGlobalID。 |

#### フィールド {#fields-314}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationnamespacedeleteremotedevelopmentclusteragentmappingclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationnamespacedeleteremotedevelopmentclusteragentmappingerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationnamespacedeleteremotedevelopmentclusteragentmappingnamespaceclusteragentmapping"></a>`namespaceClusterAgentMapping` {{< icon name="warning-solid" >}} | [`NamespaceClusterAgentMapping`](#namespaceclusteragentmapping) | **非推奨**: **状態**: 実験的機能。GitLab 17.11で導入されました。 |

### `Mutation.namespaceSettingsUpdate` {#mutationnamespacesettingsupdate}

{{< details >}}GitLab 17.9で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `NamespaceSettingsUpdateInput`

#### 引数 {#arguments-410}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationnamespacesettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationnamespacesettingsupdatefullpath"></a>`fullPath` | [`ID!`](#id) | 設定が属するネームスペースのフルパス。 |
| <a id="mutationnamespacesettingsupdatepipelinevariablesdefaultrole"></a>`pipelineVariablesDefaultRole` | [`PipelineVariablesDefaultRoleType`](#pipelinevariablesdefaultroletype) | ネームスペース内のパイプライン変数をオーバーライドするために必要なデフォルトの最小ロールを示します。 |

#### フィールド {#fields-315}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationnamespacesettingsupdatecicdsettings"></a>`ciCdSettings` | [`CiCdSettings!`](#cicdsettings) | ミューテーション後のネームスペースCI/CD設定。 |
| <a id="mutationnamespacesettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationnamespacesettingsupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.namespacesRegenerateNewWorkItemEmailAddress` {#mutationnamespacesregeneratenewworkitememailaddress}

{{< details >}}GitLab 18.2で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `NamespacesRegenerateNewWorkItemEmailAddressInput`

#### 引数 {#arguments-411}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationnamespacesregeneratenewworkitememailaddressclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationnamespacesregeneratenewworkitememailaddressfullpath"></a>`fullPath` | [`ID!`](#id) | 新しい作業項目のメールアドレスを再生成するネームスペースのフルパス。 |

#### フィールド {#fields-316}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationnamespacesregeneratenewworkitememailaddressclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationnamespacesregeneratenewworkitememailaddresserrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationnamespacesregeneratenewworkitememailaddressnamespace"></a>`namespace` | [`Namespace`](#namespace) | 新しい作業項目のメールアドレスを再生成した後のネームスペース。 |

### `Mutation.noteConvertToThread` {#mutationnoteconverttothread}

標準のコメントを解決可能なスレッドに変換します。

入力型: `NoteConvertToThreadInput`

#### 引数 {#arguments-412}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationnoteconverttothreadclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationnoteconverttothreadid"></a>`id` | [`NoteID!`](#noteid) | 変換するノートのグローバルID。 |

#### フィールド {#fields-317}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationnoteconverttothreadclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationnoteconverttothreaderrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationnoteconverttothreadnote"></a>`note` | [`Note`](#note) | ミューテーション後のノート。 |
| <a id="mutationnoteconverttothreadquickactionsstatus"></a>`quickActionsStatus` | [`QuickActionsStatus`](#quickactionsstatus) | ミューテーション後のクイックアクションのステータス。 |

### `Mutation.oncallRotationCreate` {#mutationoncallrotationcreate}

入力型: `OncallRotationCreateInput`

#### 引数 {#arguments-413}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationoncallrotationcreateactiveperiod"></a>`activePeriod` | [`OncallRotationActivePeriodInputType`](#oncallrotationactiveperiodinputtype) | オンコールローテーションが発生するアクティブ期間。 |
| <a id="mutationoncallrotationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationoncallrotationcreateendsat"></a>`endsAt` | [`OncallRotationDateInputType`](#oncallrotationdateinputtype) | オンコールローテーションの終了日時（オンコールスケジュールのタイムゾーン）。 |
| <a id="mutationoncallrotationcreatename"></a>`name` | [`String!`](#string) | オンコールローテーションの名前。 |
| <a id="mutationoncallrotationcreateparticipants"></a>`participants` | [`[OncallUserInputType!]!`](#oncalluserinputtype) | オンコールローテーションに参加しているユーザーのユーザー名。参加者は最大100名です。 |
| <a id="mutationoncallrotationcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | オンコールスケジュールを作成するプロジェクト。 |
| <a id="mutationoncallrotationcreaterotationlength"></a>`rotationLength` | [`OncallRotationLengthInputType!`](#oncallrotationlengthinputtype) | オンコールローテーションのローテーション長。 |
| <a id="mutationoncallrotationcreatescheduleiid"></a>`scheduleIid` | [`String!`](#string) | オンコールローテーションを作成するオンコールスケジュールのIID。 |
| <a id="mutationoncallrotationcreatestartsat"></a>`startsAt` | [`OncallRotationDateInputType!`](#oncallrotationdateinputtype) | オンコールローテーションの開始日時（オンコールスケジュールのタイムゾーン）。 |

#### フィールド {#fields-318}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationoncallrotationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationoncallrotationcreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationoncallrotationcreateoncallrotation"></a>`oncallRotation` | [`IncidentManagementOncallRotation`](#incidentmanagementoncallrotation) | オンコールローテーション。 |

### `Mutation.oncallRotationDestroy` {#mutationoncallrotationdestroy}

入力型: `OncallRotationDestroyInput`

#### 引数 {#arguments-414}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationoncallrotationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationoncallrotationdestroyid"></a>`id` | [`IncidentManagementOncallRotationID!`](#incidentmanagementoncallrotationid) | 削除するオンコールローテーションのID。 |
| <a id="mutationoncallrotationdestroyprojectpath"></a>`projectPath` | [`ID!`](#id) | オンコールスケジュールの削除元プロジェクト。 |
| <a id="mutationoncallrotationdestroyscheduleiid"></a>`scheduleIid` | [`String!`](#string) | オンコールローテーションが属するオンコールスケジュールのIID。 |

#### フィールド {#fields-319}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationoncallrotationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationoncallrotationdestroyerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationoncallrotationdestroyoncallrotation"></a>`oncallRotation` | [`IncidentManagementOncallRotation`](#incidentmanagementoncallrotation) | オンコールローテーション。 |

### `Mutation.oncallRotationUpdate` {#mutationoncallrotationupdate}

入力型: `OncallRotationUpdateInput`

#### 引数 {#arguments-415}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationoncallrotationupdateactiveperiod"></a>`activePeriod` | [`OncallRotationActivePeriodInputType`](#oncallrotationactiveperiodinputtype) | オンコールローテーションが発生するアクティブ期間。 |
| <a id="mutationoncallrotationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationoncallrotationupdateendsat"></a>`endsAt` | [`OncallRotationDateInputType`](#oncallrotationdateinputtype) | オンコールローテーションの終了日時（オンコールスケジュールのタイムゾーン）。 |
| <a id="mutationoncallrotationupdateid"></a>`id` | [`IncidentManagementOncallRotationID!`](#incidentmanagementoncallrotationid) | オンコールローテーションを作成するオンコールスケジュールのID。 |
| <a id="mutationoncallrotationupdatename"></a>`name` | [`String`](#string) | オンコールローテーションの名前。 |
| <a id="mutationoncallrotationupdateparticipants"></a>`participants` | [`[OncallUserInputType!]`](#oncalluserinputtype) | オンコールローテーションに参加しているユーザーのユーザー名。参加者は最大100名です。 |
| <a id="mutationoncallrotationupdaterotationlength"></a>`rotationLength` | [`OncallRotationLengthInputType`](#oncallrotationlengthinputtype) | オンコールローテーションのローテーション長。 |
| <a id="mutationoncallrotationupdatestartsat"></a>`startsAt` | [`OncallRotationDateInputType`](#oncallrotationdateinputtype) | オンコールローテーションの開始日時（オンコールスケジュールのタイムゾーン）。 |

#### フィールド {#fields-320}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationoncallrotationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationoncallrotationupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationoncallrotationupdateoncallrotation"></a>`oncallRotation` | [`IncidentManagementOncallRotation`](#incidentmanagementoncallrotation) | オンコールローテーション。 |

### `Mutation.oncallScheduleCreate` {#mutationoncallschedulecreate}

入力型: `OncallScheduleCreateInput`

#### 引数 {#arguments-416}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationoncallschedulecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationoncallschedulecreatedescription"></a>`description` | [`String`](#string) | オンコールスケジュールの説明。 |
| <a id="mutationoncallschedulecreatename"></a>`name` | [`String!`](#string) | オンコールスケジュールの名前。 |
| <a id="mutationoncallschedulecreateprojectpath"></a>`projectPath` | [`ID!`](#id) | オンコールスケジュールを作成するプロジェクト。 |
| <a id="mutationoncallschedulecreatetimezone"></a>`timezone` | [`String!`](#string) | オンコールスケジュールのタイムゾーン。 |

#### フィールド {#fields-321}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationoncallschedulecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationoncallschedulecreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationoncallschedulecreateoncallschedule"></a>`oncallSchedule` | [`IncidentManagementOncallSchedule`](#incidentmanagementoncallschedule) | オンコールスケジュール。 |

### `Mutation.oncallScheduleDestroy` {#mutationoncallscheduledestroy}

入力型: `OncallScheduleDestroyInput`

#### 引数 {#arguments-417}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationoncallscheduledestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationoncallscheduledestroyiid"></a>`iid` | [`String!`](#string) | 削除するオンコールスケジュールの内部ID。 |
| <a id="mutationoncallscheduledestroyprojectpath"></a>`projectPath` | [`ID!`](#id) | オンコールスケジュールの削除元プロジェクト。 |

#### フィールド {#fields-322}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationoncallscheduledestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationoncallscheduledestroyerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationoncallscheduledestroyoncallschedule"></a>`oncallSchedule` | [`IncidentManagementOncallSchedule`](#incidentmanagementoncallschedule) | オンコールスケジュール。 |

### `Mutation.oncallScheduleUpdate` {#mutationoncallscheduleupdate}

入力型: `OncallScheduleUpdateInput`

#### 引数 {#arguments-418}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationoncallscheduleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationoncallscheduleupdatedescription"></a>`description` | [`String`](#string) | オンコールスケジュールの説明。 |
| <a id="mutationoncallscheduleupdateiid"></a>`iid` | [`String!`](#string) | 更新するオンコールスケジュールの内部ID。 |
| <a id="mutationoncallscheduleupdatename"></a>`name` | [`String`](#string) | オンコールスケジュールの名前。 |
| <a id="mutationoncallscheduleupdateprojectpath"></a>`projectPath` | [`ID!`](#id) | オンコールスケジュールを更新するプロジェクト。 |
| <a id="mutationoncallscheduleupdatetimezone"></a>`timezone` | [`String`](#string) | オンコールスケジュールのタイムゾーン。 |

#### フィールド {#fields-323}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationoncallscheduleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationoncallscheduleupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationoncallscheduleupdateoncallschedule"></a>`oncallSchedule` | [`IncidentManagementOncallSchedule`](#incidentmanagementoncallschedule) | オンコールスケジュール。 |

### `Mutation.organizationCreate` {#mutationorganizationcreate}

{{< details >}} GitLab 16.6で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `OrganizationCreateInput`

#### 引数 {#arguments-419}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationorganizationcreateavatar"></a>`avatar` | [`Upload`](#upload) | 組織のアバター。 |
| <a id="mutationorganizationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationorganizationcreatedescription"></a>`description` | [`String`](#string) | 組織の説明。 |
| <a id="mutationorganizationcreatename"></a>`name` | [`String!`](#string) | 組織の名前。 |
| <a id="mutationorganizationcreatepath"></a>`path` | [`String!`](#string) | 組織のパス。 |

#### フィールド {#fields-324}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationorganizationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationorganizationcreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationorganizationcreateorganization"></a>`organization` | [`Organization`](#organization) | ミューテーション後の組織。 |

### `Mutation.organizationCreateClusterAgentMapping` {#mutationorganizationcreateclusteragentmapping}

{{< details >}} GitLab 17.11で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `OrganizationCreateClusterAgentMappingInput`

#### 引数 {#arguments-420}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationorganizationcreateclusteragentmappingclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationorganizationcreateclusteragentmappingclusteragentid"></a>`clusterAgentId` | [`ClustersAgentID!`](#clustersagentid) | 組織に関連付けるクラスターエージェントのGlobalID。 |
| <a id="mutationorganizationcreateclusteragentmappingorganizationid"></a>`organizationId` | [`OrganizationsOrganizationID!`](#organizationsorganizationid) | クラスターエージェントに関連付ける組織のGlobalID。 |

#### フィールド {#fields-325}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationorganizationcreateclusteragentmappingclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationorganizationcreateclusteragentmappingerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.organizationDeleteClusterAgentMapping` {#mutationorganizationdeleteclusteragentmapping}

{{< details >}} GitLab 17.11で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `OrganizationDeleteClusterAgentMappingInput`

#### 引数 {#arguments-421}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationorganizationdeleteclusteragentmappingclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationorganizationdeleteclusteragentmappingclusteragentid"></a>`clusterAgentId` | [`ClustersAgentID!`](#clustersagentid) | 組織との関連付けを解除するクラスターエージェントのGlobalID。 |
| <a id="mutationorganizationdeleteclusteragentmappingorganizationid"></a>`organizationId` | [`OrganizationsOrganizationID!`](#organizationsorganizationid) | クラスターエージェントとの関連付けを解除する組織のGlobalID。 |

#### フィールド {#fields-326}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationorganizationdeleteclusteragentmappingclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationorganizationdeleteclusteragentmappingerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.organizationUpdate` {#mutationorganizationupdate}

{{< details >}} GitLab 16.7で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `OrganizationUpdateInput`

#### 引数 {#arguments-422}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationorganizationupdateavatar"></a>`avatar` | [`Upload`](#upload) | 組織のアバター。 |
| <a id="mutationorganizationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationorganizationupdatedescription"></a>`description` | [`String`](#string) | 組織の説明。 |
| <a id="mutationorganizationupdateid"></a>`id` | [`OrganizationsOrganizationID!`](#organizationsorganizationid) | ミューテーション対象の組織のID。 |
| <a id="mutationorganizationupdatename"></a>`name` | [`String`](#string) | 組織の名前。 |
| <a id="mutationorganizationupdatepath"></a>`path` | [`String`](#string) | 組織のパス。 |

#### フィールド {#fields-327}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationorganizationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationorganizationupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationorganizationupdateorganization"></a>`organization` | [`Organization`](#organization) | ミューテーション後の組織。 |

### `Mutation.organizationUserUpdate` {#mutationorganizationuserupdate}

{{< details >}}GitLab 17.5で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `OrganizationUserUpdateInput`

#### 引数 {#arguments-423}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationorganizationuserupdateaccesslevel"></a>`accessLevel` | [`OrganizationUserAccessLevel!`](#organizationuseraccesslevel) | 更新後の組織ユーザーのアクセスレベル。 |
| <a id="mutationorganizationuserupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationorganizationuserupdateid"></a>`id` | [`OrganizationsOrganizationUserID!`](#organizationsorganizationuserid) | ミューテーション対象の組織ユーザーのID。 |

#### フィールド {#fields-328}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationorganizationuserupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationorganizationuserupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationorganizationuserupdateorganizationuser"></a>`organizationUser` {{< icon name="warning-solid" >}} | [`OrganizationUser`](#organizationuser) | **非推奨**: **状態**: 実験的機能。GitLab 17.5で導入されました。 |

### `Mutation.pagesMarkOnboardingComplete` {#mutationpagesmarkonboardingcomplete}

入力型: `PagesMarkOnboardingCompleteInput`

#### 引数 {#arguments-424}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpagesmarkonboardingcompleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationpagesmarkonboardingcompleteprojectpath"></a>`projectPath` | [`ID!`](#id) | プロジェクトのフルパス。 |

#### フィールド {#fields-329}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpagesmarkonboardingcompleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationpagesmarkonboardingcompleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationpagesmarkonboardingcompleteonboardingcomplete"></a>`onboardingComplete` | [`Boolean!`](#boolean) | プロジェクトのPagesメタデータの新しいonboarding_complete状態を示します。 |

### `Mutation.pipelineCancel` {#mutationpipelinecancel}

入力型: `PipelineCancelInput`

#### 引数 {#arguments-425}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelinecancelclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationpipelinecancelid"></a>`id` | [`CiPipelineID!`](#cipipelineid) | ミューテーション対象のパイプラインのID。 |

#### フィールド {#fields-330}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelinecancelclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationpipelinecancelerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.pipelineCreate` {#mutationpipelinecreate}

入力型: `PipelineCreateInput`

#### 引数 {#arguments-426}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelinecreateasync"></a>`async` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | **非推奨**: **状態**: 実験的機能。GitLab 17.8で導入されました。 |
| <a id="mutationpipelinecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationpipelinecreateinputs"></a>`inputs` {{< icon name="warning-solid" >}} | [`[CiInputsInput!]`](#ciinputsinput) | **非推奨**: **状態**: 実験的機能。GitLab 17.10で導入されました。 |
| <a id="mutationpipelinecreateprojectpath"></a>`projectPath` | [`ID!`](#id) | パイプラインをトリガーしているプロジェクトのフルパス。 |
| <a id="mutationpipelinecreateref"></a>`ref` | [`String!`](#string) | パイプラインを実行するref。 |
| <a id="mutationpipelinecreatevariables"></a>`variables` | [`[CiVariableInput!]`](#civariableinput) | パイプラインの変数。 |

#### フィールド {#fields-331}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelinecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationpipelinecreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationpipelinecreatepipeline"></a>`pipeline` | [`Pipeline`](#pipeline) | ミューテーション後に作成されたパイプライン。`async: true`の場合はnull。 |
| <a id="mutationpipelinecreaterequestid"></a>`requestId` {{< icon name="warning-solid" >}} | [`String`](#string) | **非推奨**: **状態**: 実験的機能。GitLab 17.8で導入されました。 |

### `Mutation.pipelineDestroy` {#mutationpipelinedestroy}

入力型: `PipelineDestroyInput`

#### 引数 {#arguments-427}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelinedestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationpipelinedestroyid"></a>`id` | [`CiPipelineID!`](#cipipelineid) | ミューテーション対象のパイプラインのID。 |

#### フィールド {#fields-332}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelinedestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationpipelinedestroyerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.pipelineRetry` {#mutationpipelineretry}

入力型: `PipelineRetryInput`

#### 引数 {#arguments-428}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelineretryclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationpipelineretryid"></a>`id` | [`CiPipelineID!`](#cipipelineid) | ミューテーション対象のパイプラインのID。 |

#### フィールド {#fields-333}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelineretryclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationpipelineretryerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationpipelineretrypipeline"></a>`pipeline` | [`Pipeline`](#pipeline) | ミューテーション後のパイプライン。 |

### `Mutation.pipelineScheduleCreate` {#mutationpipelineschedulecreate}

入力型: `PipelineScheduleCreateInput`

#### 引数 {#arguments-429}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelineschedulecreateactive"></a>`active` | [`Boolean`](#boolean) | パイプラインスケジュールをアクティブにするかどうかを示します。 |
| <a id="mutationpipelineschedulecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationpipelineschedulecreatecron"></a>`cron` | [`String!`](#string) | パイプラインスケジュールのcron式。 |
| <a id="mutationpipelineschedulecreatecrontimezone"></a>`cronTimezone` | [`String`](#string) | ActiveSupport::TimeZoneでサポートされているcronタイムゾーン。次に例を示します。「Pacific Time（US & Canada）」（デフォルト: 「UTC」）。 |
| <a id="mutationpipelineschedulecreatedescription"></a>`description` | [`String!`](#string) | パイプラインスケジュールの説明。 |
| <a id="mutationpipelineschedulecreateinputs"></a>`inputs` {{< icon name="warning-solid" >}} | [`[CiInputsInput!]`](#ciinputsinput) | **非推奨**: **状態**: 実験的機能。GitLab 17.10で導入されました。 |
| <a id="mutationpipelineschedulecreateprojectpath"></a>`projectPath` | [`ID!`](#id) | パイプラインスケジュールが関連付けられているプロジェクトのフルパス。 |
| <a id="mutationpipelineschedulecreateref"></a>`ref` | [`String!`](#string) | パイプラインスケジュールのref。 |
| <a id="mutationpipelineschedulecreatevariables"></a>`variables` | [`[PipelineScheduleVariableInput!]`](#pipelineschedulevariableinput) | パイプラインスケジュールの変数。 |

#### フィールド {#fields-334}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelineschedulecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationpipelineschedulecreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationpipelineschedulecreatepipelineschedule"></a>`pipelineSchedule` | [`PipelineSchedule`](#pipelineschedule) | 作成されたパイプラインスケジュール。 |

### `Mutation.pipelineScheduleDelete` {#mutationpipelinescheduledelete}

入力型: `PipelineScheduleDeleteInput`

#### 引数 {#arguments-430}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelinescheduledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationpipelinescheduledeleteid"></a>`id` | [`CiPipelineScheduleID!`](#cipipelinescheduleid) | ミューテーション対象のパイプラインスケジュールのID。 |

#### フィールド {#fields-335}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelinescheduledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationpipelinescheduledeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.pipelineSchedulePlay` {#mutationpipelinescheduleplay}

入力型: `PipelineSchedulePlayInput`

#### 引数 {#arguments-431}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelinescheduleplayclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationpipelinescheduleplayid"></a>`id` | [`CiPipelineScheduleID!`](#cipipelinescheduleid) | ミューテーション対象のパイプラインスケジュールのID。 |

#### フィールド {#fields-336}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelinescheduleplayclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationpipelinescheduleplayerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationpipelinescheduleplaypipelineschedule"></a>`pipelineSchedule` | [`PipelineSchedule`](#pipelineschedule) | ミューテーション後のパイプラインスケジュール。 |

### `Mutation.pipelineScheduleTakeOwnership` {#mutationpipelinescheduletakeownership}

入力型: `PipelineScheduleTakeOwnershipInput`

#### 引数 {#arguments-432}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelinescheduletakeownershipclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationpipelinescheduletakeownershipid"></a>`id` | [`CiPipelineScheduleID!`](#cipipelinescheduleid) | ミューテーション対象のパイプラインスケジュールのID。 |

#### フィールド {#fields-337}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelinescheduletakeownershipclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationpipelinescheduletakeownershiperrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationpipelinescheduletakeownershippipelineschedule"></a>`pipelineSchedule` | [`PipelineSchedule`](#pipelineschedule) | 更新されたパイプラインスケジュールの所有権。 |

### `Mutation.pipelineScheduleUpdate` {#mutationpipelinescheduleupdate}

入力型: `PipelineScheduleUpdateInput`

#### 引数 {#arguments-433}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelinescheduleupdateactive"></a>`active` | [`Boolean`](#boolean) | パイプラインスケジュールをアクティブにするかどうかを示します。 |
| <a id="mutationpipelinescheduleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationpipelinescheduleupdatecron"></a>`cron` | [`String`](#string) | パイプラインスケジュールのcron式。 |
| <a id="mutationpipelinescheduleupdatecrontimezone"></a>`cronTimezone` | [`String`](#string) | ActiveSupport::TimeZoneでサポートされているcronタイムゾーン。次に例を示します。「Pacific Time（US & Canada）」（デフォルト: 「UTC」）。 |
| <a id="mutationpipelinescheduleupdatedescription"></a>`description` | [`String`](#string) | パイプラインスケジュールの説明。 |
| <a id="mutationpipelinescheduleupdateid"></a>`id` | [`CiPipelineScheduleID!`](#cipipelinescheduleid) | ミューテーション対象のパイプラインスケジュールのID。 |
| <a id="mutationpipelinescheduleupdateinputs"></a>`inputs` {{< icon name="warning-solid" >}} | [`[CiInputsInput!]`](#ciinputsinput) | **非推奨**: **状態**: 実験的機能。GitLab 17.11で導入されました。 |
| <a id="mutationpipelinescheduleupdateref"></a>`ref` | [`String`](#string) | パイプラインスケジュールのref。 |
| <a id="mutationpipelinescheduleupdatevariables"></a>`variables` | [`[PipelineScheduleVariableInput!]`](#pipelineschedulevariableinput) | パイプラインスケジュールの変数。 |

#### フィールド {#fields-338}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelinescheduleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationpipelinescheduleupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationpipelinescheduleupdatepipelineschedule"></a>`pipelineSchedule` | [`PipelineSchedule`](#pipelineschedule) | 更新されたパイプラインスケジュール。 |

### `Mutation.pipelineTriggerCreate` {#mutationpipelinetriggercreate}

{{< details >}}GitLab 16.3で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `PipelineTriggerCreateInput`

#### 引数 {#arguments-434}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelinetriggercreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationpipelinetriggercreatedescription"></a>`description` | [`String!`](#string) | パイプライントリガートークンの説明。 |
| <a id="mutationpipelinetriggercreateexpiresat"></a>`expiresAt` | [`Time`](#time) | パイプライントリガートークンの有効期限のタイムスタンプ。 |
| <a id="mutationpipelinetriggercreateprojectpath"></a>`projectPath` | [`ID!`](#id) | ミューテーション対象のパイプライントリガートークンが属するプロジェクトのフルパス。 |

#### フィールド {#fields-339}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelinetriggercreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationpipelinetriggercreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationpipelinetriggercreatepipelinetrigger"></a>`pipelineTrigger` | [`PipelineTrigger`](#pipelinetrigger) | ミューテーション後のパイプライントリガートークン。 |

### `Mutation.pipelineTriggerDelete` {#mutationpipelinetriggerdelete}

{{< details >}}GitLab 16.3で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `PipelineTriggerDeleteInput`

#### 引数 {#arguments-435}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelinetriggerdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationpipelinetriggerdeleteid"></a>`id` | [`CiTriggerID!`](#citriggerid) | 削除するパイプライントリガートークンのID。 |

#### フィールド {#fields-340}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelinetriggerdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationpipelinetriggerdeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.pipelineTriggerUpdate` {#mutationpipelinetriggerupdate}

{{< details >}}GitLab 16.3で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `PipelineTriggerUpdateInput`

#### 引数 {#arguments-436}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelinetriggerupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationpipelinetriggerupdatedescription"></a>`description` | [`String!`](#string) | パイプライントリガートークンの説明。 |
| <a id="mutationpipelinetriggerupdateid"></a>`id` | [`CiTriggerID!`](#citriggerid) | 更新するパイプライントリガートークンのID。 |

#### フィールド {#fields-341}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpipelinetriggerupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationpipelinetriggerupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationpipelinetriggerupdatepipelinetrigger"></a>`pipelineTrigger` | [`PipelineTrigger`](#pipelinetrigger) | ミューテーション後のパイプライントリガートークン。 |

### `Mutation.processUserBillablePromotionRequest` {#mutationprocessuserbillablepromotionrequest}

{{< details >}}GitLab 17.2で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `ProcessUserBillablePromotionRequestInput`

#### 引数 {#arguments-437}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprocessuserbillablepromotionrequestclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprocessuserbillablepromotionrequeststatus"></a>`status` | [`MemberApprovalStatusType!`](#memberapprovalstatustype) | メンバー承認リクエストのステータス（承認、却下、保留中）。 |
| <a id="mutationprocessuserbillablepromotionrequestuserid"></a>`userId` | [`UserID!`](#userid) | プロモートするユーザーのグローバルID。 |

#### フィールド {#fields-342}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprocessuserbillablepromotionrequestclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprocessuserbillablepromotionrequesterrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationprocessuserbillablepromotionrequestresult"></a>`result` | [`UserPromotionStatusType`](#userpromotionstatustype) | ユーザープロモーション処理のステータス（SUCCESS、PARTIAL_SUCCESS、FAILED）。 |

### `Mutation.productAnalyticsProjectSettingsUpdate` {#mutationproductanalyticsprojectsettingsupdate}

入力型: `ProductAnalyticsProjectSettingsUpdateInput`

#### 引数 {#arguments-438}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationproductanalyticsprojectsettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationproductanalyticsprojectsettingsupdatecubeapibaseurl"></a>`cubeApiBaseUrl` | [`String`](#string) | Cube APIのベースURL。 |
| <a id="mutationproductanalyticsprojectsettingsupdatecubeapikey"></a>`cubeApiKey` | [`String`](#string) | Cube APIのAPIキー。 |
| <a id="mutationproductanalyticsprojectsettingsupdatefullpath"></a>`fullPath` | [`ID!`](#id) | 設定が属するプロジェクトのフルパス。 |
| <a id="mutationproductanalyticsprojectsettingsupdateproductanalyticsconfiguratorconnectionstring"></a>`productAnalyticsConfiguratorConnectionString` | [`String`](#string) | プロダクト分析コンフィギュレーターの接続文字列。 |
| <a id="mutationproductanalyticsprojectsettingsupdateproductanalyticsdatacollectorhost"></a>`productAnalyticsDataCollectorHost` | [`String`](#string) | プロダクト分析データコレクターのホスト。 |

#### フィールド {#fields-343}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationproductanalyticsprojectsettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationproductanalyticsprojectsettingsupdatecubeapibaseurl"></a>`cubeApiBaseUrl` | [`String`](#string) | Cube APIのベースURL。 |
| <a id="mutationproductanalyticsprojectsettingsupdatecubeapikey"></a>`cubeApiKey` | [`String`](#string) | Cube APIのAPIキー。 |
| <a id="mutationproductanalyticsprojectsettingsupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationproductanalyticsprojectsettingsupdateproductanalyticsconfiguratorconnectionstring"></a>`productAnalyticsConfiguratorConnectionString` | [`String`](#string) | プロダクト分析コンフィギュレーターの接続文字列。 |
| <a id="mutationproductanalyticsprojectsettingsupdateproductanalyticsdatacollectorhost"></a>`productAnalyticsDataCollectorHost` | [`String`](#string) | プロダクト分析データコレクターのホスト。 |

### `Mutation.projectBlobsRemove` {#mutationprojectblobsremove}

{{< details >}}GitLab 17.1で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `projectBlobsRemoveInput`

#### 引数 {#arguments-439}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectblobsremovebloboids"></a>`blobOids` | [`[String!]!`](#string) | blob oidのリスト。 |
| <a id="mutationprojectblobsremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojectblobsremoveprojectpath"></a>`projectPath` | [`ID!`](#id) | 置き換えるプロジェクトのフルパス。 |

#### フィールド {#fields-344}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectblobsremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojectblobsremoveerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.projectCiCdSettingsUpdate` {#mutationprojectcicdsettingsupdate}

入力型: `ProjectCiCdSettingsUpdateInput`

#### 引数 {#arguments-440}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectcicdsettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojectcicdsettingsupdatedisplaypipelinevariables"></a>`displayPipelineVariables` | [`Boolean`](#boolean) | パイプライン変数をUIに表示できるかどうかを示します。 |
| <a id="mutationprojectcicdsettingsupdatefullpath"></a>`fullPath` | [`ID!`](#id) | 設定が属するプロジェクトのフルパス。 |
| <a id="mutationprojectcicdsettingsupdategrouprunnersenabled"></a>`groupRunnersEnabled` | [`Boolean`](#boolean) | グループRunnerがプロジェクトで有効になっているかどうかを示します。 |
| <a id="mutationprojectcicdsettingsupdateinboundjobtokenscopeenabled"></a>`inboundJobTokenScopeEnabled` | [`Boolean`](#boolean) | このプロジェクトへのアクセスが、他のプロジェクトで生成されたCI/CDジョブトークンによって制限されているかどうかを示します。 |
| <a id="mutationprojectcicdsettingsupdatejobtokenscopeenabled"></a>`jobTokenScopeEnabled` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | **非推奨**: 送信ジョブトークンスコープは削除されます。このフィールドで可能な設定値はfalseだけになりました。GitLab 16.0で非推奨になりました。 |
| <a id="mutationprojectcicdsettingsupdatekeeplatestartifact"></a>`keepLatestArtifact` | [`Boolean`](#boolean) | プロジェクトで最新のアーティファクトを保持する必要があるかどうかを示します。 |
| <a id="mutationprojectcicdsettingsupdatemergepipelinesenabled"></a>`mergePipelinesEnabled` | [`Boolean`](#boolean) | プロジェクトでマージ結果パイプラインが有効になっているかどうかを示します。 |
| <a id="mutationprojectcicdsettingsupdatemergetrainsenabled"></a>`mergeTrainsEnabled` | [`Boolean`](#boolean) | プロジェクトでマージトレインが有効になっているかどうかを示します。 |
| <a id="mutationprojectcicdsettingsupdatemergetrainsskiptrainallowed"></a>`mergeTrainsSkipTrainAllowed` | [`Boolean`](#boolean) | マージトレインを更新せずにマージできるオプションを許可するかどうかを示します。`merge_trains_skip_train`機能フラグも有効になっているのでなければ、無視されます。 |
| <a id="mutationprojectcicdsettingsupdatepipelinevariablesminimumoverriderole"></a>`pipelineVariablesMinimumOverrideRole` | [`String`](#string) | パイプラインの作成時、またはジョブの実行時に変数を設定するために必要な最小ロール。 |
| <a id="mutationprojectcicdsettingsupdatepushrepositoryforjobtokenallowed"></a>`pushRepositoryForJobTokenAllowed` | [`Boolean`](#boolean) | ジョブトークンを使用して、元のプロジェクトリポジトリにプッシュできるかどうかを示します。 |
| <a id="mutationprojectcicdsettingsupdateresourcegroupdefaultprocessmode"></a>`resourceGroupDefaultProcessMode` | [`ResourceGroupsProcessMode`](#resourcegroupsprocessmode) | プロジェクト内のリソースグループのデフォルトの処理モード。 |

#### フィールド {#fields-345}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectcicdsettingsupdatecicdsettings"></a>`ciCdSettings` | [`ProjectCiCdSetting!`](#projectcicdsetting) | ミューテーション後のCI/CD設定。 |
| <a id="mutationprojectcicdsettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojectcicdsettingsupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.projectInitializeProductAnalytics` {#mutationprojectinitializeproductanalytics}

入力型: `ProjectInitializeProductAnalyticsInput`

#### 引数 {#arguments-441}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectinitializeproductanalyticsclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojectinitializeproductanalyticsprojectpath"></a>`projectPath` | [`ID!`](#id) | 初期化するプロジェクトのフルパス。 |

#### フィールド {#fields-346}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectinitializeproductanalyticsclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojectinitializeproductanalyticserrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationprojectinitializeproductanalyticsproject"></a>`project` | [`Project`](#project) | 初期化が実行されたプロジェクト。 |

### `Mutation.projectMemberBulkUpdate` {#mutationprojectmemberbulkupdate}

プロジェクトの複数のメンバーを更新します。このミューテーションを使用するには、少なくともメンテナーの役割が必要です。

入力型: `ProjectMemberBulkUpdateInput`

#### 引数 {#arguments-442}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectmemberbulkupdateaccesslevel"></a>`accessLevel` | [`MemberAccessLevel!`](#memberaccesslevel) | メンバーの更新後アクセスレベル。 |
| <a id="mutationprojectmemberbulkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojectmemberbulkupdateexpiresat"></a>`expiresAt` | [`Time`](#time) | メンバーシップの有効期限が切れる日時。 |
| <a id="mutationprojectmemberbulkupdateprojectid"></a>`projectId` | [`ProjectID!`](#projectid) | プロジェクトのグローバルID。 |
| <a id="mutationprojectmemberbulkupdateuserids"></a>`userIds` | [`[UserID!]!`](#userid) | メンバーのグローバルID。 |

#### フィールド {#fields-347}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectmemberbulkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojectmemberbulkupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationprojectmemberbulkupdateprojectmembers"></a>`projectMembers` | [`[ProjectMember!]`](#projectmember) | ミューテーション後のプロジェクトメンバー。 |

### `Mutation.projectSavedReplyCreate` {#mutationprojectsavedreplycreate}

{{< details >}}GitLab 16.11で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `ProjectSavedReplyCreateInput`

#### 引数 {#arguments-443}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsavedreplycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsavedreplycreatecontent"></a>`content` | [`String!`](#string) | 保存済み返信の内容。 |
| <a id="mutationprojectsavedreplycreatename"></a>`name` | [`String!`](#string) | 保存済み返信の名前。 |
| <a id="mutationprojectsavedreplycreateprojectid"></a>`projectId` | [`ProjectID!`](#projectid) | 保存済み返信のプロジェクト。 |

#### フィールド {#fields-348}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsavedreplycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsavedreplycreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationprojectsavedreplycreatesavedreply"></a>`savedReply` | [`ProjectSavedReply`](#projectsavedreply) | ミューテーション後の保存済み返信。 |

### `Mutation.projectSavedReplyDestroy` {#mutationprojectsavedreplydestroy}

{{< details >}}GitLab 16.11で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `ProjectSavedReplyDestroyInput`

#### 引数 {#arguments-444}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsavedreplydestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsavedreplydestroyid"></a>`id` | [`ProjectsSavedReplyID!`](#projectssavedreplyid) | プロジェクトレベルの保存済み返信のグローバルID。 |

#### フィールド {#fields-349}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsavedreplydestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsavedreplydestroyerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationprojectsavedreplydestroysavedreply"></a>`savedReply` | [`ProjectSavedReply`](#projectsavedreply) | ミューテーション後の保存済み返信。 |

### `Mutation.projectSavedReplyUpdate` {#mutationprojectsavedreplyupdate}

{{< details >}}GitLab 16.11で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `ProjectSavedReplyUpdateInput`

#### 引数 {#arguments-445}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsavedreplyupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsavedreplyupdatecontent"></a>`content` | [`String!`](#string) | 保存済み返信の内容。 |
| <a id="mutationprojectsavedreplyupdateid"></a>`id` | [`ProjectsSavedReplyID!`](#projectssavedreplyid) | プロジェクトレベルの保存済み返信のグローバルID。 |
| <a id="mutationprojectsavedreplyupdatename"></a>`name` | [`String!`](#string) | 保存済み返信の名前。 |

#### フィールド {#fields-350}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsavedreplyupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsavedreplyupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationprojectsavedreplyupdatesavedreply"></a>`savedReply` | [`ProjectSavedReply`](#projectsavedreply) | ミューテーション後の保存済み返信。 |

### `Mutation.projectSecretCreate` {#mutationprojectsecretcreate}

入力型: `ProjectSecretCreateInput`

#### 引数 {#arguments-446}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsecretcreatebranch"></a>`branch` | [`String!`](#string) | シークレットにアクセスできるブランチ。 |
| <a id="mutationprojectsecretcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsecretcreatedescription"></a>`description` | [`String`](#string) | プロジェクトシークレットの説明。 |
| <a id="mutationprojectsecretcreateenvironment"></a>`environment` | [`String!`](#string) | シークレットにアクセスできる環境。 |
| <a id="mutationprojectsecretcreatename"></a>`name` | [`String!`](#string) | プロジェクトシークレットの名前。 |
| <a id="mutationprojectsecretcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | シークレットのプロジェクト。 |
| <a id="mutationprojectsecretcreaterotationintervaldays"></a>`rotationIntervalDays` | [`Int`](#int) | シークレットのローテーションのリマインダーの間隔 (日数)。 |
| <a id="mutationprojectsecretcreatesecret"></a>`secret` | [`String!`](#string) | プロジェクトシークレットの値。 |

#### フィールド {#fields-351}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsecretcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsecretcreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationprojectsecretcreateprojectsecret"></a>`projectSecret` | [`ProjectSecret`](#projectsecret) | プロジェクトシークレット。 |

### `Mutation.projectSecretDelete` {#mutationprojectsecretdelete}

入力型: `ProjectSecretDeleteInput`

#### 引数 {#arguments-447}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsecretdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsecretdeletename"></a>`name` | [`String!`](#string) | プロジェクトシークレットの名前。 |
| <a id="mutationprojectsecretdeleteprojectpath"></a>`projectPath` | [`ID!`](#id) | シークレットのプロジェクト。 |

#### フィールド {#fields-352}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsecretdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsecretdeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationprojectsecretdeleteprojectsecret"></a>`projectSecret` | [`ProjectSecret`](#projectsecret) | 削除されたプロジェクトシークレット。 |

### `Mutation.projectSecretUpdate` {#mutationprojectsecretupdate}

入力型: `ProjectSecretUpdateInput`

#### 引数 {#arguments-448}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsecretupdatebranch"></a>`branch` | [`String`](#string) | シークレットにアクセスできるブランチ。 |
| <a id="mutationprojectsecretupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsecretupdatedescription"></a>`description` | [`String`](#string) | プロジェクトシークレットの新しい説明。 |
| <a id="mutationprojectsecretupdateenvironment"></a>`environment` | [`String`](#string) | シークレットにアクセスできる新しい環境。 |
| <a id="mutationprojectsecretupdatemetadatacas"></a>`metadataCas` | [`Int!`](#int) | これは、更新されるプロジェクトシークレットの現在のメタデータバージョンと一致する必要があります。 |
| <a id="mutationprojectsecretupdatename"></a>`name` | [`String!`](#string) | 更新するプロジェクトシークレットの名前。 |
| <a id="mutationprojectsecretupdateprojectpath"></a>`projectPath` | [`ID!`](#id) | シークレットのプロジェクト。 |
| <a id="mutationprojectsecretupdaterotationintervaldays"></a>`rotationIntervalDays` | [`Int`](#int) | シークレットのローテーションのリマインダーの間隔 (日数)。 |
| <a id="mutationprojectsecretupdatesecret"></a>`secret` | [`String`](#string) | プロジェクトシークレットの新しい値。 |

#### フィールド {#fields-353}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsecretupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsecretupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationprojectsecretupdateprojectsecret"></a>`projectSecret` | [`ProjectSecret`](#projectsecret) | 更新されたプロジェクトシークレット。 |

### `Mutation.projectSecretsManagerDeprovision` {#mutationprojectsecretsmanagerdeprovision}

入力型: `ProjectSecretsManagerDeprovisionInput`

#### 引数 {#arguments-449}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsecretsmanagerdeprovisionclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsecretsmanagerdeprovisionprojectpath"></a>`projectPath` | [`ID!`](#id) | シークレットマネージャーのプロジェクト。 |

#### フィールド {#fields-354}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsecretsmanagerdeprovisionclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsecretsmanagerdeprovisionerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationprojectsecretsmanagerdeprovisionprojectsecretsmanager"></a>`projectSecretsManager` | [`ProjectSecretsManager`](#projectsecretsmanager) | プロジェクトシークレットマネージャー。 |

### `Mutation.projectSecretsManagerInitialize` {#mutationprojectsecretsmanagerinitialize}

入力型: `ProjectSecretsManagerInitializeInput`

#### 引数 {#arguments-450}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsecretsmanagerinitializeclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsecretsmanagerinitializeprojectpath"></a>`projectPath` | [`ID!`](#id) | シークレットマネージャーのプロジェクト。 |

#### フィールド {#fields-355}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsecretsmanagerinitializeclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsecretsmanagerinitializeerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationprojectsecretsmanagerinitializeprojectsecretsmanager"></a>`projectSecretsManager` | [`ProjectSecretsManager`](#projectsecretsmanager) | プロジェクトシークレットマネージャー。 |

### `Mutation.projectSecurityExclusionCreate` {#mutationprojectsecurityexclusioncreate}

入力型: `ProjectSecurityExclusionCreateInput`

#### 引数 {#arguments-451}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsecurityexclusioncreateactive"></a>`active` | [`Boolean!`](#boolean) | 除外がアクティブかどうか。 |
| <a id="mutationprojectsecurityexclusioncreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsecurityexclusioncreatedescription"></a>`description` | [`String`](#string) | （オプション）除外の説明。 |
| <a id="mutationprojectsecurityexclusioncreateprojectpath"></a>`projectPath` | [`ID!`](#id) | 除外が関連付けられるプロジェクトのフルパス。 |
| <a id="mutationprojectsecurityexclusioncreatescanner"></a>`scanner` | [`ExclusionScannerEnum!`](#exclusionscannerenum) | 除外に基づいて値を無視するスキャナー。 |
| <a id="mutationprojectsecurityexclusioncreatetype"></a>`type` | [`ExclusionTypeEnum!`](#exclusiontypeenum) | 除外のタイプ。 |
| <a id="mutationprojectsecurityexclusioncreatevalue"></a>`value` | [`String!`](#string) | 除外の値。 |

#### フィールド {#fields-356}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsecurityexclusioncreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsecurityexclusioncreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationprojectsecurityexclusioncreatesecurityexclusion"></a>`securityExclusion` | [`ProjectSecurityExclusion`](#projectsecurityexclusion) | 作成されたプロジェクトセキュリティ除外。 |

### `Mutation.projectSecurityExclusionDelete` {#mutationprojectsecurityexclusiondelete}

入力型: `ProjectSecurityExclusionDeleteInput`

#### 引数 {#arguments-452}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsecurityexclusiondeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsecurityexclusiondeleteid"></a>`id` | [`SecurityProjectSecurityExclusionID!`](#securityprojectsecurityexclusionid) | 削除する除外のグローバルID。 |

#### フィールド {#fields-357}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsecurityexclusiondeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsecurityexclusiondeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.projectSecurityExclusionUpdate` {#mutationprojectsecurityexclusionupdate}

入力型: `ProjectSecurityExclusionUpdateInput`

#### 引数 {#arguments-453}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsecurityexclusionupdateactive"></a>`active` | [`Boolean`](#boolean) | 除外がアクティブかどうか。 |
| <a id="mutationprojectsecurityexclusionupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsecurityexclusionupdatedescription"></a>`description` | [`String`](#string) | （オプション）除外の説明。 |
| <a id="mutationprojectsecurityexclusionupdateid"></a>`id` | [`SecurityProjectSecurityExclusionID!`](#securityprojectsecurityexclusionid) | 更新する除外のグローバルID。 |
| <a id="mutationprojectsecurityexclusionupdatescanner"></a>`scanner` | [`ExclusionScannerEnum`](#exclusionscannerenum) | 除外に基づいて値を無視するスキャナー。 |
| <a id="mutationprojectsecurityexclusionupdatetype"></a>`type` | [`ExclusionTypeEnum`](#exclusiontypeenum) | 除外のタイプ。 |
| <a id="mutationprojectsecurityexclusionupdatevalue"></a>`value` | [`String`](#string) | 除外の値。 |

#### フィールド {#fields-358}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsecurityexclusionupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsecurityexclusionupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationprojectsecurityexclusionupdatesecurityexclusion"></a>`securityExclusion` | [`ProjectSecurityExclusion`](#projectsecurityexclusion) | 更新されたプロジェクトセキュリティ除外。 |

### `Mutation.projectSetComplianceFramework` {#mutationprojectsetcomplianceframework}

{{< details >}}GitLab 17.11で**非推奨**になりました。代わりに、mutation ProjectUpdateComplianceFrameworksを使用してください。{{< /details >}}

プロジェクトにコンプライアンスフレームワークを割り当てる（または設定解除する）。プロジェクトに複数のコンプライアンスフレームワークが関連付けられている場合、このミューテーションはエラーになります。

入力型: `ProjectSetComplianceFrameworkInput`

#### 引数 {#arguments-454}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsetcomplianceframeworkclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsetcomplianceframeworkcomplianceframeworkid"></a>`complianceFrameworkId` | [`ComplianceManagementFrameworkID`](#compliancemanagementframeworkid) | プロジェクトに割り当てるコンプライアンスフレームワークのID。`null`に設定すると、設定が解除されます。 |
| <a id="mutationprojectsetcomplianceframeworkprojectid"></a>`projectId` | [`ProjectID!`](#projectid) | コンプライアンスフレームワークを変更するプロジェクトのID。 |

#### フィールド {#fields-359}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsetcomplianceframeworkclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsetcomplianceframeworkerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationprojectsetcomplianceframeworkproject"></a>`project` | [`Project`](#project) | ミューテーション後のプロジェクト。 |

### `Mutation.projectSetContinuousVulnerabilityScanning` {#mutationprojectsetcontinuousvulnerabilityscanning}

{{< details >}}GitLab 17.3で**非推奨**になりました。CVSが永続的に有効になりました。詳細については、[このエピック](https://gitlab.com/groups/gitlab-org/-/epics/11474)を参照してください。{{< /details >}}

指定されたプロジェクトの継続的脆弱性スキャンを有効または無効にします。

入力型: `ProjectSetContinuousVulnerabilityScanningInput`

#### 引数 {#arguments-455}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsetcontinuousvulnerabilityscanningclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsetcontinuousvulnerabilityscanningenable"></a>`enable` | [`Boolean!`](#boolean) | 目的となる継続的脆弱性スキャン機能のステータス。 |
| <a id="mutationprojectsetcontinuousvulnerabilityscanningprojectpath"></a>`projectPath` | [`ID!`](#id) | プロジェクトのフルパス。 |

#### フィールド {#fields-360}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsetcontinuousvulnerabilityscanningclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsetcontinuousvulnerabilityscanningcontinuousvulnerabilityscanningenabled"></a>`continuousVulnerabilityScanningEnabled` | [`Boolean!`](#boolean) | 機能が有効かどうか。 |
| <a id="mutationprojectsetcontinuousvulnerabilityscanningerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.projectSetLocked` {#mutationprojectsetlocked}

入力型: `ProjectSetLockedInput`

#### 引数 {#arguments-456}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsetlockedclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsetlockedfilepath"></a>`filePath` | [`String!`](#string) | ファイルへのフルパス。 |
| <a id="mutationprojectsetlockedlock"></a>`lock` | [`Boolean!`](#boolean) | ファイルパスをロックするかどうか。 |
| <a id="mutationprojectsetlockedprojectpath"></a>`projectPath` | [`ID!`](#id) | ミューテーション対象のプロジェクトのフルパス。 |

#### フィールド {#fields-361}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsetlockedclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsetlockederrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationprojectsetlockedproject"></a>`project` | [`Project`](#project) | ミューテーション後のプロジェクト。 |

### `Mutation.projectSettingsUpdate` {#mutationprojectsettingsupdate}

{{< details >}}GitLab 16.9で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `ProjectSettingsUpdateInput`

#### 引数 {#arguments-457}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsettingsupdateduocontextexclusionsettings"></a>`duoContextExclusionSettings` | [`DuoContextExclusionSettingsInput`](#duocontextexclusionsettingsinput) | GitLab Duoコンテキストからファイルを除外するための設定。 |
| <a id="mutationprojectsettingsupdateduofeaturesenabled"></a>`duoFeaturesEnabled` | [`Boolean`](#boolean) | プロジェクトでGitLab Duo機能が有効かどうかを示します。 |
| <a id="mutationprojectsettingsupdatefullpath"></a>`fullPath` | [`ID!`](#id) | 設定が属するプロジェクトのフルパス。 |
| <a id="mutationprojectsettingsupdatewebbasedcommitsigningenabled"></a>`webBasedCommitSigningEnabled` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | **非推奨**: **状態**: 実験的機能。GitLab 18.2で導入されました。 |

#### フィールド {#fields-362}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsettingsupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationprojectsettingsupdateprojectsettings"></a>`projectSettings` | [`ProjectSetting!`](#projectsetting) | ミューテーション後のプロジェクト設定。 |

### `Mutation.projectSubscriptionCreate` {#mutationprojectsubscriptioncreate}

入力型: `ProjectSubscriptionCreateInput`

#### 引数 {#arguments-458}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsubscriptioncreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsubscriptioncreateprojectpath"></a>`projectPath` | [`String!`](#string) | プロジェクトサブスクリプションのダウンストリームプロジェクトのフルパス。 |
| <a id="mutationprojectsubscriptioncreateupstreampath"></a>`upstreamPath` | [`String!`](#string) | プロジェクトサブスクリプションのアップストリームプロジェクトのフルパス。 |

#### フィールド {#fields-363}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsubscriptioncreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsubscriptioncreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationprojectsubscriptioncreatesubscription"></a>`subscription` | [`CiSubscriptionsProject`](#cisubscriptionsproject) | ミューテーションによって作成されたプロジェクトサブスクリプション。 |

### `Mutation.projectSubscriptionDelete` {#mutationprojectsubscriptiondelete}

入力型: `ProjectSubscriptionDeleteInput`

#### 引数 {#arguments-459}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsubscriptiondeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsubscriptiondeletesubscriptionid"></a>`subscriptionId` | [`CiSubscriptionsProjectID!`](#cisubscriptionsprojectid) | 削除するサブスクリプションのID。 |

#### フィールド {#fields-364}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsubscriptiondeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsubscriptiondeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationprojectsubscriptiondeleteproject"></a>`project` | [`Project`](#project) | ミューテーション後のプロジェクト。 |

### `Mutation.projectSyncFork` {#mutationprojectsyncfork}

{{< details >}} GitLab 15.9で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `ProjectSyncForkInput`

#### 引数 {#arguments-460}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsyncforkclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsyncforkprojectpath"></a>`projectPath` | [`ID!`](#id) | 初期化するプロジェクトのフルパス。 |
| <a id="mutationprojectsyncforktargetbranch"></a>`targetBranch` | [`String!`](#string) | フェッチ先フォークのref。 |

#### フィールド {#fields-365}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectsyncforkclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojectsyncforkdetails"></a>`details` | [`ForkDetails`](#forkdetails) | 更新されたフォークの詳細。 |
| <a id="mutationprojectsyncforkerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.projectTargetBranchRuleCreate` {#mutationprojecttargetbranchrulecreate}

入力型: `ProjectTargetBranchRuleCreateInput`

#### 引数 {#arguments-461}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojecttargetbranchrulecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojecttargetbranchrulecreatename"></a>`name` | [`String!`](#string) | ターゲットブランチルールの名前。 |
| <a id="mutationprojecttargetbranchrulecreateprojectid"></a>`projectId` | [`ProjectID!`](#projectid) | ターゲットブランチルールのプロジェクトID。 |
| <a id="mutationprojecttargetbranchrulecreatetargetbranch"></a>`targetBranch` | [`String!`](#string) | ターゲットブランチルールのターゲットブランチ。 |

#### フィールド {#fields-366}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojecttargetbranchrulecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojecttargetbranchrulecreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationprojecttargetbranchrulecreatetargetbranchrule"></a>`targetBranchRule` | [`ProjectTargetBranchRule`](#projecttargetbranchrule) | ミューテーション後のターゲットブランチルール。 |

### `Mutation.projectTargetBranchRuleDestroy` {#mutationprojecttargetbranchruledestroy}

入力型: `ProjectTargetBranchRuleDestroyInput`

#### 引数 {#arguments-462}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojecttargetbranchruledestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojecttargetbranchruledestroyid"></a>`id` | [`ProjectsTargetBranchRuleID!`](#projectstargetbranchruleid) | ターゲットブランチルールのID。 |

#### フィールド {#fields-367}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojecttargetbranchruledestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojecttargetbranchruledestroyerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.projectTextReplace` {#mutationprojecttextreplace}

{{< details >}}GitLab 17.1で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `projectTextReplaceInput`

#### 引数 {#arguments-463}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojecttextreplaceclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojecttextreplaceprojectpath"></a>`projectPath` | [`ID!`](#id) | 置き換えるプロジェクトのフルパス。 |
| <a id="mutationprojecttextreplacereplacements"></a>`replacements` | [`[String!]!`](#string) | プロジェクト全体で置換するテキストパターンのリスト。 |

#### フィールド {#fields-368}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojecttextreplaceclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojecttextreplaceerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.projectUpdateComplianceFrameworks` {#mutationprojectupdatecomplianceframeworks}

プロジェクトのコンプライアンスフレームワークを更新します。

入力型: `ProjectUpdateComplianceFrameworksInput`

#### 引数 {#arguments-464}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectupdatecomplianceframeworksclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojectupdatecomplianceframeworkscomplianceframeworkids"></a>`complianceFrameworkIds` | [`[ComplianceManagementFrameworkID!]!`](#compliancemanagementframeworkid) | プロジェクトで更新するコンプライアンスフレームワークのID。 |
| <a id="mutationprojectupdatecomplianceframeworksprojectid"></a>`projectId` | [`ProjectID!`](#projectid) | コンプライアンスフレームワークを変更するプロジェクトのID。 |

#### フィールド {#fields-369}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprojectupdatecomplianceframeworksclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprojectupdatecomplianceframeworkserrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationprojectupdatecomplianceframeworksproject"></a>`project` | [`Project`](#project) | ミューテーション後のプロジェクト。 |

### `Mutation.prometheusIntegrationCreate` {#mutationprometheusintegrationcreate}

{{< details >}}GitLab 18.2で**非推奨**になりました。HttpIntegrationCreateを使用します。{{< /details >}}

入力型: `PrometheusIntegrationCreateInput`

#### 引数 {#arguments-465}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprometheusintegrationcreateactive"></a>`active` | [`Boolean!`](#boolean) | インテグレーションがアラートを受信しているかどうか。 |
| <a id="mutationprometheusintegrationcreateapiurl"></a>`apiUrl` {{< icon name="warning-solid" >}} | [`String`](#string) | **非推奨**: この機能は16.0で削除されました。GitLab 18.2で非推奨になりました。 |
| <a id="mutationprometheusintegrationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprometheusintegrationcreatename"></a>`name` | [`String`](#string) | インテグレーションの名前。 |
| <a id="mutationprometheusintegrationcreatepayloadattributemappings"></a>`payloadAttributeMappings` | [`[AlertManagementPayloadAlertFieldInput!]`](#alertmanagementpayloadalertfieldinput) | GitLabアラート属性からペイロードの例に基づくフィールドへのカスタムマッピング。 |
| <a id="mutationprometheusintegrationcreatepayloadexample"></a>`payloadExample` | [`JsonString`](#jsonstring) | アラートペイロードの例。 |
| <a id="mutationprometheusintegrationcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | インテグレーションを作成するプロジェクト。 |
| <a id="mutationprometheusintegrationcreatetype"></a>`type` | [`AlertManagementIntegrationType`](#alertmanagementintegrationtype) | 作成するインテグレーションのタイプ。作成後は変更できません。 |

#### フィールド {#fields-370}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprometheusintegrationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprometheusintegrationcreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationprometheusintegrationcreateintegration"></a>`integration` | [`AlertManagementPrometheusIntegration`](#alertmanagementprometheusintegration) | 新たに作成されたインテグレーション。 |

### `Mutation.prometheusIntegrationResetToken` {#mutationprometheusintegrationresettoken}

{{< details >}}GitLab 18.2で**非推奨**になりました。HttpIntegrationResetTokenを使用します。{{< /details >}}

入力型: `PrometheusIntegrationResetTokenInput`

#### 引数 {#arguments-466}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprometheusintegrationresettokenclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprometheusintegrationresettokenid"></a>`id` | [`IntegrationsPrometheusID!`](#integrationsprometheusid) | ミューテーション対象のインテグレーションのID。 |

#### フィールド {#fields-371}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprometheusintegrationresettokenclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprometheusintegrationresettokenerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationprometheusintegrationresettokenintegration"></a>`integration` | [`AlertManagementPrometheusIntegration`](#alertmanagementprometheusintegration) | 更新されたインテグレーション。 |

### `Mutation.prometheusIntegrationUpdate` {#mutationprometheusintegrationupdate}

{{< details >}}GitLab 18.2で**非推奨**になりました。HttpIntegrationUpdateを使用します。{{< /details >}}

入力型: `PrometheusIntegrationUpdateInput`

#### 引数 {#arguments-467}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprometheusintegrationupdateactive"></a>`active` | [`Boolean`](#boolean) | インテグレーションがアラートを受信しているかどうか。 |
| <a id="mutationprometheusintegrationupdateapiurl"></a>`apiUrl` {{< icon name="warning-solid" >}} | [`String`](#string) | **非推奨**: この機能は16.0で削除されました。GitLab 18.2で非推奨になりました。 |
| <a id="mutationprometheusintegrationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprometheusintegrationupdateid"></a>`id` | [`IntegrationsPrometheusID!`](#integrationsprometheusid) | ミューテーション対象のインテグレーションのID。 |
| <a id="mutationprometheusintegrationupdatename"></a>`name` | [`String`](#string) | インテグレーションの名前。 |
| <a id="mutationprometheusintegrationupdatepayloadattributemappings"></a>`payloadAttributeMappings` | [`[AlertManagementPayloadAlertFieldInput!]`](#alertmanagementpayloadalertfieldinput) | GitLabアラート属性からペイロードの例に基づくフィールドへのカスタムマッピング。 |
| <a id="mutationprometheusintegrationupdatepayloadexample"></a>`payloadExample` | [`JsonString`](#jsonstring) | アラートペイロードの例。 |

#### フィールド {#fields-372}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationprometheusintegrationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationprometheusintegrationupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationprometheusintegrationupdateintegration"></a>`integration` | [`AlertManagementPrometheusIntegration`](#alertmanagementprometheusintegration) | 更新されたインテグレーション。 |

### `Mutation.promoteToEpic` {#mutationpromotetoepic}

{{< details >}}GitLab 17.5で**非推奨**になりました。`WorkItem`型に置き換えられました。詳細については、[移行ガイド](https://docs.gitlab.com/api/graphql/epic_work_items_api_migration_guide/)を参照してください。{{< /details >}}

入力型: `PromoteToEpicInput`

#### 引数 {#arguments-468}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpromotetoepicclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationpromotetoepicgrouppath"></a>`groupPath` | [`ID`](#id) | プロモート後のエピックが属するグループ。 |
| <a id="mutationpromotetoepiciid"></a>`iid` | [`String!`](#string) | ミューテーション対象のイシューのIID。 |
| <a id="mutationpromotetoepicprojectpath"></a>`projectPath` | [`ID!`](#id) | ミューテーション対象のイシューの属するプロジェクト。 |

#### フィールド {#fields-373}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationpromotetoepicclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationpromotetoepicepic"></a>`epic` | [`Epic`](#epic) | イシュープロモーション後のエピック。 |
| <a id="mutationpromotetoepicerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationpromotetoepicissue"></a>`issue` | [`Issue`](#issue) | ミューテーション後のイシュー。 |

### `Mutation.refreshFindingTokenStatus` {#mutationrefreshfindingtokenstatus}

入力型: `RefreshFindingTokenStatusInput`

#### 引数 {#arguments-469}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrefreshfindingtokenstatusclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationrefreshfindingtokenstatusvulnerabilityid"></a>`vulnerabilityId` | [`VulnerabilityID!`](#vulnerabilityid) | トークンの状態を更新する脆弱性のグローバルID。 |

#### フィールド {#fields-374}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrefreshfindingtokenstatusclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationrefreshfindingtokenstatuserrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationrefreshfindingtokenstatusfindingtokenstatus"></a>`findingTokenStatus` | [`VulnerabilityFindingTokenStatus`](#vulnerabilityfindingtokenstatus) | 指定された検出結果の更新されたトークンステータスレコード。 |

### `Mutation.refreshSecurityFindingTokenStatus` {#mutationrefreshsecurityfindingtokenstatus}

入力型: `RefreshSecurityFindingTokenStatusInput`

#### 引数 {#arguments-470}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrefreshsecurityfindingtokenstatusclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationrefreshsecurityfindingtokenstatussecurityfindinguuid"></a>`securityFindingUuid` | [`String!`](#string) | トークンのステータスを更新するSecurity::FindingのUUID（MRコンテキスト）。 |

#### フィールド {#fields-375}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrefreshsecurityfindingtokenstatusclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationrefreshsecurityfindingtokenstatuserrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationrefreshsecurityfindingtokenstatusfindingtokenstatus"></a>`findingTokenStatus` | [`SecurityFindingTokenStatus`](#securityfindingtokenstatus) | 指定されたSecurity::Findingの更新されたトークンステータスレコード。 |

### `Mutation.refreshStandardsAdherenceChecks` {#mutationrefreshstandardsadherencechecks}

入力型: `RefreshStandardsAdherenceChecksInput`

#### 引数 {#arguments-471}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrefreshstandardsadherencechecksclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationrefreshstandardsadherencechecksgrouppath"></a>`groupPath` | [`ID!`](#id) | グループパス。 |

#### フィールド {#fields-376}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrefreshstandardsadherencechecksadherencechecksstatus"></a>`adherenceChecksStatus` | [`StandardsAdherenceChecksStatus`](#standardsadherencechecksstatus) | 標準準拠チェックの進行状況。 |
| <a id="mutationrefreshstandardsadherencechecksclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationrefreshstandardsadherencecheckserrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.refreshVulnerabilityFindingTokenStatus` {#mutationrefreshvulnerabilityfindingtokenstatus}

入力型: `RefreshVulnerabilityFindingTokenStatusInput`

#### 引数 {#arguments-472}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrefreshvulnerabilityfindingtokenstatusclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationrefreshvulnerabilityfindingtokenstatusvulnerabilityid"></a>`vulnerabilityId` | [`VulnerabilityID!`](#vulnerabilityid) | トークンの状態を更新する脆弱性のグローバルID。 |

#### フィールド {#fields-377}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrefreshvulnerabilityfindingtokenstatusclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationrefreshvulnerabilityfindingtokenstatuserrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationrefreshvulnerabilityfindingtokenstatusfindingtokenstatus"></a>`findingTokenStatus` | [`VulnerabilityFindingTokenStatus`](#vulnerabilityfindingtokenstatus) | 指定されたVulnerabilities::Findingの更新されたトークンステータスレコード。 |

### `Mutation.releaseAssetLinkCreate` {#mutationreleaseassetlinkcreate}

入力型: `ReleaseAssetLinkCreateInput`

#### 引数 {#arguments-473}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationreleaseassetlinkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationreleaseassetlinkcreatedirectassetpath"></a>`directAssetPath` | [`String`](#string) | ダイレクトアセットリンクの相対パス。 |
| <a id="mutationreleaseassetlinkcreatelinktype"></a>`linkType` | [`ReleaseAssetLinkType`](#releaseassetlinktype) | アセットリンクのタイプ。 |
| <a id="mutationreleaseassetlinkcreatename"></a>`name` | [`String!`](#string) | アセットリンクの名前。 |
| <a id="mutationreleaseassetlinkcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | アセットリンクが関連付けられているプロジェクトのフルパス。 |
| <a id="mutationreleaseassetlinkcreatetagname"></a>`tagName` | [`String!`](#string) | 関連付けられているリリースのタグの名前。 |
| <a id="mutationreleaseassetlinkcreateurl"></a>`url` | [`String!`](#string) | アセットリンクのURL。 |

#### フィールド {#fields-378}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationreleaseassetlinkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationreleaseassetlinkcreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationreleaseassetlinkcreatelink"></a>`link` | [`ReleaseAssetLink`](#releaseassetlink) | ミューテーション後のアセットリンク。 |

### `Mutation.releaseAssetLinkDelete` {#mutationreleaseassetlinkdelete}

入力型: `ReleaseAssetLinkDeleteInput`

#### 引数 {#arguments-474}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationreleaseassetlinkdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationreleaseassetlinkdeleteid"></a>`id` | [`ReleasesLinkID!`](#releaseslinkid) | 削除するリリースアセットリンクのID。 |

#### フィールド {#fields-379}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationreleaseassetlinkdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationreleaseassetlinkdeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationreleaseassetlinkdeletelink"></a>`link` | [`ReleaseAssetLink`](#releaseassetlink) | 削除されたリリースアセットリンク。 |

### `Mutation.releaseAssetLinkUpdate` {#mutationreleaseassetlinkupdate}

入力型: `ReleaseAssetLinkUpdateInput`

#### 引数 {#arguments-475}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationreleaseassetlinkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationreleaseassetlinkupdatedirectassetpath"></a>`directAssetPath` | [`String`](#string) | ダイレクトアセットリンクの相対パス。 |
| <a id="mutationreleaseassetlinkupdateid"></a>`id` | [`ReleasesLinkID!`](#releaseslinkid) | 更新するリリースアセットリンクのID。 |
| <a id="mutationreleaseassetlinkupdatelinktype"></a>`linkType` | [`ReleaseAssetLinkType`](#releaseassetlinktype) | アセットリンクのタイプ。 |
| <a id="mutationreleaseassetlinkupdatename"></a>`name` | [`String`](#string) | アセットリンクの名前。 |
| <a id="mutationreleaseassetlinkupdateurl"></a>`url` | [`String`](#string) | アセットリンクのURL。 |

#### フィールド {#fields-380}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationreleaseassetlinkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationreleaseassetlinkupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationreleaseassetlinkupdatelink"></a>`link` | [`ReleaseAssetLink`](#releaseassetlink) | ミューテーション後のアセットリンク。 |

### `Mutation.releaseCreate` {#mutationreleasecreate}

入力型: `ReleaseCreateInput`

#### 引数 {#arguments-476}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationreleasecreateassets"></a>`assets` | [`ReleaseAssetsInput`](#releaseassetsinput) | リリースに関連付けられているアセット。 |
| <a id="mutationreleasecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationreleasecreatedescription"></a>`description` | [`String`](#string) | リリースの説明（「リリースノート」）。 |
| <a id="mutationreleasecreatemilestones"></a>`milestones` | [`[String!]`](#string) | リリースに関連付けられている各マイルストーンのタイトル。GitLab Premiumのお客様は、グループマイルストーンを指定できます。 |
| <a id="mutationreleasecreatename"></a>`name` | [`String`](#string) | リリースの名前。 |
| <a id="mutationreleasecreateprojectpath"></a>`projectPath` | [`ID!`](#id) | リリースが関連付けられているプロジェクトのフルパス。 |
| <a id="mutationreleasecreateref"></a>`ref` | [`String`](#string) | 新しいタグの作成時に使用するコミットSHAまたはブランチ名。 |
| <a id="mutationreleasecreatereleasedat"></a>`releasedAt` | [`Time`](#time) | リリースの日時。デフォルトは現在の時刻です。ISO 8601形式で指定します（`2019-03-15T08:00:00Z`）。このフィールドは、今後のリリースまたは過去のリリースを作成する場合のみ指定します。 |
| <a id="mutationreleasecreatetagmessage"></a>`tagMessage` | [`String`](#string) | 新しい注釈付きタグを作成する場合に使用するメッセージ。 |
| <a id="mutationreleasecreatetagname"></a>`tagName` | [`String!`](#string) | リリースに関連付けるタグの名前。 |

#### フィールド {#fields-381}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationreleasecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationreleasecreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationreleasecreaterelease"></a>`release` | [`Release`](#release) | ミューテーション後のリリース。 |

### `Mutation.releaseDelete` {#mutationreleasedelete}

入力型: `ReleaseDeleteInput`

#### 引数 {#arguments-477}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationreleasedeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationreleasedeleteprojectpath"></a>`projectPath` | [`ID!`](#id) | リリースが関連付けられているプロジェクトのフルパス。 |
| <a id="mutationreleasedeletetagname"></a>`tagName` | [`String!`](#string) | 削除するリリースに関連付けられているタグの名前。 |

#### フィールド {#fields-382}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationreleasedeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationreleasedeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationreleasedeleterelease"></a>`release` | [`Release`](#release) | 削除されたリリース。 |

### `Mutation.releaseUpdate` {#mutationreleaseupdate}

入力型: `ReleaseUpdateInput`

#### 引数 {#arguments-478}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationreleaseupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationreleaseupdatedescription"></a>`description` | [`String`](#string) | リリースの説明（リリースノート）。 |
| <a id="mutationreleaseupdatemilestones"></a>`milestones` | [`[String!]`](#string) | リリースに関連付けられている各マイルストーンのタイトル。GitLab Premiumのお客様は、グループマイルストーンを指定できます。 |
| <a id="mutationreleaseupdatename"></a>`name` | [`String`](#string) | リリースの名前。 |
| <a id="mutationreleaseupdateprojectpath"></a>`projectPath` | [`ID!`](#id) | リリースが関連付けられているプロジェクトのフルパス。 |
| <a id="mutationreleaseupdatereleasedat"></a>`releasedAt` | [`Time`](#time) | リリース日。 |
| <a id="mutationreleaseupdatetagname"></a>`tagName` | [`String!`](#string) | リリースに関連付けられているタグの名前。 |

#### フィールド {#fields-383}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationreleaseupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationreleaseupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationreleaseupdaterelease"></a>`release` | [`Release`](#release) | ミューテーション後のリリース。 |

### `Mutation.removeProjectFromSecurityDashboard` {#mutationremoveprojectfromsecuritydashboard}

入力型: `RemoveProjectFromSecurityDashboardInput`

#### 引数 {#arguments-479}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationremoveprojectfromsecuritydashboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationremoveprojectfromsecuritydashboardid"></a>`id` | [`ProjectID!`](#projectid) | インスタンスセキュリティダッシュボードから削除するプロジェクトのID。 |

#### フィールド {#fields-384}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationremoveprojectfromsecuritydashboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationremoveprojectfromsecuritydashboarderrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.repositionImageDiffNote` {#mutationrepositionimagediffnote}

イメージ上の差分ノート（`position.positionType`が`"image"`の場合の`Note`）の位置を変更します。

入力型: `RepositionImageDiffNoteInput`

#### 引数 {#arguments-480}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrepositionimagediffnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationrepositionimagediffnoteid"></a>`id` | [`DiffNoteID!`](#diffnoteid) | 更新する差分ノートのグローバルID。 |
| <a id="mutationrepositionimagediffnoteposition"></a>`position` | [`UpdateDiffImagePositionInput!`](#updatediffimagepositioninput) | 差分に関するノートの位置。 |

#### フィールド {#fields-385}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrepositionimagediffnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationrepositionimagediffnoteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationrepositionimagediffnotenote"></a>`note` | [`Note`](#note) | ミューテーション後のノート。 |
| <a id="mutationrepositionimagediffnotequickactionsstatus"></a>`quickActionsStatus` | [`QuickActionsStatus`](#quickactionsstatus) | ミューテーション後のクイックアクションのステータス。 |

### `Mutation.restorePagesDeployment` {#mutationrestorepagesdeployment}

{{< details >}}GitLab 17.1で**導入**されました。**状態**: 実験的機能。{{< /details >}}

削除がスケジュールされているPagesデプロイを復元します。

入力型: `RestorePagesDeploymentInput`

#### 引数 {#arguments-481}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrestorepagesdeploymentclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationrestorepagesdeploymentid"></a>`id` | [`PagesDeploymentID!`](#pagesdeploymentid) | PagesデプロイのID。 |

#### フィールド {#fields-386}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrestorepagesdeploymentclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationrestorepagesdeploymenterrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationrestorepagesdeploymentpagesdeployment"></a>`pagesDeployment` | [`PagesDeployment!`](#pagesdeployment) | 復元されたPagesデプロイ。 |

### `Mutation.resyncSecurityPolicies` {#mutationresyncsecuritypolicies}

{{< details >}}GitLab 18.1で**導入**されました。**状態**: 実験的機能。{{< /details >}}

指定されたプロジェクトまたはグループ（`full_path`）にリンクされているセキュリティポリシーの再同期をトリガーします。

入力型: `ResyncSecurityPoliciesInput`

#### 引数 {#arguments-482}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationresyncsecuritypoliciesclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationresyncsecuritypoliciesfullpath"></a>`fullPath` | [`String!`](#string) | プロジェクトまたはグループのフルパス。 |
| <a id="mutationresyncsecuritypoliciesrelationship"></a>`relationship` | [`RelationshipType`](#relationshiptype) | 再同期するポリシーの関係。 |

#### フィールド {#fields-387}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationresyncsecuritypoliciesclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationresyncsecuritypolicieserrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.runnerAssignToProject` {#mutationrunnerassigntoproject}

{{< details >}}GitLab 18.1で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `RunnerAssignToProjectInput`

#### 引数 {#arguments-483}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrunnerassigntoprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationrunnerassigntoprojectprojectpath"></a>`projectPath` | [`ID!`](#id) | Runnerが割り当てられるプロジェクトのフルパス。 |
| <a id="mutationrunnerassigntoprojectrunnerid"></a>`runnerId` | [`CiRunnerID!`](#cirunnerid) | プロジェクトに割り当てるRunnerのID。 |

#### フィールド {#fields-388}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrunnerassigntoprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationrunnerassigntoprojecterrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.runnerBulkPause` {#mutationrunnerbulkpause}

{{< details >}} GitLab 17.11で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `RunnerBulkPauseInput`

#### 引数 {#arguments-484}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrunnerbulkpauseclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationrunnerbulkpauseids"></a>`ids` | [`[CiRunnerID!]!`](#cirunnerid) | 一時停止または一時停止解除するRunnerのID。 |
| <a id="mutationrunnerbulkpausepaused"></a>`paused` | [`Boolean!`](#boolean) | Runnerによるジョブ受信が許可されていないことを示します。 |

#### フィールド {#fields-389}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrunnerbulkpauseclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationrunnerbulkpauseerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationrunnerbulkpauseupdatedcount"></a>`updatedCount` | [`Int`](#int) | 有効更新されたレコードの数。同期操作が実行された場合にのみ存在します。 |
| <a id="mutationrunnerbulkpauseupdatedrunners"></a>`updatedRunners` | [`[CiRunner!]`](#cirunner) | ミューテーション後のRunner。 |

### `Mutation.runnerCacheClear` {#mutationrunnercacheclear}

入力型: `RunnerCacheClearInput`

#### 引数 {#arguments-485}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrunnercacheclearclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationrunnercacheclearprojectid"></a>`projectId` | [`ProjectID!`](#projectid) | RunnerキャッシュをクリアするプロジェクトのグローバルID。 |

#### フィールド {#fields-390}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrunnercacheclearclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationrunnercacheclearerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.runnerCreate` {#mutationrunnercreate}

{{< details >}}GitLab 15.10で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `RunnerCreateInput`

#### 引数 {#arguments-486}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrunnercreateaccesslevel"></a>`accessLevel` | [`CiRunnerAccessLevel`](#cirunneraccesslevel) | Runnerのアクセスレベル。 |
| <a id="mutationrunnercreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationrunnercreatedescription"></a>`description` | [`String`](#string) | Runnerの説明。 |
| <a id="mutationrunnercreategroupid"></a>`groupId` | [`GroupID`](#groupid) | Runnerを作成するグループのグローバルID（グループRunnerの場合のみ有効）。 |
| <a id="mutationrunnercreatelocked"></a>`locked` | [`Boolean`](#boolean) | Runnerがロックされていることを示します。 |
| <a id="mutationrunnercreatemaintenancenote"></a>`maintenanceNote` | [`String`](#string) | Runnerのメンテナンスノート。 |
| <a id="mutationrunnercreatemaximumtimeout"></a>`maximumTimeout` | [`Int`](#int) | Runnerが処理するジョブの最大タイムアウト（秒単位）。 |
| <a id="mutationrunnercreatepaused"></a>`paused` | [`Boolean`](#boolean) | Runnerによるジョブ受信が許可されていないことを示します。 |
| <a id="mutationrunnercreateprivateprojectsminutescostfactor"></a>`privateProjectsMinutesCostFactor` {{< icon name="warning-solid" >}} | [`Float`](#float) | **非推奨**: **状態**: 実験的機能。GitLab 17.7で導入されました。 |
| <a id="mutationrunnercreateprojectid"></a>`projectId` | [`ProjectID`](#projectid) | Runnerを作成するプロジェクトのグローバルID（プロジェクトRunnerの場合のみ有効）。 |
| <a id="mutationrunnercreatepublicprojectsminutescostfactor"></a>`publicProjectsMinutesCostFactor` {{< icon name="warning-solid" >}} | [`Float`](#float) | **非推奨**: **状態**: 実験的機能。GitLab 17.7で導入されました。 |
| <a id="mutationrunnercreaterununtagged"></a>`runUntagged` | [`Boolean`](#boolean) | Runnerがタグなしジョブを実行できることを示します。 |
| <a id="mutationrunnercreaterunnertype"></a>`runnerType` | [`CiRunnerType!`](#cirunnertype) | 作成するRunnerのタイプ。 |
| <a id="mutationrunnercreatetaglist"></a>`tagList` | [`[String!]`](#string) | Runnerに関連付けられているタグ。 |

#### フィールド {#fields-391}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrunnercreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationrunnercreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationrunnercreaterunner"></a>`runner` | [`CiRunner`](#cirunner) | ミューテーション後のRunner。 |

### `Mutation.runnerDelete` {#mutationrunnerdelete}

入力型: `RunnerDeleteInput`

#### 引数 {#arguments-487}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrunnerdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationrunnerdeleteid"></a>`id` | [`CiRunnerID!`](#cirunnerid) | 削除するRunnerのID。 |

#### フィールド {#fields-392}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrunnerdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationrunnerdeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.runnerUnassignFromProject` {#mutationrunnerunassignfromproject}

{{< details >}}GitLab 18.1で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `RunnerUnassignFromProjectInput`

#### 引数 {#arguments-488}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrunnerunassignfromprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationrunnerunassignfromprojectprojectpath"></a>`projectPath` | [`ID!`](#id) | Runnerの割り当てを解除するプロジェクトのフルパス。 |
| <a id="mutationrunnerunassignfromprojectrunnerid"></a>`runnerId` | [`CiRunnerID!`](#cirunnerid) | プロジェクトから割り当てを解除するRunnerのID。 |

#### フィールド {#fields-393}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrunnerunassignfromprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationrunnerunassignfromprojecterrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.runnerUpdate` {#mutationrunnerupdate}

入力型: `RunnerUpdateInput`

#### 引数 {#arguments-489}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrunnerupdateaccesslevel"></a>`accessLevel` | [`CiRunnerAccessLevel`](#cirunneraccesslevel) | Runnerのアクセスレベル。 |
| <a id="mutationrunnerupdateactive"></a>`active` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | **非推奨**: 名前が変更されました。`paused`を使用してください。GitLab 14.8で非推奨になりました。 |
| <a id="mutationrunnerupdateassociatedprojects"></a>`associatedProjects` | [`[ProjectID!]`](#projectid) | Runnerに関連付けられているプロジェクト。プロジェクトRunnerでのみ利用可能です。 |
| <a id="mutationrunnerupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationrunnerupdatedescription"></a>`description` | [`String`](#string) | Runnerの説明。 |
| <a id="mutationrunnerupdateid"></a>`id` | [`CiRunnerID!`](#cirunnerid) | 更新するRunnerのID。 |
| <a id="mutationrunnerupdatelocked"></a>`locked` | [`Boolean`](#boolean) | Runnerがロックされていることを示します。 |
| <a id="mutationrunnerupdatemaintenancenote"></a>`maintenanceNote` | [`String`](#string) | Runnerのメンテナンスノート。 |
| <a id="mutationrunnerupdatemaximumtimeout"></a>`maximumTimeout` | [`Int`](#int) | Runnerが処理するジョブの最大タイムアウト（秒単位）。 |
| <a id="mutationrunnerupdatepaused"></a>`paused` | [`Boolean`](#boolean) | Runnerによるジョブ受信が許可されていないことを示します。 |
| <a id="mutationrunnerupdateprivateprojectsminutescostfactor"></a>`privateProjectsMinutesCostFactor` {{< icon name="warning-solid" >}} | [`Float`](#float) | **非推奨**: **状態**: 実験的機能。GitLab 17.7で導入されました。 |
| <a id="mutationrunnerupdatepublicprojectsminutescostfactor"></a>`publicProjectsMinutesCostFactor` {{< icon name="warning-solid" >}} | [`Float`](#float) | **非推奨**: **状態**: 実験的機能。GitLab 17.7で導入されました。 |
| <a id="mutationrunnerupdaterununtagged"></a>`runUntagged` | [`Boolean`](#boolean) | Runnerがタグなしジョブを実行できることを示します。 |
| <a id="mutationrunnerupdatetaglist"></a>`tagList` | [`[String!]`](#string) | Runnerに関連付けられているタグ。 |

#### フィールド {#fields-394}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrunnerupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationrunnerupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationrunnerupdaterunner"></a>`runner` | [`CiRunner`](#cirunner) | ミューテーション後のRunner。 |

### `Mutation.runnersExportUsage` {#mutationrunnersexportusage}

入力型: `RunnersExportUsageInput`

#### 引数 {#arguments-490}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrunnersexportusageclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationrunnersexportusagefromdate"></a>`fromDate` | [`ISO8601Date`](#iso8601date) | レポート期間のUTC開始日。デフォルトは、前月の開始日です。 |
| <a id="mutationrunnersexportusagefullpath"></a>`fullPath` | [`ID`](#id) | ジョブを、その属するグループまたはプロジェクトのフルパスでフィルタリングします。例: `gitlab-org`や`gitlab-org/gitlab`など。これを使用できるのは、管理者と、グループ（グループが指定されている場合）またはプロジェクト（プロジェクトが指定されている場合）のメンテナーロールを付与されているユーザーだけです。最大5,000個の子プロジェクトからのRunnerに制限されています。 |
| <a id="mutationrunnersexportusagemaxprojectcount"></a>`maxProjectCount` | [`Int`](#int) | 返すプロジェクトの最大数。その他すべてのRunnerの使用状況は、`<Other projects>`エントリに起因します。デフォルトはプロジェクト1000個です。 |
| <a id="mutationrunnersexportusagerunnertype"></a>`runnerType` | [`CiRunnerType`](#cirunnertype) | レポートに含めるRunnerのスコープ。 |
| <a id="mutationrunnersexportusagetodate"></a>`toDate` | [`ISO8601Date`](#iso8601date) | レポート期間のUTC終了日。デフォルトは、`fromDate`で指定された月の月末です。 |

#### フィールド {#fields-395}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrunnersexportusageclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationrunnersexportusageerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.runnersRegistrationTokenReset` {#mutationrunnersregistrationtokenreset}

{{< details >}} GitLab 17.7で**非推奨**になりました。基盤となる機能は15.6で非推奨となりました。18.0で削除される予定です。{{< /details >}}

入力型: `RunnersRegistrationTokenResetInput`

#### 引数 {#arguments-491}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrunnersregistrationtokenresetclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationrunnersregistrationtokenresetid"></a>`id` | [`ID`](#id) | トークンをリセットするプロジェクトまたはグループのID。インスタンスRunnerトークンをリセットする場合は省略してください。 |
| <a id="mutationrunnersregistrationtokenresettype"></a>`type` | [`CiRunnerType!`](#cirunnertype) | トークンをリセットするオブジェクトのスコープ。 |

#### フィールド {#fields-396}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationrunnersregistrationtokenresetclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationrunnersregistrationtokenreseterrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationrunnersregistrationtokenresettoken"></a>`token` | [`String`](#string) | ミューテーション後のRunnerトークン。 |

### `Mutation.safeDisablePipelineVariables` {#mutationsafedisablepipelinevariables}

入力型: `SafeDisablePipelineVariablesInput`

#### 引数 {#arguments-492}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsafedisablepipelinevariablesclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsafedisablepipelinevariablesfullpath"></a>`fullPath` | [`ID!`](#id) | パイプライン変数を除外するグループのフルパス。 |

#### フィールド {#fields-397}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsafedisablepipelinevariablesclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsafedisablepipelinevariableserrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationsafedisablepipelinevariablessuccess"></a>`success` | [`Boolean!`](#boolean) | 移行が正常にキューに追加されたかどうかを示します。 |

### `Mutation.savedReplyCreate` {#mutationsavedreplycreate}

入力型: `SavedReplyCreateInput`

#### 引数 {#arguments-493}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsavedreplycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsavedreplycreatecontent"></a>`content` | [`String!`](#string) | 保存済み返信の内容。 |
| <a id="mutationsavedreplycreatename"></a>`name` | [`String!`](#string) | 保存済み返信の名前。 |

#### フィールド {#fields-398}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsavedreplycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsavedreplycreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationsavedreplycreatesavedreply"></a>`savedReply` | [`SavedReply`](#savedreply) | ミューテーション後の保存済み返信。 |

### `Mutation.savedReplyDestroy` {#mutationsavedreplydestroy}

入力型: `SavedReplyDestroyInput`

#### 引数 {#arguments-494}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsavedreplydestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsavedreplydestroyid"></a>`id` | [`UsersSavedReplyID!`](#userssavedreplyid) | ユーザー保存済み返信のグローバルID。 |

#### フィールド {#fields-399}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsavedreplydestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsavedreplydestroyerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationsavedreplydestroysavedreply"></a>`savedReply` | [`SavedReply`](#savedreply) | ミューテーション後の保存済み返信。 |

### `Mutation.savedReplyUpdate` {#mutationsavedreplyupdate}

入力型: `SavedReplyUpdateInput`

#### 引数 {#arguments-495}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsavedreplyupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsavedreplyupdatecontent"></a>`content` | [`String!`](#string) | 保存済み返信の内容。 |
| <a id="mutationsavedreplyupdateid"></a>`id` | [`UsersSavedReplyID!`](#userssavedreplyid) | ユーザー保存済み返信のグローバルID。 |
| <a id="mutationsavedreplyupdatename"></a>`name` | [`String!`](#string) | 保存済み返信の名前。 |

#### フィールド {#fields-400}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsavedreplyupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsavedreplyupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationsavedreplyupdatesavedreply"></a>`savedReply` | [`SavedReply`](#savedreply) | ミューテーション後の保存済み返信。 |

### `Mutation.scanExecutionPolicyCommit` {#mutationscanexecutionpolicycommit}

`policy_yaml`のコンテンツを、指定されたプロジェクト（`full_path`）で割り当てられているセキュリティポリシープロジェクトにコミットします。

入力型: `ScanExecutionPolicyCommitInput`

#### 引数 {#arguments-496}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationscanexecutionpolicycommitclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationscanexecutionpolicycommitfullpath"></a>`fullPath` | [`String`](#string) | プロジェクトのフルパス。 |
| <a id="mutationscanexecutionpolicycommitname"></a>`name` | [`String!`](#string) | ポリシーの名前。名前がnullの場合、`policy_yaml`の`name`フィールドが使用されます。 |
| <a id="mutationscanexecutionpolicycommitoperationmode"></a>`operationMode` | [`MutationOperationMode!`](#mutationoperationmode) | 操作モードを変更します。 |
| <a id="mutationscanexecutionpolicycommitpolicyyaml"></a>`policyYaml` | [`String!`](#string) | ポリシーのYAMLスニペット。 |
| <a id="mutationscanexecutionpolicycommitprojectpath"></a>`projectPath` {{< icon name="warning-solid" >}} | [`ID`](#id) | **非推奨**: `fullPath`を使用してください。GitLab 14.10で非推奨になりました。 |

#### フィールド {#fields-401}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationscanexecutionpolicycommitbranch"></a>`branch` | [`String`](#string) | ポリシーの変更のコミット先ブランチの名前。 |
| <a id="mutationscanexecutionpolicycommitclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationscanexecutionpolicycommiterrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationscanexecutionpolicycommitvalidationerrors"></a>`validationErrors` | [`[SecurityPolicyValidationError!]`](#securitypolicyvalidationerror) | ミューテーションの実行中に発生した検証エラー。 |

### `Mutation.secretPermissionDelete` {#mutationsecretpermissiondelete}

入力型: `SecretPermissionDeleteInput`

#### 引数 {#arguments-497}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecretpermissiondeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsecretpermissiondeleteprincipal"></a>`principal` | [`PrincipalInput!`](#principalinput) | 削除する権限の所有者。 |
| <a id="mutationsecretpermissiondeleteprojectpath"></a>`projectPath` | [`ID!`](#id) | シークレットのプロジェクト権限。 |

#### フィールド {#fields-402}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecretpermissiondeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsecretpermissiondeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationsecretpermissiondeletesecretpermission"></a>`secretPermission` | [`SecretPermission`](#secretpermission) | シークレット権限を削除しました。 |

### `Mutation.secretPermissionUpdate` {#mutationsecretpermissionupdate}

入力型: `SecretPermissionUpdateInput`

#### 引数 {#arguments-498}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecretpermissionupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsecretpermissionupdateexpiredat"></a>`expiredAt` | [`ISO8601Date`](#iso8601date) | シークレット権限の有効期限（オプション）。 |
| <a id="mutationsecretpermissionupdatepermissions"></a>`permissions` | [`[String!]!`](#string) | 付与する権限。['create'、'update'、'read'、'delete']。 |
| <a id="mutationsecretpermissionupdateprincipal"></a>`principal` | [`PrincipalInput!`](#principalinput) | アクセスを提供するユーザー/MemberRole/ロール/グループ。 |
| <a id="mutationsecretpermissionupdateprojectpath"></a>`projectPath` | [`ID!`](#id) | 権限を追加するプロジェクト。 |

#### フィールド {#fields-403}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecretpermissionupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsecretpermissionupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationsecretpermissionupdatesecretpermission"></a>`secretPermission` | [`SecretPermission`](#secretpermission) | 作成されたシークレット権限。 |

### `Mutation.securityAttributeCreate` {#mutationsecurityattributecreate}

入力型: `SecurityAttributeCreateInput`

#### 引数 {#arguments-499}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecurityattributecreateattributes"></a>`attributes` | [`[SecurityAttributeInput!]!`](#securityattributeinput) | 作成する属性。 |
| <a id="mutationsecurityattributecreatecategoryid"></a>`categoryId` | [`SecurityCategoryID`](#securitycategoryid) | セキュリティカテゴリのグローバルID。 |
| <a id="mutationsecurityattributecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsecurityattributecreatenamespaceid"></a>`namespaceId` | [`NamespaceID`](#namespaceid) | ネームスペースのグローバルID。カテゴリIDが指定されていない場合に使用されます。 |
| <a id="mutationsecurityattributecreatetemplatetype"></a>`templateType` | [`SecurityCategoryTemplateType`](#securitycategorytemplatetype) | 定義されたカテゴリのテンプレートタイプ。カテゴリIDが指定されていない場合に使用されます。 |

#### フィールド {#fields-404}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecurityattributecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsecurityattributecreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationsecurityattributecreatesecurityattributes"></a>`securityAttributes` | [`[SecurityAttribute!]`](#securityattribute) | 作成されたセキュリティ属性。 |

### `Mutation.securityAttributeUpdate` {#mutationsecurityattributeupdate}

入力型: `SecurityAttributeUpdateInput`

#### 引数 {#arguments-500}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecurityattributeupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsecurityattributeupdatecolor"></a>`color` | [`Color`](#color) | セキュリティ属性の色。 |
| <a id="mutationsecurityattributeupdatedescription"></a>`description` | [`String`](#string) | セキュリティ属性の説明。 |
| <a id="mutationsecurityattributeupdateid"></a>`id` | [`SecurityAttributeID!`](#securityattributeid) | セキュリティ属性のグローバルID。 |
| <a id="mutationsecurityattributeupdatename"></a>`name` | [`String`](#string) | セキュリティ属性の名前。 |

#### フィールド {#fields-405}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecurityattributeupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsecurityattributeupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationsecurityattributeupdatesecurityattribute"></a>`securityAttribute` | [`SecurityAttribute`](#securityattribute) | 更新されたセキュリティ属性。 |

### `Mutation.securityCategoryCreate` {#mutationsecuritycategorycreate}

入力型: `SecurityCategoryCreateInput`

#### 引数 {#arguments-501}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecuritycategorycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsecuritycategorycreatedescription"></a>`description` | [`String`](#string) | セキュリティカテゴリの説明。 |
| <a id="mutationsecuritycategorycreatemultipleselection"></a>`multipleSelection` | [`Boolean`](#boolean) | 複数の属性を選択できるかどうか。 |
| <a id="mutationsecuritycategorycreatename"></a>`name` | [`String!`](#string) | セキュリティカテゴリの名前。 |
| <a id="mutationsecuritycategorycreatenamespaceid"></a>`namespaceId` | [`NamespaceID!`](#namespaceid) | カテゴリネームスペースのグローバルID。 |

#### フィールド {#fields-406}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecuritycategorycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsecuritycategorycreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationsecuritycategorycreatesecuritycategory"></a>`securityCategory` | [`SecurityCategory`](#securitycategory) | 作成されたセキュリティカテゴリ。 |

### `Mutation.securityCategoryUpdate` {#mutationsecuritycategoryupdate}

入力型: `SecurityCategoryUpdateInput`

#### 引数 {#arguments-502}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecuritycategoryupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsecuritycategoryupdatedescription"></a>`description` | [`String`](#string) | セキュリティカテゴリの説明。 |
| <a id="mutationsecuritycategoryupdateid"></a>`id` | [`SecurityCategoryID`](#securitycategoryid) | セキュリティカテゴリのグローバルID。 |
| <a id="mutationsecuritycategoryupdatename"></a>`name` | [`String`](#string) | セキュリティカテゴリの名前。 |
| <a id="mutationsecuritycategoryupdatenamespaceid"></a>`namespaceId` | [`NamespaceID!`](#namespaceid) | カテゴリネームスペースのグローバルID。 |
| <a id="mutationsecuritycategoryupdatetemplatetype"></a>`templateType` | [`SecurityCategoryTemplateType`](#securitycategorytemplatetype) | 定義されたカテゴリのテンプレートタイプ。カテゴリIDが指定されていない場合に使用されます。 |

#### フィールド {#fields-407}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecuritycategoryupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsecuritycategoryupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationsecuritycategoryupdatesecuritycategory"></a>`securityCategory` | [`SecurityCategory`](#securitycategory) | 更新されたセキュリティカテゴリ。 |

### `Mutation.securityFindingCreateIssue` {#mutationsecurityfindingcreateissue}

入力型: `SecurityFindingCreateIssueInput`

#### 引数 {#arguments-503}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingcreateissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsecurityfindingcreateissueproject"></a>`project` | [`ProjectID!`](#projectid) | イシューのアタッチ先プロジェクトのID。 |
| <a id="mutationsecurityfindingcreateissueuuid"></a>`uuid` | [`String!`](#string) | イシューの作成に使用されるセキュリティ検出結果のUUID。 |

#### フィールド {#fields-408}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingcreateissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsecurityfindingcreateissueerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationsecurityfindingcreateissueissue"></a>`issue` | [`Issue`](#issue) | ミューテーション後に作成されたイシュー。 |

### `Mutation.securityFindingCreateMergeRequest` {#mutationsecurityfindingcreatemergerequest}

入力型: `SecurityFindingCreateMergeRequestInput`

#### 引数 {#arguments-504}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingcreatemergerequestclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsecurityfindingcreatemergerequestuuid"></a>`uuid` | [`String!`](#string) | マージリクエストの作成に使用されるセキュリティ検出結果のUUID。 |

#### フィールド {#fields-409}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingcreatemergerequestclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsecurityfindingcreatemergerequesterrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationsecurityfindingcreatemergerequestmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | ミューテーション後に作成されたマージリクエスト。 |

### `Mutation.securityFindingCreateVulnerability` {#mutationsecurityfindingcreatevulnerability}

{{< details >}}GitLab 17.5で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `SecurityFindingCreateVulnerabilityInput`

#### 引数 {#arguments-505}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingcreatevulnerabilityclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsecurityfindingcreatevulnerabilityuuid"></a>`uuid` | [`String!`](#string) | 脆弱性の作成に使用されるセキュリティ検出結果のUUID。 |

#### フィールド {#fields-410}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingcreatevulnerabilityclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsecurityfindingcreatevulnerabilityerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationsecurityfindingcreatevulnerabilityvulnerability"></a>`vulnerability` | [`Vulnerability`](#vulnerability) | ミューテーション後に作成された脆弱性。 |

### `Mutation.securityFindingDismiss` {#mutationsecurityfindingdismiss}

入力型: `SecurityFindingDismissInput`

#### 引数 {#arguments-506}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingdismissclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsecurityfindingdismisscomment"></a>`comment` | [`String`](#string) | 発見を無視する理由についてのコメント。 |
| <a id="mutationsecurityfindingdismissdismissalreason"></a>`dismissalReason` | [`VulnerabilityDismissalReason`](#vulnerabilitydismissalreason) | 発見を無視する理由。 |
| <a id="mutationsecurityfindingdismissuuid"></a>`uuid` | [`String!`](#string) | 無視する検出結果のUUID。 |

#### フィールド {#fields-411}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingdismissclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsecurityfindingdismisserrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationsecurityfindingdismisssecurityfinding"></a>`securityFinding` | [`PipelineSecurityReportFinding`](#pipelinesecurityreportfinding) | 無視された発見。 |
| <a id="mutationsecurityfindingdismissuuid"></a>`uuid` | [`String`](#string) | 無視された発見のUUID。 |

### `Mutation.securityFindingRevertToDetected` {#mutationsecurityfindingreverttodetected}

入力型: `SecurityFindingRevertToDetectedInput`

#### 引数 {#arguments-507}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingreverttodetectedclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsecurityfindingreverttodetectedcomment"></a>`comment` | [`String`](#string) | 発見をリバートして検出されたステータスに戻した理由を説明するコメント。 |
| <a id="mutationsecurityfindingreverttodetecteduuid"></a>`uuid` | [`String!`](#string) | 無視する検出結果のUUID。 |

#### フィールド {#fields-412}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingreverttodetectedclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsecurityfindingreverttodetectederrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationsecurityfindingreverttodetectedsecurityfinding"></a>`securityFinding` | [`PipelineSecurityReportFinding`](#pipelinesecurityreportfinding) | リバートされて検出された状態に戻された発見。 |

### `Mutation.securityFindingSeverityOverride` {#mutationsecurityfindingseverityoverride}

入力型: `SecurityFindingSeverityOverrideInput`

#### 引数 {#arguments-508}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingseverityoverrideclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsecurityfindingseverityoverrideseverity"></a>`severity` | [`VulnerabilitySeverity!`](#vulnerabilityseverity) | 発見の新しい重大度値。 |
| <a id="mutationsecurityfindingseverityoverrideuuid"></a>`uuid` | [`String!`](#string) | 変更する検出結果のUUID。 |

#### フィールド {#fields-413}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingseverityoverrideclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsecurityfindingseverityoverrideerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationsecurityfindingseverityoverridesecurityfinding"></a>`securityFinding` | [`PipelineSecurityReportFinding`](#pipelinesecurityreportfinding) | 重大度が変更された発見。 |

### `Mutation.securityPolicyProjectAssign` {#mutationsecuritypolicyprojectassign}

指定されたプロジェクト（`security_policy_project_id`）を、指定されたプロジェクト（`full_path`）のセキュリティポリシープロジェクトとして割り当てます。プロジェクトにすでにセキュリティポリシープロジェクトがある場合、指定された`security_policy_project_id`のプロジェクトのセキュリティポリシープロジェクトを再割り当てします。

入力型: `SecurityPolicyProjectAssignInput`

#### 引数 {#arguments-509}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecuritypolicyprojectassignclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsecuritypolicyprojectassignfullpath"></a>`fullPath` | [`String`](#string) | プロジェクトまたはグループのフルパス。 |
| <a id="mutationsecuritypolicyprojectassignprojectpath"></a>`projectPath` {{< icon name="warning-solid" >}} | [`ID`](#id) | **非推奨**: `fullPath`を使用してください。GitLab 14.10で非推奨になりました。 |
| <a id="mutationsecuritypolicyprojectassignsecuritypolicyprojectid"></a>`securityPolicyProjectId` | [`ProjectID!`](#projectid) | セキュリティポリシープロジェクトのID。 |

#### フィールド {#fields-414}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecuritypolicyprojectassignclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsecuritypolicyprojectassignerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.securityPolicyProjectCreate` {#mutationsecuritypolicyprojectcreate}

指定されたプロジェクトまたはグループ（`full_path`）のセキュリティポリシープロジェクトを作成して割り当てます。

入力型: `SecurityPolicyProjectCreateInput`

#### 引数 {#arguments-510}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecuritypolicyprojectcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsecuritypolicyprojectcreatefullpath"></a>`fullPath` | [`String`](#string) | プロジェクトまたはグループのフルパス。 |
| <a id="mutationsecuritypolicyprojectcreateprojectpath"></a>`projectPath` {{< icon name="warning-solid" >}} | [`ID`](#id) | **非推奨**: `fullPath`を使用してください。GitLab 14.10で非推奨になりました。 |

#### フィールド {#fields-415}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecuritypolicyprojectcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsecuritypolicyprojectcreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationsecuritypolicyprojectcreateproject"></a>`project` | [`Project`](#project) | 作成されたセキュリティポリシープロジェクト。 |

### `Mutation.securityPolicyProjectCreateAsync` {#mutationsecuritypolicyprojectcreateasync}

{{< details >}}GitLab 17.3で**導入**されました。**状態**: 実験的機能。{{< /details >}}

指定されたプロジェクトまたはグループ（`full_path`）のセキュリティポリシープロジェクトを非同期で作成して割り当てます。

入力型: `SecurityPolicyProjectCreateAsyncInput`

#### 引数 {#arguments-511}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecuritypolicyprojectcreateasyncclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsecuritypolicyprojectcreateasyncfullpath"></a>`fullPath` | [`String!`](#string) | プロジェクトまたはグループのフルパス。 |

#### フィールド {#fields-416}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecuritypolicyprojectcreateasyncclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsecuritypolicyprojectcreateasyncerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.securityPolicyProjectUnassign` {#mutationsecuritypolicyprojectunassign}

指定されたプロジェクト(`full_path`)のセキュリティポリシープロジェクトの割り当てを解除します。

入力型: `SecurityPolicyProjectUnassignInput`

#### 引数 {#arguments-512}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecuritypolicyprojectunassignclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsecuritypolicyprojectunassignfullpath"></a>`fullPath` | [`String`](#string) | プロジェクトまたはグループのフルパス。 |
| <a id="mutationsecuritypolicyprojectunassignprojectpath"></a>`projectPath` {{< icon name="warning-solid" >}} | [`ID`](#id) | **非推奨**: `fullPath`を使用してください。GitLab 14.10で非推奨になりました。 |

#### フィールド {#fields-417}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecuritypolicyprojectunassignclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsecuritypolicyprojectunassignerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.securityTrainingUpdate` {#mutationsecuritytrainingupdate}

入力型: `SecurityTrainingUpdateInput`

#### 引数 {#arguments-513}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecuritytrainingupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsecuritytrainingupdateisenabled"></a>`isEnabled` | [`Boolean!`](#boolean) | プロジェクトでトレーニングプロバイダーを有効として設定します。 |
| <a id="mutationsecuritytrainingupdateisprimary"></a>`isPrimary` | [`Boolean`](#boolean) | プロジェクトでトレーニングプロバイダーをプライマリとして設定します。 |
| <a id="mutationsecuritytrainingupdateprojectpath"></a>`projectPath` | [`ID!`](#id) | プロジェクトのフルパス。 |
| <a id="mutationsecuritytrainingupdateproviderid"></a>`providerId` | [`SecurityTrainingProviderID!`](#securitytrainingproviderid) | プロバイダーのID。 |

#### フィールド {#fields-418}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsecuritytrainingupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsecuritytrainingupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationsecuritytrainingupdatetraining"></a>`training` | [`ProjectSecurityTraining`](#projectsecuritytraining) | ミューテーションの対象となるトレーニングエンティティを表します。 |

### `Mutation.setContainerScanningForRegistry` {#mutationsetcontainerscanningforregistry}

指定されたプロジェクトのコンテナレジストリでのコンテナスキャンを有効または無効にします。

入力型: `SetContainerScanningForRegistryInput`

#### 引数 {#arguments-514}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsetcontainerscanningforregistryclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsetcontainerscanningforregistryenable"></a>`enable` | [`Boolean!`](#boolean) | 目的とするコンテナレジストリ機能でのコンテナスキャンのステータス。 |
| <a id="mutationsetcontainerscanningforregistrynamespacepath"></a>`namespacePath` | [`ID!`](#id) | ネームスペース（プロジェクト）のフルパス。 |

#### フィールド {#fields-419}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsetcontainerscanningforregistryclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsetcontainerscanningforregistrycontainerscanningforregistryenabled"></a>`containerScanningForRegistryEnabled` | [`Boolean`](#boolean) | 機能が有効かどうか。 |
| <a id="mutationsetcontainerscanningforregistryerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.setGroupSecretPushProtection` {#mutationsetgroupsecretpushprotection}

グループのシークレットプッシュ保護を有効または無効にします。

入力型: `SetGroupSecretPushProtectionInput`

#### 引数 {#arguments-515}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsetgroupsecretpushprotectionclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsetgroupsecretpushprotectionnamespacepath"></a>`namespacePath` | [`ID!`](#id) | グループのフルパス。 |
| <a id="mutationsetgroupsecretpushprotectionprojectstoexclude"></a>`projectsToExclude` | [`[Int!]`](#int) | 機能から除外するプロジェクトのID。 |
| <a id="mutationsetgroupsecretpushprotectionsecretpushprotectionenabled"></a>`secretPushProtectionEnabled` | [`Boolean!`](#boolean) | 機能を有効にするかどうか。 |

#### フィールド {#fields-420}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsetgroupsecretpushprotectionclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsetgroupsecretpushprotectionerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.setLicenseConfigurationSource` {#mutationsetlicenseconfigurationsource}

指定されたプロジェクトのライセンス情報ソースを設定します。

入力型: `SetLicenseConfigurationSourceInput`

#### 引数 {#arguments-516}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsetlicenseconfigurationsourceclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsetlicenseconfigurationsourceprojectpath"></a>`projectPath` | [`ID!`](#id) | プロジェクトのフルパス。 |
| <a id="mutationsetlicenseconfigurationsourcesource"></a>`source` | [`SecurityPreferredLicenseSourceConfiguration!`](#securitypreferredlicensesourceconfiguration) | 依存関係のライセンス情報の推奨されるソース。 |

#### フィールド {#fields-421}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsetlicenseconfigurationsourceclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsetlicenseconfigurationsourceerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationsetlicenseconfigurationsourcelicenseconfigurationsource"></a>`licenseConfigurationSource` | [`SecurityPreferredLicenseSourceConfiguration`](#securitypreferredlicensesourceconfiguration) | 依存関係のライセンス情報の推奨されるソース。 |

### `Mutation.setPagesForceHttps` {#mutationsetpagesforcehttps}

入力型: `SetPagesForceHttpsInput`

#### 引数 {#arguments-517}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsetpagesforcehttpsclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsetpagesforcehttpsprojectpath"></a>`projectPath` | [`ID!`](#id) | ページにHTTPSを強制的に使用するように設定するプロジェクトのパス。 |
| <a id="mutationsetpagesforcehttpsvalue"></a>`value` | [`Boolean!`](#boolean) | ユーザーが自分のページでHTTPSを強制するかどうかを示します。 |

#### フィールド {#fields-422}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsetpagesforcehttpsclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsetpagesforcehttpserrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationsetpagesforcehttpsproject"></a>`project` | [`Project`](#project) | 更新されたプロジェクト。 |

### `Mutation.setPagesUseUniqueDomain` {#mutationsetpagesuseuniquedomain}

入力型: `SetPagesUseUniqueDomainInput`

#### 引数 {#arguments-518}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsetpagesuseuniquedomainclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsetpagesuseuniquedomainprojectpath"></a>`projectPath` | [`ID!`](#id) | 固有のドメインを使用するようにページを設定するプロジェクトのパス。 |
| <a id="mutationsetpagesuseuniquedomainvalue"></a>`value` | [`Boolean!`](#boolean) | ユーザーが自分のページに固有のサブドメインを使用するかどうかを示します。 |

#### フィールド {#fields-423}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsetpagesuseuniquedomainclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsetpagesuseuniquedomainerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationsetpagesuseuniquedomainproject"></a>`project` | [`Project`](#project) | 更新されたプロジェクト。 |

### `Mutation.setPreReceiveSecretDetection` {#mutationsetprereceivesecretdetection}

特定のプロジェクトのシークレットプッシュ保護を有効または無効にします。

入力型: `SetPreReceiveSecretDetectionInput`

#### 引数 {#arguments-519}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsetprereceivesecretdetectionclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsetprereceivesecretdetectionenable"></a>`enable` | [`Boolean!`](#boolean) | 目的とするシークレットプッシュ保護機能のステータス。 |
| <a id="mutationsetprereceivesecretdetectionnamespacepath"></a>`namespacePath` | [`ID!`](#id) | ネームスペース（プロジェクト）のフルパス。 |

#### フィールド {#fields-424}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsetprereceivesecretdetectionclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsetprereceivesecretdetectionerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationsetprereceivesecretdetectionprereceivesecretdetectionenabled"></a>`preReceiveSecretDetectionEnabled` | [`Boolean`](#boolean) | 機能が有効かどうか。 |
| <a id="mutationsetprereceivesecretdetectionsecretpushprotectionenabled"></a>`secretPushProtectionEnabled` | [`Boolean`](#boolean) | 機能が有効かどうか。 |

### `Mutation.setSecretPushProtection` {#mutationsetsecretpushprotection}

特定のプロジェクトのシークレットプッシュ保護を有効または無効にします。

入力型: `SetSecretPushProtectionInput`

#### 引数 {#arguments-520}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsetsecretpushprotectionclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsetsecretpushprotectionenable"></a>`enable` | [`Boolean!`](#boolean) | 目的とするシークレットプッシュ保護機能のステータス。 |
| <a id="mutationsetsecretpushprotectionnamespacepath"></a>`namespacePath` | [`ID!`](#id) | ネームスペース（プロジェクト）のフルパス。 |

#### フィールド {#fields-425}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsetsecretpushprotectionclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsetsecretpushprotectionerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationsetsecretpushprotectionprereceivesecretdetectionenabled"></a>`preReceiveSecretDetectionEnabled` | [`Boolean`](#boolean) | 機能が有効かどうか。 |
| <a id="mutationsetsecretpushprotectionsecretpushprotectionenabled"></a>`secretPushProtectionEnabled` | [`Boolean`](#boolean) | 機能が有効かどうか。 |

### `Mutation.setValidityChecks` {#mutationsetvaliditychecks}

指定されたプロジェクトのシークレット検出の有効性チェックを有効/無効にします。

入力型: `SetValidityChecksInput`

#### 引数 {#arguments-521}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsetvaliditychecksclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsetvaliditychecksenable"></a>`enable` | [`Boolean!`](#boolean) | 有効性チェック機能の目的のステータス。 |
| <a id="mutationsetvaliditychecksnamespacepath"></a>`namespacePath` | [`ID!`](#id) | ネームスペース（プロジェクト）のフルパス。 |

#### フィールド {#fields-426}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationsetvaliditychecksclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationsetvaliditycheckserrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationsetvaliditychecksvaliditychecksenabled"></a>`validityChecksEnabled` | [`Boolean`](#boolean) | 機能が有効かどうか。 |

### `Mutation.starProject` {#mutationstarproject}

{{< details >}} GitLab 16.7で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `StarProjectInput`

#### 引数 {#arguments-522}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationstarprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationstarprojectprojectid"></a>`projectId` | [`ProjectID!`](#projectid) | お気に入り登録またはスター解除するプロジェクトのフルパス。 |
| <a id="mutationstarprojectstarred"></a>`starred` | [`Boolean!`](#boolean) | プロジェクトをお気に入り登録するか、スター解除するかを示します。 |

#### フィールド {#fields-427}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationstarprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationstarprojectcount"></a>`count` | [`String!`](#string) | プロジェクトの星の数。 |
| <a id="mutationstarprojecterrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.tagCreate` {#mutationtagcreate}

入力型: `TagCreateInput`

#### 引数 {#arguments-523}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtagcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationtagcreatemessage"></a>`message` | [`String`](#string) | タグ付けメッセージ。 |
| <a id="mutationtagcreatename"></a>`name` | [`String!`](#string) | タグの名前。 |
| <a id="mutationtagcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | ブランチが関連付けられているプロジェクトのフルパス。 |
| <a id="mutationtagcreateref"></a>`ref` | [`String!`](#string) | タグの作成元となるタグ名またはコミットSHA。 |

#### フィールド {#fields-428}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtagcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationtagcreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationtagcreatetag"></a>`tag` | [`Tag`](#tag) | ミューテーション後のタグ。 |

### `Mutation.tagDelete` {#mutationtagdelete}

入力型: `TagDeleteInput`

#### 引数 {#arguments-524}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtagdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationtagdeletename"></a>`name` | [`String!`](#string) | タグの名前。 |
| <a id="mutationtagdeleteprojectpath"></a>`projectPath` | [`ID!`](#id) | ブランチが関連付けられているプロジェクトのフルパス。 |

#### フィールド {#fields-429}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtagdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationtagdeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationtagdeletetag"></a>`tag` | [`Tag`](#tag) | ミューテーション後のタグ。 |

### `Mutation.terraformStateDelete` {#mutationterraformstatedelete}

入力型: `TerraformStateDeleteInput`

#### 引数 {#arguments-525}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationterraformstatedeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationterraformstatedeleteid"></a>`id` | [`TerraformStateID!`](#terraformstateid) | TerraformステートのグローバルID。 |

#### フィールド {#fields-430}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationterraformstatedeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationterraformstatedeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.terraformStateLock` {#mutationterraformstatelock}

入力型: `TerraformStateLockInput`

#### 引数 {#arguments-526}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationterraformstatelockclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationterraformstatelockid"></a>`id` | [`TerraformStateID!`](#terraformstateid) | TerraformステートのグローバルID。 |

#### フィールド {#fields-431}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationterraformstatelockclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationterraformstatelockerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.terraformStateUnlock` {#mutationterraformstateunlock}

入力型: `TerraformStateUnlockInput`

#### 引数 {#arguments-527}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationterraformstateunlockclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationterraformstateunlockid"></a>`id` | [`TerraformStateID!`](#terraformstateid) | TerraformステートのグローバルID。 |

#### フィールド {#fields-432}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationterraformstateunlockclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationterraformstateunlockerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.timelineEventCreate` {#mutationtimelineeventcreate}

{{< details >}} GitLab 15.6で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `TimelineEventCreateInput`

#### 引数 {#arguments-528}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationtimelineeventcreateincidentid"></a>`incidentId` | [`IssueID!`](#issueid) | タイムラインイベントのインシデントID。 |
| <a id="mutationtimelineeventcreatenote"></a>`note` | [`String!`](#string) | タイムラインイベントのテキストノート。 |
| <a id="mutationtimelineeventcreateoccurredat"></a>`occurredAt` | [`Time!`](#time) | イベント発生時点のタイムスタンプ。 |
| <a id="mutationtimelineeventcreatetimelineeventtagnames"></a>`timelineEventTagNames` | [`[String!]`](#string) | インシデントタイムラインイベントのタグ。 |

#### フィールド {#fields-433}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationtimelineeventcreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationtimelineeventcreatetimelineevent"></a>`timelineEvent` | [`TimelineEventType`](#timelineeventtype) | タイムラインイベント。 |

### `Mutation.timelineEventDestroy` {#mutationtimelineeventdestroy}

入力型: `TimelineEventDestroyInput`

#### 引数 {#arguments-529}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationtimelineeventdestroyid"></a>`id` | [`IncidentManagementTimelineEventID!`](#incidentmanagementtimelineeventid) | 削除するタイムラインイベントID。 |

#### フィールド {#fields-434}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationtimelineeventdestroyerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationtimelineeventdestroytimelineevent"></a>`timelineEvent` | [`TimelineEventType`](#timelineeventtype) | タイムラインイベント。 |

### `Mutation.timelineEventPromoteFromNote` {#mutationtimelineeventpromotefromnote}

入力型: `TimelineEventPromoteFromNoteInput`

#### 引数 {#arguments-530}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventpromotefromnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationtimelineeventpromotefromnotenoteid"></a>`noteId` | [`NoteID!`](#noteid) | タイムラインイベントのプロモート元のノートID。 |

#### フィールド {#fields-435}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventpromotefromnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationtimelineeventpromotefromnoteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationtimelineeventpromotefromnotetimelineevent"></a>`timelineEvent` | [`TimelineEventType`](#timelineeventtype) | タイムラインイベント。 |

### `Mutation.timelineEventTagCreate` {#mutationtimelineeventtagcreate}

入力型: `TimelineEventTagCreateInput`

#### 引数 {#arguments-531}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventtagcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationtimelineeventtagcreatename"></a>`name` | [`String!`](#string) | タグの名前。 |
| <a id="mutationtimelineeventtagcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | タイムラインイベントタグを作成するプロジェクト。 |

#### フィールド {#fields-436}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventtagcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationtimelineeventtagcreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationtimelineeventtagcreatetimelineeventtag"></a>`timelineEventTag` | [`TimelineEventTagType`](#timelineeventtagtype) | タイムラインイベントタグ。 |

### `Mutation.timelineEventUpdate` {#mutationtimelineeventupdate}

入力型: `TimelineEventUpdateInput`

#### 引数 {#arguments-532}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationtimelineeventupdateid"></a>`id` | [`IncidentManagementTimelineEventID!`](#incidentmanagementtimelineeventid) | 更新するタイムラインイベントのID。 |
| <a id="mutationtimelineeventupdatenote"></a>`note` | [`String`](#string) | タイムラインイベントのテキストノート。 |
| <a id="mutationtimelineeventupdateoccurredat"></a>`occurredAt` | [`Time`](#time) | イベント発生時点のタイムスタンプ。 |
| <a id="mutationtimelineeventupdatetimelineeventtagnames"></a>`timelineEventTagNames` | [`[String!]`](#string) | インシデントタイムラインイベントのタグ。 |

#### フィールド {#fields-437}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationtimelineeventupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationtimelineeventupdatetimelineevent"></a>`timelineEvent` | [`TimelineEventType`](#timelineeventtype) | タイムラインイベント。 |

### `Mutation.timelogCreate` {#mutationtimelogcreate}

入力型: `TimelogCreateInput`

#### 引数 {#arguments-533}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtimelogcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationtimelogcreateissuableid"></a>`issuableId` | [`IssuableID!`](#issuableid) | issuable（イシュー、作業項目、またはマージリクエスト）のグローバルID。 |
| <a id="mutationtimelogcreatespentat"></a>`spentAt` | [`Time`](#time) | 時間が消費された時点のタイムスタンプ。空の場合、デフォルトは現在時刻です。 |
| <a id="mutationtimelogcreatesummary"></a>`summary` | [`String!`](#string) | 消費した時間の概要。 |
| <a id="mutationtimelogcreatetimespent"></a>`timeSpent` | [`String!`](#string) | 消費した時間。 |

#### フィールド {#fields-438}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtimelogcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationtimelogcreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationtimelogcreatetimelog"></a>`timelog` | [`Timelog`](#timelog) | 時間ログ。 |

### `Mutation.timelogDelete` {#mutationtimelogdelete}

入力型: `TimelogDeleteInput`

#### 引数 {#arguments-534}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtimelogdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationtimelogdeleteid"></a>`id` | [`TimelogID!`](#timelogid) | 時間ログのグローバルID。 |

#### フィールド {#fields-439}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtimelogdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationtimelogdeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationtimelogdeletetimelog"></a>`timelog` | [`Timelog`](#timelog) | 時間ログ。 |

### `Mutation.todoCreate` {#mutationtodocreate}

入力型: `TodoCreateInput`

#### 引数 {#arguments-535}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtodocreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationtodocreatetargetid"></a>`targetId` | [`TodoableID!`](#todoableid) | To Doアイテムの親のグローバルID。イシュー、マージリクエスト、デザイン、およびエピックがサポートされています。 |

#### フィールド {#fields-440}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtodocreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationtodocreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationtodocreatetodo"></a>`todo` | [`Todo`](#todo) | 作成されたTo Doアイテム。 |

### `Mutation.todoDeleteAllDone` {#mutationtododeletealldone}

{{< details >}} GitLab 17.11で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `TodoDeleteAllDoneInput`

#### 引数 {#arguments-536}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtododeletealldoneclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationtododeletealldoneupdatedbefore"></a>`updatedBefore` | [`Time`](#time) | タイムスタンプより前に完了としてマークされたTo-doアイテムは削除されます。 |

#### フィールド {#fields-441}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtododeletealldoneclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationtododeletealldoneerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.todoDeleteMany` {#mutationtododeletemany}

{{< details >}} GitLab 17.11で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `TodoDeleteManyInput`

#### 引数 {#arguments-537}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtododeletemanyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationtododeletemanyids"></a>`ids` | [`[TodoID!]!`](#todoid) | 処理するto-doアイテムのグローバルID（一度に最大100個までサポート）。 |

#### フィールド {#fields-442}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtododeletemanyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationtododeletemanyerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.todoMarkDone` {#mutationtodomarkdone}

入力型: `TodoMarkDoneInput`

#### 引数 {#arguments-538}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtodomarkdoneclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationtodomarkdoneid"></a>`id` | [`TodoID!`](#todoid) | 完了としてマークするTo DoアイテムのグローバルID。 |

#### フィールド {#fields-443}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtodomarkdoneclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationtodomarkdoneerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationtodomarkdonetodo"></a>`todo` | [`Todo!`](#todo) | リクエストされたTo Doアイテム。 |

### `Mutation.todoResolveMany` {#mutationtodoresolvemany}

{{< details >}}GitLab 17.9で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `TodoResolveManyInput`

#### 引数 {#arguments-539}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtodoresolvemanyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationtodoresolvemanyids"></a>`ids` | [`[TodoID!]!`](#todoid) | 処理するto-doアイテムのグローバルID（一度に最大100個までサポート）。 |

#### フィールド {#fields-444}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtodoresolvemanyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationtodoresolvemanyerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationtodoresolvemanytodos"></a>`todos` | [`[Todo!]!`](#todo) | 解決済みのto-doアイテム。 |

### `Mutation.todoRestore` {#mutationtodorestore}

入力型: `TodoRestoreInput`

#### 引数 {#arguments-540}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtodorestoreclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationtodorestoreid"></a>`id` | [`TodoID!`](#todoid) | 復元するTo DoアイテムのグローバルID。 |

#### フィールド {#fields-445}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtodorestoreclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationtodorestoreerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationtodorestoretodo"></a>`todo` | [`Todo!`](#todo) | リクエストされたTo Doアイテム。 |

### `Mutation.todoRestoreMany` {#mutationtodorestoremany}

入力型: `TodoRestoreManyInput`

#### 引数 {#arguments-541}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtodorestoremanyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationtodorestoremanyids"></a>`ids` | [`[TodoID!]!`](#todoid) | 処理するto-doアイテムのグローバルID（一度に最大100個までサポート）。 |

#### フィールド {#fields-446}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtodorestoremanyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationtodorestoremanyerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationtodorestoremanytodos"></a>`todos` | [`[Todo!]!`](#todo) | 復元されたto-doアイテム。 |

### `Mutation.todoSnooze` {#mutationtodosnooze}

{{< details >}}GitLab 17.4で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `TodoSnoozeInput`

#### 引数 {#arguments-542}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtodosnoozeclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationtodosnoozeid"></a>`id` | [`TodoID!`](#todoid) | スヌーズするTo DoアイテムのグローバルID。 |
| <a id="mutationtodosnoozesnoozeuntil"></a>`snoozeUntil` | [`Time!`](#time) | todoをスヌーズするまでの時間。 |

#### フィールド {#fields-447}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtodosnoozeclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationtodosnoozeerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationtodosnoozetodo"></a>`todo` | [`Todo!`](#todo) | リクエストされたTo Doアイテム。 |

### `Mutation.todoSnoozeMany` {#mutationtodosnoozemany}

{{< details >}}GitLab 17.9で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `TodoSnoozeManyInput`

#### 引数 {#arguments-543}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtodosnoozemanyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationtodosnoozemanyids"></a>`ids` | [`[TodoID!]!`](#todoid) | 処理するto-doアイテムのグローバルID（一度に最大100個までサポート）。 |
| <a id="mutationtodosnoozemanysnoozeuntil"></a>`snoozeUntil` | [`Time!`](#time) | todoをスヌーズするまでの時間。 |

#### フィールド {#fields-448}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtodosnoozemanyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationtodosnoozemanyerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationtodosnoozemanytodos"></a>`todos` | [`[Todo!]!`](#todo) | スヌーズされたto-doアイテム。 |

### `Mutation.todoUnSnooze` {#mutationtodounsnooze}

{{< details >}}GitLab 17.4で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `TodoUnSnoozeInput`

#### 引数 {#arguments-544}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtodounsnoozeclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationtodounsnoozeid"></a>`id` | [`TodoID!`](#todoid) | スヌーズするTo DoアイテムのグローバルID。 |

#### フィールド {#fields-449}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtodounsnoozeclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationtodounsnoozeerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationtodounsnoozetodo"></a>`todo` | [`Todo!`](#todo) | リクエストされたTo Doアイテム。 |

### `Mutation.todoUnsnoozeMany` {#mutationtodounsnoozemany}

{{< details >}}GitLab 17.9で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `TodoUnsnoozeManyInput`

#### 引数 {#arguments-545}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtodounsnoozemanyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationtodounsnoozemanyids"></a>`ids` | [`[TodoID!]!`](#todoid) | 処理するto-doアイテムのグローバルID（一度に最大100個までサポート）。 |

#### フィールド {#fields-450}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtodounsnoozemanyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationtodounsnoozemanyerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationtodounsnoozemanytodos"></a>`todos` | [`[Todo!]!`](#todo) | スヌーズ解除されたTo-Doアイテム。 |

### `Mutation.todosMarkAllDone` {#mutationtodosmarkalldone}

入力型: `TodosMarkAllDoneInput`

#### 引数 {#arguments-546}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtodosmarkalldoneaction"></a>`action` | [`[TodoActionEnum!]`](#todoactionenum) | フィルタリングするアクション。 |
| <a id="mutationtodosmarkalldoneauthorid"></a>`authorId` | [`[ID!]`](#id) | 作成者のID。 |
| <a id="mutationtodosmarkalldoneclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationtodosmarkalldonegroupid"></a>`groupId` | [`[ID!]`](#id) | グループのID。 |
| <a id="mutationtodosmarkalldoneprojectid"></a>`projectId` | [`[ID!]`](#id) | プロジェクトのID。 |
| <a id="mutationtodosmarkalldonetargetid"></a>`targetId` | [`TodoableID`](#todoableid) | To Doアイテムの親のグローバルID。イシュー、マージリクエスト、デザイン、およびエピックがサポートされています。引数が省略された場合、現在のユーザーの保留中のTo-Doアイテムはすべて完了としてマークされます。 |
| <a id="mutationtodosmarkalldonetype"></a>`type` | [`[TodoTargetEnum!]`](#todotargetenum) | todoのタイプ。 |

#### フィールド {#fields-451}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationtodosmarkalldoneclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationtodosmarkalldoneerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationtodosmarkalldonetodos"></a>`todos` | [`[Todo!]!`](#todo) | 更新されたTo-Doアイテム。 |

### `Mutation.unlinkProjectComplianceViolationIssue` {#mutationunlinkprojectcomplianceviolationissue}

{{< details >}}GitLab 18.3で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `UnlinkProjectComplianceViolationIssueInput`

#### 引数 {#arguments-547}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationunlinkprojectcomplianceviolationissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationunlinkprojectcomplianceviolationissueissueiid"></a>`issueIid` | [`String!`](#string) | リンクを解除するイシューのIID。 |
| <a id="mutationunlinkprojectcomplianceviolationissueprojectpath"></a>`projectPath` | [`ID!`](#id) | イシューが属するプロジェクトのフルパス。 |
| <a id="mutationunlinkprojectcomplianceviolationissueviolationid"></a>`violationId` | [`ComplianceManagementProjectsComplianceViolationID!`](#compliancemanagementprojectscomplianceviolationid) | プロジェクトコンプライアンス違反のグローバルID。 |

#### フィールド {#fields-452}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationunlinkprojectcomplianceviolationissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationunlinkprojectcomplianceviolationissueerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationunlinkprojectcomplianceviolationissueviolation"></a>`violation` | [`ProjectComplianceViolation`](#projectcomplianceviolation) | 更新されたプロジェクトのコンプライアンス違反。 |

### `Mutation.updateAbuseReportNote` {#mutationupdateabusereportnote}

{{< details >}}GitLab 17.5で**導入**されました。**状態**: 実験的機能。{{< /details >}}

不正行為レポートのノートを更新します。

入力型: `UpdateAbuseReportNoteInput`

#### 引数 {#arguments-548}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdateabusereportnotebody"></a>`body` | [`String!`](#string) | ノートの内容。 |
| <a id="mutationupdateabusereportnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdateabusereportnoteid"></a>`id` | [`AntiAbuseReportsNoteID!`](#antiabusereportsnoteid) | 更新するノートのグローバルID。 |

#### フィールド {#fields-453}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdateabusereportnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdateabusereportnoteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationupdateabusereportnotenote"></a>`note` | [`AbuseReportNote!`](#abusereportnote) | ミューテーション後の不正行為レポートノート。 |

### `Mutation.updateAlertStatus` {#mutationupdatealertstatus}

入力型: `UpdateAlertStatusInput`

#### 引数 {#arguments-549}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatealertstatusclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdatealertstatusiid"></a>`iid` | [`String!`](#string) | ミューテーション対象のアラートのID。 |
| <a id="mutationupdatealertstatusprojectpath"></a>`projectPath` | [`ID!`](#id) | ミューテーション対象のアラートの属するプロジェクト。 |
| <a id="mutationupdatealertstatusstatus"></a>`status` | [`AlertManagementStatus!`](#alertmanagementstatus) | アラートを設定するステータス。 |

#### フィールド {#fields-454}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatealertstatusalert"></a>`alert` | [`AlertManagementAlert`](#alertmanagementalert) | ミューテーション後のアラート。 |
| <a id="mutationupdatealertstatusclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdatealertstatuserrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationupdatealertstatusissue"></a>`issue` | [`Issue`](#issue) | ミューテーション後に作成されたイシュー。 |
| <a id="mutationupdatealertstatustodo"></a>`todo` | [`Todo`](#todo) | ミューテーション後のTo Doアイテム。 |

### `Mutation.updateBoard` {#mutationupdateboard}

入力型: `UpdateBoardInput`

#### 引数 {#arguments-550}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdateboardassigneeid"></a>`assigneeId` | [`UserID`](#userid) | ボードに割り当てるユーザーのID。 |
| <a id="mutationupdateboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdateboardhidebackloglist"></a>`hideBacklogList` | [`Boolean`](#boolean) | バックログリストを非表示にするかどうか。 |
| <a id="mutationupdateboardhideclosedlist"></a>`hideClosedList` | [`Boolean`](#boolean) | 完了リストを非表示にするかどうか。 |
| <a id="mutationupdateboardid"></a>`id` | [`BoardID!`](#boardid) | ボードのグローバルID。 |
| <a id="mutationupdateboarditerationcadenceid"></a>`iterationCadenceId` | [`IterationsCadenceID`](#iterationscadenceid) | ボードに割り当てるイテレーションの反復ID。 |
| <a id="mutationupdateboarditerationid"></a>`iterationId` | [`IterationID`](#iterationid) | ボードに割り当てるイテレーションのID。 |
| <a id="mutationupdateboardlabelids"></a>`labelIds` | [`[LabelID!]`](#labelid) | ボードに追加するラベルのID。 |
| <a id="mutationupdateboardlabels"></a>`labels` | [`[String!]`](#string) | イシューのラベル。 |
| <a id="mutationupdateboardmilestoneid"></a>`milestoneId` | [`MilestoneID`](#milestoneid) | ボードに割り当てるマイルストーンのID。 |
| <a id="mutationupdateboardname"></a>`name` | [`String`](#string) | ボード名。 |
| <a id="mutationupdateboardweight"></a>`weight` | [`Int`](#int) | ボードに割り当てるウェイト値。 |

#### フィールド {#fields-455}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdateboardboard"></a>`board` | [`Board`](#board) | ミューテーション後のボード。 |
| <a id="mutationupdateboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdateboarderrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.updateBoardEpicUserPreferences` {#mutationupdateboardepicuserpreferences}

{{< details >}}GitLab 17.5で**非推奨**になりました。WorkItem型に置き換えられました。{{< /details >}}

入力型: `UpdateBoardEpicUserPreferencesInput`

#### 引数 {#arguments-551}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdateboardepicuserpreferencesboardid"></a>`boardId` | [`BoardID!`](#boardid) | ボードのグローバルID。 |
| <a id="mutationupdateboardepicuserpreferencesclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdateboardepicuserpreferencescollapsed"></a>`collapsed` | [`Boolean!`](#boolean) | ボードでエピックを折りたたむかどうか。 |
| <a id="mutationupdateboardepicuserpreferencesepicid"></a>`epicId` | [`EpicID!`](#epicid) | プリファレンスを設定する対象となるエピックのID。 |

#### フィールド {#fields-456}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdateboardepicuserpreferencesclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdateboardepicuserpreferencesepicuserpreferences"></a>`epicUserPreferences` | [`BoardEpicUserPreferences`](#boardepicuserpreferences) | ミューテーション後のボードにおけるエピックのユーザープリファレンス。 |
| <a id="mutationupdateboardepicuserpreferenceserrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.updateBoardList` {#mutationupdateboardlist}

入力型: `UpdateBoardListInput`

#### 引数 {#arguments-552}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdateboardlistclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdateboardlistcollapsed"></a>`collapsed` | [`Boolean`](#boolean) | ユーザーに対してリストを折りたたむかどうかを示します。 |
| <a id="mutationupdateboardlistlistid"></a>`listId` | [`ListID!`](#listid) | リストのグローバルID。 |
| <a id="mutationupdateboardlistposition"></a>`position` | [`Int`](#int) | ボード内のリストの位置。 |

#### フィールド {#fields-457}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdateboardlistclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdateboardlisterrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationupdateboardlistlist"></a>`list` | [`BoardList`](#boardlist) | ミューテーション対象のリスト。 |

### `Mutation.updateComplianceFramework` {#mutationupdatecomplianceframework}

入力型: `UpdateComplianceFrameworkInput`

#### 引数 {#arguments-553}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatecomplianceframeworkclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdatecomplianceframeworkid"></a>`id` | [`ComplianceManagementFrameworkID!`](#compliancemanagementframeworkid) | 更新するコンプライアンスフレームワークのグローバルID。 |
| <a id="mutationupdatecomplianceframeworkparams"></a>`params` | [`ComplianceFrameworkInput!`](#complianceframeworkinput) | コンプライアンスフレームワークを更新するためのパラメータ。 |

#### フィールド {#fields-458}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatecomplianceframeworkclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdatecomplianceframeworkcomplianceframework"></a>`complianceFramework` | [`ComplianceFramework`](#complianceframework) | ミューテーション後のコンプライアンスフレームワーク。 |
| <a id="mutationupdatecomplianceframeworkerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.updateComplianceRequirement` {#mutationupdatecompliancerequirement}

{{< details >}}GitLab 17.7で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `UpdateComplianceRequirementInput`

#### 引数 {#arguments-554}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatecompliancerequirementclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdatecompliancerequirementcontrols"></a>`controls` | [`[ComplianceRequirementsControlInput!]`](#compliancerequirementscontrolinput) | コンプライアンス要件に追加または更新するコントロール。 |
| <a id="mutationupdatecompliancerequirementid"></a>`id` | [`ComplianceManagementComplianceFrameworkComplianceRequirementID!`](#compliancemanagementcomplianceframeworkcompliancerequirementid) | 更新するコンプライアンス要件のグローバルID。 |
| <a id="mutationupdatecompliancerequirementparams"></a>`params` | [`ComplianceRequirementInput!`](#compliancerequirementinput) | コンプライアンス要件を更新するためのパラメータ。 |

#### フィールド {#fields-459}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatecompliancerequirementclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdatecompliancerequirementerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationupdatecompliancerequirementrequirement"></a>`requirement` | [`ComplianceRequirement`](#compliancerequirement) | 更新後のコンプライアンス要件。 |

### `Mutation.updateComplianceRequirementsControl` {#mutationupdatecompliancerequirementscontrol}

{{< details >}}GitLab 17.9で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `UpdateComplianceRequirementsControlInput`

#### 引数 {#arguments-555}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatecompliancerequirementscontrolclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdatecompliancerequirementscontrolid"></a>`id` | [`ComplianceManagementComplianceFrameworkComplianceRequirementsControlID!`](#compliancemanagementcomplianceframeworkcompliancerequirementscontrolid) | 更新するコンプライアンス要件コントロールのグローバルID。 |
| <a id="mutationupdatecompliancerequirementscontrolparams"></a>`params` | [`ComplianceRequirementsControlInput!`](#compliancerequirementscontrolinput) | コンプライアンス要件コントロールを更新するためのパラメータ。 |

#### フィールド {#fields-460}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatecompliancerequirementscontrolclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdatecompliancerequirementscontrolerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationupdatecompliancerequirementscontrolrequirementscontrol"></a>`requirementsControl` | [`ComplianceRequirementsControl`](#compliancerequirementscontrol) | 更新後のコンプライアンス要件コントロール。 |

### `Mutation.updateContainerExpirationPolicy` {#mutationupdatecontainerexpirationpolicy}

入力型: `UpdateContainerExpirationPolicyInput`

#### 引数 {#arguments-556}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatecontainerexpirationpolicycadence"></a>`cadence` | [`ContainerExpirationPolicyCadenceEnum`](#containerexpirationpolicycadenceenum) | コンテナ有効期限ポリシーのスケジュール。 |
| <a id="mutationupdatecontainerexpirationpolicyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdatecontainerexpirationpolicyenabled"></a>`enabled` | [`Boolean`](#boolean) | コンテナ有効期限ポリシーが有効かどうかを示します。 |
| <a id="mutationupdatecontainerexpirationpolicykeepn"></a>`keepN` | [`ContainerExpirationPolicyKeepEnum`](#containerexpirationpolicykeepenum) | 保持するタグの数。 |
| <a id="mutationupdatecontainerexpirationpolicynameregex"></a>`nameRegex` | [`UntrustedRegexp`](#untrustedregexp) | 正規表現パターンに一致する名前のタグが有効期限切れになります。 |
| <a id="mutationupdatecontainerexpirationpolicynameregexkeep"></a>`nameRegexKeep` | [`UntrustedRegexp`](#untrustedregexp) | 正規表現パターンに一致する名前のタグが保持されます。 |
| <a id="mutationupdatecontainerexpirationpolicyolderthan"></a>`olderThan` | [`ContainerExpirationPolicyOlderThanEnum`](#containerexpirationpolicyolderthanenum) | 指定された期間より古いタグが有効期限切れになります。 |
| <a id="mutationupdatecontainerexpirationpolicyprojectpath"></a>`projectPath` | [`ID!`](#id) | コンテナ有効期限ポリシーが属するプロジェクトパス。 |

#### フィールド {#fields-461}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatecontainerexpirationpolicyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdatecontainerexpirationpolicycontainerexpirationpolicy"></a>`containerExpirationPolicy` {{< icon name="warning-solid" >}} | [`ContainerExpirationPolicy`](#containerexpirationpolicy) | **非推奨**: `container_tags_expiration_policy`を使用してください。GitLab 17.5で非推奨になりました。 |
| <a id="mutationupdatecontainerexpirationpolicycontainertagsexpirationpolicy"></a>`containerTagsExpirationPolicy` | [`ContainerTagsExpirationPolicy`](#containertagsexpirationpolicy) | ミューテーション後のコンテナタグ有効期限ポリシー。 |
| <a id="mutationupdatecontainerexpirationpolicyerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.updateContainerProtectionRepositoryRule` {#mutationupdatecontainerprotectionrepositoryrule}

ユーザーロールに基づいて、コンテナイメージを変更できるユーザーを制御するコンテナリポジトリ保護ルールを更新します。

入力型: `UpdateContainerProtectionRepositoryRuleInput`

#### 引数 {#arguments-557}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatecontainerprotectionrepositoryruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdatecontainerprotectionrepositoryruleid"></a>`id` | [`ContainerRegistryProtectionRuleID!`](#containerregistryprotectionruleid) | 更新するコンテナリポジトリ保護ルールのグローバルID。 |
| <a id="mutationupdatecontainerprotectionrepositoryruleminimumaccesslevelfordelete"></a>`minimumAccessLevelForDelete` | [`ContainerProtectionRepositoryRuleAccessLevel`](#containerprotectionrepositoryruleaccesslevel) | コンテナリポジトリからコンテナイメージを削除するために必要な最小GitLabアクセスレベル。有効な値には`MAINTAINER`、`OWNER`、または`ADMIN`が含まれます。値が`nil`の場合のデフォルトの最小アクセスレベルは`DEVELOPER`です。 |
| <a id="mutationupdatecontainerprotectionrepositoryruleminimumaccesslevelforpush"></a>`minimumAccessLevelForPush` | [`ContainerProtectionRepositoryRuleAccessLevel`](#containerprotectionrepositoryruleaccesslevel) | コンテナイメージをコンテナリポジトリにプッシュするために必要な最小GitLabアクセスレベル。有効な値には`MAINTAINER`、`OWNER`、または`ADMIN`が含まれます。値が`nil`の場合のデフォルトの最小アクセスレベルは`DEVELOPER`です。 |
| <a id="mutationupdatecontainerprotectionrepositoryrulerepositorypathpattern"></a>`repositoryPathPattern` | [`String`](#string) | 保護ルールによって保護されるコンテナリポジトリパスパターン。先頭がプロジェクトのフルパスでなければなりません。例: `my-project/*-prod-*`。ワイルドカード文字`*`は、プロジェクトのフルパスの後なら、どこにでも使用できます。 |

#### フィールド {#fields-462}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatecontainerprotectionrepositoryruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdatecontainerprotectionrepositoryrulecontainerprotectionrepositoryrule"></a>`containerProtectionRepositoryRule` | [`ContainerProtectionRepositoryRule`](#containerprotectionrepositoryrule) | ミューテーション後のコンテナリポジトリ保護ルール。 |
| <a id="mutationupdatecontainerprotectionrepositoryruleerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.updateContainerProtectionTagRule` {#mutationupdatecontainerprotectiontagrule}

{{< details >}}GitLab 17.8で**導入**されました。**状態**: 実験的機能。{{< /details >}}

指定されたパターンに一致するコンテナイメージタグを変更できるユーザーロールを制御する保護ルールを更新します。

入力型: `UpdateContainerProtectionTagRuleInput`

#### 引数 {#arguments-558}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatecontainerprotectiontagruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdatecontainerprotectiontagruleid"></a>`id` | [`ContainerRegistryProtectionTagRuleID!`](#containerregistryprotectiontagruleid) | 更新するタグ保護ルールのグローバルID。 |
| <a id="mutationupdatecontainerprotectiontagruleminimumaccesslevelfordelete"></a>`minimumAccessLevelForDelete` {{< icon name="warning-solid" >}} | [`ContainerProtectionTagRuleAccessLevel`](#containerprotectiontagruleaccesslevel) | **非推奨**: **状態**: 実験的機能。GitLab 17.8で導入されました。 |
| <a id="mutationupdatecontainerprotectiontagruleminimumaccesslevelforpush"></a>`minimumAccessLevelForPush` {{< icon name="warning-solid" >}} | [`ContainerProtectionTagRuleAccessLevel`](#containerprotectiontagruleaccesslevel) | **非推奨**: **状態**: 実験的機能。GitLab 17.8で導入されました。 |
| <a id="mutationupdatecontainerprotectiontagruletagnamepattern"></a>`tagNamePattern` {{< icon name="warning-solid" >}} | [`String`](#string) | **非推奨**: **状態**: 実験的機能。GitLab 17.8で導入されました。 |

#### フィールド {#fields-463}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatecontainerprotectiontagruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdatecontainerprotectiontagrulecontainerprotectiontagrule"></a>`containerProtectionTagRule` {{< icon name="warning-solid" >}} | [`ContainerProtectionTagRule`](#containerprotectiontagrule) | **非推奨**: **状態**: 実験的機能。GitLab 17.8で導入されました。 |
| <a id="mutationupdatecontainerprotectiontagruleerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.updateDependencyProxyImageTtlGroupPolicy` {#mutationupdatedependencyproxyimagettlgrouppolicy}

これらの設定を調整できるのはグループのオーナーだけです。

入力型: `UpdateDependencyProxyImageTtlGroupPolicyInput`

#### 引数 {#arguments-559}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatedependencyproxyimagettlgrouppolicyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdatedependencyproxyimagettlgrouppolicyenabled"></a>`enabled` | [`Boolean`](#boolean) | ポリシーが有効か無効かを示します。 |
| <a id="mutationupdatedependencyproxyimagettlgrouppolicygrouppath"></a>`groupPath` | [`ID!`](#id) | グループ依存プロキシイメージTTLポリシーのグループパス。 |
| <a id="mutationupdatedependencyproxyimagettlgrouppolicyttl"></a>`ttl` | [`Int`](#int) | キャッシュに入れられたイメージファイルを保持する日数。 |

#### フィールド {#fields-464}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatedependencyproxyimagettlgrouppolicyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdatedependencyproxyimagettlgrouppolicydependencyproxyimagettlpolicy"></a>`dependencyProxyImageTtlPolicy` | [`DependencyProxyImageTtlGroupPolicy`](#dependencyproxyimagettlgrouppolicy) | ミューテーション後のグループイメージTTLポリシー。 |
| <a id="mutationupdatedependencyproxyimagettlgrouppolicyerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.updateDependencyProxyPackagesSettings` {#mutationupdatedependencyproxypackagessettings}

パッケージの設定に関する依存プロキシを更新または作成します。設定でパッケージと依存プロキシを有効にする必要があります。プロジェクトレベルでパッケージ機能を有効にする必要があります。

入力型: `UpdateDependencyProxyPackagesSettingsInput`

#### 引数 {#arguments-560}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatedependencyproxypackagessettingsclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdatedependencyproxypackagessettingsenabled"></a>`enabled` | [`Boolean`](#boolean) | プロジェクトでパッケージの依存プロキシが有効かどうかを示します。 |
| <a id="mutationupdatedependencyproxypackagessettingsmavenexternalregistrypassword"></a>`mavenExternalRegistryPassword` | [`String`](#string) | 外部Mavenパッケージレジストリのパスワード。16.5で導入されました。これは実験的機能です。予告なく変更または削除されることがあります。 |
| <a id="mutationupdatedependencyproxypackagessettingsmavenexternalregistryurl"></a>`mavenExternalRegistryUrl` | [`String`](#string) | 外部MavenパッケージレジストリのURL。 |
| <a id="mutationupdatedependencyproxypackagessettingsmavenexternalregistryusername"></a>`mavenExternalRegistryUsername` | [`String`](#string) | 外部Mavenパッケージレジストリのユーザー名。 |
| <a id="mutationupdatedependencyproxypackagessettingsprojectpath"></a>`projectPath` | [`ID!`](#id) | パッケージ設定の依存プロキシのプロジェクトパス。 |

#### フィールド {#fields-465}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatedependencyproxypackagessettingsclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdatedependencyproxypackagessettingsdependencyproxypackagessetting"></a>`dependencyProxyPackagesSetting` | [`DependencyProxyPackagesSetting`](#dependencyproxypackagessetting) | ミューテーション後のパッケージ設定の依存プロキシ。 |
| <a id="mutationupdatedependencyproxypackagessettingserrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.updateDependencyProxySettings` {#mutationupdatedependencyproxysettings}

これらの設定を調整できるのはグループのオーナーだけです。

入力型: `UpdateDependencyProxySettingsInput`

#### 引数 {#arguments-561}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatedependencyproxysettingsclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdatedependencyproxysettingsenabled"></a>`enabled` | [`Boolean`](#boolean) | ポリシーが有効か無効かを示します。 |
| <a id="mutationupdatedependencyproxysettingsgrouppath"></a>`groupPath` | [`ID!`](#id) | グループ依存プロキシのグループパス。 |
| <a id="mutationupdatedependencyproxysettingsidentity"></a>`identity` | [`String`](#string) | イメージをプルする際にDocker Hubで認証するために使用されるID認証情報。ユーザー名（パスワードまたはパーソナルアクセストークン（PAT）の場合）、または組織名（組織アクセストークン（OAT）の場合）を指定できます。 |
| <a id="mutationupdatedependencyproxysettingssecret"></a>`secret` | [`String`](#string) | イメージをプルする際にDocker Hubで認証するために使用されるシークレット認証情報。パスワード、パーソナルアクセストークン（PAT）、または組織アクセストークン（OAT）を指定できます。 |

#### フィールド {#fields-466}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatedependencyproxysettingsclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdatedependencyproxysettingsdependencyproxysetting"></a>`dependencyProxySetting` | [`DependencyProxySetting`](#dependencyproxysetting) | ミューテーション後のグループ依存プロキシ設定。 |
| <a id="mutationupdatedependencyproxysettingserrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.updateEpic` {#mutationupdateepic}

{{< details >}}GitLab 17.5で**非推奨**になりました。`WorkItem`型に置き換えられました。詳細については、[移行ガイド](https://docs.gitlab.com/api/graphql/epic_work_items_api_migration_guide/)を参照してください。{{< /details >}}

入力型: `UpdateEpicInput`

#### 引数 {#arguments-562}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdateepicaddlabelids"></a>`addLabelIds` | [`[ID!]`](#id) | エピックに追加するラベルのID。 |
| <a id="mutationupdateepicaddlabels"></a>`addLabels` | [`[String!]`](#string) | エピックに追加するラベルの配列。 |
| <a id="mutationupdateepicclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdateepiccolor"></a>`color` | [`Color`](#color) | エピックの色。 |
| <a id="mutationupdateepicconfidential"></a>`confidential` | [`Boolean`](#boolean) | エピックが機密かどうかを示します。 |
| <a id="mutationupdateepicdescription"></a>`description` | [`String`](#string) | エピックの説明。 |
| <a id="mutationupdateepicduedatefixed"></a>`dueDateFixed` | [`String`](#string) | エピックの終了日。 |
| <a id="mutationupdateepicduedateisfixed"></a>`dueDateIsFixed` | [`Boolean`](#boolean) | 終了日をイシューのマイルストーンではなく、due_date_fixedフィールドから取得することを示します。 |
| <a id="mutationupdateepicgrouppath"></a>`groupPath` | [`ID!`](#id) | ミューテーション対象のエピックの属するグループ。 |
| <a id="mutationupdateepiciid"></a>`iid` | [`ID!`](#id) | ミューテーション対象のエピックのIID。 |
| <a id="mutationupdateepicremovelabelids"></a>`removeLabelIds` | [`[ID!]`](#id) | エピックから削除するラベルのID。 |
| <a id="mutationupdateepicremovelabels"></a>`removeLabels` | [`[String!]`](#string) | エピックから削除するラベルの配列。 |
| <a id="mutationupdateepicstartdatefixed"></a>`startDateFixed` | [`String`](#string) | エピックの開始日。 |
| <a id="mutationupdateepicstartdateisfixed"></a>`startDateIsFixed` | [`Boolean`](#boolean) | 開始日をイシューのマイルストーンではなく、start_date_fixedフィールドから取得することを示します。 |
| <a id="mutationupdateepicstateevent"></a>`stateEvent` | [`EpicStateEvent`](#epicstateevent) | エピックの状態イベント。 |
| <a id="mutationupdateepictitle"></a>`title` | [`String`](#string) | エピックのタイトル。 |

#### フィールド {#fields-467}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdateepicclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdateepicepic"></a>`epic` | [`Epic`](#epic) | ミューテーション後のエピック。 |
| <a id="mutationupdateepicerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.updateEpicBoardList` {#mutationupdateepicboardlist}

{{< details >}}GitLab 17.5で**非推奨**になりました。WorkItem型に置き換えられました。{{< /details >}}

入力型: `UpdateEpicBoardListInput`

#### 引数 {#arguments-563}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdateepicboardlistclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdateepicboardlistcollapsed"></a>`collapsed` | [`Boolean`](#boolean) | ユーザーに対してリストを折りたたむかどうかを示します。 |
| <a id="mutationupdateepicboardlistlistid"></a>`listId` | [`BoardsEpicListID!`](#boardsepiclistid) | エピックリストのグローバルID。 |
| <a id="mutationupdateepicboardlistposition"></a>`position` | [`Int`](#int) | ボード内のリストの位置。 |

#### フィールド {#fields-468}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdateepicboardlistclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdateepicboardlisterrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationupdateepicboardlistlist"></a>`list` | [`EpicList`](#epiclist) | ミューテーション対象のエピックリスト。 |

### `Mutation.updateImageDiffNote` {#mutationupdateimagediffnote}

イメージ上のDiffNote（`position.positionType`が`"image"`である`Note`）を更新します。ノートの本文に含まれるのがクイックアクションだけの場合、更新時にノートが削除され、ノートは返されません。

入力型: `UpdateImageDiffNoteInput`

#### 引数 {#arguments-564}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdateimagediffnotebody"></a>`body` | [`String`](#string) | ノートの内容。 |
| <a id="mutationupdateimagediffnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdateimagediffnoteid"></a>`id` | [`NoteID!`](#noteid) | 更新するノートのグローバルID。 |
| <a id="mutationupdateimagediffnoteposition"></a>`position` | [`UpdateDiffImagePositionInput`](#updatediffimagepositioninput) | 差分に関するノートの位置。 |

#### フィールド {#fields-469}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdateimagediffnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdateimagediffnoteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationupdateimagediffnotenote"></a>`note` | [`Note`](#note) | ミューテーション後のノート。 |
| <a id="mutationupdateimagediffnotequickactionsstatus"></a>`quickActionsStatus` | [`QuickActionsStatus`](#quickactionsstatus) | ミューテーション後のクイックアクションのステータス。 |

### `Mutation.updateIssue` {#mutationupdateissue}

入力型: `UpdateIssueInput`

#### 引数 {#arguments-565}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdateissueaddlabelids"></a>`addLabelIds` | [`[ID!]`](#id) | イシューに追加するラベルのID。 |
| <a id="mutationupdateissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdateissueconfidential"></a>`confidential` | [`Boolean`](#boolean) | イシューが機密であることを示します。 |
| <a id="mutationupdateissuedescription"></a>`description` | [`String`](#string) | イシューの説明。 |
| <a id="mutationupdateissueduedate"></a>`dueDate` | [`ISO8601Date`](#iso8601date) | イシューの期限。 |
| <a id="mutationupdateissueepicid"></a>`epicId` {{< icon name="warning-solid" >}} | [`EpicID`](#epicid) | **非推奨**: これはWorkItem hierarchyWidgetに置き換えられる予定です。GitLab 17.5で非推奨になりました。 |
| <a id="mutationupdateissuehealthstatus"></a>`healthStatus` | [`HealthStatus`](#healthstatus) | 目的のヘルスステータス。 |
| <a id="mutationupdateissueiid"></a>`iid` | [`String!`](#string) | ミューテーション対象のイシューのIID。 |
| <a id="mutationupdateissuelabelids"></a>`labelIds` | [`[ID!]`](#id) | 設定するラベルのID。既存のイシューラベルを置き換えます。 |
| <a id="mutationupdateissuelocked"></a>`locked` | [`Boolean`](#boolean) | イシューでディスカッションがロックされていることを示します。 |
| <a id="mutationupdateissuemilestoneid"></a>`milestoneId` | [`ID`](#id) | イシューに割り当てるマイルストーンのID。nullに設定すると、更新時にマイルストーンが削除されます。 |
| <a id="mutationupdateissueprojectpath"></a>`projectPath` | [`ID!`](#id) | ミューテーション対象のイシューの属するプロジェクト。 |
| <a id="mutationupdateissueremovelabelids"></a>`removeLabelIds` | [`[ID!]`](#id) | イシューから削除するラベルのID。 |
| <a id="mutationupdateissuestateevent"></a>`stateEvent` | [`IssueStateEvent`](#issuestateevent) | イシューを完了または再オープンします。 |
| <a id="mutationupdateissuetimeestimate"></a>`timeEstimate` | [`String`](#string) | イシュー完了にかかる推定時間。`null`または`0`を使用すると、現在の推定値が削除されます。 |
| <a id="mutationupdateissuetitle"></a>`title` | [`String`](#string) | イシューのタイトル。 |
| <a id="mutationupdateissuetype"></a>`type` | [`IssueType`](#issuetype) | イシューのタイプ。 |
| <a id="mutationupdateissueweight"></a>`weight` | [`Int`](#int) | イシューのウェイト。 |

#### フィールド {#fields-470}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdateissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdateissueerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationupdateissueissue"></a>`issue` | [`Issue`](#issue) | ミューテーション後のイシュー。 |

### `Mutation.updateIteration` {#mutationupdateiteration}

入力型: `UpdateIterationInput`

#### 引数 {#arguments-566}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdateiterationclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdateiterationdescription"></a>`description` | [`String`](#string) | イテレーションの説明。 |
| <a id="mutationupdateiterationduedate"></a>`dueDate` | [`String`](#string) | イテレーションの終了日。 |
| <a id="mutationupdateiterationgrouppath"></a>`groupPath` | [`ID!`](#id) | イテレーションのグループ。 |
| <a id="mutationupdateiterationid"></a>`id` | [`ID!`](#id) | イテレーションのグローバルID。 |
| <a id="mutationupdateiterationstartdate"></a>`startDate` | [`String`](#string) | イテレーションの開始日。 |
| <a id="mutationupdateiterationtitle"></a>`title` | [`String`](#string) | イテレーションのタイトル。 |

#### フィールド {#fields-471}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdateiterationclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdateiterationerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationupdateiterationiteration"></a>`iteration` | [`Iteration`](#iteration) | 更新されたイテレーション。 |

### `Mutation.updateNamespacePackageSettings` {#mutationupdatenamespacepackagesettings}

これらの設定を調整できるのはグループのオーナーだけです。

入力型: `UpdateNamespacePackageSettingsInput`

#### 引数 {#arguments-567}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatenamespacepackagesettingsauditeventsenabled"></a>`auditEventsEnabled` | [`Boolean`](#boolean) | ネームスペースのパッケージを公開または削除する際に、監査イベントを作成するかどうかを示します（PremiumとUltimateのみ）。 |
| <a id="mutationupdatenamespacepackagesettingsclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdatenamespacepackagesettingsgenericduplicateexceptionregex"></a>`genericDuplicateExceptionRegex` | [`UntrustedRegexp`](#untrustedregexp) | generic_duplicates_allowedがfalseの場合、この正規表現に一致する名前の重複パッケージを公開できます。それ以外の場合、この設定は無効です。 |
| <a id="mutationupdatenamespacepackagesettingsgenericduplicatesallowed"></a>`genericDuplicatesAllowed` | [`Boolean`](#boolean) | ネームスペースで汎用パッケージの重複を許可するかどうかを示します。 |
| <a id="mutationupdatenamespacepackagesettingslockmavenpackagerequestsforwarding"></a>`lockMavenPackageRequestsForwarding` | [`Boolean`](#boolean) | すべての子孫ネームスペースに対してMavenパッケージの転送がロックされるかどうかを示します。 |
| <a id="mutationupdatenamespacepackagesettingslocknpmpackagerequestsforwarding"></a>`lockNpmPackageRequestsForwarding` | [`Boolean`](#boolean) | すべての子孫ネームスペースに対してnpmパッケージの転送がロックされるかどうかを示します。 |
| <a id="mutationupdatenamespacepackagesettingslockpypipackagerequestsforwarding"></a>`lockPypiPackageRequestsForwarding` | [`Boolean`](#boolean) | すべての子孫ネームスペースに対してPyPIパッケージの転送がロックされるかどうかを示します。 |
| <a id="mutationupdatenamespacepackagesettingsmavenduplicateexceptionregex"></a>`mavenDuplicateExceptionRegex` | [`UntrustedRegexp`](#untrustedregexp) | maven_duplicates_allowedがfalseの場合、この正規表現に一致する名前の重複パッケージを公開できます。それ以外の場合、この設定は無効です。 |
| <a id="mutationupdatenamespacepackagesettingsmavenduplicatesallowed"></a>`mavenDuplicatesAllowed` | [`Boolean`](#boolean) | ネームスペースでMavenパッケージの重複を許可するかどうかを示します。 |
| <a id="mutationupdatenamespacepackagesettingsmavenpackagerequestsforwarding"></a>`mavenPackageRequestsForwarding` | [`Boolean`](#boolean) | ネームスペースでMavenパッケージの転送を許可するかどうかを示します。 |
| <a id="mutationupdatenamespacepackagesettingsnamespacepath"></a>`namespacePath` | [`ID!`](#id) | ネームスペースパッケージの設定が属するネームスペースパス。 |
| <a id="mutationupdatenamespacepackagesettingsnpmpackagerequestsforwarding"></a>`npmPackageRequestsForwarding` | [`Boolean`](#boolean) | ネームスペースでnpmパッケージの転送を許可するかどうかを示します。 |
| <a id="mutationupdatenamespacepackagesettingsnugetduplicateexceptionregex"></a>`nugetDuplicateExceptionRegex` | [`UntrustedRegexp`](#untrustedregexp) | nuget_duplicates_allowedがfalseの場合、この正規表現に一致する名前の重複パッケージを公開できます。それ以外の場合、この設定は無効です。 |
| <a id="mutationupdatenamespacepackagesettingsnugetduplicatesallowed"></a>`nugetDuplicatesAllowed` | [`Boolean`](#boolean) | ネームスペースでNuGetパッケージの重複を許可するかどうかを示します。 |
| <a id="mutationupdatenamespacepackagesettingsnugetsymbolserverenabled"></a>`nugetSymbolServerEnabled` | [`Boolean`](#boolean) | ネームスペースでNuGetシンボルサーバーが有効かどうかを示します。 |
| <a id="mutationupdatenamespacepackagesettingspypipackagerequestsforwarding"></a>`pypiPackageRequestsForwarding` | [`Boolean`](#boolean) | ネームスペースでPyPIパッケージの転送を許可するかどうかを示します。 |
| <a id="mutationupdatenamespacepackagesettingsterraformmoduleduplicateexceptionregex"></a>`terraformModuleDuplicateExceptionRegex` | [`UntrustedRegexp`](#untrustedregexp) | terraform_module_duplicates_allowedがfalseの場合、この正規表現に一致する名前の重複パッケージを公開できます。それ以外の場合、この設定は無効です。 |
| <a id="mutationupdatenamespacepackagesettingsterraformmoduleduplicatesallowed"></a>`terraformModuleDuplicatesAllowed` | [`Boolean`](#boolean) | ネームスペースでTerraformパッケージの重複を許可するかどうかを示します。 |

#### フィールド {#fields-472}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatenamespacepackagesettingsclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdatenamespacepackagesettingserrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationupdatenamespacepackagesettingspackagesettings"></a>`packageSettings` | [`PackageSettings`](#packagesettings) | ミューテーション後のネームスペースパッケージ設定。 |

### `Mutation.updateNote` {#mutationupdatenote}

ノートを更新します。ノートの本文に含まれるのがクイックアクションだけの場合、更新時にノートが削除され、ノートは返されません。

入力型: `UpdateNoteInput`

#### 引数 {#arguments-568}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatenotebody"></a>`body` | [`String`](#string) | ノートの内容。 |
| <a id="mutationupdatenoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdatenoteid"></a>`id` | [`NoteID!`](#noteid) | 更新するノートのグローバルID。 |

#### フィールド {#fields-473}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatenoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdatenoteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationupdatenotenote"></a>`note` | [`Note`](#note) | ミューテーション後のノート。 |
| <a id="mutationupdatenotequickactionsstatus"></a>`quickActionsStatus` | [`QuickActionsStatus`](#quickactionsstatus) | ミューテーション後のクイックアクションのステータス。 |

### `Mutation.updatePackagesCleanupPolicy` {#mutationupdatepackagescleanuppolicy}

入力型: `UpdatePackagesCleanupPolicyInput`

#### 引数 {#arguments-569}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatepackagescleanuppolicyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdatepackagescleanuppolicykeepnduplicatedpackagefiles"></a>`keepNDuplicatedPackageFiles` | [`PackagesCleanupKeepDuplicatedPackageFilesEnum`](#packagescleanupkeepduplicatedpackagefilesenum) | 保持する重複パッケージファイルの数。 |
| <a id="mutationupdatepackagescleanuppolicyprojectpath"></a>`projectPath` | [`ID!`](#id) | パッケージクリーンアップポリシーの属するプロジェクトパス。 |

#### フィールド {#fields-474}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatepackagescleanuppolicyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdatepackagescleanuppolicyerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationupdatepackagescleanuppolicypackagescleanuppolicy"></a>`packagesCleanupPolicy` | [`PackagesCleanupPolicy`](#packagescleanuppolicy) | ミューテーション後のパッケージクリーンアップポリシー。 |

### `Mutation.updatePackagesProtectionRule` {#mutationupdatepackagesprotectionrule}

プロジェクトパッケージへのアクセスを制限するよう、パッケージ保護ルールを更新します。特定の権限のないユーザーがパッケージを変更できないようにすることができます。

入力型: `UpdatePackagesProtectionRuleInput`

#### 引数 {#arguments-570}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatepackagesprotectionruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdatepackagesprotectionruleid"></a>`id` | [`PackagesProtectionRuleID!`](#packagesprotectionruleid) | 更新するパッケージ保護ルールのグローバルID。 |
| <a id="mutationupdatepackagesprotectionruleminimumaccesslevelfordelete"></a>`minimumAccessLevelForDelete` {{< icon name="warning-solid" >}} | [`PackagesProtectionRuleAccessLevelForDelete`](#packagesprotectionruleaccesslevelfordelete) | **非推奨**: **状態**: 実験的機能。GitLab 17.10で導入されました。 |
| <a id="mutationupdatepackagesprotectionruleminimumaccesslevelforpush"></a>`minimumAccessLevelForPush` | [`PackagesProtectionRuleAccessLevel`](#packagesprotectionruleaccesslevel) | パッケージをパッケージレジストリにプッシュするために必要な最小GitLabアクセスレベル。有効な値には`MAINTAINER`、`OWNER`、または`ADMIN`が含まれます。値が`nil`の場合のデフォルトの最小アクセスレベルは`DEVELOPER`です。 |
| <a id="mutationupdatepackagesprotectionrulepackagenamepattern"></a>`packageNamePattern` | [`String`](#string) | 保護ルールによって保護されるパッケージ名。例: `@my-scope/my-package-*`。ワイルドカード文字`*`を使用できます。 |
| <a id="mutationupdatepackagesprotectionrulepackagetype"></a>`packageType` | [`PackagesProtectionRulePackageType`](#packagesprotectionrulepackagetype) | 保護ルールによって保護されるパッケージのタイプ。例: `NPM`、`PYPI`。 |

#### フィールド {#fields-475}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatepackagesprotectionruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdatepackagesprotectionruleerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationupdatepackagesprotectionrulepackageprotectionrule"></a>`packageProtectionRule` | [`PackagesProtectionRule`](#packagesprotectionrule) | ミューテーション後のパッケージ保護ルール。 |

### `Mutation.updateProjectComplianceViolation` {#mutationupdateprojectcomplianceviolation}

{{< details >}}GitLab 18.2で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `UpdateProjectComplianceViolationInput`

#### 引数 {#arguments-571}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdateprojectcomplianceviolationclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdateprojectcomplianceviolationid"></a>`id` | [`ComplianceManagementProjectsComplianceViolationID!`](#compliancemanagementprojectscomplianceviolationid) | 更新するプロジェクトのコンプライアンス違反のグローバルID。 |
| <a id="mutationupdateprojectcomplianceviolationstatus"></a>`status` | [`ComplianceViolationStatus!`](#complianceviolationstatus) | プロジェクトのコンプライアンス違反の新しいステータス。 |

#### フィールド {#fields-476}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdateprojectcomplianceviolationclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdateprojectcomplianceviolationcomplianceviolation"></a>`complianceViolation` | [`ProjectComplianceViolation`](#projectcomplianceviolation) | ステータスの更新後のコンプライアンス違反。 |
| <a id="mutationupdateprojectcomplianceviolationerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.updateRequirement` {#mutationupdaterequirement}

入力型: `UpdateRequirementInput`

#### 引数 {#arguments-572}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdaterequirementclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdaterequirementdescription"></a>`description` | [`String`](#string) | 要件の説明。 |
| <a id="mutationupdaterequirementiid"></a>`iid` {{< icon name="warning-solid" >}} | [`String`](#string) | **非推奨**: 代わりにwork_item_iidを使用してください。GitLab 15.8で非推奨になりました。 |
| <a id="mutationupdaterequirementlasttestreportstate"></a>`lastTestReportState` | [`TestReportState`](#testreportstate) | 指定された状態の要求事項のテストレポートを作成します。 |
| <a id="mutationupdaterequirementprojectpath"></a>`projectPath` | [`ID!`](#id) | 要件が関連付けられているプロジェクトのフルパス。 |
| <a id="mutationupdaterequirementstate"></a>`state` | [`RequirementState`](#requirementstate) | 要求事項の状態。 |
| <a id="mutationupdaterequirementtitle"></a>`title` | [`String`](#string) | 要件のタイトル。 |
| <a id="mutationupdaterequirementworkitemiid"></a>`workItemIid` | [`String`](#string) | 更新する要求事項作業アイテムのIID。 |

#### フィールド {#fields-477}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdaterequirementclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdaterequirementerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationupdaterequirementrequirement"></a>`requirement` | [`Requirement`](#requirement) | ミューテーション後の要求事項。 |

### `Mutation.updateSnippet` {#mutationupdatesnippet}

入力型: `UpdateSnippetInput`

#### 引数 {#arguments-573}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatesnippetblobactions"></a>`blobActions` | [`[SnippetBlobActionInputType!]`](#snippetblobactioninputtype) | スニペットリポジトリとblobに対して実行するアクション。 |
| <a id="mutationupdatesnippetclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdatesnippetdescription"></a>`description` | [`String`](#string) | スニペットの説明。 |
| <a id="mutationupdatesnippetid"></a>`id` | [`SnippetID!`](#snippetid) | 更新するスニペットのグローバルID。 |
| <a id="mutationupdatesnippettitle"></a>`title` | [`String`](#string) | スニペットのタイトル。 |
| <a id="mutationupdatesnippetvisibilitylevel"></a>`visibilityLevel` | [`VisibilityLevelsEnum`](#visibilitylevelsenum) | スニペットの表示レベル。 |

#### フィールド {#fields-478}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationupdatesnippetclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationupdatesnippeterrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationupdatesnippetsnippet"></a>`snippet` | [`Snippet`](#snippet) | ミューテーション後のスニペット。 |

### `Mutation.uploadDelete` {#mutationuploaddelete}

アップロードを削除します。

入力型: `UploadDeleteInput`

#### 引数 {#arguments-574}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationuploaddeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationuploaddeletefilename"></a>`filename` | [`String!`](#string) | アップロードファイル名。 |
| <a id="mutationuploaddeletegrouppath"></a>`groupPath` | [`ID`](#id) | リソースが関連付けられているグループのフルパス。 |
| <a id="mutationuploaddeleteprojectpath"></a>`projectPath` | [`ID`](#id) | リソースが関連付けられているプロジェクトのフルパス。 |
| <a id="mutationuploaddeletesecret"></a>`secret` | [`String!`](#string) | アップロードパスのシークレット部分。 |

#### フィールド {#fields-479}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationuploaddeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationuploaddeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationuploaddeleteupload"></a>`upload` | [`FileUpload`](#fileupload) | 削除されたアップロード。 |

### `Mutation.userAchievementPrioritiesUpdate` {#mutationuserachievementprioritiesupdate}

{{< details >}}GitLab 16.5で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `UserAchievementPrioritiesUpdateInput`

#### 引数 {#arguments-575}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationuserachievementprioritiesupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationuserachievementprioritiesupdateuserachievementids"></a>`userAchievementIds` | [`[AchievementsUserAchievementID!]!`](#achievementsuserachievementid) | 優先順位付けし、優先順位最高のものから順に並べたユーザーアチーブメントのグローバルID。 |

#### フィールド {#fields-480}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationuserachievementprioritiesupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationuserachievementprioritiesupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationuserachievementprioritiesupdateuserachievements"></a>`userAchievements` | [`[UserAchievement!]!`](#userachievement) | 更新されたユーザーアチーブメント。 |

### `Mutation.userAchievementsDelete` {#mutationuserachievementsdelete}

{{< details >}}GitLab 16.1で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `UserAchievementsDeleteInput`

#### 引数 {#arguments-576}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationuserachievementsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationuserachievementsdeleteuserachievementid"></a>`userAchievementId` | [`AchievementsUserAchievementID!`](#achievementsuserachievementid) | 削除するユーザーアチーブメントのグローバルID。 |

#### フィールド {#fields-481}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationuserachievementsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationuserachievementsdeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationuserachievementsdeleteuserachievement"></a>`userAchievement` | [`UserAchievement`](#userachievement) | 削除されたユーザーアチーブメント。 |

### `Mutation.userAchievementsUpdate` {#mutationuserachievementsupdate}

{{< details >}}GitLab 17.3で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `UserAchievementsUpdateInput`

#### 引数 {#arguments-577}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationuserachievementsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationuserachievementsupdateshowonprofile"></a>`showOnProfile` | [`Boolean!`](#boolean) | ユーザーアチーブメントがプロフィールに表示されるかどうかを示します。 |
| <a id="mutationuserachievementsupdateuserachievementid"></a>`userAchievementId` | [`AchievementsUserAchievementID!`](#achievementsuserachievementid) | 更新するユーザーアチーブメントのグローバルID。 |

#### フィールド {#fields-482}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationuserachievementsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationuserachievementsupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationuserachievementsupdateuserachievement"></a>`userAchievement` | [`UserAchievement`](#userachievement) | アチーブメントの授与。 |

### `Mutation.userAddOnAssignmentBulkCreate` {#mutationuseraddonassignmentbulkcreate}

入力型: `UserAddOnAssignmentBulkCreateInput`

#### 引数 {#arguments-578}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationuseraddonassignmentbulkcreateaddonpurchaseid"></a>`addOnPurchaseId` | [`GitlabSubscriptionsAddOnPurchaseID!`](#gitlabsubscriptionsaddonpurchaseid) | 割り当て先AddOnPurchaseのグローバルID。 |
| <a id="mutationuseraddonassignmentbulkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationuseraddonassignmentbulkcreateuserids"></a>`userIds` | [`[UserID!]!`](#userid) | 割り当てるユーザーのグローバルID。 |

#### フィールド {#fields-483}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationuseraddonassignmentbulkcreateaddonpurchase"></a>`addOnPurchase` | [`AddOnPurchase`](#addonpurchase) | ミューテーション後のAddOnPurchase状態。 |
| <a id="mutationuseraddonassignmentbulkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationuseraddonassignmentbulkcreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.userAddOnAssignmentBulkRemove` {#mutationuseraddonassignmentbulkremove}

入力型: `UserAddOnAssignmentBulkRemoveInput`

#### 引数 {#arguments-579}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationuseraddonassignmentbulkremoveaddonpurchaseid"></a>`addOnPurchaseId` | [`GitlabSubscriptionsAddOnPurchaseID!`](#gitlabsubscriptionsaddonpurchaseid) | 割り当てを解除するAddOnPurchaseのグローバルID。 |
| <a id="mutationuseraddonassignmentbulkremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationuseraddonassignmentbulkremoveuserids"></a>`userIds` | [`[UserID!]!`](#userid) | 割り当てを解除するユーザーのグローバルID。 |

#### フィールド {#fields-484}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationuseraddonassignmentbulkremoveaddonpurchase"></a>`addOnPurchase` | [`AddOnPurchase`](#addonpurchase) | ミューテーション後のAddOnPurchase状態。 |
| <a id="mutationuseraddonassignmentbulkremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationuseraddonassignmentbulkremoveerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.userAddOnAssignmentCreate` {#mutationuseraddonassignmentcreate}

入力型: `UserAddOnAssignmentCreateInput`

#### 引数 {#arguments-580}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationuseraddonassignmentcreateaddonpurchaseid"></a>`addOnPurchaseId` | [`GitlabSubscriptionsAddOnPurchaseID!`](#gitlabsubscriptionsaddonpurchaseid) | 割り当て先AddOnPurchaseのグローバルID。 |
| <a id="mutationuseraddonassignmentcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationuseraddonassignmentcreateuserid"></a>`userId` | [`UserID!`](#userid) | 割り当てるユーザーのグローバルID。 |

#### フィールド {#fields-485}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationuseraddonassignmentcreateaddonpurchase"></a>`addOnPurchase` | [`AddOnPurchase`](#addonpurchase) | ミューテーション後のAddOnPurchase状態。 |
| <a id="mutationuseraddonassignmentcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationuseraddonassignmentcreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationuseraddonassignmentcreateuser"></a>`user` | [`AddOnUser`](#addonuser) | アドオン購入が割り当てられたユーザー。 |

### `Mutation.userAddOnAssignmentRemove` {#mutationuseraddonassignmentremove}

入力型: `UserAddOnAssignmentRemoveInput`

#### 引数 {#arguments-581}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationuseraddonassignmentremoveaddonpurchaseid"></a>`addOnPurchaseId` | [`GitlabSubscriptionsAddOnPurchaseID!`](#gitlabsubscriptionsaddonpurchaseid) | AddOnPurchase割り当てが属するグローバルID。 |
| <a id="mutationuseraddonassignmentremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationuseraddonassignmentremoveuserid"></a>`userId` | [`UserID!`](#userid) | 割り当てを削除するユーザーのグローバルID。 |

#### フィールド {#fields-486}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationuseraddonassignmentremoveaddonpurchase"></a>`addOnPurchase` | [`AddOnPurchase`](#addonpurchase) | ミューテーション後のAddOnPurchase状態。 |
| <a id="mutationuseraddonassignmentremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationuseraddonassignmentremoveerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationuseraddonassignmentremoveuser"></a>`user` | [`AddOnUser`](#addonuser) | アドオンが削除されたユーザー。 |

### `Mutation.userCalloutCreate` {#mutationusercalloutcreate}

入力型: `UserCalloutCreateInput`

#### 引数 {#arguments-582}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationusercalloutcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationusercalloutcreatefeaturename"></a>`featureName` | [`String!`](#string) | コールアウトをやめる機能の名前。 |

#### フィールド {#fields-487}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationusercalloutcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationusercalloutcreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationusercalloutcreateusercallout"></a>`userCallout` | [`UserCallout!`](#usercallout) | 破棄されたユーザーコールアウト。 |

### `Mutation.userPreferencesUpdate` {#mutationuserpreferencesupdate}

入力型: `UserPreferencesUpdateInput`

#### 引数 {#arguments-583}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationuserpreferencesupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationuserpreferencesupdateextensionsmarketplaceoptinstatus"></a>`extensionsMarketplaceOptInStatus` | [`ExtensionsMarketplaceOptInStatus`](#extensionsmarketplaceoptinstatus) | ユーザーのWeb IDE拡張機能マーケットプレースオプトインのステータス。 |
| <a id="mutationuserpreferencesupdateissuessort"></a>`issuesSort` | [`IssueSort`](#issuesort) | イシューリストのソート順。 |
| <a id="mutationuserpreferencesupdatemergerequestdashboardlisttype"></a>`mergeRequestDashboardListType` | [`MergeRequestsDashboardListType`](#mergerequestsdashboardlisttype) | マージリクエストダッシュボードリストの表示タイプ。 |
| <a id="mutationuserpreferencesupdatemergerequestdashboardshowdrafts"></a>`mergeRequestDashboardShowDrafts` | [`Boolean`](#boolean) | マージリクエストダッシュボードにドラフトのマージリクエストを表示します。 |
| <a id="mutationuserpreferencesupdatemergerequestssort"></a>`mergeRequestsSort` | [`MergeRequestSort`](#mergerequestsort) | イシューリストのソート順。 |
| <a id="mutationuserpreferencesupdateorganizationgroupsprojectsdisplay"></a>`organizationGroupsProjectsDisplay` {{< icon name="warning-solid" >}} | [`OrganizationGroupProjectDisplay`](#organizationgroupprojectdisplay) | **非推奨**: **状態**: 実験的機能。GitLab 17.2で導入されました。 |
| <a id="mutationuserpreferencesupdateorganizationgroupsprojectssort"></a>`organizationGroupsProjectsSort` {{< icon name="warning-solid" >}} | [`OrganizationGroupProjectSort`](#organizationgroupprojectsort) | **非推奨**: **状態**: 実験的機能。GitLab 17.2で導入されました。 |
| <a id="mutationuserpreferencesupdateprojectstudioenabled"></a>`projectStudioEnabled` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | **非推奨**: **状態**: 実験的機能。GitLab 18.4で導入されました。 |
| <a id="mutationuserpreferencesupdateprojectssort"></a>`projectsSort` | [`ProjectSort`](#projectsort) | プロジェクトのソート順。 |
| <a id="mutationuserpreferencesupdateuseworkitemsview"></a>`useWorkItemsView` | [`Boolean`](#boolean) | 従来のイシュービューではなく、作業アイテムビューを使用します。 |
| <a id="mutationuserpreferencesupdatevisibilitypipelineidtype"></a>`visibilityPipelineIdType` | [`VisibilityPipelineIdType`](#visibilitypipelineidtype) | パイプラインリストにIDまたはIIDを表示するかどうかを決定します。 |
| <a id="mutationuserpreferencesupdateworkitemsdisplaysettings"></a>`workItemsDisplaySettings` {{< icon name="warning-solid" >}} | [`JSON`](#json) | **非推奨**: **状態**: 実験的機能。GitLab 18.1で導入されました。 |

#### フィールド {#fields-488}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationuserpreferencesupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationuserpreferencesupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationuserpreferencesupdateuserpreferences"></a>`userPreferences` | [`UserPreferences`](#userpreferences) | ミューテーション後のユーザープリファレンス。 |

### `Mutation.userSetNamespaceCommitEmail` {#mutationusersetnamespacecommitemail}

入力型: `UserSetNamespaceCommitEmailInput`

#### 引数 {#arguments-584}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationusersetnamespacecommitemailclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationusersetnamespacecommitemailemailid"></a>`emailId` | [`EmailID`](#emailid) | 設定するメールのID。 |
| <a id="mutationusersetnamespacecommitemailnamespaceid"></a>`namespaceId` | [`NamespaceID!`](#namespaceid) | ネームスペースコミットメールを設定する対象のネームスペースのID。 |

#### フィールド {#fields-489}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationusersetnamespacecommitemailclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationusersetnamespacecommitemailerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationusersetnamespacecommitemailnamespacecommitemail"></a>`namespaceCommitEmail` | [`NamespaceCommitEmail`](#namespacecommitemail) | ミューテーション後のユーザーネームスペースコミットメール。 |

### `Mutation.valueStreamCreate` {#mutationvaluestreamcreate}

{{< details >}} GitLab 16.6で**導入**されました。**状態**: 実験的機能。{{< /details >}}

バリューストリームを作成します。

入力型: `ValueStreamCreateInput`

#### 引数 {#arguments-585}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvaluestreamcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationvaluestreamcreatename"></a>`name` | [`String!`](#string) | バリューストリームの名前。 |
| <a id="mutationvaluestreamcreatenamespacepath"></a>`namespacePath` | [`ID!`](#id) | バリューストリームを作成するネームスペース（プロジェクトまたはグループ）のフルパス。 |
| <a id="mutationvaluestreamcreatesetting"></a>`setting` | [`ValueStreamSettingInput`](#valuestreamsettinginput) | バリューストリームの設定。 |
| <a id="mutationvaluestreamcreatestages"></a>`stages` | [`[CreateValueStreamStageInput!]`](#createvaluestreamstageinput) | バリューストリームのステージ。 |

#### フィールド {#fields-490}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvaluestreamcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationvaluestreamcreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationvaluestreamcreatevaluestream"></a>`valueStream` | [`ValueStream`](#valuestream) | 作成されたバリューストリーム。 |

### `Mutation.valueStreamDestroy` {#mutationvaluestreamdestroy}

{{< details >}} GitLab 16.6で**導入**されました。**状態**: 実験的機能。{{< /details >}}

バリューストリームを削除します。

入力型: `ValueStreamDestroyInput`

#### 引数 {#arguments-586}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvaluestreamdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationvaluestreamdestroyid"></a>`id` | [`AnalyticsCycleAnalyticsValueStreamID!`](#analyticscycleanalyticsvaluestreamid) | 削除するバリューストリームのグローバルID。 |

#### フィールド {#fields-491}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvaluestreamdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationvaluestreamdestroyerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationvaluestreamdestroyvaluestream"></a>`valueStream` | [`ValueStream`](#valuestream) | ミューテーション後に削除されたバリューストリーム。 |

### `Mutation.valueStreamUpdate` {#mutationvaluestreamupdate}

{{< details >}} GitLab 16.6で**導入**されました。**状態**: 実験的機能。{{< /details >}}

バリューストリームを更新します。

入力型: `ValueStreamUpdateInput`

#### 引数 {#arguments-587}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvaluestreamupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationvaluestreamupdateid"></a>`id` | [`AnalyticsCycleAnalyticsValueStreamID!`](#analyticscycleanalyticsvaluestreamid) | 更新するバリューストリームのグローバルID。 |
| <a id="mutationvaluestreamupdatename"></a>`name` | [`String`](#string) | バリューストリームの名前。 |
| <a id="mutationvaluestreamupdatesetting"></a>`setting` | [`ValueStreamSettingInput`](#valuestreamsettinginput) | バリューストリームの設定。 |
| <a id="mutationvaluestreamupdatestages"></a>`stages` | [`[UpdateValueStreamStageInput!]`](#updatevaluestreamstageinput) | バリューストリームのステージ。 |

#### フィールド {#fields-492}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvaluestreamupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationvaluestreamupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationvaluestreamupdatevaluestream"></a>`valueStream` | [`ValueStream`](#valuestream) | 更新されたバリューストリーム。 |

### `Mutation.verifiedNamespaceCreate` {#mutationverifiednamespacecreate}

検証済みのネームスペースを作成し、渡された検証レベル情報によるマークを、すべての子カタログリソースに付けます。

入力型: `VerifiedNamespaceCreateInput`

#### 引数 {#arguments-588}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationverifiednamespacecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationverifiednamespacecreatenamespacepath"></a>`namespacePath` | [`ID!`](#id) | ルートネームスペースパス。 |
| <a id="mutationverifiednamespacecreateverificationlevel"></a>`verificationLevel` | [`CiCatalogResourceVerificationLevel!`](#cicatalogresourceverificationlevel) | ルートネームスペースの検証レベル。 |

#### フィールド {#fields-493}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationverifiednamespacecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationverifiednamespacecreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.vulnerabilitiesArchive` {#mutationvulnerabilitiesarchive}

{{< details >}}GitLab 17.10で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `VulnerabilitiesArchiveInput`

#### 引数 {#arguments-589}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitiesarchiveclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilitiesarchivedate"></a>`date` | [`Date!`](#date) | アーカイブする脆弱性の最終更新日。 |
| <a id="mutationvulnerabilitiesarchiveprojectid"></a>`projectId` | [`ProjectID!`](#projectid) | 脆弱性をアタッチする先のプロジェクトのID。 |

#### フィールド {#fields-494}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitiesarchiveclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilitiesarchiveerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationvulnerabilitiesarchivestatus"></a>`status` | [`String!`](#string) | アクションのステータス。 |

### `Mutation.vulnerabilitiesCreateIssue` {#mutationvulnerabilitiescreateissue}

{{< details >}}GitLab 17.9で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `VulnerabilitiesCreateIssueInput`

#### 引数 {#arguments-590}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitiescreateissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilitiescreateissueproject"></a>`project` | [`ProjectID!`](#projectid) | イシューのアタッチ先プロジェクトのID。 |
| <a id="mutationvulnerabilitiescreateissuevulnerabilityids"></a>`vulnerabilityIds` | [`[VulnerabilityID!]!`](#vulnerabilityid) | 指定されたイシューにリンクする脆弱性のID。最大100個まで指定できます。 |

#### フィールド {#fields-495}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitiescreateissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilitiescreateissueerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationvulnerabilitiescreateissueissue"></a>`issue` | [`Issue`](#issue) | ミューテーション後に作成されたイシュー。 |

### `Mutation.vulnerabilitiesDismiss` {#mutationvulnerabilitiesdismiss}

入力型: `VulnerabilitiesDismissInput`

#### 引数 {#arguments-591}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitiesdismissclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilitiesdismisscomment"></a>`comment` | [`String`](#string) | 脆弱性を無視した理由についてのコメント（最大50,000文字）。 |
| <a id="mutationvulnerabilitiesdismissdismissalreason"></a>`dismissalReason` | [`VulnerabilityDismissalReason`](#vulnerabilitydismissalreason) | 脆弱性を無視する理由。 |
| <a id="mutationvulnerabilitiesdismissvulnerabilityids"></a>`vulnerabilityIds` | [`[VulnerabilityID!]!`](#vulnerabilityid) | 無視する脆弱性のID（最大100エントリ）。 |

#### フィールド {#fields-496}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitiesdismissclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilitiesdismisserrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationvulnerabilitiesdismissvulnerabilities"></a>`vulnerabilities` | [`[Vulnerability!]!`](#vulnerability) | 状態変更後の脆弱性。 |

### `Mutation.vulnerabilitiesRemoveAllFromProject` {#mutationvulnerabilitiesremoveallfromproject}

特定のプロジェクトから、脆弱性および関連情報をすべて削除します。GitLab 16.7で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/412602)されました。

入力型: `VulnerabilitiesRemoveAllFromProjectInput`

#### 引数 {#arguments-592}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitiesremoveallfromprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilitiesremoveallfromprojectprojectids"></a>`projectIds` | [`[ProjectID!]!`](#projectid) | 脆弱性をすべて削除することが必要なプロジェクトのID。削除はバックグラウンドで実行されるため、すぐには変更が表示されません。 |
| <a id="mutationvulnerabilitiesremoveallfromprojectresolvedondefaultbranch"></a>`resolvedOnDefaultBranch` | [`Boolean`](#boolean) | `true`に設定すると、検出されなくなった脆弱性のみ削除します。`false`に設定すると、まだ検出される脆弱性のみを削除します。 |

#### フィールド {#fields-497}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitiesremoveallfromprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilitiesremoveallfromprojecterrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationvulnerabilitiesremoveallfromprojectprojects"></a>`projects` | [`[Project!]!`](#project) | 削除がスケジュールされたプロジェクト。 |

### `Mutation.vulnerabilitiesSeverityOverride` {#mutationvulnerabilitiesseverityoverride}

入力型: `vulnerabilitiesSeverityOverrideInput`

#### 引数 {#arguments-593}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitiesseverityoverrideclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilitiesseverityoverridecomment"></a>`comment` | [`String!`](#string) | 脆弱性の重大度を変更した理由についてのコメント（最大50,000文字）。 |
| <a id="mutationvulnerabilitiesseverityoverrideseverity"></a>`severity` | [`VulnerabilitySeverity!`](#vulnerabilityseverity) | 重大度の新しい重大度値。 |
| <a id="mutationvulnerabilitiesseverityoverridevulnerabilityids"></a>`vulnerabilityIds` | [`[VulnerabilityID!]!`](#vulnerabilityid) | 重大度を変更することが必要な脆弱性のID （最大100エントリ）。 |

#### フィールド {#fields-498}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitiesseverityoverrideclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilitiesseverityoverrideerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationvulnerabilitiesseverityoverridevulnerabilities"></a>`vulnerabilities` | [`[Vulnerability!]!`](#vulnerability) | 重大度変更後の脆弱性。 |

### `Mutation.vulnerabilityConfirm` {#mutationvulnerabilityconfirm}

入力型: `VulnerabilityConfirmInput`

#### 引数 {#arguments-594}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityconfirmclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilityconfirmcomment"></a>`comment` | [`String`](#string) | 脆弱性が確認された理由についてのコメント（最大50,000文字）。 |
| <a id="mutationvulnerabilityconfirmid"></a>`id` | [`VulnerabilityID!`](#vulnerabilityid) | 確認する脆弱性のID。 |

#### フィールド {#fields-499}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityconfirmclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilityconfirmerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationvulnerabilityconfirmvulnerability"></a>`vulnerability` | [`Vulnerability`](#vulnerability) | 状態変更後の脆弱性。 |

### `Mutation.vulnerabilityCreate` {#mutationvulnerabilitycreate}

入力型: `VulnerabilityCreateInput`

#### 引数 {#arguments-595}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilitycreateconfirmedat"></a>`confirmedAt` | [`Time`](#time) | 脆弱性のステータスが確認済みに変わった時点のタイムスタンプ（ステータスが`confirmed`の場合のデフォルトは作成時刻）。 |
| <a id="mutationvulnerabilitycreatedescription"></a>`description` | [`String!`](#string) | 脆弱性をより詳細に説明する長いテキストセクション。 |
| <a id="mutationvulnerabilitycreatedetectedat"></a>`detectedAt` | [`Time`](#time) | 脆弱性が最初に検出された時点のタイムスタンプ（デフォルトは作成時刻）。 |
| <a id="mutationvulnerabilitycreatedismissedat"></a>`dismissedAt` | [`Time`](#time) | 脆弱性のステータスが無視に変わった時点のタイムスタンプ（ステータスが`dismissed`の場合のデフォルトは作成時刻）。 |
| <a id="mutationvulnerabilitycreateidentifiers"></a>`identifiers` | [`[VulnerabilityIdentifierInput!]!`](#vulnerabilityidentifierinput) | 脆弱性のCVEまたはCWE識別子の配列。 |
| <a id="mutationvulnerabilitycreatename"></a>`name` | [`String!`](#string) | 脆弱性の名前。 |
| <a id="mutationvulnerabilitycreateproject"></a>`project` | [`ProjectID!`](#projectid) | 脆弱性をアタッチする先のプロジェクトのID。 |
| <a id="mutationvulnerabilitycreateresolvedat"></a>`resolvedAt` | [`Time`](#time) | 脆弱性のステータスが解決済みに変わった時点のタイムスタンプ（ステータスが`resolved`の場合のデフォルトは作成時刻）。 |
| <a id="mutationvulnerabilitycreatescanner"></a>`scanner` | [`VulnerabilityScannerInput!`](#vulnerabilityscannerinput) | 脆弱性の発見に使用されたスキャナーに関する情報。 |
| <a id="mutationvulnerabilitycreateseverity"></a>`severity` | [`VulnerabilitySeverity`](#vulnerabilityseverity) | 脆弱性の重大度（デフォルトは`unknown`）。 |
| <a id="mutationvulnerabilitycreatesolution"></a>`solution` | [`String`](#string) | 脆弱性の修正方法についての説明。 |
| <a id="mutationvulnerabilitycreatestate"></a>`state` | [`VulnerabilityState`](#vulnerabilitystate) | 脆弱性の状態（デフォルトは`detected`）。 |

#### フィールド {#fields-500}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilitycreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationvulnerabilitycreatevulnerability"></a>`vulnerability` | [`Vulnerability`](#vulnerability) | 作成された脆弱性。 |

### `Mutation.vulnerabilityDismiss` {#mutationvulnerabilitydismiss}

入力型: `VulnerabilityDismissInput`

#### 引数 {#arguments-596}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitydismissclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilitydismisscomment"></a>`comment` | [`String`](#string) | 脆弱性を無視した理由についてのコメント（最大50,000文字）。 |
| <a id="mutationvulnerabilitydismissdismissalreason"></a>`dismissalReason` | [`VulnerabilityDismissalReason`](#vulnerabilitydismissalreason) | 脆弱性を無視する理由。 |
| <a id="mutationvulnerabilitydismissid"></a>`id` | [`VulnerabilityID!`](#vulnerabilityid) | 無視する脆弱性のID。 |

#### フィールド {#fields-501}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitydismissclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilitydismisserrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationvulnerabilitydismissvulnerability"></a>`vulnerability` | [`Vulnerability`](#vulnerability) | 状態変更後の脆弱性。 |

### `Mutation.vulnerabilityExternalIssueLinkCreate` {#mutationvulnerabilityexternalissuelinkcreate}

入力型: `VulnerabilityExternalIssueLinkCreateInput`

#### 引数 {#arguments-597}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityexternalissuelinkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilityexternalissuelinkcreateexternaltracker"></a>`externalTracker` | [`VulnerabilityExternalIssueLinkExternalTracker!`](#vulnerabilityexternalissuelinkexternaltracker) | 外部イシューリンクの外部トラッカータイプ。 |
| <a id="mutationvulnerabilityexternalissuelinkcreateid"></a>`id` | [`VulnerabilityID!`](#vulnerabilityid) | 脆弱性のID。 |
| <a id="mutationvulnerabilityexternalissuelinkcreatelinktype"></a>`linkType` | [`VulnerabilityExternalIssueLinkType!`](#vulnerabilityexternalissuelinktype) | 外部イシューリンクのタイプ。 |

#### フィールド {#fields-502}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityexternalissuelinkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilityexternalissuelinkcreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationvulnerabilityexternalissuelinkcreateexternalissuelink"></a>`externalIssueLink` | [`VulnerabilityExternalIssueLink`](#vulnerabilityexternalissuelink) | 作成された外部イシューリンク。 |

### `Mutation.vulnerabilityExternalIssueLinkDestroy` {#mutationvulnerabilityexternalissuelinkdestroy}

入力型: `VulnerabilityExternalIssueLinkDestroyInput`

#### 引数 {#arguments-598}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityexternalissuelinkdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilityexternalissuelinkdestroyid"></a>`id` | [`VulnerabilitiesExternalIssueLinkID!`](#vulnerabilitiesexternalissuelinkid) | 脆弱性外部イシューリンクのグローバルID。 |

#### フィールド {#fields-503}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityexternalissuelinkdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilityexternalissuelinkdestroyerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.vulnerabilityIssueLinkCreate` {#mutationvulnerabilityissuelinkcreate}

入力型: `VulnerabilityIssueLinkCreateInput`

#### 引数 {#arguments-599}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityissuelinkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilityissuelinkcreateissueid"></a>`issueId` | [`IssueID!`](#issueid) | リンク先のイシューのID。 |
| <a id="mutationvulnerabilityissuelinkcreatevulnerabilityids"></a>`vulnerabilityIds` | [`[VulnerabilityID!]!`](#vulnerabilityid) | 指定されたイシューにリンクする脆弱性のID。最大100個まで指定できます。 |

#### フィールド {#fields-504}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityissuelinkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilityissuelinkcreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationvulnerabilityissuelinkcreateissuelinks"></a>`issueLinks` | [`[VulnerabilityIssueLink!]`](#vulnerabilityissuelink) | 作成されたイシューリンク。 |

### `Mutation.vulnerabilityLinkMergeRequest` {#mutationvulnerabilitylinkmergerequest}

マージリクエストを脆弱性にリンクさせます。

入力型: `VulnerabilityLinkMergeRequestInput`

#### 引数 {#arguments-600}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitylinkmergerequestclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilitylinkmergerequestmergerequestid"></a>`mergeRequestId` | [`MergeRequestID!`](#mergerequestid) | マージリクエストのID。 |
| <a id="mutationvulnerabilitylinkmergerequestvulnerabilityid"></a>`vulnerabilityId` | [`VulnerabilityID!`](#vulnerabilityid) | 脆弱性のID。 |

#### フィールド {#fields-505}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitylinkmergerequestclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilitylinkmergerequesterrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationvulnerabilitylinkmergerequestvulnerability"></a>`vulnerability` | [`Vulnerability`](#vulnerability) | 更新された脆弱性。 |

### `Mutation.vulnerabilityResolve` {#mutationvulnerabilityresolve}

入力型: `VulnerabilityResolveInput`

#### 引数 {#arguments-601}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityresolveclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilityresolvecomment"></a>`comment` | [`String`](#string) | 脆弱性が解決された理由についてのコメント（最大50,000文字）。 |
| <a id="mutationvulnerabilityresolveid"></a>`id` | [`VulnerabilityID!`](#vulnerabilityid) | 解決する脆弱性のID。 |

#### フィールド {#fields-506}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityresolveclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilityresolveerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationvulnerabilityresolvevulnerability"></a>`vulnerability` | [`Vulnerability`](#vulnerability) | 状態変更後の脆弱性。 |

### `Mutation.vulnerabilityRevertToDetected` {#mutationvulnerabilityreverttodetected}

入力型: `VulnerabilityRevertToDetectedInput`

#### 引数 {#arguments-602}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityreverttodetectedclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilityreverttodetectedcomment"></a>`comment` | [`String`](#string) | 脆弱性がリバートされた理由についてのコメント（最大50,000文字）。 |
| <a id="mutationvulnerabilityreverttodetectedid"></a>`id` | [`VulnerabilityID!`](#vulnerabilityid) | リバートして検出状態に戻す脆弱性のID。 |

#### フィールド {#fields-507}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityreverttodetectedclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationvulnerabilityreverttodetectederrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationvulnerabilityreverttodetectedvulnerability"></a>`vulnerability` | [`Vulnerability`](#vulnerability) | 状態変更後の脆弱性。 |

### `Mutation.wikiPageSubscribe` {#mutationwikipagesubscribe}

{{< details >}}GitLab 18.1で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `WikiPageSubscribeInput`

#### 引数 {#arguments-603}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationwikipagesubscribeclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationwikipagesubscribeid"></a>`id` | [`WikiPageMetaID!`](#wikipagemetaid) | WikiページメタデータレコードのグローバルID。 |
| <a id="mutationwikipagesubscribesubscribed"></a>`subscribed` | [`Boolean!`](#boolean) | サブスクリプションの望ましい状態。 |

#### フィールド {#fields-508}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationwikipagesubscribeclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationwikipagesubscribeerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationwikipagesubscribewikipage"></a>`wikiPage` | [`WikiPage`](#wikipage) | ミューテーション後のWikiページ。 |

### `Mutation.workItemAddClosingMergeRequest` {#mutationworkitemaddclosingmergerequest}

{{< details >}}GitLab 17.1で**導入**されました。**状態**: 実験的機能。{{< /details >}}

完了マージリクエストを作業アイテムに追加します。

入力型: `WorkItemAddClosingMergeRequestInput`

#### 引数 {#arguments-604}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemaddclosingmergerequestclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemaddclosingmergerequestcontextnamespacepath"></a>`contextNamespacePath` | [`ID`](#id) | コンテキストネームスペース（プロジェクトまたはグループ）のフルパス。`!1`などの短い参照構文を使用してマージリクエストを検索するために使用されるのは、プロジェクトのフルパスだけです。フルの参照とURLの場合は無視されます。指定されていない場合のデフォルトは、作業アイテムのネームスペースです。 |
| <a id="mutationworkitemaddclosingmergerequestid"></a>`id` | [`WorkItemID!`](#workitemid) | 作業アイテムのグローバルID。 |
| <a id="mutationworkitemaddclosingmergerequestmergerequestreference"></a>`mergeRequestReference` | [`String!`](#string) | マージリクエスト参照（短い、フル、またはURL）。例: `!1`、`project_full_path!1`、または`https://gitlab.com/gitlab-org/gitlab/-/merge_requests/1`。 |

#### フィールド {#fields-509}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemaddclosingmergerequestclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemaddclosingmergerequestclosingmergerequest"></a>`closingMergeRequest` | [`WorkItemClosingMergeRequest`](#workitemclosingmergerequest) | 作業アイテムに追加された完了マージリクエスト。 |
| <a id="mutationworkitemaddclosingmergerequesterrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationworkitemaddclosingmergerequestworkitem"></a>`workItem` | [`WorkItem`](#workitem) | 新しい完了マージリクエストを含む作業アイテム。 |

### `Mutation.workItemAddLinkedItems` {#mutationworkitemaddlinkeditems}

{{< details >}}GitLab 16.3で**導入**されました。**状態**: 実験的機能。{{< /details >}}

リンクされたアイテムを作業アイテムに追加します。

入力型: `WorkItemAddLinkedItemsInput`

#### 引数 {#arguments-605}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemaddlinkeditemsclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemaddlinkeditemsid"></a>`id` | [`WorkItemID!`](#workitemid) | 作業アイテムのグローバルID。 |
| <a id="mutationworkitemaddlinkeditemslinktype"></a>`linkType` | [`WorkItemRelatedLinkType`](#workitemrelatedlinktype) | リンクのタイプ。デフォルトは`RELATED`です。 |
| <a id="mutationworkitemaddlinkeditemsworkitemsids"></a>`workItemsIds` | [`[WorkItemID!]!`](#workitemid) | リンクするアイテムのグローバルID。指定できるIDの最大数: 10。 |

#### フィールド {#fields-510}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemaddlinkeditemsclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemaddlinkeditemserrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationworkitemaddlinkeditemsmessage"></a>`message` | [`String`](#string) | リンクされたアイテムの更新結果メッセージ。 |
| <a id="mutationworkitemaddlinkeditemsworkitem"></a>`workItem` | [`WorkItem`](#workitem) | 更新された作業アイテム。 |

### `Mutation.workItemBulkMove` {#mutationworkitembulkmove}

{{< details >}}GitLab 18.2で**導入**されました。**状態**: 実験的機能。{{< /details >}}

作業アイテムをプロジェクト間またはグループ間で移動します。

入力型: `WorkItemBulkMoveInput`

#### 引数 {#arguments-606}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitembulkmoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationworkitembulkmoveids"></a>`ids` | [`[WorkItemID!]!`](#workitemid) | 移動する作業アイテムのグローバルID配列。ユーザーが移動できないIDは無視されます。最大100個まで指定できます。 |
| <a id="mutationworkitembulkmovesourcefullpath"></a>`sourceFullPath` | [`String!`](#string) | ソースネームスペースのフルパス。例: `gitlab-org/gitlab-foss`。 |
| <a id="mutationworkitembulkmovetargetfullpath"></a>`targetFullPath` | [`String!`](#string) | ターゲットネームスペースのフルパス。例: `gitlab-org/gitlab-foss`。ユーザーパスはサポートされていません。 |

#### フィールド {#fields-511}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitembulkmoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationworkitembulkmoveerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationworkitembulkmovemovedworkitemcount"></a>`movedWorkItemCount` | [`Int`](#int) | 正常に移動された作業アイテムの数。 |

### `Mutation.workItemBulkUpdate` {#mutationworkitembulkupdate}

{{< details >}}GitLab 17.4で**導入**されました。**状態**: 実験的機能。{{< /details >}}

作業アイテムセットの複数プロパティの更新を許可します。

入力型: `WorkItemBulkUpdateInput`

#### 引数 {#arguments-607}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitembulkupdateassigneeswidget"></a>`assigneesWidget` {{< icon name="warning-solid" >}} | [`WorkItemWidgetAssigneesInput`](#workitemwidgetassigneesinput) | **非推奨**: **状態**: 実験的機能。GitLab 18.2で導入されました。 |
| <a id="mutationworkitembulkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationworkitembulkupdateconfidential"></a>`confidential` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | **非推奨**: **状態**: 実験的機能。GitLab 18.2で導入されました。 |
| <a id="mutationworkitembulkupdatefullpath"></a>`fullPath` | [`ID!`](#id) | 更新する作業アイテムを含むプロジェクトまたはグループのフルパス（PremiumおよびUltimateのみ）。ユーザーパスはサポートされていません。 |
| <a id="mutationworkitembulkupdatehealthstatuswidget"></a>`healthStatusWidget` {{< icon name="warning-solid" >}} | [`WorkItemWidgetHealthStatusInput`](#workitemwidgethealthstatusinput) | **非推奨**: **状態**: 実験的機能。GitLab 18.2で導入されました。 |
| <a id="mutationworkitembulkupdatehierarchywidget"></a>`hierarchyWidget` {{< icon name="warning-solid" >}} | [`WorkItemWidgetHierarchyCreateInput`](#workitemwidgethierarchycreateinput) | **非推奨**: **状態**: 実験的機能。GitLab 18.2で導入されました。 |
| <a id="mutationworkitembulkupdateids"></a>`ids` | [`[WorkItemID!]!`](#workitemid) | 更新する作業アイテムのグローバルID配列。ユーザーが更新できないIDは無視されます。最大100個まで指定できます。 |
| <a id="mutationworkitembulkupdateiterationwidget"></a>`iterationWidget` {{< icon name="warning-solid" >}} | [`WorkItemWidgetIterationInput`](#workitemwidgetiterationinput) | **非推奨**: **状態**: 実験的機能。GitLab 18.2で導入されました。 |
| <a id="mutationworkitembulkupdatelabelswidget"></a>`labelsWidget` | [`WorkItemWidgetLabelsUpdateInput`](#workitemwidgetlabelsupdateinput) | ラベルウィジェットのインプット。 |
| <a id="mutationworkitembulkupdatemilestonewidget"></a>`milestoneWidget` {{< icon name="warning-solid" >}} | [`WorkItemWidgetMilestoneInput`](#workitemwidgetmilestoneinput) | **非推奨**: **状態**: 実験的機能。GitLab 18.2で導入されました。 |
| <a id="mutationworkitembulkupdatestateevent"></a>`stateEvent` {{< icon name="warning-solid" >}} | [`WorkItemStateEvent`](#workitemstateevent) | **非推奨**: **状態**: 実験的機能。GitLab 18.2で導入されました。 |
| <a id="mutationworkitembulkupdatestatuswidget"></a>`statusWidget` {{< icon name="warning-solid" >}} | [`WorkItemWidgetStatusInput`](#workitemwidgetstatusinput) | **非推奨**: **状態**: 実験的機能。GitLab 18.3で導入されました。 |
| <a id="mutationworkitembulkupdatesubscriptionevent"></a>`subscriptionEvent` {{< icon name="warning-solid" >}} | [`WorkItemSubscriptionEvent`](#workitemsubscriptionevent) | **非推奨**: **状態**: 実験的機能。GitLab 18.2で導入されました。 |

#### フィールド {#fields-512}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitembulkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationworkitembulkupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationworkitembulkupdateupdatedworkitemcount"></a>`updatedWorkItemCount` | [`Int`](#int) | 正常に更新された作業アイテムの数。 |

### `Mutation.workItemConvert` {#mutationworkitemconvert}

{{< details >}}GitLab 15.11で**導入**されました。**状態**: 実験的機能。{{< /details >}}

作業アイテムを新しいタイプに変換します。

入力型: `WorkItemConvertInput`

#### 引数 {#arguments-608}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemconvertclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemconvertid"></a>`id` | [`WorkItemID!`](#workitemid) | 作業アイテムのグローバルID。 |
| <a id="mutationworkitemconvertworkitemtypeid"></a>`workItemTypeId` | [`WorkItemsTypeID!`](#workitemstypeid) | 新しい作業アイテムタイプのグローバルID。 |

#### フィールド {#fields-513}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemconvertclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemconverterrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationworkitemconvertworkitem"></a>`workItem` | [`WorkItem`](#workitem) | 更新された作業アイテム。 |

### `Mutation.workItemCreate` {#mutationworkitemcreate}

{{< details >}}GitLab 15.1で**導入**されました。**状態**: 実験的機能。{{< /details >}}

作業アイテムを作成します。

入力型: `WorkItemCreateInput`

#### 引数 {#arguments-609}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemcreateassigneeswidget"></a>`assigneesWidget` | [`WorkItemWidgetAssigneesInput`](#workitemwidgetassigneesinput) | 担当者ウィジェットのインプット。 |
| <a id="mutationworkitemcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemcreatecolorwidget"></a>`colorWidget` | [`WorkItemWidgetColorInput`](#workitemwidgetcolorinput) | カラーウィジェットのインプット。 |
| <a id="mutationworkitemcreateconfidential"></a>`confidential` | [`Boolean`](#boolean) | 作業アイテムの機密性を設定します。 |
| <a id="mutationworkitemcreatecreatedat"></a>`createdAt` | [`Time`](#time) | 作業アイテム作成時のタイムスタンプ。管理者とプロジェクトオーナーのみが使用できます。 |
| <a id="mutationworkitemcreatecrmcontactswidget"></a>`crmContactsWidget` | [`WorkItemWidgetCrmContactsCreateInput`](#workitemwidgetcrmcontactscreateinput) | CRM連絡先ウィジェットのインプット。 |
| <a id="mutationworkitemcreatecustomfieldswidget"></a>`customFieldsWidget` {{< icon name="warning-solid" >}} | [`[WorkItemWidgetCustomFieldValueInputType!]`](#workitemwidgetcustomfieldvalueinputtype) | **非推奨**: **状態**: 実験的機能。GitLab 17.10で導入されました。 |
| <a id="mutationworkitemcreatedescription"></a>`description` {{< icon name="warning-solid" >}} | [`String`](#string) | **非推奨**: 代わりに説明ウィジェットを使用してください。GitLab 16.9で非推奨になりました。 |
| <a id="mutationworkitemcreatedescriptionwidget"></a>`descriptionWidget` | [`WorkItemWidgetDescriptionInput`](#workitemwidgetdescriptioninput) | 説明ウィジェットのインプット。 |
| <a id="mutationworkitemcreatediscussionstoresolve"></a>`discussionsToResolve` | [`WorkItemResolveDiscussionsInput`](#workitemresolvediscussionsinput) | 作業アイテムの作成時に、noteable（ノート可能）内のディスカッションを解決するために必要な情報。 |
| <a id="mutationworkitemcreatehealthstatuswidget"></a>`healthStatusWidget` | [`WorkItemWidgetHealthStatusInput`](#workitemwidgethealthstatusinput) | ヘルスステータスウィジェットのインプット。 |
| <a id="mutationworkitemcreatehierarchywidget"></a>`hierarchyWidget` | [`WorkItemWidgetHierarchyCreateInput`](#workitemwidgethierarchycreateinput) | 階層ウィジェットのインプット。 |
| <a id="mutationworkitemcreateiterationwidget"></a>`iterationWidget` | [`WorkItemWidgetIterationInput`](#workitemwidgetiterationinput) | 作業アイテムのイテレーションウィジェット。 |
| <a id="mutationworkitemcreatelabelswidget"></a>`labelsWidget` | [`WorkItemWidgetLabelsCreateInput`](#workitemwidgetlabelscreateinput) | ラベルウィジェットのインプット。 |
| <a id="mutationworkitemcreatelinkeditemswidget"></a>`linkedItemsWidget` | [`WorkItemWidgetLinkedItemsCreateInput`](#workitemwidgetlinkeditemscreateinput) | リンクされたアイテムウィジェットのインプット。 |
| <a id="mutationworkitemcreatemilestonewidget"></a>`milestoneWidget` | [`WorkItemWidgetMilestoneInput`](#workitemwidgetmilestoneinput) | マイルストーンウィジェットのインプット。 |
| <a id="mutationworkitemcreatenamespacepath"></a>`namespacePath` | [`ID`](#id) | 作業アイテムを作成するネームスペース（プロジェクトまたはグループ）のフルパス。 |
| <a id="mutationworkitemcreateprojectpath"></a>`projectPath` {{< icon name="warning-solid" >}} | [`ID`](#id) | **非推奨**: 代わりにnamespacePathを使用してください。これはプロジェクトとグループの両方をカバーします。GitLab 15.10で非推奨になりました。 |
| <a id="mutationworkitemcreatestartandduedatewidget"></a>`startAndDueDateWidget` | [`WorkItemWidgetStartAndDueDateUpdateInput`](#workitemwidgetstartandduedateupdateinput) | 開始日と期限ウィジェットのインプット。 |
| <a id="mutationworkitemcreatestatuswidget"></a>`statusWidget` {{< icon name="warning-solid" >}} | [`WorkItemWidgetStatusInput`](#workitemwidgetstatusinput) | **非推奨**: **状態**: 実験的機能。GitLab 17.11で導入されました。 |
| <a id="mutationworkitemcreatetitle"></a>`title` | [`String!`](#string) | 作業アイテムのタイトル。 |
| <a id="mutationworkitemcreatevulnerabilityid"></a>`vulnerabilityId` {{< icon name="warning-solid" >}} | [`VulnerabilityID`](#vulnerabilityid) | **非推奨**: **状態**: 実験的機能。GitLab 17.9で導入されました。 |
| <a id="mutationworkitemcreateweightwidget"></a>`weightWidget` | [`WorkItemWidgetWeightInput`](#workitemwidgetweightinput) | ウェイトウィジェットのインプット。 |
| <a id="mutationworkitemcreateworkitemtypeid"></a>`workItemTypeId` | [`WorkItemsTypeID!`](#workitemstypeid) | 作業アイテムタイプのグローバルID。 |

#### フィールド {#fields-514}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemcreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationworkitemcreateworkitem"></a>`workItem` | [`WorkItem`](#workitem) | 作成された作業アイテム。 |

### `Mutation.workItemCreateFromTask` {#mutationworkitemcreatefromtask}

{{< details >}}GitLab 15.1で**導入**されました。**状態**: 実験的機能。{{< /details >}}

別の作業アイテムの説明に含まれるタスクから作業アイテムを作成します。

入力型: `WorkItemCreateFromTaskInput`

#### 引数 {#arguments-610}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemcreatefromtaskclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemcreatefromtaskid"></a>`id` | [`WorkItemID!`](#workitemid) | 作業アイテムのグローバルID。 |
| <a id="mutationworkitemcreatefromtaskworkitemdata"></a>`workItemData` | [`WorkItemConvertTaskInput!`](#workitemconverttaskinput) | タスクを作業アイテムに変換するために必要な引数。 |

#### フィールド {#fields-515}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemcreatefromtaskclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemcreatefromtaskerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationworkitemcreatefromtasknewworkitem"></a>`newWorkItem` | [`WorkItem`](#workitem) | タスクから作成された新しい作業アイテム。 |
| <a id="mutationworkitemcreatefromtaskworkitem"></a>`workItem` | [`WorkItem`](#workitem) | 更新された作業アイテム。 |

### `Mutation.workItemDelete` {#mutationworkitemdelete}

{{< details >}}GitLab 15.1で**導入**されました。**状態**: 実験的機能。{{< /details >}}

作業アイテムを削除します。

入力型: `WorkItemDeleteInput`

#### 引数 {#arguments-611}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemdeleteid"></a>`id` | [`WorkItemID!`](#workitemid) | 作業アイテムのグローバルID。 |

#### フィールド {#fields-516}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemdeleteerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationworkitemdeletenamespace"></a>`namespace` | [`Namespace`](#namespace) | 削除された作業アイテムが属していたネームスペース。 |
| <a id="mutationworkitemdeleteproject"></a>`project` {{< icon name="warning-solid" >}} | [`Project`](#project) | **非推奨**: `namespace`を使用してください。GitLab 16.9で非推奨になりました。 |

### `Mutation.workItemExport` {#mutationworkitemexport}

{{< details >}}GitLab 18.0で**非推奨**になりました。WorkItemsCsvExportを使用します。{{< /details >}}

入力型: `WorkItemExportInput`

#### 引数 {#arguments-612}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemexportassigneeusernames"></a>`assigneeUsernames` | [`[String!]`](#string) | 作業アイテムに割り当てられたユーザーのユーザー名。 |
| <a id="mutationworkitemexportassigneewildcardid"></a>`assigneeWildcardId` | [`AssigneeWildcardId`](#assigneewildcardid) | 担当者のワイルドカードでフィルタリングします。`assigneeUsernames`と互換性がありません。 |
| <a id="mutationworkitemexportauthorusername"></a>`authorUsername` | [`String`](#string) | 作業アイテムを作成者のユーザー名でフィルタリングします。 |
| <a id="mutationworkitemexportclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemexportclosedafter"></a>`closedAfter` | [`Time`](#time) | 指定日より後に完了した作業アイテム。 |
| <a id="mutationworkitemexportclosedbefore"></a>`closedBefore` | [`Time`](#time) | 指定日より前に完了した作業アイテム。 |
| <a id="mutationworkitemexportconfidential"></a>`confidential` | [`Boolean`](#boolean) | 機密情報作業アイテムをフィルタリングします。`false`の場合、機密情報作業アイテムを除外します。`true`の場合、機密情報作業アイテムのみ返します。 |
| <a id="mutationworkitemexportcreatedafter"></a>`createdAfter` | [`Time`](#time) | 指定タイムスタンプより後に作成された作業アイテム。 |
| <a id="mutationworkitemexportcreatedbefore"></a>`createdBefore` | [`Time`](#time) | 指定タイムスタンプより前に作成された作業アイテム。 |
| <a id="mutationworkitemexportcrmcontactid"></a>`crmContactId` | [`String`](#string) | CRMの連絡先IDでフィルタリングします。 |
| <a id="mutationworkitemexportcrmorganizationid"></a>`crmOrganizationId` | [`String`](#string) | CRMの連絡先組織IDでフィルタリングします。 |
| <a id="mutationworkitemexportdueafter"></a>`dueAfter` | [`Time`](#time) | 指定タイムスタンプより後に期限切れになる作業アイテム。 |
| <a id="mutationworkitemexportduebefore"></a>`dueBefore` | [`Time`](#time) | 指定タイムスタンプより前に期限切れになる作業アイテム。 |
| <a id="mutationworkitemexporthealthstatusfilter"></a>`healthStatusFilter` {{< icon name="warning-solid" >}} | [`HealthStatusFilter`](#healthstatusfilter) | **非推奨**: **状態**: 実験的機能。GitLab 18.2で導入されました。 |
| <a id="mutationworkitemexporthierarchyfilters"></a>`hierarchyFilters` {{< icon name="warning-solid" >}} | [`HierarchyFilterInput`](#hierarchyfilterinput) | **非推奨**: **状態**: 実験的機能。GitLab 18.3で導入されました。 |
| <a id="mutationworkitemexportiids"></a>`iids` | [`[String!]`](#string) | 作業アイテムのIIDのリスト。例: `["1", "2"]`。 |
| <a id="mutationworkitemexportin"></a>`in` | [`[IssuableSearchableField!]`](#issuablesearchablefield) | 検索を実行するフィールドを指定します。デフォルトは`[TITLE, DESCRIPTION]`です。`search`引数が必要です。 |
| <a id="mutationworkitemexportincludedescendantworkitems"></a>`includeDescendantWorkItems` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | **非推奨**: **状態**: 実験的機能。GitLab 18.3で導入されました。 |
| <a id="mutationworkitemexportiterationcadenceid"></a>`iterationCadenceId` {{< icon name="warning-solid" >}} | [`[IterationsCadenceID!]`](#iterationscadenceid) | **非推奨**: **状態**: 実験的機能。GitLab 18.2で導入されました。 |
| <a id="mutationworkitemexportiterationid"></a>`iterationId` {{< icon name="warning-solid" >}} | [`[ID]`](#id) | **非推奨**: **状態**: 実験的機能。GitLab 18.2で導入されました。 |
| <a id="mutationworkitemexportiterationwildcardid"></a>`iterationWildcardId` {{< icon name="warning-solid" >}} | [`IterationWildcardId`](#iterationwildcardid) | **非推奨**: **状態**: 実験的機能。GitLab 18.2で導入されました。 |
| <a id="mutationworkitemexportlabelname"></a>`labelName` | [`[String!]`](#string) | 作業アイテムに適用されるラベル。 |
| <a id="mutationworkitemexportmilestonetitle"></a>`milestoneTitle` | [`[String!]`](#string) | 作業アイテムに適用されるマイルストーン。 |
| <a id="mutationworkitemexportmilestonewildcardid"></a>`milestoneWildcardId` | [`MilestoneWildcardId`](#milestonewildcardid) | マイルストーンIDのワイルドカードでフィルタリングします。`milestoneTitle`と互換性がありません。 |
| <a id="mutationworkitemexportmyreactionemoji"></a>`myReactionEmoji` | [`String`](#string) | 現在のユーザーが適用したリアクション絵文字でフィルタリングします。ワイルドカード値として`NONE`と`ANY`がサポートされています。 |
| <a id="mutationworkitemexportnot"></a>`not` | [`NegatedWorkItemFilterInput`](#negatedworkitemfilterinput) | 否定条件となる作業アイテム引数。 |
| <a id="mutationworkitemexportor"></a>`or` | [`UnionedWorkItemFilterInput`](#unionedworkitemfilterinput) | 引数のリストのインクルーシブ`OR`結合。 |
| <a id="mutationworkitemexportparentids"></a>`parentIds` | [`[WorkItemID!]`](#workitemid) | 親アイテムのグローバルIDで作業アイテムをフィルタリングします（最大100アイテム）。 |
| <a id="mutationworkitemexportprojectpath"></a>`projectPath` | [`ID!`](#id) | プロジェクトのフルパス。 |
| <a id="mutationworkitemexportreleasetag"></a>`releaseTag` | [`[String!]`](#string) | 作業アイテムのマイルストーンに関連付けられたリリースタグ。親がグループの場合、無視されます。 |
| <a id="mutationworkitemexportreleasetagwildcardid"></a>`releaseTagWildcardId` | [`ReleaseTagWildcardId`](#releasetagwildcardid) | リリースタグのワイルドカードでフィルタリングします。 |
| <a id="mutationworkitemexportsearch"></a>`search` | [`String`](#string) | タイトルまたは説明の検索クエリ。 |
| <a id="mutationworkitemexportselectedfields"></a>`selectedFields` | [`[AvailableExportFields!]`](#availableexportfields) | エクスポート対象として選択されたフィールドのリスト。省略すると、利用可能なすべてのフィールドがエクスポートされます。 |
| <a id="mutationworkitemexportstate"></a>`state` | [`IssuableState`](#issuablestate) | 作業アイテムの現在の状態。 |
| <a id="mutationworkitemexportsubscribed"></a>`subscribed` | [`SubscriptionStatus`](#subscriptionstatus) | 現在のユーザーがサブスクライブしている作業アイテム。 |
| <a id="mutationworkitemexporttypes"></a>`types` | [`[IssueType!]`](#issuetype) | 指定された作業アイテムタイプで作業アイテムをフィルタリングします。 |
| <a id="mutationworkitemexportupdatedafter"></a>`updatedAfter` | [`Time`](#time) | 指定タイムスタンプより後に更新された作業アイテム。 |
| <a id="mutationworkitemexportupdatedbefore"></a>`updatedBefore` | [`Time`](#time) | 指定タイムスタンプより前に更新された作業アイテム。 |
| <a id="mutationworkitemexportweight"></a>`weight` {{< icon name="warning-solid" >}} | [`String`](#string) | **非推奨**: **状態**: 実験的機能。GitLab 18.2で導入されました。 |
| <a id="mutationworkitemexportweightwildcardid"></a>`weightWildcardId` {{< icon name="warning-solid" >}} | [`WeightWildcardId`](#weightwildcardid) | **非推奨**: **状態**: 実験的機能。GitLab 18.2で導入されました。 |

#### フィールド {#fields-517}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemexportclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemexporterrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationworkitemexportmessage"></a>`message` | [`String`](#string) | エクスポートリクエストの結果メッセージ。 |

### `Mutation.workItemHierarchyAddChildrenItems` {#mutationworkitemhierarchyaddchildrenitems}

{{< details >}}GitLab 18.2で**導入**されました。**状態**: 実験的機能。{{< /details >}}

グローバルIDで、指定された作業アイテムの階層に子アイテムを追加します。

入力型: `WorkItemHierarchyAddChildrenItemsInput`

#### 引数 {#arguments-613}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemhierarchyaddchildrenitemschildrenids"></a>`childrenIds` | [`[WorkItemID!]!`](#workitemid) | 子作業アイテムのグローバルID。 |
| <a id="mutationworkitemhierarchyaddchildrenitemsclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemhierarchyaddchildrenitemsid"></a>`id` | [`WorkItemID!`](#workitemid) | 作業アイテムのグローバルID。 |

#### フィールド {#fields-518}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemhierarchyaddchildrenitemsaddedchildren"></a>`addedChildren` | [`[WorkItem!]!`](#workitem) | 子として追加された作業アイテム。 |
| <a id="mutationworkitemhierarchyaddchildrenitemsclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemhierarchyaddchildrenitemserrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |

### `Mutation.workItemRemoveLinkedItems` {#mutationworkitemremovelinkeditems}

{{< details >}}GitLab 16.3で**導入**されました。**状態**: 実験的機能。{{< /details >}}

作業アイテムにリンクされているアイテムを削除します。

入力型: `WorkItemRemoveLinkedItemsInput`

#### 引数 {#arguments-614}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemremovelinkeditemsclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemremovelinkeditemsid"></a>`id` | [`WorkItemID!`](#workitemid) | 作業アイテムのグローバルID。 |
| <a id="mutationworkitemremovelinkeditemsworkitemsids"></a>`workItemsIds` | [`[WorkItemID!]!`](#workitemid) | リンクを解除するアイテムのグローバルID。指定できるIDの最大数: 10。 |

#### フィールド {#fields-519}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemremovelinkeditemsclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemremovelinkeditemserrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationworkitemremovelinkeditemsmessage"></a>`message` | [`String`](#string) | リンクされたアイテムの更新結果メッセージ。 |
| <a id="mutationworkitemremovelinkeditemsworkitem"></a>`workItem` | [`WorkItem`](#workitem) | 更新された作業アイテム。 |

### `Mutation.workItemSubscribe` {#mutationworkitemsubscribe}

{{< details >}}GitLab 16.3で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `WorkItemSubscribeInput`

#### 引数 {#arguments-615}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemsubscribeclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemsubscribeid"></a>`id` | [`WorkItemID!`](#workitemid) | 作業アイテムのグローバルID。 |
| <a id="mutationworkitemsubscribesubscribed"></a>`subscribed` | [`Boolean!`](#boolean) | サブスクリプションの望ましい状態。 |

#### フィールド {#fields-520}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemsubscribeclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemsubscribeerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationworkitemsubscribeworkitem"></a>`workItem` | [`WorkItem`](#workitem) | ミューテーション後の作業アイテム。 |

### `Mutation.workItemUpdate` {#mutationworkitemupdate}

{{< details >}}GitLab 15.1で**導入**されました。**状態**: 実験的機能。{{< /details >}}

グローバルIDで作業アイテムを更新します。

入力型: `WorkItemUpdateInput`

#### 引数 {#arguments-616}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemupdateassigneeswidget"></a>`assigneesWidget` | [`WorkItemWidgetAssigneesInput`](#workitemwidgetassigneesinput) | 担当者ウィジェットのインプット。 |
| <a id="mutationworkitemupdateawardemojiwidget"></a>`awardEmojiWidget` | [`WorkItemWidgetAwardEmojiUpdateInput`](#workitemwidgetawardemojiupdateinput) | 絵文字リアクションウィジェットのインプット。 |
| <a id="mutationworkitemupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemupdatecolorwidget"></a>`colorWidget` | [`WorkItemWidgetColorInput`](#workitemwidgetcolorinput) | カラーウィジェットのインプット。 |
| <a id="mutationworkitemupdateconfidential"></a>`confidential` | [`Boolean`](#boolean) | 作業アイテムの機密性を設定します。 |
| <a id="mutationworkitemupdatecrmcontactswidget"></a>`crmContactsWidget` | [`WorkItemWidgetCrmContactsUpdateInput`](#workitemwidgetcrmcontactsupdateinput) | CRM連絡先ウィジェットのインプット。 |
| <a id="mutationworkitemupdatecurrentusertodoswidget"></a>`currentUserTodosWidget` | [`WorkItemWidgetCurrentUserTodosInput`](#workitemwidgetcurrentusertodosinput) | To Doウィジェットのインプット。 |
| <a id="mutationworkitemupdatecustomfieldswidget"></a>`customFieldsWidget` {{< icon name="warning-solid" >}} | [`[WorkItemWidgetCustomFieldValueInputType!]`](#workitemwidgetcustomfieldvalueinputtype) | **非推奨**: **状態**: 実験的機能。GitLab 17.10で導入されました。 |
| <a id="mutationworkitemupdatedescriptionwidget"></a>`descriptionWidget` | [`WorkItemWidgetDescriptionInput`](#workitemwidgetdescriptioninput) | 説明ウィジェットのインプット。 |
| <a id="mutationworkitemupdatehealthstatuswidget"></a>`healthStatusWidget` | [`WorkItemWidgetHealthStatusInput`](#workitemwidgethealthstatusinput) | ヘルスステータスウィジェットのインプット。 |
| <a id="mutationworkitemupdatehierarchywidget"></a>`hierarchyWidget` | [`WorkItemWidgetHierarchyUpdateInput`](#workitemwidgethierarchyupdateinput) | 階層ウィジェットのインプット。 |
| <a id="mutationworkitemupdateid"></a>`id` | [`WorkItemID!`](#workitemid) | 作業アイテムのグローバルID。 |
| <a id="mutationworkitemupdateiterationwidget"></a>`iterationWidget` | [`WorkItemWidgetIterationInput`](#workitemwidgetiterationinput) | イテレーションウィジェットのインプット。 |
| <a id="mutationworkitemupdatelabelswidget"></a>`labelsWidget` | [`WorkItemWidgetLabelsUpdateInput`](#workitemwidgetlabelsupdateinput) | ラベルウィジェットのインプット。 |
| <a id="mutationworkitemupdatemilestonewidget"></a>`milestoneWidget` | [`WorkItemWidgetMilestoneInput`](#workitemwidgetmilestoneinput) | マイルストーンウィジェットのインプット。 |
| <a id="mutationworkitemupdatenoteswidget"></a>`notesWidget` | [`WorkItemWidgetNotesInput`](#workitemwidgetnotesinput) | ノートウィジェットのインプット。 |
| <a id="mutationworkitemupdatenotificationswidget"></a>`notificationsWidget` | [`WorkItemWidgetNotificationsUpdateInput`](#workitemwidgetnotificationsupdateinput) | 通知ウィジェットのインプット。 |
| <a id="mutationworkitemupdateprogresswidget"></a>`progressWidget` | [`WorkItemWidgetProgressInput`](#workitemwidgetprogressinput) | 進捗状況ウィジェットのインプット。 |
| <a id="mutationworkitemupdatestartandduedatewidget"></a>`startAndDueDateWidget` | [`WorkItemWidgetStartAndDueDateUpdateInput`](#workitemwidgetstartandduedateupdateinput) | 開始日と期限ウィジェットのインプット。 |
| <a id="mutationworkitemupdatestateevent"></a>`stateEvent` | [`WorkItemStateEvent`](#workitemstateevent) | 作業アイテムを完了または再オープンします。 |
| <a id="mutationworkitemupdatestatuswidget"></a>`statusWidget` {{< icon name="warning-solid" >}} | [`WorkItemWidgetStatusInput`](#workitemwidgetstatusinput) | **非推奨**: **状態**: 実験的機能。GitLab 17.11で導入されました。 |
| <a id="mutationworkitemupdatetimetrackingwidget"></a>`timeTrackingWidget` | [`WorkItemWidgetTimeTrackingInput`](#workitemwidgettimetrackinginput) | タイムトラッキングウィジェットのインプット。 |
| <a id="mutationworkitemupdatetitle"></a>`title` | [`String`](#string) | 作業アイテムのタイトル。 |
| <a id="mutationworkitemupdateverificationstatuswidget"></a>`verificationStatusWidget` | [`VerificationStatusInput`](#verificationstatusinput) | 検証ステータスウィジェットのインプット。 |
| <a id="mutationworkitemupdateweightwidget"></a>`weightWidget` | [`WorkItemWidgetWeightInput`](#workitemwidgetweightinput) | ウェイトウィジェットのインプット。 |

#### フィールド {#fields-521}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationworkitemupdateworkitem"></a>`workItem` | [`WorkItem`](#workitem) | 更新された作業アイテム。 |

### `Mutation.workItemUserPreferenceUpdate` {#mutationworkitemuserpreferenceupdate}

{{< details >}}GitLab 17.10で**導入**されました。**状態**: 実験的機能。{{< /details >}}

作業アイテムタイプとネームスペースのユーザープリファレンスを作成または更新します。

入力型: `WorkItemUserPreferenceUpdateInput`

#### 引数 {#arguments-617}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemuserpreferenceupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemuserpreferenceupdatedisplaysettings"></a>`displaySettings` | [`JSON`](#json) | 作業アイテムリストの表示設定。 |
| <a id="mutationworkitemuserpreferenceupdatenamespacepath"></a>`namespacePath` | [`ID!`](#id) | プリファレンスを設定するネームスペースのフルパス。 |
| <a id="mutationworkitemuserpreferenceupdatesort"></a>`sort` | [`WorkItemSort`](#workitemsort) | 作業アイテムリストのソート順。 |
| <a id="mutationworkitemuserpreferenceupdateworkitemtypeid"></a>`workItemTypeId` | [`WorkItemsTypeID`](#workitemstypeid) | 作業アイテムタイプのグローバルID。 |

#### フィールド {#fields-522}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemuserpreferenceupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemuserpreferenceupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationworkitemuserpreferenceupdateuserpreferences"></a>`userPreferences` | [`WorkItemTypesUserPreference`](#workitemtypesuserpreference) | ユーザープリファレンス。 |

### `Mutation.workItemsCsvExport` {#mutationworkitemscsvexport}

{{< details >}}GitLab 15.10で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `WorkItemsCsvExportInput`

#### 引数 {#arguments-618}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemscsvexportassigneeusernames"></a>`assigneeUsernames` | [`[String!]`](#string) | 作業アイテムに割り当てられたユーザーのユーザー名。 |
| <a id="mutationworkitemscsvexportassigneewildcardid"></a>`assigneeWildcardId` | [`AssigneeWildcardId`](#assigneewildcardid) | 担当者のワイルドカードでフィルタリングします。`assigneeUsernames`と互換性がありません。 |
| <a id="mutationworkitemscsvexportauthorusername"></a>`authorUsername` | [`String`](#string) | 作業アイテムを作成者のユーザー名でフィルタリングします。 |
| <a id="mutationworkitemscsvexportclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemscsvexportclosedafter"></a>`closedAfter` | [`Time`](#time) | 指定日より後に完了した作業アイテム。 |
| <a id="mutationworkitemscsvexportclosedbefore"></a>`closedBefore` | [`Time`](#time) | 指定日より前に完了した作業アイテム。 |
| <a id="mutationworkitemscsvexportconfidential"></a>`confidential` | [`Boolean`](#boolean) | 機密情報作業アイテムをフィルタリングします。`false`の場合、機密情報作業アイテムを除外します。`true`の場合、機密情報作業アイテムのみ返します。 |
| <a id="mutationworkitemscsvexportcreatedafter"></a>`createdAfter` | [`Time`](#time) | 指定タイムスタンプより後に作成された作業アイテム。 |
| <a id="mutationworkitemscsvexportcreatedbefore"></a>`createdBefore` | [`Time`](#time) | 指定タイムスタンプより前に作成された作業アイテム。 |
| <a id="mutationworkitemscsvexportcrmcontactid"></a>`crmContactId` | [`String`](#string) | CRMの連絡先IDでフィルタリングします。 |
| <a id="mutationworkitemscsvexportcrmorganizationid"></a>`crmOrganizationId` | [`String`](#string) | CRMの連絡先組織IDでフィルタリングします。 |
| <a id="mutationworkitemscsvexportdueafter"></a>`dueAfter` | [`Time`](#time) | 指定タイムスタンプより後に期限切れになる作業アイテム。 |
| <a id="mutationworkitemscsvexportduebefore"></a>`dueBefore` | [`Time`](#time) | 指定タイムスタンプより前に期限切れになる作業アイテム。 |
| <a id="mutationworkitemscsvexporthealthstatusfilter"></a>`healthStatusFilter` {{< icon name="warning-solid" >}} | [`HealthStatusFilter`](#healthstatusfilter) | **非推奨**: **状態**: 実験的機能。GitLab 18.2で導入されました。 |
| <a id="mutationworkitemscsvexporthierarchyfilters"></a>`hierarchyFilters` {{< icon name="warning-solid" >}} | [`HierarchyFilterInput`](#hierarchyfilterinput) | **非推奨**: **状態**: 実験的機能。GitLab 18.3で導入されました。 |
| <a id="mutationworkitemscsvexportiids"></a>`iids` | [`[String!]`](#string) | 作業アイテムのIIDのリスト。例: `["1", "2"]`。 |
| <a id="mutationworkitemscsvexportin"></a>`in` | [`[IssuableSearchableField!]`](#issuablesearchablefield) | 検索を実行するフィールドを指定します。デフォルトは`[TITLE, DESCRIPTION]`です。`search`引数が必要です。 |
| <a id="mutationworkitemscsvexportincludedescendantworkitems"></a>`includeDescendantWorkItems` {{< icon name="warning-solid" >}} | [`Boolean`](#boolean) | **非推奨**: **状態**: 実験的機能。GitLab 18.3で導入されました。 |
| <a id="mutationworkitemscsvexportiterationcadenceid"></a>`iterationCadenceId` {{< icon name="warning-solid" >}} | [`[IterationsCadenceID!]`](#iterationscadenceid) | **非推奨**: **状態**: 実験的機能。GitLab 18.2で導入されました。 |
| <a id="mutationworkitemscsvexportiterationid"></a>`iterationId` {{< icon name="warning-solid" >}} | [`[ID]`](#id) | **非推奨**: **状態**: 実験的機能。GitLab 18.2で導入されました。 |
| <a id="mutationworkitemscsvexportiterationwildcardid"></a>`iterationWildcardId` {{< icon name="warning-solid" >}} | [`IterationWildcardId`](#iterationwildcardid) | **非推奨**: **状態**: 実験的機能。GitLab 18.2で導入されました。 |
| <a id="mutationworkitemscsvexportlabelname"></a>`labelName` | [`[String!]`](#string) | 作業アイテムに適用されるラベル。 |
| <a id="mutationworkitemscsvexportmilestonetitle"></a>`milestoneTitle` | [`[String!]`](#string) | 作業アイテムに適用されるマイルストーン。 |
| <a id="mutationworkitemscsvexportmilestonewildcardid"></a>`milestoneWildcardId` | [`MilestoneWildcardId`](#milestonewildcardid) | マイルストーンIDのワイルドカードでフィルタリングします。`milestoneTitle`と互換性がありません。 |
| <a id="mutationworkitemscsvexportmyreactionemoji"></a>`myReactionEmoji` | [`String`](#string) | 現在のユーザーが適用したリアクション絵文字でフィルタリングします。ワイルドカード値として`NONE`と`ANY`がサポートされています。 |
| <a id="mutationworkitemscsvexportnot"></a>`not` | [`NegatedWorkItemFilterInput`](#negatedworkitemfilterinput) | 否定条件となる作業アイテム引数。 |
| <a id="mutationworkitemscsvexportor"></a>`or` | [`UnionedWorkItemFilterInput`](#unionedworkitemfilterinput) | 引数のリストのインクルーシブ`OR`結合。 |
| <a id="mutationworkitemscsvexportparentids"></a>`parentIds` | [`[WorkItemID!]`](#workitemid) | 親アイテムのグローバルIDで作業アイテムをフィルタリングします（最大100アイテム）。 |
| <a id="mutationworkitemscsvexportprojectpath"></a>`projectPath` | [`ID!`](#id) | プロジェクトのフルパス。 |
| <a id="mutationworkitemscsvexportreleasetag"></a>`releaseTag` | [`[String!]`](#string) | 作業アイテムのマイルストーンに関連付けられたリリースタグ。親がグループの場合、無視されます。 |
| <a id="mutationworkitemscsvexportreleasetagwildcardid"></a>`releaseTagWildcardId` | [`ReleaseTagWildcardId`](#releasetagwildcardid) | リリースタグのワイルドカードでフィルタリングします。 |
| <a id="mutationworkitemscsvexportsearch"></a>`search` | [`String`](#string) | タイトルまたは説明の検索クエリ。 |
| <a id="mutationworkitemscsvexportselectedfields"></a>`selectedFields` | [`[AvailableExportFields!]`](#availableexportfields) | エクスポート対象として選択されたフィールドのリスト。省略すると、利用可能なすべてのフィールドがエクスポートされます。 |
| <a id="mutationworkitemscsvexportstate"></a>`state` | [`IssuableState`](#issuablestate) | 作業アイテムの現在の状態。 |
| <a id="mutationworkitemscsvexportsubscribed"></a>`subscribed` | [`SubscriptionStatus`](#subscriptionstatus) | 現在のユーザーがサブスクライブしている作業アイテム。 |
| <a id="mutationworkitemscsvexporttypes"></a>`types` | [`[IssueType!]`](#issuetype) | 指定された作業アイテムタイプで作業アイテムをフィルタリングします。 |
| <a id="mutationworkitemscsvexportupdatedafter"></a>`updatedAfter` | [`Time`](#time) | 指定タイムスタンプより後に更新された作業アイテム。 |
| <a id="mutationworkitemscsvexportupdatedbefore"></a>`updatedBefore` | [`Time`](#time) | 指定タイムスタンプより前に更新された作業アイテム。 |
| <a id="mutationworkitemscsvexportweight"></a>`weight` {{< icon name="warning-solid" >}} | [`String`](#string) | **非推奨**: **状態**: 実験的機能。GitLab 18.2で導入されました。 |
| <a id="mutationworkitemscsvexportweightwildcardid"></a>`weightWildcardId` {{< icon name="warning-solid" >}} | [`WeightWildcardId`](#weightwildcardid) | **非推奨**: **状態**: 実験的機能。GitLab 18.2で導入されました。 |

#### フィールド {#fields-523}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemscsvexportclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemscsvexporterrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationworkitemscsvexportmessage"></a>`message` | [`String`](#string) | エクスポートリクエストの結果メッセージ。 |

### `Mutation.workItemsCsvImport` {#mutationworkitemscsvimport}

{{< details >}}GitLab 18.2で**導入**されました。**状態**: 実験的機能。{{< /details >}}

入力型: `WorkItemsCsvImportInput`

#### 引数 {#arguments-619}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemscsvimportclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemscsvimportfile"></a>`file` | [`Upload!`](#upload) | 作業アイテムからインポートするCSVファイル。 |
| <a id="mutationworkitemscsvimportprojectpath"></a>`projectPath` | [`ID!`](#id) | プロジェクトのフルパス。 |

#### フィールド {#fields-524}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemscsvimportclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemscsvimporterrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationworkitemscsvimportmessage"></a>`message` | [`String`](#string) | インポートリクエストの結果メッセージ。 |

### `Mutation.workItemsHierarchyReorder` {#mutationworkitemshierarchyreorder}

{{< details >}}GitLab 17.3で**導入**されました。**状態**: 実験的機能。{{< /details >}}

階層ツリー内の作業アイテムを並べ替えます。

入力型: `workItemsHierarchyReorderInput`

#### 引数 {#arguments-620}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemshierarchyreorderadjacentworkitemid"></a>`adjacentWorkItemId` | [`WorkItemID`](#workitemid) | 次に移動する作業アイテムのID。上のアイテムや下のアイテムなど。 |
| <a id="mutationworkitemshierarchyreorderclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemshierarchyreorderid"></a>`id` | [`WorkItemID!`](#workitemid) | 並べ替える作業アイテムのグローバルID。 |
| <a id="mutationworkitemshierarchyreorderparentid"></a>`parentId` | [`WorkItemID`](#workitemid) | 新しい親作業アイテムのグローバルID。 |
| <a id="mutationworkitemshierarchyreorderrelativeposition"></a>`relativePosition` | [`RelativePositionType`](#relativepositiontype) | 隣接する作業アイテムを基準とする相対位置。有効な値は`BEFORE`または`AFTER`です。 |

#### フィールド {#fields-525}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemshierarchyreorderadjacentworkitem"></a>`adjacentWorkItem` | [`WorkItem`](#workitem) | ミューテーション後の隣接する作業アイテム。 |
| <a id="mutationworkitemshierarchyreorderclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemshierarchyreordererrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationworkitemshierarchyreorderparentworkitem"></a>`parentWorkItem` | [`WorkItem`](#workitem) | ミューテーション後の作業アイテムの親。 |
| <a id="mutationworkitemshierarchyreorderworkitem"></a>`workItem` | [`WorkItem`](#workitem) | ミューテーション後の作業アイテム。 |

### `Mutation.workItemsReorder` {#mutationworkitemsreorder}

{{< details >}}GitLab 18.3で**導入**されました。**状態**: 実験的機能。{{< /details >}}

プロジェクトレベルの作業アイテムを並べ替えます。

入力型: `workItemsReorderInput`

#### 引数 {#arguments-621}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemsreorderclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemsreorderid"></a>`id` | [`WorkItemID!`](#workitemid) | 並べ替える作業アイテムのグローバルID。 |
| <a id="mutationworkitemsreordermoveafterid"></a>`moveAfterId` | [`WorkItemID`](#workitemid) | 作業アイテムの後に配置する必要があるプロジェクトの作業アイテムのグローバルID。 |
| <a id="mutationworkitemsreordermovebeforeid"></a>`moveBeforeId` | [`WorkItemID`](#workitemid) | 作業アイテムの前に配置する必要があるプロジェクトの作業アイテムのグローバルID。 |

#### フィールド {#fields-526}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkitemsreorderclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationworkitemsreordererrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationworkitemsreorderworkitem"></a>`workItem` | [`WorkItem`](#workitem) | ミューテーション後の作業アイテム。 |

### `Mutation.workspaceCreate` {#mutationworkspacecreate}

入力型: `WorkspaceCreateInput`

#### 引数 {#arguments-622}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkspacecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationworkspacecreateclusteragentid"></a>`clusterAgentId` | [`ClustersAgentID!`](#clustersagentid) | 作成されたワークスペースが関連付けられるクラスターエージェントのGlobalID。 |
| <a id="mutationworkspacecreatedesiredstate"></a>`desiredState` | [`String!`](#string) | 作成されたワークスペースの望ましい状態。 |
| <a id="mutationworkspacecreatedevfilepath"></a>`devfilePath` | [`String`](#string) | ワークスペースの設定に使用するdevfileを含むプロジェクトパス。指定されていない場合、GitLabのデフォルトdevfileが使用されます。 |
| <a id="mutationworkspacecreatedevfileref"></a>`devfileRef` {{< icon name="warning-solid" >}} | [`String`](#string) | **非推奨**: 引数の名前がproject_refに変更されました。GitLab 17.8で非推奨になりました。 |
| <a id="mutationworkspacecreateeditor"></a>`editor` {{< icon name="warning-solid" >}} | [`String`](#string) | **非推奨**: 引数は使用されません。GitLab 17.5で非推奨になりました。 |
| <a id="mutationworkspacecreatemaxhoursbeforetermination"></a>`maxHoursBeforeTermination` {{< icon name="warning-solid" >}} | [`Int`](#int) | **非推奨**: フィールドは使用されていません。GitLab 17.9で非推奨になりました。 |
| <a id="mutationworkspacecreateprojectid"></a>`projectId` | [`ProjectID!`](#projectid) | 作成されたワークスペースのdevfileを提供するプロジェクトのID。 |
| <a id="mutationworkspacecreateprojectref"></a>`projectRef` | [`String`](#string) | プロジェクトリポジトリのgit ref。 |
| <a id="mutationworkspacecreatevariables"></a>`variables` {{< icon name="warning-solid" >}} | [`[WorkspaceVariableInput!]`](#workspacevariableinput) | **非推奨**: 引数はworkspace_variablesに名前が変更されました。GitLab 18.0で非推奨になりました。 |
| <a id="mutationworkspacecreateworkspacevariables"></a>`workspaceVariables` {{< icon name="warning-solid" >}} | [`[WorkspaceVariableInput!]`](#workspacevariableinput) | **非推奨**: **状態**: 実験的機能。GitLab 18.0で導入されました。 |

#### フィールド {#fields-527}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkspacecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationworkspacecreateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationworkspacecreateworkspace"></a>`workspace` | [`Workspace`](#workspace) | 作成されたワークスペース。 |

### `Mutation.workspaceUpdate` {#mutationworkspaceupdate}

入力型: `WorkspaceUpdateInput`

#### 引数 {#arguments-623}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkspaceupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationworkspaceupdatedesiredstate"></a>`desiredState` | [`String!`](#string) | 作成されたワークスペースの望ましい状態。 |
| <a id="mutationworkspaceupdateid"></a>`id` | [`RemoteDevelopmentWorkspaceID!`](#remotedevelopmentworkspaceid) | ワークスペースのグローバルID。 |

#### フィールド {#fields-528}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mutationworkspaceupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | ミューテーションを実行しているクライアントの固有識別子。 |
| <a id="mutationworkspaceupdateerrors"></a>`errors` | [`[String!]!`](#string) | ミューテーション中に発生したエラー。 |
| <a id="mutationworkspaceupdateworkspace"></a>`workspace` | [`Workspace`](#workspace) | 作成されたワークスペース。 |

## 接続 {#connections}

スキーマ内の一部の型は`Connection`型です。これらは、グラフ内の2つのノード間のエッジのページネーションコレクションを表します。これらは、[Relayカーソル接続仕様](https://relay.dev/graphql/connections.htm)に従います。

### ページネーションの引数 {#pagination-arguments}

どの接続フィールドも、次のページネーション引数をサポートしています。

| 名前 | 型 | 説明 |
|------|------|-------------|
| `after` | [`String`](#string) | リストのうち指定されたカーソルより後にある要素を返します。 |
| `before` | [`String`](#string) | リストのうち指定されたカーソルより前にある要素を返します。 |
| `first` | [`Int`](#int) | リストのうち最初の_n_個の要素を返します。 |
| `last` | [`Int`](#int) | リストのうち最後の_n_個の要素を返します。 |

これらの引数はすべての接続フィールドに共通であるため、接続ごとに繰り返されることはありません。

### 接続フィールド {#connection-fields}

すべての接続には、少なくとも次のフィールドがあります。

| 名前 | 型 | 説明 |
|------|------|-------------|
| `pageInfo` | [`PageInfo!`](#pageinfo) | ページネーション情報。 |
| `edges` | `[edge!]` | エッジ。 |
| `nodes` | `[item!]` | 現在のページのアイテム。 |

`Edge`と`Item`の正確な型は、接続のタイプによって異なります。[`ProjectConnection`](#projectconnection)には、[`[Project!]`](#project)型のノードと、[`ProjectEdge`](#projectedge)型のエッジがあります。

### 接続タイプ {#connection-types}

スキーマ内の一部のタイプは、接続のモデル化のためだけに存在しています。各接続には、固有の名前付きタイプと、固有の名前付きエッジタイプがあります。これらについては、別個に下記のリストに示します。

#### `AbuseReportDiscussionConnection` {#abusereportdiscussionconnection}

[`AbuseReportDiscussion`](#abusereportdiscussion)の接続タイプ。

##### フィールド {#fields-529}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="abusereportdiscussionconnectionedges"></a>`edges` | [`[AbuseReportDiscussionEdge]`](#abusereportdiscussionedge) | エッジのリスト。 |
| <a id="abusereportdiscussionconnectionnodes"></a>`nodes` | [`[AbuseReportDiscussion]`](#abusereportdiscussion) | ノードのリスト。 |
| <a id="abusereportdiscussionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AbuseReportDiscussionEdge` {#abusereportdiscussionedge}

[`AbuseReportDiscussion`](#abusereportdiscussion)のエッジ型。

##### フィールド {#fields-530}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="abusereportdiscussionedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="abusereportdiscussionedgenode"></a>`node` | [`AbuseReportDiscussion`](#abusereportdiscussion) | エッジの終端にあるアイテム。 |

#### `AbuseReportLabelConnection` {#abusereportlabelconnection}

[`AbuseReportLabel`](#abusereportlabel)の接続タイプ。

##### フィールド {#fields-531}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="abusereportlabelconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="abusereportlabelconnectionedges"></a>`edges` | [`[AbuseReportLabelEdge]`](#abusereportlabeledge) | エッジのリスト。 |
| <a id="abusereportlabelconnectionnodes"></a>`nodes` | [`[AbuseReportLabel]`](#abusereportlabel) | ノードのリスト。 |
| <a id="abusereportlabelconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AbuseReportLabelEdge` {#abusereportlabeledge}

[`AbuseReportLabel`](#abusereportlabel)のエッジ型。

##### フィールド {#fields-532}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="abusereportlabeledgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="abusereportlabeledgenode"></a>`node` | [`AbuseReportLabel`](#abusereportlabel) | エッジの終端にあるアイテム。 |

#### `AbuseReportNoteConnection` {#abusereportnoteconnection}

[`AbuseReportNote`](#abusereportnote)の接続タイプ。

##### フィールド {#fields-533}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="abusereportnoteconnectionedges"></a>`edges` | [`[AbuseReportNoteEdge]`](#abusereportnoteedge) | エッジのリスト。 |
| <a id="abusereportnoteconnectionnodes"></a>`nodes` | [`[AbuseReportNote]`](#abusereportnote) | ノードのリスト。 |
| <a id="abusereportnoteconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AbuseReportNoteEdge` {#abusereportnoteedge}

[`AbuseReportNote`](#abusereportnote)のエッジ型。

##### フィールド {#fields-534}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="abusereportnoteedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="abusereportnoteedgenode"></a>`node` | [`AbuseReportNote`](#abusereportnote) | エッジの終端にあるアイテム。 |

#### `AccessLevelDeployKeyConnection` {#accessleveldeploykeyconnection}

[`AccessLevelDeployKey`](#accessleveldeploykey)の接続タイプ。

##### フィールド {#fields-535}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="accessleveldeploykeyconnectionedges"></a>`edges` | [`[AccessLevelDeployKeyEdge]`](#accessleveldeploykeyedge) | エッジのリスト。 |
| <a id="accessleveldeploykeyconnectionnodes"></a>`nodes` | [`[AccessLevelDeployKey]`](#accessleveldeploykey) | ノードのリスト。 |
| <a id="accessleveldeploykeyconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AccessLevelDeployKeyEdge` {#accessleveldeploykeyedge}

[`AccessLevelDeployKey`](#accessleveldeploykey)のエッジ型。

##### フィールド {#fields-536}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="accessleveldeploykeyedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="accessleveldeploykeyedgenode"></a>`node` | [`AccessLevelDeployKey`](#accessleveldeploykey) | エッジの終端にあるアイテム。 |

#### `AchievementConnection` {#achievementconnection}

[`Achievement`](#achievement)の接続タイプ。

##### フィールド {#fields-537}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="achievementconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="achievementconnectionedges"></a>`edges` | [`[AchievementEdge]`](#achievementedge) | エッジのリスト。 |
| <a id="achievementconnectionnodes"></a>`nodes` | [`[Achievement]`](#achievement) | ノードのリスト。 |
| <a id="achievementconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AchievementEdge` {#achievementedge}

[`Achievement`](#achievement)のエッジ型。

##### フィールド {#fields-538}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="achievementedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="achievementedgenode"></a>`node` | [`Achievement`](#achievement) | エッジの終端にあるアイテム。 |

#### `AddOnUserConnection` {#addonuserconnection}

[`AddOnUser`](#addonuser)の接続タイプ。

##### フィールド {#fields-539}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="addonuserconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="addonuserconnectionedges"></a>`edges` | [`[AddOnUserEdge]`](#addonuseredge) | エッジのリスト。 |
| <a id="addonuserconnectionnodes"></a>`nodes` | [`[AddOnUser]`](#addonuser) | ノードのリスト。 |
| <a id="addonuserconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AddOnUserEdge` {#addonuseredge}

[`AddOnUser`](#addonuser)のエッジ型。

##### フィールド {#fields-540}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="addonuseredgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="addonuseredgenode"></a>`node` | [`AddOnUser`](#addonuser) | エッジの終端にあるアイテム。 |

#### `AdminMemberRoleConnection` {#adminmemberroleconnection}

[`AdminMemberRole`](#adminmemberrole)の接続タイプ。

##### フィールド {#fields-541}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="adminmemberroleconnectionedges"></a>`edges` | [`[AdminMemberRoleEdge]`](#adminmemberroleedge) | エッジのリスト。 |
| <a id="adminmemberroleconnectionnodes"></a>`nodes` | [`[AdminMemberRole]`](#adminmemberrole) | ノードのリスト。 |
| <a id="adminmemberroleconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AdminMemberRoleEdge` {#adminmemberroleedge}

[`AdminMemberRole`](#adminmemberrole)のエッジ型。

##### フィールド {#fields-542}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="adminmemberroleedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="adminmemberroleedgenode"></a>`node` | [`AdminMemberRole`](#adminmemberrole) | エッジの終端にあるアイテム。 |

#### `AgentConfigurationConnection` {#agentconfigurationconnection}

[`AgentConfiguration`](#agentconfiguration)の接続タイプ。

##### フィールド {#fields-543}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="agentconfigurationconnectionedges"></a>`edges` | [`[AgentConfigurationEdge]`](#agentconfigurationedge) | エッジのリスト。 |
| <a id="agentconfigurationconnectionnodes"></a>`nodes` | [`[AgentConfiguration]`](#agentconfiguration) | ノードのリスト。 |
| <a id="agentconfigurationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AgentConfigurationEdge` {#agentconfigurationedge}

[`AgentConfiguration`](#agentconfiguration)のエッジ型。

##### フィールド {#fields-544}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="agentconfigurationedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="agentconfigurationedgenode"></a>`node` | [`AgentConfiguration`](#agentconfiguration) | エッジの終端にあるアイテム。 |

#### `AiAgentConnection` {#aiagentconnection}

[`AiAgent`](#aiagent)の接続タイプ。

##### フィールド {#fields-545}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aiagentconnectionedges"></a>`edges` | [`[AiAgentEdge]`](#aiagentedge) | エッジのリスト。 |
| <a id="aiagentconnectionnodes"></a>`nodes` | [`[AiAgent]`](#aiagent) | ノードのリスト。 |
| <a id="aiagentconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AiAgentEdge` {#aiagentedge}

[`AiAgent`](#aiagent)のエッジ型。

##### フィールド {#fields-546}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aiagentedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="aiagentedgenode"></a>`node` | [`AiAgent`](#aiagent) | エッジの終端にあるアイテム。 |

#### `AiCatalogBuiltInToolConnection` {#aicatalogbuiltintoolconnection}

[`AiCatalogBuiltInTool`](#aicatalogbuiltintool)の接続タイプ。

##### フィールド {#fields-547}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aicatalogbuiltintoolconnectionedges"></a>`edges` | [`[AiCatalogBuiltInToolEdge]`](#aicatalogbuiltintooledge) | エッジのリスト。 |
| <a id="aicatalogbuiltintoolconnectionnodes"></a>`nodes` | [`[AiCatalogBuiltInTool]`](#aicatalogbuiltintool) | ノードのリスト。 |
| <a id="aicatalogbuiltintoolconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AiCatalogBuiltInToolEdge` {#aicatalogbuiltintooledge}

[`AiCatalogBuiltInTool`](#aicatalogbuiltintool)のエッジ型。

##### フィールド {#fields-548}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aicatalogbuiltintooledgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="aicatalogbuiltintooledgenode"></a>`node` | [`AiCatalogBuiltInTool`](#aicatalogbuiltintool) | エッジの終端にあるアイテム。 |

#### `AiCatalogFlowStepsConnection` {#aicatalogflowstepsconnection}

[`AiCatalogFlowSteps`](#aicatalogflowsteps)の接続タイプ。

##### フィールド {#fields-549}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aicatalogflowstepsconnectionedges"></a>`edges` | [`[AiCatalogFlowStepsEdge]`](#aicatalogflowstepsedge) | エッジのリスト。 |
| <a id="aicatalogflowstepsconnectionnodes"></a>`nodes` | [`[AiCatalogFlowSteps]`](#aicatalogflowsteps) | ノードのリスト。 |
| <a id="aicatalogflowstepsconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AiCatalogFlowStepsEdge` {#aicatalogflowstepsedge}

[`AiCatalogFlowSteps`](#aicatalogflowsteps)のエッジ型。

##### フィールド {#fields-550}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aicatalogflowstepsedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="aicatalogflowstepsedgenode"></a>`node` | [`AiCatalogFlowSteps`](#aicatalogflowsteps) | エッジの終端にあるアイテム。 |

#### `AiCatalogItemConnection` {#aicatalogitemconnection}

[`AiCatalogItem`](#aicatalogitem)の接続タイプ。

##### フィールド {#fields-551}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aicatalogitemconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="aicatalogitemconnectionedges"></a>`edges` | [`[AiCatalogItemEdge]`](#aicatalogitemedge) | エッジのリスト。 |
| <a id="aicatalogitemconnectionnodes"></a>`nodes` | [`[AiCatalogItem]`](#aicatalogitem) | ノードのリスト。 |
| <a id="aicatalogitemconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AiCatalogItemConsumerConnection` {#aicatalogitemconsumerconnection}

[`AiCatalogItemConsumer`](#aicatalogitemconsumer)の接続タイプ。

##### フィールド {#fields-552}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aicatalogitemconsumerconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="aicatalogitemconsumerconnectionedges"></a>`edges` | [`[AiCatalogItemConsumerEdge]`](#aicatalogitemconsumeredge) | エッジのリスト。 |
| <a id="aicatalogitemconsumerconnectionnodes"></a>`nodes` | [`[AiCatalogItemConsumer]`](#aicatalogitemconsumer) | ノードのリスト。 |
| <a id="aicatalogitemconsumerconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AiCatalogItemConsumerEdge` {#aicatalogitemconsumeredge}

[`AiCatalogItemConsumer`](#aicatalogitemconsumer)のエッジ型。

##### フィールド {#fields-553}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aicatalogitemconsumeredgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="aicatalogitemconsumeredgenode"></a>`node` | [`AiCatalogItemConsumer`](#aicatalogitemconsumer) | エッジの終端にあるアイテム。 |

#### `AiCatalogItemEdge` {#aicatalogitemedge}

[`AiCatalogItem`](#aicatalogitem)のエッジ型。

##### フィールド {#fields-554}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aicatalogitemedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="aicatalogitemedgenode"></a>`node` | [`AiCatalogItem`](#aicatalogitem) | エッジの終端にあるアイテム。 |

#### `AiCatalogItemVersionConnection` {#aicatalogitemversionconnection}

[`AiCatalogItemVersion`](#aicatalogitemversion)の接続タイプ。

##### フィールド {#fields-555}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aicatalogitemversionconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="aicatalogitemversionconnectionedges"></a>`edges` | [`[AiCatalogItemVersionEdge]`](#aicatalogitemversionedge) | エッジのリスト。 |
| <a id="aicatalogitemversionconnectionnodes"></a>`nodes` | [`[AiCatalogItemVersion]`](#aicatalogitemversion) | ノードのリスト。 |
| <a id="aicatalogitemversionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AiCatalogItemVersionEdge` {#aicatalogitemversionedge}

[`AiCatalogItemVersion`](#aicatalogitemversion)のエッジ型。

##### フィールド {#fields-556}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aicatalogitemversionedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="aicatalogitemversionedgenode"></a>`node` | [`AiCatalogItemVersion`](#aicatalogitemversion) | エッジの終端にあるアイテム。 |

#### `AiConversationsThreadConnection` {#aiconversationsthreadconnection}

[`AiConversationsThread`](#aiconversationsthread)の接続タイプ。

##### フィールド {#fields-557}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aiconversationsthreadconnectionedges"></a>`edges` | [`[AiConversationsThreadEdge]`](#aiconversationsthreadedge) | エッジのリスト。 |
| <a id="aiconversationsthreadconnectionnodes"></a>`nodes` | [`[AiConversationsThread]`](#aiconversationsthread) | ノードのリスト。 |
| <a id="aiconversationsthreadconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AiConversationsThreadEdge` {#aiconversationsthreadedge}

[`AiConversationsThread`](#aiconversationsthread)のエッジ型。

##### フィールド {#fields-558}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aiconversationsthreadedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="aiconversationsthreadedgenode"></a>`node` | [`AiConversationsThread`](#aiconversationsthread) | エッジの終端にあるアイテム。 |

#### `AiFeatureSettingConnection` {#aifeaturesettingconnection}

[`AiFeatureSetting`](#aifeaturesetting)の接続タイプ。

##### フィールド {#fields-559}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aifeaturesettingconnectionedges"></a>`edges` | [`[AiFeatureSettingEdge]`](#aifeaturesettingedge) | エッジのリスト。 |
| <a id="aifeaturesettingconnectionnodes"></a>`nodes` | [`[AiFeatureSetting]`](#aifeaturesetting) | ノードのリスト。 |
| <a id="aifeaturesettingconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AiFeatureSettingEdge` {#aifeaturesettingedge}

[`AiFeatureSetting`](#aifeaturesetting)のエッジ型。

##### フィールド {#fields-560}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aifeaturesettingedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="aifeaturesettingedgenode"></a>`node` | [`AiFeatureSetting`](#aifeaturesetting) | エッジの終端にあるアイテム。 |

#### `AiFlowTriggerTypeConnection` {#aiflowtriggertypeconnection}

[`AiFlowTriggerType`](#aiflowtriggertype)の接続タイプ。

##### フィールド {#fields-561}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aiflowtriggertypeconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="aiflowtriggertypeconnectionedges"></a>`edges` | [`[AiFlowTriggerTypeEdge]`](#aiflowtriggertypeedge) | エッジのリスト。 |
| <a id="aiflowtriggertypeconnectionnodes"></a>`nodes` | [`[AiFlowTriggerType]`](#aiflowtriggertype) | ノードのリスト。 |
| <a id="aiflowtriggertypeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AiFlowTriggerTypeEdge` {#aiflowtriggertypeedge}

[`AiFlowTriggerType`](#aiflowtriggertype)のエッジ型。

##### フィールド {#fields-562}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aiflowtriggertypeedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="aiflowtriggertypeedgenode"></a>`node` | [`AiFlowTriggerType`](#aiflowtriggertype) | エッジの終端にあるアイテム。 |

#### `AiMessageConnection` {#aimessageconnection}

[`AiMessage`](#aimessage)の接続タイプ。

##### フィールド {#fields-563}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aimessageconnectionedges"></a>`edges` | [`[AiMessageEdge]`](#aimessageedge) | エッジのリスト。 |
| <a id="aimessageconnectionnodes"></a>`nodes` | [`[AiMessage]`](#aimessage) | ノードのリスト。 |
| <a id="aimessageconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AiMessageEdge` {#aimessageedge}

[`AiMessage`](#aimessage)のエッジ型。

##### フィールド {#fields-564}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aimessageedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="aimessageedgenode"></a>`node` | [`AiMessage`](#aimessage) | エッジの終端にあるアイテム。 |

#### `AiModelSelectionNamespaceFeatureSettingConnection` {#aimodelselectionnamespacefeaturesettingconnection}

[`AiModelSelectionNamespaceFeatureSetting`](#aimodelselectionnamespacefeaturesetting)の接続タイプ。

##### フィールド {#fields-565}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aimodelselectionnamespacefeaturesettingconnectionedges"></a>`edges` | [`[AiModelSelectionNamespaceFeatureSettingEdge]`](#aimodelselectionnamespacefeaturesettingedge) | エッジのリスト。 |
| <a id="aimodelselectionnamespacefeaturesettingconnectionnodes"></a>`nodes` | [`[AiModelSelectionNamespaceFeatureSetting]`](#aimodelselectionnamespacefeaturesetting) | ノードのリスト。 |
| <a id="aimodelselectionnamespacefeaturesettingconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AiModelSelectionNamespaceFeatureSettingEdge` {#aimodelselectionnamespacefeaturesettingedge}

[`AiModelSelectionNamespaceFeatureSetting`](#aimodelselectionnamespacefeaturesetting)のエッジ型。

##### フィールド {#fields-566}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aimodelselectionnamespacefeaturesettingedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="aimodelselectionnamespacefeaturesettingedgenode"></a>`node` | [`AiModelSelectionNamespaceFeatureSetting`](#aimodelselectionnamespacefeaturesetting) | エッジの終端にあるアイテム。 |

#### `AiModelSelectionOfferedModelConnection` {#aimodelselectionofferedmodelconnection}

[`AiModelSelectionOfferedModel`](#aimodelselectionofferedmodel)の接続タイプ。

##### フィールド {#fields-567}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aimodelselectionofferedmodelconnectionedges"></a>`edges` | [`[AiModelSelectionOfferedModelEdge]`](#aimodelselectionofferedmodeledge) | エッジのリスト。 |
| <a id="aimodelselectionofferedmodelconnectionnodes"></a>`nodes` | [`[AiModelSelectionOfferedModel]`](#aimodelselectionofferedmodel) | ノードのリスト。 |
| <a id="aimodelselectionofferedmodelconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AiModelSelectionOfferedModelEdge` {#aimodelselectionofferedmodeledge}

[`AiModelSelectionOfferedModel`](#aimodelselectionofferedmodel)のエッジ型。

##### フィールド {#fields-568}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aimodelselectionofferedmodeledgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="aimodelselectionofferedmodeledgenode"></a>`node` | [`AiModelSelectionOfferedModel`](#aimodelselectionofferedmodel) | エッジの終端にあるアイテム。 |

#### `AiSelfHostedModelConnection` {#aiselfhostedmodelconnection}

[`AiSelfHostedModel`](#aiselfhostedmodel)の接続タイプ。

##### フィールド {#fields-569}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aiselfhostedmodelconnectionedges"></a>`edges` | [`[AiSelfHostedModelEdge]`](#aiselfhostedmodeledge) | エッジのリスト。 |
| <a id="aiselfhostedmodelconnectionnodes"></a>`nodes` | [`[AiSelfHostedModel]`](#aiselfhostedmodel) | ノードのリスト。 |
| <a id="aiselfhostedmodelconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AiSelfHostedModelEdge` {#aiselfhostedmodeledge}

[`AiSelfHostedModel`](#aiselfhostedmodel)のエッジ型。

##### フィールド {#fields-570}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aiselfhostedmodeledgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="aiselfhostedmodeledgenode"></a>`node` | [`AiSelfHostedModel`](#aiselfhostedmodel) | エッジの終端にあるアイテム。 |

#### `AiUsageEventConnection` {#aiusageeventconnection}

[`AiUsageEvent`](#aiusageevent)の接続タイプ。

##### フィールド {#fields-571}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aiusageeventconnectionedges"></a>`edges` | [`[AiUsageEventEdge]`](#aiusageeventedge) | エッジのリスト。 |
| <a id="aiusageeventconnectionnodes"></a>`nodes` | [`[AiUsageEvent]`](#aiusageevent) | ノードのリスト。 |
| <a id="aiusageeventconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AiUsageEventEdge` {#aiusageeventedge}

[`AiUsageEvent`](#aiusageevent)のエッジ型。

##### フィールド {#fields-572}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aiusageeventedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="aiusageeventedgenode"></a>`node` | [`AiUsageEvent`](#aiusageevent) | エッジの終端にあるアイテム。 |

#### `AiUserMetricsConnection` {#aiusermetricsconnection}

[`AiUserMetrics`](#aiusermetrics)の接続タイプ。

##### フィールド {#fields-573}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aiusermetricsconnectionedges"></a>`edges` | [`[AiUserMetricsEdge]`](#aiusermetricsedge) | エッジのリスト。 |
| <a id="aiusermetricsconnectionnodes"></a>`nodes` | [`[AiUserMetrics]`](#aiusermetrics) | ノードのリスト。 |
| <a id="aiusermetricsconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AiUserMetricsEdge` {#aiusermetricsedge}

[`AiUserMetrics`](#aiusermetrics)のエッジ型。

##### フィールド {#fields-574}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aiusermetricsedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="aiusermetricsedgenode"></a>`node` | [`AiUserMetrics`](#aiusermetrics) | エッジの終端にあるアイテム。 |

#### `AiXrayReportConnection` {#aixrayreportconnection}

[`AiXrayReport`](#aixrayreport)の接続タイプ。

##### フィールド {#fields-575}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aixrayreportconnectionedges"></a>`edges` | [`[AiXrayReportEdge]`](#aixrayreportedge) | エッジのリスト。 |
| <a id="aixrayreportconnectionnodes"></a>`nodes` | [`[AiXrayReport]`](#aixrayreport) | ノードのリスト。 |
| <a id="aixrayreportconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AiXrayReportEdge` {#aixrayreportedge}

[`AiXrayReport`](#aixrayreport)のエッジ型。

##### フィールド {#fields-576}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="aixrayreportedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="aixrayreportedgenode"></a>`node` | [`AiXrayReport`](#aixrayreport) | エッジの終端にあるアイテム。 |

#### `AlertManagementAlertConnection` {#alertmanagementalertconnection}

[`AlertManagementAlert`](#alertmanagementalert)の接続タイプ。

##### フィールド {#fields-577}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="alertmanagementalertconnectionedges"></a>`edges` | [`[AlertManagementAlertEdge]`](#alertmanagementalertedge) | エッジのリスト。 |
| <a id="alertmanagementalertconnectionnodes"></a>`nodes` | [`[AlertManagementAlert]`](#alertmanagementalert) | ノードのリスト。 |
| <a id="alertmanagementalertconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AlertManagementAlertEdge` {#alertmanagementalertedge}

[`AlertManagementAlert`](#alertmanagementalert)のエッジ型。

##### フィールド {#fields-578}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="alertmanagementalertedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="alertmanagementalertedgenode"></a>`node` | [`AlertManagementAlert`](#alertmanagementalert) | エッジの終端にあるアイテム。 |

#### `AlertManagementHttpIntegrationConnection` {#alertmanagementhttpintegrationconnection}

[`AlertManagementHttpIntegration`](#alertmanagementhttpintegration)の接続タイプ。

##### フィールド {#fields-579}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="alertmanagementhttpintegrationconnectionedges"></a>`edges` | [`[AlertManagementHttpIntegrationEdge]`](#alertmanagementhttpintegrationedge) | エッジのリスト。 |
| <a id="alertmanagementhttpintegrationconnectionnodes"></a>`nodes` | [`[AlertManagementHttpIntegration]`](#alertmanagementhttpintegration) | ノードのリスト。 |
| <a id="alertmanagementhttpintegrationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AlertManagementHttpIntegrationEdge` {#alertmanagementhttpintegrationedge}

[`AlertManagementHttpIntegration`](#alertmanagementhttpintegration)のエッジ型。

##### フィールド {#fields-580}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="alertmanagementhttpintegrationedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="alertmanagementhttpintegrationedgenode"></a>`node` | [`AlertManagementHttpIntegration`](#alertmanagementhttpintegration) | エッジの終端にあるアイテム。 |

#### `AlertManagementIntegrationConnection` {#alertmanagementintegrationconnection}

[`AlertManagementIntegration`](#alertmanagementintegration)の接続タイプ。

##### フィールド {#fields-581}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="alertmanagementintegrationconnectionedges"></a>`edges` | [`[AlertManagementIntegrationEdge]`](#alertmanagementintegrationedge) | エッジのリスト。 |
| <a id="alertmanagementintegrationconnectionnodes"></a>`nodes` | [`[AlertManagementIntegration]`](#alertmanagementintegration) | ノードのリスト。 |
| <a id="alertmanagementintegrationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AlertManagementIntegrationEdge` {#alertmanagementintegrationedge}

[`AlertManagementIntegration`](#alertmanagementintegration)のエッジ型。

##### フィールド {#fields-582}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="alertmanagementintegrationedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="alertmanagementintegrationedgenode"></a>`node` | [`AlertManagementIntegration`](#alertmanagementintegration) | エッジの終端にあるアイテム。 |

#### `AmazonS3ConfigurationTypeConnection` {#amazons3configurationtypeconnection}

[`AmazonS3ConfigurationType`](#amazons3configurationtype)の接続タイプ。

##### フィールド {#fields-583}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="amazons3configurationtypeconnectionedges"></a>`edges` | [`[AmazonS3ConfigurationTypeEdge]`](#amazons3configurationtypeedge) | エッジのリスト。 |
| <a id="amazons3configurationtypeconnectionnodes"></a>`nodes` | [`[AmazonS3ConfigurationType]`](#amazons3configurationtype) | ノードのリスト。 |
| <a id="amazons3configurationtypeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AmazonS3ConfigurationTypeEdge` {#amazons3configurationtypeedge}

[`AmazonS3ConfigurationType`](#amazons3configurationtype)のエッジ型。

##### フィールド {#fields-584}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="amazons3configurationtypeedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="amazons3configurationtypeedgenode"></a>`node` | [`AmazonS3ConfigurationType`](#amazons3configurationtype) | エッジの終端にあるアイテム。 |

#### `ApprovalPolicyConnection` {#approvalpolicyconnection}

[`ApprovalPolicy`](#approvalpolicy)の接続タイプ。

##### フィールド {#fields-585}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="approvalpolicyconnectionedges"></a>`edges` | [`[ApprovalPolicyEdge]`](#approvalpolicyedge) | エッジのリスト。 |
| <a id="approvalpolicyconnectionnodes"></a>`nodes` | [`[ApprovalPolicy]`](#approvalpolicy) | ノードのリスト。 |
| <a id="approvalpolicyconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ApprovalPolicyEdge` {#approvalpolicyedge}

[`ApprovalPolicy`](#approvalpolicy)のエッジ型。

##### フィールド {#fields-586}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="approvalpolicyedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="approvalpolicyedgenode"></a>`node` | [`ApprovalPolicy`](#approvalpolicy) | エッジの終端にあるアイテム。 |

#### `ApprovalProjectRuleConnection` {#approvalprojectruleconnection}

[`ApprovalProjectRule`](#approvalprojectrule)の接続タイプ。

##### フィールド {#fields-587}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="approvalprojectruleconnectionedges"></a>`edges` | [`[ApprovalProjectRuleEdge]`](#approvalprojectruleedge) | エッジのリスト。 |
| <a id="approvalprojectruleconnectionnodes"></a>`nodes` | [`[ApprovalProjectRule]`](#approvalprojectrule) | ノードのリスト。 |
| <a id="approvalprojectruleconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ApprovalProjectRuleEdge` {#approvalprojectruleedge}

[`ApprovalProjectRule`](#approvalprojectrule)のエッジ型。

##### フィールド {#fields-588}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="approvalprojectruleedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="approvalprojectruleedgenode"></a>`node` | [`ApprovalProjectRule`](#approvalprojectrule) | エッジの終端にあるアイテム。 |

#### `AuditEventDefinitionConnection` {#auditeventdefinitionconnection}

[`AuditEventDefinition`](#auditeventdefinition)の接続タイプ。

##### フィールド {#fields-589}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="auditeventdefinitionconnectionedges"></a>`edges` | [`[AuditEventDefinitionEdge]`](#auditeventdefinitionedge) | エッジのリスト。 |
| <a id="auditeventdefinitionconnectionnodes"></a>`nodes` | [`[AuditEventDefinition]`](#auditeventdefinition) | ノードのリスト。 |
| <a id="auditeventdefinitionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AuditEventDefinitionEdge` {#auditeventdefinitionedge}

[`AuditEventDefinition`](#auditeventdefinition)のエッジ型。

##### フィールド {#fields-590}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="auditeventdefinitionedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="auditeventdefinitionedgenode"></a>`node` | [`AuditEventDefinition`](#auditeventdefinition) | エッジの終端にあるアイテム。 |

#### `AuditEventStreamingHeaderConnection` {#auditeventstreamingheaderconnection}

[`AuditEventStreamingHeader`](#auditeventstreamingheader)の接続タイプ。

##### フィールド {#fields-591}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="auditeventstreamingheaderconnectionedges"></a>`edges` | [`[AuditEventStreamingHeaderEdge]`](#auditeventstreamingheaderedge) | エッジのリスト。 |
| <a id="auditeventstreamingheaderconnectionnodes"></a>`nodes` | [`[AuditEventStreamingHeader]`](#auditeventstreamingheader) | ノードのリスト。 |
| <a id="auditeventstreamingheaderconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AuditEventStreamingHeaderEdge` {#auditeventstreamingheaderedge}

[`AuditEventStreamingHeader`](#auditeventstreamingheader)のエッジ型。

##### フィールド {#fields-592}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="auditeventstreamingheaderedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="auditeventstreamingheaderedgenode"></a>`node` | [`AuditEventStreamingHeader`](#auditeventstreamingheader) | エッジの終端にあるアイテム。 |

#### `AuditEventsStreamingInstanceHeaderConnection` {#auditeventsstreaminginstanceheaderconnection}

[`AuditEventsStreamingInstanceHeader`](#auditeventsstreaminginstanceheader)の接続タイプ。

##### フィールド {#fields-593}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="auditeventsstreaminginstanceheaderconnectionedges"></a>`edges` | [`[AuditEventsStreamingInstanceHeaderEdge]`](#auditeventsstreaminginstanceheaderedge) | エッジのリスト。 |
| <a id="auditeventsstreaminginstanceheaderconnectionnodes"></a>`nodes` | [`[AuditEventsStreamingInstanceHeader]`](#auditeventsstreaminginstanceheader) | ノードのリスト。 |
| <a id="auditeventsstreaminginstanceheaderconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AuditEventsStreamingInstanceHeaderEdge` {#auditeventsstreaminginstanceheaderedge}

[`AuditEventsStreamingInstanceHeader`](#auditeventsstreaminginstanceheader)のエッジ型。

##### フィールド {#fields-594}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="auditeventsstreaminginstanceheaderedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="auditeventsstreaminginstanceheaderedgenode"></a>`node` | [`AuditEventsStreamingInstanceHeader`](#auditeventsstreaminginstanceheader) | エッジの終端にあるアイテム。 |

#### `AwardEmojiConnection` {#awardemojiconnection}

[`AwardEmoji`](#awardemoji)の接続タイプ。

##### フィールド {#fields-595}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="awardemojiconnectionedges"></a>`edges` | [`[AwardEmojiEdge]`](#awardemojiedge) | エッジのリスト。 |
| <a id="awardemojiconnectionnodes"></a>`nodes` | [`[AwardEmoji]`](#awardemoji) | ノードのリスト。 |
| <a id="awardemojiconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `AwardEmojiEdge` {#awardemojiedge}

[`AwardEmoji`](#awardemoji)のエッジ型。

##### フィールド {#fields-596}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="awardemojiedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="awardemojiedgenode"></a>`node` | [`AwardEmoji`](#awardemoji) | エッジの終端にあるアイテム。 |

#### `BlobConnection` {#blobconnection}

[`Blob`](#blob)の接続タイプ。

##### フィールド {#fields-597}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="blobconnectionedges"></a>`edges` | [`[BlobEdge]`](#blobedge) | エッジのリスト。 |
| <a id="blobconnectionnodes"></a>`nodes` | [`[Blob]`](#blob) | ノードのリスト。 |
| <a id="blobconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `BlobEdge` {#blobedge}

[`Blob`](#blob)のエッジ型。

##### フィールド {#fields-598}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="blobedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="blobedgenode"></a>`node` | [`Blob`](#blob) | エッジの終端にあるアイテム。 |

#### `BoardConnection` {#boardconnection}

[`Board`](#board)の接続タイプ。

##### フィールド {#fields-599}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="boardconnectionedges"></a>`edges` | [`[BoardEdge]`](#boardedge) | エッジのリスト。 |
| <a id="boardconnectionnodes"></a>`nodes` | [`[Board]`](#board) | ノードのリスト。 |
| <a id="boardconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `BoardEdge` {#boardedge}

[`Board`](#board)のエッジ型。

##### フィールド {#fields-600}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="boardedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="boardedgenode"></a>`node` | [`Board`](#board) | エッジの終端にあるアイテム。 |

#### `BoardEpicConnection` {#boardepicconnection}

[`BoardEpic`](#boardepic)の接続タイプ。

##### フィールド {#fields-601}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="boardepicconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="boardepicconnectionedges"></a>`edges` | [`[BoardEpicEdge]`](#boardepicedge) | エッジのリスト。 |
| <a id="boardepicconnectionnodes"></a>`nodes` | [`[BoardEpic]`](#boardepic) | ノードのリスト。 |
| <a id="boardepicconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `BoardEpicEdge` {#boardepicedge}

[`BoardEpic`](#boardepic)のエッジ型。

##### フィールド {#fields-602}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="boardepicedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="boardepicedgenode"></a>`node` | [`BoardEpic`](#boardepic) | エッジの終端にあるアイテム。 |

#### `BoardListConnection` {#boardlistconnection}

[`BoardList`](#boardlist)の接続タイプ。

##### フィールド {#fields-603}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="boardlistconnectionedges"></a>`edges` | [`[BoardListEdge]`](#boardlistedge) | エッジのリスト。 |
| <a id="boardlistconnectionnodes"></a>`nodes` | [`[BoardList]`](#boardlist) | ノードのリスト。 |
| <a id="boardlistconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `BoardListEdge` {#boardlistedge}

[`BoardList`](#boardlist)のエッジ型。

##### フィールド {#fields-604}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="boardlistedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="boardlistedgenode"></a>`node` | [`BoardList`](#boardlist) | エッジの終端にあるアイテム。 |

#### `BranchRuleConnection` {#branchruleconnection}

[`BranchRule`](#branchrule)の接続タイプ。

##### フィールド {#fields-605}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="branchruleconnectionedges"></a>`edges` | [`[BranchRuleEdge]`](#branchruleedge) | エッジのリスト。 |
| <a id="branchruleconnectionnodes"></a>`nodes` | [`[BranchRule]`](#branchrule) | ノードのリスト。 |
| <a id="branchruleconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `BranchRuleEdge` {#branchruleedge}

[`BranchRule`](#branchrule)のエッジ型。

##### フィールド {#fields-606}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="branchruleedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="branchruleedgenode"></a>`node` | [`BranchRule`](#branchrule) | エッジの終端にあるアイテム。 |

#### `CiBuildNeedConnection` {#cibuildneedconnection}

[`CiBuildNeed`](#cibuildneed)の接続タイプ。

##### フィールド {#fields-607}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cibuildneedconnectionedges"></a>`edges` | [`[CiBuildNeedEdge]`](#cibuildneededge) | エッジのリスト。 |
| <a id="cibuildneedconnectionnodes"></a>`nodes` | [`[CiBuildNeed]`](#cibuildneed) | ノードのリスト。 |
| <a id="cibuildneedconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiBuildNeedEdge` {#cibuildneededge}

[`CiBuildNeed`](#cibuildneed)のエッジ型。

##### フィールド {#fields-608}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cibuildneededgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="cibuildneededgenode"></a>`node` | [`CiBuildNeed`](#cibuildneed) | エッジの終端にあるアイテム。 |

#### `CiCatalogResourceComponentConnection` {#cicatalogresourcecomponentconnection}

[`CiCatalogResourceComponent`](#cicatalogresourcecomponent)の接続タイプ。

##### フィールド {#fields-609}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cicatalogresourcecomponentconnectionedges"></a>`edges` | [`[CiCatalogResourceComponentEdge]`](#cicatalogresourcecomponentedge) | エッジのリスト。 |
| <a id="cicatalogresourcecomponentconnectionnodes"></a>`nodes` | [`[CiCatalogResourceComponent]`](#cicatalogresourcecomponent) | ノードのリスト。 |
| <a id="cicatalogresourcecomponentconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiCatalogResourceComponentEdge` {#cicatalogresourcecomponentedge}

[`CiCatalogResourceComponent`](#cicatalogresourcecomponent)のエッジ型。

##### フィールド {#fields-610}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cicatalogresourcecomponentedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="cicatalogresourcecomponentedgenode"></a>`node` | [`CiCatalogResourceComponent`](#cicatalogresourcecomponent) | エッジの終端にあるアイテム。 |

#### `CiCatalogResourceComponentUsageConnection` {#cicatalogresourcecomponentusageconnection}

[`CiCatalogResourceComponentUsage`](#cicatalogresourcecomponentusage)の接続タイプ。

##### フィールド {#fields-611}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cicatalogresourcecomponentusageconnectionedges"></a>`edges` | [`[CiCatalogResourceComponentUsageEdge]`](#cicatalogresourcecomponentusageedge) | エッジのリスト。 |
| <a id="cicatalogresourcecomponentusageconnectionnodes"></a>`nodes` | [`[CiCatalogResourceComponentUsage]`](#cicatalogresourcecomponentusage) | ノードのリスト。 |
| <a id="cicatalogresourcecomponentusageconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiCatalogResourceComponentUsageEdge` {#cicatalogresourcecomponentusageedge}

[`CiCatalogResourceComponentUsage`](#cicatalogresourcecomponentusage)のエッジ型。

##### フィールド {#fields-612}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cicatalogresourcecomponentusageedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="cicatalogresourcecomponentusageedgenode"></a>`node` | [`CiCatalogResourceComponentUsage`](#cicatalogresourcecomponentusage) | エッジの終端にあるアイテム。 |

#### `CiCatalogResourceConnection` {#cicatalogresourceconnection}

[`CiCatalogResource`](#cicatalogresource)の接続タイプ。

##### フィールド {#fields-613}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cicatalogresourceconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="cicatalogresourceconnectionedges"></a>`edges` | [`[CiCatalogResourceEdge]`](#cicatalogresourceedge) | エッジのリスト。 |
| <a id="cicatalogresourceconnectionnodes"></a>`nodes` | [`[CiCatalogResource]`](#cicatalogresource) | ノードのリスト。 |
| <a id="cicatalogresourceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiCatalogResourceEdge` {#cicatalogresourceedge}

[`CiCatalogResource`](#cicatalogresource)のエッジ型。

##### フィールド {#fields-614}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cicatalogresourceedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="cicatalogresourceedgenode"></a>`node` | [`CiCatalogResource`](#cicatalogresource) | エッジの終端にあるアイテム。 |

#### `CiCatalogResourceVersionConnection` {#cicatalogresourceversionconnection}

[`CiCatalogResourceVersion`](#cicatalogresourceversion)の接続タイプ。

##### フィールド {#fields-615}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cicatalogresourceversionconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="cicatalogresourceversionconnectionedges"></a>`edges` | [`[CiCatalogResourceVersionEdge]`](#cicatalogresourceversionedge) | エッジのリスト。 |
| <a id="cicatalogresourceversionconnectionnodes"></a>`nodes` | [`[CiCatalogResourceVersion]`](#cicatalogresourceversion) | ノードのリスト。 |
| <a id="cicatalogresourceversionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiCatalogResourceVersionEdge` {#cicatalogresourceversionedge}

[`CiCatalogResourceVersion`](#cicatalogresourceversion)のエッジ型。

##### フィールド {#fields-616}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cicatalogresourceversionedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="cicatalogresourceversionedgenode"></a>`node` | [`CiCatalogResourceVersion`](#cicatalogresourceversion) | エッジの終端にあるアイテム。 |

#### `CiConfigGroupConnection` {#ciconfiggroupconnection}

[`CiConfigGroup`](#ciconfiggroup)の接続タイプ。

##### フィールド {#fields-617}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="ciconfiggroupconnectionedges"></a>`edges` | [`[CiConfigGroupEdge]`](#ciconfiggroupedge) | エッジのリスト。 |
| <a id="ciconfiggroupconnectionnodes"></a>`nodes` | [`[CiConfigGroup]`](#ciconfiggroup) | ノードのリスト。 |
| <a id="ciconfiggroupconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiConfigGroupEdge` {#ciconfiggroupedge}

[`CiConfigGroup`](#ciconfiggroup)のエッジ型。

##### フィールド {#fields-618}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="ciconfiggroupedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="ciconfiggroupedgenode"></a>`node` | [`CiConfigGroup`](#ciconfiggroup) | エッジの終端にあるアイテム。 |

#### `CiConfigJobConnection` {#ciconfigjobconnection}

[`CiConfigJob`](#ciconfigjob)の接続タイプ。

##### フィールド {#fields-619}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="ciconfigjobconnectionedges"></a>`edges` | [`[CiConfigJobEdge]`](#ciconfigjobedge) | エッジのリスト。 |
| <a id="ciconfigjobconnectionnodes"></a>`nodes` | [`[CiConfigJob]`](#ciconfigjob) | ノードのリスト。 |
| <a id="ciconfigjobconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiConfigJobEdge` {#ciconfigjobedge}

[`CiConfigJob`](#ciconfigjob)のエッジ型。

##### フィールド {#fields-620}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="ciconfigjobedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="ciconfigjobedgenode"></a>`node` | [`CiConfigJob`](#ciconfigjob) | エッジの終端にあるアイテム。 |

#### `CiConfigNeedConnection` {#ciconfigneedconnection}

[`CiConfigNeed`](#ciconfigneed)の接続タイプ。

##### フィールド {#fields-621}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="ciconfigneedconnectionedges"></a>`edges` | [`[CiConfigNeedEdge]`](#ciconfigneededge) | エッジのリスト。 |
| <a id="ciconfigneedconnectionnodes"></a>`nodes` | [`[CiConfigNeed]`](#ciconfigneed) | ノードのリスト。 |
| <a id="ciconfigneedconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiConfigNeedEdge` {#ciconfigneededge}

[`CiConfigNeed`](#ciconfigneed)のエッジ型。

##### フィールド {#fields-622}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="ciconfigneededgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="ciconfigneededgenode"></a>`node` | [`CiConfigNeed`](#ciconfigneed) | エッジの終端にあるアイテム。 |

#### `CiConfigStageConnection` {#ciconfigstageconnection}

[`CiConfigStage`](#ciconfigstage)の接続タイプ。

##### フィールド {#fields-623}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="ciconfigstageconnectionedges"></a>`edges` | [`[CiConfigStageEdge]`](#ciconfigstageedge) | エッジのリスト。 |
| <a id="ciconfigstageconnectionnodes"></a>`nodes` | [`[CiConfigStage]`](#ciconfigstage) | ノードのリスト。 |
| <a id="ciconfigstageconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiConfigStageEdge` {#ciconfigstageedge}

[`CiConfigStage`](#ciconfigstage)のエッジ型。

##### フィールド {#fields-624}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="ciconfigstageedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="ciconfigstageedgenode"></a>`node` | [`CiConfigStage`](#ciconfigstage) | エッジの終端にあるアイテム。 |

#### `CiDedicatedHostedRunnerUsageConnection` {#cidedicatedhostedrunnerusageconnection}

[`CiDedicatedHostedRunnerUsage`](#cidedicatedhostedrunnerusage)の接続タイプ。

##### フィールド {#fields-625}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cidedicatedhostedrunnerusageconnectionedges"></a>`edges` | [`[CiDedicatedHostedRunnerUsageEdge]`](#cidedicatedhostedrunnerusageedge) | エッジのリスト。 |
| <a id="cidedicatedhostedrunnerusageconnectionnodes"></a>`nodes` | [`[CiDedicatedHostedRunnerUsage]`](#cidedicatedhostedrunnerusage) | ノードのリスト。 |
| <a id="cidedicatedhostedrunnerusageconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiDedicatedHostedRunnerUsageEdge` {#cidedicatedhostedrunnerusageedge}

[`CiDedicatedHostedRunnerUsage`](#cidedicatedhostedrunnerusage)のエッジ型。

##### フィールド {#fields-626}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cidedicatedhostedrunnerusageedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="cidedicatedhostedrunnerusageedgenode"></a>`node` | [`CiDedicatedHostedRunnerUsage`](#cidedicatedhostedrunnerusage) | エッジの終端にあるアイテム。 |

#### `CiDeletedRunnerConnection` {#cideletedrunnerconnection}

[`CiDeletedRunner`](#cideletedrunner)の接続タイプ。

##### フィールド {#fields-627}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cideletedrunnerconnectionedges"></a>`edges` | [`[CiDeletedRunnerEdge]`](#cideletedrunneredge) | エッジのリスト。 |
| <a id="cideletedrunnerconnectionnodes"></a>`nodes` | [`[CiDeletedRunner]`](#cideletedrunner) | ノードのリスト。 |
| <a id="cideletedrunnerconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiDeletedRunnerEdge` {#cideletedrunneredge}

[`CiDeletedRunner`](#cideletedrunner)のエッジ型。

##### フィールド {#fields-628}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cideletedrunneredgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="cideletedrunneredgenode"></a>`node` | [`CiDeletedRunner`](#cideletedrunner) | エッジの終端にあるアイテム。 |

#### `CiGroupConnection` {#cigroupconnection}

[`CiGroup`](#cigroup)の接続タイプ。

##### フィールド {#fields-629}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cigroupconnectionedges"></a>`edges` | [`[CiGroupEdge]`](#cigroupedge) | エッジのリスト。 |
| <a id="cigroupconnectionnodes"></a>`nodes` | [`[CiGroup]`](#cigroup) | ノードのリスト。 |
| <a id="cigroupconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiGroupEdge` {#cigroupedge}

[`CiGroup`](#cigroup)のエッジ型。

##### フィールド {#fields-630}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cigroupedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="cigroupedgenode"></a>`node` | [`CiGroup`](#cigroup) | エッジの終端にあるアイテム。 |

#### `CiGroupEnvironmentScopeConnection` {#cigroupenvironmentscopeconnection}

[`CiGroupEnvironmentScope`](#cigroupenvironmentscope)の接続タイプ。

##### フィールド {#fields-631}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cigroupenvironmentscopeconnectionedges"></a>`edges` | [`[CiGroupEnvironmentScopeEdge]`](#cigroupenvironmentscopeedge) | エッジのリスト。 |
| <a id="cigroupenvironmentscopeconnectionnodes"></a>`nodes` | [`[CiGroupEnvironmentScope]`](#cigroupenvironmentscope) | ノードのリスト。 |
| <a id="cigroupenvironmentscopeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiGroupEnvironmentScopeEdge` {#cigroupenvironmentscopeedge}

[`CiGroupEnvironmentScope`](#cigroupenvironmentscope)のエッジ型。

##### フィールド {#fields-632}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cigroupenvironmentscopeedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="cigroupenvironmentscopeedgenode"></a>`node` | [`CiGroupEnvironmentScope`](#cigroupenvironmentscope) | エッジの終端にあるアイテム。 |

#### `CiGroupVariableConnection` {#cigroupvariableconnection}

[`CiGroupVariable`](#cigroupvariable)の接続タイプ。

##### フィールド {#fields-633}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cigroupvariableconnectionedges"></a>`edges` | [`[CiGroupVariableEdge]`](#cigroupvariableedge) | エッジのリスト。 |
| <a id="cigroupvariableconnectionlimit"></a>`limit` | [`Int!`](#int) | グループCI/CD変数の最大数。 |
| <a id="cigroupvariableconnectionnodes"></a>`nodes` | [`[CiGroupVariable]`](#cigroupvariable) | ノードのリスト。 |
| <a id="cigroupvariableconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiGroupVariableEdge` {#cigroupvariableedge}

[`CiGroupVariable`](#cigroupvariable)のエッジ型。

##### フィールド {#fields-634}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cigroupvariableedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="cigroupvariableedgenode"></a>`node` | [`CiGroupVariable`](#cigroupvariable) | エッジの終端にあるアイテム。 |

#### `CiInputsFieldConnection` {#ciinputsfieldconnection}

[`CiInputsField`](#ciinputsfield)の接続タイプ。

##### フィールド {#fields-635}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="ciinputsfieldconnectionedges"></a>`edges` | [`[CiInputsFieldEdge]`](#ciinputsfieldedge) | エッジのリスト。 |
| <a id="ciinputsfieldconnectionnodes"></a>`nodes` | [`[CiInputsField]`](#ciinputsfield) | ノードのリスト。 |
| <a id="ciinputsfieldconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiInputsFieldEdge` {#ciinputsfieldedge}

[`CiInputsField`](#ciinputsfield)のエッジ型。

##### フィールド {#fields-636}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="ciinputsfieldedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="ciinputsfieldedgenode"></a>`node` | [`CiInputsField`](#ciinputsfield) | エッジの終端にあるアイテム。 |

#### `CiInstanceVariableConnection` {#ciinstancevariableconnection}

[`CiInstanceVariable`](#ciinstancevariable)の接続タイプ。

##### フィールド {#fields-637}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="ciinstancevariableconnectionedges"></a>`edges` | [`[CiInstanceVariableEdge]`](#ciinstancevariableedge) | エッジのリスト。 |
| <a id="ciinstancevariableconnectionnodes"></a>`nodes` | [`[CiInstanceVariable]`](#ciinstancevariable) | ノードのリスト。 |
| <a id="ciinstancevariableconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiInstanceVariableEdge` {#ciinstancevariableedge}

[`CiInstanceVariable`](#ciinstancevariable)のエッジ型。

##### フィールド {#fields-638}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="ciinstancevariableedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="ciinstancevariableedgenode"></a>`node` | [`CiInstanceVariable`](#ciinstancevariable) | エッジの終端にあるアイテム。 |

#### `CiJobArtifactConnection` {#cijobartifactconnection}

[`CiJobArtifact`](#cijobartifact)の接続タイプ。

##### フィールド {#fields-639}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cijobartifactconnectionedges"></a>`edges` | [`[CiJobArtifactEdge]`](#cijobartifactedge) | エッジのリスト。 |
| <a id="cijobartifactconnectionnodes"></a>`nodes` | [`[CiJobArtifact]`](#cijobartifact) | ノードのリスト。 |
| <a id="cijobartifactconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiJobArtifactEdge` {#cijobartifactedge}

[`CiJobArtifact`](#cijobartifact)のエッジ型。

##### フィールド {#fields-640}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cijobartifactedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="cijobartifactedgenode"></a>`node` | [`CiJobArtifact`](#cijobartifact) | エッジの終端にあるアイテム。 |

#### `CiJobConnection` {#cijobconnection}

[`CiJob`](#cijob)の接続タイプ。

##### フィールド {#fields-641}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cijobconnectionedges"></a>`edges` | [`[CiJobEdge]`](#cijobedge) | エッジのリスト。 |
| <a id="cijobconnectionnodes"></a>`nodes` | [`[CiJob]`](#cijob) | ノードのリスト。 |
| <a id="cijobconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

##### 引数のあるフィールド {#fields-with-arguments}

###### `CiJobConnection.count` {#cijobconnectioncount}

コレクションの制限カウント。制限を超えるカウントの場合、制限+1を返します。

[`Int!`](#int)を返します。

\#######引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cijobconnectioncountlimit"></a>`limit` | [`Int`](#int) | カウントクエリに適用される制限値。デフォルトは1000です。 |

#### `CiJobEdge` {#cijobedge}

[`CiJob`](#cijob)のエッジ型。

##### フィールド {#fields-642}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cijobedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="cijobedgenode"></a>`node` | [`CiJob`](#cijob) | エッジの終端にあるアイテム。 |

#### `CiJobInterfaceConnection` {#cijobinterfaceconnection}

[`CiJobInterface`](#cijobinterface)の接続タイプ。

##### フィールド {#fields-643}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cijobinterfaceconnectionedges"></a>`edges` | [`[CiJobInterfaceEdge]`](#cijobinterfaceedge) | エッジのリスト。 |
| <a id="cijobinterfaceconnectionnodes"></a>`nodes` | [`[CiJobInterface]`](#cijobinterface) | ノードのリスト。 |
| <a id="cijobinterfaceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

##### 引数のあるフィールド {#fields-with-arguments-1}

###### `CiJobInterfaceConnection.count` {#cijobinterfaceconnectioncount}

コレクションの制限カウント。制限を超えるカウントの場合、制限+1を返します。

[`Int!`](#int)を返します。

\#######引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cijobinterfaceconnectioncountlimit"></a>`limit` | [`Int`](#int) | カウントクエリに適用される制限値。デフォルトは1000です。 |

#### `CiJobInterfaceEdge` {#cijobinterfaceedge}

[`CiJobInterface`](#cijobinterface)のエッジ型。

##### フィールド {#fields-644}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cijobinterfaceedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="cijobinterfaceedgenode"></a>`node` | [`CiJobInterface`](#cijobinterface) | エッジの終端にあるアイテム。 |

#### `CiJobTokenAccessibleGroupConnection` {#cijobtokenaccessiblegroupconnection}

[`CiJobTokenAccessibleGroup`](#cijobtokenaccessiblegroup)の接続タイプ。

##### フィールド {#fields-645}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cijobtokenaccessiblegroupconnectionedges"></a>`edges` | [`[CiJobTokenAccessibleGroupEdge]`](#cijobtokenaccessiblegroupedge) | エッジのリスト。 |
| <a id="cijobtokenaccessiblegroupconnectionnodes"></a>`nodes` | [`[CiJobTokenAccessibleGroup]`](#cijobtokenaccessiblegroup) | ノードのリスト。 |
| <a id="cijobtokenaccessiblegroupconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiJobTokenAccessibleGroupEdge` {#cijobtokenaccessiblegroupedge}

[`CiJobTokenAccessibleGroup`](#cijobtokenaccessiblegroup)のエッジ型。

##### フィールド {#fields-646}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cijobtokenaccessiblegroupedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="cijobtokenaccessiblegroupedgenode"></a>`node` | [`CiJobTokenAccessibleGroup`](#cijobtokenaccessiblegroup) | エッジの終端にあるアイテム。 |

#### `CiJobTokenAccessibleProjectConnection` {#cijobtokenaccessibleprojectconnection}

[`CiJobTokenAccessibleProject`](#cijobtokenaccessibleproject)の接続タイプ。

##### フィールド {#fields-647}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cijobtokenaccessibleprojectconnectionedges"></a>`edges` | [`[CiJobTokenAccessibleProjectEdge]`](#cijobtokenaccessibleprojectedge) | エッジのリスト。 |
| <a id="cijobtokenaccessibleprojectconnectionnodes"></a>`nodes` | [`[CiJobTokenAccessibleProject]`](#cijobtokenaccessibleproject) | ノードのリスト。 |
| <a id="cijobtokenaccessibleprojectconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiJobTokenAccessibleProjectEdge` {#cijobtokenaccessibleprojectedge}

[`CiJobTokenAccessibleProject`](#cijobtokenaccessibleproject)のエッジ型。

##### フィールド {#fields-648}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cijobtokenaccessibleprojectedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="cijobtokenaccessibleprojectedgenode"></a>`node` | [`CiJobTokenAccessibleProject`](#cijobtokenaccessibleproject) | エッジの終端にあるアイテム。 |

#### `CiJobTokenAuthLogConnection` {#cijobtokenauthlogconnection}

[`CiJobTokenAuthLog`](#cijobtokenauthlog)の接続タイプ。

##### フィールド {#fields-649}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cijobtokenauthlogconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="cijobtokenauthlogconnectionedges"></a>`edges` | [`[CiJobTokenAuthLogEdge]`](#cijobtokenauthlogedge) | エッジのリスト。 |
| <a id="cijobtokenauthlogconnectionnodes"></a>`nodes` | [`[CiJobTokenAuthLog]`](#cijobtokenauthlog) | ノードのリスト。 |
| <a id="cijobtokenauthlogconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiJobTokenAuthLogEdge` {#cijobtokenauthlogedge}

[`CiJobTokenAuthLog`](#cijobtokenauthlog)のエッジ型。

##### フィールド {#fields-650}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cijobtokenauthlogedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="cijobtokenauthlogedgenode"></a>`node` | [`CiJobTokenAuthLog`](#cijobtokenauthlog) | エッジの終端にあるアイテム。 |

#### `CiJobTokenScopeAllowlistEntryConnection` {#cijobtokenscopeallowlistentryconnection}

[`CiJobTokenScopeAllowlistEntry`](#cijobtokenscopeallowlistentry)の接続タイプ。

##### フィールド {#fields-651}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cijobtokenscopeallowlistentryconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="cijobtokenscopeallowlistentryconnectionedges"></a>`edges` | [`[CiJobTokenScopeAllowlistEntryEdge]`](#cijobtokenscopeallowlistentryedge) | エッジのリスト。 |
| <a id="cijobtokenscopeallowlistentryconnectionnodes"></a>`nodes` | [`[CiJobTokenScopeAllowlistEntry]`](#cijobtokenscopeallowlistentry) | ノードのリスト。 |
| <a id="cijobtokenscopeallowlistentryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiJobTokenScopeAllowlistEntryEdge` {#cijobtokenscopeallowlistentryedge}

[`CiJobTokenScopeAllowlistEntry`](#cijobtokenscopeallowlistentry)のエッジ型。

##### フィールド {#fields-652}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cijobtokenscopeallowlistentryedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="cijobtokenscopeallowlistentryedgenode"></a>`node` | [`CiJobTokenScopeAllowlistEntry`](#cijobtokenscopeallowlistentry) | エッジの終端にあるアイテム。 |

#### `CiManualVariableConnection` {#cimanualvariableconnection}

[`CiManualVariable`](#cimanualvariable)の接続タイプ。

##### フィールド {#fields-653}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cimanualvariableconnectionedges"></a>`edges` | [`[CiManualVariableEdge]`](#cimanualvariableedge) | エッジのリスト。 |
| <a id="cimanualvariableconnectionnodes"></a>`nodes` | [`[CiManualVariable]`](#cimanualvariable) | ノードのリスト。 |
| <a id="cimanualvariableconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiManualVariableEdge` {#cimanualvariableedge}

[`CiManualVariable`](#cimanualvariable)のエッジ型。

##### フィールド {#fields-654}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cimanualvariableedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="cimanualvariableedgenode"></a>`node` | [`CiManualVariable`](#cimanualvariable) | エッジの終端にあるアイテム。 |

#### `CiMinutesNamespaceMonthlyUsageConnection` {#ciminutesnamespacemonthlyusageconnection}

[`CiMinutesNamespaceMonthlyUsage`](#ciminutesnamespacemonthlyusage)の接続タイプ。

##### フィールド {#fields-655}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="ciminutesnamespacemonthlyusageconnectionedges"></a>`edges` | [`[CiMinutesNamespaceMonthlyUsageEdge]`](#ciminutesnamespacemonthlyusageedge) | エッジのリスト。 |
| <a id="ciminutesnamespacemonthlyusageconnectionnodes"></a>`nodes` | [`[CiMinutesNamespaceMonthlyUsage]`](#ciminutesnamespacemonthlyusage) | ノードのリスト。 |
| <a id="ciminutesnamespacemonthlyusageconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiMinutesNamespaceMonthlyUsageEdge` {#ciminutesnamespacemonthlyusageedge}

[`CiMinutesNamespaceMonthlyUsage`](#ciminutesnamespacemonthlyusage)のエッジ型。

##### フィールド {#fields-656}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="ciminutesnamespacemonthlyusageedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="ciminutesnamespacemonthlyusageedgenode"></a>`node` | [`CiMinutesNamespaceMonthlyUsage`](#ciminutesnamespacemonthlyusage) | エッジの終端にあるアイテム。 |

#### `CiMinutesProjectMonthlyUsageConnection` {#ciminutesprojectmonthlyusageconnection}

[`CiMinutesProjectMonthlyUsage`](#ciminutesprojectmonthlyusage)の接続タイプ。

##### フィールド {#fields-657}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="ciminutesprojectmonthlyusageconnectionedges"></a>`edges` | [`[CiMinutesProjectMonthlyUsageEdge]`](#ciminutesprojectmonthlyusageedge) | エッジのリスト。 |
| <a id="ciminutesprojectmonthlyusageconnectionnodes"></a>`nodes` | [`[CiMinutesProjectMonthlyUsage]`](#ciminutesprojectmonthlyusage) | ノードのリスト。 |
| <a id="ciminutesprojectmonthlyusageconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiMinutesProjectMonthlyUsageEdge` {#ciminutesprojectmonthlyusageedge}

[`CiMinutesProjectMonthlyUsage`](#ciminutesprojectmonthlyusage)のエッジ型。

##### フィールド {#fields-658}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="ciminutesprojectmonthlyusageedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="ciminutesprojectmonthlyusageedgenode"></a>`node` | [`CiMinutesProjectMonthlyUsage`](#ciminutesprojectmonthlyusage) | エッジの終端にあるアイテム。 |

#### `CiProjectSubscriptionConnection` {#ciprojectsubscriptionconnection}

[`CiProjectSubscription`](#ciprojectsubscription)の接続タイプ。

##### フィールド {#fields-659}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="ciprojectsubscriptionconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="ciprojectsubscriptionconnectionedges"></a>`edges` | [`[CiProjectSubscriptionEdge]`](#ciprojectsubscriptionedge) | エッジのリスト。 |
| <a id="ciprojectsubscriptionconnectionnodes"></a>`nodes` | [`[CiProjectSubscription]`](#ciprojectsubscription) | ノードのリスト。 |
| <a id="ciprojectsubscriptionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiProjectSubscriptionEdge` {#ciprojectsubscriptionedge}

[`CiProjectSubscription`](#ciprojectsubscription)のエッジ型。

##### フィールド {#fields-660}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="ciprojectsubscriptionedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="ciprojectsubscriptionedgenode"></a>`node` | [`CiProjectSubscription`](#ciprojectsubscription) | エッジの終端にあるアイテム。 |

#### `CiProjectVariableConnection` {#ciprojectvariableconnection}

[`CiProjectVariable`](#ciprojectvariable)の接続タイプ。

##### フィールド {#fields-661}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="ciprojectvariableconnectionedges"></a>`edges` | [`[CiProjectVariableEdge]`](#ciprojectvariableedge) | エッジのリスト。 |
| <a id="ciprojectvariableconnectionlimit"></a>`limit` | [`Int!`](#int) | プロジェクトCI/CD変数の最大数。 |
| <a id="ciprojectvariableconnectionnodes"></a>`nodes` | [`[CiProjectVariable]`](#ciprojectvariable) | ノードのリスト。 |
| <a id="ciprojectvariableconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiProjectVariableEdge` {#ciprojectvariableedge}

[`CiProjectVariable`](#ciprojectvariable)のエッジ型。

##### フィールド {#fields-662}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="ciprojectvariableedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="ciprojectvariableedgenode"></a>`node` | [`CiProjectVariable`](#ciprojectvariable) | エッジの終端にあるアイテム。 |

#### `CiRunnerConnection` {#cirunnerconnection}

[`CiRunner`](#cirunner)の接続タイプ。

##### フィールド {#fields-663}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cirunnerconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="cirunnerconnectionedges"></a>`edges` | [`[CiRunnerEdge]`](#cirunneredge) | エッジのリスト。 |
| <a id="cirunnerconnectionjobsstatistics"></a>`jobsStatistics` | [`CiJobsStatistics`](#cijobsstatistics) | Runnerのコレクションによって実行されたジョブの統計。管理者のみが利用できます。 |
| <a id="cirunnerconnectionnodes"></a>`nodes` | [`[CiRunner]`](#cirunner) | ノードのリスト。 |
| <a id="cirunnerconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiRunnerEdge` {#cirunneredge}

[`CiRunner`](#cirunner)のエッジ型。

##### フィールド {#fields-664}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cirunneredgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="cirunneredgeediturl"></a>`editUrl` | [`String`](#string) | Runner編集ページのWeb URL。値は、クエリ内でのフィールドの配置場所によって異なります。プロジェクトまたはグループで使用できます。 |
| <a id="cirunneredgenode"></a>`node` | [`CiRunner`](#cirunner) | エッジの終端にあるアイテム。 |
| <a id="cirunneredgeweburl"></a>`webUrl` | [`String`](#string) | RunnerのWeb URL。値は、クエリ内でのフィールドの配置場所によって異なります。プロジェクトまたはグループで使用できます。 |

#### `CiRunnerManagerConnection` {#cirunnermanagerconnection}

[`CiRunnerManager`](#cirunnermanager)の接続タイプ。

##### フィールド {#fields-665}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cirunnermanagerconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="cirunnermanagerconnectionedges"></a>`edges` | [`[CiRunnerManagerEdge]`](#cirunnermanageredge) | エッジのリスト。 |
| <a id="cirunnermanagerconnectionnodes"></a>`nodes` | [`[CiRunnerManager]`](#cirunnermanager) | ノードのリスト。 |
| <a id="cirunnermanagerconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiRunnerManagerEdge` {#cirunnermanageredge}

[`CiRunnerManager`](#cirunnermanager)のエッジ型。

##### フィールド {#fields-666}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cirunnermanageredgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="cirunnermanageredgenode"></a>`node` | [`CiRunnerManager`](#cirunnermanager) | エッジの終端にあるアイテム。 |

#### `CiSecureFileRegistryConnection` {#cisecurefileregistryconnection}

[`CiSecureFileRegistry`](#cisecurefileregistry)の接続タイプ。

##### フィールド {#fields-667}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cisecurefileregistryconnectionedges"></a>`edges` | [`[CiSecureFileRegistryEdge]`](#cisecurefileregistryedge) | エッジのリスト。 |
| <a id="cisecurefileregistryconnectionnodes"></a>`nodes` | [`[CiSecureFileRegistry]`](#cisecurefileregistry) | ノードのリスト。 |
| <a id="cisecurefileregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

##### 引数のあるフィールド {#fields-with-arguments-2}

###### `CiSecureFileRegistryConnection.count` {#cisecurefileregistryconnectioncount}

コレクションの制限カウント。制限を超えるカウントの場合、制限+1を返します。

[`Int!`](#int)を返します。

\#######引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cisecurefileregistryconnectioncountlimit"></a>`limit` | [`Int`](#int) | カウントクエリに適用される制限値。デフォルトは1000です。 |

#### `CiSecureFileRegistryEdge` {#cisecurefileregistryedge}

[`CiSecureFileRegistry`](#cisecurefileregistry)のエッジ型。

##### フィールド {#fields-668}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cisecurefileregistryedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="cisecurefileregistryedgenode"></a>`node` | [`CiSecureFileRegistry`](#cisecurefileregistry) | エッジの終端にあるアイテム。 |

#### `CiStageConnection` {#cistageconnection}

[`CiStage`](#cistage)の接続タイプ。

##### フィールド {#fields-669}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cistageconnectionedges"></a>`edges` | [`[CiStageEdge]`](#cistageedge) | エッジのリスト。 |
| <a id="cistageconnectionnodes"></a>`nodes` | [`[CiStage]`](#cistage) | ノードのリスト。 |
| <a id="cistageconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiStageEdge` {#cistageedge}

[`CiStage`](#cistage)のエッジ型。

##### フィールド {#fields-670}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cistageedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="cistageedgenode"></a>`node` | [`CiStage`](#cistage) | エッジの終端にあるアイテム。 |

#### `CiSubscriptionsProjectConnection` {#cisubscriptionsprojectconnection}

[`CiSubscriptionsProject`](#cisubscriptionsproject)の接続タイプ。

##### フィールド {#fields-671}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cisubscriptionsprojectconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="cisubscriptionsprojectconnectionedges"></a>`edges` | [`[CiSubscriptionsProjectEdge]`](#cisubscriptionsprojectedge) | エッジのリスト。 |
| <a id="cisubscriptionsprojectconnectionnodes"></a>`nodes` | [`[CiSubscriptionsProject]`](#cisubscriptionsproject) | ノードのリスト。 |
| <a id="cisubscriptionsprojectconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CiSubscriptionsProjectEdge` {#cisubscriptionsprojectedge}

[`CiSubscriptionsProject`](#cisubscriptionsproject)のエッジ型。

##### フィールド {#fields-672}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="cisubscriptionsprojectedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="cisubscriptionsprojectedgenode"></a>`node` | [`CiSubscriptionsProject`](#cisubscriptionsproject) | エッジの終端にあるアイテム。 |

#### `ClusterAgentActivityEventConnection` {#clusteragentactivityeventconnection}

[`ClusterAgentActivityEvent`](#clusteragentactivityevent)の接続タイプ。

##### フィールド {#fields-673}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="clusteragentactivityeventconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="clusteragentactivityeventconnectionedges"></a>`edges` | [`[ClusterAgentActivityEventEdge]`](#clusteragentactivityeventedge) | エッジのリスト。 |
| <a id="clusteragentactivityeventconnectionnodes"></a>`nodes` | [`[ClusterAgentActivityEvent]`](#clusteragentactivityevent) | ノードのリスト。 |
| <a id="clusteragentactivityeventconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ClusterAgentActivityEventEdge` {#clusteragentactivityeventedge}

[`ClusterAgentActivityEvent`](#clusteragentactivityevent)のエッジ型。

##### フィールド {#fields-674}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="clusteragentactivityeventedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="clusteragentactivityeventedgenode"></a>`node` | [`ClusterAgentActivityEvent`](#clusteragentactivityevent) | エッジの終端にあるアイテム。 |

#### `ClusterAgentAuthorizationCiAccessConnection` {#clusteragentauthorizationciaccessconnection}

[`ClusterAgentAuthorizationCiAccess`](#clusteragentauthorizationciaccess)の接続タイプ。

##### フィールド {#fields-675}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="clusteragentauthorizationciaccessconnectionedges"></a>`edges` | [`[ClusterAgentAuthorizationCiAccessEdge]`](#clusteragentauthorizationciaccessedge) | エッジのリスト。 |
| <a id="clusteragentauthorizationciaccessconnectionnodes"></a>`nodes` | [`[ClusterAgentAuthorizationCiAccess]`](#clusteragentauthorizationciaccess) | ノードのリスト。 |
| <a id="clusteragentauthorizationciaccessconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ClusterAgentAuthorizationCiAccessEdge` {#clusteragentauthorizationciaccessedge}

[`ClusterAgentAuthorizationCiAccess`](#clusteragentauthorizationciaccess)のエッジ型。

##### フィールド {#fields-676}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="clusteragentauthorizationciaccessedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="clusteragentauthorizationciaccessedgenode"></a>`node` | [`ClusterAgentAuthorizationCiAccess`](#clusteragentauthorizationciaccess) | エッジの終端にあるアイテム。 |

#### `ClusterAgentAuthorizationUserAccessConnection` {#clusteragentauthorizationuseraccessconnection}

[`ClusterAgentAuthorizationUserAccess`](#clusteragentauthorizationuseraccess)の接続タイプ。

##### フィールド {#fields-677}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="clusteragentauthorizationuseraccessconnectionedges"></a>`edges` | [`[ClusterAgentAuthorizationUserAccessEdge]`](#clusteragentauthorizationuseraccessedge) | エッジのリスト。 |
| <a id="clusteragentauthorizationuseraccessconnectionnodes"></a>`nodes` | [`[ClusterAgentAuthorizationUserAccess]`](#clusteragentauthorizationuseraccess) | ノードのリスト。 |
| <a id="clusteragentauthorizationuseraccessconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ClusterAgentAuthorizationUserAccessEdge` {#clusteragentauthorizationuseraccessedge}

[`ClusterAgentAuthorizationUserAccess`](#clusteragentauthorizationuseraccess)のエッジ型。

##### フィールド {#fields-678}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="clusteragentauthorizationuseraccessedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="clusteragentauthorizationuseraccessedgenode"></a>`node` | [`ClusterAgentAuthorizationUserAccess`](#clusteragentauthorizationuseraccess) | エッジの終端にあるアイテム。 |

#### `ClusterAgentConnection` {#clusteragentconnection}

[`ClusterAgent`](#clusteragent)の接続タイプ。

##### フィールド {#fields-679}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="clusteragentconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="clusteragentconnectionedges"></a>`edges` | [`[ClusterAgentEdge]`](#clusteragentedge) | エッジのリスト。 |
| <a id="clusteragentconnectionnodes"></a>`nodes` | [`[ClusterAgent]`](#clusteragent) | ノードのリスト。 |
| <a id="clusteragentconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ClusterAgentEdge` {#clusteragentedge}

[`ClusterAgent`](#clusteragent)のエッジ型。

##### フィールド {#fields-680}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="clusteragentedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="clusteragentedgenode"></a>`node` | [`ClusterAgent`](#clusteragent) | エッジの終端にあるアイテム。 |

#### `ClusterAgentTokenConnection` {#clusteragenttokenconnection}

[`ClusterAgentToken`](#clusteragenttoken)の接続タイプ。

##### フィールド {#fields-681}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="clusteragenttokenconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="clusteragenttokenconnectionedges"></a>`edges` | [`[ClusterAgentTokenEdge]`](#clusteragenttokenedge) | エッジのリスト。 |
| <a id="clusteragenttokenconnectionnodes"></a>`nodes` | [`[ClusterAgentToken]`](#clusteragenttoken) | ノードのリスト。 |
| <a id="clusteragenttokenconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ClusterAgentTokenEdge` {#clusteragenttokenedge}

[`ClusterAgentToken`](#clusteragenttoken)のエッジ型。

##### フィールド {#fields-682}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="clusteragenttokenedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="clusteragenttokenedgenode"></a>`node` | [`ClusterAgentToken`](#clusteragenttoken) | エッジの終端にあるアイテム。 |

#### `ClusterAgentUrlConfigurationConnection` {#clusteragenturlconfigurationconnection}

[`ClusterAgentUrlConfiguration`](#clusteragenturlconfiguration)の接続タイプ。

##### フィールド {#fields-683}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="clusteragenturlconfigurationconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="clusteragenturlconfigurationconnectionedges"></a>`edges` | [`[ClusterAgentUrlConfigurationEdge]`](#clusteragenturlconfigurationedge) | エッジのリスト。 |
| <a id="clusteragenturlconfigurationconnectionnodes"></a>`nodes` | [`[ClusterAgentUrlConfiguration]`](#clusteragenturlconfiguration) | ノードのリスト。 |
| <a id="clusteragenturlconfigurationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ClusterAgentUrlConfigurationEdge` {#clusteragenturlconfigurationedge}

[`ClusterAgentUrlConfiguration`](#clusteragenturlconfiguration)のエッジ型。

##### フィールド {#fields-684}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="clusteragenturlconfigurationedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="clusteragenturlconfigurationedgenode"></a>`node` | [`ClusterAgentUrlConfiguration`](#clusteragenturlconfiguration) | エッジの終端にあるアイテム。 |

#### `CodeCoverageActivityConnection` {#codecoverageactivityconnection}

[`CodeCoverageActivity`](#codecoverageactivity)の接続タイプ。

##### フィールド {#fields-685}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="codecoverageactivityconnectionedges"></a>`edges` | [`[CodeCoverageActivityEdge]`](#codecoverageactivityedge) | エッジのリスト。 |
| <a id="codecoverageactivityconnectionnodes"></a>`nodes` | [`[CodeCoverageActivity]`](#codecoverageactivity) | ノードのリスト。 |
| <a id="codecoverageactivityconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CodeCoverageActivityEdge` {#codecoverageactivityedge}

[`CodeCoverageActivity`](#codecoverageactivity)のエッジ型。

##### フィールド {#fields-686}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="codecoverageactivityedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="codecoverageactivityedgenode"></a>`node` | [`CodeCoverageActivity`](#codecoverageactivity) | エッジの終端にあるアイテム。 |

#### `CodeQualityDegradationConnection` {#codequalitydegradationconnection}

[`CodeQualityDegradation`](#codequalitydegradation)の接続タイプ。

##### フィールド {#fields-687}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="codequalitydegradationconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="codequalitydegradationconnectionedges"></a>`edges` | [`[CodeQualityDegradationEdge]`](#codequalitydegradationedge) | エッジのリスト。 |
| <a id="codequalitydegradationconnectionnodes"></a>`nodes` | [`[CodeQualityDegradation]`](#codequalitydegradation) | ノードのリスト。 |
| <a id="codequalitydegradationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CodeQualityDegradationEdge` {#codequalitydegradationedge}

[`CodeQualityDegradation`](#codequalitydegradation)のエッジ型。

##### フィールド {#fields-688}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="codequalitydegradationedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="codequalitydegradationedgenode"></a>`node` | [`CodeQualityDegradation`](#codequalitydegradation) | エッジの終端にあるアイテム。 |

#### `CodeSuggestionEventConnection` {#codesuggestioneventconnection}

[`CodeSuggestionEvent`](#codesuggestionevent)の接続タイプ。

##### フィールド {#fields-689}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="codesuggestioneventconnectionedges"></a>`edges` | [`[CodeSuggestionEventEdge]`](#codesuggestioneventedge) | エッジのリスト。 |
| <a id="codesuggestioneventconnectionnodes"></a>`nodes` | [`[CodeSuggestionEvent]`](#codesuggestionevent) | ノードのリスト。 |
| <a id="codesuggestioneventconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CodeSuggestionEventEdge` {#codesuggestioneventedge}

[`CodeSuggestionEvent`](#codesuggestionevent)のエッジ型。

##### フィールド {#fields-690}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="codesuggestioneventedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="codesuggestioneventedgenode"></a>`node` | [`CodeSuggestionEvent`](#codesuggestionevent) | エッジの終端にあるアイテム。 |

#### `CommitConnection` {#commitconnection}

[`Commit`](#commit)の接続タイプ。

##### フィールド {#fields-691}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="commitconnectionedges"></a>`edges` | [`[CommitEdge]`](#commitedge) | エッジのリスト。 |
| <a id="commitconnectionnodes"></a>`nodes` | [`[Commit]`](#commit) | ノードのリスト。 |
| <a id="commitconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CommitEdge` {#commitedge}

[`Commit`](#commit)のエッジ型。

##### フィールド {#fields-692}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="commitedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="commitedgenode"></a>`node` | [`Commit`](#commit) | エッジの終端にあるアイテム。 |

#### `ComplianceFrameworkConnection` {#complianceframeworkconnection}

[`ComplianceFramework`](#complianceframework)の接続タイプ。

##### フィールド {#fields-693}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="complianceframeworkconnectionedges"></a>`edges` | [`[ComplianceFrameworkEdge]`](#complianceframeworkedge) | エッジのリスト。 |
| <a id="complianceframeworkconnectionnodes"></a>`nodes` | [`[ComplianceFramework]`](#complianceframework) | ノードのリスト。 |
| <a id="complianceframeworkconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ComplianceFrameworkCoverageDetailConnection` {#complianceframeworkcoveragedetailconnection}

[`ComplianceFrameworkCoverageDetail`](#complianceframeworkcoveragedetail)の接続タイプ。

##### フィールド {#fields-694}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="complianceframeworkcoveragedetailconnectionedges"></a>`edges` | [`[ComplianceFrameworkCoverageDetailEdge]`](#complianceframeworkcoveragedetailedge) | エッジのリスト。 |
| <a id="complianceframeworkcoveragedetailconnectionnodes"></a>`nodes` | [`[ComplianceFrameworkCoverageDetail]`](#complianceframeworkcoveragedetail) | ノードのリスト。 |
| <a id="complianceframeworkcoveragedetailconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ComplianceFrameworkCoverageDetailEdge` {#complianceframeworkcoveragedetailedge}

[`ComplianceFrameworkCoverageDetail`](#complianceframeworkcoveragedetail)のエッジ型。

##### フィールド {#fields-695}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="complianceframeworkcoveragedetailedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="complianceframeworkcoveragedetailedgenode"></a>`node` | [`ComplianceFrameworkCoverageDetail`](#complianceframeworkcoveragedetail) | エッジの終端にあるアイテム。 |

#### `ComplianceFrameworkEdge` {#complianceframeworkedge}

[`ComplianceFramework`](#complianceframework)のエッジ型。

##### フィールド {#fields-696}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="complianceframeworkedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="complianceframeworkedgenode"></a>`node` | [`ComplianceFramework`](#complianceframework) | エッジの終端にあるアイテム。 |

#### `ComplianceFrameworksNeedingAttentionConnection` {#complianceframeworksneedingattentionconnection}

[`ComplianceFrameworksNeedingAttention`](#complianceframeworksneedingattention)の接続タイプ。

##### フィールド {#fields-697}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="complianceframeworksneedingattentionconnectionedges"></a>`edges` | [`[ComplianceFrameworksNeedingAttentionEdge]`](#complianceframeworksneedingattentionedge) | エッジのリスト。 |
| <a id="complianceframeworksneedingattentionconnectionnodes"></a>`nodes` | [`[ComplianceFrameworksNeedingAttention]`](#complianceframeworksneedingattention) | ノードのリスト。 |
| <a id="complianceframeworksneedingattentionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ComplianceFrameworksNeedingAttentionEdge` {#complianceframeworksneedingattentionedge}

[`ComplianceFrameworksNeedingAttention`](#complianceframeworksneedingattention)のエッジ型。

##### フィールド {#fields-698}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="complianceframeworksneedingattentionedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="complianceframeworksneedingattentionedgenode"></a>`node` | [`ComplianceFrameworksNeedingAttention`](#complianceframeworksneedingattention) | エッジの終端にあるアイテム。 |

#### `ComplianceRequirementConnection` {#compliancerequirementconnection}

[`ComplianceRequirement`](#compliancerequirement)の接続タイプ。

##### フィールド {#fields-699}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="compliancerequirementconnectionedges"></a>`edges` | [`[ComplianceRequirementEdge]`](#compliancerequirementedge) | エッジのリスト。 |
| <a id="compliancerequirementconnectionnodes"></a>`nodes` | [`[ComplianceRequirement]`](#compliancerequirement) | ノードのリスト。 |
| <a id="compliancerequirementconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ComplianceRequirementEdge` {#compliancerequirementedge}

[`ComplianceRequirement`](#compliancerequirement)のエッジ型。

##### フィールド {#fields-700}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="compliancerequirementedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="compliancerequirementedgenode"></a>`node` | [`ComplianceRequirement`](#compliancerequirement) | エッジの終端にあるアイテム。 |

#### `ComplianceRequirementsControlConnection` {#compliancerequirementscontrolconnection}

[`ComplianceRequirementsControl`](#compliancerequirementscontrol)の接続タイプ。

##### フィールド {#fields-701}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="compliancerequirementscontrolconnectionedges"></a>`edges` | [`[ComplianceRequirementsControlEdge]`](#compliancerequirementscontroledge) | エッジのリスト。 |
| <a id="compliancerequirementscontrolconnectionnodes"></a>`nodes` | [`[ComplianceRequirementsControl]`](#compliancerequirementscontrol) | ノードのリスト。 |
| <a id="compliancerequirementscontrolconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ComplianceRequirementsControlEdge` {#compliancerequirementscontroledge}

[`ComplianceRequirementsControl`](#compliancerequirementscontrol)のエッジ型。

##### フィールド {#fields-702}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="compliancerequirementscontroledgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="compliancerequirementscontroledgenode"></a>`node` | [`ComplianceRequirementsControl`](#compliancerequirementscontrol) | エッジの終端にあるアイテム。 |

#### `ComplianceStandardsAdherenceConnection` {#compliancestandardsadherenceconnection}

[`ComplianceStandardsAdherence`](#compliancestandardsadherence)の接続タイプ。

##### フィールド {#fields-703}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="compliancestandardsadherenceconnectionedges"></a>`edges` | [`[ComplianceStandardsAdherenceEdge]`](#compliancestandardsadherenceedge) | エッジのリスト。 |
| <a id="compliancestandardsadherenceconnectionnodes"></a>`nodes` | [`[ComplianceStandardsAdherence]`](#compliancestandardsadherence) | ノードのリスト。 |
| <a id="compliancestandardsadherenceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ComplianceStandardsAdherenceEdge` {#compliancestandardsadherenceedge}

[`ComplianceStandardsAdherence`](#compliancestandardsadherence)のエッジ型。

##### フィールド {#fields-704}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="compliancestandardsadherenceedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="compliancestandardsadherenceedgenode"></a>`node` | [`ComplianceStandardsAdherence`](#compliancestandardsadherence) | エッジの終端にあるアイテム。 |

#### `ComplianceViolationConnection` {#complianceviolationconnection}

[`ComplianceViolation`](#complianceviolation)の接続タイプ。

##### フィールド {#fields-705}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="complianceviolationconnectionedges"></a>`edges` | [`[ComplianceViolationEdge]`](#complianceviolationedge) | エッジのリスト。 |
| <a id="complianceviolationconnectionnodes"></a>`nodes` | [`[ComplianceViolation]`](#complianceviolation) | ノードのリスト。 |
| <a id="complianceviolationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ComplianceViolationEdge` {#complianceviolationedge}

[`ComplianceViolation`](#complianceviolation)のエッジ型。

##### フィールド {#fields-706}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="complianceviolationedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="complianceviolationedgenode"></a>`node` | [`ComplianceViolation`](#complianceviolation) | エッジの終端にあるアイテム。 |

#### `ComponentVersionConnection` {#componentversionconnection}

[`ComponentVersion`](#componentversion)の接続タイプ。

##### フィールド {#fields-707}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="componentversionconnectionedges"></a>`edges` | [`[ComponentVersionEdge]`](#componentversionedge) | エッジのリスト。 |
| <a id="componentversionconnectionnodes"></a>`nodes` | [`[ComponentVersion]`](#componentversion) | ノードのリスト。 |
| <a id="componentversionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ComponentVersionEdge` {#componentversionedge}

[`ComponentVersion`](#componentversion)のエッジ型。

##### フィールド {#fields-708}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="componentversionedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="componentversionedgenode"></a>`node` | [`ComponentVersion`](#componentversion) | エッジの終端にあるアイテム。 |

#### `ConnectedAgentConnection` {#connectedagentconnection}

[`ConnectedAgent`](#connectedagent)の接続タイプ。

##### フィールド {#fields-709}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="connectedagentconnectionedges"></a>`edges` | [`[ConnectedAgentEdge]`](#connectedagentedge) | エッジのリスト。 |
| <a id="connectedagentconnectionnodes"></a>`nodes` | [`[ConnectedAgent]`](#connectedagent) | ノードのリスト。 |
| <a id="connectedagentconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ConnectedAgentEdge` {#connectedagentedge}

[`ConnectedAgent`](#connectedagent)のエッジ型。

##### フィールド {#fields-710}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="connectedagentedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="connectedagentedgenode"></a>`node` | [`ConnectedAgent`](#connectedagent) | エッジの終端にあるアイテム。 |

#### `ContainerProtectionRepositoryRuleConnection` {#containerprotectionrepositoryruleconnection}

[`ContainerProtectionRepositoryRule`](#containerprotectionrepositoryrule)の接続タイプ。

##### フィールド {#fields-711}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="containerprotectionrepositoryruleconnectionedges"></a>`edges` | [`[ContainerProtectionRepositoryRuleEdge]`](#containerprotectionrepositoryruleedge) | エッジのリスト。 |
| <a id="containerprotectionrepositoryruleconnectionnodes"></a>`nodes` | [`[ContainerProtectionRepositoryRule]`](#containerprotectionrepositoryrule) | ノードのリスト。 |
| <a id="containerprotectionrepositoryruleconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ContainerProtectionRepositoryRuleEdge` {#containerprotectionrepositoryruleedge}

[`ContainerProtectionRepositoryRule`](#containerprotectionrepositoryrule)のエッジ型。

##### フィールド {#fields-712}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="containerprotectionrepositoryruleedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="containerprotectionrepositoryruleedgenode"></a>`node` | [`ContainerProtectionRepositoryRule`](#containerprotectionrepositoryrule) | エッジの終端にあるアイテム。 |

#### `ContainerProtectionTagRuleConnection` {#containerprotectiontagruleconnection}

[`ContainerProtectionTagRule`](#containerprotectiontagrule)の接続タイプ。

##### フィールド {#fields-713}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="containerprotectiontagruleconnectionedges"></a>`edges` | [`[ContainerProtectionTagRuleEdge]`](#containerprotectiontagruleedge) | エッジのリスト。 |
| <a id="containerprotectiontagruleconnectionnodes"></a>`nodes` | [`[ContainerProtectionTagRule]`](#containerprotectiontagrule) | ノードのリスト。 |
| <a id="containerprotectiontagruleconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ContainerProtectionTagRuleEdge` {#containerprotectiontagruleedge}

[`ContainerProtectionTagRule`](#containerprotectiontagrule)のエッジ型。

##### フィールド {#fields-714}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="containerprotectiontagruleedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="containerprotectiontagruleedgenode"></a>`node` | [`ContainerProtectionTagRule`](#containerprotectiontagrule) | エッジの終端にあるアイテム。 |

#### `ContainerRepositoryConnection` {#containerrepositoryconnection}

[`ContainerRepository`](#containerrepository)の接続タイプ。

##### フィールド {#fields-715}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="containerrepositoryconnectionedges"></a>`edges` | [`[ContainerRepositoryEdge]`](#containerrepositoryedge) | エッジのリスト。 |
| <a id="containerrepositoryconnectionnodes"></a>`nodes` | [`[ContainerRepository]`](#containerrepository) | ノードのリスト。 |
| <a id="containerrepositoryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ContainerRepositoryEdge` {#containerrepositoryedge}

[`ContainerRepository`](#containerrepository)のエッジ型。

##### フィールド {#fields-716}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="containerrepositoryedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="containerrepositoryedgenode"></a>`node` | [`ContainerRepository`](#containerrepository) | エッジの終端にあるアイテム。 |

#### `ContainerRepositoryRegistryConnection` {#containerrepositoryregistryconnection}

[`ContainerRepositoryRegistry`](#containerrepositoryregistry)の接続タイプ。

##### フィールド {#fields-717}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="containerrepositoryregistryconnectionedges"></a>`edges` | [`[ContainerRepositoryRegistryEdge]`](#containerrepositoryregistryedge) | エッジのリスト。 |
| <a id="containerrepositoryregistryconnectionnodes"></a>`nodes` | [`[ContainerRepositoryRegistry]`](#containerrepositoryregistry) | ノードのリスト。 |
| <a id="containerrepositoryregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

##### 引数のあるフィールド {#fields-with-arguments-3}

###### `ContainerRepositoryRegistryConnection.count` {#containerrepositoryregistryconnectioncount}

コレクションの制限カウント。制限を超えるカウントの場合、制限+1を返します。

[`Int!`](#int)を返します。

\#######引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="containerrepositoryregistryconnectioncountlimit"></a>`limit` | [`Int`](#int) | カウントクエリに適用される制限値。デフォルトは1000です。 |

#### `ContainerRepositoryRegistryEdge` {#containerrepositoryregistryedge}

[`ContainerRepositoryRegistry`](#containerrepositoryregistry)のエッジ型。

##### フィールド {#fields-718}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="containerrepositoryregistryedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="containerrepositoryregistryedgenode"></a>`node` | [`ContainerRepositoryRegistry`](#containerrepositoryregistry) | エッジの終端にあるアイテム。 |

#### `ContainerRepositoryTagConnection` {#containerrepositorytagconnection}

[`ContainerRepositoryTag`](#containerrepositorytag)の接続タイプ。

##### フィールド {#fields-719}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="containerrepositorytagconnectionedges"></a>`edges` | [`[ContainerRepositoryTagEdge]`](#containerrepositorytagedge) | エッジのリスト。 |
| <a id="containerrepositorytagconnectionnodes"></a>`nodes` | [`[ContainerRepositoryTag]`](#containerrepositorytag) | ノードのリスト。 |
| <a id="containerrepositorytagconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ContainerRepositoryTagEdge` {#containerrepositorytagedge}

[`ContainerRepositoryTag`](#containerrepositorytag)のエッジ型。

##### フィールド {#fields-720}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="containerrepositorytagedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="containerrepositorytagedgenode"></a>`node` | [`ContainerRepositoryTag`](#containerrepositorytag) | エッジの終端にあるアイテム。 |

#### `ContributionAnalyticsContributionConnection` {#contributionanalyticscontributionconnection}

[`ContributionAnalyticsContribution`](#contributionanalyticscontribution)の接続タイプ。

##### フィールド {#fields-721}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="contributionanalyticscontributionconnectionedges"></a>`edges` | [`[ContributionAnalyticsContributionEdge]`](#contributionanalyticscontributionedge) | エッジのリスト。 |
| <a id="contributionanalyticscontributionconnectionnodes"></a>`nodes` | [`[ContributionAnalyticsContribution]`](#contributionanalyticscontribution) | ノードのリスト。 |
| <a id="contributionanalyticscontributionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ContributionAnalyticsContributionEdge` {#contributionanalyticscontributionedge}

[`ContributionAnalyticsContribution`](#contributionanalyticscontribution)のエッジ型。

##### フィールド {#fields-722}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="contributionanalyticscontributionedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="contributionanalyticscontributionedgenode"></a>`node` | [`ContributionAnalyticsContribution`](#contributionanalyticscontribution) | エッジの終端にあるアイテム。 |

#### `CountableVulnerabilityConnection` {#countablevulnerabilityconnection}

[`CountableVulnerability`](#countablevulnerability)の接続タイプ。

##### フィールド {#fields-723}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="countablevulnerabilityconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="countablevulnerabilityconnectionedges"></a>`edges` | [`[CountableVulnerabilityEdge]`](#countablevulnerabilityedge) | エッジのリスト。 |
| <a id="countablevulnerabilityconnectionnodes"></a>`nodes` | [`[CountableVulnerability]`](#countablevulnerability) | ノードのリスト。 |
| <a id="countablevulnerabilityconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CountableVulnerabilityEdge` {#countablevulnerabilityedge}

[`CountableVulnerability`](#countablevulnerability)のエッジ型。

##### フィールド {#fields-724}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="countablevulnerabilityedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="countablevulnerabilityedgenode"></a>`node` | [`CountableVulnerability`](#countablevulnerability) | エッジの終端にあるアイテム。 |

#### `CoverageFuzzingCorpusConnection` {#coveragefuzzingcorpusconnection}

[`CoverageFuzzingCorpus`](#coveragefuzzingcorpus)の接続タイプ。

##### フィールド {#fields-725}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="coveragefuzzingcorpusconnectionedges"></a>`edges` | [`[CoverageFuzzingCorpusEdge]`](#coveragefuzzingcorpusedge) | エッジのリスト。 |
| <a id="coveragefuzzingcorpusconnectionnodes"></a>`nodes` | [`[CoverageFuzzingCorpus]`](#coveragefuzzingcorpus) | ノードのリスト。 |
| <a id="coveragefuzzingcorpusconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CoverageFuzzingCorpusEdge` {#coveragefuzzingcorpusedge}

[`CoverageFuzzingCorpus`](#coveragefuzzingcorpus)のエッジ型。

##### フィールド {#fields-726}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="coveragefuzzingcorpusedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="coveragefuzzingcorpusedgenode"></a>`node` | [`CoverageFuzzingCorpus`](#coveragefuzzingcorpus) | エッジの終端にあるアイテム。 |

#### `CustomEmojiConnection` {#customemojiconnection}

[`CustomEmoji`](#customemoji)の接続タイプ。

##### フィールド {#fields-727}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="customemojiconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="customemojiconnectionedges"></a>`edges` | [`[CustomEmojiEdge]`](#customemojiedge) | エッジのリスト。 |
| <a id="customemojiconnectionnodes"></a>`nodes` | [`[CustomEmoji]`](#customemoji) | ノードのリスト。 |
| <a id="customemojiconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CustomEmojiEdge` {#customemojiedge}

[`CustomEmoji`](#customemoji)のエッジ型。

##### フィールド {#fields-728}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="customemojiedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="customemojiedgenode"></a>`node` | [`CustomEmoji`](#customemoji) | エッジの終端にあるアイテム。 |

#### `CustomFieldConnection` {#customfieldconnection}

[`CustomField`](#customfield)の接続タイプ。

##### フィールド {#fields-729}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="customfieldconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="customfieldconnectionedges"></a>`edges` | [`[CustomFieldEdge]`](#customfieldedge) | エッジのリスト。 |
| <a id="customfieldconnectionnodes"></a>`nodes` | [`[CustomField]`](#customfield) | ノードのリスト。 |
| <a id="customfieldconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CustomFieldEdge` {#customfieldedge}

[`CustomField`](#customfield)のエッジ型。

##### フィールド {#fields-730}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="customfieldedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="customfieldedgenode"></a>`node` | [`CustomField`](#customfield) | エッジの終端にあるアイテム。 |

#### `CustomerRelationsContactConnection` {#customerrelationscontactconnection}

[`CustomerRelationsContact`](#customerrelationscontact)の接続タイプ。

##### フィールド {#fields-731}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="customerrelationscontactconnectionedges"></a>`edges` | [`[CustomerRelationsContactEdge]`](#customerrelationscontactedge) | エッジのリスト。 |
| <a id="customerrelationscontactconnectionnodes"></a>`nodes` | [`[CustomerRelationsContact]`](#customerrelationscontact) | ノードのリスト。 |
| <a id="customerrelationscontactconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CustomerRelationsContactEdge` {#customerrelationscontactedge}

[`CustomerRelationsContact`](#customerrelationscontact)のエッジ型。

##### フィールド {#fields-732}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="customerrelationscontactedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="customerrelationscontactedgenode"></a>`node` | [`CustomerRelationsContact`](#customerrelationscontact) | エッジの終端にあるアイテム。 |

#### `CustomerRelationsOrganizationConnection` {#customerrelationsorganizationconnection}

[`CustomerRelationsOrganization`](#customerrelationsorganization)の接続タイプ。

##### フィールド {#fields-733}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="customerrelationsorganizationconnectionedges"></a>`edges` | [`[CustomerRelationsOrganizationEdge]`](#customerrelationsorganizationedge) | エッジのリスト。 |
| <a id="customerrelationsorganizationconnectionnodes"></a>`nodes` | [`[CustomerRelationsOrganization]`](#customerrelationsorganization) | ノードのリスト。 |
| <a id="customerrelationsorganizationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CustomerRelationsOrganizationEdge` {#customerrelationsorganizationedge}

[`CustomerRelationsOrganization`](#customerrelationsorganization)のエッジ型。

##### フィールド {#fields-734}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="customerrelationsorganizationedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="customerrelationsorganizationedgenode"></a>`node` | [`CustomerRelationsOrganization`](#customerrelationsorganization) | エッジの終端にあるアイテム。 |

#### `CustomizableAdminPermissionConnection` {#customizableadminpermissionconnection}

[`CustomizableAdminPermission`](#customizableadminpermission)の接続タイプ。

##### フィールド {#fields-735}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="customizableadminpermissionconnectionedges"></a>`edges` | [`[CustomizableAdminPermissionEdge]`](#customizableadminpermissionedge) | エッジのリスト。 |
| <a id="customizableadminpermissionconnectionnodes"></a>`nodes` | [`[CustomizableAdminPermission]`](#customizableadminpermission) | ノードのリスト。 |
| <a id="customizableadminpermissionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CustomizableAdminPermissionEdge` {#customizableadminpermissionedge}

[`CustomizableAdminPermission`](#customizableadminpermission)のエッジ型。

##### フィールド {#fields-736}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="customizableadminpermissionedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="customizableadminpermissionedgenode"></a>`node` | [`CustomizableAdminPermission`](#customizableadminpermission) | エッジの終端にあるアイテム。 |

#### `CustomizableDashboardConnection` {#customizabledashboardconnection}

[`CustomizableDashboard`](#customizabledashboard)の接続タイプ。

##### フィールド {#fields-737}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="customizabledashboardconnectionedges"></a>`edges` | [`[CustomizableDashboardEdge]`](#customizabledashboardedge) | エッジのリスト。 |
| <a id="customizabledashboardconnectionnodes"></a>`nodes` | [`[CustomizableDashboard]`](#customizabledashboard) | ノードのリスト。 |
| <a id="customizabledashboardconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CustomizableDashboardEdge` {#customizabledashboardedge}

[`CustomizableDashboard`](#customizabledashboard)のエッジ型。

##### フィールド {#fields-738}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="customizabledashboardedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="customizabledashboardedgenode"></a>`node` | [`CustomizableDashboard`](#customizabledashboard) | エッジの終端にあるアイテム。 |

#### `CustomizableDashboardPanelConnection` {#customizabledashboardpanelconnection}

[`CustomizableDashboardPanel`](#customizabledashboardpanel)の接続タイプ。

##### フィールド {#fields-739}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="customizabledashboardpanelconnectionedges"></a>`edges` | [`[CustomizableDashboardPanelEdge]`](#customizabledashboardpaneledge) | エッジのリスト。 |
| <a id="customizabledashboardpanelconnectionnodes"></a>`nodes` | [`[CustomizableDashboardPanel]`](#customizabledashboardpanel) | ノードのリスト。 |
| <a id="customizabledashboardpanelconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CustomizableDashboardPanelEdge` {#customizabledashboardpaneledge}

[`CustomizableDashboardPanel`](#customizabledashboardpanel)のエッジ型。

##### フィールド {#fields-740}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="customizabledashboardpaneledgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="customizabledashboardpaneledgenode"></a>`node` | [`CustomizableDashboardPanel`](#customizabledashboardpanel) | エッジの終端にあるアイテム。 |

#### `CustomizableDashboardVisualizationConnection` {#customizabledashboardvisualizationconnection}

[`CustomizableDashboardVisualization`](#customizabledashboardvisualization)の接続タイプ。

##### フィールド {#fields-741}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="customizabledashboardvisualizationconnectionedges"></a>`edges` | [`[CustomizableDashboardVisualizationEdge]`](#customizabledashboardvisualizationedge) | エッジのリスト。 |
| <a id="customizabledashboardvisualizationconnectionnodes"></a>`nodes` | [`[CustomizableDashboardVisualization]`](#customizabledashboardvisualization) | ノードのリスト。 |
| <a id="customizabledashboardvisualizationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CustomizableDashboardVisualizationEdge` {#customizabledashboardvisualizationedge}

[`CustomizableDashboardVisualization`](#customizabledashboardvisualization)のエッジ型。

##### フィールド {#fields-742}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="customizabledashboardvisualizationedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="customizabledashboardvisualizationedgenode"></a>`node` | [`CustomizableDashboardVisualization`](#customizabledashboardvisualization) | エッジの終端にあるアイテム。 |

#### `CustomizableStandardPermissionConnection` {#customizablestandardpermissionconnection}

[`CustomizableStandardPermission`](#customizablestandardpermission)の接続タイプ。

##### フィールド {#fields-743}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="customizablestandardpermissionconnectionedges"></a>`edges` | [`[CustomizableStandardPermissionEdge]`](#customizablestandardpermissionedge) | エッジのリスト。 |
| <a id="customizablestandardpermissionconnectionnodes"></a>`nodes` | [`[CustomizableStandardPermission]`](#customizablestandardpermission) | ノードのリスト。 |
| <a id="customizablestandardpermissionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `CustomizableStandardPermissionEdge` {#customizablestandardpermissionedge}

[`CustomizableStandardPermission`](#customizablestandardpermission)のエッジ型。

##### フィールド {#fields-744}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="customizablestandardpermissionedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="customizablestandardpermissionedgenode"></a>`node` | [`CustomizableStandardPermission`](#customizablestandardpermission) | エッジの終端にあるアイテム。 |

#### `DastProfileConnection` {#dastprofileconnection}

[`DastProfile`](#dastprofile)の接続タイプ。

##### フィールド {#fields-745}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="dastprofileconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="dastprofileconnectionedges"></a>`edges` | [`[DastProfileEdge]`](#dastprofileedge) | エッジのリスト。 |
| <a id="dastprofileconnectionnodes"></a>`nodes` | [`[DastProfile]`](#dastprofile) | ノードのリスト。 |
| <a id="dastprofileconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `DastProfileEdge` {#dastprofileedge}

[`DastProfile`](#dastprofile)のエッジ型。

##### フィールド {#fields-746}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="dastprofileedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="dastprofileedgenode"></a>`node` | [`DastProfile`](#dastprofile) | エッジの終端にあるアイテム。 |

#### `DastScannerProfileConnection` {#dastscannerprofileconnection}

[`DastScannerProfile`](#dastscannerprofile)の接続タイプ。

##### フィールド {#fields-747}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="dastscannerprofileconnectionedges"></a>`edges` | [`[DastScannerProfileEdge]`](#dastscannerprofileedge) | エッジのリスト。 |
| <a id="dastscannerprofileconnectionnodes"></a>`nodes` | [`[DastScannerProfile]`](#dastscannerprofile) | ノードのリスト。 |
| <a id="dastscannerprofileconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `DastScannerProfileEdge` {#dastscannerprofileedge}

[`DastScannerProfile`](#dastscannerprofile)のエッジ型。

##### フィールド {#fields-748}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="dastscannerprofileedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="dastscannerprofileedgenode"></a>`node` | [`DastScannerProfile`](#dastscannerprofile) | エッジの終端にあるアイテム。 |

#### `DastSiteProfileConnection` {#dastsiteprofileconnection}

[`DastSiteProfile`](#dastsiteprofile)の接続タイプ。

##### フィールド {#fields-749}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="dastsiteprofileconnectionedges"></a>`edges` | [`[DastSiteProfileEdge]`](#dastsiteprofileedge) | エッジのリスト。 |
| <a id="dastsiteprofileconnectionnodes"></a>`nodes` | [`[DastSiteProfile]`](#dastsiteprofile) | ノードのリスト。 |
| <a id="dastsiteprofileconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `DastSiteProfileEdge` {#dastsiteprofileedge}

[`DastSiteProfile`](#dastsiteprofile)のエッジ型。

##### フィールド {#fields-750}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="dastsiteprofileedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="dastsiteprofileedgenode"></a>`node` | [`DastSiteProfile`](#dastsiteprofile) | エッジの終端にあるアイテム。 |

#### `DastSiteValidationConnection` {#dastsitevalidationconnection}

[`DastSiteValidation`](#dastsitevalidation)の接続タイプ。

##### フィールド {#fields-751}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="dastsitevalidationconnectionedges"></a>`edges` | [`[DastSiteValidationEdge]`](#dastsitevalidationedge) | エッジのリスト。 |
| <a id="dastsitevalidationconnectionnodes"></a>`nodes` | [`[DastSiteValidation]`](#dastsitevalidation) | ノードのリスト。 |
| <a id="dastsitevalidationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `DastSiteValidationEdge` {#dastsitevalidationedge}

[`DastSiteValidation`](#dastsitevalidation)のエッジ型。

##### フィールド {#fields-752}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="dastsitevalidationedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="dastsitevalidationedgenode"></a>`node` | [`DastSiteValidation`](#dastsitevalidation) | エッジの終端にあるアイテム。 |

#### `DependencyAggregationConnection` {#dependencyaggregationconnection}

[`DependencyAggregation`](#dependencyaggregation)の接続タイプ。

##### フィールド {#fields-753}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="dependencyaggregationconnectionedges"></a>`edges` | [`[DependencyAggregationEdge]`](#dependencyaggregationedge) | エッジのリスト。 |
| <a id="dependencyaggregationconnectionnodes"></a>`nodes` | [`[DependencyAggregation]`](#dependencyaggregation) | ノードのリスト。 |
| <a id="dependencyaggregationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `DependencyAggregationEdge` {#dependencyaggregationedge}

[`DependencyAggregation`](#dependencyaggregation)のエッジ型。

##### フィールド {#fields-754}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="dependencyaggregationedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="dependencyaggregationedgenode"></a>`node` | [`DependencyAggregation`](#dependencyaggregation) | エッジの終端にあるアイテム。 |

#### `DependencyConnection` {#dependencyconnection}

[`Dependency`](#dependency)の接続タイプ。

##### フィールド {#fields-755}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="dependencyconnectionedges"></a>`edges` | [`[DependencyEdge]`](#dependencyedge) | エッジのリスト。 |
| <a id="dependencyconnectionnodes"></a>`nodes` | [`[Dependency]`](#dependency) | ノードのリスト。 |
| <a id="dependencyconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `DependencyEdge` {#dependencyedge}

[`Dependency`](#dependency)のエッジ型。

##### フィールド {#fields-756}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="dependencyedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="dependencyedgenode"></a>`node` | [`Dependency`](#dependency) | エッジの終端にあるアイテム。 |

#### `DependencyPathEdge` {#dependencypathedge}

[`DependencyPath`](#dependencypath)のエッジ型。

##### フィールド {#fields-757}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="dependencypathedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="dependencypathedgenode"></a>`node` | [`DependencyPath`](#dependencypath) | 依存パスノード。 |

#### `DependencyProxyBlobConnection` {#dependencyproxyblobconnection}

[`DependencyProxyBlob`](#dependencyproxyblob)の接続タイプ。

##### フィールド {#fields-758}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="dependencyproxyblobconnectionedges"></a>`edges` | [`[DependencyProxyBlobEdge]`](#dependencyproxyblobedge) | エッジのリスト。 |
| <a id="dependencyproxyblobconnectionnodes"></a>`nodes` | [`[DependencyProxyBlob]`](#dependencyproxyblob) | ノードのリスト。 |
| <a id="dependencyproxyblobconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `DependencyProxyBlobEdge` {#dependencyproxyblobedge}

[`DependencyProxyBlob`](#dependencyproxyblob)のエッジ型。

##### フィールド {#fields-759}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="dependencyproxyblobedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="dependencyproxyblobedgenode"></a>`node` | [`DependencyProxyBlob`](#dependencyproxyblob) | エッジの終端にあるアイテム。 |

#### `DependencyProxyBlobRegistryConnection` {#dependencyproxyblobregistryconnection}

[`DependencyProxyBlobRegistry`](#dependencyproxyblobregistry)の接続タイプ。

##### フィールド {#fields-760}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="dependencyproxyblobregistryconnectionedges"></a>`edges` | [`[DependencyProxyBlobRegistryEdge]`](#dependencyproxyblobregistryedge) | エッジのリスト。 |
| <a id="dependencyproxyblobregistryconnectionnodes"></a>`nodes` | [`[DependencyProxyBlobRegistry]`](#dependencyproxyblobregistry) | ノードのリスト。 |
| <a id="dependencyproxyblobregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

##### 引数のあるフィールド {#fields-with-arguments-4}

###### `DependencyProxyBlobRegistryConnection.count` {#dependencyproxyblobregistryconnectioncount}

コレクションの制限カウント。制限を超えるカウントの場合、制限+1を返します。

[`Int!`](#int)を返します。

\#######引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="dependencyproxyblobregistryconnectioncountlimit"></a>`limit` | [`Int`](#int) | カウントクエリに適用される制限値。デフォルトは1000です。 |

#### `DependencyProxyBlobRegistryEdge` {#dependencyproxyblobregistryedge}

[`DependencyProxyBlobRegistry`](#dependencyproxyblobregistry)のエッジ型。

##### フィールド {#fields-761}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="dependencyproxyblobregistryedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="dependencyproxyblobregistryedgenode"></a>`node` | [`DependencyProxyBlobRegistry`](#dependencyproxyblobregistry) | エッジの終端にあるアイテム。 |

#### `DependencyProxyManifestConnection` {#dependencyproxymanifestconnection}

[`DependencyProxyManifest`](#dependencyproxymanifest)の接続タイプ。

##### フィールド {#fields-762}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="dependencyproxymanifestconnectionedges"></a>`edges` | [`[DependencyProxyManifestEdge]`](#dependencyproxymanifestedge) | エッジのリスト。 |
| <a id="dependencyproxymanifestconnectionnodes"></a>`nodes` | [`[DependencyProxyManifest]`](#dependencyproxymanifest) | ノードのリスト。 |
| <a id="dependencyproxymanifestconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `DependencyProxyManifestEdge` {#dependencyproxymanifestedge}

[`DependencyProxyManifest`](#dependencyproxymanifest)のエッジ型。

##### フィールド {#fields-763}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="dependencyproxymanifestedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="dependencyproxymanifestedgenode"></a>`node` | [`DependencyProxyManifest`](#dependencyproxymanifest) | エッジの終端にあるアイテム。 |

#### `DependencyProxyManifestRegistryConnection` {#dependencyproxymanifestregistryconnection}

[`DependencyProxyManifestRegistry`](#dependencyproxymanifestregistry)の接続タイプ。

##### フィールド {#fields-764}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="dependencyproxymanifestregistryconnectionedges"></a>`edges` | [`[DependencyProxyManifestRegistryEdge]`](#dependencyproxymanifestregistryedge) | エッジのリスト。 |
| <a id="dependencyproxymanifestregistryconnectionnodes"></a>`nodes` | [`[DependencyProxyManifestRegistry]`](#dependencyproxymanifestregistry) | ノードのリスト。 |
| <a id="dependencyproxymanifestregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

##### 引数のあるフィールド {#fields-with-arguments-5}

###### `DependencyProxyManifestRegistryConnection.count` {#dependencyproxymanifestregistryconnectioncount}

コレクションの制限カウント。制限を超えるカウントの場合、制限+1を返します。

[`Int!`](#int)を返します。

\#######引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="dependencyproxymanifestregistryconnectioncountlimit"></a>`limit` | [`Int`](#int) | カウントクエリに適用される制限値。デフォルトは1000です。 |

#### `DependencyProxyManifestRegistryEdge` {#dependencyproxymanifestregistryedge}

[`DependencyProxyManifestRegistry`](#dependencyproxymanifestregistry)のエッジ型。

##### フィールド {#fields-765}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="dependencyproxymanifestregistryedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="dependencyproxymanifestregistryedgenode"></a>`node` | [`DependencyProxyManifestRegistry`](#dependencyproxymanifestregistry) | エッジの終端にあるアイテム。 |

#### `DeploymentConnection` {#deploymentconnection}

[`Deployment`](#deployment)の接続タイプ。

##### フィールド {#fields-766}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="deploymentconnectionedges"></a>`edges` | [`[DeploymentEdge]`](#deploymentedge) | エッジのリスト。 |
| <a id="deploymentconnectionnodes"></a>`nodes` | [`[Deployment]`](#deployment) | ノードのリスト。 |
| <a id="deploymentconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `DeploymentEdge` {#deploymentedge}

[`Deployment`](#deployment)のエッジ型。

##### フィールド {#fields-767}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="deploymentedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="deploymentedgenode"></a>`node` | [`Deployment`](#deployment) | エッジの終端にあるアイテム。 |

#### `DesignAtVersionConnection` {#designatversionconnection}

[`DesignAtVersion`](#designatversion)の接続タイプ。

##### フィールド {#fields-768}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="designatversionconnectionedges"></a>`edges` | [`[DesignAtVersionEdge]`](#designatversionedge) | エッジのリスト。 |
| <a id="designatversionconnectionnodes"></a>`nodes` | [`[DesignAtVersion]`](#designatversion) | ノードのリスト。 |
| <a id="designatversionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `DesignAtVersionEdge` {#designatversionedge}

[`DesignAtVersion`](#designatversion)のエッジ型。

##### フィールド {#fields-769}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="designatversionedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="designatversionedgenode"></a>`node` | [`DesignAtVersion`](#designatversion) | エッジの終端にあるアイテム。 |

#### `DesignConnection` {#designconnection}

[`Design`](#design)の接続タイプ。

##### フィールド {#fields-770}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="designconnectionedges"></a>`edges` | [`[DesignEdge]`](#designedge) | エッジのリスト。 |
| <a id="designconnectionnodes"></a>`nodes` | [`[Design]`](#design) | ノードのリスト。 |
| <a id="designconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `DesignEdge` {#designedge}

[`Design`](#design)のエッジ型。

##### フィールド {#fields-771}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="designedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="designedgenode"></a>`node` | [`Design`](#design) | エッジの終端にあるアイテム。 |

#### `DesignManagementRepositoryRegistryConnection` {#designmanagementrepositoryregistryconnection}

[`DesignManagementRepositoryRegistry`](#designmanagementrepositoryregistry)の接続タイプ。

##### フィールド {#fields-772}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="designmanagementrepositoryregistryconnectionedges"></a>`edges` | [`[DesignManagementRepositoryRegistryEdge]`](#designmanagementrepositoryregistryedge) | エッジのリスト。 |
| <a id="designmanagementrepositoryregistryconnectionnodes"></a>`nodes` | [`[DesignManagementRepositoryRegistry]`](#designmanagementrepositoryregistry) | ノードのリスト。 |
| <a id="designmanagementrepositoryregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

##### 引数のあるフィールド {#fields-with-arguments-6}

###### `DesignManagementRepositoryRegistryConnection.count` {#designmanagementrepositoryregistryconnectioncount}

コレクションの制限カウント。制限を超えるカウントの場合、制限+1を返します。

[`Int!`](#int)を返します。

\#######引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="designmanagementrepositoryregistryconnectioncountlimit"></a>`limit` | [`Int`](#int) | カウントクエリに適用される制限値。デフォルトは1000です。 |

#### `DesignManagementRepositoryRegistryEdge` {#designmanagementrepositoryregistryedge}

[`DesignManagementRepositoryRegistry`](#designmanagementrepositoryregistry)のエッジ型。

##### フィールド {#fields-773}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="designmanagementrepositoryregistryedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="designmanagementrepositoryregistryedgenode"></a>`node` | [`DesignManagementRepositoryRegistry`](#designmanagementrepositoryregistry) | エッジの終端にあるアイテム。 |

#### `DesignVersionConnection` {#designversionconnection}

[`DesignVersion`](#designversion)の接続タイプ。

##### フィールド {#fields-774}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="designversionconnectionedges"></a>`edges` | [`[DesignVersionEdge]`](#designversionedge) | エッジのリスト。 |
| <a id="designversionconnectionnodes"></a>`nodes` | [`[DesignVersion]`](#designversion) | ノードのリスト。 |
| <a id="designversionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `DesignVersionEdge` {#designversionedge}

[`DesignVersion`](#designversion)のエッジ型。

##### フィールド {#fields-775}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="designversionedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="designversionedgenode"></a>`node` | [`DesignVersion`](#designversion) | エッジの終端にあるアイテム。 |

#### `DevopsAdoptionEnabledNamespaceConnection` {#devopsadoptionenablednamespaceconnection}

[`DevopsAdoptionEnabledNamespace`](#devopsadoptionenablednamespace)の接続タイプ。

##### フィールド {#fields-776}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="devopsadoptionenablednamespaceconnectionedges"></a>`edges` | [`[DevopsAdoptionEnabledNamespaceEdge]`](#devopsadoptionenablednamespaceedge) | エッジのリスト。 |
| <a id="devopsadoptionenablednamespaceconnectionnodes"></a>`nodes` | [`[DevopsAdoptionEnabledNamespace]`](#devopsadoptionenablednamespace) | ノードのリスト。 |
| <a id="devopsadoptionenablednamespaceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `DevopsAdoptionEnabledNamespaceEdge` {#devopsadoptionenablednamespaceedge}

[`DevopsAdoptionEnabledNamespace`](#devopsadoptionenablednamespace)のエッジ型。

##### フィールド {#fields-777}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="devopsadoptionenablednamespaceedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="devopsadoptionenablednamespaceedgenode"></a>`node` | [`DevopsAdoptionEnabledNamespace`](#devopsadoptionenablednamespace) | エッジの終端にあるアイテム。 |

#### `DevopsAdoptionSnapshotConnection` {#devopsadoptionsnapshotconnection}

[`DevopsAdoptionSnapshot`](#devopsadoptionsnapshot)の接続タイプ。

##### フィールド {#fields-778}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="devopsadoptionsnapshotconnectionedges"></a>`edges` | [`[DevopsAdoptionSnapshotEdge]`](#devopsadoptionsnapshotedge) | エッジのリスト。 |
| <a id="devopsadoptionsnapshotconnectionnodes"></a>`nodes` | [`[DevopsAdoptionSnapshot]`](#devopsadoptionsnapshot) | ノードのリスト。 |
| <a id="devopsadoptionsnapshotconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `DevopsAdoptionSnapshotEdge` {#devopsadoptionsnapshotedge}

[`DevopsAdoptionSnapshot`](#devopsadoptionsnapshot)のエッジ型。

##### フィールド {#fields-779}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="devopsadoptionsnapshotedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="devopsadoptionsnapshotedgenode"></a>`node` | [`DevopsAdoptionSnapshot`](#devopsadoptionsnapshot) | エッジの終端にあるアイテム。 |

#### `DiscussionConnection` {#discussionconnection}

[`Discussion`](#discussion)の接続タイプ。

##### フィールド {#fields-780}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="discussionconnectionedges"></a>`edges` | [`[DiscussionEdge]`](#discussionedge) | エッジのリスト。 |
| <a id="discussionconnectionnodes"></a>`nodes` | [`[Discussion]`](#discussion) | ノードのリスト。 |
| <a id="discussionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `DiscussionEdge` {#discussionedge}

[`Discussion`](#discussion)のエッジ型。

##### フィールド {#fields-781}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="discussionedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="discussionedgenode"></a>`node` | [`Discussion`](#discussion) | エッジの終端にあるアイテム。 |

#### `DoraPerformanceScoreCountConnection` {#doraperformancescorecountconnection}

[`DoraPerformanceScoreCount`](#doraperformancescorecount)の接続タイプ。

##### フィールド {#fields-782}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="doraperformancescorecountconnectionedges"></a>`edges` | [`[DoraPerformanceScoreCountEdge]`](#doraperformancescorecountedge) | エッジのリスト。 |
| <a id="doraperformancescorecountconnectionnodoradataprojectscount"></a>`noDoraDataProjectsCount` | [`Int!`](#int) | スコープ内のDORAスコアがないプロジェクトの数。 |
| <a id="doraperformancescorecountconnectionnodes"></a>`nodes` | [`[DoraPerformanceScoreCount]`](#doraperformancescorecount) | ノードのリスト。 |
| <a id="doraperformancescorecountconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |
| <a id="doraperformancescorecountconnectiontotalprojectscount"></a>`totalProjectsCount` | [`Int!`](#int) | プロジェクトの総数。 |

#### `DoraPerformanceScoreCountEdge` {#doraperformancescorecountedge}

[`DoraPerformanceScoreCount`](#doraperformancescorecount)のエッジ型。

##### フィールド {#fields-783}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="doraperformancescorecountedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="doraperformancescorecountedgenode"></a>`node` | [`DoraPerformanceScoreCount`](#doraperformancescorecount) | エッジの終端にあるアイテム。 |

#### `DuoWorkflowConnection` {#duoworkflowconnection}

[`DuoWorkflow`](#duoworkflow)の接続タイプ。

##### フィールド {#fields-784}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="duoworkflowconnectionedges"></a>`edges` | [`[DuoWorkflowEdge]`](#duoworkflowedge) | エッジのリスト。 |
| <a id="duoworkflowconnectionnodes"></a>`nodes` | [`[DuoWorkflow]`](#duoworkflow) | ノードのリスト。 |
| <a id="duoworkflowconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `DuoWorkflowEdge` {#duoworkflowedge}

[`DuoWorkflow`](#duoworkflow)のエッジ型。

##### フィールド {#fields-785}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="duoworkflowedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="duoworkflowedgenode"></a>`node` | [`DuoWorkflow`](#duoworkflow) | エッジの終端にあるアイテム。 |

#### `DuoWorkflowEventConnection` {#duoworkfloweventconnection}

[`DuoWorkflowEvent`](#duoworkflowevent)の接続タイプ。

##### フィールド {#fields-786}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="duoworkfloweventconnectionedges"></a>`edges` | [`[DuoWorkflowEventEdge]`](#duoworkfloweventedge) | エッジのリスト。 |
| <a id="duoworkfloweventconnectionnodes"></a>`nodes` | [`[DuoWorkflowEvent]`](#duoworkflowevent) | ノードのリスト。 |
| <a id="duoworkfloweventconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `DuoWorkflowEventEdge` {#duoworkfloweventedge}

[`DuoWorkflowEvent`](#duoworkflowevent)のエッジ型。

##### フィールド {#fields-787}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="duoworkfloweventedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="duoworkfloweventedgenode"></a>`node` | [`DuoWorkflowEvent`](#duoworkflowevent) | エッジの終端にあるアイテム。 |

#### `EgressNodeConnection` {#egressnodeconnection}

[`EgressNode`](#egressnode)の接続タイプ。

##### フィールド {#fields-788}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="egressnodeconnectionedges"></a>`edges` | [`[EgressNodeEdge]`](#egressnodeedge) | エッジのリスト。 |
| <a id="egressnodeconnectionnodes"></a>`nodes` | [`[EgressNode]`](#egressnode) | ノードのリスト。 |
| <a id="egressnodeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `EgressNodeEdge` {#egressnodeedge}

[`EgressNode`](#egressnode)のエッジ型。

##### フィールド {#fields-789}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="egressnodeedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="egressnodeedgenode"></a>`node` | [`EgressNode`](#egressnode) | エッジの終端にあるアイテム。 |

#### `EmailConnection` {#emailconnection}

[`Email`](#email)の接続タイプ。

##### フィールド {#fields-790}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="emailconnectionedges"></a>`edges` | [`[EmailEdge]`](#emailedge) | エッジのリスト。 |
| <a id="emailconnectionnodes"></a>`nodes` | [`[Email]`](#email) | ノードのリスト。 |
| <a id="emailconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `EmailEdge` {#emailedge}

[`Email`](#email)のエッジ型。

##### フィールド {#fields-791}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="emailedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="emailedgenode"></a>`node` | [`Email`](#email) | エッジの終端にあるアイテム。 |

#### `EmailParticipantTypeConnection` {#emailparticipanttypeconnection}

[`EmailParticipantType`](#emailparticipanttype)の接続タイプ。

##### フィールド {#fields-792}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="emailparticipanttypeconnectionedges"></a>`edges` | [`[EmailParticipantTypeEdge]`](#emailparticipanttypeedge) | エッジのリスト。 |
| <a id="emailparticipanttypeconnectionnodes"></a>`nodes` | [`[EmailParticipantType]`](#emailparticipanttype) | ノードのリスト。 |
| <a id="emailparticipanttypeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `EmailParticipantTypeEdge` {#emailparticipanttypeedge}

[`EmailParticipantType`](#emailparticipanttype)のエッジ型。

##### フィールド {#fields-793}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="emailparticipanttypeedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="emailparticipanttypeedgenode"></a>`node` | [`EmailParticipantType`](#emailparticipanttype) | エッジの終端にあるアイテム。 |

#### `EnvironmentConnection` {#environmentconnection}

[`Environment`](#environment)の接続タイプ。

##### フィールド {#fields-794}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="environmentconnectionedges"></a>`edges` | [`[EnvironmentEdge]`](#environmentedge) | エッジのリスト。 |
| <a id="environmentconnectionnodes"></a>`nodes` | [`[Environment]`](#environment) | ノードのリスト。 |
| <a id="environmentconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `EnvironmentEdge` {#environmentedge}

[`Environment`](#environment)のエッジ型。

##### フィールド {#fields-795}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="environmentedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="environmentedgenode"></a>`node` | [`Environment`](#environment) | エッジの終端にあるアイテム。 |

#### `EpicBoardConnection` {#epicboardconnection}

[`EpicBoard`](#epicboard)の接続タイプ。

##### フィールド {#fields-796}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="epicboardconnectionedges"></a>`edges` | [`[EpicBoardEdge]`](#epicboardedge) | エッジのリスト。 |
| <a id="epicboardconnectionnodes"></a>`nodes` | [`[EpicBoard]`](#epicboard) | ノードのリスト。 |
| <a id="epicboardconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `EpicBoardEdge` {#epicboardedge}

[`EpicBoard`](#epicboard)のエッジ型。

##### フィールド {#fields-797}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="epicboardedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="epicboardedgenode"></a>`node` | [`EpicBoard`](#epicboard) | エッジの終端にあるアイテム。 |

#### `EpicConnection` {#epicconnection}

[`Epic`](#epic)の接続タイプ。

##### フィールド {#fields-798}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="epicconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="epicconnectionedges"></a>`edges` | [`[EpicEdge]`](#epicedge) | エッジのリスト。 |
| <a id="epicconnectionnodes"></a>`nodes` | [`[Epic]`](#epic) | ノードのリスト。 |
| <a id="epicconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `EpicEdge` {#epicedge}

[`Epic`](#epic)のエッジ型。

##### フィールド {#fields-799}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="epicedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="epicedgenode"></a>`node` | [`Epic`](#epic) | エッジの終端にあるアイテム。 |

#### `EpicIssueConnection` {#epicissueconnection}

[`EpicIssue`](#epicissue)の接続タイプ。

##### フィールド {#fields-800}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="epicissueconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="epicissueconnectionedges"></a>`edges` | [`[EpicIssueEdge]`](#epicissueedge) | エッジのリスト。 |
| <a id="epicissueconnectionnodes"></a>`nodes` | [`[EpicIssue]`](#epicissue) | ノードのリスト。 |
| <a id="epicissueconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |
| <a id="epicissueconnectionweight"></a>`weight` | [`Int!`](#int) | イシューコレクションの合計ウェイト。 |

#### `EpicIssueEdge` {#epicissueedge}

[`EpicIssue`](#epicissue)のエッジ型。

##### フィールド {#fields-801}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="epicissueedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="epicissueedgenode"></a>`node` | [`EpicIssue`](#epicissue) | エッジの終端にあるアイテム。 |

#### `EpicListConnection` {#epiclistconnection}

[`EpicList`](#epiclist)の接続タイプ。

##### フィールド {#fields-802}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="epiclistconnectionedges"></a>`edges` | [`[EpicListEdge]`](#epiclistedge) | エッジのリスト。 |
| <a id="epiclistconnectionnodes"></a>`nodes` | [`[EpicList]`](#epiclist) | ノードのリスト。 |
| <a id="epiclistconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `EpicListEdge` {#epiclistedge}

[`EpicList`](#epiclist)のエッジ型。

##### フィールド {#fields-803}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="epiclistedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="epiclistedgenode"></a>`node` | [`EpicList`](#epiclist) | エッジの終端にあるアイテム。 |

#### `ErrorTrackingStackTraceConnection` {#errortrackingstacktraceconnection}

[`ErrorTrackingStackTrace`](#errortrackingstacktrace)の接続タイプ。

##### フィールド {#fields-804}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="errortrackingstacktraceconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="errortrackingstacktraceconnectionedges"></a>`edges` | [`[ErrorTrackingStackTraceEdge]`](#errortrackingstacktraceedge) | エッジのリスト。 |
| <a id="errortrackingstacktraceconnectionnodes"></a>`nodes` | [`[ErrorTrackingStackTrace]`](#errortrackingstacktrace) | ノードのリスト。 |
| <a id="errortrackingstacktraceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ErrorTrackingStackTraceEdge` {#errortrackingstacktraceedge}

[`ErrorTrackingStackTrace`](#errortrackingstacktrace)のエッジ型。

##### フィールド {#fields-805}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="errortrackingstacktraceedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="errortrackingstacktraceedgenode"></a>`node` | [`ErrorTrackingStackTrace`](#errortrackingstacktrace) | エッジの終端にあるアイテム。 |

#### `EscalationPolicyTypeConnection` {#escalationpolicytypeconnection}

[`EscalationPolicyType`](#escalationpolicytype)の接続タイプ。

##### フィールド {#fields-806}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="escalationpolicytypeconnectionedges"></a>`edges` | [`[EscalationPolicyTypeEdge]`](#escalationpolicytypeedge) | エッジのリスト。 |
| <a id="escalationpolicytypeconnectionnodes"></a>`nodes` | [`[EscalationPolicyType]`](#escalationpolicytype) | ノードのリスト。 |
| <a id="escalationpolicytypeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `EscalationPolicyTypeEdge` {#escalationpolicytypeedge}

[`EscalationPolicyType`](#escalationpolicytype)のエッジ型。

##### フィールド {#fields-807}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="escalationpolicytypeedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="escalationpolicytypeedgenode"></a>`node` | [`EscalationPolicyType`](#escalationpolicytype) | エッジの終端にあるアイテム。 |

#### `EventConnection` {#eventconnection}

[`Event`](#event)の接続タイプ。

##### フィールド {#fields-808}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="eventconnectionedges"></a>`edges` | [`[EventEdge]`](#eventedge) | エッジのリスト。 |
| <a id="eventconnectionnodes"></a>`nodes` | [`[Event]`](#event) | ノードのリスト。 |
| <a id="eventconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `EventEdge` {#eventedge}

[`Event`](#event)のエッジ型。

##### フィールド {#fields-809}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="eventedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="eventedgenode"></a>`node` | [`Event`](#event) | エッジの終端にあるアイテム。 |

#### `ExternalAuditEventDestinationConnection` {#externalauditeventdestinationconnection}

[`ExternalAuditEventDestination`](#externalauditeventdestination)の接続タイプ。

##### フィールド {#fields-810}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="externalauditeventdestinationconnectionedges"></a>`edges` | [`[ExternalAuditEventDestinationEdge]`](#externalauditeventdestinationedge) | エッジのリスト。 |
| <a id="externalauditeventdestinationconnectionnodes"></a>`nodes` | [`[ExternalAuditEventDestination]`](#externalauditeventdestination) | ノードのリスト。 |
| <a id="externalauditeventdestinationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ExternalAuditEventDestinationEdge` {#externalauditeventdestinationedge}

[`ExternalAuditEventDestination`](#externalauditeventdestination)のエッジ型。

##### フィールド {#fields-811}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="externalauditeventdestinationedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="externalauditeventdestinationedgenode"></a>`node` | [`ExternalAuditEventDestination`](#externalauditeventdestination) | エッジの終端にあるアイテム。 |

#### `ExternalStatusCheckConnection` {#externalstatuscheckconnection}

[`ExternalStatusCheck`](#externalstatuscheck)の接続タイプ。

##### フィールド {#fields-812}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="externalstatuscheckconnectionedges"></a>`edges` | [`[ExternalStatusCheckEdge]`](#externalstatuscheckedge) | エッジのリスト。 |
| <a id="externalstatuscheckconnectionnodes"></a>`nodes` | [`[ExternalStatusCheck]`](#externalstatuscheck) | ノードのリスト。 |
| <a id="externalstatuscheckconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ExternalStatusCheckEdge` {#externalstatuscheckedge}

[`ExternalStatusCheck`](#externalstatuscheck)のエッジ型。

##### フィールド {#fields-813}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="externalstatuscheckedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="externalstatuscheckedgenode"></a>`node` | [`ExternalStatusCheck`](#externalstatuscheck) | エッジの終端にあるアイテム。 |

#### `FeatureFlagConnection` {#featureflagconnection}

[`FeatureFlag`](#featureflag)の接続タイプ。

##### フィールド {#fields-814}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="featureflagconnectionedges"></a>`edges` | [`[FeatureFlagEdge]`](#featureflagedge) | エッジのリスト。 |
| <a id="featureflagconnectionnodes"></a>`nodes` | [`[FeatureFlag]`](#featureflag) | ノードのリスト。 |
| <a id="featureflagconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `FeatureFlagEdge` {#featureflagedge}

[`FeatureFlag`](#featureflag)のエッジ型。

##### フィールド {#fields-815}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="featureflagedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="featureflagedgenode"></a>`node` | [`FeatureFlag`](#featureflag) | エッジの終端にあるアイテム。 |

#### `GitlabSubscriptionHistoryConnection` {#gitlabsubscriptionhistoryconnection}

[`GitlabSubscriptionHistory`](#gitlabsubscriptionhistory)の接続タイプ。

##### フィールド {#fields-816}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="gitlabsubscriptionhistoryconnectionedges"></a>`edges` | [`[GitlabSubscriptionHistoryEdge]`](#gitlabsubscriptionhistoryedge) | エッジのリスト。 |
| <a id="gitlabsubscriptionhistoryconnectionnodes"></a>`nodes` | [`[GitlabSubscriptionHistory]`](#gitlabsubscriptionhistory) | ノードのリスト。 |
| <a id="gitlabsubscriptionhistoryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `GitlabSubscriptionHistoryEdge` {#gitlabsubscriptionhistoryedge}

[`GitlabSubscriptionHistory`](#gitlabsubscriptionhistory)のエッジ型。

##### フィールド {#fields-817}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="gitlabsubscriptionhistoryedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="gitlabsubscriptionhistoryedgenode"></a>`node` | [`GitlabSubscriptionHistory`](#gitlabsubscriptionhistory) | エッジの終端にあるアイテム。 |

#### `GoogleCloudArtifactRegistryArtifactConnection` {#googlecloudartifactregistryartifactconnection}

[`GoogleCloudArtifactRegistryArtifact`](#googlecloudartifactregistryartifact)の接続タイプ。

##### フィールド {#fields-818}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="googlecloudartifactregistryartifactconnectionedges"></a>`edges` | [`[GoogleCloudArtifactRegistryArtifactEdge]`](#googlecloudartifactregistryartifactedge) | エッジのリスト。 |
| <a id="googlecloudartifactregistryartifactconnectionnodes"></a>`nodes` | [`[GoogleCloudArtifactRegistryArtifact]`](#googlecloudartifactregistryartifact) | ノードのリスト。 |
| <a id="googlecloudartifactregistryartifactconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `GoogleCloudArtifactRegistryArtifactEdge` {#googlecloudartifactregistryartifactedge}

[`GoogleCloudArtifactRegistryArtifact`](#googlecloudartifactregistryartifact)のエッジ型。

##### フィールド {#fields-819}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="googlecloudartifactregistryartifactedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="googlecloudartifactregistryartifactedgenode"></a>`node` | [`GoogleCloudArtifactRegistryArtifact`](#googlecloudartifactregistryartifact) | エッジの終端にあるアイテム。 |

#### `GoogleCloudLoggingConfigurationTypeConnection` {#googlecloudloggingconfigurationtypeconnection}

[`GoogleCloudLoggingConfigurationType`](#googlecloudloggingconfigurationtype)の接続タイプ。

##### フィールド {#fields-820}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="googlecloudloggingconfigurationtypeconnectionedges"></a>`edges` | [`[GoogleCloudLoggingConfigurationTypeEdge]`](#googlecloudloggingconfigurationtypeedge) | エッジのリスト。 |
| <a id="googlecloudloggingconfigurationtypeconnectionnodes"></a>`nodes` | [`[GoogleCloudLoggingConfigurationType]`](#googlecloudloggingconfigurationtype) | ノードのリスト。 |
| <a id="googlecloudloggingconfigurationtypeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `GoogleCloudLoggingConfigurationTypeEdge` {#googlecloudloggingconfigurationtypeedge}

[`GoogleCloudLoggingConfigurationType`](#googlecloudloggingconfigurationtype)のエッジ型。

##### フィールド {#fields-821}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="googlecloudloggingconfigurationtypeedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="googlecloudloggingconfigurationtypeedgenode"></a>`node` | [`GoogleCloudLoggingConfigurationType`](#googlecloudloggingconfigurationtype) | エッジの終端にあるアイテム。 |

#### `GroupAuditEventStreamingDestinationConnection` {#groupauditeventstreamingdestinationconnection}

[`GroupAuditEventStreamingDestination`](#groupauditeventstreamingdestination)の接続タイプ。

##### フィールド {#fields-822}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="groupauditeventstreamingdestinationconnectionedges"></a>`edges` | [`[GroupAuditEventStreamingDestinationEdge]`](#groupauditeventstreamingdestinationedge) | エッジのリスト。 |
| <a id="groupauditeventstreamingdestinationconnectionnodes"></a>`nodes` | [`[GroupAuditEventStreamingDestination]`](#groupauditeventstreamingdestination) | ノードのリスト。 |
| <a id="groupauditeventstreamingdestinationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `GroupAuditEventStreamingDestinationEdge` {#groupauditeventstreamingdestinationedge}

[`GroupAuditEventStreamingDestination`](#groupauditeventstreamingdestination)のエッジ型。

##### フィールド {#fields-823}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="groupauditeventstreamingdestinationedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="groupauditeventstreamingdestinationedgenode"></a>`node` | [`GroupAuditEventStreamingDestination`](#groupauditeventstreamingdestination) | エッジの終端にあるアイテム。 |

#### `GroupConnection` {#groupconnection}

[`Group`](#group)の接続タイプ。

##### フィールド {#fields-824}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="groupconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="groupconnectionedges"></a>`edges` | [`[GroupEdge]`](#groupedge) | エッジのリスト。 |
| <a id="groupconnectionnodes"></a>`nodes` | [`[Group]`](#group) | ノードのリスト。 |
| <a id="groupconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `GroupEdge` {#groupedge}

[`Group`](#group)のエッジ型。

##### フィールド {#fields-825}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="groupedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="groupedgenode"></a>`node` | [`Group`](#group) | エッジの終端にあるアイテム。 |

#### `GroupInterfaceConnection` {#groupinterfaceconnection}

[`GroupInterface`](#groupinterface)の接続タイプ。

##### フィールド {#fields-826}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="groupinterfaceconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="groupinterfaceconnectionedges"></a>`edges` | [`[GroupInterfaceEdge]`](#groupinterfaceedge) | エッジのリスト。 |
| <a id="groupinterfaceconnectionnodes"></a>`nodes` | [`[GroupInterface]`](#groupinterface) | ノードのリスト。 |
| <a id="groupinterfaceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `GroupInterfaceEdge` {#groupinterfaceedge}

[`GroupInterface`](#groupinterface)のエッジ型。

##### フィールド {#fields-827}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="groupinterfaceedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="groupinterfaceedgenode"></a>`node` | [`GroupInterface`](#groupinterface) | エッジの終端にあるアイテム。 |

#### `GroupMemberConnection` {#groupmemberconnection}

[`GroupMember`](#groupmember)の接続タイプ。

##### フィールド {#fields-828}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="groupmemberconnectionedges"></a>`edges` | [`[GroupMemberEdge]`](#groupmemberedge) | エッジのリスト。 |
| <a id="groupmemberconnectionnodes"></a>`nodes` | [`[GroupMember]`](#groupmember) | ノードのリスト。 |
| <a id="groupmemberconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `GroupMemberEdge` {#groupmemberedge}

[`GroupMember`](#groupmember)のエッジ型。

##### フィールド {#fields-829}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="groupmemberedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="groupmemberedgenode"></a>`node` | [`GroupMember`](#groupmember) | エッジの終端にあるアイテム。 |

#### `GroupSavedReplyConnection` {#groupsavedreplyconnection}

[`GroupSavedReply`](#groupsavedreply)の接続タイプ。

##### フィールド {#fields-830}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="groupsavedreplyconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="groupsavedreplyconnectionedges"></a>`edges` | [`[GroupSavedReplyEdge]`](#groupsavedreplyedge) | エッジのリスト。 |
| <a id="groupsavedreplyconnectionnodes"></a>`nodes` | [`[GroupSavedReply]`](#groupsavedreply) | ノードのリスト。 |
| <a id="groupsavedreplyconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `GroupSavedReplyEdge` {#groupsavedreplyedge}

[`GroupSavedReply`](#groupsavedreply)のエッジ型。

##### フィールド {#fields-831}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="groupsavedreplyedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="groupsavedreplyedgenode"></a>`node` | [`GroupSavedReply`](#groupsavedreply) | エッジの終端にあるアイテム。 |

#### `GroupWikiRepositoryRegistryConnection` {#groupwikirepositoryregistryconnection}

[`GroupWikiRepositoryRegistry`](#groupwikirepositoryregistry)の接続タイプ。

##### フィールド {#fields-832}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="groupwikirepositoryregistryconnectionedges"></a>`edges` | [`[GroupWikiRepositoryRegistryEdge]`](#groupwikirepositoryregistryedge) | エッジのリスト。 |
| <a id="groupwikirepositoryregistryconnectionnodes"></a>`nodes` | [`[GroupWikiRepositoryRegistry]`](#groupwikirepositoryregistry) | ノードのリスト。 |
| <a id="groupwikirepositoryregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

##### 引数のあるフィールド {#fields-with-arguments-7}

###### `GroupWikiRepositoryRegistryConnection.count` {#groupwikirepositoryregistryconnectioncount}

コレクションの制限カウント。制限を超えるカウントの場合、制限+1を返します。

[`Int!`](#int)を返します。

\#######引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="groupwikirepositoryregistryconnectioncountlimit"></a>`limit` | [`Int`](#int) | カウントクエリに適用される制限値。デフォルトは1000です。 |

#### `GroupWikiRepositoryRegistryEdge` {#groupwikirepositoryregistryedge}

[`GroupWikiRepositoryRegistry`](#groupwikirepositoryregistry)のエッジ型。

##### フィールド {#fields-833}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="groupwikirepositoryregistryedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="groupwikirepositoryregistryedgenode"></a>`node` | [`GroupWikiRepositoryRegistry`](#groupwikirepositoryregistry) | エッジの終端にあるアイテム。 |

#### `ImportSourceUserConnection` {#importsourceuserconnection}

[`ImportSourceUser`](#importsourceuser)の接続タイプ。

##### フィールド {#fields-834}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="importsourceuserconnectionedges"></a>`edges` | [`[ImportSourceUserEdge]`](#importsourceuseredge) | エッジのリスト。 |
| <a id="importsourceuserconnectionnodes"></a>`nodes` | [`[ImportSourceUser]`](#importsourceuser) | ノードのリスト。 |
| <a id="importsourceuserconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ImportSourceUserEdge` {#importsourceuseredge}

[`ImportSourceUser`](#importsourceuser)のエッジ型。

##### フィールド {#fields-835}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="importsourceuseredgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="importsourceuseredgenode"></a>`node` | [`ImportSourceUser`](#importsourceuser) | エッジの終端にあるアイテム。 |

#### `IncidentManagementOncallRotationConnection` {#incidentmanagementoncallrotationconnection}

[`IncidentManagementOncallRotation`](#incidentmanagementoncallrotation)の接続タイプ。

##### フィールド {#fields-836}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="incidentmanagementoncallrotationconnectionedges"></a>`edges` | [`[IncidentManagementOncallRotationEdge]`](#incidentmanagementoncallrotationedge) | エッジのリスト。 |
| <a id="incidentmanagementoncallrotationconnectionnodes"></a>`nodes` | [`[IncidentManagementOncallRotation]`](#incidentmanagementoncallrotation) | ノードのリスト。 |
| <a id="incidentmanagementoncallrotationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `IncidentManagementOncallRotationEdge` {#incidentmanagementoncallrotationedge}

[`IncidentManagementOncallRotation`](#incidentmanagementoncallrotation)のエッジ型。

##### フィールド {#fields-837}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="incidentmanagementoncallrotationedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="incidentmanagementoncallrotationedgenode"></a>`node` | [`IncidentManagementOncallRotation`](#incidentmanagementoncallrotation) | エッジの終端にあるアイテム。 |

#### `IncidentManagementOncallScheduleConnection` {#incidentmanagementoncallscheduleconnection}

[`IncidentManagementOncallSchedule`](#incidentmanagementoncallschedule)の接続タイプ。

##### フィールド {#fields-838}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="incidentmanagementoncallscheduleconnectionedges"></a>`edges` | [`[IncidentManagementOncallScheduleEdge]`](#incidentmanagementoncallscheduleedge) | エッジのリスト。 |
| <a id="incidentmanagementoncallscheduleconnectionnodes"></a>`nodes` | [`[IncidentManagementOncallSchedule]`](#incidentmanagementoncallschedule) | ノードのリスト。 |
| <a id="incidentmanagementoncallscheduleconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `IncidentManagementOncallScheduleEdge` {#incidentmanagementoncallscheduleedge}

[`IncidentManagementOncallSchedule`](#incidentmanagementoncallschedule)のエッジ型。

##### フィールド {#fields-839}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="incidentmanagementoncallscheduleedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="incidentmanagementoncallscheduleedgenode"></a>`node` | [`IncidentManagementOncallSchedule`](#incidentmanagementoncallschedule) | エッジの終端にあるアイテム。 |

#### `IncidentManagementOncallShiftConnection` {#incidentmanagementoncallshiftconnection}

[`IncidentManagementOncallShift`](#incidentmanagementoncallshift)の接続タイプ。

##### フィールド {#fields-840}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="incidentmanagementoncallshiftconnectionedges"></a>`edges` | [`[IncidentManagementOncallShiftEdge]`](#incidentmanagementoncallshiftedge) | エッジのリスト。 |
| <a id="incidentmanagementoncallshiftconnectionnodes"></a>`nodes` | [`[IncidentManagementOncallShift]`](#incidentmanagementoncallshift) | ノードのリスト。 |
| <a id="incidentmanagementoncallshiftconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `IncidentManagementOncallShiftEdge` {#incidentmanagementoncallshiftedge}

[`IncidentManagementOncallShift`](#incidentmanagementoncallshift)のエッジ型。

##### フィールド {#fields-841}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="incidentmanagementoncallshiftedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="incidentmanagementoncallshiftedgenode"></a>`node` | [`IncidentManagementOncallShift`](#incidentmanagementoncallshift) | エッジの終端にあるアイテム。 |

#### `InheritedCiVariableConnection` {#inheritedcivariableconnection}

[`InheritedCiVariable`](#inheritedcivariable)の接続タイプ。

##### フィールド {#fields-842}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="inheritedcivariableconnectionedges"></a>`edges` | [`[InheritedCiVariableEdge]`](#inheritedcivariableedge) | エッジのリスト。 |
| <a id="inheritedcivariableconnectionnodes"></a>`nodes` | [`[InheritedCiVariable]`](#inheritedcivariable) | ノードのリスト。 |
| <a id="inheritedcivariableconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `InheritedCiVariableEdge` {#inheritedcivariableedge}

[`InheritedCiVariable`](#inheritedcivariable)のエッジ型。

##### フィールド {#fields-843}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="inheritedcivariableedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="inheritedcivariableedgenode"></a>`node` | [`InheritedCiVariable`](#inheritedcivariable) | エッジの終端にあるアイテム。 |

#### `InstanceAmazonS3ConfigurationTypeConnection` {#instanceamazons3configurationtypeconnection}

[`InstanceAmazonS3ConfigurationType`](#instanceamazons3configurationtype)の接続タイプ。

##### フィールド {#fields-844}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="instanceamazons3configurationtypeconnectionedges"></a>`edges` | [`[InstanceAmazonS3ConfigurationTypeEdge]`](#instanceamazons3configurationtypeedge) | エッジのリスト。 |
| <a id="instanceamazons3configurationtypeconnectionnodes"></a>`nodes` | [`[InstanceAmazonS3ConfigurationType]`](#instanceamazons3configurationtype) | ノードのリスト。 |
| <a id="instanceamazons3configurationtypeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `InstanceAmazonS3ConfigurationTypeEdge` {#instanceamazons3configurationtypeedge}

[`InstanceAmazonS3ConfigurationType`](#instanceamazons3configurationtype)のエッジ型。

##### フィールド {#fields-845}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="instanceamazons3configurationtypeedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="instanceamazons3configurationtypeedgenode"></a>`node` | [`InstanceAmazonS3ConfigurationType`](#instanceamazons3configurationtype) | エッジの終端にあるアイテム。 |

#### `InstanceAuditEventStreamingDestinationConnection` {#instanceauditeventstreamingdestinationconnection}

[`InstanceAuditEventStreamingDestination`](#instanceauditeventstreamingdestination)の接続タイプ。

##### フィールド {#fields-846}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="instanceauditeventstreamingdestinationconnectionedges"></a>`edges` | [`[InstanceAuditEventStreamingDestinationEdge]`](#instanceauditeventstreamingdestinationedge) | エッジのリスト。 |
| <a id="instanceauditeventstreamingdestinationconnectionnodes"></a>`nodes` | [`[InstanceAuditEventStreamingDestination]`](#instanceauditeventstreamingdestination) | ノードのリスト。 |
| <a id="instanceauditeventstreamingdestinationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `InstanceAuditEventStreamingDestinationEdge` {#instanceauditeventstreamingdestinationedge}

[`InstanceAuditEventStreamingDestination`](#instanceauditeventstreamingdestination)のエッジ型。

##### フィールド {#fields-847}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="instanceauditeventstreamingdestinationedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="instanceauditeventstreamingdestinationedgenode"></a>`node` | [`InstanceAuditEventStreamingDestination`](#instanceauditeventstreamingdestination) | エッジの終端にあるアイテム。 |

#### `InstanceExternalAuditEventDestinationConnection` {#instanceexternalauditeventdestinationconnection}

[`InstanceExternalAuditEventDestination`](#instanceexternalauditeventdestination)の接続タイプ。

##### フィールド {#fields-848}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="instanceexternalauditeventdestinationconnectionedges"></a>`edges` | [`[InstanceExternalAuditEventDestinationEdge]`](#instanceexternalauditeventdestinationedge) | エッジのリスト。 |
| <a id="instanceexternalauditeventdestinationconnectionnodes"></a>`nodes` | [`[InstanceExternalAuditEventDestination]`](#instanceexternalauditeventdestination) | ノードのリスト。 |
| <a id="instanceexternalauditeventdestinationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `InstanceExternalAuditEventDestinationEdge` {#instanceexternalauditeventdestinationedge}

[`InstanceExternalAuditEventDestination`](#instanceexternalauditeventdestination)のエッジ型。

##### フィールド {#fields-849}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="instanceexternalauditeventdestinationedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="instanceexternalauditeventdestinationedgenode"></a>`node` | [`InstanceExternalAuditEventDestination`](#instanceexternalauditeventdestination) | エッジの終端にあるアイテム。 |

#### `InstanceGoogleCloudLoggingConfigurationTypeConnection` {#instancegooglecloudloggingconfigurationtypeconnection}

[`InstanceGoogleCloudLoggingConfigurationType`](#instancegooglecloudloggingconfigurationtype)の接続タイプ。

##### フィールド {#fields-850}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="instancegooglecloudloggingconfigurationtypeconnectionedges"></a>`edges` | [`[InstanceGoogleCloudLoggingConfigurationTypeEdge]`](#instancegooglecloudloggingconfigurationtypeedge) | エッジのリスト。 |
| <a id="instancegooglecloudloggingconfigurationtypeconnectionnodes"></a>`nodes` | [`[InstanceGoogleCloudLoggingConfigurationType]`](#instancegooglecloudloggingconfigurationtype) | ノードのリスト。 |
| <a id="instancegooglecloudloggingconfigurationtypeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `InstanceGoogleCloudLoggingConfigurationTypeEdge` {#instancegooglecloudloggingconfigurationtypeedge}

[`InstanceGoogleCloudLoggingConfigurationType`](#instancegooglecloudloggingconfigurationtype)のエッジ型。

##### フィールド {#fields-851}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="instancegooglecloudloggingconfigurationtypeedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="instancegooglecloudloggingconfigurationtypeedgenode"></a>`node` | [`InstanceGoogleCloudLoggingConfigurationType`](#instancegooglecloudloggingconfigurationtype) | エッジの終端にあるアイテム。 |

#### `IntegrationExclusionConnection` {#integrationexclusionconnection}

[`IntegrationExclusion`](#integrationexclusion)の接続タイプ。

##### フィールド {#fields-852}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="integrationexclusionconnectionedges"></a>`edges` | [`[IntegrationExclusionEdge]`](#integrationexclusionedge) | エッジのリスト。 |
| <a id="integrationexclusionconnectionnodes"></a>`nodes` | [`[IntegrationExclusion]`](#integrationexclusion) | ノードのリスト。 |
| <a id="integrationexclusionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `IntegrationExclusionEdge` {#integrationexclusionedge}

[`IntegrationExclusion`](#integrationexclusion)のエッジ型。

##### フィールド {#fields-853}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="integrationexclusionedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="integrationexclusionedgenode"></a>`node` | [`IntegrationExclusion`](#integrationexclusion) | エッジの終端にあるアイテム。 |

#### `IssuableResourceLinkConnection` {#issuableresourcelinkconnection}

[`IssuableResourceLink`](#issuableresourcelink)の接続タイプ。

##### フィールド {#fields-854}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="issuableresourcelinkconnectionedges"></a>`edges` | [`[IssuableResourceLinkEdge]`](#issuableresourcelinkedge) | エッジのリスト。 |
| <a id="issuableresourcelinkconnectionnodes"></a>`nodes` | [`[IssuableResourceLink]`](#issuableresourcelink) | ノードのリスト。 |
| <a id="issuableresourcelinkconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `IssuableResourceLinkEdge` {#issuableresourcelinkedge}

[`IssuableResourceLink`](#issuableresourcelink)のエッジ型。

##### フィールド {#fields-855}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="issuableresourcelinkedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="issuableresourcelinkedgenode"></a>`node` | [`IssuableResourceLink`](#issuableresourcelink) | エッジの終端にあるアイテム。 |

#### `IssueConnection` {#issueconnection}

[`Issue`](#issue)の接続タイプ。

##### フィールド {#fields-856}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="issueconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="issueconnectionedges"></a>`edges` | [`[IssueEdge]`](#issueedge) | エッジのリスト。 |
| <a id="issueconnectionnodes"></a>`nodes` | [`[Issue]`](#issue) | ノードのリスト。 |
| <a id="issueconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |
| <a id="issueconnectionweight"></a>`weight` | [`Int!`](#int) | イシューコレクションの合計ウェイト。 |

#### `IssueEdge` {#issueedge}

[`Issue`](#issue)のエッジ型。

##### フィールド {#fields-857}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="issueedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="issueedgenode"></a>`node` | [`Issue`](#issue) | エッジの終端にあるアイテム。 |

#### `IterationCadenceConnection` {#iterationcadenceconnection}

[`IterationCadence`](#iterationcadence)の接続タイプ。

##### フィールド {#fields-858}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="iterationcadenceconnectionedges"></a>`edges` | [`[IterationCadenceEdge]`](#iterationcadenceedge) | エッジのリスト。 |
| <a id="iterationcadenceconnectionnodes"></a>`nodes` | [`[IterationCadence]`](#iterationcadence) | ノードのリスト。 |
| <a id="iterationcadenceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `IterationCadenceEdge` {#iterationcadenceedge}

[`IterationCadence`](#iterationcadence)のエッジ型。

##### フィールド {#fields-859}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="iterationcadenceedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="iterationcadenceedgenode"></a>`node` | [`IterationCadence`](#iterationcadence) | エッジの終端にあるアイテム。 |

#### `IterationConnection` {#iterationconnection}

[`Iteration`](#iteration)の接続タイプ。

##### フィールド {#fields-860}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="iterationconnectionedges"></a>`edges` | [`[IterationEdge]`](#iterationedge) | エッジのリスト。 |
| <a id="iterationconnectionnodes"></a>`nodes` | [`[Iteration]`](#iteration) | ノードのリスト。 |
| <a id="iterationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `IterationEdge` {#iterationedge}

[`Iteration`](#iteration)のエッジ型。

##### フィールド {#fields-861}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="iterationedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="iterationedgenode"></a>`node` | [`Iteration`](#iteration) | エッジの終端にあるアイテム。 |

#### `JiraImportConnection` {#jiraimportconnection}

[`JiraImport`](#jiraimport)の接続タイプ。

##### フィールド {#fields-862}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="jiraimportconnectionedges"></a>`edges` | [`[JiraImportEdge]`](#jiraimportedge) | エッジのリスト。 |
| <a id="jiraimportconnectionnodes"></a>`nodes` | [`[JiraImport]`](#jiraimport) | ノードのリスト。 |
| <a id="jiraimportconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `JiraImportEdge` {#jiraimportedge}

[`JiraImport`](#jiraimport)のエッジ型。

##### フィールド {#fields-863}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="jiraimportedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="jiraimportedgenode"></a>`node` | [`JiraImport`](#jiraimport) | エッジの終端にあるアイテム。 |

#### `JiraProjectConnection` {#jiraprojectconnection}

[`JiraProject`](#jiraproject)の接続タイプ。

##### フィールド {#fields-864}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="jiraprojectconnectionedges"></a>`edges` | [`[JiraProjectEdge]`](#jiraprojectedge) | エッジのリスト。 |
| <a id="jiraprojectconnectionnodes"></a>`nodes` | [`[JiraProject]`](#jiraproject) | ノードのリスト。 |
| <a id="jiraprojectconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `JiraProjectEdge` {#jiraprojectedge}

[`JiraProject`](#jiraproject)のエッジ型。

##### フィールド {#fields-865}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="jiraprojectedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="jiraprojectedgenode"></a>`node` | [`JiraProject`](#jiraproject) | エッジの終端にあるアイテム。 |

#### `JobArtifactRegistryConnection` {#jobartifactregistryconnection}

[`JobArtifactRegistry`](#jobartifactregistry)の接続タイプ。

##### フィールド {#fields-866}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="jobartifactregistryconnectionedges"></a>`edges` | [`[JobArtifactRegistryEdge]`](#jobartifactregistryedge) | エッジのリスト。 |
| <a id="jobartifactregistryconnectionnodes"></a>`nodes` | [`[JobArtifactRegistry]`](#jobartifactregistry) | ノードのリスト。 |
| <a id="jobartifactregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

##### 引数のあるフィールド {#fields-with-arguments-8}

###### `JobArtifactRegistryConnection.count` {#jobartifactregistryconnectioncount}

コレクションの制限カウント。制限を超えるカウントの場合、制限+1を返します。

[`Int!`](#int)を返します。

\#######引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="jobartifactregistryconnectioncountlimit"></a>`limit` | [`Int`](#int) | カウントクエリに適用される制限値。デフォルトは1000です。 |

#### `JobArtifactRegistryEdge` {#jobartifactregistryedge}

[`JobArtifactRegistry`](#jobartifactregistry)のエッジ型。

##### フィールド {#fields-867}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="jobartifactregistryedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="jobartifactregistryedgenode"></a>`node` | [`JobArtifactRegistry`](#jobartifactregistry) | エッジの終端にあるアイテム。 |

#### `JobNeedUnionConnection` {#jobneedunionconnection}

[`JobNeedUnion`](#jobneedunion)の接続タイプ。

##### フィールド {#fields-868}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="jobneedunionconnectionedges"></a>`edges` | [`[JobNeedUnionEdge]`](#jobneedunionedge) | エッジのリスト。 |
| <a id="jobneedunionconnectionnodes"></a>`nodes` | [`[JobNeedUnion]`](#jobneedunion) | ノードのリスト。 |
| <a id="jobneedunionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `JobNeedUnionEdge` {#jobneedunionedge}

[`JobNeedUnion`](#jobneedunion)のエッジ型。

##### フィールド {#fields-869}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="jobneedunionedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="jobneedunionedgenode"></a>`node` | [`JobNeedUnion`](#jobneedunion) | エッジの終端にあるアイテム。 |

#### `LabelConnection` {#labelconnection}

[`Label`](#label)の接続タイプ。

##### フィールド {#fields-870}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="labelconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="labelconnectionedges"></a>`edges` | [`[LabelEdge]`](#labeledge) | エッジのリスト。 |
| <a id="labelconnectionnodes"></a>`nodes` | [`[Label]`](#label) | ノードのリスト。 |
| <a id="labelconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `LabelEdge` {#labeledge}

[`Label`](#label)のエッジ型。

##### フィールド {#fields-871}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="labeledgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="labeledgenode"></a>`node` | [`Label`](#label) | エッジの終端にあるアイテム。 |

#### `LdapAdminRoleLinkConnection` {#ldapadminrolelinkconnection}

[`LdapAdminRoleLink`](#ldapadminrolelink)の接続タイプ。

##### フィールド {#fields-872}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="ldapadminrolelinkconnectionedges"></a>`edges` | [`[LdapAdminRoleLinkEdge]`](#ldapadminrolelinkedge) | エッジのリスト。 |
| <a id="ldapadminrolelinkconnectionnodes"></a>`nodes` | [`[LdapAdminRoleLink]`](#ldapadminrolelink) | ノードのリスト。 |
| <a id="ldapadminrolelinkconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `LdapAdminRoleLinkEdge` {#ldapadminrolelinkedge}

[`LdapAdminRoleLink`](#ldapadminrolelink)のエッジ型。

##### フィールド {#fields-873}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="ldapadminrolelinkedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="ldapadminrolelinkedgenode"></a>`node` | [`LdapAdminRoleLink`](#ldapadminrolelink) | エッジの終端にあるアイテム。 |

#### `LfsObjectRegistryConnection` {#lfsobjectregistryconnection}

[`LfsObjectRegistry`](#lfsobjectregistry)の接続タイプ。

##### フィールド {#fields-874}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="lfsobjectregistryconnectionedges"></a>`edges` | [`[LfsObjectRegistryEdge]`](#lfsobjectregistryedge) | エッジのリスト。 |
| <a id="lfsobjectregistryconnectionnodes"></a>`nodes` | [`[LfsObjectRegistry]`](#lfsobjectregistry) | ノードのリスト。 |
| <a id="lfsobjectregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

##### 引数のあるフィールド {#fields-with-arguments-9}

###### `LfsObjectRegistryConnection.count` {#lfsobjectregistryconnectioncount}

コレクションの制限カウント。制限を超えるカウントの場合、制限+1を返します。

[`Int!`](#int)を返します。

\#######引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="lfsobjectregistryconnectioncountlimit"></a>`limit` | [`Int`](#int) | カウントクエリに適用される制限値。デフォルトは1000です。 |

#### `LfsObjectRegistryEdge` {#lfsobjectregistryedge}

[`LfsObjectRegistry`](#lfsobjectregistry)のエッジ型。

##### フィールド {#fields-875}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="lfsobjectregistryedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="lfsobjectregistryedgenode"></a>`node` | [`LfsObjectRegistry`](#lfsobjectregistry) | エッジの終端にあるアイテム。 |

#### `LicenseHistoryEntryConnection` {#licensehistoryentryconnection}

[`LicenseHistoryEntry`](#licensehistoryentry)の接続タイプ。

##### フィールド {#fields-876}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="licensehistoryentryconnectionedges"></a>`edges` | [`[LicenseHistoryEntryEdge]`](#licensehistoryentryedge) | エッジのリスト。 |
| <a id="licensehistoryentryconnectionnodes"></a>`nodes` | [`[LicenseHistoryEntry]`](#licensehistoryentry) | ノードのリスト。 |
| <a id="licensehistoryentryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `LicenseHistoryEntryEdge` {#licensehistoryentryedge}

[`LicenseHistoryEntry`](#licensehistoryentry)のエッジ型。

##### フィールド {#fields-877}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="licensehistoryentryedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="licensehistoryentryedgenode"></a>`node` | [`LicenseHistoryEntry`](#licensehistoryentry) | エッジの終端にあるアイテム。 |

#### `LinkedWorkItemTypeConnection` {#linkedworkitemtypeconnection}

[`LinkedWorkItemType`](#linkedworkitemtype)の接続タイプ。

##### フィールド {#fields-878}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="linkedworkitemtypeconnectionedges"></a>`edges` | [`[LinkedWorkItemTypeEdge]`](#linkedworkitemtypeedge) | エッジのリスト。 |
| <a id="linkedworkitemtypeconnectionnodes"></a>`nodes` | [`[LinkedWorkItemType]`](#linkedworkitemtype) | ノードのリスト。 |
| <a id="linkedworkitemtypeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `LinkedWorkItemTypeEdge` {#linkedworkitemtypeedge}

[`LinkedWorkItemType`](#linkedworkitemtype)のエッジ型。

##### フィールド {#fields-879}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="linkedworkitemtypeedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="linkedworkitemtypeedgenode"></a>`node` | [`LinkedWorkItemType`](#linkedworkitemtype) | エッジの終端にあるアイテム。 |

#### `MavenVirtualRegistryConnection` {#mavenvirtualregistryconnection}

[`MavenVirtualRegistry`](#mavenvirtualregistry)の接続タイプ。

##### フィールド {#fields-880}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mavenvirtualregistryconnectionedges"></a>`edges` | [`[MavenVirtualRegistryEdge]`](#mavenvirtualregistryedge) | エッジのリスト。 |
| <a id="mavenvirtualregistryconnectionnodes"></a>`nodes` | [`[MavenVirtualRegistry]`](#mavenvirtualregistry) | ノードのリスト。 |
| <a id="mavenvirtualregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `MavenVirtualRegistryEdge` {#mavenvirtualregistryedge}

[`MavenVirtualRegistry`](#mavenvirtualregistry)のエッジ型。

##### フィールド {#fields-881}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mavenvirtualregistryedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="mavenvirtualregistryedgenode"></a>`node` | [`MavenVirtualRegistry`](#mavenvirtualregistry) | エッジの終端にあるアイテム。 |

#### `MemberApprovalConnection` {#memberapprovalconnection}

[`MemberApproval`](#memberapproval)の接続タイプ。

##### フィールド {#fields-882}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="memberapprovalconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="memberapprovalconnectionedges"></a>`edges` | [`[MemberApprovalEdge]`](#memberapprovaledge) | エッジのリスト。 |
| <a id="memberapprovalconnectionnodes"></a>`nodes` | [`[MemberApproval]`](#memberapproval) | ノードのリスト。 |
| <a id="memberapprovalconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `MemberApprovalEdge` {#memberapprovaledge}

[`MemberApproval`](#memberapproval)のエッジ型。

##### フィールド {#fields-883}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="memberapprovaledgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="memberapprovaledgenode"></a>`node` | [`MemberApproval`](#memberapproval) | エッジの終端にあるアイテム。 |

#### `MemberInterfaceConnection` {#memberinterfaceconnection}

[`MemberInterface`](#memberinterface)の接続タイプ。

##### フィールド {#fields-884}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="memberinterfaceconnectionedges"></a>`edges` | [`[MemberInterfaceEdge]`](#memberinterfaceedge) | エッジのリスト。 |
| <a id="memberinterfaceconnectionnodes"></a>`nodes` | [`[MemberInterface]`](#memberinterface) | ノードのリスト。 |
| <a id="memberinterfaceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `MemberInterfaceEdge` {#memberinterfaceedge}

[`MemberInterface`](#memberinterface)のエッジ型。

##### フィールド {#fields-885}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="memberinterfaceedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="memberinterfaceedgenode"></a>`node` | [`MemberInterface`](#memberinterface) | エッジの終端にあるアイテム。 |

#### `MemberRoleConnection` {#memberroleconnection}

[`MemberRole`](#memberrole)の接続タイプ。

##### フィールド {#fields-886}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="memberroleconnectionedges"></a>`edges` | [`[MemberRoleEdge]`](#memberroleedge) | エッジのリスト。 |
| <a id="memberroleconnectionnodes"></a>`nodes` | [`[MemberRole]`](#memberrole) | ノードのリスト。 |
| <a id="memberroleconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `MemberRoleEdge` {#memberroleedge}

[`MemberRole`](#memberrole)のエッジ型。

##### フィールド {#fields-887}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="memberroleedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="memberroleedgenode"></a>`node` | [`MemberRole`](#memberrole) | エッジの終端にあるアイテム。 |

#### `MergeAccessLevelConnection` {#mergeaccesslevelconnection}

[`MergeAccessLevel`](#mergeaccesslevel)の接続タイプ。

##### フィールド {#fields-888}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mergeaccesslevelconnectionedges"></a>`edges` | [`[MergeAccessLevelEdge]`](#mergeaccessleveledge) | エッジのリスト。 |
| <a id="mergeaccesslevelconnectionnodes"></a>`nodes` | [`[MergeAccessLevel]`](#mergeaccesslevel) | ノードのリスト。 |
| <a id="mergeaccesslevelconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `MergeAccessLevelEdge` {#mergeaccessleveledge}

[`MergeAccessLevel`](#mergeaccesslevel)のエッジ型。

##### フィールド {#fields-889}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mergeaccessleveledgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="mergeaccessleveledgenode"></a>`node` | [`MergeAccessLevel`](#mergeaccesslevel) | エッジの終端にあるアイテム。 |

#### `MergeRequestAssigneeConnection` {#mergerequestassigneeconnection}

[`MergeRequestAssignee`](#mergerequestassignee)の接続タイプ。

##### フィールド {#fields-890}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mergerequestassigneeconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="mergerequestassigneeconnectionedges"></a>`edges` | [`[MergeRequestAssigneeEdge]`](#mergerequestassigneeedge) | エッジのリスト。 |
| <a id="mergerequestassigneeconnectionnodes"></a>`nodes` | [`[MergeRequestAssignee]`](#mergerequestassignee) | ノードのリスト。 |
| <a id="mergerequestassigneeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `MergeRequestAssigneeEdge` {#mergerequestassigneeedge}

[`MergeRequestAssignee`](#mergerequestassignee)のエッジ型。

##### フィールド {#fields-891}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mergerequestassigneeedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="mergerequestassigneeedgenode"></a>`node` | [`MergeRequestAssignee`](#mergerequestassignee) | エッジの終端にあるアイテム。 |

#### `MergeRequestConnection` {#mergerequestconnection}

[`MergeRequest`](#mergerequest)の接続タイプ。

##### フィールド {#fields-892}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mergerequestconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="mergerequestconnectionedges"></a>`edges` | [`[MergeRequestEdge]`](#mergerequestedge) | エッジのリスト。 |
| <a id="mergerequestconnectionnodes"></a>`nodes` | [`[MergeRequest]`](#mergerequest) | ノードのリスト。 |
| <a id="mergerequestconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |
| <a id="mergerequestconnectiontotaltimetomerge"></a>`totalTimeToMerge` | [`Float`](#float) | マージリクエストのコレクションについて、マージにかかる時間の合計（秒単位）。 |

#### `MergeRequestDiffConnection` {#mergerequestdiffconnection}

[`MergeRequestDiff`](#mergerequestdiff)の接続タイプ。

##### フィールド {#fields-893}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mergerequestdiffconnectionedges"></a>`edges` | [`[MergeRequestDiffEdge]`](#mergerequestdiffedge) | エッジのリスト。 |
| <a id="mergerequestdiffconnectionnodes"></a>`nodes` | [`[MergeRequestDiff]`](#mergerequestdiff) | ノードのリスト。 |
| <a id="mergerequestdiffconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `MergeRequestDiffEdge` {#mergerequestdiffedge}

[`MergeRequestDiff`](#mergerequestdiff)のエッジ型。

##### フィールド {#fields-894}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mergerequestdiffedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="mergerequestdiffedgenode"></a>`node` | [`MergeRequestDiff`](#mergerequestdiff) | エッジの終端にあるアイテム。 |

#### `MergeRequestDiffRegistryConnection` {#mergerequestdiffregistryconnection}

[`MergeRequestDiffRegistry`](#mergerequestdiffregistry)の接続タイプ。

##### フィールド {#fields-895}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mergerequestdiffregistryconnectionedges"></a>`edges` | [`[MergeRequestDiffRegistryEdge]`](#mergerequestdiffregistryedge) | エッジのリスト。 |
| <a id="mergerequestdiffregistryconnectionnodes"></a>`nodes` | [`[MergeRequestDiffRegistry]`](#mergerequestdiffregistry) | ノードのリスト。 |
| <a id="mergerequestdiffregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

##### 引数のあるフィールド {#fields-with-arguments-10}

###### `MergeRequestDiffRegistryConnection.count` {#mergerequestdiffregistryconnectioncount}

コレクションの制限カウント。制限を超えるカウントの場合、制限+1を返します。

[`Int!`](#int)を返します。

\#######引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mergerequestdiffregistryconnectioncountlimit"></a>`limit` | [`Int`](#int) | カウントクエリに適用される制限値。デフォルトは1000です。 |

#### `MergeRequestDiffRegistryEdge` {#mergerequestdiffregistryedge}

[`MergeRequestDiffRegistry`](#mergerequestdiffregistry)のエッジ型。

##### フィールド {#fields-896}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mergerequestdiffregistryedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="mergerequestdiffregistryedgenode"></a>`node` | [`MergeRequestDiffRegistry`](#mergerequestdiffregistry) | エッジの終端にあるアイテム。 |

#### `MergeRequestEdge` {#mergerequestedge}

[`MergeRequest`](#mergerequest)のエッジ型。

##### フィールド {#fields-897}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mergerequestedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="mergerequestedgenode"></a>`node` | [`MergeRequest`](#mergerequest) | エッジの終端にあるアイテム。 |

#### `MergeRequestParticipantConnection` {#mergerequestparticipantconnection}

[`MergeRequestParticipant`](#mergerequestparticipant)の接続タイプ。

##### フィールド {#fields-898}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mergerequestparticipantconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="mergerequestparticipantconnectionedges"></a>`edges` | [`[MergeRequestParticipantEdge]`](#mergerequestparticipantedge) | エッジのリスト。 |
| <a id="mergerequestparticipantconnectionnodes"></a>`nodes` | [`[MergeRequestParticipant]`](#mergerequestparticipant) | ノードのリスト。 |
| <a id="mergerequestparticipantconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `MergeRequestParticipantEdge` {#mergerequestparticipantedge}

[`MergeRequestParticipant`](#mergerequestparticipant)のエッジ型。

##### フィールド {#fields-899}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mergerequestparticipantedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="mergerequestparticipantedgenode"></a>`node` | [`MergeRequestParticipant`](#mergerequestparticipant) | エッジの終端にあるアイテム。 |

#### `MergeRequestReviewerConnection` {#mergerequestreviewerconnection}

[`MergeRequestReviewer`](#mergerequestreviewer)の接続タイプ。

##### フィールド {#fields-900}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mergerequestreviewerconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="mergerequestreviewerconnectionedges"></a>`edges` | [`[MergeRequestReviewerEdge]`](#mergerequestrevieweredge) | エッジのリスト。 |
| <a id="mergerequestreviewerconnectionnodes"></a>`nodes` | [`[MergeRequestReviewer]`](#mergerequestreviewer) | ノードのリスト。 |
| <a id="mergerequestreviewerconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `MergeRequestReviewerEdge` {#mergerequestrevieweredge}

[`MergeRequestReviewer`](#mergerequestreviewer)のエッジ型。

##### フィールド {#fields-901}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mergerequestrevieweredgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="mergerequestrevieweredgenode"></a>`node` | [`MergeRequestReviewer`](#mergerequestreviewer) | エッジの終端にあるアイテム。 |

#### `MergeTrainCarConnection` {#mergetraincarconnection}

[`MergeTrainCar`](#mergetraincar)の接続タイプ。

##### フィールド {#fields-902}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mergetraincarconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="mergetraincarconnectionedges"></a>`edges` | [`[MergeTrainCarEdge]`](#mergetraincaredge) | エッジのリスト。 |
| <a id="mergetraincarconnectionnodes"></a>`nodes` | [`[MergeTrainCar]`](#mergetraincar) | ノードのリスト。 |
| <a id="mergetraincarconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `MergeTrainCarEdge` {#mergetraincaredge}

[`MergeTrainCar`](#mergetraincar)のエッジ型。

##### フィールド {#fields-903}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mergetraincaredgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="mergetraincaredgenode"></a>`node` | [`MergeTrainCar`](#mergetraincar) | エッジの終端にあるアイテム。 |

#### `MergeTrainConnection` {#mergetrainconnection}

[`MergeTrain`](#mergetrain)の接続タイプ。

##### フィールド {#fields-904}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mergetrainconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="mergetrainconnectionedges"></a>`edges` | [`[MergeTrainEdge]`](#mergetrainedge) | エッジのリスト。 |
| <a id="mergetrainconnectionnodes"></a>`nodes` | [`[MergeTrain]`](#mergetrain) | ノードのリスト。 |
| <a id="mergetrainconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `MergeTrainEdge` {#mergetrainedge}

[`MergeTrain`](#mergetrain)のエッジ型。

##### フィールド {#fields-905}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mergetrainedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="mergetrainedgenode"></a>`node` | [`MergeTrain`](#mergetrain) | エッジの終端にあるアイテム。 |

#### `MilestoneConnection` {#milestoneconnection}

[`Milestone`](#milestone)の接続タイプ。

##### フィールド {#fields-906}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="milestoneconnectionedges"></a>`edges` | [`[MilestoneEdge]`](#milestoneedge) | エッジのリスト。 |
| <a id="milestoneconnectionnodes"></a>`nodes` | [`[Milestone]`](#milestone) | ノードのリスト。 |
| <a id="milestoneconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `MilestoneEdge` {#milestoneedge}

[`Milestone`](#milestone)のエッジ型。

##### フィールド {#fields-907}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="milestoneedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="milestoneedgenode"></a>`node` | [`Milestone`](#milestone) | エッジの終端にあるアイテム。 |

#### `MlCandidateConnection` {#mlcandidateconnection}

[`MlCandidate`](#mlcandidate)の接続タイプ。

##### フィールド {#fields-908}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mlcandidateconnectionedges"></a>`edges` | [`[MlCandidateEdge]`](#mlcandidateedge) | エッジのリスト。 |
| <a id="mlcandidateconnectionnodes"></a>`nodes` | [`[MlCandidate]`](#mlcandidate) | ノードのリスト。 |
| <a id="mlcandidateconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

##### 引数のあるフィールド {#fields-with-arguments-11}

###### `MlCandidateConnection.count` {#mlcandidateconnectioncount}

コレクションの制限カウント。制限を超えるカウントの場合、制限+1を返します。

[`Int!`](#int)を返します。

\#######引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mlcandidateconnectioncountlimit"></a>`limit` | [`Int`](#int) | カウントクエリに適用される制限値。デフォルトは1000です。 |

#### `MlCandidateEdge` {#mlcandidateedge}

[`MlCandidate`](#mlcandidate)のエッジ型。

##### フィールド {#fields-909}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mlcandidateedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="mlcandidateedgenode"></a>`node` | [`MlCandidate`](#mlcandidate) | エッジの終端にあるアイテム。 |

#### `MlCandidateMetadataConnection` {#mlcandidatemetadataconnection}

[`MlCandidateMetadata`](#mlcandidatemetadata)の接続タイプ。

##### フィールド {#fields-910}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mlcandidatemetadataconnectionedges"></a>`edges` | [`[MlCandidateMetadataEdge]`](#mlcandidatemetadataedge) | エッジのリスト。 |
| <a id="mlcandidatemetadataconnectionnodes"></a>`nodes` | [`[MlCandidateMetadata]`](#mlcandidatemetadata) | ノードのリスト。 |
| <a id="mlcandidatemetadataconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

##### 引数のあるフィールド {#fields-with-arguments-12}

###### `MlCandidateMetadataConnection.count` {#mlcandidatemetadataconnectioncount}

コレクションの制限カウント。制限を超えるカウントの場合、制限+1を返します。

[`Int!`](#int)を返します。

\#######引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mlcandidatemetadataconnectioncountlimit"></a>`limit` | [`Int`](#int) | カウントクエリに適用される制限値。デフォルトは1000です。 |

#### `MlCandidateMetadataEdge` {#mlcandidatemetadataedge}

[`MlCandidateMetadata`](#mlcandidatemetadata)のエッジ型。

##### フィールド {#fields-911}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mlcandidatemetadataedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="mlcandidatemetadataedgenode"></a>`node` | [`MlCandidateMetadata`](#mlcandidatemetadata) | エッジの終端にあるアイテム。 |

#### `MlCandidateMetricConnection` {#mlcandidatemetricconnection}

[`MlCandidateMetric`](#mlcandidatemetric)の接続タイプ。

##### フィールド {#fields-912}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mlcandidatemetricconnectionedges"></a>`edges` | [`[MlCandidateMetricEdge]`](#mlcandidatemetricedge) | エッジのリスト。 |
| <a id="mlcandidatemetricconnectionnodes"></a>`nodes` | [`[MlCandidateMetric]`](#mlcandidatemetric) | ノードのリスト。 |
| <a id="mlcandidatemetricconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

##### 引数のあるフィールド {#fields-with-arguments-13}

###### `MlCandidateMetricConnection.count` {#mlcandidatemetricconnectioncount}

コレクションの制限カウント。制限を超えるカウントの場合、制限+1を返します。

[`Int!`](#int)を返します。

\#######引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mlcandidatemetricconnectioncountlimit"></a>`limit` | [`Int`](#int) | カウントクエリに適用される制限値。デフォルトは1000です。 |

#### `MlCandidateMetricEdge` {#mlcandidatemetricedge}

[`MlCandidateMetric`](#mlcandidatemetric)のエッジ型。

##### フィールド {#fields-913}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mlcandidatemetricedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="mlcandidatemetricedgenode"></a>`node` | [`MlCandidateMetric`](#mlcandidatemetric) | エッジの終端にあるアイテム。 |

#### `MlCandidateParamConnection` {#mlcandidateparamconnection}

[`MlCandidateParam`](#mlcandidateparam)の接続タイプ。

##### フィールド {#fields-914}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mlcandidateparamconnectionedges"></a>`edges` | [`[MlCandidateParamEdge]`](#mlcandidateparamedge) | エッジのリスト。 |
| <a id="mlcandidateparamconnectionnodes"></a>`nodes` | [`[MlCandidateParam]`](#mlcandidateparam) | ノードのリスト。 |
| <a id="mlcandidateparamconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

##### 引数のあるフィールド {#fields-with-arguments-14}

###### `MlCandidateParamConnection.count` {#mlcandidateparamconnectioncount}

コレクションの制限カウント。制限を超えるカウントの場合、制限+1を返します。

[`Int!`](#int)を返します。

\#######引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mlcandidateparamconnectioncountlimit"></a>`limit` | [`Int`](#int) | カウントクエリに適用される制限値。デフォルトは1000です。 |

#### `MlCandidateParamEdge` {#mlcandidateparamedge}

[`MlCandidateParam`](#mlcandidateparam)のエッジ型。

##### フィールド {#fields-915}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mlcandidateparamedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="mlcandidateparamedgenode"></a>`node` | [`MlCandidateParam`](#mlcandidateparam) | エッジの終端にあるアイテム。 |

#### `MlExperimentConnection` {#mlexperimentconnection}

[`MlExperiment`](#mlexperiment)の接続タイプ。

##### フィールド {#fields-916}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mlexperimentconnectionedges"></a>`edges` | [`[MlExperimentEdge]`](#mlexperimentedge) | エッジのリスト。 |
| <a id="mlexperimentconnectionnodes"></a>`nodes` | [`[MlExperiment]`](#mlexperiment) | ノードのリスト。 |
| <a id="mlexperimentconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

##### 引数のあるフィールド {#fields-with-arguments-15}

###### `MlExperimentConnection.count` {#mlexperimentconnectioncount}

コレクションの制限カウント。制限を超えるカウントの場合、制限+1を返します。

[`Int!`](#int)を返します。

\#######引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mlexperimentconnectioncountlimit"></a>`limit` | [`Int`](#int) | カウントクエリに適用される制限値。デフォルトは1000です。 |

#### `MlExperimentEdge` {#mlexperimentedge}

[`MlExperiment`](#mlexperiment)のエッジ型。

##### フィールド {#fields-917}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mlexperimentedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="mlexperimentedgenode"></a>`node` | [`MlExperiment`](#mlexperiment) | エッジの終端にあるアイテム。 |

#### `MlModelConnection` {#mlmodelconnection}

[`MlModel`](#mlmodel)の接続タイプ。

##### フィールド {#fields-918}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mlmodelconnectionedges"></a>`edges` | [`[MlModelEdge]`](#mlmodeledge) | エッジのリスト。 |
| <a id="mlmodelconnectionnodes"></a>`nodes` | [`[MlModel]`](#mlmodel) | ノードのリスト。 |
| <a id="mlmodelconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

##### 引数のあるフィールド {#fields-with-arguments-16}

###### `MlModelConnection.count` {#mlmodelconnectioncount}

コレクションの制限カウント。制限を超えるカウントの場合、制限+1を返します。

[`Int!`](#int)を返します。

\#######引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mlmodelconnectioncountlimit"></a>`limit` | [`Int`](#int) | カウントクエリに適用される制限値。デフォルトは1000です。 |

#### `MlModelEdge` {#mlmodeledge}

[`MlModel`](#mlmodel)のエッジ型。

##### フィールド {#fields-919}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mlmodeledgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="mlmodeledgenode"></a>`node` | [`MlModel`](#mlmodel) | エッジの終端にあるアイテム。 |

#### `MlModelVersionConnection` {#mlmodelversionconnection}

[`MlModelVersion`](#mlmodelversion)の接続タイプ。

##### フィールド {#fields-920}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mlmodelversionconnectionedges"></a>`edges` | [`[MlModelVersionEdge]`](#mlmodelversionedge) | エッジのリスト。 |
| <a id="mlmodelversionconnectionnodes"></a>`nodes` | [`[MlModelVersion]`](#mlmodelversion) | ノードのリスト。 |
| <a id="mlmodelversionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

##### 引数のあるフィールド {#fields-with-arguments-17}

###### `MlModelVersionConnection.count` {#mlmodelversionconnectioncount}

コレクションの制限カウント。制限を超えるカウントの場合、制限+1を返します。

[`Int!`](#int)を返します。

\#######引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mlmodelversionconnectioncountlimit"></a>`limit` | [`Int`](#int) | カウントクエリに適用される制限値。デフォルトは1000です。 |

#### `MlModelVersionEdge` {#mlmodelversionedge}

[`MlModelVersion`](#mlmodelversion)のエッジ型。

##### フィールド {#fields-921}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="mlmodelversionedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="mlmodelversionedgenode"></a>`node` | [`MlModelVersion`](#mlmodelversion) | エッジの終端にあるアイテム。 |

#### `NamespaceCommitEmailConnection` {#namespacecommitemailconnection}

[`NamespaceCommitEmail`](#namespacecommitemail)の接続タイプ。

##### フィールド {#fields-922}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="namespacecommitemailconnectionedges"></a>`edges` | [`[NamespaceCommitEmailEdge]`](#namespacecommitemailedge) | エッジのリスト。 |
| <a id="namespacecommitemailconnectionnodes"></a>`nodes` | [`[NamespaceCommitEmail]`](#namespacecommitemail) | ノードのリスト。 |
| <a id="namespacecommitemailconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `NamespaceCommitEmailEdge` {#namespacecommitemailedge}

[`NamespaceCommitEmail`](#namespacecommitemail)のエッジ型。

##### フィールド {#fields-923}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="namespacecommitemailedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="namespacecommitemailedgenode"></a>`node` | [`NamespaceCommitEmail`](#namespacecommitemail) | エッジの終端にあるアイテム。 |

#### `NamespaceConnection` {#namespaceconnection}

[`Namespace`](#namespace)の接続タイプ。

##### フィールド {#fields-924}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="namespaceconnectionedges"></a>`edges` | [`[NamespaceEdge]`](#namespaceedge) | エッジのリスト。 |
| <a id="namespaceconnectionnodes"></a>`nodes` | [`[Namespace]`](#namespace) | ノードのリスト。 |
| <a id="namespaceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `NamespaceEdge` {#namespaceedge}

[`Namespace`](#namespace)のエッジ型。

##### フィールド {#fields-925}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="namespaceedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="namespaceedgenode"></a>`node` | [`Namespace`](#namespace) | エッジの終端にあるアイテム。 |

#### `NestedEnvironmentConnection` {#nestedenvironmentconnection}

[`NestedEnvironment`](#nestedenvironment)の接続タイプ。

##### フィールド {#fields-926}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="nestedenvironmentconnectionedges"></a>`edges` | [`[NestedEnvironmentEdge]`](#nestedenvironmentedge) | エッジのリスト。 |
| <a id="nestedenvironmentconnectionnodes"></a>`nodes` | [`[NestedEnvironment]`](#nestedenvironment) | ノードのリスト。 |
| <a id="nestedenvironmentconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `NestedEnvironmentEdge` {#nestedenvironmentedge}

[`NestedEnvironment`](#nestedenvironment)のエッジ型。

##### フィールド {#fields-927}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="nestedenvironmentedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="nestedenvironmentedgenode"></a>`node` | [`NestedEnvironment`](#nestedenvironment) | エッジの終端にあるアイテム。 |

#### `NoteConnection` {#noteconnection}

[`Note`](#note)の接続タイプ。

##### フィールド {#fields-928}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="noteconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="noteconnectionedges"></a>`edges` | [`[NoteEdge]`](#noteedge) | エッジのリスト。 |
| <a id="noteconnectionnodes"></a>`nodes` | [`[Note]`](#note) | ノードのリスト。 |
| <a id="noteconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `NoteEdge` {#noteedge}

[`Note`](#note)のエッジ型。

##### フィールド {#fields-929}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="noteedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="noteedgenode"></a>`node` | [`Note`](#note) | エッジの終端にあるアイテム。 |

#### `ObservabilityLogConnection` {#observabilitylogconnection}

[`ObservabilityLog`](#observabilitylog)の接続タイプ。

##### フィールド {#fields-930}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="observabilitylogconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="observabilitylogconnectionedges"></a>`edges` | [`[ObservabilityLogEdge]`](#observabilitylogedge) | エッジのリスト。 |
| <a id="observabilitylogconnectionnodes"></a>`nodes` | [`[ObservabilityLog]`](#observabilitylog) | ノードのリスト。 |
| <a id="observabilitylogconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ObservabilityLogEdge` {#observabilitylogedge}

[`ObservabilityLog`](#observabilitylog)のエッジ型。

##### フィールド {#fields-931}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="observabilitylogedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="observabilitylogedgenode"></a>`node` | [`ObservabilityLog`](#observabilitylog) | エッジの終端にあるアイテム。 |

#### `ObservabilityMetricConnection` {#observabilitymetricconnection}

[`ObservabilityMetric`](#observabilitymetric)の接続タイプ。

##### フィールド {#fields-932}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="observabilitymetricconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="observabilitymetricconnectionedges"></a>`edges` | [`[ObservabilityMetricEdge]`](#observabilitymetricedge) | エッジのリスト。 |
| <a id="observabilitymetricconnectionnodes"></a>`nodes` | [`[ObservabilityMetric]`](#observabilitymetric) | ノードのリスト。 |
| <a id="observabilitymetricconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ObservabilityMetricEdge` {#observabilitymetricedge}

[`ObservabilityMetric`](#observabilitymetric)のエッジ型。

##### フィールド {#fields-933}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="observabilitymetricedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="observabilitymetricedgenode"></a>`node` | [`ObservabilityMetric`](#observabilitymetric) | エッジの終端にあるアイテム。 |

#### `ObservabilityTraceConnection` {#observabilitytraceconnection}

[`ObservabilityTrace`](#observabilitytrace)の接続タイプ。

##### フィールド {#fields-934}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="observabilitytraceconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="observabilitytraceconnectionedges"></a>`edges` | [`[ObservabilityTraceEdge]`](#observabilitytraceedge) | エッジのリスト。 |
| <a id="observabilitytraceconnectionnodes"></a>`nodes` | [`[ObservabilityTrace]`](#observabilitytrace) | ノードのリスト。 |
| <a id="observabilitytraceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ObservabilityTraceEdge` {#observabilitytraceedge}

[`ObservabilityTrace`](#observabilitytrace)のエッジ型。

##### フィールド {#fields-935}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="observabilitytraceedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="observabilitytraceedgenode"></a>`node` | [`ObservabilityTrace`](#observabilitytrace) | エッジの終端にあるアイテム。 |

#### `OncallParticipantTypeConnection` {#oncallparticipanttypeconnection}

[`OncallParticipantType`](#oncallparticipanttype)の接続タイプ。

##### フィールド {#fields-936}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="oncallparticipanttypeconnectionedges"></a>`edges` | [`[OncallParticipantTypeEdge]`](#oncallparticipanttypeedge) | エッジのリスト。 |
| <a id="oncallparticipanttypeconnectionnodes"></a>`nodes` | [`[OncallParticipantType]`](#oncallparticipanttype) | ノードのリスト。 |
| <a id="oncallparticipanttypeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `OncallParticipantTypeEdge` {#oncallparticipanttypeedge}

[`OncallParticipantType`](#oncallparticipanttype)のエッジ型。

##### フィールド {#fields-937}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="oncallparticipanttypeedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="oncallparticipanttypeedgenode"></a>`node` | [`OncallParticipantType`](#oncallparticipanttype) | エッジの終端にあるアイテム。 |

#### `OrganizationConnection` {#organizationconnection}

[`Organization`](#organization)の接続タイプ。

##### フィールド {#fields-938}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="organizationconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="organizationconnectionedges"></a>`edges` | [`[OrganizationEdge]`](#organizationedge) | エッジのリスト。 |
| <a id="organizationconnectionnodes"></a>`nodes` | [`[Organization]`](#organization) | ノードのリスト。 |
| <a id="organizationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `OrganizationEdge` {#organizationedge}

[`Organization`](#organization)のエッジ型。

##### フィールド {#fields-939}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="organizationedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="organizationedgenode"></a>`node` | [`Organization`](#organization) | エッジの終端にあるアイテム。 |

#### `OrganizationUserConnection` {#organizationuserconnection}

[`OrganizationUser`](#organizationuser)の接続タイプ。

##### フィールド {#fields-940}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="organizationuserconnectionedges"></a>`edges` | [`[OrganizationUserEdge]`](#organizationuseredge) | エッジのリスト。 |
| <a id="organizationuserconnectionnodes"></a>`nodes` | [`[OrganizationUser]`](#organizationuser) | ノードのリスト。 |
| <a id="organizationuserconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `OrganizationUserEdge` {#organizationuseredge}

[`OrganizationUser`](#organizationuser)のエッジ型。

##### フィールド {#fields-941}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="organizationuseredgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="organizationuseredgenode"></a>`node` | [`OrganizationUser`](#organizationuser) | エッジの終端にあるアイテム。 |

#### `PackageBaseConnection` {#packagebaseconnection}

[`PackageBase`](#packagebase)の接続タイプ。

##### フィールド {#fields-942}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="packagebaseconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="packagebaseconnectionedges"></a>`edges` | [`[PackageBaseEdge]`](#packagebaseedge) | エッジのリスト。 |
| <a id="packagebaseconnectionnodes"></a>`nodes` | [`[PackageBase]`](#packagebase) | ノードのリスト。 |
| <a id="packagebaseconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `PackageBaseEdge` {#packagebaseedge}

[`PackageBase`](#packagebase)のエッジ型。

##### フィールド {#fields-943}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="packagebaseedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="packagebaseedgenode"></a>`node` | [`PackageBase`](#packagebase) | エッジの終端にあるアイテム。 |

#### `PackageConnection` {#packageconnection}

[`Package`](#package)の接続タイプ。

##### フィールド {#fields-944}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="packageconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="packageconnectionedges"></a>`edges` | [`[PackageEdge]`](#packageedge) | エッジのリスト。 |
| <a id="packageconnectionnodes"></a>`nodes` | [`[Package]`](#package) | ノードのリスト。 |
| <a id="packageconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `PackageDependencyLinkConnection` {#packagedependencylinkconnection}

[`PackageDependencyLink`](#packagedependencylink)の接続タイプ。

##### フィールド {#fields-945}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="packagedependencylinkconnectionedges"></a>`edges` | [`[PackageDependencyLinkEdge]`](#packagedependencylinkedge) | エッジのリスト。 |
| <a id="packagedependencylinkconnectionnodes"></a>`nodes` | [`[PackageDependencyLink]`](#packagedependencylink) | ノードのリスト。 |
| <a id="packagedependencylinkconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `PackageDependencyLinkEdge` {#packagedependencylinkedge}

[`PackageDependencyLink`](#packagedependencylink)のエッジ型。

##### フィールド {#fields-946}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="packagedependencylinkedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="packagedependencylinkedgenode"></a>`node` | [`PackageDependencyLink`](#packagedependencylink) | エッジの終端にあるアイテム。 |

#### `PackageEdge` {#packageedge}

[`Package`](#package)のエッジ型。

##### フィールド {#fields-947}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="packageedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="packageedgenode"></a>`node` | [`Package`](#package) | エッジの終端にあるアイテム。 |

#### `PackageFileConnection` {#packagefileconnection}

[`PackageFile`](#packagefile)の接続タイプ。

##### フィールド {#fields-948}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="packagefileconnectionedges"></a>`edges` | [`[PackageFileEdge]`](#packagefileedge) | エッジのリスト。 |
| <a id="packagefileconnectionnodes"></a>`nodes` | [`[PackageFile]`](#packagefile) | ノードのリスト。 |
| <a id="packagefileconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `PackageFileEdge` {#packagefileedge}

[`PackageFile`](#packagefile)のエッジ型。

##### フィールド {#fields-949}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="packagefileedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="packagefileedgenode"></a>`node` | [`PackageFile`](#packagefile) | エッジの終端にあるアイテム。 |

#### `PackageFileRegistryConnection` {#packagefileregistryconnection}

[`PackageFileRegistry`](#packagefileregistry)の接続タイプ。

##### フィールド {#fields-950}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="packagefileregistryconnectionedges"></a>`edges` | [`[PackageFileRegistryEdge]`](#packagefileregistryedge) | エッジのリスト。 |
| <a id="packagefileregistryconnectionnodes"></a>`nodes` | [`[PackageFileRegistry]`](#packagefileregistry) | ノードのリスト。 |
| <a id="packagefileregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

##### 引数のあるフィールド {#fields-with-arguments-18}

###### `PackageFileRegistryConnection.count` {#packagefileregistryconnectioncount}

コレクションの制限カウント。制限を超えるカウントの場合、制限+1を返します。

[`Int!`](#int)を返します。

\#######引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="packagefileregistryconnectioncountlimit"></a>`limit` | [`Int`](#int) | カウントクエリに適用される制限値。デフォルトは1000です。 |

#### `PackageFileRegistryEdge` {#packagefileregistryedge}

[`PackageFileRegistry`](#packagefileregistry)のエッジ型。

##### フィールド {#fields-951}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="packagefileregistryedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="packagefileregistryedgenode"></a>`node` | [`PackageFileRegistry`](#packagefileregistry) | エッジの終端にあるアイテム。 |

#### `PackageTagConnection` {#packagetagconnection}

[`PackageTag`](#packagetag)の接続タイプ。

##### フィールド {#fields-952}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="packagetagconnectionedges"></a>`edges` | [`[PackageTagEdge]`](#packagetagedge) | エッジのリスト。 |
| <a id="packagetagconnectionnodes"></a>`nodes` | [`[PackageTag]`](#packagetag) | ノードのリスト。 |
| <a id="packagetagconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `PackageTagEdge` {#packagetagedge}

[`PackageTag`](#packagetag)のエッジ型。

##### フィールド {#fields-953}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="packagetagedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="packagetagedgenode"></a>`node` | [`PackageTag`](#packagetag) | エッジの終端にあるアイテム。 |

#### `PackagesProtectionRuleConnection` {#packagesprotectionruleconnection}

[`PackagesProtectionRule`](#packagesprotectionrule)の接続タイプ。

##### フィールド {#fields-954}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="packagesprotectionruleconnectionedges"></a>`edges` | [`[PackagesProtectionRuleEdge]`](#packagesprotectionruleedge) | エッジのリスト。 |
| <a id="packagesprotectionruleconnectionnodes"></a>`nodes` | [`[PackagesProtectionRule]`](#packagesprotectionrule) | ノードのリスト。 |
| <a id="packagesprotectionruleconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `PackagesProtectionRuleEdge` {#packagesprotectionruleedge}

[`PackagesProtectionRule`](#packagesprotectionrule)のエッジ型。

##### フィールド {#fields-955}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="packagesprotectionruleedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="packagesprotectionruleedgenode"></a>`node` | [`PackagesProtectionRule`](#packagesprotectionrule) | エッジの終端にあるアイテム。 |

#### `PagesDeploymentConnection` {#pagesdeploymentconnection}

[`PagesDeployment`](#pagesdeployment)の接続タイプ。

##### フィールド {#fields-956}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pagesdeploymentconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="pagesdeploymentconnectionedges"></a>`edges` | [`[PagesDeploymentEdge]`](#pagesdeploymentedge) | エッジのリスト。 |
| <a id="pagesdeploymentconnectionnodes"></a>`nodes` | [`[PagesDeployment]`](#pagesdeployment) | ノードのリスト。 |
| <a id="pagesdeploymentconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `PagesDeploymentEdge` {#pagesdeploymentedge}

[`PagesDeployment`](#pagesdeployment)のエッジ型。

##### フィールド {#fields-957}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pagesdeploymentedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="pagesdeploymentedgenode"></a>`node` | [`PagesDeployment`](#pagesdeployment) | エッジの終端にあるアイテム。 |

#### `PagesDeploymentRegistryConnection` {#pagesdeploymentregistryconnection}

[`PagesDeploymentRegistry`](#pagesdeploymentregistry)の接続タイプ。

##### フィールド {#fields-958}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pagesdeploymentregistryconnectionedges"></a>`edges` | [`[PagesDeploymentRegistryEdge]`](#pagesdeploymentregistryedge) | エッジのリスト。 |
| <a id="pagesdeploymentregistryconnectionnodes"></a>`nodes` | [`[PagesDeploymentRegistry]`](#pagesdeploymentregistry) | ノードのリスト。 |
| <a id="pagesdeploymentregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

##### 引数のあるフィールド {#fields-with-arguments-19}

###### `PagesDeploymentRegistryConnection.count` {#pagesdeploymentregistryconnectioncount}

コレクションの制限カウント。制限を超えるカウントの場合、制限+1を返します。

[`Int!`](#int)を返します。

\#######引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pagesdeploymentregistryconnectioncountlimit"></a>`limit` | [`Int`](#int) | カウントクエリに適用される制限値。デフォルトは1000です。 |

#### `PagesDeploymentRegistryEdge` {#pagesdeploymentregistryedge}

[`PagesDeploymentRegistry`](#pagesdeploymentregistry)のエッジ型。

##### フィールド {#fields-959}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pagesdeploymentregistryedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="pagesdeploymentregistryedgenode"></a>`node` | [`PagesDeploymentRegistry`](#pagesdeploymentregistry) | エッジの終端にあるアイテム。 |

#### `PathLockConnection` {#pathlockconnection}

[`PathLock`](#pathlock)の接続タイプ。

##### フィールド {#fields-960}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pathlockconnectionedges"></a>`edges` | [`[PathLockEdge]`](#pathlockedge) | エッジのリスト。 |
| <a id="pathlockconnectionnodes"></a>`nodes` | [`[PathLock]`](#pathlock) | ノードのリスト。 |
| <a id="pathlockconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `PathLockEdge` {#pathlockedge}

[`PathLock`](#pathlock)のエッジ型。

##### フィールド {#fields-961}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pathlockedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="pathlockedgenode"></a>`node` | [`PathLock`](#pathlock) | エッジの終端にあるアイテム。 |

#### `PendingMemberInterfaceConnection` {#pendingmemberinterfaceconnection}

[`PendingMemberInterface`](#pendingmemberinterface)の接続タイプ。

##### フィールド {#fields-962}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pendingmemberinterfaceconnectionedges"></a>`edges` | [`[PendingMemberInterfaceEdge]`](#pendingmemberinterfaceedge) | エッジのリスト。 |
| <a id="pendingmemberinterfaceconnectionnodes"></a>`nodes` | [`[PendingMemberInterface]`](#pendingmemberinterface) | ノードのリスト。 |
| <a id="pendingmemberinterfaceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `PendingMemberInterfaceEdge` {#pendingmemberinterfaceedge}

[`PendingMemberInterface`](#pendingmemberinterface)のエッジ型。

##### フィールド {#fields-963}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pendingmemberinterfaceedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="pendingmemberinterfaceedgenode"></a>`node` | [`PendingMemberInterface`](#pendingmemberinterface) | エッジの終端にあるアイテム。 |

#### `PipelineArtifactRegistryConnection` {#pipelineartifactregistryconnection}

[`PipelineArtifactRegistry`](#pipelineartifactregistry)の接続タイプ。

##### フィールド {#fields-964}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pipelineartifactregistryconnectionedges"></a>`edges` | [`[PipelineArtifactRegistryEdge]`](#pipelineartifactregistryedge) | エッジのリスト。 |
| <a id="pipelineartifactregistryconnectionnodes"></a>`nodes` | [`[PipelineArtifactRegistry]`](#pipelineartifactregistry) | ノードのリスト。 |
| <a id="pipelineartifactregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

##### 引数のあるフィールド {#fields-with-arguments-20}

###### `PipelineArtifactRegistryConnection.count` {#pipelineartifactregistryconnectioncount}

コレクションの制限カウント。制限を超えるカウントの場合、制限+1を返します。

[`Int!`](#int)を返します。

\#######引数

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pipelineartifactregistryconnectioncountlimit"></a>`limit` | [`Int`](#int) | カウントクエリに適用される制限値。デフォルトは1000です。 |

#### `PipelineArtifactRegistryEdge` {#pipelineartifactregistryedge}

[`PipelineArtifactRegistry`](#pipelineartifactregistry)のエッジ型。

##### フィールド {#fields-965}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pipelineartifactregistryedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="pipelineartifactregistryedgenode"></a>`node` | [`PipelineArtifactRegistry`](#pipelineartifactregistry) | エッジの終端にあるアイテム。 |

#### `PipelineConnection` {#pipelineconnection}

[`Pipeline`](#pipeline)の接続タイプ。

##### フィールド {#fields-966}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pipelineconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="pipelineconnectionedges"></a>`edges` | [`[PipelineEdge]`](#pipelineedge) | エッジのリスト。 |
| <a id="pipelineconnectionnodes"></a>`nodes` | [`[Pipeline]`](#pipeline) | ノードのリスト。 |
| <a id="pipelineconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `PipelineEdge` {#pipelineedge}

[`Pipeline`](#pipeline)のエッジ型。

##### フィールド {#fields-967}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pipelineedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="pipelineedgenode"></a>`node` | [`Pipeline`](#pipeline) | エッジの終端にあるアイテム。 |

#### `PipelineExecutionPolicyConnection` {#pipelineexecutionpolicyconnection}

[`PipelineExecutionPolicy`](#pipelineexecutionpolicy)の接続タイプ。

##### フィールド {#fields-968}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pipelineexecutionpolicyconnectionedges"></a>`edges` | [`[PipelineExecutionPolicyEdge]`](#pipelineexecutionpolicyedge) | エッジのリスト。 |
| <a id="pipelineexecutionpolicyconnectionnodes"></a>`nodes` | [`[PipelineExecutionPolicy]`](#pipelineexecutionpolicy) | ノードのリスト。 |
| <a id="pipelineexecutionpolicyconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `PipelineExecutionPolicyEdge` {#pipelineexecutionpolicyedge}

[`PipelineExecutionPolicy`](#pipelineexecutionpolicy)のエッジ型。

##### フィールド {#fields-969}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pipelineexecutionpolicyedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="pipelineexecutionpolicyedgenode"></a>`node` | [`PipelineExecutionPolicy`](#pipelineexecutionpolicy) | エッジの終端にあるアイテム。 |

#### `PipelineExecutionSchedulePolicyConnection` {#pipelineexecutionschedulepolicyconnection}

[`PipelineExecutionSchedulePolicy`](#pipelineexecutionschedulepolicy)の接続タイプ。

##### フィールド {#fields-970}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pipelineexecutionschedulepolicyconnectionedges"></a>`edges` | [`[PipelineExecutionSchedulePolicyEdge]`](#pipelineexecutionschedulepolicyedge) | エッジのリスト。 |
| <a id="pipelineexecutionschedulepolicyconnectionnodes"></a>`nodes` | [`[PipelineExecutionSchedulePolicy]`](#pipelineexecutionschedulepolicy) | ノードのリスト。 |
| <a id="pipelineexecutionschedulepolicyconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `PipelineExecutionSchedulePolicyEdge` {#pipelineexecutionschedulepolicyedge}

[`PipelineExecutionSchedulePolicy`](#pipelineexecutionschedulepolicy)のエッジ型。

##### フィールド {#fields-971}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pipelineexecutionschedulepolicyedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="pipelineexecutionschedulepolicyedgenode"></a>`node` | [`PipelineExecutionSchedulePolicy`](#pipelineexecutionschedulepolicy) | エッジの終端にあるアイテム。 |

#### `PipelineManualVariableConnection` {#pipelinemanualvariableconnection}

[`PipelineManualVariable`](#pipelinemanualvariable)の接続タイプ。

##### フィールド {#fields-972}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pipelinemanualvariableconnectionedges"></a>`edges` | [`[PipelineManualVariableEdge]`](#pipelinemanualvariableedge) | エッジのリスト。 |
| <a id="pipelinemanualvariableconnectionnodes"></a>`nodes` | [`[PipelineManualVariable]`](#pipelinemanualvariable) | ノードのリスト。 |
| <a id="pipelinemanualvariableconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `PipelineManualVariableEdge` {#pipelinemanualvariableedge}

[`PipelineManualVariable`](#pipelinemanualvariable)のエッジ型。

##### フィールド {#fields-973}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pipelinemanualvariableedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="pipelinemanualvariableedgenode"></a>`node` | [`PipelineManualVariable`](#pipelinemanualvariable) | エッジの終端にあるアイテム。 |

#### `PipelineMessageConnection` {#pipelinemessageconnection}

[`PipelineMessage`](#pipelinemessage)の接続タイプ。

##### フィールド {#fields-974}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pipelinemessageconnectionedges"></a>`edges` | [`[PipelineMessageEdge]`](#pipelinemessageedge) | エッジのリスト。 |
| <a id="pipelinemessageconnectionnodes"></a>`nodes` | [`[PipelineMessage]`](#pipelinemessage) | ノードのリスト。 |
| <a id="pipelinemessageconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `PipelineMessageEdge` {#pipelinemessageedge}

[`PipelineMessage`](#pipelinemessage)のエッジ型。

##### フィールド {#fields-975}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pipelinemessageedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="pipelinemessageedgenode"></a>`node` | [`PipelineMessage`](#pipelinemessage) | エッジの終端にあるアイテム。 |

#### `PipelineScheduleConnection` {#pipelinescheduleconnection}

[`PipelineSchedule`](#pipelineschedule)の接続タイプ。

##### フィールド {#fields-976}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pipelinescheduleconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="pipelinescheduleconnectionedges"></a>`edges` | [`[PipelineScheduleEdge]`](#pipelinescheduleedge) | エッジのリスト。 |
| <a id="pipelinescheduleconnectionnodes"></a>`nodes` | [`[PipelineSchedule]`](#pipelineschedule) | ノードのリスト。 |
| <a id="pipelinescheduleconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `PipelineScheduleEdge` {#pipelinescheduleedge}

[`PipelineSchedule`](#pipelineschedule)のエッジ型。

##### フィールド {#fields-977}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pipelinescheduleedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="pipelinescheduleedgenode"></a>`node` | [`PipelineSchedule`](#pipelineschedule) | エッジの終端にあるアイテム。 |

#### `PipelineScheduleVariableConnection` {#pipelineschedulevariableconnection}

[`PipelineScheduleVariable`](#pipelineschedulevariable)の接続タイプ。

##### フィールド {#fields-978}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pipelineschedulevariableconnectionedges"></a>`edges` | [`[PipelineScheduleVariableEdge]`](#pipelineschedulevariableedge) | エッジのリスト。 |
| <a id="pipelineschedulevariableconnectionnodes"></a>`nodes` | [`[PipelineScheduleVariable]`](#pipelineschedulevariable) | ノードのリスト。 |
| <a id="pipelineschedulevariableconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `PipelineScheduleVariableEdge` {#pipelineschedulevariableedge}

[`PipelineScheduleVariable`](#pipelineschedulevariable)のエッジ型。

##### フィールド {#fields-979}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pipelineschedulevariableedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="pipelineschedulevariableedgenode"></a>`node` | [`PipelineScheduleVariable`](#pipelineschedulevariable) | エッジの終端にあるアイテム。 |

#### `PipelineSecurityReportFindingConnection` {#pipelinesecurityreportfindingconnection}

[`PipelineSecurityReportFinding`](#pipelinesecurityreportfinding)の接続タイプ。

##### フィールド {#fields-980}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pipelinesecurityreportfindingconnectionedges"></a>`edges` | [`[PipelineSecurityReportFindingEdge]`](#pipelinesecurityreportfindingedge) | エッジのリスト。 |
| <a id="pipelinesecurityreportfindingconnectionnodes"></a>`nodes` | [`[PipelineSecurityReportFinding]`](#pipelinesecurityreportfinding) | ノードのリスト。 |
| <a id="pipelinesecurityreportfindingconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `PipelineSecurityReportFindingEdge` {#pipelinesecurityreportfindingedge}

[`PipelineSecurityReportFinding`](#pipelinesecurityreportfinding)のエッジ型。

##### フィールド {#fields-981}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pipelinesecurityreportfindingedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="pipelinesecurityreportfindingedgenode"></a>`node` | [`PipelineSecurityReportFinding`](#pipelinesecurityreportfinding) | エッジの終端にあるアイテム。 |

#### `PipelineTriggerConnection` {#pipelinetriggerconnection}

[`PipelineTrigger`](#pipelinetrigger)の接続タイプ。

##### フィールド {#fields-982}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pipelinetriggerconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="pipelinetriggerconnectionedges"></a>`edges` | [`[PipelineTriggerEdge]`](#pipelinetriggeredge) | エッジのリスト。 |
| <a id="pipelinetriggerconnectionnodes"></a>`nodes` | [`[PipelineTrigger]`](#pipelinetrigger) | ノードのリスト。 |
| <a id="pipelinetriggerconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `PipelineTriggerEdge` {#pipelinetriggeredge}

[`PipelineTrigger`](#pipelinetrigger)のエッジ型。

##### フィールド {#fields-983}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="pipelinetriggeredgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="pipelinetriggeredgenode"></a>`node` | [`PipelineTrigger`](#pipelinetrigger) | エッジの終端にあるアイテム。 |

#### `ProjectComplianceControlStatusTypeConnection` {#projectcompliancecontrolstatustypeconnection}

[`ProjectComplianceControlStatusType`](#projectcompliancecontrolstatustype)の接続タイプ。

##### フィールド {#fields-984}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="projectcompliancecontrolstatustypeconnectionedges"></a>`edges` | [`[ProjectComplianceControlStatusTypeEdge]`](#projectcompliancecontrolstatustypeedge) | エッジのリスト。 |
| <a id="projectcompliancecontrolstatustypeconnectionnodes"></a>`nodes` | [`[ProjectComplianceControlStatusType]`](#projectcompliancecontrolstatustype) | ノードのリスト。 |
| <a id="projectcompliancecontrolstatustypeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ProjectComplianceControlStatusTypeEdge` {#projectcompliancecontrolstatustypeedge}

[`ProjectComplianceControlStatusType`](#projectcompliancecontrolstatustype)のエッジ型。

##### フィールド {#fields-985}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="projectcompliancecontrolstatustypeedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="projectcompliancecontrolstatustypeedgenode"></a>`node` | [`ProjectComplianceControlStatusType`](#projectcompliancecontrolstatustype) | エッジの終端にあるアイテム。 |

#### `ProjectComplianceRequirementStatusConnection` {#projectcompliancerequirementstatusconnection}

[`ProjectComplianceRequirementStatus`](#projectcompliancerequirementstatus)の接続タイプ。

##### フィールド {#fields-986}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="projectcompliancerequirementstatusconnectionedges"></a>`edges` | [`[ProjectComplianceRequirementStatusEdge]`](#projectcompliancerequirementstatusedge) | エッジのリスト。 |
| <a id="projectcompliancerequirementstatusconnectionnodes"></a>`nodes` | [`[ProjectComplianceRequirementStatus]`](#projectcompliancerequirementstatus) | ノードのリスト。 |
| <a id="projectcompliancerequirementstatusconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ProjectComplianceRequirementStatusEdge` {#projectcompliancerequirementstatusedge}

[`ProjectComplianceRequirementStatus`](#projectcompliancerequirementstatus)のエッジ型。

##### フィールド {#fields-987}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="projectcompliancerequirementstatusedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="projectcompliancerequirementstatusedgenode"></a>`node` | [`ProjectComplianceRequirementStatus`](#projectcompliancerequirementstatus) | エッジの終端にあるアイテム。 |

#### `ProjectComplianceViolationConnection` {#projectcomplianceviolationconnection}

[`ProjectComplianceViolation`](#projectcomplianceviolation)の接続タイプ。

##### フィールド {#fields-988}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="projectcomplianceviolationconnectionedges"></a>`edges` | [`[ProjectComplianceViolationEdge]`](#projectcomplianceviolationedge) | エッジのリスト。 |
| <a id="projectcomplianceviolationconnectionnodes"></a>`nodes` | [`[ProjectComplianceViolation]`](#projectcomplianceviolation) | ノードのリスト。 |
| <a id="projectcomplianceviolationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ProjectComplianceViolationEdge` {#projectcomplianceviolationedge}

[`ProjectComplianceViolation`](#projectcomplianceviolation)のエッジ型。

##### フィールド {#fields-989}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="projectcomplianceviolationedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="projectcomplianceviolationedgenode"></a>`node` | [`ProjectComplianceViolation`](#projectcomplianceviolation) | エッジの終端にあるアイテム。 |

#### `ProjectConnection` {#projectconnection}

[`Project`](#project)の接続タイプ。

##### フィールド {#fields-990}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="projectconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="projectconnectionedges"></a>`edges` | [`[ProjectEdge]`](#projectedge) | エッジのリスト。 |
| <a id="projectconnectionnodes"></a>`nodes` | [`[Project]`](#project) | ノードのリスト。 |
| <a id="projectconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ProjectEdge` {#projectedge}

[`Project`](#project)のエッジ型。

##### フィールド {#fields-991}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="projectedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="projectedgenode"></a>`node` | [`Project`](#project) | エッジの終端にあるアイテム。 |

#### `ProjectInterfaceConnection` {#projectinterfaceconnection}

[`ProjectInterface`](#projectinterface)の接続タイプ。

##### フィールド {#fields-992}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="projectinterfaceconnectioncount"></a>`count` | [`Int!`](#int) | コレクションの合計数。 |
| <a id="projectinterfaceconnectionedges"></a>`edges` | [`[ProjectInterfaceEdge]`](#projectinterfaceedge) | エッジのリスト。 |
| <a id="projectinterfaceconnectionnodes"></a>`nodes` | [`[ProjectInterface]`](#projectinterface) | ノードのリスト。 |
| <a id="projectinterfaceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ProjectInterfaceEdge` {#projectinterfaceedge}

[`ProjectInterface`](#projectinterface)のエッジ型。

##### フィールド {#fields-993}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="projectinterfaceedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="projectinterfaceedgenode"></a>`node` | [`ProjectInterface`](#projectinterface) | エッジの終端にあるアイテム。 |

#### `ProjectMemberConnection` {#projectmemberconnection}

[`ProjectMember`](#projectmember)の接続タイプ。

##### フィールド {#fields-994}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="projectmemberconnectionedges"></a>`edges` | [`[ProjectMemberEdge]`](#projectmemberedge) | エッジのリスト。 |
| <a id="projectmemberconnectionnodes"></a>`nodes` | [`[ProjectMember]`](#projectmember) | ノードのリスト。 |
| <a id="projectmemberconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | ページネーションを支援する情報。 |

#### `ProjectMemberEdge` {#projectmemberedge}

[`ProjectMember`](#projectmember)のエッジ型。

##### フィールド {#fields-995}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
| <a id="projectmemberedgecursor"></a>`cursor` | [`String!`](#string) | ページネーションで使用するカーソル。 |
| <a id="projectmemberedgenode"></a>`node` | [`ProjectMember`](#projectmember) | エッジの終端にあるアイテム。 |

#### `ProjectRepositoryRegistryConnection` {#projectrepositoryregistryconnection}

[`ProjectRepositoryRegistry`](#projectrepositoryregistry)の接続タイプ。

##### フィールド {#fields-996}

| 名前 | 型 | 説明 |
| ---- | ---- | ----------- |
