﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/appmesh/AppMesh_EXPORTS.h>
#include <aws/appmesh/model/MatchRange.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace AppMesh {
namespace Model {

/**
 * <p>An object that represents the match method. Specify one of the match
 * values.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/GrpcRouteMetadataMatchMethod">AWS
 * API Reference</a></p>
 */
class GrpcRouteMetadataMatchMethod {
 public:
  AWS_APPMESH_API GrpcRouteMetadataMatchMethod() = default;
  AWS_APPMESH_API GrpcRouteMetadataMatchMethod(Aws::Utils::Json::JsonView jsonValue);
  AWS_APPMESH_API GrpcRouteMetadataMatchMethod& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_APPMESH_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The value sent by the client must match the specified value exactly.</p>
   */
  inline const Aws::String& GetExact() const { return m_exact; }
  inline bool ExactHasBeenSet() const { return m_exactHasBeenSet; }
  template <typename ExactT = Aws::String>
  void SetExact(ExactT&& value) {
    m_exactHasBeenSet = true;
    m_exact = std::forward<ExactT>(value);
  }
  template <typename ExactT = Aws::String>
  GrpcRouteMetadataMatchMethod& WithExact(ExactT&& value) {
    SetExact(std::forward<ExactT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The value sent by the client must begin with the specified characters.</p>
   */
  inline const Aws::String& GetPrefix() const { return m_prefix; }
  inline bool PrefixHasBeenSet() const { return m_prefixHasBeenSet; }
  template <typename PrefixT = Aws::String>
  void SetPrefix(PrefixT&& value) {
    m_prefixHasBeenSet = true;
    m_prefix = std::forward<PrefixT>(value);
  }
  template <typename PrefixT = Aws::String>
  GrpcRouteMetadataMatchMethod& WithPrefix(PrefixT&& value) {
    SetPrefix(std::forward<PrefixT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An object that represents the range of values to match on.</p>
   */
  inline const MatchRange& GetRange() const { return m_range; }
  inline bool RangeHasBeenSet() const { return m_rangeHasBeenSet; }
  template <typename RangeT = MatchRange>
  void SetRange(RangeT&& value) {
    m_rangeHasBeenSet = true;
    m_range = std::forward<RangeT>(value);
  }
  template <typename RangeT = MatchRange>
  GrpcRouteMetadataMatchMethod& WithRange(RangeT&& value) {
    SetRange(std::forward<RangeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The value sent by the client must include the specified characters.</p>
   */
  inline const Aws::String& GetRegex() const { return m_regex; }
  inline bool RegexHasBeenSet() const { return m_regexHasBeenSet; }
  template <typename RegexT = Aws::String>
  void SetRegex(RegexT&& value) {
    m_regexHasBeenSet = true;
    m_regex = std::forward<RegexT>(value);
  }
  template <typename RegexT = Aws::String>
  GrpcRouteMetadataMatchMethod& WithRegex(RegexT&& value) {
    SetRegex(std::forward<RegexT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The value sent by the client must end with the specified characters.</p>
   */
  inline const Aws::String& GetSuffix() const { return m_suffix; }
  inline bool SuffixHasBeenSet() const { return m_suffixHasBeenSet; }
  template <typename SuffixT = Aws::String>
  void SetSuffix(SuffixT&& value) {
    m_suffixHasBeenSet = true;
    m_suffix = std::forward<SuffixT>(value);
  }
  template <typename SuffixT = Aws::String>
  GrpcRouteMetadataMatchMethod& WithSuffix(SuffixT&& value) {
    SetSuffix(std::forward<SuffixT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_exact;
  bool m_exactHasBeenSet = false;

  Aws::String m_prefix;
  bool m_prefixHasBeenSet = false;

  MatchRange m_range;
  bool m_rangeHasBeenSet = false;

  Aws::String m_regex;
  bool m_regexHasBeenSet = false;

  Aws::String m_suffix;
  bool m_suffixHasBeenSet = false;
};

}  // namespace Model
}  // namespace AppMesh
}  // namespace Aws
