/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.geo.XYEncodingUtils;
import org.apache.lucene.geo.XYGeometry;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;

public class XYDocValuesPointInGeometryQuery
extends Query {
    private final String field;
    private final XYGeometry[] geometries;

    XYDocValuesPointInGeometryQuery(String field, XYGeometry ... geometries) {
        if (field == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        if (geometries == null) {
            throw new IllegalArgumentException("geometries must not be null");
        }
        if (geometries.length == 0) {
            throw new IllegalArgumentException("geometries must not be empty");
        }
        for (int i = 0; i < geometries.length; ++i) {
            if (geometries[i] != null) continue;
            throw new IllegalArgumentException("geometries[" + i + "] must not be null");
        }
        this.field = field;
        this.geometries = (XYGeometry[])geometries.clone();
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        if (!this.field.equals(field)) {
            sb.append(this.field);
            sb.append(':');
        }
        sb.append("geometries(").append(Arrays.toString(this.geometries));
        return sb.append(")").toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        XYDocValuesPointInGeometryQuery other = (XYDocValuesPointInGeometryQuery)obj;
        return this.field.equals(other.field) && Arrays.equals(this.geometries, other.geometries);
    }

    @Override
    public int hashCode() {
        int h = this.classHash();
        h = 31 * h + this.field.hashCode();
        h = 31 * h + Arrays.hashCode(this.geometries);
        return h;
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, final float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){
            final Component2D component2D;
            {
                super(query, score);
                this.component2D = XYGeometry.create(XYDocValuesPointInGeometryQuery.this.geometries);
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                final SortedNumericDocValues values = context.reader().getSortedNumericDocValues(XYDocValuesPointInGeometryQuery.this.field);
                if (values == null) {
                    return null;
                }
                TwoPhaseIterator iterator = new TwoPhaseIterator(values){

                    @Override
                    public boolean matches() throws IOException {
                        int count = values.docValueCount();
                        for (int i = 0; i < count; ++i) {
                            double y;
                            long value = values.nextValue();
                            double x = XYEncodingUtils.decode((int)(value >>> 32));
                            if (!component2D.contains(x, y = (double)XYEncodingUtils.decode((int)(value & 0xFFFFFFFFFFFFFFFFL)))) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public float matchCost() {
                        return 1000.0f;
                    }
                };
                return new ConstantScoreScorer((Weight)this, boost, scoreMode, iterator);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return DocValues.isCacheable(ctx, XYDocValuesPointInGeometryQuery.this.field);
            }
        };
    }
}

