/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.function;

import java.util.Comparator;
import java.util.Objects;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import javax.measure.Quantity;
import javax.measure.Unit;
import tech.units.indriya.function.NaturalQuantityComparator;
import tech.units.indriya.function.QuantitySummaryStatistics;

public final class QuantityFunctions {
    private QuantityFunctions() {
    }

    public static <Q extends Quantity<Q>> Comparator<Quantity<Q>> sortNumber() {
        return (q1, q2) -> Double.compare(q1.getValue().doubleValue(), q2.getValue().doubleValue());
    }

    public static <Q extends Quantity<Q>> Comparator<Quantity<Q>> sortNumberDesc() {
        Comparator<Quantity<Q>> sortNumber = QuantityFunctions.sortNumber();
        return sortNumber.reversed();
    }

    public static <Q extends Quantity<Q>> Comparator<Quantity<Q>> sortSymbol() {
        return (q1, q2) -> q1.getUnit().getSymbol().compareTo(q2.getUnit().getSymbol());
    }

    public static <Q extends Quantity<Q>> Comparator<Quantity<Q>> sortSymbolDesc() {
        Comparator<Quantity<Q>> sortSymbol = QuantityFunctions.sortSymbol();
        return sortSymbol.reversed();
    }

    public static <Q extends Quantity<Q>> Comparator<Quantity<Q>> sortNatural() {
        return new NaturalQuantityComparator();
    }

    public static <Q extends Quantity<Q>> Comparator<Quantity<Q>> sortNaturalDesc() {
        Comparator<Quantity<Q>> sortNatural = QuantityFunctions.sortNatural();
        return sortNatural.reversed();
    }

    public static <Q extends Quantity<Q>> BinaryOperator<Quantity<Q>> min() {
        return (q1, q2) -> {
            double d2;
            double d1 = q1.getValue().doubleValue();
            double min = Double.min(d1, d2 = q2.to(q1.getUnit()).getValue().doubleValue());
            if (min == d1) {
                return q1;
            }
            return q2;
        };
    }

    public static <Q extends Quantity<Q>> BinaryOperator<Quantity<Q>> max() {
        return (q1, q2) -> {
            double d2;
            double d1 = q1.getValue().doubleValue();
            double min = Double.max(d1, d2 = q2.to(q1.getUnit()).getValue().doubleValue());
            if (min == d1) {
                return q1;
            }
            return q2;
        };
    }

    public static <Q extends Quantity<Q>> BinaryOperator<Quantity<Q>> sum() {
        return Quantity::add;
    }

    public static <Q extends Quantity<Q>> BinaryOperator<Quantity<Q>> sum(Unit<Q> unit) {
        return (q1, q2) -> q1.to(unit).add(q2.to(unit));
    }

    @SafeVarargs
    public static <Q extends Quantity<Q>> Predicate<Quantity<Q>> fiterByUnit(Unit<Q> ... units) {
        if (Objects.isNull(units) || units.length == 0) {
            return q -> true;
        }
        Predicate<Quantity> predicate = null;
        for (Unit u : units) {
            predicate = Objects.isNull(predicate) ? q -> q.getUnit().equals(u) : predicate.or(q -> q.getUnit().equals(u));
        }
        return predicate;
    }

    @SafeVarargs
    public static <Q extends Quantity<Q>> Predicate<Quantity<Q>> fiterByExcludingUnit(Unit<Q> ... units) {
        if (Objects.isNull(units) || units.length == 0) {
            return q -> true;
        }
        return QuantityFunctions.fiterByUnit(units).negate();
    }

    public static <Q extends Quantity<Q>> Predicate<Quantity<Q>> isGreaterThan(Number value) {
        return q -> q.getValue().doubleValue() > value.doubleValue();
    }

    public static <Q extends Quantity<Q>> Predicate<Quantity<Q>> isGreaterThan(Quantity<Q> quantity) {
        return q -> q.to(quantity.getUnit()).getValue().doubleValue() > quantity.getValue().doubleValue();
    }

    public static <Q extends Quantity<Q>> Predicate<Quantity<Q>> isGreaterThanOrEqualTo(Number value) {
        return q -> q.getValue().doubleValue() >= value.doubleValue();
    }

    public static <Q extends Quantity<Q>> Predicate<Quantity<Q>> isGreaterThanOrEqualTo(Quantity<Q> quantity) {
        return q -> q.to(quantity.getUnit()).getValue().doubleValue() >= quantity.getValue().doubleValue();
    }

    public static <Q extends Quantity<Q>> Predicate<Quantity<Q>> isLesserThan(Number value) {
        return q -> q.getValue().doubleValue() < value.doubleValue();
    }

    public static <Q extends Quantity<Q>> Predicate<Quantity<Q>> isLesserThan(Quantity<Q> quantity) {
        return q -> q.to(quantity.getUnit()).getValue().doubleValue() < quantity.getValue().doubleValue();
    }

    public static <Q extends Quantity<Q>> Predicate<Quantity<Q>> isLesserThanOrEqualTo(Number value) {
        return q -> q.getValue().doubleValue() <= value.doubleValue();
    }

    public static <Q extends Quantity<Q>> Predicate<Quantity<Q>> isLesserThanOrEqualTo(Quantity<Q> quantity) {
        return q -> q.to(quantity.getUnit()).getValue().doubleValue() <= quantity.getValue().doubleValue();
    }

    public static <Q extends Quantity<Q>> Predicate<Quantity<Q>> isBetween(Number min, Number max) {
        Predicate<Quantity<Q>> minFilter = QuantityFunctions.isGreaterThanOrEqualTo(min);
        Predicate<Quantity<Q>> maxFilter = QuantityFunctions.isLesserThanOrEqualTo(max);
        return minFilter.and(maxFilter);
    }

    public static <Q extends Quantity<Q>> Predicate<Quantity<Q>> isBetween(Quantity<Q> min, Quantity<Q> max) {
        return QuantityFunctions.isGreaterThanOrEqualTo(min).and(QuantityFunctions.isLesserThanOrEqualTo(max));
    }

    public static <Q extends Quantity<Q>> Collector<Quantity<Q>, QuantitySummaryStatistics<Q>, QuantitySummaryStatistics<Q>> summarizeQuantity(Unit<Q> unit) {
        Supplier<QuantitySummaryStatistics> supplier = () -> new QuantitySummaryStatistics(unit);
        return Collector.of(supplier, QuantitySummaryStatistics::accept, QuantitySummaryStatistics::combine, new Collector.Characteristics[0]);
    }

    public static <Q extends Quantity<Q>> Function<Quantity<Q>, Unit<Q>> groupByUnit() {
        return Quantity::getUnit;
    }
}

