/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.view;

import com.intellij.coverage.CoverageAnnotator;
import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.filters.ModifiedFilesFilter;
import com.intellij.coverage.view.CoverageListNode;
import com.intellij.coverage.view.CoverageListRootNode;
import com.intellij.coverage.view.CoverageViewExtension;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.coverage.view.ElementColumnInfo;
import com.intellij.coverage.view.PercentageCoverageColumnInfo;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.ui.ColumnInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class DirectoryCoverageViewExtension
extends CoverageViewExtension {
    protected final CoverageAnnotator myAnnotator;

    @Deprecated
    public DirectoryCoverageViewExtension(Project project, CoverageAnnotator annotator, CoverageSuitesBundle suitesBundle, CoverageViewManager.StateBean stateBean) {
        this(project, annotator, suitesBundle);
    }

    public DirectoryCoverageViewExtension(Project project, CoverageAnnotator annotator, CoverageSuitesBundle suitesBundle) {
        super(project, suitesBundle);
        this.myAnnotator = annotator;
    }

    @Override
    public ColumnInfo[] createColumnInfos() {
        return new ColumnInfo[]{new ElementColumnInfo(), new PercentageCoverageColumnInfo(1, CoverageBundle.message("table.column.name.statistics", new Object[0]), this.mySuitesBundle)};
    }

    @Override
    public String getPercentage(int columnIdx, @NotNull AbstractTreeNode<?> node) {
        VirtualFile file;
        if (node == null) {
            DirectoryCoverageViewExtension.$$$reportNull$$$0(0);
        }
        if ((file = this.extractFile(node)) == null) {
            return null;
        }
        if (file.isDirectory()) {
            return this.myAnnotator.getDirCoverageInformationString(this.myProject, file, this.mySuitesBundle, this.myCoverageDataManager);
        }
        return this.myAnnotator.getFileCoverageInformationString(this.myProject, file, this.mySuitesBundle, this.myCoverageDataManager);
    }

    @Nullable
    protected VirtualFile extractFile(@NotNull AbstractTreeNode<?> node) {
        if (node == null) {
            DirectoryCoverageViewExtension.$$$reportNull$$$0(1);
        }
        if (node instanceof CoverageListNode) {
            CoverageListNode coverageNode = (CoverageListNode)node;
            return coverageNode.getFile();
        }
        return null;
    }

    @Override
    public PsiElement getParentElement(PsiElement element) {
        PsiFile containingFile = element.getContainingFile();
        if (containingFile != null) {
            return containingFile.getContainingDirectory();
        }
        return null;
    }

    @Override
    @NotNull
    public AbstractTreeNode<?> createRootNode() {
        VirtualFile baseDir = ProjectUtil.guessProjectDir((Project)this.myProject);
        if (baseDir == null) {
            VirtualFile[] roots = ProjectRootManager.getInstance((Project)this.myProject).getContentRoots();
            baseDir = VfsUtil.getCommonAncestor(Arrays.asList(roots));
        }
        PsiDirectory directory = PsiManager.getInstance((Project)this.myProject).findDirectory(Objects.requireNonNull(baseDir));
        return new CoverageListRootNode(this.myProject, (PsiNamedElement)Objects.requireNonNull(directory), this.mySuitesBundle);
    }

    @Override
    void onRootReset() {
        ModifiedFilesFilter filter = this.myAnnotator.getModifiedFilesFilter();
        if (filter != null) {
            filter.resetFilteredFiles();
        }
    }

    public @Unmodifiable List<AbstractTreeNode<?>> getChildrenNodes(AbstractTreeNode node) {
        ArrayList children = new ArrayList();
        if (node instanceof CoverageListNode) {
            PsiFile[] psiFiles;
            PsiDirectory[] subdirectories;
            Object val = node.getValue();
            if (val instanceof PsiFile || val == null) {
                return Collections.emptyList();
            }
            PsiDirectory psiDirectory = (PsiDirectory)val;
            for (PsiDirectory subdirectory : subdirectories = (PsiDirectory[])ReadAction.compute(() -> psiDirectory.getSubdirectories())) {
                CoverageListNode e;
                if (this.myAnnotator.getDirCoverageInformationString(subdirectory, this.mySuitesBundle, this.myCoverageDataManager) == null || (e = new CoverageListNode(this.myProject, (PsiNamedElement)subdirectory, this.mySuitesBundle)).getChildren().isEmpty()) continue;
                children.add(e);
            }
            for (PsiFile psiFile : psiFiles = (PsiFile[])ReadAction.compute(() -> psiDirectory.getFiles())) {
                if (this.myAnnotator.getFileCoverageInformationString(psiFile, this.mySuitesBundle, this.myCoverageDataManager) == null) continue;
                CoverageListNode e = new CoverageListNode(this.myProject, (PsiNamedElement)psiFile, this.mySuitesBundle);
                VirtualFile file = e.getFile();
                CoverageViewManager.StateBean stateBean = CoverageViewManager.getInstance(this.myProject).getStateBean();
                ModifiedFilesFilter filter = this.myAnnotator.getModifiedFilesFilter();
                if (stateBean.isShowOnlyModified() && file != null && filter != null && !filter.isFileModified(file)) continue;
                children.add(e);
            }
        }
        return children;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "node";
        objectArray2[1] = "com/intellij/coverage/view/DirectoryCoverageViewExtension";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getPercentage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "extractFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

