/*
 * Decompiled with CFR 0.152.
 */
package org.limine.entry.tool.processes;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import org.limine.entry.tool.formats.limine8.Limine;
import org.limine.entry.tool.objects.Config;
import org.limine.entry.tool.objects.EntryOptions;
import org.limine.entry.tool.objects.TreeNode;
import org.limine.entry.tool.processes.LimineWriter;
import org.limine.entry.tool.processes.MacroReplacer;
import org.limine.entry.tool.processes.Utility;

public class LimineReader {
    private final String limineConfigPath;
    private final TreeNode rootNode;
    private final TreeNode targetOsNode;

    public LimineReader(Config config) throws IOException {
        this.limineConfigPath = Utility.buildPath(config.espPath(), "limine.conf");
        this.rootNode = new TreeNode("root", 0, null);
        if (!Utility.isFilePresent(this.limineConfigPath)) {
            Utility.infoMessage(this.limineConfigPath + " is created.");
            LimineWriter.createDefaultLimineConfigFile(this.limineConfigPath);
        }
        this.readLimineConfig(this.rootNode);
        TreeNode osNode = this.rootNode.findNodeByIDorName(config, 1);
        if (osNode == null && Config.ENABLE_OS_GENERATION) {
            this.targetOsNode = new TreeNode(Limine.ENTRY_KEY.toString().trim() + String.valueOf((Object)Limine.EXPAND) + config.targetOs(), 1, "root");
            EntryOptions osEntryOptions = new EntryOptions().setMachineID(config.machineID()).setPriority(50).setEntryOverwrite(false);
            List<CallSite> lines = List.of(String.valueOf((Object)Limine.COMMENT) + " " + this.targetOsNode.getCleanName(), String.valueOf((Object)Limine.COMMENT) + " " + osEntryOptions.buildEntryComment());
            this.targetOsNode.getConfigLines().addAll(lines);
            int position = this.rootNode.findPositionByLowerPriority(50);
            this.rootNode.addNode(position, this.targetOsNode);
        } else {
            this.targetOsNode = osNode;
        }
    }

    public TreeNode getRootNode() {
        return this.rootNode;
    }

    public TreeNode getTargetOsNode() {
        return this.targetOsNode;
    }

    private void readLimineConfig(TreeNode rootNode) throws IOException {
        List<String> lines = Files.readAllLines(Paths.get(this.limineConfigPath, new String[0]));
        this.parseLinesToTree(lines, rootNode, 0, lines.size());
    }

    private int parseLinesToTree(List<String> lines, TreeNode currentNode, int startIndex, int endIndex) {
        int index = startIndex;
        while (index < endIndex) {
            String line = lines.get(index);
            String trimLine = line.trim();
            if (trimLine.startsWith(Limine.ENTRY_KEY.toString())) {
                int depth = this.calculateDepth(trimLine);
                TreeNode childNode = new TreeNode(line, depth, currentNode.getName());
                currentNode.addNode(childNode);
                int nextIndex = this.findNextNodeIndex(lines, index + 1, endIndex, depth);
                index = this.parseLinesToTree(lines, childNode, index + 1, nextIndex);
                continue;
            }
            MacroReplacer.parseMacro(line);
            currentNode.addConfigLine(line);
            ++index;
        }
        return index;
    }

    private int findNextNodeIndex(List<String> lines, int startIndex, int endIndex, int currentDepth) {
        for (int i = startIndex; i < endIndex; ++i) {
            String line = lines.get(i).trim();
            if (!line.startsWith(Limine.ENTRY_KEY.toString()) || this.calculateDepth(line) > currentDepth) continue;
            return i;
        }
        return endIndex;
    }

    private int calculateDepth(String line) {
        int depth;
        for (depth = 0; depth < line.length() && line.startsWith(Limine.ENTRY_KEY.toString(), depth); ++depth) {
        }
        return depth;
    }
}

