/*
 * Decompiled with CFR 0.152.
 */
package org.limine.entry.tool.processes;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.limine.entry.tool.formats.limine8.Limine;
import org.limine.entry.tool.formats.limine8.LimineEntry;
import org.limine.entry.tool.objects.Config;
import org.limine.entry.tool.objects.EntryOptions;
import org.limine.entry.tool.objects.TreeNode;
import org.limine.entry.tool.processes.Utility;

public class LimineManager {
    private final TreeNode targetOsNode;
    private final Config config;
    public boolean isUpdateNeeded;

    public LimineManager(TreeNode targetOsNode, Config config) {
        this.targetOsNode = targetOsNode;
        this.config = config;
        this.isUpdateNeeded = false;
    }

    public static boolean merge(TreeNode rootNode, String efiName, String comment, EntryOptions entryOptions, String efiFilePath, Config config) {
        if ((efiFilePath = Utility.correctCaseSensitivePath(efiFilePath)) == null) {
            return false;
        }
        String mountPoint = Utility.getMountPointIfFat32(efiFilePath);
        if (mountPoint.isEmpty()) {
            return false;
        }
        Object pathFunction = Objects.equals(Utility.removeSurroundingSlashes(mountPoint), Utility.removeSurroundingSlashes(config.espPath())) ? Limine.DEFAULT_PATH_FUNCTION.toString() : "guid(" + Utility.getPartitionUUID(mountPoint) + "):";
        TreeNode efiNode = rootNode.findNodeByCleanName(efiName, null, 1);
        if (efiNode == null) {
            efiNode = new TreeNode(String.valueOf((Object)Limine.ENTRY_KEY) + efiName, 1, rootNode.getName());
            efiNode.setEnableLineBreak(true);
            int position = rootNode.findPositionByLowerPriority(entryOptions.getPriority());
            rootNode.addNode(position, efiNode);
        } else if (entryOptions.getEntryOverwrite()) {
            efiNode.getConfigLines().clear();
        } else {
            return false;
        }
        List<String> lines = List.of(String.valueOf((Object)Limine.COMMENT) + " " + comment, String.valueOf((Object)Limine.COMMENT) + " " + entryOptions.buildEntryComment(), String.valueOf((Object)Limine.PROTOCOL) + " " + String.valueOf((Object)Limine.PROTOCOL_EFI), String.valueOf((Object)Limine.PATH) + " " + (String)pathFunction + efiFilePath.substring(mountPoint.length()), "");
        efiNode.getConfigLines().addAll(lines);
        return true;
    }

    public static boolean removeEfi(TreeNode rootNode, String efiFilePath, Config config) {
        String mountPoint;
        if (efiFilePath == null || efiFilePath.isBlank()) {
            return false;
        }
        String correctPath = Utility.correctCaseSensitivePath(efiFilePath);
        if (correctPath != null) {
            efiFilePath = correctPath;
        }
        if ((mountPoint = Utility.getMountPointIfFat32(efiFilePath)).isEmpty()) {
            return false;
        }
        String pathFunction = null;
        if (Objects.equals(Utility.removeSurroundingSlashes(mountPoint), Utility.removeSurroundingSlashes(config.espPath()))) {
            pathFunction = Limine.DEFAULT_PATH_FUNCTION.toString();
        }
        String gptUuid = null;
        if (Utility.isSystemEfi()) {
            gptUuid = Utility.getPartitionUUID(mountPoint);
        }
        if (pathFunction == null && gptUuid == null) {
            return false;
        }
        String espFilePath = efiFilePath.substring(mountPoint.length());
        Iterator it = rootNode.getNodes().iterator();
        boolean isUpdateNeeded = false;
        while (it.hasNext()) {
            LimineEntry entry = new LimineEntry((TreeNode)it.next());
            if (!entry.containsEfiPath(pathFunction, espFilePath) && !entry.containsEfiPath(gptUuid, espFilePath)) continue;
            it.remove();
            isUpdateNeeded = true;
            break;
        }
        return isUpdateNeeded;
    }

    public static boolean removeOs(TreeNode rootNode, String osNameOrMachineID, Config config) {
        if (osNameOrMachineID == null || osNameOrMachineID.isBlank()) {
            return false;
        }
        Matcher machineIdMatcher = Pattern.compile("([a-f0-9]{32})").matcher(osNameOrMachineID);
        TreeNode osNode = machineIdMatcher.find() ? rootNode.findNodeByMachineID(osNameOrMachineID, 1) : rootNode.findNodeByCleanName(osNameOrMachineID, null, 1);
        boolean isUpdateNeeded = false;
        if (osNode != null) {
            rootNode.getNodes().remove(osNode);
            isUpdateNeeded = true;
        }
        return isUpdateNeeded;
    }

    public void add(String kernelName, String kernelComment, EntryOptions kernelEntryOptions, String initramfsPath, String vmlinuzPath, String suffixName) {
        String targetHashCode;
        String hashCode;
        if (!Utility.isFilePresent(initramfsPath)) {
            Utility.errorMessage("The file: " + initramfsPath + " is not found");
            return;
        }
        if (!Utility.isFilePresent(vmlinuzPath)) {
            Utility.errorMessage("The file: " + vmlinuzPath + " is not found");
            return;
        }
        String dirPath = Utility.buildPath(this.config.espPath(), this.config.machineID(), kernelName) + File.separator;
        Utility.ensureDirectoryExists(dirPath);
        String initramfsFileName = Utility.extractFileNameFromPath(initramfsPath.trim());
        String targetInitramfsPath = dirPath + initramfsFileName;
        String vmlinuzFileName = Utility.extractFileNameFromPath(vmlinuzPath.trim());
        String targetVmlinuzPath = dirPath + vmlinuzFileName;
        if (Utility.isFilePresent(targetInitramfsPath)) {
            hashCode = Utility.computeBlake2(initramfsPath);
            if (!hashCode.equals(targetHashCode = Utility.computeBlake2(targetInitramfsPath))) {
                Utility.copyFile(initramfsPath, targetInitramfsPath, true);
            }
        } else {
            Utility.copyFile(initramfsPath, targetInitramfsPath, true);
        }
        if (Utility.isFilePresent(targetVmlinuzPath)) {
            hashCode = Utility.computeBlake2(vmlinuzPath);
            if (!hashCode.equals(targetHashCode = Utility.computeBlake2(targetVmlinuzPath))) {
                Utility.copyFile(vmlinuzPath, targetVmlinuzPath, true);
            }
        } else {
            Utility.copyFile(vmlinuzPath, targetVmlinuzPath, true);
        }
        boolean isKernelFound = false;
        String bootEntryName = String.valueOf((Object)Limine.SUB_ENTRY_KEY) + kernelName + suffixName;
        List<String> comments = List.of(kernelComment);
        String kernelCmdline = this.config.getKernelCmdline(kernelName + suffixName);
        for (TreeNode bootNode : this.targetOsNode.getNodes()) {
            if (!bootNode.getName().endsWith(bootEntryName)) continue;
            List<String> bootConfig = this.createBootConfig(kernelName, comments, kernelCmdline, initramfsFileName, vmlinuzFileName);
            bootNode.getConfigLines().clear();
            bootNode.getConfigLines().addAll(bootConfig);
            isKernelFound = true;
            break;
        }
        if (!isKernelFound) {
            TreeNode bootNode = new TreeNode(Config.SPACES + bootEntryName, 2, this.targetOsNode.getName());
            bootNode.setOptions(kernelEntryOptions);
            List<String> bootConfig = this.createBootConfig(kernelName, comments, kernelCmdline, initramfsFileName, vmlinuzFileName);
            bootNode.getConfigLines().addAll(bootConfig);
            this.targetOsNode.addNode(bootNode);
        }
        this.sortEntriesByBootOrder(this.targetOsNode.getNodes(), Config.BOOT_ORDER);
        this.isUpdateNeeded = true;
    }

    public void addUki(String kernelName, String kernelComment, EntryOptions kernelEntryOptions, String ukiFilePath) {
        if (!Utility.isFilePresent(ukiFilePath)) {
            Utility.errorMessage("The file: " + ukiFilePath + " is not found");
            return;
        }
        String dirPath = Utility.buildPath(this.config.espPath(), "EFI/Linux") + File.separator;
        Utility.ensureDirectoryExists(dirPath);
        String ukiFileName = this.getDefaultUkiFileName(kernelName);
        String targetUkiPath = dirPath + ukiFileName;
        if (Utility.isFilePresent(targetUkiPath)) {
            String hashCode = Utility.computeBlake2(ukiFilePath);
            String targetHashCode = Utility.computeBlake2(targetUkiPath);
            if (!hashCode.isEmpty() && !hashCode.equals(targetHashCode)) {
                Utility.copyFile(ukiFilePath, targetUkiPath, true);
            }
        } else {
            Utility.copyFile(ukiFilePath, targetUkiPath, true);
        }
        boolean isKernelFound = false;
        String bootEntryName = String.valueOf((Object)Limine.SUB_ENTRY_KEY) + kernelName;
        List<String> comments = List.of(kernelComment);
        String kernelCmdline = this.config.getKernelCmdline(kernelName);
        for (TreeNode bootNode : this.targetOsNode.getNodes()) {
            if (!bootNode.getName().endsWith(bootEntryName)) continue;
            List<String> bootConfig = this.createUkiBootConfig(comments, kernelCmdline, ukiFileName);
            bootNode.getConfigLines().clear();
            bootNode.getConfigLines().addAll(bootConfig);
            isKernelFound = true;
            break;
        }
        if (!isKernelFound) {
            TreeNode bootNode = new TreeNode(Config.SPACES + bootEntryName, 2, this.targetOsNode.getName());
            bootNode.setOptions(kernelEntryOptions);
            List<String> bootConfig = this.createUkiBootConfig(comments, kernelCmdline, ukiFileName);
            bootNode.getConfigLines().addAll(bootConfig);
            this.targetOsNode.addNode(bootNode);
        }
        this.sortEntriesByBootOrder(this.targetOsNode.getNodes(), Config.BOOT_ORDER);
        this.isUpdateNeeded = true;
    }

    private List<String> createBootConfig(String kernelName, List<String> kernelComments, String kernelCmdline, String initramfsFileName, String vmlinuzFileName) {
        String initramfsFullPath = Utility.buildPath(this.config.espPath(), this.config.machineID(), kernelName, initramfsFileName);
        initramfsFullPath = Utility.correctCaseSensitivePath(initramfsFullPath);
        String vmlinuzFullPath = Utility.buildPath(this.config.espPath(), this.config.machineID(), kernelName, vmlinuzFileName);
        vmlinuzFullPath = Utility.correctCaseSensitivePath(vmlinuzFullPath);
        String espPath = Utility.buildPath(this.config.espPath());
        assert (initramfsFullPath != null);
        String initramfsEspPath = initramfsFullPath.substring(espPath.length());
        assert (vmlinuzFullPath != null);
        String vmlinuzEspPath = vmlinuzFullPath.substring(espPath.length());
        ArrayList<String> bootConfig = new ArrayList<String>();
        for (String comment : kernelComments) {
            if (comment.isBlank()) continue;
            bootConfig.add(Config.SPACES + String.valueOf((Object)Limine.COMMENT) + " " + comment);
        }
        if (Utility.isSystemAmd64()) {
            bootConfig.add(Config.SPACES + String.valueOf((Object)Limine.PROTOCOL) + " " + String.valueOf((Object)Limine.PROTOCOL_LINUX));
        } else {
            bootConfig.add(Config.SPACES + String.valueOf((Object)Limine.PROTOCOL) + " " + String.valueOf((Object)Limine.PROTOCOL_LINUX));
        }
        bootConfig.add(Config.SPACES + String.valueOf((Object)Limine.MODULE_PATH) + " " + this.config.pathFunction() + initramfsEspPath + this.b2sum(initramfsFullPath));
        bootConfig.add(Config.SPACES + String.valueOf((Object)Limine.PATH) + " " + this.config.pathFunction() + vmlinuzEspPath + this.b2sum(vmlinuzFullPath));
        bootConfig.add(Config.SPACES + String.valueOf((Object)Limine.CMDLINE) + " " + kernelCmdline);
        bootConfig.add("");
        return bootConfig;
    }

    private List<String> createUkiBootConfig(List<String> kernelComments, String kernelCmdline, String ukiFileName) {
        String ukiFullPath = Utility.buildPath(this.config.espPath(), "EFI/Linux", ukiFileName);
        ukiFullPath = Utility.correctCaseSensitivePath(ukiFullPath);
        String espPath = Utility.buildPath(this.config.espPath());
        assert (ukiFullPath != null);
        String ukiEspPath = ukiFullPath.substring(espPath.length());
        ArrayList<String> bootConfig = new ArrayList<String>();
        for (String comment : kernelComments) {
            if (comment.isBlank()) continue;
            bootConfig.add(Config.SPACES + String.valueOf((Object)Limine.COMMENT) + " " + comment);
        }
        bootConfig.add(Config.SPACES + String.valueOf((Object)Limine.PROTOCOL) + " " + String.valueOf((Object)Limine.PROTOCOL_EFI));
        bootConfig.add(Config.SPACES + String.valueOf((Object)Limine.PATH) + " " + this.config.pathFunction() + ukiEspPath + this.b2sum(ukiFullPath));
        bootConfig.add(Config.SPACES + String.valueOf((Object)Limine.CMDLINE) + " " + kernelCmdline);
        bootConfig.add("");
        return bootConfig;
    }

    private String b2sum(String absoluteFilePath) {
        if (Config.ENABLE_VERIFICATION) {
            String b2sum = Utility.computeBlake2(absoluteFilePath);
            if (b2sum.isEmpty()) {
                return "";
            }
            return String.valueOf((Object)Limine.HASH) + b2sum;
        }
        return "";
    }

    private String getDefaultUkiFileName(String kernelName) {
        Object ukiFileName = kernelName;
        if (!kernelName.toLowerCase().endsWith(".efi")) {
            ukiFileName = (String)ukiFileName + ".efi";
        }
        if (Config.UKI_FILE_PREFIX != null && !Config.UKI_FILE_PREFIX.isBlank()) {
            if (!kernelName.startsWith(Config.UKI_FILE_PREFIX)) {
                ukiFileName = Config.UKI_FILE_PREFIX + "_" + (String)ukiFileName;
            }
        } else if (!kernelName.startsWith(this.config.machineID())) {
            ukiFileName = this.config.machineID() + "_" + (String)ukiFileName;
        }
        return ukiFileName;
    }

    public void remove(String kernelName, boolean isUKI) {
        if (kernelName == null || kernelName.isBlank()) {
            return;
        }
        String kernelFilePath = isUKI ? Utility.buildPath("EFI/Linux") + File.separator + this.getDefaultUkiFileName(kernelName) : Utility.buildPath(this.config.machineID(), kernelName) + File.separator;
        Iterator it = this.targetOsNode.getNodes().iterator();
        while (it.hasNext()) {
            LimineEntry entry = new LimineEntry((TreeNode)it.next());
            if (isUKI) {
                if (!entry.containsEfiPath(Limine.DEFAULT_PATH_FUNCTION.toString(), kernelFilePath)) continue;
                it.remove();
                this.isUpdateNeeded = true;
                break;
            }
            if (!entry.containsKernelDirPath(Limine.DEFAULT_PATH_FUNCTION.toString(), kernelFilePath)) continue;
            it.remove();
            this.isUpdateNeeded = true;
            break;
        }
        if (isUKI) {
            String ukiFilePath = Utility.buildPath(this.config.espPath(), "EFI/Linux") + File.separator + this.getDefaultUkiFileName(kernelName);
            if (Utility.isFilePresent(ukiFilePath)) {
                Utility.deleteFile(ukiFilePath);
            }
        } else {
            String dirPath = Utility.buildPath(this.config.espPath(), this.config.machineID(), kernelName);
            if (Utility.isDirectoryPresent(dirPath)) {
                Utility.deleteDirectory(dirPath);
            }
        }
    }

    public void removeEntry(String kernelName) {
        if (kernelName == null || kernelName.isBlank()) {
            return;
        }
        String kernelNameKey = String.valueOf((Object)Limine.SUB_ENTRY_KEY) + kernelName;
        LinkedList<TreeNode> nodes = this.targetOsNode.getNodes();
        for (int i = 0; i < nodes.size(); ++i) {
            TreeNode bootNode = (TreeNode)nodes.get(i);
            if (!bootNode.getName().trim().equals(kernelNameKey)) continue;
            nodes.remove(i);
            this.isUpdateNeeded = true;
            --i;
        }
    }

    private void sortEntriesByBootOrder(List<TreeNode> entries, String[] bootOrder) {
        ArrayList<String> patternsBeforeWildcard = new ArrayList<String>();
        ArrayList<String> patternsAfterWildcard = new ArrayList<String>();
        LinkedHashMap groupedEntries = new LinkedHashMap();
        boolean wildcardFound = false;
        for (String pattern : bootOrder) {
            groupedEntries.put(pattern, new ArrayList());
            if (pattern.trim().equals("*")) {
                wildcardFound = true;
                continue;
            }
            if (wildcardFound) {
                patternsAfterWildcard.add(pattern);
                continue;
            }
            patternsBeforeWildcard.add(pattern);
        }
        if (!wildcardFound) {
            groupedEntries.put("*", new ArrayList());
        }
        for (TreeNode treeNode : entries) {
            String regex;
            boolean matched = false;
            for (String pattern : patternsAfterWildcard) {
                regex = pattern.replace("*", ".*");
                if (!Pattern.matches(regex, treeNode.getCleanName())) continue;
                ((List)groupedEntries.get(pattern)).add(treeNode);
                matched = true;
                break;
            }
            if (!matched) {
                for (String pattern : patternsBeforeWildcard) {
                    regex = pattern.replace("*", ".*");
                    if (!Pattern.matches(regex, treeNode.getCleanName())) continue;
                    ((List)groupedEntries.get(pattern)).add(treeNode);
                    matched = true;
                    break;
                }
            }
            if (matched) continue;
            ((List)groupedEntries.get("*")).add(treeNode);
        }
        entries.clear();
        for (Map.Entry entry : groupedEntries.entrySet()) {
            if (Config.ENABLE_SORT && ((String)entry.getKey()).contains("*")) {
                ((List)entry.getValue()).sort(TreeNode::compareTo);
            }
            entries.addAll((Collection)entry.getValue());
        }
    }
}

