/*
 * Decompiled with CFR 0.152.
 */
package org.limine.entry.tool.processes;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.limine.entry.tool.formats.limine8.Limine;
import org.limine.entry.tool.objects.Config;
import org.limine.entry.tool.objects.Output;
import org.limine.entry.tool.processes.Utility;

public class ConfigReader {
    private final Map<String, String> configs = new HashMap<String, String>();
    private final Map<String, String> kernelCmdlineMap = new HashMap<String, String>();

    public ConfigReader() {
        this.loadConfigDir("/usr/share/limine-entry-tool.d");
        this.loadConfigFile("/etc/limine-entry-tool.conf");
        this.loadConfigDir("/etc/limine-entry-tool.d");
        this.loadConfigFile("/etc/default/limine");
    }

    private void loadConfigDir(String dirPath) {
        Path dir = Paths.get(dirPath, new String[0]);
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> stream = Files.list(dir);){
            stream.filter(p -> p.getFileName().toString().endsWith(".conf") && Files.isRegularFile(p, new LinkOption[0])).sorted(Comparator.comparing(Path::getFileName)).forEach(p -> this.loadConfigFile(p.toString()));
        }
        catch (IOException e) {
            Utility.exitWithError("Failed to load config directory:", dirPath + " due to " + e.getMessage());
        }
    }

    private void loadConfigFile(String filePath) {
        Path path = Paths.get(filePath, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(path);){
            String line;
            while ((line = reader.readLine()) != null) {
                String value;
                String key;
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                boolean append = false;
                int appendIndex = line.indexOf("+=");
                int eqIndex = line.indexOf(61);
                if (appendIndex != -1) {
                    key = line.substring(0, appendIndex).trim();
                    value = Utility.removeSurrounding(line.substring(appendIndex + 2).trim(), "\"");
                    append = true;
                } else {
                    if (eqIndex == -1) continue;
                    key = line.substring(0, eqIndex).trim();
                    value = Utility.removeSurrounding(line.substring(eqIndex + 1).trim(), "\"");
                }
                if (this.parseKernelCmdline(key, value, append)) continue;
                this.configs.put(key, value);
            }
        }
        catch (IOException e) {
            Utility.exitWithError("Failed to load config file:", filePath + " due to " + e.getMessage());
        }
    }

    private boolean parseKernelCmdline(String key, String value, boolean append) {
        String prefix = "KERNEL_CMDLINE";
        if (!key.startsWith("KERNEL_CMDLINE")) {
            return false;
        }
        String targetKey = "default";
        if (key.length() > "KERNEL_CMDLINE".length() && key.charAt("KERNEL_CMDLINE".length()) == '[') {
            int end;
            int start = "KERNEL_CMDLINE".length() + 1;
            if (start > (end = key.indexOf(93, start))) {
                return false;
            }
            String extractedKey = key.substring(start, end).trim();
            if (!(extractedKey = Utility.removeSurrounding(extractedKey, "\"")).isEmpty()) {
                targetKey = extractedKey;
            }
        } else if (key.length() != "KERNEL_CMDLINE".length()) {
            return false;
        }
        if (append && this.kernelCmdlineMap.containsKey(targetKey)) {
            this.kernelCmdlineMap.compute(targetKey, (k, existing) -> value + " " + existing);
        } else {
            this.kernelCmdlineMap.put(targetKey, value);
        }
        return true;
    }

    public Config readConfig() {
        String enableSort;
        String bootOrder;
        String configBackupThreshold;
        String enableVerification;
        Output output;
        String espPath;
        boolean quiet = "yes".equalsIgnoreCase(this.configs.get("QUIET_MODE"));
        Config.QUIET = Config.QUIET || quiet;
        String targetOs = this.configs.get("TARGET_OS_NAME");
        targetOs = targetOs == null || targetOs.isBlank() ? Utility.getLinuxDistroName() : Utility.cleanName(targetOs);
        String defaultCmdline = this.kernelCmdlineMap.get("default");
        if (defaultCmdline == null || defaultCmdline.isBlank()) {
            this.kernelCmdlineMap.put("default", Utility.readKernelCmdline());
        }
        if (((espPath = this.configs.get("ESP_PATH")) == null || espPath.isBlank()) && Utility.isSystemEfi() && Utility.isCommandPresent("bootctl") && (output = Utility.getTextFromCommand("bootctl --print-esp-path", false, false)).isSuccess()) {
            espPath = output.text().get(0);
        }
        if (espPath == null || espPath.isBlank()) {
            Utility.exitWithError("No ESP_PATH. Please set ESP_PATH in /etc/default/limine");
            return null;
        }
        if (!Utility.validateFatPartition(espPath = Utility.buildPath(espPath))) {
            Utility.exitWithError("Incorrect config: \"" + espPath + "\" is not an ESP path. Please correct the config /etc/default/limine to set your value in ESP_PATH.");
            return null;
        }
        String spaceNumber = this.configs.get("SPACE_NUMBER");
        if (spaceNumber != null) {
            try {
                StringBuilder spaces = new StringBuilder();
                for (int number = Integer.parseInt(spaceNumber); number > 0; --number) {
                    spaces.append(" ");
                }
                Config.SPACES = spaces.toString();
            }
            catch (NumberFormatException ignored) {
                Utility.errorMessage("Value of SPACE_NUMBER should be a number and not a word!");
            }
        }
        if ((enableVerification = this.configs.get("ENABLE_VERIFICATION")) != null) {
            Config.ENABLE_VERIFICATION = "yes".equalsIgnoreCase(enableVerification);
        }
        if ((configBackupThreshold = this.configs.get("CONFIG_BACKUP_THRESHOLD")) != null) {
            try {
                Config.CONFIG_BACKUP_THRESHOLD = Integer.parseInt(configBackupThreshold);
            }
            catch (NumberFormatException e) {
                Utility.errorMessage("CONFIG_BACKUP_THRESHOLD=" + configBackupThreshold + " is invalid, it should be in hours format.");
            }
        }
        if ((bootOrder = this.configs.get("BOOT_ORDER")) != null && !bootOrder.isBlank()) {
            Config.BOOT_ORDER = (String[])Arrays.stream(bootOrder.split(",")).map(String::trim).toArray(String[]::new);
        }
        if ((enableSort = this.configs.get("ENABLE_SORT")) != null && "yes".equalsIgnoreCase(enableSort)) {
            Config.ENABLE_SORT = true;
        }
        String machineID = Utility.readMachineID();
        String customUkiName = this.configs.get("CUSTOM_UKI_NAME");
        Pattern validName = Pattern.compile("^[a-z0-9]+$");
        Config.UKI_FILE_PREFIX = customUkiName != null && !customUkiName.isBlank() && validName.matcher(customUkiName).matches() ? customUkiName : machineID;
        return new Config(machineID, targetOs, espPath, this.kernelCmdlineMap, Limine.DEFAULT_PATH_FUNCTION.toString());
    }
}

