/*
 * Decompiled with CFR 0.152.
 */
package org.limine.entry.tool.objects;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EntryOptions {
    private String machineID = null;
    private int orderPriority = 50;
    private boolean entryOverwrite = false;

    public void parseComment(String comment) {
        Pattern orderPriorityPattern;
        Matcher orderPriorityMatcher;
        if (comment == null || comment.isBlank()) {
            return;
        }
        comment = comment.toLowerCase();
        Pattern machineIdPattern = Pattern.compile(String.valueOf((Object)Key.MACHINE_ID) + "([a-f0-9]{32})");
        Matcher machineIdMatcher = machineIdPattern.matcher(comment);
        if (machineIdMatcher.find()) {
            this.machineID = machineIdMatcher.group(1);
        }
        if ((orderPriorityMatcher = (orderPriorityPattern = Pattern.compile(String.valueOf((Object)Key.ORDER_PRIORITY) + "(\\d{1,8})")).matcher(comment)).find()) {
            this.orderPriority = Integer.parseInt(orderPriorityMatcher.group(1));
        }
    }

    public boolean parseArg(String arg, Key optionName) {
        if (Key.ORDER_PRIORITY.equals((Object)optionName)) {
            Pattern orderPriorityPattern = Pattern.compile("(\\d{1,8})");
            Matcher orderPriorityMatcher = orderPriorityPattern.matcher(arg);
            if (orderPriorityMatcher.find()) {
                this.orderPriority = Integer.parseInt(orderPriorityMatcher.group(1));
                return true;
            }
            return false;
        }
        return false;
    }

    public int getPriority() {
        return this.orderPriority;
    }

    public EntryOptions setPriority(int priority) {
        this.orderPriority = priority;
        return this;
    }

    public String getMachineID() {
        return this.machineID;
    }

    public EntryOptions setMachineID(String machineID) {
        this.machineID = machineID;
        return this;
    }

    public boolean getEntryOverwrite() {
        return this.entryOverwrite;
    }

    public EntryOptions setEntryOverwrite(boolean entryOverwrite) {
        this.entryOverwrite = entryOverwrite;
        return this;
    }

    public String buildEntryComment() {
        StringBuilder comment = new StringBuilder();
        if (this.machineID != null) {
            comment.append((Object)Key.MACHINE_ID).append(this.machineID).append(" ");
        }
        comment.append((Object)Key.ORDER_PRIORITY).append(this.orderPriority).append(" ");
        return comment.toString();
    }

    public static enum Key {
        MACHINE_ID("machine-id="),
        ORDER_PRIORITY("order-priority=");

        private final String key;

        private Key(String key) {
            this.key = key;
        }

        public String toString() {
            return this.key;
        }
    }
}

