import { OAIEngine } from './OAIEngine';
/**
 * Base OAI Remote Inference Provider
 * Added the implementation of loading and unloading model (applicable to local inference providers)
 */
export declare abstract class RemoteOAIEngine extends OAIEngine {
    apiKey?: string;
    /**
     * On extension load, subscribe to events.
     */
    onLoad(): void;
    /**
     * Headers for the inference request
     */
    headers(): Promise<HeadersInit>;
}
