import { AIEngine } from './AIEngine';
import { MessageRequest, Model } from '../../../types';
/**
 * Base OAI Inference Provider
 * Applicable to all OAI compatible inference providers
 */
export declare abstract class OAIEngine extends AIEngine {
    abstract inferenceUrl: string;
    controller: AbortController;
    isCancelled: boolean;
    loadedModel: Model | undefined;
    transformPayload?: Function;
    transformResponse?: Function;
    /**
     * On extension load, subscribe to events.
     */
    onLoad(): void;
    /**
     * On extension unload
     */
    onUnload(): void;
    inference(data: MessageRequest): void;
    /**
     * Stops the inference.
     */
    stopInference(): void;
    /**
     * Headers for the inference request
     */
    headers(): Promise<HeadersInit>;
}
