import { Model } from '../../../types';
import { OAIEngine } from './OAIEngine';
/**
 * Base OAI Local Inference Provider
 * Added the implementation of loading and unloading model (applicable to local inference providers)
 */
export declare abstract class LocalOAIEngine extends OAIEngine {
    abstract nodeModule: string;
    loadModelFunctionName: string;
    unloadModelFunctionName: string;
    /**
     * This class represents a base for local inference providers in the OpenAI architecture.
     * It extends the OAIEngine class and provides the implementation of loading and unloading models locally.
     * The loadModel function subscribes to the ModelEvent.OnModelInit event, loading models when initiated.
     * The unloadModel function subscribes to the ModelEvent.OnModelStop event, unloading models when stopped.
     */
    onLoad(): void;
    /**
     * Load the model.
     */
    loadModel(model: Model & {
        file_path?: string;
    }): Promise<void>;
    /**
     * Stops the model.
     */
    unloadModel(model?: Model): Promise<void>;
}
