import { AIEngine } from './AIEngine';
/**
 * Manages the registration and retrieval of inference engines.
 */
export declare class EngineManager {
    engines: Map<string, AIEngine>;
    controller: AbortController | null;
    /**
     * Registers an engine.
     * @param engine - The engine to register.
     */
    register<T extends AIEngine>(engine: T): void;
    /**
     * Retrieves a engine by provider.
     * @param provider - The name of the engine to retrieve.
     * @returns The engine, if found.
     */
    get<T extends AIEngine>(provider: string): T | undefined;
    /**
     * The instance of the engine manager.
     */
    static instance(): EngineManager;
}
