/**
 * Gets Jan's data folder path.
 *
 * @returns {Promise<string>} A Promise that resolves with Jan's data folder path.
 */
declare const getJanDataFolderPath: () => Promise<string>;
/**
 * Opens the file explorer at a specific path.
 * @param {string} path - The path to open in the file explorer.
 * @returns {Promise<any>} A promise that resolves when the file explorer is opened.
 */
declare const openFileExplorer: (path: string) => Promise<any>;
/**
 * Joins multiple paths together.
 * @param paths - The paths to join.
 * @returns {Promise<string>} A promise that resolves with the joined path.
 */
declare const joinPath: (args: string[]) => Promise<string>;
/**
 * Get dirname of a file path.
 * @param path - The file path to retrieve dirname.
 * @returns {Promise<string>} A promise that resolves the dirname.
 */
declare const dirName: (path: string) => Promise<string>;
/**
 * Retrieve the basename from an url.
 * @param path - The path to retrieve.
 * @returns {Promise<string>} A promise that resolves with the basename.
 */
declare const baseName: (paths: string) => Promise<string>;
/**
 * Opens an external URL in the default web browser.
 *
 * @param {string} url - The URL to open.
 * @returns {Promise<any>} - A promise that resolves when the URL has been successfully opened.
 */
declare const openExternalUrl: (url: string) => Promise<any>;
/**
 * Gets the resource path of the application.
 *
 * @returns {Promise<string>} - A promise that resolves with the resource path.
 */
declare const getResourcePath: () => Promise<string>;
/**
 * Gets the user's home path.
 * @returns return user's home path
 */
declare const getUserHomePath: () => Promise<string>;
/**
 * Log to file from browser processes.
 *
 * @param message - Message to log.
 */
declare const log: (message: string, fileName?: string) => void;
/**
 * Check whether the path is a subdirectory of another path.
 *
 * @param from - The path to check.
 * @param to - The path to check against.
 *
 * @returns {Promise<boolean>} - A promise that resolves with a boolean indicating whether the path is a subdirectory.
 */
declare const isSubdirectory: (from: string, to: string) => Promise<boolean>;
/**
 * Show toast message from browser processes.
 * @param title
 * @param message
 * @returns
 */
declare const showToast: (title: string, message: string) => void;
/**
 * Register extension point function type definition
 */
export type RegisterExtensionPoint = (extensionName: string, extensionId: string, method: Function, priority?: number) => void;
/**
 * Functions exports
 */
export { getJanDataFolderPath, openFileExplorer, getResourcePath, joinPath, openExternalUrl, baseName, log, isSubdirectory, getUserHomePath, showToast, dirName, };
