import { __awaiter } from "tslib";
import { AIEngine } from './AIEngine';
import { InferenceEvent, MessageEvent, } from '../../../types';
import { events } from '../../events';
/**
 * Base OAI Inference Provider
 * Applicable to all OAI compatible inference providers
 */
export class OAIEngine extends AIEngine {
    constructor() {
        super(...arguments);
        // Controller to handle stop requests
        this.controller = new AbortController();
        this.isCancelled = false;
    }
    /**
     * On extension load, subscribe to events.
     */
    onLoad() {
        super.onLoad();
        events.on(MessageEvent.OnMessageSent, (data) => this.inference(data));
        events.on(InferenceEvent.OnInferenceStopped, () => this.stopInference());
    }
    /**
     * On extension unload
     */
    onUnload() { }
    inference(data) { }
    /**
     * Stops the inference.
     */
    stopInference() {
        var _a;
        this.isCancelled = true;
        (_a = this.controller) === null || _a === void 0 ? void 0 : _a.abort();
    }
    /**
     * Headers for the inference request
     */
    headers() {
        return __awaiter(this, void 0, void 0, function* () {
            return {};
        });
    }
}
//# sourceMappingURL=OAIEngine.js.map