import { __awaiter } from "tslib";
import { events } from '../../events';
import { ModelEvent } from '../../../types';
import { OAIEngine } from './OAIEngine';
/**
 * Base OAI Local Inference Provider
 * Added the implementation of loading and unloading model (applicable to local inference providers)
 */
export class LocalOAIEngine extends OAIEngine {
    constructor() {
        super(...arguments);
        this.loadModelFunctionName = 'loadModel';
        this.unloadModelFunctionName = 'unloadModel';
    }
    /**
     * This class represents a base for local inference providers in the OpenAI architecture.
     * It extends the OAIEngine class and provides the implementation of loading and unloading models locally.
     * The loadModel function subscribes to the ModelEvent.OnModelInit event, loading models when initiated.
     * The unloadModel function subscribes to the ModelEvent.OnModelStop event, unloading models when stopped.
     */
    onLoad() {
        super.onLoad();
        // These events are applicable to local inference providers
        events.on(ModelEvent.OnModelInit, (model) => this.loadModel(model));
        events.on(ModelEvent.OnModelStop, (model) => this.unloadModel(model));
    }
    /**
     * Load the model.
     */
    loadModel(model) {
        return __awaiter(this, void 0, void 0, function* () {
            // Implementation of loading the model
        });
    }
    /**
     * Stops the model.
     */
    unloadModel(model) {
        return __awaiter(this, void 0, void 0, function* () {
            // Implementation of unloading the model
        });
    }
}
//# sourceMappingURL=LocalOAIEngine.js.map