#!/usr/sbin/bash
#
#   xdata.sh - Check the 'xdata' array conforms to requirements.
#
#   Copyright (c) 2014-2025 Pacman Development Team <pacman-dev@lists.archlinux.org>
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

[[ -n "$LIBMAKEPKG_LINT_PKGBUILD_XDATA_SH" ]] && return
LIBMAKEPKG_LINT_PKGBUILD_XDATA_SH=1

MAKEPKG_LIBRARY=${MAKEPKG_LIBRARY:-'/usr/share/makepkg'}

source "$MAKEPKG_LIBRARY/util/message.sh"
source "$MAKEPKG_LIBRARY/util/pkgbuild.sh"


lint_pkgbuild_functions+=('lint_xdata')


lint_xdata() {
	local xdata_list entry key value ret=0

	get_pkgbuild_all_split_attributes xdata xdata_list

	for entry in "${xdata_list[@]}"; do
		key="${entry%%=*}"
		value="${entry##*=}"

		if [[ "${entry}" == "${key}=${value}" ]]; then
			# Entries must contain exactly one equal sign.
			error "$(gettext "%s array: Entries must contain exactly one equal sign, e.g. key=value.")" "xdata"
			ret=1
		elif [[ "${key}" == '' ]]; then
			# Do not allow keys without values.
			error "$(gettext "%s array: The key part of an entry must not be empty.")" "xdata"
			ret=1
		elif [[ "${key}" == "pkgtype" ]]; then
			# The key "pkgtype" is reserved for makepkg.
			error "$(gettext "%s array: The key 'pkgtype' is reserved for makepkg.")" "xdata"
			ret=1
		fi
	done

	return $ret
}
