/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.AbstractManifestData;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.TaskManifest;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.ManifestStoreOperations;
import org.apache.hadoop.util.JsonSerialization;

@InterfaceAudience.LimitedPrivate(value={"mapreduce, object-stores"})
@InterfaceStability.Unstable
public class ManifestStoreOperationsThroughFileSystem
extends ManifestStoreOperations {
    private FileSystem fileSystem;
    private boolean msyncUnsupported = false;

    public ManifestStoreOperationsThroughFileSystem(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public ManifestStoreOperationsThroughFileSystem() {
    }

    @Override
    public void close() throws IOException {
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public void bindToFileSystem(FileSystem filesystem, Path path) throws IOException {
        this.fileSystem = filesystem;
    }

    @Override
    public FileStatus getFileStatus(Path path) throws IOException {
        return this.fileSystem.getFileStatus(path);
    }

    @Override
    public boolean isFile(Path path) throws IOException {
        return this.fileSystem.isFile(path);
    }

    @Override
    public boolean delete(Path path, boolean recursive) throws IOException {
        return this.fileSystem.delete(path, recursive);
    }

    @Override
    public boolean mkdirs(Path path) throws IOException {
        return this.fileSystem.mkdirs(path);
    }

    @Override
    public boolean renameFile(Path source, Path dest) throws IOException {
        return this.fileSystem.rename(source, dest);
    }

    @Override
    public RemoteIterator<FileStatus> listStatusIterator(Path path) throws IOException {
        return this.fileSystem.listStatusIterator(path);
    }

    @Override
    public TaskManifest loadTaskManifest(JsonSerialization<TaskManifest> serializer, FileStatus st) throws IOException {
        return TaskManifest.load(serializer, this.fileSystem, st.getPath(), st);
    }

    @Override
    public <T extends AbstractManifestData<T>> void save(T manifestData, Path path, boolean overwrite) throws IOException {
        manifestData.save(this.fileSystem, path, overwrite);
    }

    @Override
    public boolean storePreservesEtagsThroughRenames(Path path) {
        try {
            return this.fileSystem.hasPathCapability(path, "fs.capability.etags.preserved.in.rename");
        }
        catch (IOException ignored) {
            return false;
        }
    }

    @Override
    public void msync(Path path) throws IOException {
        if (this.msyncUnsupported) {
            return;
        }
        this.fileSystem.makeQualified(path);
        try {
            this.fileSystem.msync();
        }
        catch (UnsupportedOperationException ignored) {
            this.msyncUnsupported = true;
        }
    }
}

