"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _configSchema = require("@osd/config-schema");
var _helpers = require("../services/utils/helpers");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(services, router, dataSourceEnabled) {
  const {
    crossClusterService
  } = services;
  const fieldValidations = {
    indexes: _configSchema.schema.string(),
    include_mappings: _configSchema.schema.maybe(_configSchema.schema.boolean())
  };
  router.get({
    path: '/api/alerting/remote/indexes',
    validate: {
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled, fieldValidations)
    }
  }, crossClusterService.getRemoteIndexes);
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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