/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.keybinding;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.common.VerificationException;
import org.keycloak.common.util.Base64;
import org.keycloak.crypto.KeyUse;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.SignatureProvider;
import org.keycloak.crypto.SignatureVerifierContext;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jwk.JWKBuilder;
import org.keycloak.jose.jwk.JWKParser;
import org.keycloak.jose.jws.JWSHeader;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oid4vc.issuance.OID4VCIssuerWellKnownProvider;
import org.keycloak.protocol.oid4vc.issuance.VCIssuanceContext;
import org.keycloak.protocol.oid4vc.issuance.VCIssuerException;
import org.keycloak.protocol.oid4vc.issuance.keybinding.AttestationKeyResolver;
import org.keycloak.protocol.oid4vc.issuance.keybinding.CNonceHandler;
import org.keycloak.protocol.oid4vc.model.ISO18045ResistanceLevel;
import org.keycloak.protocol.oid4vc.model.KeyAttestationJwtBody;
import org.keycloak.protocol.oid4vc.model.KeyAttestationsRequired;
import org.keycloak.protocol.oid4vc.model.SupportedProofTypeData;
import org.keycloak.services.clientpolicy.executor.FapiConstant;
import org.keycloak.util.JsonSerialization;

public class AttestationValidatorUtil {
    public static final String ATTESTATION_JWT_TYP = "key-attestation+jwt ";
    private static final String CACERTS_PATH = System.getProperty("javax.net.ssl.trustStore", System.getProperty("java.home") + "/lib/security/cacerts");
    private static final char[] DEFAULT_TRUSTSTORE_PASSWORD = System.getProperty("javax.net.ssl.trustStorePassword", "changeit").toCharArray();

    public static KeyAttestationJwtBody validateAttestationJwt(String attestationJwt, KeycloakSession keycloakSession, VCIssuanceContext vcIssuanceContext, AttestationKeyResolver keyResolver) throws IOException, JWSInputException, VerificationException {
        SignatureVerifierContext verifier;
        KeyAttestationJwtBody attestationBody;
        if (attestationJwt == null || attestationJwt.split("\\.").length != 3) {
            throw new VCIssuerException("Invalid JWT format");
        }
        JWSInput jwsInput = new JWSInput(attestationJwt);
        String payloadString = new String(jwsInput.getContent(), StandardCharsets.UTF_8);
        try {
            JsonSerialization.mapper.readTree(payloadString);
        }
        catch (JsonProcessingException e) {
            throw new VCIssuerException("Invalid JSON in attestation payload: " + payloadString, e);
        }
        try {
            attestationBody = (KeyAttestationJwtBody)JsonSerialization.readValue((byte[])jwsInput.getContent(), KeyAttestationJwtBody.class);
        }
        catch (IOException e) {
            throw new VCIssuerException("Invalid attestation payload format", e);
        }
        JWSHeader header = jwsInput.getHeader();
        AttestationValidatorUtil.validateJwsHeader(header);
        Map rawHeader = (Map)JsonSerialization.mapper.convertValue((Object)jwsInput.getHeader(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        if (header.getX5c() != null && !header.getX5c().isEmpty()) {
            verifier = AttestationValidatorUtil.verifierFromX5CChain(header.getX5c(), header.getAlgorithm().name(), keycloakSession);
        } else if (header.getKeyId() != null) {
            JWK resolvedJwk = keyResolver.resolveKey(header.getKeyId(), rawHeader, (Map)JsonSerialization.mapper.convertValue((Object)attestationBody, Map.class));
            verifier = AttestationValidatorUtil.verifierFromResolvedJWK(resolvedJwk, header.getAlgorithm().name(), keycloakSession);
        } else {
            throw new VCIssuerException("Neither x5c nor kid present in attestation JWT header");
        }
        if (!verifier.verify(jwsInput.getEncodedSignatureInput().getBytes(StandardCharsets.UTF_8), jwsInput.getSignature())) {
            throw new VCIssuerException("Could not verify signature of attestation JWT");
        }
        AttestationValidatorUtil.validateAttestationPayload(keycloakSession, vcIssuanceContext, attestationBody);
        if (attestationBody.getAttestedKeys() == null) {
            throw new VCIssuerException("Missing required attested_keys claim in attestation");
        }
        return attestationBody;
    }

    private static void validateAttestationPayload(KeycloakSession keycloakSession, VCIssuanceContext vcIssuanceContext, KeyAttestationJwtBody attestationBody) throws VCIssuerException, VerificationException {
        if (attestationBody.getIat() == null) {
            throw new VCIssuerException("Missing 'iat' claim in attestation");
        }
        if (attestationBody.getNonce() == null) {
            throw new VCIssuerException("Missing 'nonce' in attestation");
        }
        CNonceHandler cNonceHandler = (CNonceHandler)keycloakSession.getProvider(CNonceHandler.class);
        if (cNonceHandler == null) {
            throw new VCIssuerException("No CNonceHandler available");
        }
        KeyAttestationsRequired attestationRequirements = AttestationValidatorUtil.getAttestationRequirements(vcIssuanceContext);
        if (attestationBody.getKeyStorage() != null) {
            AttestationValidatorUtil.validateResistanceLevel(attestationBody.getKeyStorage(), attestationRequirements != null ? attestationRequirements.getKeyStorage() : null, "key_storage");
        }
        if (attestationBody.getUserAuthentication() != null) {
            AttestationValidatorUtil.validateResistanceLevel(attestationBody.getUserAuthentication(), attestationRequirements != null ? attestationRequirements.getUserAuthentication() : null, "user_authentication");
        }
        cNonceHandler.verifyCNonce(attestationBody.getNonce(), List.of(OID4VCIssuerWellKnownProvider.getCredentialsEndpoint(keycloakSession.getContext())), Map.of("source_endpoint", OID4VCIssuerWellKnownProvider.getNonceEndpoint(keycloakSession.getContext())));
        if (attestationBody.getAttestedKeys() != null) {
            vcIssuanceContext.setAttestedKeys(attestationBody.getAttestedKeys());
        }
    }

    private static KeyAttestationsRequired getAttestationRequirements(VCIssuanceContext vcIssuanceContext) {
        if (vcIssuanceContext.getCredentialConfig() == null || vcIssuanceContext.getCredentialConfig().getProofTypesSupported() == null || vcIssuanceContext.getCredentialConfig().getProofTypesSupported().getSupportedProofTypes() == null) {
            return null;
        }
        SupportedProofTypeData proofTypeData = vcIssuanceContext.getCredentialConfig().getProofTypesSupported().getSupportedProofTypes().get("jwt");
        return proofTypeData != null ? proofTypeData.getKeyAttestationsRequired() : null;
    }

    private static void validateResistanceLevel(List<String> actualLevels, List<ISO18045ResistanceLevel> requiredLevels, String levelType) throws VCIssuerException {
        if (requiredLevels == null || requiredLevels.isEmpty()) {
            for (String level : actualLevels) {
                try {
                    ISO18045ResistanceLevel.fromValue(level);
                }
                catch (Exception e) {
                    throw new VCIssuerException("Invalid " + levelType + " level: " + level);
                }
            }
            return;
        }
        Set requiredLevelValues = requiredLevels.stream().map(ISO18045ResistanceLevel::getValue).collect(Collectors.toSet());
        for (String level : actualLevels) {
            try {
                ISO18045ResistanceLevel levelEnum = ISO18045ResistanceLevel.fromValue(level);
                if (requiredLevelValues.contains(levelEnum.getValue())) continue;
                throw new VCIssuerException(levelType + " level '" + level + "' is not accepted by credential issuer. Allowed values: " + String.valueOf(requiredLevelValues));
            }
            catch (IllegalArgumentException e) {
                throw new VCIssuerException("Invalid " + levelType + " level: " + level);
            }
        }
    }

    private static void validateJwsHeader(JWSHeader header) {
        String alg = Optional.ofNullable(header.getAlgorithm()).map(Enum::name).orElseThrow(() -> new VCIssuerException("Missing algorithm in JWS header"));
        if ("none".equalsIgnoreCase(alg)) {
            throw new VCIssuerException("'none' algorithm is not allowed");
        }
        if (!FapiConstant.ALLOWED_ALGORITHMS.contains(alg)) {
            throw new VCIssuerException("Unsupported algorithm: " + alg + ". Allowed algorithms: " + String.valueOf(FapiConstant.ALLOWED_ALGORITHMS));
        }
        if (!ATTESTATION_JWT_TYP.equals(header.getType())) {
            throw new VCIssuerException("Invalid JWT typ: expected key-attestation+jwt ");
        }
    }

    private static SignatureVerifierContext verifierFromX5CChain(List<String> x5cList, String alg, KeycloakSession keycloakSession) throws VCIssuerException {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ArrayList<X509Certificate> certChain = new ArrayList<X509Certificate>();
            for (String certBase64 : x5cList) {
                byte[] certBytes = Base64.decode((String)certBase64);
                try (ByteArrayInputStream in = new ByteArrayInputStream(certBytes);){
                    certChain.add((X509Certificate)cf.generateCertificate(in));
                }
            }
            CertPath certPath = cf.generateCertPath(certChain);
            X509Certificate firstCert = (X509Certificate)certChain.get(0);
            boolean isSelfSigned = firstCert.getSubjectX500Principal().equals(firstCert.getIssuerX500Principal());
            if (!isSelfSigned) {
                CertPathValidator validator = CertPathValidator.getInstance("PKIX");
                PKIXParameters params = new PKIXParameters(AttestationValidatorUtil.getTrustAnchors());
                params.setRevocationEnabled(false);
                validator.validate(certPath, params);
            }
            PublicKey publicKey = ((X509Certificate)certChain.get(0)).getPublicKey();
            JWK certJwk = AttestationValidatorUtil.convertPublicKeyToJWK(publicKey, alg, certChain);
            return AttestationValidatorUtil.verifierFromResolvedJWK(certJwk, alg, keycloakSession);
        }
        catch (Exception e) {
            throw new VCIssuerException("Failed to validate x5c certificate chain", e);
        }
    }

    private static Set<TrustAnchor> getTrustAnchors() throws Exception {
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (FileInputStream in = new FileInputStream(CACERTS_PATH);){
            trustStore.load(in, DEFAULT_TRUSTSTORE_PASSWORD);
        }
        HashSet<TrustAnchor> anchors = new HashSet<TrustAnchor>();
        Enumeration<String> aliases = trustStore.aliases();
        while (aliases.hasMoreElements()) {
            Certificate cert = trustStore.getCertificate(aliases.nextElement());
            if (!(cert instanceof X509Certificate)) continue;
            anchors.add(new TrustAnchor((X509Certificate)cert, null));
        }
        return anchors;
    }

    private static SignatureVerifierContext verifierFromResolvedJWK(JWK jwk, String alg, KeycloakSession session) throws VerificationException {
        SignatureProvider provider = (SignatureProvider)session.getProvider(SignatureProvider.class, alg);
        KeyWrapper wrapper = new KeyWrapper();
        wrapper.setType(jwk.getKeyType());
        wrapper.setAlgorithm(alg);
        wrapper.setUse(KeyUse.SIG);
        if (jwk.getOtherClaims().get("crv") != null) {
            wrapper.setCurve((String)jwk.getOtherClaims().get("crv"));
        }
        wrapper.setPublicKey((Key)JWKParser.create((JWK)jwk).toPublicKey());
        return provider.verifier(wrapper);
    }

    private static JWK convertPublicKeyToJWK(PublicKey key, String alg, List<X509Certificate> certChain) {
        if (key instanceof RSAPublicKey) {
            RSAPublicKey rsa = (RSAPublicKey)key;
            return JWKBuilder.create().algorithm(alg).rsa((Key)rsa, certChain);
        }
        if (key instanceof ECPublicKey) {
            ECPublicKey ec = (ECPublicKey)key;
            return JWKBuilder.create().algorithm(alg).ec((Key)ec, certChain, null);
        }
        throw new VCIssuerException("Unsupported public key type in certificate: " + key.getClass().getName());
    }
}

