﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/lexv2-models/LexModelsV2_EXPORTS.h>
#include <aws/lexv2-models/model/TestExecutionResultItems.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace LexModelsV2 {
namespace Model {
class ListTestExecutionResultItemsResult {
 public:
  AWS_LEXMODELSV2_API ListTestExecutionResultItemsResult() = default;
  AWS_LEXMODELSV2_API ListTestExecutionResultItemsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_LEXMODELSV2_API ListTestExecutionResultItemsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The list of results from the test execution.</p>
   */
  inline const TestExecutionResultItems& GetTestExecutionResults() const { return m_testExecutionResults; }
  template <typename TestExecutionResultsT = TestExecutionResultItems>
  void SetTestExecutionResults(TestExecutionResultsT&& value) {
    m_testExecutionResultsHasBeenSet = true;
    m_testExecutionResults = std::forward<TestExecutionResultsT>(value);
  }
  template <typename TestExecutionResultsT = TestExecutionResultItems>
  ListTestExecutionResultItemsResult& WithTestExecutionResults(TestExecutionResultsT&& value) {
    SetTestExecutionResults(std::forward<TestExecutionResultsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A token that indicates whether there are more results to return in a response
   * to the <code>ListTestExecutionResultItems</code> operation. If the
   * <code>nextToken</code> field is present, you send the contents as the
   * <code>nextToken</code> parameter of a <code>ListTestExecutionResultItems</code>
   * operation request to get the next page of results.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListTestExecutionResultItemsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListTestExecutionResultItemsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  TestExecutionResultItems m_testExecutionResults;
  bool m_testExecutionResultsHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace LexModelsV2
}  // namespace Aws
