/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation.models;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import java.time.OffsetDateTime;
import java.util.Base64;

public final class BlockBlobsCommitBlockListHeaders {
    private String xMsVersion;
    private String eTag;
    private byte[] xMsContentCrc64;
    private DateTimeRfc1123 lastModified;
    private String xMsVersionId;
    private String xMsEncryptionKeySha256;
    private String xMsRequestId;
    private Boolean xMsRequestServerEncrypted;
    private String xMsClientRequestId;
    private DateTimeRfc1123 date;
    private byte[] contentMD5;
    private String xMsEncryptionScope;
    private static final HttpHeaderName X_MS_VERSION = HttpHeaderName.fromString((String)"x-ms-version");
    private static final HttpHeaderName X_MS_CONTENT_CRC64 = HttpHeaderName.fromString((String)"x-ms-content-crc64");
    private static final HttpHeaderName X_MS_VERSION_ID = HttpHeaderName.fromString((String)"x-ms-version-id");
    private static final HttpHeaderName X_MS_ENCRYPTION_KEY_SHA256 = HttpHeaderName.fromString((String)"x-ms-encryption-key-sha256");
    private static final HttpHeaderName X_MS_REQUEST_SERVER_ENCRYPTED = HttpHeaderName.fromString((String)"x-ms-request-server-encrypted");
    private static final HttpHeaderName X_MS_ENCRYPTION_SCOPE = HttpHeaderName.fromString((String)"x-ms-encryption-scope");

    public BlockBlobsCommitBlockListHeaders(HttpHeaders rawHeaders) {
        String contentMD5;
        String lastModified;
        this.xMsVersion = rawHeaders.getValue(X_MS_VERSION);
        this.eTag = rawHeaders.getValue(HttpHeaderName.ETAG);
        String xMsContentCrc64 = rawHeaders.getValue(X_MS_CONTENT_CRC64);
        if (xMsContentCrc64 != null) {
            this.xMsContentCrc64 = Base64.getDecoder().decode(xMsContentCrc64);
        }
        if ((lastModified = rawHeaders.getValue(HttpHeaderName.LAST_MODIFIED)) != null) {
            this.lastModified = new DateTimeRfc1123(lastModified);
        }
        this.xMsVersionId = rawHeaders.getValue(X_MS_VERSION_ID);
        this.xMsEncryptionKeySha256 = rawHeaders.getValue(X_MS_ENCRYPTION_KEY_SHA256);
        this.xMsRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_REQUEST_ID);
        String xMsRequestServerEncrypted = rawHeaders.getValue(X_MS_REQUEST_SERVER_ENCRYPTED);
        if (xMsRequestServerEncrypted != null) {
            this.xMsRequestServerEncrypted = Boolean.parseBoolean(xMsRequestServerEncrypted);
        }
        this.xMsClientRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_CLIENT_REQUEST_ID);
        String date = rawHeaders.getValue(HttpHeaderName.DATE);
        if (date != null) {
            this.date = new DateTimeRfc1123(date);
        }
        if ((contentMD5 = rawHeaders.getValue(HttpHeaderName.CONTENT_MD5)) != null) {
            this.contentMD5 = Base64.getDecoder().decode(contentMD5);
        }
        this.xMsEncryptionScope = rawHeaders.getValue(X_MS_ENCRYPTION_SCOPE);
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public BlockBlobsCommitBlockListHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public BlockBlobsCommitBlockListHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public byte[] getXMsContentCrc64() {
        return CoreUtils.clone((byte[])this.xMsContentCrc64);
    }

    public BlockBlobsCommitBlockListHeaders setXMsContentCrc64(byte[] xMsContentCrc64) {
        this.xMsContentCrc64 = CoreUtils.clone((byte[])xMsContentCrc64);
        return this;
    }

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public BlockBlobsCommitBlockListHeaders setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public String getXMsVersionId() {
        return this.xMsVersionId;
    }

    public BlockBlobsCommitBlockListHeaders setXMsVersionId(String xMsVersionId) {
        this.xMsVersionId = xMsVersionId;
        return this;
    }

    public String getXMsEncryptionKeySha256() {
        return this.xMsEncryptionKeySha256;
    }

    public BlockBlobsCommitBlockListHeaders setXMsEncryptionKeySha256(String xMsEncryptionKeySha256) {
        this.xMsEncryptionKeySha256 = xMsEncryptionKeySha256;
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public BlockBlobsCommitBlockListHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public Boolean isXMsRequestServerEncrypted() {
        return this.xMsRequestServerEncrypted;
    }

    public BlockBlobsCommitBlockListHeaders setXMsRequestServerEncrypted(Boolean xMsRequestServerEncrypted) {
        this.xMsRequestServerEncrypted = xMsRequestServerEncrypted;
        return this;
    }

    public String getXMsClientRequestId() {
        return this.xMsClientRequestId;
    }

    public BlockBlobsCommitBlockListHeaders setXMsClientRequestId(String xMsClientRequestId) {
        this.xMsClientRequestId = xMsClientRequestId;
        return this;
    }

    public OffsetDateTime getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.getDateTime();
    }

    public BlockBlobsCommitBlockListHeaders setDate(OffsetDateTime date) {
        this.date = date == null ? null : new DateTimeRfc1123(date);
        return this;
    }

    public byte[] getContentMD5() {
        return CoreUtils.clone((byte[])this.contentMD5);
    }

    public BlockBlobsCommitBlockListHeaders setContentMD5(byte[] contentMD5) {
        this.contentMD5 = CoreUtils.clone((byte[])contentMD5);
        return this;
    }

    public String getXMsEncryptionScope() {
        return this.xMsEncryptionScope;
    }

    public BlockBlobsCommitBlockListHeaders setXMsEncryptionScope(String xMsEncryptionScope) {
        this.xMsEncryptionScope = xMsEncryptionScope;
        return this;
    }
}

