/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.client;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.SdkBaseException;
import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.model.AmazonSNSException;
import com.amazonaws.services.sns.model.AuthorizationErrorException;
import com.amazonaws.services.sns.model.EndpointDisabledException;
import com.amazonaws.services.sns.model.InternalErrorException;
import com.amazonaws.services.sns.model.InvalidParameterException;
import com.amazonaws.services.sns.model.InvalidParameterValueException;
import com.amazonaws.services.sns.model.InvalidSecurityException;
import com.amazonaws.services.sns.model.KMSAccessDeniedException;
import com.amazonaws.services.sns.model.KMSDisabledException;
import com.amazonaws.services.sns.model.KMSInvalidStateException;
import com.amazonaws.services.sns.model.KMSNotFoundException;
import com.amazonaws.services.sns.model.KMSOptInRequiredException;
import com.amazonaws.services.sns.model.KMSThrottlingException;
import com.amazonaws.services.sns.model.NotFoundException;
import com.amazonaws.services.sns.model.PlatformApplicationDisabledException;
import com.amazonaws.services.sns.model.PublishRequest;
import com.amazonaws.services.sns.model.PublishResult;
import java.util.Arrays;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.notifications.core.credentials.SnsClientFactory;
import org.opensearch.notifications.core.setting.PluginSettings;
import org.opensearch.notifications.core.utils.HelpersKt;
import org.opensearch.notifications.spi.model.DestinationMessageResponse;
import org.opensearch.notifications.spi.model.MessageContent;
import org.opensearch.notifications.spi.model.destination.SnsDestination;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0013H\u0002J\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/opensearch/notifications/core/client/DestinationSnsClient;", "", "snsClientFactory", "Lorg/opensearch/notifications/core/credentials/SnsClientFactory;", "(Lorg/opensearch/notifications/core/credentials/SnsClientFactory;)V", "execute", "Lorg/opensearch/notifications/spi/model/DestinationMessageResponse;", "destination", "Lorg/opensearch/notifications/spi/model/destination/SnsDestination;", "message", "Lorg/opensearch/notifications/spi/model/MessageContent;", "referenceId", "", "getSdkExceptionText", "exception", "Lcom/amazonaws/SdkBaseException;", "getServiceExceptionText", "Lcom/amazonaws/AmazonServiceException;", "getSnsExceptionText", "Lcom/amazonaws/services/sns/model/AmazonSNSException;", "sendMessage", "Lcom/amazonaws/services/sns/model/PublishResult;", "amazonSNS", "Lcom/amazonaws/services/sns/AmazonSNS;", "Companion", "opensearch-notifications-core"})
public final class DestinationSnsClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SnsClientFactory snsClientFactory;
    @NotNull
    private static final Lazy<Logger> log$delegate = HelpersKt.logger(DestinationSnsClient.class);

    public DestinationSnsClient(@NotNull SnsClientFactory snsClientFactory) {
        Intrinsics.checkNotNullParameter((Object)snsClientFactory, (String)"snsClientFactory");
        this.snsClientFactory = snsClientFactory;
    }

    @NotNull
    public final DestinationMessageResponse execute(@NotNull SnsDestination destination, @NotNull MessageContent message, @NotNull String referenceId) {
        DestinationMessageResponse destinationMessageResponse;
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        AmazonSNS amazonSNS = this.snsClientFactory.createSnsClient(destination.getRegion(), destination.getRoleArn());
        try {
            PublishResult result = this.sendMessage(amazonSNS, destination, message);
            destinationMessageResponse = new DestinationMessageResponse(RestStatus.OK.getStatus(), "Success, message id: " + result.getMessageId());
        }
        catch (InvalidParameterException exception) {
            destinationMessageResponse = new DestinationMessageResponse(RestStatus.BAD_REQUEST.getStatus(), this.getSnsExceptionText((AmazonSNSException)((Object)exception)));
        }
        catch (InvalidParameterValueException exception) {
            destinationMessageResponse = new DestinationMessageResponse(RestStatus.BAD_REQUEST.getStatus(), this.getSnsExceptionText((AmazonSNSException)((Object)exception)));
        }
        catch (InternalErrorException exception) {
            destinationMessageResponse = new DestinationMessageResponse(RestStatus.INTERNAL_SERVER_ERROR.getStatus(), this.getSnsExceptionText((AmazonSNSException)((Object)exception)));
        }
        catch (NotFoundException exception) {
            destinationMessageResponse = new DestinationMessageResponse(RestStatus.NOT_FOUND.getStatus(), this.getSnsExceptionText((AmazonSNSException)((Object)exception)));
        }
        catch (EndpointDisabledException exception) {
            destinationMessageResponse = new DestinationMessageResponse(RestStatus.LOCKED.getStatus(), this.getSnsExceptionText((AmazonSNSException)((Object)exception)));
        }
        catch (PlatformApplicationDisabledException exception) {
            destinationMessageResponse = new DestinationMessageResponse(RestStatus.SERVICE_UNAVAILABLE.getStatus(), this.getSnsExceptionText((AmazonSNSException)((Object)exception)));
        }
        catch (AuthorizationErrorException exception) {
            destinationMessageResponse = new DestinationMessageResponse(RestStatus.UNAUTHORIZED.getStatus(), this.getSnsExceptionText((AmazonSNSException)((Object)exception)));
        }
        catch (KMSDisabledException exception) {
            destinationMessageResponse = new DestinationMessageResponse(RestStatus.PRECONDITION_FAILED.getStatus(), this.getSnsExceptionText((AmazonSNSException)((Object)exception)));
        }
        catch (KMSInvalidStateException exception) {
            destinationMessageResponse = new DestinationMessageResponse(RestStatus.PRECONDITION_FAILED.getStatus(), this.getSnsExceptionText((AmazonSNSException)((Object)exception)));
        }
        catch (KMSNotFoundException exception) {
            destinationMessageResponse = new DestinationMessageResponse(RestStatus.PRECONDITION_FAILED.getStatus(), this.getSnsExceptionText((AmazonSNSException)((Object)exception)));
        }
        catch (KMSOptInRequiredException exception) {
            destinationMessageResponse = new DestinationMessageResponse(RestStatus.PRECONDITION_FAILED.getStatus(), this.getSnsExceptionText((AmazonSNSException)((Object)exception)));
        }
        catch (KMSThrottlingException exception) {
            destinationMessageResponse = new DestinationMessageResponse(RestStatus.TOO_MANY_REQUESTS.getStatus(), this.getSnsExceptionText((AmazonSNSException)((Object)exception)));
        }
        catch (KMSAccessDeniedException exception) {
            destinationMessageResponse = new DestinationMessageResponse(RestStatus.UNAUTHORIZED.getStatus(), this.getSnsExceptionText((AmazonSNSException)((Object)exception)));
        }
        catch (InvalidSecurityException exception) {
            destinationMessageResponse = new DestinationMessageResponse(RestStatus.UNAUTHORIZED.getStatus(), this.getSnsExceptionText((AmazonSNSException)((Object)exception)));
        }
        catch (AmazonSNSException exception) {
            destinationMessageResponse = new DestinationMessageResponse(RestStatus.FAILED_DEPENDENCY.getStatus(), this.getSnsExceptionText(exception));
        }
        catch (AmazonServiceException exception) {
            destinationMessageResponse = new DestinationMessageResponse(RestStatus.FAILED_DEPENDENCY.getStatus(), this.getServiceExceptionText(exception));
        }
        catch (SdkBaseException exception) {
            destinationMessageResponse = new DestinationMessageResponse(RestStatus.FAILED_DEPENDENCY.getStatus(), this.getSdkExceptionText(exception));
        }
        return destinationMessageResponse;
    }

    private final String getSnsExceptionText(AmazonSNSException exception) {
        DestinationSnsClient.Companion.getLog().info("notifications-core:SnsException " + exception);
        return "SNS Send Error(" + exception.getStatusCode() + "), SNS status:(" + exception.getErrorType().name() + ")" + exception.getErrorCode() + ":" + exception.getErrorMessage();
    }

    private final String getServiceExceptionText(AmazonServiceException exception) {
        DestinationSnsClient.Companion.getLog().info("notifications-core:SnsException " + exception);
        return "SNS service Error(" + exception.getStatusCode() + "), Service status:(" + exception.getErrorType().name() + ")" + exception.getErrorCode() + ":" + exception.getErrorMessage();
    }

    private final String getSdkExceptionText(SdkBaseException exception) {
        DestinationSnsClient.Companion.getLog().info("notifications-core:SdkException " + exception);
        return "SNS sdk Error, SDK status:" + exception.getMessage();
    }

    @NotNull
    public final PublishResult sendMessage(@NotNull AmazonSNS amazonSNS, @NotNull SnsDestination destination, @NotNull MessageContent message) throws Exception {
        Intrinsics.checkNotNullParameter((Object)amazonSNS, (String)"amazonSNS");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        PublishRequest publishRequest = new PublishRequest().withTopicArn(destination.getTopicArn()).withMessage(message.getTextDescription()).withSubject(message.getTitle());
        Intrinsics.checkNotNullExpressionValue((Object)publishRequest, (String)"withSubject(...)");
        PublishRequest request = publishRequest;
        if (StringsKt.endsWith$default((String)destination.getTopicArn(), (String)".fifo", (boolean)false, (int)2, null)) {
            PublishRequest publishRequest2 = request.withMessageDeduplicationId(UUID.randomUUID().toString());
            String string = "opensearch-%s";
            Object[] objectArray = new Object[]{PluginSettings.INSTANCE.getClusterName()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            publishRequest2.withMessageGroupId(string2);
        }
        PublishResult publishResult = amazonSNS.publish(request);
        Intrinsics.checkNotNullExpressionValue((Object)publishResult, (String)"publish(...)");
        return publishResult;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/opensearch/notifications/core/client/DestinationSnsClient$Companion;", "", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "opensearch-notifications-core"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLog() {
            Lazy lazy = log$delegate;
            return (Logger)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

