/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.sparse.mapper;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

public class MethodComponentContext
implements ToXContentFragment,
Writeable {
    private final String name;
    private final Map<String, Object> parameters;

    public MethodComponentContext(MethodComponentContext methodComponentContext) {
        if (methodComponentContext == null) {
            throw new IllegalArgumentException("MethodComponentContext cannot be null");
        }
        this.name = methodComponentContext.name;
        this.parameters = new HashMap<String, Object>();
        if (methodComponentContext.parameters != null) {
            this.parameters.putAll(methodComponentContext.parameters);
        }
    }

    public MethodComponentContext(StreamInput in, String name) throws IOException {
        this.name = name;
        this.parameters = in.available() > 0 ? in.readMap(StreamInput::readString, StreamInput::readGenericValue) : null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (this.parameters != null) {
            out.writeMap(this.parameters, StreamOutput::writeString, StreamOutput::writeGenericValue);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("name", this.name);
        if (this.parameters == null) {
            builder.field("parameters", (String)null);
        } else {
            builder.startObject("parameters");
            this.parameters.forEach((key, value) -> {
                try {
                    builder.field(key, value);
                }
                catch (IOException ioe) {
                    throw new RuntimeException("Unable to generate xcontent for method component");
                }
            });
            builder.endObject();
        }
        return builder;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MethodComponentContext other = (MethodComponentContext)obj;
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        equalsBuilder.append((Object)this.name, (Object)other.name);
        equalsBuilder.append(this.parameters, other.parameters);
        return equalsBuilder.isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.name).append(this.parameters).toHashCode();
    }

    public Map<String, Object> getParameters() {
        if (this.parameters == null) {
            return Collections.emptyMap();
        }
        return this.parameters;
    }

    public Object getParameter(String key, Object defaultValue) {
        return this.getParameters().getOrDefault(key, defaultValue);
    }

    public Float getFloatParameter(String key, Float defaultValue) {
        Object value = this.getParameter(key, defaultValue);
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        return defaultValue;
    }

    @Generated
    public MethodComponentContext(String name, Map<String, Object> parameters) {
        this.name = name;
        this.parameters = parameters;
    }

    @Generated
    public String getName() {
        return this.name;
    }
}

