/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.impl;

import java.io.Serializable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;

public class CoordinateArraySequence
implements CoordinateSequence,
Serializable {
    private static final long serialVersionUID = -915438501601840650L;
    private int dimension = 3;
    private Coordinate[] coordinates;

    public CoordinateArraySequence(Coordinate[] coordinates) {
        this(coordinates, 3);
    }

    public CoordinateArraySequence(Coordinate[] coordinates, int dimension) {
        this.coordinates = coordinates;
        this.dimension = dimension;
        if (coordinates == null) {
            this.coordinates = new Coordinate[0];
        }
    }

    public CoordinateArraySequence(int size) {
        this.coordinates = new Coordinate[size];
        for (int i = 0; i < size; ++i) {
            this.coordinates[i] = new Coordinate();
        }
    }

    public CoordinateArraySequence(int size, int dimension) {
        this.coordinates = new Coordinate[size];
        this.dimension = dimension;
        for (int i = 0; i < size; ++i) {
            this.coordinates[i] = new Coordinate();
        }
    }

    public CoordinateArraySequence(CoordinateSequence coordSeq) {
        if (coordSeq == null) {
            this.coordinates = new Coordinate[0];
            return;
        }
        this.dimension = coordSeq.getDimension();
        this.coordinates = new Coordinate[coordSeq.size()];
        for (int i = 0; i < this.coordinates.length; ++i) {
            this.coordinates[i] = coordSeq.getCoordinateCopy(i);
        }
    }

    public int getDimension() {
        return this.dimension;
    }

    public Coordinate getCoordinate(int i) {
        return this.coordinates[i];
    }

    public Coordinate getCoordinateCopy(int i) {
        return new Coordinate(this.coordinates[i]);
    }

    public void getCoordinate(int index, Coordinate coord) {
        coord.x = this.coordinates[index].x;
        coord.y = this.coordinates[index].y;
        coord.z = this.coordinates[index].z;
    }

    public double getX(int index) {
        return this.coordinates[index].x;
    }

    public double getY(int index) {
        return this.coordinates[index].y;
    }

    public double getOrdinate(int index, int ordinateIndex) {
        switch (ordinateIndex) {
            case 0: {
                return this.coordinates[index].x;
            }
            case 1: {
                return this.coordinates[index].y;
            }
            case 2: {
                return this.coordinates[index].z;
            }
        }
        return Double.NaN;
    }

    public Object clone() {
        return this.copy();
    }

    public CoordinateArraySequence copy() {
        Coordinate[] cloneCoordinates = new Coordinate[this.size()];
        for (int i = 0; i < this.coordinates.length; ++i) {
            cloneCoordinates[i] = this.coordinates[i].copy();
        }
        return new CoordinateArraySequence(cloneCoordinates, this.dimension);
    }

    public int size() {
        return this.coordinates.length;
    }

    public void setOrdinate(int index, int ordinateIndex, double value) {
        switch (ordinateIndex) {
            case 0: {
                this.coordinates[index].x = value;
                break;
            }
            case 1: {
                this.coordinates[index].y = value;
                break;
            }
            case 2: {
                this.coordinates[index].z = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid ordinateIndex");
            }
        }
    }

    public Coordinate[] toCoordinateArray() {
        return this.coordinates;
    }

    public Envelope expandEnvelope(Envelope env) {
        for (int i = 0; i < this.coordinates.length; ++i) {
            env.expandToInclude(this.coordinates[i]);
        }
        return env;
    }

    public String toString() {
        if (this.coordinates.length > 0) {
            StringBuilder strBuilder = new StringBuilder(17 * this.coordinates.length);
            strBuilder.append('(');
            strBuilder.append(this.coordinates[0]);
            for (int i = 1; i < this.coordinates.length; ++i) {
                strBuilder.append(", ");
                strBuilder.append(this.coordinates[i]);
            }
            strBuilder.append(')');
            return strBuilder.toString();
        }
        return "()";
    }
}

