//                                               -*- C++ -*-
/**
 *  @brief YACSPhysicalModel implements models defined by an xml file
 *
 *  Copyright 2015-2025 EDF-Phimeca
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
#ifndef PERSALYS_YACSPHYSICALMODEL_HXX
#define PERSALYS_YACSPHYSICALMODEL_HXX

#include "persalys/PythonPhysicalModel.hxx"
#include "persalys/YACSEvaluation.hxx"

namespace PERSALYS
{
class PERSALYS_BASE_API YACSPhysicalModel : public PythonPhysicalModel
{
  CLASSNAME

public:
  /* Default constructor */
  YACSPhysicalModel(const OT::String & name = "Unnamed");

  /* Constructor with parameters */
  YACSPhysicalModel(const OT::String & name,
                    const InputCollection & inputs,
                    const OutputCollection & outputs,
                    const OT::String & code);

  /** Virtual constructor */
  YACSPhysicalModel * clone() const override;

  void setInputs(const InputCollection & inputs);
  void addInput(const Input & input);
  void removeInput(const OT::String & inputName);

  void setOutputs(const OutputCollection & outputs);
  void addOutput(const Output & output);
  void removeOutput(const OT::String & outputName);

  /** Accessor to the code */
  void setCode(const OT::String & code) override;

  /** Use YACS backend or Python backend */
  void setUseYACS(const OT::Bool useYACS);
  OT::Bool getUseYACS() const;

  /** Accesor to launching resource properties */
  ydefx::JobParametersProxy& jobParameters();
  const ydefx::JobParametersProxy& jobParameters() const;

  OT::String getPythonScript() const override;

  /** Method save() stores the object through the StorageManager */
  void save(OT::Advocate & adv) const override;

  /** Method load() reloads the object from the StorageManager */
  void load(OT::Advocate & adv) override;

  /** String converter */
  OT::String __repr__() const override;

  bool canBeDetached() const override;

protected:
  OT::Function generateFunction(const OT::Description & outputNames) const override;
  virtual OT::String getJobParamsPythonScript() const;

private:
  mutable YACSEvaluation evaluation_;
  OT::Bool useYACS_ = false;
};
}
#endif
