# getDirectoryToWatchFailedLookupLocation

Determines whether to watch given failed lookup location (file that didnt exist) when resolving module.
It also determines the directory to watch and whether to watch it recursively or not.

## Testing for Dos root: c:/

## RootDirForResolution: c:/

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | true      |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir                                                                                         | true      |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot                                                                                | true      |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | true      |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | true      |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir                                                                          | true      |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot                                                                 | true      |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | true      |
| c:/user/dir/somefile.d.ts                                                                      | c:/user                                                                                        | true      |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user                                                                                        | true      |
| c:/user/username/somefile.d.ts                                                                 | c:/user                                                                                        | true      |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user                                                                                        | true      |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user                                                                                        | true      |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | true      |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr                                                                                         | true      |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr                                                                                         | true      |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr                                                                                         | true      |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr                                                                                         | true      |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr                                                                                         | true      |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | true      |
| c:/home/dir/somefile.d.ts                                                                      | c:/home                                                                                        | true      |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home                                                                                        | true      |
| c:/home/username/somefile.d.ts                                                                 | c:/home                                                                                        | true      |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home                                                                                        | true      |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home                                                                                        | true      |

## RootDirForResolution: c:/folderAtRoot

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | true      |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir                                                                                         | true      |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | true      |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir                                                                            | true      |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | true      |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1                                                                        | true      |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1                                                                        | true      |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1                                                                        | true      |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1                                                                        | true      |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1                                                                        | true      |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1                                                                        | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1                                                                        | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1                                                                        | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1                                                                        | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1                                                                        | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1                                                                        | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1                                                                        | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1                                                                        | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1                                                                        | true      |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | true      |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | true      |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir                                                                          | true      |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot                                                                 | true      |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | true      |
| c:/user/dir/somefile.d.ts                                                                      | c:/user                                                                                        | true      |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user                                                                                        | true      |
| c:/user/username/somefile.d.ts                                                                 | c:/user                                                                                        | true      |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user                                                                                        | true      |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user                                                                                        | true      |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | true      |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr                                                                                         | true      |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr                                                                                         | true      |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr                                                                                         | true      |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr                                                                                         | true      |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr                                                                                         | true      |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | true      |
| c:/home/dir/somefile.d.ts                                                                      | c:/home                                                                                        | true      |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home                                                                                        | true      |
| c:/home/username/somefile.d.ts                                                                 | c:/home                                                                                        | true      |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home                                                                                        | true      |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home                                                                                        | true      |

## RootDirForResolution: c:/folderAtRoot/folder1

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | true      |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir                                                                                         | true      |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | true      |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir                                                                            | true      |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | true      |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir                                                                    | true      |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2                                                                | true      |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | true      |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | true      |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir                                                                          | true      |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot                                                                 | true      |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | true      |
| c:/user/dir/somefile.d.ts                                                                      | c:/user                                                                                        | true      |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user                                                                                        | true      |
| c:/user/username/somefile.d.ts                                                                 | c:/user                                                                                        | true      |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user                                                                                        | true      |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user                                                                                        | true      |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | true      |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr                                                                                         | true      |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr                                                                                         | true      |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr                                                                                         | true      |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr                                                                                         | true      |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr                                                                                         | true      |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | true      |
| c:/home/dir/somefile.d.ts                                                                      | c:/home                                                                                        | true      |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home                                                                                        | true      |
| c:/home/username/somefile.d.ts                                                                 | c:/home                                                                                        | true      |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home                                                                                        | true      |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home                                                                                        | true      |

## RootDirForResolution: c:/folderAtRoot/folder1/folder2

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | true      |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir                                                                                         | true      |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | true      |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir                                                                            | true      |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | true      |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir                                                                    | true      |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | true      |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir                                                            | true      |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3                                                        | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3                                                        | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3                                                        | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3                                                        | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3                                                        | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3                                                        | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3                                                        | true      |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | true      |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | true      |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir                                                                          | true      |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot                                                                 | true      |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | true      |
| c:/user/dir/somefile.d.ts                                                                      | c:/user                                                                                        | true      |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user                                                                                        | true      |
| c:/user/username/somefile.d.ts                                                                 | c:/user                                                                                        | true      |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user                                                                                        | true      |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user                                                                                        | true      |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | true      |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr                                                                                         | true      |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr                                                                                         | true      |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr                                                                                         | true      |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr                                                                                         | true      |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr                                                                                         | true      |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | true      |
| c:/home/dir/somefile.d.ts                                                                      | c:/home                                                                                        | true      |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home                                                                                        | true      |
| c:/home/username/somefile.d.ts                                                                 | c:/home                                                                                        | true      |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home                                                                                        | true      |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home                                                                                        | true      |

## RootDirForResolution: c:/folderAtRoot/folder1/folder2/folder3

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | true      |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir                                                                                         | true      |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | true      |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir                                                                            | true      |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | true      |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir                                                                    | true      |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | true      |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir                                                            | true      |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | false     |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | true      |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | true      |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | true      |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir                                                                          | true      |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot                                                                 | true      |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | true      |
| c:/user/dir/somefile.d.ts                                                                      | c:/user                                                                                        | true      |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user                                                                                        | true      |
| c:/user/username/somefile.d.ts                                                                 | c:/user                                                                                        | true      |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user                                                                                        | true      |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user                                                                                        | true      |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | true      |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr                                                                                         | true      |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr                                                                                         | true      |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr                                                                                         | true      |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr                                                                                         | true      |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr                                                                                         | true      |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | true      |
| c:/home/dir/somefile.d.ts                                                                      | c:/home                                                                                        | true      |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home                                                                                        | true      |
| c:/home/username/somefile.d.ts                                                                 | c:/home                                                                                        | true      |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home                                                                                        | true      |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home                                                                                        | true      |

## RootDirForResolution: c:/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | true      |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir                                                                                         | true      |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | true      |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir                                                                            | true      |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | true      |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir                                                                    | true      |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | true      |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir                                                            | true      |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | false     |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | true      |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | true      |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | true      |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir                                                                          | true      |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot                                                                 | true      |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | true      |
| c:/user/dir/somefile.d.ts                                                                      | c:/user                                                                                        | true      |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user                                                                                        | true      |
| c:/user/username/somefile.d.ts                                                                 | c:/user                                                                                        | true      |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user                                                                                        | true      |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user                                                                                        | true      |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | true      |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr                                                                                         | true      |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr                                                                                         | true      |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr                                                                                         | true      |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr                                                                                         | true      |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr                                                                                         | true      |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | true      |
| c:/home/dir/somefile.d.ts                                                                      | c:/home                                                                                        | true      |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home                                                                                        | true      |
| c:/home/username/somefile.d.ts                                                                 | c:/home                                                                                        | true      |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home                                                                                        | true      |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home                                                                                        | true      |

## RootDirForResolution: c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | true      |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir                                                                                         | true      |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | true      |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir                                                                            | true      |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | true      |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir                                                                    | true      |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | true      |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir                                                            | true      |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | false     |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | true      |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | true      |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | true      |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir                                                                          | true      |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot                                                                 | true      |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | true      |
| c:/user/dir/somefile.d.ts                                                                      | c:/user                                                                                        | true      |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user                                                                                        | true      |
| c:/user/username/somefile.d.ts                                                                 | c:/user                                                                                        | true      |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user                                                                                        | true      |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user                                                                                        | true      |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | true      |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr                                                                                         | true      |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr                                                                                         | true      |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr                                                                                         | true      |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr                                                                                         | true      |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr                                                                                         | true      |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | true      |
| c:/home/dir/somefile.d.ts                                                                      | c:/home                                                                                        | true      |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home                                                                                        | true      |
| c:/home/username/somefile.d.ts                                                                 | c:/home                                                                                        | true      |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home                                                                                        | true      |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home                                                                                        | true      |

## RootDirForResolution: c:/users

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | true      |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir                                                                                         | true      |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot                                                                                | true      |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | true      |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | true      |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir                                                                          | true      |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot                                                                 | true      |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | true      |
| c:/user/dir/somefile.d.ts                                                                      | c:/user                                                                                        | true      |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user                                                                                        | true      |
| c:/user/username/somefile.d.ts                                                                 | c:/user                                                                                        | true      |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user                                                                                        | true      |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user                                                                                        | true      |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | true      |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr                                                                                         | true      |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr                                                                                         | true      |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr                                                                                         | true      |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr                                                                                         | true      |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr                                                                                         | true      |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | true      |
| c:/home/dir/somefile.d.ts                                                                      | c:/home                                                                                        | true      |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home                                                                                        | true      |
| c:/home/username/somefile.d.ts                                                                 | c:/home                                                                                        | true      |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home                                                                                        | true      |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home                                                                                        | true      |

## RootDirForResolution: c:/users/username

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | true      |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir                                                                                         | true      |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot                                                                                | true      |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | true      |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | true      |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir                                                                          | true      |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot                                                                 | true      |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | true      |
| c:/user/dir/somefile.d.ts                                                                      | c:/user                                                                                        | true      |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user                                                                                        | true      |
| c:/user/username/somefile.d.ts                                                                 | c:/user                                                                                        | true      |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user                                                                                        | true      |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user                                                                                        | true      |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | true      |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr                                                                                         | true      |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr                                                                                         | true      |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr                                                                                         | true      |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr                                                                                         | true      |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr                                                                                         | true      |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | true      |
| c:/home/dir/somefile.d.ts                                                                      | c:/home                                                                                        | true      |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home                                                                                        | true      |
| c:/home/username/somefile.d.ts                                                                 | c:/home                                                                                        | true      |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home                                                                                        | true      |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home                                                                                        | true      |

## RootDirForResolution: c:/users/username/folderAtRoot

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | true      |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir                                                                                         | true      |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot                                                                                | true      |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | true      |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | true      |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir                                                                          | true      |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | true      |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir                                                             | true      |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | true      |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1                                                         | true      |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1                                                         | true      |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1                                                         | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1                                                         | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1                                                         | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1                                                         | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1                                                         | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1                                                         | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1                                                         | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1                                                         | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1                                                         | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1                                                         | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1                                                         | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1                                                         | true      |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | true      |
| c:/user/dir/somefile.d.ts                                                                      | c:/user                                                                                        | true      |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user                                                                                        | true      |
| c:/user/username/somefile.d.ts                                                                 | c:/user                                                                                        | true      |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user                                                                                        | true      |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user                                                                                        | true      |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | true      |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr                                                                                         | true      |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr                                                                                         | true      |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr                                                                                         | true      |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr                                                                                         | true      |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr                                                                                         | true      |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | true      |
| c:/home/dir/somefile.d.ts                                                                      | c:/home                                                                                        | true      |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home                                                                                        | true      |
| c:/home/username/somefile.d.ts                                                                 | c:/home                                                                                        | true      |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home                                                                                        | true      |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home                                                                                        | true      |

## RootDirForResolution: c:/users/username/folderAtRoot/folder1

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | true      |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir                                                                                         | true      |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot                                                                                | true      |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | true      |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | true      |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir                                                                          | true      |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | true      |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir                                                             | true      |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | true      |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir                                                     | true      |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2                                                 | true      |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | true      |
| c:/user/dir/somefile.d.ts                                                                      | c:/user                                                                                        | true      |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user                                                                                        | true      |
| c:/user/username/somefile.d.ts                                                                 | c:/user                                                                                        | true      |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user                                                                                        | true      |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user                                                                                        | true      |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | true      |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr                                                                                         | true      |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr                                                                                         | true      |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr                                                                                         | true      |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr                                                                                         | true      |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr                                                                                         | true      |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | true      |
| c:/home/dir/somefile.d.ts                                                                      | c:/home                                                                                        | true      |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home                                                                                        | true      |
| c:/home/username/somefile.d.ts                                                                 | c:/home                                                                                        | true      |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home                                                                                        | true      |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home                                                                                        | true      |

## RootDirForResolution: c:/users/username/folderAtRoot/folder1/folder2

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | true      |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir                                                                                         | true      |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot                                                                                | true      |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | true      |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | true      |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir                                                                          | true      |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | true      |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir                                                             | true      |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | true      |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir                                                     | true      |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | true      |
| c:/user/dir/somefile.d.ts                                                                      | c:/user                                                                                        | true      |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user                                                                                        | true      |
| c:/user/username/somefile.d.ts                                                                 | c:/user                                                                                        | true      |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user                                                                                        | true      |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user                                                                                        | true      |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | true      |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr                                                                                         | true      |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr                                                                                         | true      |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr                                                                                         | true      |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr                                                                                         | true      |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr                                                                                         | true      |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | true      |
| c:/home/dir/somefile.d.ts                                                                      | c:/home                                                                                        | true      |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home                                                                                        | true      |
| c:/home/username/somefile.d.ts                                                                 | c:/home                                                                                        | true      |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home                                                                                        | true      |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home                                                                                        | true      |

## RootDirForResolution: c:/users/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | true      |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir                                                                                         | true      |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot                                                                                | true      |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | true      |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | true      |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir                                                                          | true      |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | true      |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir                                                             | true      |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | true      |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir                                                     | true      |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | true      |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | true      |
| c:/user/dir/somefile.d.ts                                                                      | c:/user                                                                                        | true      |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user                                                                                        | true      |
| c:/user/username/somefile.d.ts                                                                 | c:/user                                                                                        | true      |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user                                                                                        | true      |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user                                                                                        | true      |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | true      |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr                                                                                         | true      |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr                                                                                         | true      |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr                                                                                         | true      |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr                                                                                         | true      |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr                                                                                         | true      |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | true      |
| c:/home/dir/somefile.d.ts                                                                      | c:/home                                                                                        | true      |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home                                                                                        | true      |
| c:/home/username/somefile.d.ts                                                                 | c:/home                                                                                        | true      |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home                                                                                        | true      |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home                                                                                        | true      |

## RootDirForResolution: c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | true      |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir                                                                                         | true      |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot                                                                                | true      |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | true      |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | true      |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir                                                                          | true      |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | true      |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir                                                             | true      |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | true      |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir                                                     | true      |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | true      |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | true      |
| c:/user/dir/somefile.d.ts                                                                      | c:/user                                                                                        | true      |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user                                                                                        | true      |
| c:/user/username/somefile.d.ts                                                                 | c:/user                                                                                        | true      |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user                                                                                        | true      |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user                                                                                        | true      |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | true      |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr                                                                                         | true      |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr                                                                                         | true      |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr                                                                                         | true      |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr                                                                                         | true      |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr                                                                                         | true      |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | true      |
| c:/home/dir/somefile.d.ts                                                                      | c:/home                                                                                        | true      |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home                                                                                        | true      |
| c:/home/username/somefile.d.ts                                                                 | c:/home                                                                                        | true      |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home                                                                                        | true      |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home                                                                                        | true      |

## RootDirForResolution: c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | true      |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir                                                                                         | true      |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot                                                                                | true      |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | true      |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | true      |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir                                                                          | true      |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | true      |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir                                                             | true      |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | true      |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir                                                     | true      |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | true      |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | true      |
| c:/user/dir/somefile.d.ts                                                                      | c:/user                                                                                        | true      |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user                                                                                        | true      |
| c:/user/username/somefile.d.ts                                                                 | c:/user                                                                                        | true      |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user                                                                                        | true      |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user                                                                                        | true      |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | true      |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr                                                                                         | true      |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr                                                                                         | true      |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr                                                                                         | true      |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr                                                                                         | true      |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr                                                                                         | true      |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | true      |
| c:/home/dir/somefile.d.ts                                                                      | c:/home                                                                                        | true      |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home                                                                                        | true      |
| c:/home/username/somefile.d.ts                                                                 | c:/home                                                                                        | true      |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home                                                                                        | true      |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home                                                                                        | true      |

## RootDirForResolution: c:/user

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | true      |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir                                                                                         | true      |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot                                                                                | true      |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | true      |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | true      |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir                                                                          | true      |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot                                                                 | true      |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | true      |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir                                                                                    | true      |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | true      |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username                                                                               | true      |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username                                                                               | true      |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username                                                                               | true      |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username                                                                               | true      |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username                                                                               | true      |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username                                                                               | true      |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username                                                                               | true      |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username                                                                               | true      |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username                                                                               | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username                                                                               | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username                                                                               | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username                                                                               | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username                                                                               | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username                                                                               | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username                                                                               | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username                                                                               | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username                                                                               | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username                                                                               | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username                                                                               | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username                                                                               | true      |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | true      |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr                                                                                         | true      |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr                                                                                         | true      |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr                                                                                         | true      |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr                                                                                         | true      |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr                                                                                         | true      |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | true      |
| c:/home/dir/somefile.d.ts                                                                      | c:/home                                                                                        | true      |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home                                                                                        | true      |
| c:/home/username/somefile.d.ts                                                                 | c:/home                                                                                        | true      |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home                                                                                        | true      |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home                                                                                        | true      |

## RootDirForResolution: c:/user/username

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | true      |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir                                                                                         | true      |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot                                                                                | true      |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | true      |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | true      |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir                                                                          | true      |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot                                                                 | true      |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | true      |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir                                                                                    | true      |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | true      |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir                                                                           | true      |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | true      |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot                                                                  | true      |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot                                                                  | true      |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot                                                                  | true      |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot                                                                  | true      |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot                                                                  | true      |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot                                                                  | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot                                                                  | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot                                                                  | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot                                                                  | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot                                                                  | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot                                                                  | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot                                                                  | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot                                                                  | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot                                                                  | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot                                                                  | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot                                                                  | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot                                                                  | true      |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | true      |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr                                                                                         | true      |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr                                                                                         | true      |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr                                                                                         | true      |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr                                                                                         | true      |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr                                                                                         | true      |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | true      |
| c:/home/dir/somefile.d.ts                                                                      | c:/home                                                                                        | true      |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home                                                                                        | true      |
| c:/home/username/somefile.d.ts                                                                 | c:/home                                                                                        | true      |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home                                                                                        | true      |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home                                                                                        | true      |

## RootDirForResolution: c:/user/username/folderAtRoot

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | true      |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir                                                                                         | true      |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot                                                                                | true      |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | true      |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | true      |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir                                                                          | true      |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot                                                                 | true      |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | true      |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir                                                                                    | true      |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | true      |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir                                                                           | true      |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | true      |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir                                                              | true      |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | true      |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1                                                          | true      |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1                                                          | true      |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1                                                          | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1                                                          | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1                                                          | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1                                                          | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1                                                          | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1                                                          | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1                                                          | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1                                                          | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1                                                          | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1                                                          | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1                                                          | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1                                                          | true      |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | true      |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr                                                                                         | true      |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr                                                                                         | true      |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr                                                                                         | true      |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr                                                                                         | true      |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr                                                                                         | true      |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | true      |
| c:/home/dir/somefile.d.ts                                                                      | c:/home                                                                                        | true      |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home                                                                                        | true      |
| c:/home/username/somefile.d.ts                                                                 | c:/home                                                                                        | true      |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home                                                                                        | true      |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home                                                                                        | true      |

## RootDirForResolution: c:/user/username/folderAtRoot/folder1

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | true      |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir                                                                                         | true      |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot                                                                                | true      |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | true      |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | true      |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir                                                                          | true      |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot                                                                 | true      |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | true      |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir                                                                                    | true      |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | true      |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir                                                                           | true      |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | true      |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir                                                              | true      |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | true      |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir                                                      | true      |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2                                                  | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2                                                  | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2                                                  | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2                                                  | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2                                                  | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2                                                  | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2                                                  | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2                                                  | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2                                                  | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2                                                  | true      |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | true      |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr                                                                                         | true      |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr                                                                                         | true      |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr                                                                                         | true      |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr                                                                                         | true      |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr                                                                                         | true      |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | true      |
| c:/home/dir/somefile.d.ts                                                                      | c:/home                                                                                        | true      |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home                                                                                        | true      |
| c:/home/username/somefile.d.ts                                                                 | c:/home                                                                                        | true      |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home                                                                                        | true      |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home                                                                                        | true      |

## RootDirForResolution: c:/user/username/folderAtRoot/folder1/folder2

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | true      |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir                                                                                         | true      |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot                                                                                | true      |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | true      |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | true      |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir                                                                          | true      |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot                                                                 | true      |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | true      |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir                                                                                    | true      |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | true      |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir                                                                           | true      |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | true      |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir                                                              | true      |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | true      |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir                                                      | true      |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | false     |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | true      |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr                                                                                         | true      |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr                                                                                         | true      |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr                                                                                         | true      |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr                                                                                         | true      |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr                                                                                         | true      |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | true      |
| c:/home/dir/somefile.d.ts                                                                      | c:/home                                                                                        | true      |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home                                                                                        | true      |
| c:/home/username/somefile.d.ts                                                                 | c:/home                                                                                        | true      |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home                                                                                        | true      |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home                                                                                        | true      |

## RootDirForResolution: c:/user/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | true      |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir                                                                                         | true      |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot                                                                                | true      |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | true      |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | true      |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir                                                                          | true      |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot                                                                 | true      |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | true      |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir                                                                                    | true      |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | true      |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir                                                                           | true      |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | true      |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir                                                              | true      |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | true      |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir                                                      | true      |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | false     |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | true      |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr                                                                                         | true      |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr                                                                                         | true      |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr                                                                                         | true      |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr                                                                                         | true      |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr                                                                                         | true      |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | true      |
| c:/home/dir/somefile.d.ts                                                                      | c:/home                                                                                        | true      |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home                                                                                        | true      |
| c:/home/username/somefile.d.ts                                                                 | c:/home                                                                                        | true      |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home                                                                                        | true      |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home                                                                                        | true      |

## RootDirForResolution: c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | true      |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir                                                                                         | true      |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot                                                                                | true      |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | true      |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | true      |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir                                                                          | true      |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot                                                                 | true      |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | true      |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir                                                                                    | true      |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | true      |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir                                                                           | true      |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | true      |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir                                                              | true      |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | true      |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir                                                      | true      |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | false     |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | true      |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | true      |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr                                                                                         | true      |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr                                                                                         | true      |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr                                                                                         | true      |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr                                                                                         | true      |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr                                                                                         | true      |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | true      |
| c:/home/dir/somefile.d.ts                                                                      | c:/home                                                                                        | true      |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home                                                                                        | true      |
| c:/home/username/somefile.d.ts                                                                 | c:/home                                                                                        | true      |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home                                                                                        | true      |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home                                                                                        | true      |

## RootDirForResolution: c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | true      |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir                                                                                         | true      |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot                                                                                | true      |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | true      |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | true      |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir                                                                          | true      |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot                                                                 | true      |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | true      |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir                                                                                    | true      |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | true      |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir                                                                           | true      |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | true      |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir                                                              | true      |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | true      |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir                                                      | true      |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | false     |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | true      |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | true      |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr                                                                                         | true      |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr                                                                                         | true      |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr                                                                                         | true      |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr                                                                                         | true      |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr                                                                                         | true      |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | true      |
| c:/home/dir/somefile.d.ts                                                                      | c:/home                                                                                        | true      |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home                                                                                        | true      |
| c:/home/username/somefile.d.ts                                                                 | c:/home                                                                                        | true      |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home                                                                                        | true      |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home                                                                                        | true      |

## RootDirForResolution: c:/usr

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | true      |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir                                                                                         | true      |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot                                                                                | true      |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | true      |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | true      |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir                                                                          | true      |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot                                                                 | true      |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | true      |
| c:/user/dir/somefile.d.ts                                                                      | c:/user                                                                                        | true      |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user                                                                                        | true      |
| c:/user/username/somefile.d.ts                                                                 | c:/user                                                                                        | true      |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user                                                                                        | true      |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user                                                                                        | true      |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | true      |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir                                                                                     | true      |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | true      |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username                                                                                | true      |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username                                                                                | true      |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username                                                                                | true      |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username                                                                                | true      |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username                                                                                | true      |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username                                                                                | true      |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username                                                                                | true      |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username                                                                                | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username                                                                                | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username                                                                                | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username                                                                                | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username                                                                                | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username                                                                                | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username                                                                                | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username                                                                                | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username                                                                                | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username                                                                                | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username                                                                                | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username                                                                                | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username                                                                                | true      |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | true      |
| c:/home/dir/somefile.d.ts                                                                      | c:/home                                                                                        | true      |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home                                                                                        | true      |
| c:/home/username/somefile.d.ts                                                                 | c:/home                                                                                        | true      |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home                                                                                        | true      |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home                                                                                        | true      |

## RootDirForResolution: c:/usr/username

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | true      |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir                                                                                         | true      |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot                                                                                | true      |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | true      |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | true      |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir                                                                          | true      |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot                                                                 | true      |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | true      |
| c:/user/dir/somefile.d.ts                                                                      | c:/user                                                                                        | true      |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user                                                                                        | true      |
| c:/user/username/somefile.d.ts                                                                 | c:/user                                                                                        | true      |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user                                                                                        | true      |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user                                                                                        | true      |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | true      |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir                                                                                     | true      |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | true      |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir                                                                            | true      |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | true      |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot                                                                   | true      |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot                                                                   | true      |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot                                                                   | true      |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot                                                                   | true      |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot                                                                   | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot                                                                   | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot                                                                   | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot                                                                   | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot                                                                   | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot                                                                   | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot                                                                   | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot                                                                   | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot                                                                   | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot                                                                   | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot                                                                   | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot                                                                   | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot                                                                   | true      |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | true      |
| c:/home/dir/somefile.d.ts                                                                      | c:/home                                                                                        | true      |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home                                                                                        | true      |
| c:/home/username/somefile.d.ts                                                                 | c:/home                                                                                        | true      |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home                                                                                        | true      |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home                                                                                        | true      |

## RootDirForResolution: c:/usr/username/folderAtRoot

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | true      |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir                                                                                         | true      |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot                                                                                | true      |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | true      |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | true      |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir                                                                          | true      |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot                                                                 | true      |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | true      |
| c:/user/dir/somefile.d.ts                                                                      | c:/user                                                                                        | true      |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user                                                                                        | true      |
| c:/user/username/somefile.d.ts                                                                 | c:/user                                                                                        | true      |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user                                                                                        | true      |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user                                                                                        | true      |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | true      |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir                                                                                     | true      |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | true      |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir                                                                            | true      |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | true      |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir                                                               | true      |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | true      |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1                                                           | true      |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1                                                           | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1                                                           | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1                                                           | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1                                                           | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1                                                           | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1                                                           | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1                                                           | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1                                                           | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1                                                           | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1                                                           | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1                                                           | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1                                                           | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1                                                           | true      |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | true      |
| c:/home/dir/somefile.d.ts                                                                      | c:/home                                                                                        | true      |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home                                                                                        | true      |
| c:/home/username/somefile.d.ts                                                                 | c:/home                                                                                        | true      |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home                                                                                        | true      |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home                                                                                        | true      |

## RootDirForResolution: c:/usr/username/folderAtRoot/folder1

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | true      |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir                                                                                         | true      |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot                                                                                | true      |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | true      |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | true      |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir                                                                          | true      |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot                                                                 | true      |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | true      |
| c:/user/dir/somefile.d.ts                                                                      | c:/user                                                                                        | true      |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user                                                                                        | true      |
| c:/user/username/somefile.d.ts                                                                 | c:/user                                                                                        | true      |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user                                                                                        | true      |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user                                                                                        | true      |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | true      |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir                                                                                     | true      |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | true      |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir                                                                            | true      |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | true      |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir                                                               | true      |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | true      |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir                                                       | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | true      |
| c:/home/dir/somefile.d.ts                                                                      | c:/home                                                                                        | true      |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home                                                                                        | true      |
| c:/home/username/somefile.d.ts                                                                 | c:/home                                                                                        | true      |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home                                                                                        | true      |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home                                                                                        | true      |

## RootDirForResolution: c:/usr/username/folderAtRoot/folder1/folder2

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | true      |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir                                                                                         | true      |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot                                                                                | true      |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | true      |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | true      |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir                                                                          | true      |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot                                                                 | true      |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | true      |
| c:/user/dir/somefile.d.ts                                                                      | c:/user                                                                                        | true      |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user                                                                                        | true      |
| c:/user/username/somefile.d.ts                                                                 | c:/user                                                                                        | true      |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user                                                                                        | true      |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user                                                                                        | true      |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | true      |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir                                                                                     | true      |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | true      |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir                                                                            | true      |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | true      |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir                                                               | true      |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | true      |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir                                                       | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | false     |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | true      |
| c:/home/dir/somefile.d.ts                                                                      | c:/home                                                                                        | true      |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home                                                                                        | true      |
| c:/home/username/somefile.d.ts                                                                 | c:/home                                                                                        | true      |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home                                                                                        | true      |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home                                                                                        | true      |

## RootDirForResolution: c:/usr/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | true      |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir                                                                                         | true      |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot                                                                                | true      |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | true      |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | true      |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir                                                                          | true      |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot                                                                 | true      |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | true      |
| c:/user/dir/somefile.d.ts                                                                      | c:/user                                                                                        | true      |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user                                                                                        | true      |
| c:/user/username/somefile.d.ts                                                                 | c:/user                                                                                        | true      |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user                                                                                        | true      |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user                                                                                        | true      |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | true      |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir                                                                                     | true      |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | true      |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir                                                                            | true      |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | true      |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir                                                               | true      |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | true      |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir                                                       | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | false     |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | true      |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | true      |
| c:/home/dir/somefile.d.ts                                                                      | c:/home                                                                                        | true      |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home                                                                                        | true      |
| c:/home/username/somefile.d.ts                                                                 | c:/home                                                                                        | true      |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home                                                                                        | true      |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home                                                                                        | true      |

## RootDirForResolution: c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | true      |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir                                                                                         | true      |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot                                                                                | true      |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | true      |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | true      |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir                                                                          | true      |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot                                                                 | true      |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | true      |
| c:/user/dir/somefile.d.ts                                                                      | c:/user                                                                                        | true      |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user                                                                                        | true      |
| c:/user/username/somefile.d.ts                                                                 | c:/user                                                                                        | true      |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user                                                                                        | true      |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user                                                                                        | true      |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | true      |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir                                                                                     | true      |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | true      |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir                                                                            | true      |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | true      |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir                                                               | true      |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | true      |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir                                                       | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | false     |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | true      |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | true      |
| c:/home/dir/somefile.d.ts                                                                      | c:/home                                                                                        | true      |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home                                                                                        | true      |
| c:/home/username/somefile.d.ts                                                                 | c:/home                                                                                        | true      |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home                                                                                        | true      |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home                                                                                        | true      |

## RootDirForResolution: c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | true      |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir                                                                                         | true      |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot                                                                                | true      |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | true      |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | true      |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir                                                                          | true      |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot                                                                 | true      |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | true      |
| c:/user/dir/somefile.d.ts                                                                      | c:/user                                                                                        | true      |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user                                                                                        | true      |
| c:/user/username/somefile.d.ts                                                                 | c:/user                                                                                        | true      |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user                                                                                        | true      |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user                                                                                        | true      |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | true      |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir                                                                                     | true      |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | true      |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir                                                                            | true      |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | true      |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir                                                               | true      |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | true      |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir                                                       | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | false     |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | true      |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | true      |
| c:/home/dir/somefile.d.ts                                                                      | c:/home                                                                                        | true      |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home                                                                                        | true      |
| c:/home/username/somefile.d.ts                                                                 | c:/home                                                                                        | true      |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home                                                                                        | true      |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home                                                                                        | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home                                                                                        | true      |

## RootDirForResolution: c:/home

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | true      |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir                                                                                         | true      |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot                                                                                | true      |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | true      |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | true      |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir                                                                          | true      |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot                                                                 | true      |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | true      |
| c:/user/dir/somefile.d.ts                                                                      | c:/user                                                                                        | true      |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user                                                                                        | true      |
| c:/user/username/somefile.d.ts                                                                 | c:/user                                                                                        | true      |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user                                                                                        | true      |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user                                                                                        | true      |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | true      |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr                                                                                         | true      |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr                                                                                         | true      |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr                                                                                         | true      |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr                                                                                         | true      |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr                                                                                         | true      |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | true      |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir                                                                                    | true      |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | true      |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username                                                                               | true      |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username                                                                               | true      |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username                                                                               | true      |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username                                                                               | true      |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username                                                                               | true      |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username                                                                               | true      |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username                                                                               | true      |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username                                                                               | true      |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username                                                                               | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username                                                                               | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username                                                                               | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username                                                                               | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username                                                                               | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username                                                                               | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username                                                                               | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username                                                                               | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username                                                                               | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username                                                                               | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username                                                                               | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username                                                                               | true      |

## RootDirForResolution: c:/home/username

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | true      |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir                                                                                         | true      |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot                                                                                | true      |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | true      |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | true      |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir                                                                          | true      |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot                                                                 | true      |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | true      |
| c:/user/dir/somefile.d.ts                                                                      | c:/user                                                                                        | true      |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user                                                                                        | true      |
| c:/user/username/somefile.d.ts                                                                 | c:/user                                                                                        | true      |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user                                                                                        | true      |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user                                                                                        | true      |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | true      |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr                                                                                         | true      |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr                                                                                         | true      |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr                                                                                         | true      |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr                                                                                         | true      |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr                                                                                         | true      |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | true      |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir                                                                                    | true      |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | true      |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir                                                                           | true      |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | true      |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot                                                                  | true      |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot                                                                  | true      |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot                                                                  | true      |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot                                                                  | true      |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot                                                                  | true      |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot                                                                  | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot                                                                  | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot                                                                  | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot                                                                  | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot                                                                  | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot                                                                  | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot                                                                  | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot                                                                  | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot                                                                  | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot                                                                  | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot                                                                  | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: c:/home/username/folderAtRoot

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | true      |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir                                                                                         | true      |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot                                                                                | true      |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | true      |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | true      |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir                                                                          | true      |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot                                                                 | true      |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | true      |
| c:/user/dir/somefile.d.ts                                                                      | c:/user                                                                                        | true      |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user                                                                                        | true      |
| c:/user/username/somefile.d.ts                                                                 | c:/user                                                                                        | true      |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user                                                                                        | true      |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user                                                                                        | true      |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | true      |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr                                                                                         | true      |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr                                                                                         | true      |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr                                                                                         | true      |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr                                                                                         | true      |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr                                                                                         | true      |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | true      |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir                                                                                    | true      |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | true      |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir                                                                           | true      |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | true      |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir                                                              | true      |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | true      |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1                                                          | true      |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1                                                          | true      |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1                                                          | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1                                                          | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1                                                          | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1                                                          | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1                                                          | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1                                                          | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1                                                          | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1                                                          | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1                                                          | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1                                                          | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1                                                          | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1                                                          | true      |

## RootDirForResolution: c:/home/username/folderAtRoot/folder1

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | true      |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir                                                                                         | true      |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot                                                                                | true      |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | true      |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | true      |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir                                                                          | true      |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot                                                                 | true      |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | true      |
| c:/user/dir/somefile.d.ts                                                                      | c:/user                                                                                        | true      |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user                                                                                        | true      |
| c:/user/username/somefile.d.ts                                                                 | c:/user                                                                                        | true      |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user                                                                                        | true      |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user                                                                                        | true      |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | true      |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr                                                                                         | true      |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr                                                                                         | true      |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr                                                                                         | true      |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr                                                                                         | true      |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr                                                                                         | true      |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | true      |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir                                                                                    | true      |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | true      |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir                                                                           | true      |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | true      |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir                                                              | true      |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | true      |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir                                                      | true      |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2                                                  | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2                                                  | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2                                                  | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2                                                  | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2                                                  | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2                                                  | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2                                                  | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2                                                  | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2                                                  | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2                                                  | true      |

## RootDirForResolution: c:/home/username/folderAtRoot/folder1/folder2

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | true      |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir                                                                                         | true      |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot                                                                                | true      |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | true      |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | true      |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir                                                                          | true      |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot                                                                 | true      |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | true      |
| c:/user/dir/somefile.d.ts                                                                      | c:/user                                                                                        | true      |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user                                                                                        | true      |
| c:/user/username/somefile.d.ts                                                                 | c:/user                                                                                        | true      |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user                                                                                        | true      |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user                                                                                        | true      |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | true      |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr                                                                                         | true      |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr                                                                                         | true      |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr                                                                                         | true      |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr                                                                                         | true      |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr                                                                                         | true      |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | true      |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir                                                                                    | true      |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | true      |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir                                                                           | true      |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | true      |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir                                                              | true      |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | true      |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir                                                      | true      |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | false     |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |

## RootDirForResolution: c:/home/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | true      |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir                                                                                         | true      |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot                                                                                | true      |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | true      |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | true      |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir                                                                          | true      |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot                                                                 | true      |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | true      |
| c:/user/dir/somefile.d.ts                                                                      | c:/user                                                                                        | true      |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user                                                                                        | true      |
| c:/user/username/somefile.d.ts                                                                 | c:/user                                                                                        | true      |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user                                                                                        | true      |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user                                                                                        | true      |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | true      |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr                                                                                         | true      |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr                                                                                         | true      |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr                                                                                         | true      |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr                                                                                         | true      |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr                                                                                         | true      |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | true      |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir                                                                                    | true      |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | true      |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir                                                                           | true      |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | true      |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir                                                              | true      |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | true      |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir                                                      | true      |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | false     |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |

## RootDirForResolution: c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | true      |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir                                                                                         | true      |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot                                                                                | true      |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | true      |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | true      |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir                                                                          | true      |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot                                                                 | true      |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | true      |
| c:/user/dir/somefile.d.ts                                                                      | c:/user                                                                                        | true      |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user                                                                                        | true      |
| c:/user/username/somefile.d.ts                                                                 | c:/user                                                                                        | true      |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user                                                                                        | true      |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user                                                                                        | true      |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | true      |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr                                                                                         | true      |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr                                                                                         | true      |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr                                                                                         | true      |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr                                                                                         | true      |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr                                                                                         | true      |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | true      |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir                                                                                    | true      |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | true      |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir                                                                           | true      |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | true      |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir                                                              | true      |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | true      |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir                                                      | true      |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | false     |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | true      |

## RootDirForResolution: c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | true      |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir                                                                                         | true      |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot                                                                                | true      |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot                                                                                | true      |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | true      |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | true      |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir                                                                          | true      |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot                                                                 | true      |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot                                                                 | true      |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | true      |
| c:/user/dir/somefile.d.ts                                                                      | c:/user                                                                                        | true      |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user                                                                                        | true      |
| c:/user/username/somefile.d.ts                                                                 | c:/user                                                                                        | true      |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user                                                                                        | true      |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user                                                                                        | true      |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user                                                                                        | true      |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | true      |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr                                                                                         | true      |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr                                                                                         | true      |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr                                                                                         | true      |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr                                                                                         | true      |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr                                                                                         | true      |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr                                                                                         | true      |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | true      |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir                                                                                    | true      |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | true      |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir                                                                           | true      |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | true      |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir                                                              | true      |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | true      |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir                                                      | true      |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | false     |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | true      |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | true      |

