/*
 * (C) Copyright 2005- ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 *
 * In applying this licence, ECMWF does not waive the privileges and immunities granted to it by
 * virtue of its status as an intergovernmental organisation nor does it submit to any jurisdiction.
 */

#include <stdlib.h>

#include "grib_api_internal.h"

/*
 * Start off with an input GRIB which already has a bitmap (which we do not change)
 * We submit the array of values in two ways:
 *  1. mode=all_values    with missing values inside the array
 *  2. mode=coded_values  with just the actual data values (codedValues)
 */

static double values[] = {
    9999, 9999, 9999, 9999, 9999, 9999, 9999, 9999,
    9999, 9999, 9999, 9999, 9999, 9999, 9999, 9999,
    9999, 9999, 9999, 9999, 9999, 9999, 9999, 9999,
    9999, 9999, 9999, 9999, 9999, 9999, 9999, 9999,
    9999, 9999, 9999, 9999, 9999, 9999, 9999, 9999,
    9999, 9999, 9999, 9999, 9999, 9999, 9999, 9999,
    9999, 9999, 9999, 9999, 9999, 9999, 9999, 9999,
    9999, 9999, 9999, 9999, 9999, 9999, 9999, 347.000,
    351.17, 9999, 398.379, 360.11, 303.789, 333.813, 438.348, 9999,
    9999, 9999, 9999, 9999, 9999, 9999, 9999, 362.845,
    368.95, 349.704, 315.92, 317.444, 317.978, 312.899, 318.694, 336.607,
    328.225, 318.768, 9999, 9999, 327.48, 320.84, 9999, 9999,
    9999, 321.583, 9999, 9999, 316.595, 283.959, 9999, 9999,
    376.427, 422.802, 9999, 9999, 9999, 317.575, 9999, 9999,
    321.28, 322.032, 313.917, 354.487, 377.874, 374.873, 357.047, 339.551,
    321.89, 334.938, 320.97, 312.124, 9999, 9999, 9999, 9999,
    328.066, 379.077, 379.42, 313.396, 295.383, 319.849, 329.087, 9999,
    9999, 313.36, 9999, 9999, 9999, 9999, 9999, 9999,
    9999, 316.487, 314.708, 298.099, 314.588, 303.332, 248.011, 248.16,
    225.102, 234.641, 260.818, 308.531, 254.778, 278.966, 298.521, 9999,
    9999, 9999, 9999, 9999, 9999, 9999, 9999, 9999,
    317.767, 248.105, 283.188, 309.06, 316.791, 310.885, 9999, 9999,
    9999, 9999, 9999, 9999, 234.968, 9999, 369.517, 284.271,
    295.506, 9999, 196.032, 266.051, 179.829, 175.861, 179.113, 222.216,
    9999, 9999, 316.956, 9999, 9999, 9999, 9999, 9999,
    9999, 9999, 9999, 9999, 230.518, 250.07, 257.074, 309.024,
    318.292, 9999, 9999, 9999, 9999, 9999, 9999, 9999,
    146.209, 174.842, 179.125, 174.578, 183.333, 9999, 205.684, 229.178,
    252.941, 303.273, 307.823, 308.202, 301.054, 9999, 9999, 9999,
    9999, 9999, 9999, 9999, 9999, 9999, 9999, 9999,
    9999, 224.55, 232.05, 332.034, 9999, 9999, 9999, 9999,
    9999, 9999, 9999, 9999, 141.568, 102.806, 87.8625, 71.4856,
    9999, 46.1716, 9999, 9999, 203.383, 9999, 243.203, 239.621,
    9999, 9999, 9999, 9999, 9999, 9999, 9999, 9999,
    9999, 9999, 9999, 9999, 9999, 9999, 179.452, 306.222,
    9999, 9999, 9999, 9999, 9999, 9999, 9999, 43.1087,
    173.86, 178.752, 175.271, 172.237, 179.22, 178.687, 9999, 9999,
    9999, 9999, 9999, 9999, 9999, 9999, 9999, 9999,
    9999, 9999, 9999, 9999, 9999, 9999, 9999, 9999,
    9999, 9999, 9999, 9999, 9999, 177.747, 9999, 9999,
    9999, 9999, 9999, 215.105, 9999, 332.742, 308.695, 180.615,
    225.048, 9999, 9999, 9999, 9999, 9999, 338.102, 362.331,
    9999, 9999, 9999, 9999, 9999, 9999, 9999, 9999,
    9999, 9999, 9999, 9999, 9999, 9999, 9999, 9999,
    273.877, 345.801, 277.475, 9999, 9999, 9999, 9999, 9999,
    9999, 9999, 343.533, 337.801, 9999, 9999, 9999, 9999,
    9999, 9999, 9999, 9999, 285.976, 9999, 9999, 9999,
    9999, 9999, 9999, 9999, 9999, 9999, 9999, 9999,
    9999, 9999, 9999, 9999, 9999, 346.895, 333.021, 321.413,
    181.505, 9999, 9999, 9999, 9999, 9999, 196.798, 219.053,
    9999, 9999, 9999, 9999, 9999, 9999, 9999, 9999,
    9999, 236.096, 261.686, 9999, 9999, 9999, 9999, 9999,
    9999, 9999, 9999, 9999, 9999, 9999, 9999, 9999,
    9999, 177.465, 316.937, 358.09, 9999, 9999, 9999, 9999,
    9999, 9999, 179.764, 260.835, 9999, 9999, 9999, 9999,
    9999, 9999, 9999, 9999, 181.972, 174.103, 187.28, 185.947,
    9999, 9999, 9999, 9999, 9999, 9999, 9999, 9999,
    9999, 9999, 9999, 9999, 9999, 203.272, 365.295, 9999,
    9999, 9999, 9999, 9999, 9999, 9999, 9999, 9999,
    9999, 9999, 9999, 9999, 9999, 9999, 9999, 9999,
    9999, 9999, 9999, 9999, 9999, 9999, 9999, 9999,
    9999, 9999, 9999, 9999, 9999, 9999, 9999, 9999,
    9999, 176.828, 9999, 9999, 9999, 9999, 9999, 9999,
    9999, 9999, 9999, 9999, 9999, 9999, 9999, 9999,
    9999, 9999, 9999, 9999, 9999, 9999, 9999, 9999,
    9999, 9999, 9999, 9999, 9999, 9999, 9999, 9999,
    9999, 9999, 9999, 9999, 9999, 243.018, 9999, 9999,
    9999, 9999, 9999, 9999, 9999, 9999, 9999, 9999,
    9999, 9999, 9999, 9999, 9999, 9999, 9999, 9999,
    9999, 9999, 9999, 9999, 9999, 9999, 9999, 9999,
    9999, 9999, 9999, 9999, 9999, 9999, 9999, 9999,
    9999, 9999, 9999, 9999, 9999, 9999, 9999, 9999,
    411.872, 9999, 9999, 397.008, 312.154, 254.919, 254.473, 285.172,
    261.048, 254.308, 254.469, 255.24, 258.573, 255.994, 255.777, 319.439,
    422.381, 9999, 9999, 9999, 9999, 9999, 9999, 9999,
    9999, 9999, 9999, 9999, 9999, 426.446, 9999, 9999,
    9999, 9999, 9999, 9999, 253.435, 252.098, 251.536, 251.114,
    251.086, 251.077, 251.097, 251.08, 251.076, 251.076, 251.081, 251.089,
    251.141, 251.381, 252.472, 254.423, 194.798, 80.7719, 88.9881, 98.7602,
    131.036, 267.54, 291.101, 284.22, 264.468, 264.991, 257.708, 255.982,
    215.189, 187.116, 220.893, 317.637, 126.554, 233.276, 267.542, 255.658,
    251.495, 251.495, 251.495, 251.495, 251.495, 251.495, 251.495, 251.495,
    251.495, 251.495, 251.495, 251.495, 251.495, 251.495, 251.495, 251.495,
    251.495, 251.495, 251.495, 251.495, 251.495, 251.495, 251.495, 251.495,
    251.495, 251.495, 251.495, 251.495, 251.495, 251.495, 251.495, 251.495,
    251.495, 251.495, 251.495, 251.495
};

static double codedValues[] = {
    347.000, 351.17, 398.379, 360.11, 303.789, 333.813, 438.348, 362.845,
    368.95, 349.704, 315.92, 317.444, 317.978, 312.899, 318.694, 336.607,
    328.225, 318.768, 327.48, 320.84, 321.583, 316.595, 283.959, 376.427,
    422.802, 317.575, 321.28, 322.032, 313.917, 354.487, 377.874, 374.873,
    357.047, 339.551, 321.89, 334.938, 320.97, 312.124, 328.066, 379.077,
    379.42, 313.396, 295.383, 319.849, 329.087, 313.36, 316.487, 314.708,
    298.099, 314.588, 303.332, 248.011, 248.16, 225.102, 234.641, 260.818,
    308.531, 254.778, 278.966, 298.521, 317.767, 248.105, 283.188, 309.06,
    316.791, 310.885, 234.968, 369.517, 284.271, 295.506, 196.032, 266.051,
    179.829, 175.861, 179.113, 222.216, 316.956, 230.518, 250.07, 257.074,
    309.024, 318.292, 146.209, 174.842, 179.125, 174.578, 183.333, 205.684,
    229.178, 252.941, 303.273, 307.823, 308.202, 301.054, 224.55, 232.05,
    332.034, 141.568, 102.806, 87.8625, 71.4856, 46.1716, 203.383, 243.203,
    239.621, 179.452, 306.222, 43.1087, 173.86, 178.752, 175.271, 172.237,
    179.22, 178.687, 177.747, 215.105, 332.742, 308.695, 180.615, 225.048,
    338.102, 362.331, 273.877, 345.801, 277.475, 343.533, 337.801, 285.976,
    346.895, 333.021, 321.413, 181.505, 196.798, 219.053, 236.096, 261.686,
    177.465, 316.937, 358.09, 179.764, 260.835, 181.972, 174.103, 187.28,
    185.947, 203.272, 365.295, 176.828, 243.018, 411.872, 397.008, 312.154,
    254.919, 254.473, 285.172, 261.048, 254.308, 254.469, 255.24, 258.573,
    255.994, 255.777, 319.439, 422.381, 426.446, 253.435, 252.098, 251.536,
    251.114, 251.086, 251.077, 251.097, 251.08, 251.076, 251.076, 251.081,
    251.089, 251.141, 251.381, 252.472, 254.423, 194.798, 80.7719, 88.9881,
    98.7602, 131.036, 267.54, 291.101, 284.22, 264.468, 264.991, 257.708,
    255.982, 215.189, 187.116, 220.893, 317.637, 126.554, 233.276, 267.542,
    255.658, 251.495, 251.495, 251.495, 251.495, 251.495, 251.495, 251.495,
    251.495, 251.495, 251.495, 251.495, 251.495, 251.495, 251.495, 251.495,
    251.495, 251.495, 251.495, 251.495, 251.495, 251.495, 251.495, 251.495,
    251.495, 251.495, 251.495, 251.495, 251.495, 251.495, 251.495, 251.495,
    251.495, 251.495, 251.495, 251.495, 251.495
};

int main(int argc, char** argv)
{
    int err             = 0;
    size_t size         = 0;
    const char* infile  = NULL;
    const char* outfile = NULL;
    FILE* in            = NULL;
    FILE* out           = NULL;
    grib_handle* h      = NULL;
    const void* buffer  = NULL;
    const char* mode    = NULL;

    ECCODES_ASSERT(argc == 4);

    mode    = argv[1]; /*all_values or coded_values*/
    infile  = argv[2];
    outfile = argv[3];

    in = fopen(infile, "rb");
    ECCODES_ASSERT(in);
    out = fopen(outfile, "wb");
    ECCODES_ASSERT(out);

    while ((h = grib_handle_new_from_file(NULL, in, &err)) != NULL || err != GRIB_SUCCESS) {
        long numberOfDataPoints = 0;
        GRIB_CHECK(grib_get_long(h, "numberOfDataPoints", &numberOfDataPoints), 0);

        if (strcmp(mode, "all_values") == 0) {
            double missing            = 9999;
            const size_t num_all_vals = sizeof(values) / sizeof(values[0]);

            ECCODES_ASSERT(num_all_vals == numberOfDataPoints); /*Sanity check*/
            GRIB_CHECK(grib_set_long(h, "bitmapPresent", 1), 0);
            GRIB_CHECK(grib_set_double(h, "missingValue", missing), 0);
            printf("Fully specified: %zu values\n", num_all_vals);
            GRIB_CHECK(grib_set_double_array(h, "values", values, num_all_vals), 0);
        }
        else {
            const size_t num_coded_vals = sizeof(codedValues) / sizeof(codedValues[0]);
            ECCODES_ASSERT(strcmp(mode, "coded_values") == 0);
            ECCODES_ASSERT(num_coded_vals < (size_t)numberOfDataPoints); /*Sanity check*/
            printf("Partially specified: %zu values\n", num_coded_vals);
            GRIB_CHECK(grib_set_force_double_array(h, "codedValues", codedValues, num_coded_vals), 0);
        }

        /* Write out the new GRIB */
        GRIB_CHECK(grib_get_message(h, &buffer, &size), 0);
        if (fwrite(buffer, 1, size, out) != size) {
            perror(outfile);
            exit(1);
        }
        grib_handle_delete(h);
    }
    printf("Wrote %s\n", outfile);
    fclose(in);
    fclose(out);

    return 0;
}
